// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/firestore/admin/v1/firestore_admin.proto

package adminpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	FirestoreAdmin_CreateIndex_FullMethodName          = "/google.firestore.admin.v1.FirestoreAdmin/CreateIndex"
	FirestoreAdmin_ListIndexes_FullMethodName          = "/google.firestore.admin.v1.FirestoreAdmin/ListIndexes"
	FirestoreAdmin_GetIndex_FullMethodName             = "/google.firestore.admin.v1.FirestoreAdmin/GetIndex"
	FirestoreAdmin_DeleteIndex_FullMethodName          = "/google.firestore.admin.v1.FirestoreAdmin/DeleteIndex"
	FirestoreAdmin_GetField_FullMethodName             = "/google.firestore.admin.v1.FirestoreAdmin/GetField"
	FirestoreAdmin_UpdateField_FullMethodName          = "/google.firestore.admin.v1.FirestoreAdmin/UpdateField"
	FirestoreAdmin_ListFields_FullMethodName           = "/google.firestore.admin.v1.FirestoreAdmin/ListFields"
	FirestoreAdmin_ExportDocuments_FullMethodName      = "/google.firestore.admin.v1.FirestoreAdmin/ExportDocuments"
	FirestoreAdmin_ImportDocuments_FullMethodName      = "/google.firestore.admin.v1.FirestoreAdmin/ImportDocuments"
	FirestoreAdmin_BulkDeleteDocuments_FullMethodName  = "/google.firestore.admin.v1.FirestoreAdmin/BulkDeleteDocuments"
	FirestoreAdmin_CreateDatabase_FullMethodName       = "/google.firestore.admin.v1.FirestoreAdmin/CreateDatabase"
	FirestoreAdmin_GetDatabase_FullMethodName          = "/google.firestore.admin.v1.FirestoreAdmin/GetDatabase"
	FirestoreAdmin_ListDatabases_FullMethodName        = "/google.firestore.admin.v1.FirestoreAdmin/ListDatabases"
	FirestoreAdmin_UpdateDatabase_FullMethodName       = "/google.firestore.admin.v1.FirestoreAdmin/UpdateDatabase"
	FirestoreAdmin_DeleteDatabase_FullMethodName       = "/google.firestore.admin.v1.FirestoreAdmin/DeleteDatabase"
	FirestoreAdmin_CreateUserCreds_FullMethodName      = "/google.firestore.admin.v1.FirestoreAdmin/CreateUserCreds"
	FirestoreAdmin_GetUserCreds_FullMethodName         = "/google.firestore.admin.v1.FirestoreAdmin/GetUserCreds"
	FirestoreAdmin_ListUserCreds_FullMethodName        = "/google.firestore.admin.v1.FirestoreAdmin/ListUserCreds"
	FirestoreAdmin_EnableUserCreds_FullMethodName      = "/google.firestore.admin.v1.FirestoreAdmin/EnableUserCreds"
	FirestoreAdmin_DisableUserCreds_FullMethodName     = "/google.firestore.admin.v1.FirestoreAdmin/DisableUserCreds"
	FirestoreAdmin_ResetUserPassword_FullMethodName    = "/google.firestore.admin.v1.FirestoreAdmin/ResetUserPassword"
	FirestoreAdmin_DeleteUserCreds_FullMethodName      = "/google.firestore.admin.v1.FirestoreAdmin/DeleteUserCreds"
	FirestoreAdmin_GetBackup_FullMethodName            = "/google.firestore.admin.v1.FirestoreAdmin/GetBackup"
	FirestoreAdmin_ListBackups_FullMethodName          = "/google.firestore.admin.v1.FirestoreAdmin/ListBackups"
	FirestoreAdmin_DeleteBackup_FullMethodName         = "/google.firestore.admin.v1.FirestoreAdmin/DeleteBackup"
	FirestoreAdmin_RestoreDatabase_FullMethodName      = "/google.firestore.admin.v1.FirestoreAdmin/RestoreDatabase"
	FirestoreAdmin_CreateBackupSchedule_FullMethodName = "/google.firestore.admin.v1.FirestoreAdmin/CreateBackupSchedule"
	FirestoreAdmin_GetBackupSchedule_FullMethodName    = "/google.firestore.admin.v1.FirestoreAdmin/GetBackupSchedule"
	FirestoreAdmin_ListBackupSchedules_FullMethodName  = "/google.firestore.admin.v1.FirestoreAdmin/ListBackupSchedules"
	FirestoreAdmin_UpdateBackupSchedule_FullMethodName = "/google.firestore.admin.v1.FirestoreAdmin/UpdateBackupSchedule"
	FirestoreAdmin_DeleteBackupSchedule_FullMethodName = "/google.firestore.admin.v1.FirestoreAdmin/DeleteBackupSchedule"
	FirestoreAdmin_CloneDatabase_FullMethodName        = "/google.firestore.admin.v1.FirestoreAdmin/CloneDatabase"
)

// FirestoreAdminClient is the client API for FirestoreAdmin service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type FirestoreAdminClient interface {
	// Creates a composite index. This returns a
	// [google.longrunning.Operation][google.longrunning.Operation] which may be
	// used to track the status of the creation. The metadata for the operation
	// will be the type
	// [IndexOperationMetadata][google.firestore.admin.v1.IndexOperationMetadata].
	CreateIndex(ctx context.Context, in *CreateIndexRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists composite indexes.
	ListIndexes(ctx context.Context, in *ListIndexesRequest, opts ...grpc.CallOption) (*ListIndexesResponse, error)
	// Gets a composite index.
	GetIndex(ctx context.Context, in *GetIndexRequest, opts ...grpc.CallOption) (*Index, error)
	// Deletes a composite index.
	DeleteIndex(ctx context.Context, in *DeleteIndexRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets the metadata and configuration for a Field.
	GetField(ctx context.Context, in *GetFieldRequest, opts ...grpc.CallOption) (*Field, error)
	// Updates a field configuration. Currently, field updates apply only to
	// single field index configuration. However, calls to
	// [FirestoreAdmin.UpdateField][google.firestore.admin.v1.FirestoreAdmin.UpdateField]
	// should provide a field mask to avoid changing any configuration that the
	// caller isn't aware of. The field mask should be specified as: `{ paths:
	// "index_config" }`.
	//
	// This call returns a
	// [google.longrunning.Operation][google.longrunning.Operation] which may be
	// used to track the status of the field update. The metadata for the
	// operation will be the type
	// [FieldOperationMetadata][google.firestore.admin.v1.FieldOperationMetadata].
	//
	// To configure the default field settings for the database, use
	// the special `Field` with resource name:
	// `projects/{project_id}/databases/{database_id}/collectionGroups/__default__/fields/*`.
	UpdateField(ctx context.Context, in *UpdateFieldRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the field configuration and metadata for this database.
	//
	// Currently,
	// [FirestoreAdmin.ListFields][google.firestore.admin.v1.FirestoreAdmin.ListFields]
	// only supports listing fields that have been explicitly overridden. To issue
	// this query, call
	// [FirestoreAdmin.ListFields][google.firestore.admin.v1.FirestoreAdmin.ListFields]
	// with the filter set to `indexConfig.usesAncestorConfig:false` or
	// `ttlConfig:*`.
	ListFields(ctx context.Context, in *ListFieldsRequest, opts ...grpc.CallOption) (*ListFieldsResponse, error)
	// Exports a copy of all or a subset of documents from Google Cloud Firestore
	// to another storage system, such as Google Cloud Storage. Recent updates to
	// documents may not be reflected in the export. The export occurs in the
	// background and its progress can be monitored and managed via the
	// Operation resource that is created. The output of an export may only be
	// used once the associated operation is done. If an export operation is
	// cancelled before completion it may leave partial data behind in Google
	// Cloud Storage.
	//
	// For more details on export behavior and output format, refer to:
	// https://cloud.google.com/firestore/docs/manage-data/export-import
	ExportDocuments(ctx context.Context, in *ExportDocumentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Imports documents into Google Cloud Firestore. Existing documents with the
	// same name are overwritten. The import occurs in the background and its
	// progress can be monitored and managed via the Operation resource that is
	// created. If an ImportDocuments operation is cancelled, it is possible
	// that a subset of the data has already been imported to Cloud Firestore.
	ImportDocuments(ctx context.Context, in *ImportDocumentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Bulk deletes a subset of documents from Google Cloud Firestore.
	// Documents created or updated after the underlying system starts to process
	// the request will not be deleted. The bulk delete occurs in the background
	// and its progress can be monitored and managed via the Operation resource
	// that is created.
	//
	// For more details on bulk delete behavior, refer to:
	// https://cloud.google.com/firestore/docs/manage-data/bulk-delete
	BulkDeleteDocuments(ctx context.Context, in *BulkDeleteDocumentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Create a database.
	CreateDatabase(ctx context.Context, in *CreateDatabaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets information about a database.
	GetDatabase(ctx context.Context, in *GetDatabaseRequest, opts ...grpc.CallOption) (*Database, error)
	// List all the databases in the project.
	ListDatabases(ctx context.Context, in *ListDatabasesRequest, opts ...grpc.CallOption) (*ListDatabasesResponse, error)
	// Updates a database.
	UpdateDatabase(ctx context.Context, in *UpdateDatabaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a database.
	DeleteDatabase(ctx context.Context, in *DeleteDatabaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Create a user creds.
	CreateUserCreds(ctx context.Context, in *CreateUserCredsRequest, opts ...grpc.CallOption) (*UserCreds, error)
	// Gets a user creds resource. Note that the returned resource does not
	// contain the secret value itself.
	GetUserCreds(ctx context.Context, in *GetUserCredsRequest, opts ...grpc.CallOption) (*UserCreds, error)
	// List all user creds in the database. Note that the returned resource
	// does not contain the secret value itself.
	ListUserCreds(ctx context.Context, in *ListUserCredsRequest, opts ...grpc.CallOption) (*ListUserCredsResponse, error)
	// Enables a user creds. No-op if the user creds are already enabled.
	EnableUserCreds(ctx context.Context, in *EnableUserCredsRequest, opts ...grpc.CallOption) (*UserCreds, error)
	// Disables a user creds. No-op if the user creds are already disabled.
	DisableUserCreds(ctx context.Context, in *DisableUserCredsRequest, opts ...grpc.CallOption) (*UserCreds, error)
	// Resets the password of a user creds.
	ResetUserPassword(ctx context.Context, in *ResetUserPasswordRequest, opts ...grpc.CallOption) (*UserCreds, error)
	// Deletes a user creds.
	DeleteUserCreds(ctx context.Context, in *DeleteUserCredsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets information about a backup.
	GetBackup(ctx context.Context, in *GetBackupRequest, opts ...grpc.CallOption) (*Backup, error)
	// Lists all the backups.
	ListBackups(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*ListBackupsResponse, error)
	// Deletes a backup.
	DeleteBackup(ctx context.Context, in *DeleteBackupRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a new database by restoring from an existing backup.
	//
	// The new database must be in the same cloud region or multi-region location
	// as the existing backup. This behaves similar to
	// [FirestoreAdmin.CreateDatabase][google.firestore.admin.v1.FirestoreAdmin.CreateDatabase]
	// except instead of creating a new empty database, a new database is created
	// with the database type, index configuration, and documents from an existing
	// backup.
	//
	// The [long-running operation][google.longrunning.Operation] can be used to
	// track the progress of the restore, with the Operation's
	// [metadata][google.longrunning.Operation.metadata] field type being the
	// [RestoreDatabaseMetadata][google.firestore.admin.v1.RestoreDatabaseMetadata].
	// The [response][google.longrunning.Operation.response] type is the
	// [Database][google.firestore.admin.v1.Database] if the restore was
	// successful. The new database is not readable or writeable until the LRO has
	// completed.
	RestoreDatabase(ctx context.Context, in *RestoreDatabaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a backup schedule on a database.
	// At most two backup schedules can be configured on a database, one daily
	// backup schedule and one weekly backup schedule.
	CreateBackupSchedule(ctx context.Context, in *CreateBackupScheduleRequest, opts ...grpc.CallOption) (*BackupSchedule, error)
	// Gets information about a backup schedule.
	GetBackupSchedule(ctx context.Context, in *GetBackupScheduleRequest, opts ...grpc.CallOption) (*BackupSchedule, error)
	// List backup schedules.
	ListBackupSchedules(ctx context.Context, in *ListBackupSchedulesRequest, opts ...grpc.CallOption) (*ListBackupSchedulesResponse, error)
	// Updates a backup schedule.
	UpdateBackupSchedule(ctx context.Context, in *UpdateBackupScheduleRequest, opts ...grpc.CallOption) (*BackupSchedule, error)
	// Deletes a backup schedule.
	DeleteBackupSchedule(ctx context.Context, in *DeleteBackupScheduleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a new database by cloning an existing one.
	//
	// The new database must be in the same cloud region or multi-region location
	// as the existing database. This behaves similar to
	// [FirestoreAdmin.CreateDatabase][google.firestore.admin.v1.FirestoreAdmin.CreateDatabase]
	// except instead of creating a new empty database, a new database is created
	// with the database type, index configuration, and documents from an existing
	// database.
	//
	// The [long-running operation][google.longrunning.Operation] can be used to
	// track the progress of the clone, with the Operation's
	// [metadata][google.longrunning.Operation.metadata] field type being the
	// [CloneDatabaseMetadata][google.firestore.admin.v1.CloneDatabaseMetadata].
	// The [response][google.longrunning.Operation.response] type is the
	// [Database][google.firestore.admin.v1.Database] if the clone was
	// successful. The new database is not readable or writeable until the LRO has
	// completed.
	CloneDatabase(ctx context.Context, in *CloneDatabaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type firestoreAdminClient struct {
	cc grpc.ClientConnInterface
}

func NewFirestoreAdminClient(cc grpc.ClientConnInterface) FirestoreAdminClient {
	return &firestoreAdminClient{cc}
}

func (c *firestoreAdminClient) CreateIndex(ctx context.Context, in *CreateIndexRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FirestoreAdmin_CreateIndex_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) ListIndexes(ctx context.Context, in *ListIndexesRequest, opts ...grpc.CallOption) (*ListIndexesResponse, error) {
	out := new(ListIndexesResponse)
	err := c.cc.Invoke(ctx, FirestoreAdmin_ListIndexes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) GetIndex(ctx context.Context, in *GetIndexRequest, opts ...grpc.CallOption) (*Index, error) {
	out := new(Index)
	err := c.cc.Invoke(ctx, FirestoreAdmin_GetIndex_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) DeleteIndex(ctx context.Context, in *DeleteIndexRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, FirestoreAdmin_DeleteIndex_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) GetField(ctx context.Context, in *GetFieldRequest, opts ...grpc.CallOption) (*Field, error) {
	out := new(Field)
	err := c.cc.Invoke(ctx, FirestoreAdmin_GetField_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) UpdateField(ctx context.Context, in *UpdateFieldRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FirestoreAdmin_UpdateField_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) ListFields(ctx context.Context, in *ListFieldsRequest, opts ...grpc.CallOption) (*ListFieldsResponse, error) {
	out := new(ListFieldsResponse)
	err := c.cc.Invoke(ctx, FirestoreAdmin_ListFields_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) ExportDocuments(ctx context.Context, in *ExportDocumentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FirestoreAdmin_ExportDocuments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) ImportDocuments(ctx context.Context, in *ImportDocumentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FirestoreAdmin_ImportDocuments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) BulkDeleteDocuments(ctx context.Context, in *BulkDeleteDocumentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FirestoreAdmin_BulkDeleteDocuments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) CreateDatabase(ctx context.Context, in *CreateDatabaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FirestoreAdmin_CreateDatabase_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) GetDatabase(ctx context.Context, in *GetDatabaseRequest, opts ...grpc.CallOption) (*Database, error) {
	out := new(Database)
	err := c.cc.Invoke(ctx, FirestoreAdmin_GetDatabase_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) ListDatabases(ctx context.Context, in *ListDatabasesRequest, opts ...grpc.CallOption) (*ListDatabasesResponse, error) {
	out := new(ListDatabasesResponse)
	err := c.cc.Invoke(ctx, FirestoreAdmin_ListDatabases_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) UpdateDatabase(ctx context.Context, in *UpdateDatabaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FirestoreAdmin_UpdateDatabase_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) DeleteDatabase(ctx context.Context, in *DeleteDatabaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FirestoreAdmin_DeleteDatabase_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) CreateUserCreds(ctx context.Context, in *CreateUserCredsRequest, opts ...grpc.CallOption) (*UserCreds, error) {
	out := new(UserCreds)
	err := c.cc.Invoke(ctx, FirestoreAdmin_CreateUserCreds_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) GetUserCreds(ctx context.Context, in *GetUserCredsRequest, opts ...grpc.CallOption) (*UserCreds, error) {
	out := new(UserCreds)
	err := c.cc.Invoke(ctx, FirestoreAdmin_GetUserCreds_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) ListUserCreds(ctx context.Context, in *ListUserCredsRequest, opts ...grpc.CallOption) (*ListUserCredsResponse, error) {
	out := new(ListUserCredsResponse)
	err := c.cc.Invoke(ctx, FirestoreAdmin_ListUserCreds_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) EnableUserCreds(ctx context.Context, in *EnableUserCredsRequest, opts ...grpc.CallOption) (*UserCreds, error) {
	out := new(UserCreds)
	err := c.cc.Invoke(ctx, FirestoreAdmin_EnableUserCreds_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) DisableUserCreds(ctx context.Context, in *DisableUserCredsRequest, opts ...grpc.CallOption) (*UserCreds, error) {
	out := new(UserCreds)
	err := c.cc.Invoke(ctx, FirestoreAdmin_DisableUserCreds_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) ResetUserPassword(ctx context.Context, in *ResetUserPasswordRequest, opts ...grpc.CallOption) (*UserCreds, error) {
	out := new(UserCreds)
	err := c.cc.Invoke(ctx, FirestoreAdmin_ResetUserPassword_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) DeleteUserCreds(ctx context.Context, in *DeleteUserCredsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, FirestoreAdmin_DeleteUserCreds_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) GetBackup(ctx context.Context, in *GetBackupRequest, opts ...grpc.CallOption) (*Backup, error) {
	out := new(Backup)
	err := c.cc.Invoke(ctx, FirestoreAdmin_GetBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) ListBackups(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*ListBackupsResponse, error) {
	out := new(ListBackupsResponse)
	err := c.cc.Invoke(ctx, FirestoreAdmin_ListBackups_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) DeleteBackup(ctx context.Context, in *DeleteBackupRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, FirestoreAdmin_DeleteBackup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) RestoreDatabase(ctx context.Context, in *RestoreDatabaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FirestoreAdmin_RestoreDatabase_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) CreateBackupSchedule(ctx context.Context, in *CreateBackupScheduleRequest, opts ...grpc.CallOption) (*BackupSchedule, error) {
	out := new(BackupSchedule)
	err := c.cc.Invoke(ctx, FirestoreAdmin_CreateBackupSchedule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) GetBackupSchedule(ctx context.Context, in *GetBackupScheduleRequest, opts ...grpc.CallOption) (*BackupSchedule, error) {
	out := new(BackupSchedule)
	err := c.cc.Invoke(ctx, FirestoreAdmin_GetBackupSchedule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) ListBackupSchedules(ctx context.Context, in *ListBackupSchedulesRequest, opts ...grpc.CallOption) (*ListBackupSchedulesResponse, error) {
	out := new(ListBackupSchedulesResponse)
	err := c.cc.Invoke(ctx, FirestoreAdmin_ListBackupSchedules_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) UpdateBackupSchedule(ctx context.Context, in *UpdateBackupScheduleRequest, opts ...grpc.CallOption) (*BackupSchedule, error) {
	out := new(BackupSchedule)
	err := c.cc.Invoke(ctx, FirestoreAdmin_UpdateBackupSchedule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) DeleteBackupSchedule(ctx context.Context, in *DeleteBackupScheduleRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, FirestoreAdmin_DeleteBackupSchedule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) CloneDatabase(ctx context.Context, in *CloneDatabaseRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, FirestoreAdmin_CloneDatabase_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FirestoreAdminServer is the server API for FirestoreAdmin service.
// All implementations should embed UnimplementedFirestoreAdminServer
// for forward compatibility
type FirestoreAdminServer interface {
	// Creates a composite index. This returns a
	// [google.longrunning.Operation][google.longrunning.Operation] which may be
	// used to track the status of the creation. The metadata for the operation
	// will be the type
	// [IndexOperationMetadata][google.firestore.admin.v1.IndexOperationMetadata].
	CreateIndex(context.Context, *CreateIndexRequest) (*longrunningpb.Operation, error)
	// Lists composite indexes.
	ListIndexes(context.Context, *ListIndexesRequest) (*ListIndexesResponse, error)
	// Gets a composite index.
	GetIndex(context.Context, *GetIndexRequest) (*Index, error)
	// Deletes a composite index.
	DeleteIndex(context.Context, *DeleteIndexRequest) (*emptypb.Empty, error)
	// Gets the metadata and configuration for a Field.
	GetField(context.Context, *GetFieldRequest) (*Field, error)
	// Updates a field configuration. Currently, field updates apply only to
	// single field index configuration. However, calls to
	// [FirestoreAdmin.UpdateField][google.firestore.admin.v1.FirestoreAdmin.UpdateField]
	// should provide a field mask to avoid changing any configuration that the
	// caller isn't aware of. The field mask should be specified as: `{ paths:
	// "index_config" }`.
	//
	// This call returns a
	// [google.longrunning.Operation][google.longrunning.Operation] which may be
	// used to track the status of the field update. The metadata for the
	// operation will be the type
	// [FieldOperationMetadata][google.firestore.admin.v1.FieldOperationMetadata].
	//
	// To configure the default field settings for the database, use
	// the special `Field` with resource name:
	// `projects/{project_id}/databases/{database_id}/collectionGroups/__default__/fields/*`.
	UpdateField(context.Context, *UpdateFieldRequest) (*longrunningpb.Operation, error)
	// Lists the field configuration and metadata for this database.
	//
	// Currently,
	// [FirestoreAdmin.ListFields][google.firestore.admin.v1.FirestoreAdmin.ListFields]
	// only supports listing fields that have been explicitly overridden. To issue
	// this query, call
	// [FirestoreAdmin.ListFields][google.firestore.admin.v1.FirestoreAdmin.ListFields]
	// with the filter set to `indexConfig.usesAncestorConfig:false` or
	// `ttlConfig:*`.
	ListFields(context.Context, *ListFieldsRequest) (*ListFieldsResponse, error)
	// Exports a copy of all or a subset of documents from Google Cloud Firestore
	// to another storage system, such as Google Cloud Storage. Recent updates to
	// documents may not be reflected in the export. The export occurs in the
	// background and its progress can be monitored and managed via the
	// Operation resource that is created. The output of an export may only be
	// used once the associated operation is done. If an export operation is
	// cancelled before completion it may leave partial data behind in Google
	// Cloud Storage.
	//
	// For more details on export behavior and output format, refer to:
	// https://cloud.google.com/firestore/docs/manage-data/export-import
	ExportDocuments(context.Context, *ExportDocumentsRequest) (*longrunningpb.Operation, error)
	// Imports documents into Google Cloud Firestore. Existing documents with the
	// same name are overwritten. The import occurs in the background and its
	// progress can be monitored and managed via the Operation resource that is
	// created. If an ImportDocuments operation is cancelled, it is possible
	// that a subset of the data has already been imported to Cloud Firestore.
	ImportDocuments(context.Context, *ImportDocumentsRequest) (*longrunningpb.Operation, error)
	// Bulk deletes a subset of documents from Google Cloud Firestore.
	// Documents created or updated after the underlying system starts to process
	// the request will not be deleted. The bulk delete occurs in the background
	// and its progress can be monitored and managed via the Operation resource
	// that is created.
	//
	// For more details on bulk delete behavior, refer to:
	// https://cloud.google.com/firestore/docs/manage-data/bulk-delete
	BulkDeleteDocuments(context.Context, *BulkDeleteDocumentsRequest) (*longrunningpb.Operation, error)
	// Create a database.
	CreateDatabase(context.Context, *CreateDatabaseRequest) (*longrunningpb.Operation, error)
	// Gets information about a database.
	GetDatabase(context.Context, *GetDatabaseRequest) (*Database, error)
	// List all the databases in the project.
	ListDatabases(context.Context, *ListDatabasesRequest) (*ListDatabasesResponse, error)
	// Updates a database.
	UpdateDatabase(context.Context, *UpdateDatabaseRequest) (*longrunningpb.Operation, error)
	// Deletes a database.
	DeleteDatabase(context.Context, *DeleteDatabaseRequest) (*longrunningpb.Operation, error)
	// Create a user creds.
	CreateUserCreds(context.Context, *CreateUserCredsRequest) (*UserCreds, error)
	// Gets a user creds resource. Note that the returned resource does not
	// contain the secret value itself.
	GetUserCreds(context.Context, *GetUserCredsRequest) (*UserCreds, error)
	// List all user creds in the database. Note that the returned resource
	// does not contain the secret value itself.
	ListUserCreds(context.Context, *ListUserCredsRequest) (*ListUserCredsResponse, error)
	// Enables a user creds. No-op if the user creds are already enabled.
	EnableUserCreds(context.Context, *EnableUserCredsRequest) (*UserCreds, error)
	// Disables a user creds. No-op if the user creds are already disabled.
	DisableUserCreds(context.Context, *DisableUserCredsRequest) (*UserCreds, error)
	// Resets the password of a user creds.
	ResetUserPassword(context.Context, *ResetUserPasswordRequest) (*UserCreds, error)
	// Deletes a user creds.
	DeleteUserCreds(context.Context, *DeleteUserCredsRequest) (*emptypb.Empty, error)
	// Gets information about a backup.
	GetBackup(context.Context, *GetBackupRequest) (*Backup, error)
	// Lists all the backups.
	ListBackups(context.Context, *ListBackupsRequest) (*ListBackupsResponse, error)
	// Deletes a backup.
	DeleteBackup(context.Context, *DeleteBackupRequest) (*emptypb.Empty, error)
	// Creates a new database by restoring from an existing backup.
	//
	// The new database must be in the same cloud region or multi-region location
	// as the existing backup. This behaves similar to
	// [FirestoreAdmin.CreateDatabase][google.firestore.admin.v1.FirestoreAdmin.CreateDatabase]
	// except instead of creating a new empty database, a new database is created
	// with the database type, index configuration, and documents from an existing
	// backup.
	//
	// The [long-running operation][google.longrunning.Operation] can be used to
	// track the progress of the restore, with the Operation's
	// [metadata][google.longrunning.Operation.metadata] field type being the
	// [RestoreDatabaseMetadata][google.firestore.admin.v1.RestoreDatabaseMetadata].
	// The [response][google.longrunning.Operation.response] type is the
	// [Database][google.firestore.admin.v1.Database] if the restore was
	// successful. The new database is not readable or writeable until the LRO has
	// completed.
	RestoreDatabase(context.Context, *RestoreDatabaseRequest) (*longrunningpb.Operation, error)
	// Creates a backup schedule on a database.
	// At most two backup schedules can be configured on a database, one daily
	// backup schedule and one weekly backup schedule.
	CreateBackupSchedule(context.Context, *CreateBackupScheduleRequest) (*BackupSchedule, error)
	// Gets information about a backup schedule.
	GetBackupSchedule(context.Context, *GetBackupScheduleRequest) (*BackupSchedule, error)
	// List backup schedules.
	ListBackupSchedules(context.Context, *ListBackupSchedulesRequest) (*ListBackupSchedulesResponse, error)
	// Updates a backup schedule.
	UpdateBackupSchedule(context.Context, *UpdateBackupScheduleRequest) (*BackupSchedule, error)
	// Deletes a backup schedule.
	DeleteBackupSchedule(context.Context, *DeleteBackupScheduleRequest) (*emptypb.Empty, error)
	// Creates a new database by cloning an existing one.
	//
	// The new database must be in the same cloud region or multi-region location
	// as the existing database. This behaves similar to
	// [FirestoreAdmin.CreateDatabase][google.firestore.admin.v1.FirestoreAdmin.CreateDatabase]
	// except instead of creating a new empty database, a new database is created
	// with the database type, index configuration, and documents from an existing
	// database.
	//
	// The [long-running operation][google.longrunning.Operation] can be used to
	// track the progress of the clone, with the Operation's
	// [metadata][google.longrunning.Operation.metadata] field type being the
	// [CloneDatabaseMetadata][google.firestore.admin.v1.CloneDatabaseMetadata].
	// The [response][google.longrunning.Operation.response] type is the
	// [Database][google.firestore.admin.v1.Database] if the clone was
	// successful. The new database is not readable or writeable until the LRO has
	// completed.
	CloneDatabase(context.Context, *CloneDatabaseRequest) (*longrunningpb.Operation, error)
}

// UnimplementedFirestoreAdminServer should be embedded to have forward compatible implementations.
type UnimplementedFirestoreAdminServer struct {
}

func (UnimplementedFirestoreAdminServer) CreateIndex(context.Context, *CreateIndexRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateIndex not implemented")
}
func (UnimplementedFirestoreAdminServer) ListIndexes(context.Context, *ListIndexesRequest) (*ListIndexesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListIndexes not implemented")
}
func (UnimplementedFirestoreAdminServer) GetIndex(context.Context, *GetIndexRequest) (*Index, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIndex not implemented")
}
func (UnimplementedFirestoreAdminServer) DeleteIndex(context.Context, *DeleteIndexRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteIndex not implemented")
}
func (UnimplementedFirestoreAdminServer) GetField(context.Context, *GetFieldRequest) (*Field, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetField not implemented")
}
func (UnimplementedFirestoreAdminServer) UpdateField(context.Context, *UpdateFieldRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateField not implemented")
}
func (UnimplementedFirestoreAdminServer) ListFields(context.Context, *ListFieldsRequest) (*ListFieldsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFields not implemented")
}
func (UnimplementedFirestoreAdminServer) ExportDocuments(context.Context, *ExportDocumentsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportDocuments not implemented")
}
func (UnimplementedFirestoreAdminServer) ImportDocuments(context.Context, *ImportDocumentsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportDocuments not implemented")
}
func (UnimplementedFirestoreAdminServer) BulkDeleteDocuments(context.Context, *BulkDeleteDocumentsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BulkDeleteDocuments not implemented")
}
func (UnimplementedFirestoreAdminServer) CreateDatabase(context.Context, *CreateDatabaseRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDatabase not implemented")
}
func (UnimplementedFirestoreAdminServer) GetDatabase(context.Context, *GetDatabaseRequest) (*Database, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDatabase not implemented")
}
func (UnimplementedFirestoreAdminServer) ListDatabases(context.Context, *ListDatabasesRequest) (*ListDatabasesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDatabases not implemented")
}
func (UnimplementedFirestoreAdminServer) UpdateDatabase(context.Context, *UpdateDatabaseRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDatabase not implemented")
}
func (UnimplementedFirestoreAdminServer) DeleteDatabase(context.Context, *DeleteDatabaseRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDatabase not implemented")
}
func (UnimplementedFirestoreAdminServer) CreateUserCreds(context.Context, *CreateUserCredsRequest) (*UserCreds, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateUserCreds not implemented")
}
func (UnimplementedFirestoreAdminServer) GetUserCreds(context.Context, *GetUserCredsRequest) (*UserCreds, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetUserCreds not implemented")
}
func (UnimplementedFirestoreAdminServer) ListUserCreds(context.Context, *ListUserCredsRequest) (*ListUserCredsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListUserCreds not implemented")
}
func (UnimplementedFirestoreAdminServer) EnableUserCreds(context.Context, *EnableUserCredsRequest) (*UserCreds, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EnableUserCreds not implemented")
}
func (UnimplementedFirestoreAdminServer) DisableUserCreds(context.Context, *DisableUserCredsRequest) (*UserCreds, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DisableUserCreds not implemented")
}
func (UnimplementedFirestoreAdminServer) ResetUserPassword(context.Context, *ResetUserPasswordRequest) (*UserCreds, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResetUserPassword not implemented")
}
func (UnimplementedFirestoreAdminServer) DeleteUserCreds(context.Context, *DeleteUserCredsRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteUserCreds not implemented")
}
func (UnimplementedFirestoreAdminServer) GetBackup(context.Context, *GetBackupRequest) (*Backup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBackup not implemented")
}
func (UnimplementedFirestoreAdminServer) ListBackups(context.Context, *ListBackupsRequest) (*ListBackupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackups not implemented")
}
func (UnimplementedFirestoreAdminServer) DeleteBackup(context.Context, *DeleteBackupRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBackup not implemented")
}
func (UnimplementedFirestoreAdminServer) RestoreDatabase(context.Context, *RestoreDatabaseRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestoreDatabase not implemented")
}
func (UnimplementedFirestoreAdminServer) CreateBackupSchedule(context.Context, *CreateBackupScheduleRequest) (*BackupSchedule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBackupSchedule not implemented")
}
func (UnimplementedFirestoreAdminServer) GetBackupSchedule(context.Context, *GetBackupScheduleRequest) (*BackupSchedule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBackupSchedule not implemented")
}
func (UnimplementedFirestoreAdminServer) ListBackupSchedules(context.Context, *ListBackupSchedulesRequest) (*ListBackupSchedulesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackupSchedules not implemented")
}
func (UnimplementedFirestoreAdminServer) UpdateBackupSchedule(context.Context, *UpdateBackupScheduleRequest) (*BackupSchedule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBackupSchedule not implemented")
}
func (UnimplementedFirestoreAdminServer) DeleteBackupSchedule(context.Context, *DeleteBackupScheduleRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBackupSchedule not implemented")
}
func (UnimplementedFirestoreAdminServer) CloneDatabase(context.Context, *CloneDatabaseRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CloneDatabase not implemented")
}

// UnsafeFirestoreAdminServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to FirestoreAdminServer will
// result in compilation errors.
type UnsafeFirestoreAdminServer interface {
	mustEmbedUnimplementedFirestoreAdminServer()
}

func RegisterFirestoreAdminServer(s grpc.ServiceRegistrar, srv FirestoreAdminServer) {
	s.RegisterService(&FirestoreAdmin_ServiceDesc, srv)
}

func _FirestoreAdmin_CreateIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).CreateIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_CreateIndex_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).CreateIndex(ctx, req.(*CreateIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_ListIndexes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIndexesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).ListIndexes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_ListIndexes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).ListIndexes(ctx, req.(*ListIndexesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_GetIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).GetIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_GetIndex_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).GetIndex(ctx, req.(*GetIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_DeleteIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).DeleteIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_DeleteIndex_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).DeleteIndex(ctx, req.(*DeleteIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_GetField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).GetField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_GetField_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).GetField(ctx, req.(*GetFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_UpdateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).UpdateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_UpdateField_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).UpdateField(ctx, req.(*UpdateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_ListFields_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFieldsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).ListFields(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_ListFields_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).ListFields(ctx, req.(*ListFieldsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_ExportDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).ExportDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_ExportDocuments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).ExportDocuments(ctx, req.(*ExportDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_ImportDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).ImportDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_ImportDocuments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).ImportDocuments(ctx, req.(*ImportDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_BulkDeleteDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BulkDeleteDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).BulkDeleteDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_BulkDeleteDocuments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).BulkDeleteDocuments(ctx, req.(*BulkDeleteDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_CreateDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).CreateDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_CreateDatabase_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).CreateDatabase(ctx, req.(*CreateDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_GetDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).GetDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_GetDatabase_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).GetDatabase(ctx, req.(*GetDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_ListDatabases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDatabasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).ListDatabases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_ListDatabases_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).ListDatabases(ctx, req.(*ListDatabasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_UpdateDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).UpdateDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_UpdateDatabase_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).UpdateDatabase(ctx, req.(*UpdateDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_DeleteDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).DeleteDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_DeleteDatabase_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).DeleteDatabase(ctx, req.(*DeleteDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_CreateUserCreds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateUserCredsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).CreateUserCreds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_CreateUserCreds_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).CreateUserCreds(ctx, req.(*CreateUserCredsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_GetUserCreds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUserCredsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).GetUserCreds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_GetUserCreds_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).GetUserCreds(ctx, req.(*GetUserCredsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_ListUserCreds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUserCredsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).ListUserCreds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_ListUserCreds_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).ListUserCreds(ctx, req.(*ListUserCredsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_EnableUserCreds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnableUserCredsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).EnableUserCreds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_EnableUserCreds_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).EnableUserCreds(ctx, req.(*EnableUserCredsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_DisableUserCreds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DisableUserCredsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).DisableUserCreds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_DisableUserCreds_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).DisableUserCreds(ctx, req.(*DisableUserCredsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_ResetUserPassword_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetUserPasswordRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).ResetUserPassword(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_ResetUserPassword_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).ResetUserPassword(ctx, req.(*ResetUserPasswordRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_DeleteUserCreds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteUserCredsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).DeleteUserCreds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_DeleteUserCreds_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).DeleteUserCreds(ctx, req.(*DeleteUserCredsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_GetBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).GetBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_GetBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).GetBackup(ctx, req.(*GetBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_ListBackups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).ListBackups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_ListBackups_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).ListBackups(ctx, req.(*ListBackupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_DeleteBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).DeleteBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_DeleteBackup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).DeleteBackup(ctx, req.(*DeleteBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_RestoreDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).RestoreDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_RestoreDatabase_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).RestoreDatabase(ctx, req.(*RestoreDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_CreateBackupSchedule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBackupScheduleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).CreateBackupSchedule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_CreateBackupSchedule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).CreateBackupSchedule(ctx, req.(*CreateBackupScheduleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_GetBackupSchedule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackupScheduleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).GetBackupSchedule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_GetBackupSchedule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).GetBackupSchedule(ctx, req.(*GetBackupScheduleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_ListBackupSchedules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupSchedulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).ListBackupSchedules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_ListBackupSchedules_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).ListBackupSchedules(ctx, req.(*ListBackupSchedulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_UpdateBackupSchedule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBackupScheduleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).UpdateBackupSchedule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_UpdateBackupSchedule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).UpdateBackupSchedule(ctx, req.(*UpdateBackupScheduleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_DeleteBackupSchedule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBackupScheduleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).DeleteBackupSchedule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_DeleteBackupSchedule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).DeleteBackupSchedule(ctx, req.(*DeleteBackupScheduleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_CloneDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CloneDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).CloneDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirestoreAdmin_CloneDatabase_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).CloneDatabase(ctx, req.(*CloneDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// FirestoreAdmin_ServiceDesc is the grpc.ServiceDesc for FirestoreAdmin service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var FirestoreAdmin_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.firestore.admin.v1.FirestoreAdmin",
	HandlerType: (*FirestoreAdminServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateIndex",
			Handler:    _FirestoreAdmin_CreateIndex_Handler,
		},
		{
			MethodName: "ListIndexes",
			Handler:    _FirestoreAdmin_ListIndexes_Handler,
		},
		{
			MethodName: "GetIndex",
			Handler:    _FirestoreAdmin_GetIndex_Handler,
		},
		{
			MethodName: "DeleteIndex",
			Handler:    _FirestoreAdmin_DeleteIndex_Handler,
		},
		{
			MethodName: "GetField",
			Handler:    _FirestoreAdmin_GetField_Handler,
		},
		{
			MethodName: "UpdateField",
			Handler:    _FirestoreAdmin_UpdateField_Handler,
		},
		{
			MethodName: "ListFields",
			Handler:    _FirestoreAdmin_ListFields_Handler,
		},
		{
			MethodName: "ExportDocuments",
			Handler:    _FirestoreAdmin_ExportDocuments_Handler,
		},
		{
			MethodName: "ImportDocuments",
			Handler:    _FirestoreAdmin_ImportDocuments_Handler,
		},
		{
			MethodName: "BulkDeleteDocuments",
			Handler:    _FirestoreAdmin_BulkDeleteDocuments_Handler,
		},
		{
			MethodName: "CreateDatabase",
			Handler:    _FirestoreAdmin_CreateDatabase_Handler,
		},
		{
			MethodName: "GetDatabase",
			Handler:    _FirestoreAdmin_GetDatabase_Handler,
		},
		{
			MethodName: "ListDatabases",
			Handler:    _FirestoreAdmin_ListDatabases_Handler,
		},
		{
			MethodName: "UpdateDatabase",
			Handler:    _FirestoreAdmin_UpdateDatabase_Handler,
		},
		{
			MethodName: "DeleteDatabase",
			Handler:    _FirestoreAdmin_DeleteDatabase_Handler,
		},
		{
			MethodName: "CreateUserCreds",
			Handler:    _FirestoreAdmin_CreateUserCreds_Handler,
		},
		{
			MethodName: "GetUserCreds",
			Handler:    _FirestoreAdmin_GetUserCreds_Handler,
		},
		{
			MethodName: "ListUserCreds",
			Handler:    _FirestoreAdmin_ListUserCreds_Handler,
		},
		{
			MethodName: "EnableUserCreds",
			Handler:    _FirestoreAdmin_EnableUserCreds_Handler,
		},
		{
			MethodName: "DisableUserCreds",
			Handler:    _FirestoreAdmin_DisableUserCreds_Handler,
		},
		{
			MethodName: "ResetUserPassword",
			Handler:    _FirestoreAdmin_ResetUserPassword_Handler,
		},
		{
			MethodName: "DeleteUserCreds",
			Handler:    _FirestoreAdmin_DeleteUserCreds_Handler,
		},
		{
			MethodName: "GetBackup",
			Handler:    _FirestoreAdmin_GetBackup_Handler,
		},
		{
			MethodName: "ListBackups",
			Handler:    _FirestoreAdmin_ListBackups_Handler,
		},
		{
			MethodName: "DeleteBackup",
			Handler:    _FirestoreAdmin_DeleteBackup_Handler,
		},
		{
			MethodName: "RestoreDatabase",
			Handler:    _FirestoreAdmin_RestoreDatabase_Handler,
		},
		{
			MethodName: "CreateBackupSchedule",
			Handler:    _FirestoreAdmin_CreateBackupSchedule_Handler,
		},
		{
			MethodName: "GetBackupSchedule",
			Handler:    _FirestoreAdmin_GetBackupSchedule_Handler,
		},
		{
			MethodName: "ListBackupSchedules",
			Handler:    _FirestoreAdmin_ListBackupSchedules_Handler,
		},
		{
			MethodName: "UpdateBackupSchedule",
			Handler:    _FirestoreAdmin_UpdateBackupSchedule_Handler,
		},
		{
			MethodName: "DeleteBackupSchedule",
			Handler:    _FirestoreAdmin_DeleteBackupSchedule_Handler,
		},
		{
			MethodName: "CloneDatabase",
			Handler:    _FirestoreAdmin_CloneDatabase_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/firestore/admin/v1/firestore_admin.proto",
}
