// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcollectorprofiles "go.opentelemetry.io/proto/slim/otlp/collector/profiles/v1development"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyExportProfilesServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportProfilesServiceResponse() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewExportProfilesServiceResponse()
				CopyExportProfilesServiceResponse(dest, src)
				assert.Equal(t, src, dest)
				CopyExportProfilesServiceResponse(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyExportProfilesServiceResponseSlice(t *testing.T) {
	src := []ExportProfilesServiceResponse{}
	dest := []ExportProfilesServiceResponse{}
	// Test CopyTo empty
	dest = CopyExportProfilesServiceResponseSlice(dest, src)
	assert.Equal(t, []ExportProfilesServiceResponse{}, dest)

	// Test CopyTo larger slice
	src = GenTestExportProfilesServiceResponseSlice()
	dest = CopyExportProfilesServiceResponseSlice(dest, src)
	assert.Equal(t, GenTestExportProfilesServiceResponseSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExportProfilesServiceResponseSlice(dest, src)
	assert.Equal(t, GenTestExportProfilesServiceResponseSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExportProfilesServiceResponseSlice(dest, []ExportProfilesServiceResponse{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExportProfilesServiceResponseSlice(dest, src)
	assert.Equal(t, GenTestExportProfilesServiceResponseSlice(), dest)
}

func TestCopyExportProfilesServiceResponsePtrSlice(t *testing.T) {
	src := []*ExportProfilesServiceResponse{}
	dest := []*ExportProfilesServiceResponse{}
	// Test CopyTo empty
	dest = CopyExportProfilesServiceResponsePtrSlice(dest, src)
	assert.Equal(t, []*ExportProfilesServiceResponse{}, dest)

	// Test CopyTo larger slice
	src = GenTestExportProfilesServiceResponsePtrSlice()
	dest = CopyExportProfilesServiceResponsePtrSlice(dest, src)
	assert.Equal(t, GenTestExportProfilesServiceResponsePtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExportProfilesServiceResponsePtrSlice(dest, src)
	assert.Equal(t, GenTestExportProfilesServiceResponsePtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExportProfilesServiceResponsePtrSlice(dest, []*ExportProfilesServiceResponse{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExportProfilesServiceResponsePtrSlice(dest, src)
	assert.Equal(t, GenTestExportProfilesServiceResponsePtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONExportProfilesServiceResponseUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewExportProfilesServiceResponse()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewExportProfilesServiceResponse(), dest)
}

func TestMarshalAndUnmarshalJSONExportProfilesServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportProfilesServiceResponse() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewExportProfilesServiceResponse()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteExportProfilesServiceResponse(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoExportProfilesServiceResponseFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesExportProfilesServiceResponse() {
		t.Run(name, func(t *testing.T) {
			dest := NewExportProfilesServiceResponse()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoExportProfilesServiceResponseUnknown(t *testing.T) {
	dest := NewExportProfilesServiceResponse()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewExportProfilesServiceResponse(), dest)
}

func TestMarshalAndUnmarshalProtoExportProfilesServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportProfilesServiceResponse() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewExportProfilesServiceResponse()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteExportProfilesServiceResponse(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufExportProfilesServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportProfilesServiceResponse() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcollectorprofiles.ExportProfilesServiceResponse{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewExportProfilesServiceResponse()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesExportProfilesServiceResponse() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                  {0x02},
		"PartialSuccess/wrong_wire_type": {0xc},
		"PartialSuccess/missing_value":   {0xa},
	}
}

func genTestEncodingValuesExportProfilesServiceResponse() map[string]*ExportProfilesServiceResponse {
	return map[string]*ExportProfilesServiceResponse{
		"empty":               NewExportProfilesServiceResponse(),
		"PartialSuccess/test": {PartialSuccess: *GenTestExportProfilesPartialSuccess()},
	}
}
