// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcollectortrace "go.opentelemetry.io/proto/slim/otlp/collector/trace/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyExportTraceServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportTraceServiceRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewExportTraceServiceRequest()
				CopyExportTraceServiceRequest(dest, src)
				assert.Equal(t, src, dest)
				CopyExportTraceServiceRequest(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyExportTraceServiceRequestSlice(t *testing.T) {
	src := []ExportTraceServiceRequest{}
	dest := []ExportTraceServiceRequest{}
	// Test CopyTo empty
	dest = CopyExportTraceServiceRequestSlice(dest, src)
	assert.Equal(t, []ExportTraceServiceRequest{}, dest)

	// Test CopyTo larger slice
	src = GenTestExportTraceServiceRequestSlice()
	dest = CopyExportTraceServiceRequestSlice(dest, src)
	assert.Equal(t, GenTestExportTraceServiceRequestSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExportTraceServiceRequestSlice(dest, src)
	assert.Equal(t, GenTestExportTraceServiceRequestSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExportTraceServiceRequestSlice(dest, []ExportTraceServiceRequest{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExportTraceServiceRequestSlice(dest, src)
	assert.Equal(t, GenTestExportTraceServiceRequestSlice(), dest)
}

func TestCopyExportTraceServiceRequestPtrSlice(t *testing.T) {
	src := []*ExportTraceServiceRequest{}
	dest := []*ExportTraceServiceRequest{}
	// Test CopyTo empty
	dest = CopyExportTraceServiceRequestPtrSlice(dest, src)
	assert.Equal(t, []*ExportTraceServiceRequest{}, dest)

	// Test CopyTo larger slice
	src = GenTestExportTraceServiceRequestPtrSlice()
	dest = CopyExportTraceServiceRequestPtrSlice(dest, src)
	assert.Equal(t, GenTestExportTraceServiceRequestPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExportTraceServiceRequestPtrSlice(dest, src)
	assert.Equal(t, GenTestExportTraceServiceRequestPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExportTraceServiceRequestPtrSlice(dest, []*ExportTraceServiceRequest{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExportTraceServiceRequestPtrSlice(dest, src)
	assert.Equal(t, GenTestExportTraceServiceRequestPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONExportTraceServiceRequestUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewExportTraceServiceRequest()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewExportTraceServiceRequest(), dest)
}

func TestMarshalAndUnmarshalJSONExportTraceServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportTraceServiceRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewExportTraceServiceRequest()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteExportTraceServiceRequest(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoExportTraceServiceRequestFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesExportTraceServiceRequest() {
		t.Run(name, func(t *testing.T) {
			dest := NewExportTraceServiceRequest()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoExportTraceServiceRequestUnknown(t *testing.T) {
	dest := NewExportTraceServiceRequest()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewExportTraceServiceRequest(), dest)
}

func TestMarshalAndUnmarshalProtoExportTraceServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportTraceServiceRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewExportTraceServiceRequest()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteExportTraceServiceRequest(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufExportTraceServiceRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesExportTraceServiceRequest() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcollectortrace.ExportTraceServiceRequest{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewExportTraceServiceRequest()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesExportTraceServiceRequest() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                 {0x02},
		"ResourceSpans/wrong_wire_type": {0xc},
		"ResourceSpans/missing_value":   {0xa},
	}
}

func genTestEncodingValuesExportTraceServiceRequest() map[string]*ExportTraceServiceRequest {
	return map[string]*ExportTraceServiceRequest{
		"empty":              NewExportTraceServiceRequest(),
		"ResourceSpans/test": {ResourceSpans: []*ResourceSpans{{}, GenTestResourceSpans()}},
	}
}
