// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlplogs "go.opentelemetry.io/proto/slim/otlp/logs/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyResourceLogs(t *testing.T) {
	for name, src := range genTestEncodingValuesResourceLogs() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewResourceLogs()
				CopyResourceLogs(dest, src)
				assert.Equal(t, src, dest)
				CopyResourceLogs(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyResourceLogsSlice(t *testing.T) {
	src := []ResourceLogs{}
	dest := []ResourceLogs{}
	// Test CopyTo empty
	dest = CopyResourceLogsSlice(dest, src)
	assert.Equal(t, []ResourceLogs{}, dest)

	// Test CopyTo larger slice
	src = GenTestResourceLogsSlice()
	dest = CopyResourceLogsSlice(dest, src)
	assert.Equal(t, GenTestResourceLogsSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyResourceLogsSlice(dest, src)
	assert.Equal(t, GenTestResourceLogsSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyResourceLogsSlice(dest, []ResourceLogs{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyResourceLogsSlice(dest, src)
	assert.Equal(t, GenTestResourceLogsSlice(), dest)
}

func TestCopyResourceLogsPtrSlice(t *testing.T) {
	src := []*ResourceLogs{}
	dest := []*ResourceLogs{}
	// Test CopyTo empty
	dest = CopyResourceLogsPtrSlice(dest, src)
	assert.Equal(t, []*ResourceLogs{}, dest)

	// Test CopyTo larger slice
	src = GenTestResourceLogsPtrSlice()
	dest = CopyResourceLogsPtrSlice(dest, src)
	assert.Equal(t, GenTestResourceLogsPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyResourceLogsPtrSlice(dest, src)
	assert.Equal(t, GenTestResourceLogsPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyResourceLogsPtrSlice(dest, []*ResourceLogs{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyResourceLogsPtrSlice(dest, src)
	assert.Equal(t, GenTestResourceLogsPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONResourceLogsUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewResourceLogs()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewResourceLogs(), dest)
}

func TestMarshalAndUnmarshalJSONResourceLogs(t *testing.T) {
	for name, src := range genTestEncodingValuesResourceLogs() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewResourceLogs()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteResourceLogs(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoResourceLogsFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesResourceLogs() {
		t.Run(name, func(t *testing.T) {
			dest := NewResourceLogs()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoResourceLogsUnknown(t *testing.T) {
	dest := NewResourceLogs()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewResourceLogs(), dest)
}

func TestMarshalAndUnmarshalProtoResourceLogs(t *testing.T) {
	for name, src := range genTestEncodingValuesResourceLogs() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewResourceLogs()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteResourceLogs(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufResourceLogs(t *testing.T) {
	for name, src := range genTestEncodingValuesResourceLogs() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlplogs.ResourceLogs{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewResourceLogs()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesResourceLogs() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                       {0x02},
		"Resource/wrong_wire_type":            {0xc},
		"Resource/missing_value":              {0xa},
		"ScopeLogs/wrong_wire_type":           {0x14},
		"ScopeLogs/missing_value":             {0x12},
		"SchemaUrl/wrong_wire_type":           {0x1c},
		"SchemaUrl/missing_value":             {0x1a},
		"DeprecatedScopeLogs/wrong_wire_type": {0xc4, 0x3e},
		"DeprecatedScopeLogs/missing_value":   {0xc2, 0x3e},
	}
}

func genTestEncodingValuesResourceLogs() map[string]*ResourceLogs {
	return map[string]*ResourceLogs{
		"empty":                    NewResourceLogs(),
		"Resource/test":            {Resource: *GenTestResource()},
		"ScopeLogs/test":           {ScopeLogs: []*ScopeLogs{{}, GenTestScopeLogs()}},
		"SchemaUrl/test":           {SchemaUrl: "test_schemaurl"},
		"DeprecatedScopeLogs/test": {DeprecatedScopeLogs: []*ScopeLogs{{}, GenTestScopeLogs()}},
	}
}
