// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// Stack represents a stack trace as a list of locations.

type Stack struct {
	LocationIndices []int32
}

var (
	protoPoolStack = sync.Pool{
		New: func() any {
			return &Stack{}
		},
	}
)

func NewStack() *Stack {
	if !UseProtoPooling.IsEnabled() {
		return &Stack{}
	}
	return protoPoolStack.Get().(*Stack)
}

func DeleteStack(orig *Stack, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	orig.Reset()
	if nullable {
		protoPoolStack.Put(orig)
	}
}

func CopyStack(dest, src *Stack) *Stack {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewStack()
	}
	dest.LocationIndices = append(dest.LocationIndices[:0], src.LocationIndices...)

	return dest
}

func CopyStackSlice(dest, src []Stack) []Stack {
	var newDest []Stack
	if cap(dest) < len(src) {
		newDest = make([]Stack, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteStack(&dest[i], false)
		}
	}
	for i := range src {
		CopyStack(&newDest[i], &src[i])
	}
	return newDest
}

func CopyStackPtrSlice(dest, src []*Stack) []*Stack {
	var newDest []*Stack
	if cap(dest) < len(src) {
		newDest = make([]*Stack, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewStack()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteStack(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewStack()
		}
	}
	for i := range src {
		CopyStack(newDest[i], src[i])
	}
	return newDest
}

func (orig *Stack) Reset() {
	*orig = Stack{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *Stack) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.LocationIndices) > 0 {
		dest.WriteObjectField("locationIndices")
		dest.WriteArrayStart()
		dest.WriteInt32(orig.LocationIndices[0])
		for i := 1; i < len(orig.LocationIndices); i++ {
			dest.WriteMore()
			dest.WriteInt32(orig.LocationIndices[i])
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *Stack) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "locationIndices", "location_indices":
			for iter.ReadArray() {
				orig.LocationIndices = append(orig.LocationIndices, iter.ReadInt32())
			}

		default:
			iter.Skip()
		}
	}
}

func (orig *Stack) SizeProto() int {
	var n int
	var l int
	_ = l
	if len(orig.LocationIndices) > 0 {
		l = 0
		for _, e := range orig.LocationIndices {
			l += proto.Sov(uint64(e))
		}
		n += 1 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *Stack) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = len(orig.LocationIndices)
	if l > 0 {
		endPos := pos
		for i := l - 1; i >= 0; i-- {
			pos = proto.EncodeVarint(buf, pos, uint64(orig.LocationIndices[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(endPos-pos))
		pos--
		buf[pos] = 0xa
	}
	return len(buf) - pos
}

func (orig *Stack) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {
		case 1:
			switch wireType {
			case proto.WireTypeLen:
				var length int
				length, pos, err = proto.ConsumeLen(buf, pos)
				if err != nil {
					return err
				}
				startPos := pos - length
				var num uint64
				for startPos < pos {
					num, startPos, err = proto.ConsumeVarint(buf[:pos], startPos)
					if err != nil {
						return err
					}
					orig.LocationIndices = append(orig.LocationIndices, int32(num))
				}
				if startPos != pos {
					return fmt.Errorf("proto: invalid field len = %d for field LocationIndices", pos-startPos)
				}
			case proto.WireTypeVarint:
				var num uint64
				num, pos, err = proto.ConsumeVarint(buf, pos)
				if err != nil {
					return err
				}
				orig.LocationIndices = append(orig.LocationIndices, int32(num))
			default:
				return fmt.Errorf("proto: wrong wireType = %d for field LocationIndices", wireType)
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestStack() *Stack {
	orig := NewStack()
	orig.LocationIndices = []int32{int32(0), int32(13)}
	return orig
}

func GenTestStackPtrSlice() []*Stack {
	orig := make([]*Stack, 5)
	orig[0] = NewStack()
	orig[1] = GenTestStack()
	orig[2] = NewStack()
	orig[3] = GenTestStack()
	orig[4] = NewStack()
	return orig
}

func GenTestStackSlice() []Stack {
	orig := make([]Stack, 5)
	orig[1] = *GenTestStack()
	orig[3] = *GenTestStack()
	return orig
}
