// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpmetrics "go.opentelemetry.io/proto/slim/otlp/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopySummaryDataPointValueAtQuantile(t *testing.T) {
	for name, src := range genTestEncodingValuesSummaryDataPointValueAtQuantile() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewSummaryDataPointValueAtQuantile()
				CopySummaryDataPointValueAtQuantile(dest, src)
				assert.Equal(t, src, dest)
				CopySummaryDataPointValueAtQuantile(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopySummaryDataPointValueAtQuantileSlice(t *testing.T) {
	src := []SummaryDataPointValueAtQuantile{}
	dest := []SummaryDataPointValueAtQuantile{}
	// Test CopyTo empty
	dest = CopySummaryDataPointValueAtQuantileSlice(dest, src)
	assert.Equal(t, []SummaryDataPointValueAtQuantile{}, dest)

	// Test CopyTo larger slice
	src = GenTestSummaryDataPointValueAtQuantileSlice()
	dest = CopySummaryDataPointValueAtQuantileSlice(dest, src)
	assert.Equal(t, GenTestSummaryDataPointValueAtQuantileSlice(), dest)

	// Test CopyTo same size slice
	dest = CopySummaryDataPointValueAtQuantileSlice(dest, src)
	assert.Equal(t, GenTestSummaryDataPointValueAtQuantileSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopySummaryDataPointValueAtQuantileSlice(dest, []SummaryDataPointValueAtQuantile{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopySummaryDataPointValueAtQuantileSlice(dest, src)
	assert.Equal(t, GenTestSummaryDataPointValueAtQuantileSlice(), dest)
}

func TestCopySummaryDataPointValueAtQuantilePtrSlice(t *testing.T) {
	src := []*SummaryDataPointValueAtQuantile{}
	dest := []*SummaryDataPointValueAtQuantile{}
	// Test CopyTo empty
	dest = CopySummaryDataPointValueAtQuantilePtrSlice(dest, src)
	assert.Equal(t, []*SummaryDataPointValueAtQuantile{}, dest)

	// Test CopyTo larger slice
	src = GenTestSummaryDataPointValueAtQuantilePtrSlice()
	dest = CopySummaryDataPointValueAtQuantilePtrSlice(dest, src)
	assert.Equal(t, GenTestSummaryDataPointValueAtQuantilePtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopySummaryDataPointValueAtQuantilePtrSlice(dest, src)
	assert.Equal(t, GenTestSummaryDataPointValueAtQuantilePtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopySummaryDataPointValueAtQuantilePtrSlice(dest, []*SummaryDataPointValueAtQuantile{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopySummaryDataPointValueAtQuantilePtrSlice(dest, src)
	assert.Equal(t, GenTestSummaryDataPointValueAtQuantilePtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONSummaryDataPointValueAtQuantileUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewSummaryDataPointValueAtQuantile()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewSummaryDataPointValueAtQuantile(), dest)
}

func TestMarshalAndUnmarshalJSONSummaryDataPointValueAtQuantile(t *testing.T) {
	for name, src := range genTestEncodingValuesSummaryDataPointValueAtQuantile() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewSummaryDataPointValueAtQuantile()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteSummaryDataPointValueAtQuantile(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoSummaryDataPointValueAtQuantileFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesSummaryDataPointValueAtQuantile() {
		t.Run(name, func(t *testing.T) {
			dest := NewSummaryDataPointValueAtQuantile()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoSummaryDataPointValueAtQuantileUnknown(t *testing.T) {
	dest := NewSummaryDataPointValueAtQuantile()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewSummaryDataPointValueAtQuantile(), dest)
}

func TestMarshalAndUnmarshalProtoSummaryDataPointValueAtQuantile(t *testing.T) {
	for name, src := range genTestEncodingValuesSummaryDataPointValueAtQuantile() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewSummaryDataPointValueAtQuantile()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteSummaryDataPointValueAtQuantile(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufSummaryDataPointValueAtQuantile(t *testing.T) {
	for name, src := range genTestEncodingValuesSummaryDataPointValueAtQuantile() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpmetrics.SummaryDataPoint_ValueAtQuantile{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewSummaryDataPointValueAtQuantile()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesSummaryDataPointValueAtQuantile() map[string][]byte {
	return map[string][]byte{
		"invalid_field":            {0x02},
		"Quantile/wrong_wire_type": {0xc},
		"Quantile/missing_value":   {0x9},
		"Value/wrong_wire_type":    {0x14},
		"Value/missing_value":      {0x11},
	}
}

func genTestEncodingValuesSummaryDataPointValueAtQuantile() map[string]*SummaryDataPointValueAtQuantile {
	return map[string]*SummaryDataPointValueAtQuantile{
		"empty":         NewSummaryDataPointValueAtQuantile(),
		"Quantile/test": {Quantile: float64(3.1415926)},
		"Value/test":    {Value: float64(3.1415926)},
	}
}
