package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// GlobalMalwareInfo 租户Global恶意文件列表
type GlobalMalwareInfo struct {

	// 文件名称
	FileName *string `json:"file_name,omitempty"`

	// 文件路径
	FilePath *string `json:"file_path,omitempty"`

	// 文件大小
	Size *int64 `json:"size,omitempty"`

	// 最近扫描时间，时间单位 毫秒（ms）
	LatestScanTime *int64 `json:"latest_scan_time,omitempty"`

	// 文件描述
	Description *string `json:"description,omitempty"`

	// 仓库镜像类型，包含如下:   - SwrPrivate : swr私有镜像   - SwrShared : swr共享    - SwrEnterprise : swr企业   - Harbor : harbor仓库     - Jfrog : jfrog仓库    - Other : 其他仓库
	ImageType *string `json:"image_type,omitempty"`

	// 组织名称
	Namespace *string `json:"namespace,omitempty"`

	// 镜像名称
	ImageName *string `json:"image_name,omitempty"`

	// 镜像版本名称
	ImageVersion *string `json:"image_version,omitempty"`

	// 镜像id
	ImageId *string `json:"image_id,omitempty"`

	// 企业仓库实例ID
	InstanceId *string `json:"instance_id,omitempty"`
}

func (o GlobalMalwareInfo) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "GlobalMalwareInfo struct{}"
	}

	return strings.Join([]string{"GlobalMalwareInfo", string(data)}, " ")
}
