package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// ImageMalwareInfo 查询镜像恶意文件列表，恶意文件信息
type ImageMalwareInfo struct {

	// **参数解释**: 文件名称 **取值范围**: 字符长度0-256位
	FileName *string `json:"file_name,omitempty"`

	// **参数解释**: 文件路径 **取值范围**: 字符长度0-256位
	FilePath *string `json:"file_path,omitempty"`

	// **参数解释**: 文件大小 **取值范围**: 最小值0，最大值65535
	Size *int32 `json:"size,omitempty"`

	// **参数解释**: 文件描述 **取值范围**: 字符长度0-256位
	Description *string `json:"description,omitempty"`
}

func (o ImageMalwareInfo) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "ImageMalwareInfo struct{}"
	}

	return strings.Join([]string{"ImageMalwareInfo", string(data)}, " ")
}
