package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// AlertMalware 恶意软件
type AlertMalware struct {

	// 恶意家族
	MalwareFamily *string `json:"malware_family,omitempty"`

	// 恶意软件分类
	MalwareClass *string `json:"malware_class,omitempty"`
}

func (o AlertMalware) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "AlertMalware struct{}"
	}

	return strings.Join([]string{"AlertMalware", string(data)}, " ")
}
