package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

type VulnerabilityDataObject struct {

	// 漏洞名称
	VulName *string `json:"vul_name,omitempty"`

	// 首次发现时间，格式ISO8601：YYYY-MM-DDTHH:mm:ss.ms+timezone。时区信息为事件发生时区，无法解析时区的时间，默认时区填东八区
	FirstObservedTime *string `json:"first_observed_time,omitempty"`

	// 漏洞批次号
	BatchNumber *string `json:"batch_number,omitempty"`

	// 漏洞描述
	Description *string `json:"description,omitempty"`

	// 受影响的资产数量
	ResourceNum *int32 `json:"resource_num,omitempty"`

	// 租户id
	DomainId *string `json:"domain_id,omitempty"`

	// 工作空间id
	WorkspaceId *string `json:"workspace_id,omitempty"`

	Remediation *VulnerabilityDataObjectRemediation `json:"remediation,omitempty"`

	// 租户名称
	DomainName *string `json:"domain_name,omitempty"`

	// 更新时间
	UpdateTime *string `json:"update_time,omitempty"`

	// 是否删除
	IsDeleted *bool `json:"is_deleted,omitempty"`

	// 项目ID
	ProjectId *string `json:"project_id,omitempty"`

	ExtendProperties *VulnerabilityDataObjectExtendProperties `json:"extend_properties,omitempty"`

	// 区域名称
	RegionName *string `json:"region_name,omitempty"`

	// 漏洞公告ID
	Id *string `json:"id,omitempty"`

	VulnerabilityType *VulnerabilityDataObjectVulnerabilityType `json:"vulnerability_type,omitempty"`

	// 创建时间
	CreateTime *string `json:"create_time,omitempty"`

	// 最后发现时间
	LastObservedTime *string `json:"last_observed_time,omitempty"`

	Resource *VulnerabilityDataObjectResource `json:"resource,omitempty"`

	// 漏洞计数
	Count *int32 `json:"count,omitempty"`

	// 区域ID
	RegionId *string `json:"region_id,omitempty"`

	Vulnerability *VulnerabilityDataObjectVulnerability `json:"vulnerability,omitempty"`

	// 数据分类ID
	DataclassId *string `json:"dataclass_id,omitempty"`

	// 漏洞版本号
	Version *string `json:"version,omitempty"`

	DataSource *VulnerabilityDataObjectDataSource `json:"data_source,omitempty"`

	// 数据到达时间
	ArriveTime *string `json:"arrive_time,omitempty"`

	Environment *VulnerabilityDataObjectEnvironment `json:"environment,omitempty"`

	// 是否触发标记
	TriggerFlag *bool `json:"trigger_flag,omitempty"`

	// 处理状态
	Handled *int32 `json:"handled,omitempty"`
}

func (o VulnerabilityDataObject) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "VulnerabilityDataObject struct{}"
	}

	return strings.Join([]string{"VulnerabilityDataObject", string(data)}, " ")
}
