// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v4.24.4
// source: google/actions/sdk/v2/interactionmodel/prompt/surface_capabilities.proto

package prompt

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Capabilities the device surface supports at the time of the request.
type SurfaceCapabilities_Capability int32

const (
	// Unspecified surface capability.
	SurfaceCapabilities_UNSPECIFIED SurfaceCapabilities_Capability = 0
	// Device can speak to the user via text-to-speech or SSML.
	SurfaceCapabilities_SPEECH SurfaceCapabilities_Capability = 1
	// Device can display rich responses like cards, lists and tables.
	SurfaceCapabilities_RICH_RESPONSE SurfaceCapabilities_Capability = 2
	// Device can play long form audio media like music and podcasts.
	SurfaceCapabilities_LONG_FORM_AUDIO SurfaceCapabilities_Capability = 3
	// Device can display a interactive canvas response.
	SurfaceCapabilities_INTERACTIVE_CANVAS SurfaceCapabilities_Capability = 4
	// Device can use web links in rich responses to open a web browser.
	SurfaceCapabilities_WEB_LINK SurfaceCapabilities_Capability = 5
	// Device can support saving and fetching home storage.
	SurfaceCapabilities_HOME_STORAGE SurfaceCapabilities_Capability = 6
)

// Enum value maps for SurfaceCapabilities_Capability.
var (
	SurfaceCapabilities_Capability_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "SPEECH",
		2: "RICH_RESPONSE",
		3: "LONG_FORM_AUDIO",
		4: "INTERACTIVE_CANVAS",
		5: "WEB_LINK",
		6: "HOME_STORAGE",
	}
	SurfaceCapabilities_Capability_value = map[string]int32{
		"UNSPECIFIED":        0,
		"SPEECH":             1,
		"RICH_RESPONSE":      2,
		"LONG_FORM_AUDIO":    3,
		"INTERACTIVE_CANVAS": 4,
		"WEB_LINK":           5,
		"HOME_STORAGE":       6,
	}
)

func (x SurfaceCapabilities_Capability) Enum() *SurfaceCapabilities_Capability {
	p := new(SurfaceCapabilities_Capability)
	*p = x
	return p
}

func (x SurfaceCapabilities_Capability) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SurfaceCapabilities_Capability) Descriptor() protoreflect.EnumDescriptor {
	return file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_enumTypes[0].Descriptor()
}

func (SurfaceCapabilities_Capability) Type() protoreflect.EnumType {
	return &file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_enumTypes[0]
}

func (x SurfaceCapabilities_Capability) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SurfaceCapabilities_Capability.Descriptor instead.
func (SurfaceCapabilities_Capability) EnumDescriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_rawDescGZIP(), []int{0, 0}
}

// Represents the surface the user is using to make a request to the Action.
type SurfaceCapabilities struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The capabilities of the surface making a request to the Action.
	Capabilities []SurfaceCapabilities_Capability `protobuf:"varint,1,rep,packed,name=capabilities,proto3,enum=google.actions.sdk.v2.interactionmodel.prompt.SurfaceCapabilities_Capability" json:"capabilities,omitempty"`
}

func (x *SurfaceCapabilities) Reset() {
	*x = SurfaceCapabilities{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SurfaceCapabilities) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SurfaceCapabilities) ProtoMessage() {}

func (x *SurfaceCapabilities) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SurfaceCapabilities.ProtoReflect.Descriptor instead.
func (*SurfaceCapabilities) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_rawDescGZIP(), []int{0}
}

func (x *SurfaceCapabilities) GetCapabilities() []SurfaceCapabilities_Capability {
	if x != nil {
		return x.Capabilities
	}
	return nil
}

var File_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto protoreflect.FileDescriptor

var file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_rawDesc = []byte{
	0x0a, 0x48, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x2f,
	0x73, 0x75, 0x72, 0x66, 0x61, 0x63, 0x65, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x2d, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76,
	0x32, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x99, 0x02, 0x0a, 0x13, 0x53,
	0x75, 0x72, 0x66, 0x61, 0x63, 0x65, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x12, 0x76, 0x0a, 0x0c, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32,
	0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x2e, 0x53, 0x75, 0x72, 0x66, 0x61, 0x63, 0x65,
	0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x43, 0x61, 0x70,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x63, 0x61,
	0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x22, 0x89, 0x01, 0x0a, 0x0a, 0x43,
	0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x50,
	0x45, 0x45, 0x43, 0x48, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x52, 0x49, 0x43, 0x48, 0x5f, 0x52,
	0x45, 0x53, 0x50, 0x4f, 0x4e, 0x53, 0x45, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x4c, 0x4f, 0x4e,
	0x47, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x5f, 0x41, 0x55, 0x44, 0x49, 0x4f, 0x10, 0x03, 0x12, 0x16,
	0x0a, 0x12, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x43, 0x41,
	0x4e, 0x56, 0x41, 0x53, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x57, 0x45, 0x42, 0x5f, 0x4c, 0x49,
	0x4e, 0x4b, 0x10, 0x05, 0x12, 0x10, 0x0a, 0x0c, 0x48, 0x4f, 0x4d, 0x45, 0x5f, 0x53, 0x54, 0x4f,
	0x52, 0x41, 0x47, 0x45, 0x10, 0x06, 0x42, 0xa4, 0x01, 0x0a, 0x31, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64,
	0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x42, 0x18, 0x53, 0x75,
	0x72, 0x66, 0x61, 0x63, 0x65, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x53, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f,
	0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x3b, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_rawDescOnce sync.Once
	file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_rawDescData = file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_rawDesc
)

func file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_rawDescGZIP() []byte {
	file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_rawDescOnce.Do(func() {
		file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_rawDescData)
	})
	return file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_rawDescData
}

var file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_goTypes = []interface{}{
	(SurfaceCapabilities_Capability)(0), // 0: google.actions.sdk.v2.interactionmodel.prompt.SurfaceCapabilities.Capability
	(*SurfaceCapabilities)(nil),         // 1: google.actions.sdk.v2.interactionmodel.prompt.SurfaceCapabilities
}
var file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_depIdxs = []int32{
	0, // 0: google.actions.sdk.v2.interactionmodel.prompt.SurfaceCapabilities.capabilities:type_name -> google.actions.sdk.v2.interactionmodel.prompt.SurfaceCapabilities.Capability
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_init() }
func file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_init() {
	if File_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SurfaceCapabilities); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_goTypes,
		DependencyIndexes: file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_depIdxs,
		EnumInfos:         file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_enumTypes,
		MessageInfos:      file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_msgTypes,
	}.Build()
	File_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto = out.File
	file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_rawDesc = nil
	file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_goTypes = nil
	file_google_actions_sdk_v2_interactionmodel_prompt_surface_capabilities_proto_depIdxs = nil
}
