// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package efs

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateAccessPoint = "CreateAccessPoint"

// CreateAccessPointRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccessPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccessPoint for more information on using the CreateAccessPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAccessPointRequest method.
//	req, resp := client.CreateAccessPointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/CreateAccessPoint
func (c *EFS) CreateAccessPointRequest(input *CreateAccessPointInput) (req *request.Request, output *CreateAccessPointOutput) {
	op := &request.Operation{
		Name:       opCreateAccessPoint,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-02-01/access-points",
	}

	if input == nil {
		input = &CreateAccessPointInput{}
	}

	output = &CreateAccessPointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAccessPoint API operation for Amazon Elastic File System.
//
// Creates an EFS access point. An access point is an application-specific view
// into an EFS file system that applies an operating system user and group,
// and a file system path, to any file system request made through the access
// point. The operating system user and group override any identity information
// provided by the NFS client. The file system path is exposed as the access
// point's root directory. Applications using the access point can only access
// data in the application's own directory and any subdirectories. To learn
// more, see Mounting a file system using EFS access points (https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html).
//
// If multiple requests to create access points on the same file system are
// sent in quick succession, and the file system is near the limit of 1,000
// access points, you may experience a throttling response for these requests.
// This is to ensure that the file system does not exceed the stated access
// point limit.
//
// This operation requires permissions for the elasticfilesystem:CreateAccessPoint
// action.
//
// Access points can be tagged on creation. If tags are specified in the creation
// action, IAM performs additional authorization on the elasticfilesystem:TagResource
// action to verify if users have permissions to create tags. Therefore, you
// must grant explicit permissions to use the elasticfilesystem:TagResource
// action. For more information, see Granting permissions to tag resources during
// creation (https://docs.aws.amazon.com/efs/latest/ug/using-tags-efs.html#supported-iam-actions-tagging.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation CreateAccessPoint for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - AccessPointAlreadyExists
//     Returned if the access point that you are trying to create already exists,
//     with the creation token you provided in the request.
//
//   - IncorrectFileSystemLifeCycleState
//     Returned if the file system's lifecycle state is not "available".
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - FileSystemNotFound
//     Returned if the specified FileSystemId value doesn't exist in the requester's
//     Amazon Web Services account.
//
//   - AccessPointLimitExceeded
//     Returned if the Amazon Web Services account has already created the maximum
//     number of access points allowed per file system. For more informaton, see
//     https://docs.aws.amazon.com/efs/latest/ug/limits.html#limits-efs-resources-per-account-per-region
//     (https://docs.aws.amazon.com/efs/latest/ug/limits.html#limits-efs-resources-per-account-per-region).
//
//   - ThrottlingException
//     Returned when the CreateAccessPoint API action is called too quickly and
//     the number of Access Points on the file system is nearing the limit of 120
//     (https://docs.aws.amazon.com/efs/latest/ug/limits.html#limits-efs-resources-per-account-per-region).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/CreateAccessPoint
func (c *EFS) CreateAccessPoint(input *CreateAccessPointInput) (*CreateAccessPointOutput, error) {
	req, out := c.CreateAccessPointRequest(input)
	return out, req.Send()
}

// CreateAccessPointWithContext is the same as CreateAccessPoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccessPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) CreateAccessPointWithContext(ctx aws.Context, input *CreateAccessPointInput, opts ...request.Option) (*CreateAccessPointOutput, error) {
	req, out := c.CreateAccessPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFileSystem = "CreateFileSystem"

// CreateFileSystemRequest generates a "aws/request.Request" representing the
// client's request for the CreateFileSystem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFileSystem for more information on using the CreateFileSystem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFileSystemRequest method.
//	req, resp := client.CreateFileSystemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/CreateFileSystem
func (c *EFS) CreateFileSystemRequest(input *CreateFileSystemInput) (req *request.Request, output *FileSystemDescription) {
	op := &request.Operation{
		Name:       opCreateFileSystem,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-02-01/file-systems",
	}

	if input == nil {
		input = &CreateFileSystemInput{}
	}

	output = &FileSystemDescription{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFileSystem API operation for Amazon Elastic File System.
//
// Creates a new, empty file system. The operation requires a creation token
// in the request that Amazon EFS uses to ensure idempotent creation (calling
// the operation with same creation token has no effect). If a file system does
// not currently exist that is owned by the caller's Amazon Web Services account
// with the specified creation token, this operation does the following:
//
//   - Creates a new, empty file system. The file system will have an Amazon
//     EFS assigned ID, and an initial lifecycle state creating.
//
//   - Returns with the description of the created file system.
//
// Otherwise, this operation returns a FileSystemAlreadyExists error with the
// ID of the existing file system.
//
// For basic use cases, you can use a randomly generated UUID for the creation
// token.
//
// The idempotent operation allows you to retry a CreateFileSystem call without
// risk of creating an extra file system. This can happen when an initial call
// fails in a way that leaves it uncertain whether or not a file system was
// actually created. An example might be that a transport level timeout occurred
// or your connection was reset. As long as you use the same creation token,
// if the initial call had succeeded in creating a file system, the client can
// learn of its existence from the FileSystemAlreadyExists error.
//
// For more information, see Creating a file system (https://docs.aws.amazon.com/efs/latest/ug/creating-using-create-fs.html#creating-using-create-fs-part1)
// in the Amazon EFS User Guide.
//
// The CreateFileSystem call returns while the file system's lifecycle state
// is still creating. You can check the file system creation status by calling
// the DescribeFileSystems operation, which among other things returns the file
// system state.
//
// This operation accepts an optional PerformanceMode parameter that you choose
// for your file system. We recommend generalPurpose performance mode for most
// file systems. File systems using the maxIO performance mode can scale to
// higher levels of aggregate throughput and operations per second with a tradeoff
// of slightly higher latencies for most file operations. The performance mode
// can't be changed after the file system has been created. For more information,
// see Amazon EFS performance modes (https://docs.aws.amazon.com/efs/latest/ug/performance.html#performancemodes.html).
//
// You can set the throughput mode for the file system using the ThroughputMode
// parameter.
//
// After the file system is fully created, Amazon EFS sets its lifecycle state
// to available, at which point you can create one or more mount targets for
// the file system in your VPC. For more information, see CreateMountTarget.
// You mount your Amazon EFS file system on an EC2 instances in your VPC by
// using the mount target. For more information, see Amazon EFS: How it Works
// (https://docs.aws.amazon.com/efs/latest/ug/how-it-works.html).
//
// This operation requires permissions for the elasticfilesystem:CreateFileSystem
// action.
//
// File systems can be tagged on creation. If tags are specified in the creation
// action, IAM performs additional authorization on the elasticfilesystem:TagResource
// action to verify if users have permissions to create tags. Therefore, you
// must grant explicit permissions to use the elasticfilesystem:TagResource
// action. For more information, see Granting permissions to tag resources during
// creation (https://docs.aws.amazon.com/efs/latest/ug/using-tags-efs.html#supported-iam-actions-tagging.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation CreateFileSystem for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - FileSystemAlreadyExists
//     Returned if the file system you are trying to create already exists, with
//     the creation token you provided.
//
//   - FileSystemLimitExceeded
//     Returned if the Amazon Web Services account has already created the maximum
//     number of file systems allowed per account.
//
//   - InsufficientThroughputCapacity
//     Returned if there's not enough capacity to provision additional throughput.
//     This value might be returned when you try to create a file system in provisioned
//     throughput mode, when you attempt to increase the provisioned throughput
//     of an existing file system, or when you attempt to change an existing file
//     system from Bursting Throughput to Provisioned Throughput mode. Try again
//     later.
//
//   - ThroughputLimitExceeded
//     Returned if the throughput mode or amount of provisioned throughput can't
//     be changed because the throughput limit of 1024 MiB/s has been reached.
//
//   - UnsupportedAvailabilityZone
//     Returned if the requested Amazon EFS functionality is not available in the
//     specified Availability Zone.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/CreateFileSystem
func (c *EFS) CreateFileSystem(input *CreateFileSystemInput) (*FileSystemDescription, error) {
	req, out := c.CreateFileSystemRequest(input)
	return out, req.Send()
}

// CreateFileSystemWithContext is the same as CreateFileSystem with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFileSystem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) CreateFileSystemWithContext(ctx aws.Context, input *CreateFileSystemInput, opts ...request.Option) (*FileSystemDescription, error) {
	req, out := c.CreateFileSystemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMountTarget = "CreateMountTarget"

// CreateMountTargetRequest generates a "aws/request.Request" representing the
// client's request for the CreateMountTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMountTarget for more information on using the CreateMountTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMountTargetRequest method.
//	req, resp := client.CreateMountTargetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/CreateMountTarget
func (c *EFS) CreateMountTargetRequest(input *CreateMountTargetInput) (req *request.Request, output *MountTargetDescription) {
	op := &request.Operation{
		Name:       opCreateMountTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-02-01/mount-targets",
	}

	if input == nil {
		input = &CreateMountTargetInput{}
	}

	output = &MountTargetDescription{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMountTarget API operation for Amazon Elastic File System.
//
// Creates a mount target for a file system. You can then mount the file system
// on EC2 instances by using the mount target.
//
// You can create one mount target in each Availability Zone in your VPC. All
// EC2 instances in a VPC within a given Availability Zone share a single mount
// target for a given file system. If you have multiple subnets in an Availability
// Zone, you create a mount target in one of the subnets. EC2 instances do not
// need to be in the same subnet as the mount target in order to access their
// file system.
//
// You can create only one mount target for an EFS file system using One Zone
// storage classes. You must create that mount target in the same Availability
// Zone in which the file system is located. Use the AvailabilityZoneName and
// AvailabiltyZoneId properties in the DescribeFileSystems response object to
// get this information. Use the subnetId associated with the file system's
// Availability Zone when creating the mount target.
//
// For more information, see Amazon EFS: How it Works (https://docs.aws.amazon.com/efs/latest/ug/how-it-works.html).
//
// To create a mount target for a file system, the file system's lifecycle state
// must be available. For more information, see DescribeFileSystems.
//
// In the request, provide the following:
//
//   - The file system ID for which you are creating the mount target.
//
//   - A subnet ID, which determines the following: The VPC in which Amazon
//     EFS creates the mount target The Availability Zone in which Amazon EFS
//     creates the mount target The IP address range from which Amazon EFS selects
//     the IP address of the mount target (if you don't specify an IP address
//     in the request)
//
// After creating the mount target, Amazon EFS returns a response that includes,
// a MountTargetId and an IpAddress. You use this IP address when mounting the
// file system in an EC2 instance. You can also use the mount target's DNS name
// when mounting the file system. The EC2 instance on which you mount the file
// system by using the mount target can resolve the mount target's DNS name
// to its IP address. For more information, see How it Works: Implementation
// Overview (https://docs.aws.amazon.com/efs/latest/ug/how-it-works.html#how-it-works-implementation).
//
// Note that you can create mount targets for a file system in only one VPC,
// and there can be only one mount target per Availability Zone. That is, if
// the file system already has one or more mount targets created for it, the
// subnet specified in the request to add another mount target must meet the
// following requirements:
//
//   - Must belong to the same VPC as the subnets of the existing mount targets
//
//   - Must not be in the same Availability Zone as any of the subnets of the
//     existing mount targets
//
// If the request satisfies the requirements, Amazon EFS does the following:
//
//   - Creates a new mount target in the specified subnet.
//
//   - Also creates a new network interface in the subnet as follows: If the
//     request provides an IpAddress, Amazon EFS assigns that IP address to the
//     network interface. Otherwise, Amazon EFS assigns a free address in the
//     subnet (in the same way that the Amazon EC2 CreateNetworkInterface call
//     does when a request does not specify a primary private IP address). If
//     the request provides SecurityGroups, this network interface is associated
//     with those security groups. Otherwise, it belongs to the default security
//     group for the subnet's VPC. Assigns the description Mount target fsmt-id
//     for file system fs-id where fsmt-id is the mount target ID, and fs-id
//     is the FileSystemId. Sets the requesterManaged property of the network
//     interface to true, and the requesterId value to EFS. Each Amazon EFS mount
//     target has one corresponding requester-managed EC2 network interface.
//     After the network interface is created, Amazon EFS sets the NetworkInterfaceId
//     field in the mount target's description to the network interface ID, and
//     the IpAddress field to its address. If network interface creation fails,
//     the entire CreateMountTarget operation fails.
//
// The CreateMountTarget call returns only after creating the network interface,
// but while the mount target state is still creating, you can check the mount
// target creation status by calling the DescribeMountTargets operation, which
// among other things returns the mount target state.
//
// We recommend that you create a mount target in each of the Availability Zones.
// There are cost considerations for using a file system in an Availability
// Zone through a mount target created in another Availability Zone. For more
// information, see Amazon EFS (http://aws.amazon.com/efs/). In addition, by
// always using a mount target local to the instance's Availability Zone, you
// eliminate a partial failure scenario. If the Availability Zone in which your
// mount target is created goes down, then you can't access your file system
// through that mount target.
//
// This operation requires permissions for the following action on the file
// system:
//
//   - elasticfilesystem:CreateMountTarget
//
// This operation also requires permissions for the following Amazon EC2 actions:
//
//   - ec2:DescribeSubnets
//
//   - ec2:DescribeNetworkInterfaces
//
//   - ec2:CreateNetworkInterface
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation CreateMountTarget for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - FileSystemNotFound
//     Returned if the specified FileSystemId value doesn't exist in the requester's
//     Amazon Web Services account.
//
//   - IncorrectFileSystemLifeCycleState
//     Returned if the file system's lifecycle state is not "available".
//
//   - MountTargetConflict
//     Returned if the mount target would violate one of the specified restrictions
//     based on the file system's existing mount targets.
//
//   - SubnetNotFound
//     Returned if there is no subnet with ID SubnetId provided in the request.
//
//   - NoFreeAddressesInSubnet
//     Returned if IpAddress was not specified in the request and there are no free
//     IP addresses in the subnet.
//
//   - IpAddressInUse
//     Returned if the request specified an IpAddress that is already in use in
//     the subnet.
//
//   - NetworkInterfaceLimitExceeded
//     The calling account has reached the limit for elastic network interfaces
//     for the specific Amazon Web Services Region. Either delete some network interfaces
//     or request that the account quota be raised. For more information, see Amazon
//     VPC Quotas (https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Appendix_Limits.html)
//     in the Amazon VPC User Guide (see the Network interfaces per Region entry
//     in the Network interfaces table).
//
//   - SecurityGroupLimitExceeded
//     Returned if the size of SecurityGroups specified in the request is greater
//     than five.
//
//   - SecurityGroupNotFound
//     Returned if one of the specified security groups doesn't exist in the subnet's
//     virtual private cloud (VPC).
//
//   - UnsupportedAvailabilityZone
//     Returned if the requested Amazon EFS functionality is not available in the
//     specified Availability Zone.
//
//   - AvailabilityZonesMismatch
//     Returned if the Availability Zone that was specified for a mount target is
//     different from the Availability Zone that was specified for One Zone storage.
//     For more information, see Regional and One Zone storage redundancy (https://docs.aws.amazon.com/efs/latest/ug/availability-durability.html).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/CreateMountTarget
func (c *EFS) CreateMountTarget(input *CreateMountTargetInput) (*MountTargetDescription, error) {
	req, out := c.CreateMountTargetRequest(input)
	return out, req.Send()
}

// CreateMountTargetWithContext is the same as CreateMountTarget with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMountTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) CreateMountTargetWithContext(ctx aws.Context, input *CreateMountTargetInput, opts ...request.Option) (*MountTargetDescription, error) {
	req, out := c.CreateMountTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReplicationConfiguration = "CreateReplicationConfiguration"

// CreateReplicationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateReplicationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReplicationConfiguration for more information on using the CreateReplicationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateReplicationConfigurationRequest method.
//	req, resp := client.CreateReplicationConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/CreateReplicationConfiguration
func (c *EFS) CreateReplicationConfigurationRequest(input *CreateReplicationConfigurationInput) (req *request.Request, output *CreateReplicationConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateReplicationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-02-01/file-systems/{SourceFileSystemId}/replication-configuration",
	}

	if input == nil {
		input = &CreateReplicationConfigurationInput{}
	}

	output = &CreateReplicationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReplicationConfiguration API operation for Amazon Elastic File System.
//
// Creates a replication configuration that replicates an existing EFS file
// system to a new, read-only file system. For more information, see Amazon
// EFS replication (https://docs.aws.amazon.com/efs/latest/ug/efs-replication.html)
// in the Amazon EFS User Guide. The replication configuration specifies the
// following:
//
//   - Source file system - An existing EFS file system that you want replicated.
//     The source file system cannot be a destination file system in an existing
//     replication configuration.
//
//   - Destination file system configuration - The configuration of the destination
//     file system to which the source file system will be replicated. There
//     can only be one destination file system in a replication configuration.
//     The destination file system configuration consists of the following properties:
//     Amazon Web Services Region - The Amazon Web Services Region in which the
//     destination file system is created. Amazon EFS replication is available
//     in all Amazon Web Services Regions in which EFS is available. To use EFS
//     replication in a Region that is disabled by default, you must first opt
//     in to the Region. For more information, see Managing Amazon Web Services
//     Regions (https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable)
//     in the Amazon Web Services General Reference Reference Guide Availability
//     Zone - If you want the destination file system to use EFS One Zone availability
//     and durability, you must specify the Availability Zone to create the file
//     system in. For more information about EFS storage classes, see Amazon
//     EFS storage classes (https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html)
//     in the Amazon EFS User Guide. Encryption - All destination file systems
//     are created with encryption at rest enabled. You can specify the Key Management
//     Service (KMS) key that is used to encrypt the destination file system.
//     If you don't specify a KMS key, your service-managed KMS key for Amazon
//     EFS is used. After the file system is created, you cannot change the KMS
//     key.
//
// The following properties are set by default:
//
//   - Performance mode - The destination file system's performance mode matches
//     that of the source file system, unless the destination file system uses
//     EFS One Zone storage. In that case, the General Purpose performance mode
//     is used. The performance mode cannot be changed.
//
//   - Throughput mode - The destination file system's throughput mode matches
//     that of the source file system. After the file system is created, you
//     can modify the throughput mode.
//
// The following properties are turned off by default:
//
//   - Lifecycle management - EFS lifecycle management and EFS Intelligent-Tiering
//     are not enabled on the destination file system. After the destination
//     file system is created, you can enable EFS lifecycle management and EFS
//     Intelligent-Tiering.
//
//   - Automatic backups - Automatic daily backups are enabled on the destination
//     file system. After the file system is created, you can change this setting.
//
// For more information, see Amazon EFS replication (https://docs.aws.amazon.com/efs/latest/ug/efs-replication.html)
// in the Amazon EFS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation CreateReplicationConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - IncorrectFileSystemLifeCycleState
//     Returned if the file system's lifecycle state is not "available".
//
//   - ValidationException
//     Returned if the Backup service is not available in the Amazon Web Services
//     Region in which the request was made.
//
//   - ReplicationNotFound
//     Returned if the specified file system does not have a replication configuration.
//
//   - FileSystemNotFound
//     Returned if the specified FileSystemId value doesn't exist in the requester's
//     Amazon Web Services account.
//
//   - UnsupportedAvailabilityZone
//     Returned if the requested Amazon EFS functionality is not available in the
//     specified Availability Zone.
//
//   - FileSystemLimitExceeded
//     Returned if the Amazon Web Services account has already created the maximum
//     number of file systems allowed per account.
//
//   - InsufficientThroughputCapacity
//     Returned if there's not enough capacity to provision additional throughput.
//     This value might be returned when you try to create a file system in provisioned
//     throughput mode, when you attempt to increase the provisioned throughput
//     of an existing file system, or when you attempt to change an existing file
//     system from Bursting Throughput to Provisioned Throughput mode. Try again
//     later.
//
//   - ThroughputLimitExceeded
//     Returned if the throughput mode or amount of provisioned throughput can't
//     be changed because the throughput limit of 1024 MiB/s has been reached.
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/CreateReplicationConfiguration
func (c *EFS) CreateReplicationConfiguration(input *CreateReplicationConfigurationInput) (*CreateReplicationConfigurationOutput, error) {
	req, out := c.CreateReplicationConfigurationRequest(input)
	return out, req.Send()
}

// CreateReplicationConfigurationWithContext is the same as CreateReplicationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReplicationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) CreateReplicationConfigurationWithContext(ctx aws.Context, input *CreateReplicationConfigurationInput, opts ...request.Option) (*CreateReplicationConfigurationOutput, error) {
	req, out := c.CreateReplicationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTags = "CreateTags"

// CreateTagsRequest generates a "aws/request.Request" representing the
// client's request for the CreateTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTags for more information on using the CreateTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTagsRequest method.
//	req, resp := client.CreateTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/CreateTags
//
// Deprecated: Use TagResource.
func (c *EFS) CreateTagsRequest(input *CreateTagsInput) (req *request.Request, output *CreateTagsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, CreateTags, has been deprecated")
	}
	op := &request.Operation{
		Name:       opCreateTags,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-02-01/create-tags/{FileSystemId}",
	}

	if input == nil {
		input = &CreateTagsInput{}
	}

	output = &CreateTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateTags API operation for Amazon Elastic File System.
//
// DEPRECATED - CreateTags is deprecated and not maintained. To create tags
// for EFS resources, use the API action.
//
// Creates or overwrites tags associated with a file system. Each tag is a key-value
// pair. If a tag key specified in the request already exists on the file system,
// this operation overwrites its value with the value provided in the request.
// If you add the Name tag to your file system, Amazon EFS returns it in the
// response to the DescribeFileSystems operation.
//
// This operation requires permission for the elasticfilesystem:CreateTags action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation CreateTags for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - FileSystemNotFound
//     Returned if the specified FileSystemId value doesn't exist in the requester's
//     Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/CreateTags
//
// Deprecated: Use TagResource.
func (c *EFS) CreateTags(input *CreateTagsInput) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	return out, req.Send()
}

// CreateTagsWithContext is the same as CreateTags with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Use TagResource.
func (c *EFS) CreateTagsWithContext(ctx aws.Context, input *CreateTagsInput, opts ...request.Option) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccessPoint = "DeleteAccessPoint"

// DeleteAccessPointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccessPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccessPoint for more information on using the DeleteAccessPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAccessPointRequest method.
//	req, resp := client.DeleteAccessPointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DeleteAccessPoint
func (c *EFS) DeleteAccessPointRequest(input *DeleteAccessPointInput) (req *request.Request, output *DeleteAccessPointOutput) {
	op := &request.Operation{
		Name:       opDeleteAccessPoint,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-02-01/access-points/{AccessPointId}",
	}

	if input == nil {
		input = &DeleteAccessPointInput{}
	}

	output = &DeleteAccessPointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAccessPoint API operation for Amazon Elastic File System.
//
// Deletes the specified access point. After deletion is complete, new clients
// can no longer connect to the access points. Clients connected to the access
// point at the time of deletion will continue to function until they terminate
// their connection.
//
// This operation requires permissions for the elasticfilesystem:DeleteAccessPoint
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation DeleteAccessPoint for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - AccessPointNotFound
//     Returned if the specified AccessPointId value doesn't exist in the requester's
//     Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DeleteAccessPoint
func (c *EFS) DeleteAccessPoint(input *DeleteAccessPointInput) (*DeleteAccessPointOutput, error) {
	req, out := c.DeleteAccessPointRequest(input)
	return out, req.Send()
}

// DeleteAccessPointWithContext is the same as DeleteAccessPoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccessPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) DeleteAccessPointWithContext(ctx aws.Context, input *DeleteAccessPointInput, opts ...request.Option) (*DeleteAccessPointOutput, error) {
	req, out := c.DeleteAccessPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFileSystem = "DeleteFileSystem"

// DeleteFileSystemRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFileSystem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFileSystem for more information on using the DeleteFileSystem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFileSystemRequest method.
//	req, resp := client.DeleteFileSystemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DeleteFileSystem
func (c *EFS) DeleteFileSystemRequest(input *DeleteFileSystemInput) (req *request.Request, output *DeleteFileSystemOutput) {
	op := &request.Operation{
		Name:       opDeleteFileSystem,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-02-01/file-systems/{FileSystemId}",
	}

	if input == nil {
		input = &DeleteFileSystemInput{}
	}

	output = &DeleteFileSystemOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFileSystem API operation for Amazon Elastic File System.
//
// Deletes a file system, permanently severing access to its contents. Upon
// return, the file system no longer exists and you can't access any contents
// of the deleted file system.
//
// You need to manually delete mount targets attached to a file system before
// you can delete an EFS file system. This step is performed for you when you
// use the Amazon Web Services console to delete a file system.
//
// You cannot delete a file system that is part of an EFS Replication configuration.
// You need to delete the replication configuration first.
//
// You can't delete a file system that is in use. That is, if the file system
// has any mount targets, you must first delete them. For more information,
// see DescribeMountTargets and DeleteMountTarget.
//
// The DeleteFileSystem call returns while the file system state is still deleting.
// You can check the file system deletion status by calling the DescribeFileSystems
// operation, which returns a list of file systems in your account. If you pass
// file system ID or creation token for the deleted file system, the DescribeFileSystems
// returns a 404 FileSystemNotFound error.
//
// This operation requires permissions for the elasticfilesystem:DeleteFileSystem
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation DeleteFileSystem for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - FileSystemNotFound
//     Returned if the specified FileSystemId value doesn't exist in the requester's
//     Amazon Web Services account.
//
//   - FileSystemInUse
//     Returned if a file system has mount targets.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DeleteFileSystem
func (c *EFS) DeleteFileSystem(input *DeleteFileSystemInput) (*DeleteFileSystemOutput, error) {
	req, out := c.DeleteFileSystemRequest(input)
	return out, req.Send()
}

// DeleteFileSystemWithContext is the same as DeleteFileSystem with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFileSystem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) DeleteFileSystemWithContext(ctx aws.Context, input *DeleteFileSystemInput, opts ...request.Option) (*DeleteFileSystemOutput, error) {
	req, out := c.DeleteFileSystemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFileSystemPolicy = "DeleteFileSystemPolicy"

// DeleteFileSystemPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFileSystemPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFileSystemPolicy for more information on using the DeleteFileSystemPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFileSystemPolicyRequest method.
//	req, resp := client.DeleteFileSystemPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DeleteFileSystemPolicy
func (c *EFS) DeleteFileSystemPolicyRequest(input *DeleteFileSystemPolicyInput) (req *request.Request, output *DeleteFileSystemPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteFileSystemPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-02-01/file-systems/{FileSystemId}/policy",
	}

	if input == nil {
		input = &DeleteFileSystemPolicyInput{}
	}

	output = &DeleteFileSystemPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFileSystemPolicy API operation for Amazon Elastic File System.
//
// Deletes the FileSystemPolicy for the specified file system. The default FileSystemPolicy
// goes into effect once the existing policy is deleted. For more information
// about the default file system policy, see Using Resource-based Policies with
// EFS (https://docs.aws.amazon.com/efs/latest/ug/res-based-policies-efs.html).
//
// This operation requires permissions for the elasticfilesystem:DeleteFileSystemPolicy
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation DeleteFileSystemPolicy for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - FileSystemNotFound
//     Returned if the specified FileSystemId value doesn't exist in the requester's
//     Amazon Web Services account.
//
//   - IncorrectFileSystemLifeCycleState
//     Returned if the file system's lifecycle state is not "available".
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DeleteFileSystemPolicy
func (c *EFS) DeleteFileSystemPolicy(input *DeleteFileSystemPolicyInput) (*DeleteFileSystemPolicyOutput, error) {
	req, out := c.DeleteFileSystemPolicyRequest(input)
	return out, req.Send()
}

// DeleteFileSystemPolicyWithContext is the same as DeleteFileSystemPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFileSystemPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) DeleteFileSystemPolicyWithContext(ctx aws.Context, input *DeleteFileSystemPolicyInput, opts ...request.Option) (*DeleteFileSystemPolicyOutput, error) {
	req, out := c.DeleteFileSystemPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMountTarget = "DeleteMountTarget"

// DeleteMountTargetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMountTarget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMountTarget for more information on using the DeleteMountTarget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMountTargetRequest method.
//	req, resp := client.DeleteMountTargetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DeleteMountTarget
func (c *EFS) DeleteMountTargetRequest(input *DeleteMountTargetInput) (req *request.Request, output *DeleteMountTargetOutput) {
	op := &request.Operation{
		Name:       opDeleteMountTarget,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-02-01/mount-targets/{MountTargetId}",
	}

	if input == nil {
		input = &DeleteMountTargetInput{}
	}

	output = &DeleteMountTargetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMountTarget API operation for Amazon Elastic File System.
//
// Deletes the specified mount target.
//
// This operation forcibly breaks any mounts of the file system by using the
// mount target that is being deleted, which might disrupt instances or applications
// using those mounts. To avoid applications getting cut off abruptly, you might
// consider unmounting any mounts of the mount target, if feasible. The operation
// also deletes the associated network interface. Uncommitted writes might be
// lost, but breaking a mount target using this operation does not corrupt the
// file system itself. The file system you created remains. You can mount an
// EC2 instance in your VPC by using another mount target.
//
// This operation requires permissions for the following action on the file
// system:
//
//   - elasticfilesystem:DeleteMountTarget
//
// The DeleteMountTarget call returns while the mount target state is still
// deleting. You can check the mount target deletion by calling the DescribeMountTargets
// operation, which returns a list of mount target descriptions for the given
// file system.
//
// The operation also requires permissions for the following Amazon EC2 action
// on the mount target's network interface:
//
//   - ec2:DeleteNetworkInterface
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation DeleteMountTarget for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - DependencyTimeout
//     The service timed out trying to fulfill the request, and the client should
//     try the call again.
//
//   - MountTargetNotFound
//     Returned if there is no mount target with the specified ID found in the caller's
//     Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DeleteMountTarget
func (c *EFS) DeleteMountTarget(input *DeleteMountTargetInput) (*DeleteMountTargetOutput, error) {
	req, out := c.DeleteMountTargetRequest(input)
	return out, req.Send()
}

// DeleteMountTargetWithContext is the same as DeleteMountTarget with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMountTarget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) DeleteMountTargetWithContext(ctx aws.Context, input *DeleteMountTargetInput, opts ...request.Option) (*DeleteMountTargetOutput, error) {
	req, out := c.DeleteMountTargetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReplicationConfiguration = "DeleteReplicationConfiguration"

// DeleteReplicationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReplicationConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReplicationConfiguration for more information on using the DeleteReplicationConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteReplicationConfigurationRequest method.
//	req, resp := client.DeleteReplicationConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DeleteReplicationConfiguration
func (c *EFS) DeleteReplicationConfigurationRequest(input *DeleteReplicationConfigurationInput) (req *request.Request, output *DeleteReplicationConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteReplicationConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-02-01/file-systems/{SourceFileSystemId}/replication-configuration",
	}

	if input == nil {
		input = &DeleteReplicationConfigurationInput{}
	}

	output = &DeleteReplicationConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteReplicationConfiguration API operation for Amazon Elastic File System.
//
// Deletes an existing replication configuration. Deleting a replication configuration
// ends the replication process. After a replication configuration is deleted,
// the destination file system is no longer read-only. You can write to the
// destination file system after its status becomes Writeable.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation DeleteReplicationConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - FileSystemNotFound
//     Returned if the specified FileSystemId value doesn't exist in the requester's
//     Amazon Web Services account.
//
//   - ReplicationNotFound
//     Returned if the specified file system does not have a replication configuration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DeleteReplicationConfiguration
func (c *EFS) DeleteReplicationConfiguration(input *DeleteReplicationConfigurationInput) (*DeleteReplicationConfigurationOutput, error) {
	req, out := c.DeleteReplicationConfigurationRequest(input)
	return out, req.Send()
}

// DeleteReplicationConfigurationWithContext is the same as DeleteReplicationConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReplicationConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) DeleteReplicationConfigurationWithContext(ctx aws.Context, input *DeleteReplicationConfigurationInput, opts ...request.Option) (*DeleteReplicationConfigurationOutput, error) {
	req, out := c.DeleteReplicationConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTags = "DeleteTags"

// DeleteTagsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTags for more information on using the DeleteTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTagsRequest method.
//	req, resp := client.DeleteTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DeleteTags
//
// Deprecated: Use UntagResource.
func (c *EFS) DeleteTagsRequest(input *DeleteTagsInput) (req *request.Request, output *DeleteTagsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DeleteTags, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDeleteTags,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-02-01/delete-tags/{FileSystemId}",
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	output = &DeleteTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTags API operation for Amazon Elastic File System.
//
// DEPRECATED - DeleteTags is deprecated and not maintained. To remove tags
// from EFS resources, use the API action.
//
// Deletes the specified tags from a file system. If the DeleteTags request
// includes a tag key that doesn't exist, Amazon EFS ignores it and doesn't
// cause an error. For more information about tags and related restrictions,
// see Tag restrictions (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html)
// in the Billing and Cost Management User Guide.
//
// This operation requires permissions for the elasticfilesystem:DeleteTags
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation DeleteTags for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - FileSystemNotFound
//     Returned if the specified FileSystemId value doesn't exist in the requester's
//     Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DeleteTags
//
// Deprecated: Use UntagResource.
func (c *EFS) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	return out, req.Send()
}

// DeleteTagsWithContext is the same as DeleteTags with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Use UntagResource.
func (c *EFS) DeleteTagsWithContext(ctx aws.Context, input *DeleteTagsInput, opts ...request.Option) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccessPoints = "DescribeAccessPoints"

// DescribeAccessPointsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccessPoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccessPoints for more information on using the DescribeAccessPoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAccessPointsRequest method.
//	req, resp := client.DescribeAccessPointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeAccessPoints
func (c *EFS) DescribeAccessPointsRequest(input *DescribeAccessPointsInput) (req *request.Request, output *DescribeAccessPointsOutput) {
	op := &request.Operation{
		Name:       opDescribeAccessPoints,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-02-01/access-points",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAccessPointsInput{}
	}

	output = &DescribeAccessPointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccessPoints API operation for Amazon Elastic File System.
//
// Returns the description of a specific Amazon EFS access point if the AccessPointId
// is provided. If you provide an EFS FileSystemId, it returns descriptions
// of all access points for that file system. You can provide either an AccessPointId
// or a FileSystemId in the request, but not both.
//
// This operation requires permissions for the elasticfilesystem:DescribeAccessPoints
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation DescribeAccessPoints for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - FileSystemNotFound
//     Returned if the specified FileSystemId value doesn't exist in the requester's
//     Amazon Web Services account.
//
//   - AccessPointNotFound
//     Returned if the specified AccessPointId value doesn't exist in the requester's
//     Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeAccessPoints
func (c *EFS) DescribeAccessPoints(input *DescribeAccessPointsInput) (*DescribeAccessPointsOutput, error) {
	req, out := c.DescribeAccessPointsRequest(input)
	return out, req.Send()
}

// DescribeAccessPointsWithContext is the same as DescribeAccessPoints with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccessPoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) DescribeAccessPointsWithContext(ctx aws.Context, input *DescribeAccessPointsInput, opts ...request.Option) (*DescribeAccessPointsOutput, error) {
	req, out := c.DescribeAccessPointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAccessPointsPages iterates over the pages of a DescribeAccessPoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAccessPoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeAccessPoints operation.
//	pageNum := 0
//	err := client.DescribeAccessPointsPages(params,
//	    func(page *efs.DescribeAccessPointsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EFS) DescribeAccessPointsPages(input *DescribeAccessPointsInput, fn func(*DescribeAccessPointsOutput, bool) bool) error {
	return c.DescribeAccessPointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAccessPointsPagesWithContext same as DescribeAccessPointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) DescribeAccessPointsPagesWithContext(ctx aws.Context, input *DescribeAccessPointsInput, fn func(*DescribeAccessPointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAccessPointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAccessPointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAccessPointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeAccountPreferences = "DescribeAccountPreferences"

// DescribeAccountPreferencesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountPreferences operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountPreferences for more information on using the DescribeAccountPreferences
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAccountPreferencesRequest method.
//	req, resp := client.DescribeAccountPreferencesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeAccountPreferences
func (c *EFS) DescribeAccountPreferencesRequest(input *DescribeAccountPreferencesInput) (req *request.Request, output *DescribeAccountPreferencesOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountPreferences,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-02-01/account-preferences",
	}

	if input == nil {
		input = &DescribeAccountPreferencesInput{}
	}

	output = &DescribeAccountPreferencesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountPreferences API operation for Amazon Elastic File System.
//
// Returns the account preferences settings for the Amazon Web Services account
// associated with the user making the request, in the current Amazon Web Services
// Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation DescribeAccountPreferences for usage and error information.
//
// Returned Error Types:
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeAccountPreferences
func (c *EFS) DescribeAccountPreferences(input *DescribeAccountPreferencesInput) (*DescribeAccountPreferencesOutput, error) {
	req, out := c.DescribeAccountPreferencesRequest(input)
	return out, req.Send()
}

// DescribeAccountPreferencesWithContext is the same as DescribeAccountPreferences with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountPreferences for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) DescribeAccountPreferencesWithContext(ctx aws.Context, input *DescribeAccountPreferencesInput, opts ...request.Option) (*DescribeAccountPreferencesOutput, error) {
	req, out := c.DescribeAccountPreferencesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBackupPolicy = "DescribeBackupPolicy"

// DescribeBackupPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBackupPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBackupPolicy for more information on using the DescribeBackupPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeBackupPolicyRequest method.
//	req, resp := client.DescribeBackupPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeBackupPolicy
func (c *EFS) DescribeBackupPolicyRequest(input *DescribeBackupPolicyInput) (req *request.Request, output *DescribeBackupPolicyOutput) {
	op := &request.Operation{
		Name:       opDescribeBackupPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-02-01/file-systems/{FileSystemId}/backup-policy",
	}

	if input == nil {
		input = &DescribeBackupPolicyInput{}
	}

	output = &DescribeBackupPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBackupPolicy API operation for Amazon Elastic File System.
//
// Returns the backup policy for the specified EFS file system.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation DescribeBackupPolicy for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - FileSystemNotFound
//     Returned if the specified FileSystemId value doesn't exist in the requester's
//     Amazon Web Services account.
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - PolicyNotFound
//     Returned if the default file system policy is in effect for the EFS file
//     system specified.
//
//   - ValidationException
//     Returned if the Backup service is not available in the Amazon Web Services
//     Region in which the request was made.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeBackupPolicy
func (c *EFS) DescribeBackupPolicy(input *DescribeBackupPolicyInput) (*DescribeBackupPolicyOutput, error) {
	req, out := c.DescribeBackupPolicyRequest(input)
	return out, req.Send()
}

// DescribeBackupPolicyWithContext is the same as DescribeBackupPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBackupPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) DescribeBackupPolicyWithContext(ctx aws.Context, input *DescribeBackupPolicyInput, opts ...request.Option) (*DescribeBackupPolicyOutput, error) {
	req, out := c.DescribeBackupPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFileSystemPolicy = "DescribeFileSystemPolicy"

// DescribeFileSystemPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFileSystemPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFileSystemPolicy for more information on using the DescribeFileSystemPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFileSystemPolicyRequest method.
//	req, resp := client.DescribeFileSystemPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeFileSystemPolicy
func (c *EFS) DescribeFileSystemPolicyRequest(input *DescribeFileSystemPolicyInput) (req *request.Request, output *DescribeFileSystemPolicyOutput) {
	op := &request.Operation{
		Name:       opDescribeFileSystemPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-02-01/file-systems/{FileSystemId}/policy",
	}

	if input == nil {
		input = &DescribeFileSystemPolicyInput{}
	}

	output = &DescribeFileSystemPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFileSystemPolicy API operation for Amazon Elastic File System.
//
// Returns the FileSystemPolicy for the specified EFS file system.
//
// This operation requires permissions for the elasticfilesystem:DescribeFileSystemPolicy
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation DescribeFileSystemPolicy for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - FileSystemNotFound
//     Returned if the specified FileSystemId value doesn't exist in the requester's
//     Amazon Web Services account.
//
//   - PolicyNotFound
//     Returned if the default file system policy is in effect for the EFS file
//     system specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeFileSystemPolicy
func (c *EFS) DescribeFileSystemPolicy(input *DescribeFileSystemPolicyInput) (*DescribeFileSystemPolicyOutput, error) {
	req, out := c.DescribeFileSystemPolicyRequest(input)
	return out, req.Send()
}

// DescribeFileSystemPolicyWithContext is the same as DescribeFileSystemPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFileSystemPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) DescribeFileSystemPolicyWithContext(ctx aws.Context, input *DescribeFileSystemPolicyInput, opts ...request.Option) (*DescribeFileSystemPolicyOutput, error) {
	req, out := c.DescribeFileSystemPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFileSystems = "DescribeFileSystems"

// DescribeFileSystemsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFileSystems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFileSystems for more information on using the DescribeFileSystems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFileSystemsRequest method.
//	req, resp := client.DescribeFileSystemsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeFileSystems
func (c *EFS) DescribeFileSystemsRequest(input *DescribeFileSystemsInput) (req *request.Request, output *DescribeFileSystemsOutput) {
	op := &request.Operation{
		Name:       opDescribeFileSystems,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-02-01/file-systems",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeFileSystemsInput{}
	}

	output = &DescribeFileSystemsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFileSystems API operation for Amazon Elastic File System.
//
// Returns the description of a specific Amazon EFS file system if either the
// file system CreationToken or the FileSystemId is provided. Otherwise, it
// returns descriptions of all file systems owned by the caller's Amazon Web
// Services account in the Amazon Web Services Region of the endpoint that you're
// calling.
//
// When retrieving all file system descriptions, you can optionally specify
// the MaxItems parameter to limit the number of descriptions in a response.
// This number is automatically set to 100. If more file system descriptions
// remain, Amazon EFS returns a NextMarker, an opaque token, in the response.
// In this case, you should send a subsequent request with the Marker request
// parameter set to the value of NextMarker.
//
// To retrieve a list of your file system descriptions, this operation is used
// in an iterative process, where DescribeFileSystems is called first without
// the Marker and then the operation continues to call it with the Marker parameter
// set to the value of the NextMarker from the previous response until the response
// has no NextMarker.
//
// The order of file systems returned in the response of one DescribeFileSystems
// call and the order of file systems returned across the responses of a multi-call
// iteration is unspecified.
//
// This operation requires permissions for the elasticfilesystem:DescribeFileSystems
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation DescribeFileSystems for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - FileSystemNotFound
//     Returned if the specified FileSystemId value doesn't exist in the requester's
//     Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeFileSystems
func (c *EFS) DescribeFileSystems(input *DescribeFileSystemsInput) (*DescribeFileSystemsOutput, error) {
	req, out := c.DescribeFileSystemsRequest(input)
	return out, req.Send()
}

// DescribeFileSystemsWithContext is the same as DescribeFileSystems with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFileSystems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) DescribeFileSystemsWithContext(ctx aws.Context, input *DescribeFileSystemsInput, opts ...request.Option) (*DescribeFileSystemsOutput, error) {
	req, out := c.DescribeFileSystemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeFileSystemsPages iterates over the pages of a DescribeFileSystems operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeFileSystems method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeFileSystems operation.
//	pageNum := 0
//	err := client.DescribeFileSystemsPages(params,
//	    func(page *efs.DescribeFileSystemsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EFS) DescribeFileSystemsPages(input *DescribeFileSystemsInput, fn func(*DescribeFileSystemsOutput, bool) bool) error {
	return c.DescribeFileSystemsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeFileSystemsPagesWithContext same as DescribeFileSystemsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) DescribeFileSystemsPagesWithContext(ctx aws.Context, input *DescribeFileSystemsInput, fn func(*DescribeFileSystemsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeFileSystemsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeFileSystemsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeFileSystemsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeLifecycleConfiguration = "DescribeLifecycleConfiguration"

// DescribeLifecycleConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLifecycleConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLifecycleConfiguration for more information on using the DescribeLifecycleConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeLifecycleConfigurationRequest method.
//	req, resp := client.DescribeLifecycleConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeLifecycleConfiguration
func (c *EFS) DescribeLifecycleConfigurationRequest(input *DescribeLifecycleConfigurationInput) (req *request.Request, output *DescribeLifecycleConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeLifecycleConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-02-01/file-systems/{FileSystemId}/lifecycle-configuration",
	}

	if input == nil {
		input = &DescribeLifecycleConfigurationInput{}
	}

	output = &DescribeLifecycleConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLifecycleConfiguration API operation for Amazon Elastic File System.
//
// Returns the current LifecycleConfiguration object for the specified Amazon
// EFS file system. EFS lifecycle management uses the LifecycleConfiguration
// object to identify which files to move to the EFS Infrequent Access (IA)
// storage class. For a file system without a LifecycleConfiguration object,
// the call returns an empty array in the response.
//
// When EFS Intelligent-Tiering is enabled, TransitionToPrimaryStorageClass
// has a value of AFTER_1_ACCESS.
//
// This operation requires permissions for the elasticfilesystem:DescribeLifecycleConfiguration
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation DescribeLifecycleConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - FileSystemNotFound
//     Returned if the specified FileSystemId value doesn't exist in the requester's
//     Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeLifecycleConfiguration
func (c *EFS) DescribeLifecycleConfiguration(input *DescribeLifecycleConfigurationInput) (*DescribeLifecycleConfigurationOutput, error) {
	req, out := c.DescribeLifecycleConfigurationRequest(input)
	return out, req.Send()
}

// DescribeLifecycleConfigurationWithContext is the same as DescribeLifecycleConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLifecycleConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) DescribeLifecycleConfigurationWithContext(ctx aws.Context, input *DescribeLifecycleConfigurationInput, opts ...request.Option) (*DescribeLifecycleConfigurationOutput, error) {
	req, out := c.DescribeLifecycleConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMountTargetSecurityGroups = "DescribeMountTargetSecurityGroups"

// DescribeMountTargetSecurityGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMountTargetSecurityGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMountTargetSecurityGroups for more information on using the DescribeMountTargetSecurityGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeMountTargetSecurityGroupsRequest method.
//	req, resp := client.DescribeMountTargetSecurityGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeMountTargetSecurityGroups
func (c *EFS) DescribeMountTargetSecurityGroupsRequest(input *DescribeMountTargetSecurityGroupsInput) (req *request.Request, output *DescribeMountTargetSecurityGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeMountTargetSecurityGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-02-01/mount-targets/{MountTargetId}/security-groups",
	}

	if input == nil {
		input = &DescribeMountTargetSecurityGroupsInput{}
	}

	output = &DescribeMountTargetSecurityGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMountTargetSecurityGroups API operation for Amazon Elastic File System.
//
// Returns the security groups currently in effect for a mount target. This
// operation requires that the network interface of the mount target has been
// created and the lifecycle state of the mount target is not deleted.
//
// This operation requires permissions for the following actions:
//
//   - elasticfilesystem:DescribeMountTargetSecurityGroups action on the mount
//     target's file system.
//
//   - ec2:DescribeNetworkInterfaceAttribute action on the mount target's network
//     interface.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation DescribeMountTargetSecurityGroups for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - MountTargetNotFound
//     Returned if there is no mount target with the specified ID found in the caller's
//     Amazon Web Services account.
//
//   - IncorrectMountTargetState
//     Returned if the mount target is not in the correct state for the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeMountTargetSecurityGroups
func (c *EFS) DescribeMountTargetSecurityGroups(input *DescribeMountTargetSecurityGroupsInput) (*DescribeMountTargetSecurityGroupsOutput, error) {
	req, out := c.DescribeMountTargetSecurityGroupsRequest(input)
	return out, req.Send()
}

// DescribeMountTargetSecurityGroupsWithContext is the same as DescribeMountTargetSecurityGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMountTargetSecurityGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) DescribeMountTargetSecurityGroupsWithContext(ctx aws.Context, input *DescribeMountTargetSecurityGroupsInput, opts ...request.Option) (*DescribeMountTargetSecurityGroupsOutput, error) {
	req, out := c.DescribeMountTargetSecurityGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMountTargets = "DescribeMountTargets"

// DescribeMountTargetsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMountTargets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMountTargets for more information on using the DescribeMountTargets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeMountTargetsRequest method.
//	req, resp := client.DescribeMountTargetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeMountTargets
func (c *EFS) DescribeMountTargetsRequest(input *DescribeMountTargetsInput) (req *request.Request, output *DescribeMountTargetsOutput) {
	op := &request.Operation{
		Name:       opDescribeMountTargets,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-02-01/mount-targets",
	}

	if input == nil {
		input = &DescribeMountTargetsInput{}
	}

	output = &DescribeMountTargetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMountTargets API operation for Amazon Elastic File System.
//
// Returns the descriptions of all the current mount targets, or a specific
// mount target, for a file system. When requesting all of the current mount
// targets, the order of mount targets returned in the response is unspecified.
//
// This operation requires permissions for the elasticfilesystem:DescribeMountTargets
// action, on either the file system ID that you specify in FileSystemId, or
// on the file system of the mount target that you specify in MountTargetId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation DescribeMountTargets for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - FileSystemNotFound
//     Returned if the specified FileSystemId value doesn't exist in the requester's
//     Amazon Web Services account.
//
//   - MountTargetNotFound
//     Returned if there is no mount target with the specified ID found in the caller's
//     Amazon Web Services account.
//
//   - AccessPointNotFound
//     Returned if the specified AccessPointId value doesn't exist in the requester's
//     Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeMountTargets
func (c *EFS) DescribeMountTargets(input *DescribeMountTargetsInput) (*DescribeMountTargetsOutput, error) {
	req, out := c.DescribeMountTargetsRequest(input)
	return out, req.Send()
}

// DescribeMountTargetsWithContext is the same as DescribeMountTargets with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMountTargets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) DescribeMountTargetsWithContext(ctx aws.Context, input *DescribeMountTargetsInput, opts ...request.Option) (*DescribeMountTargetsOutput, error) {
	req, out := c.DescribeMountTargetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeReplicationConfigurations = "DescribeReplicationConfigurations"

// DescribeReplicationConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReplicationConfigurations for more information on using the DescribeReplicationConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeReplicationConfigurationsRequest method.
//	req, resp := client.DescribeReplicationConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeReplicationConfigurations
func (c *EFS) DescribeReplicationConfigurationsRequest(input *DescribeReplicationConfigurationsInput) (req *request.Request, output *DescribeReplicationConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationConfigurations,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-02-01/file-systems/replication-configurations",
	}

	if input == nil {
		input = &DescribeReplicationConfigurationsInput{}
	}

	output = &DescribeReplicationConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReplicationConfigurations API operation for Amazon Elastic File System.
//
// Retrieves the replication configuration for a specific file system. If a
// file system is not specified, all of the replication configurations for the
// Amazon Web Services account in an Amazon Web Services Region are retrieved.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation DescribeReplicationConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - FileSystemNotFound
//     Returned if the specified FileSystemId value doesn't exist in the requester's
//     Amazon Web Services account.
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - ReplicationNotFound
//     Returned if the specified file system does not have a replication configuration.
//
//   - ValidationException
//     Returned if the Backup service is not available in the Amazon Web Services
//     Region in which the request was made.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeReplicationConfigurations
func (c *EFS) DescribeReplicationConfigurations(input *DescribeReplicationConfigurationsInput) (*DescribeReplicationConfigurationsOutput, error) {
	req, out := c.DescribeReplicationConfigurationsRequest(input)
	return out, req.Send()
}

// DescribeReplicationConfigurationsWithContext is the same as DescribeReplicationConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReplicationConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) DescribeReplicationConfigurationsWithContext(ctx aws.Context, input *DescribeReplicationConfigurationsInput, opts ...request.Option) (*DescribeReplicationConfigurationsOutput, error) {
	req, out := c.DescribeReplicationConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTags = "DescribeTags"

// DescribeTagsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTags for more information on using the DescribeTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTagsRequest method.
//	req, resp := client.DescribeTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeTags
//
// Deprecated: Use ListTagsForResource.
func (c *EFS) DescribeTagsRequest(input *DescribeTagsInput) (req *request.Request, output *DescribeTagsOutput) {
	if c.Client.Config.Logger != nil {
		c.Client.Config.Logger.Log("This operation, DescribeTags, has been deprecated")
	}
	op := &request.Operation{
		Name:       opDescribeTags,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-02-01/tags/{FileSystemId}/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTagsInput{}
	}

	output = &DescribeTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTags API operation for Amazon Elastic File System.
//
// DEPRECATED - The DescribeTags action is deprecated and not maintained. To
// view tags associated with EFS resources, use the ListTagsForResource API
// action.
//
// Returns the tags associated with a file system. The order of tags returned
// in the response of one DescribeTags call and the order of tags returned across
// the responses of a multiple-call iteration (when using pagination) is unspecified.
//
// This operation requires permissions for the elasticfilesystem:DescribeTags
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation DescribeTags for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - FileSystemNotFound
//     Returned if the specified FileSystemId value doesn't exist in the requester's
//     Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/DescribeTags
//
// Deprecated: Use ListTagsForResource.
func (c *EFS) DescribeTags(input *DescribeTagsInput) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	return out, req.Send()
}

// DescribeTagsWithContext is the same as DescribeTags with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Use ListTagsForResource.
func (c *EFS) DescribeTagsWithContext(ctx aws.Context, input *DescribeTagsInput, opts ...request.Option) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeTagsPages iterates over the pages of a DescribeTags operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeTags method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeTags operation.
//	pageNum := 0
//	err := client.DescribeTagsPages(params,
//	    func(page *efs.DescribeTagsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
//
// Deprecated: Use ListTagsForResource.
func (c *EFS) DescribeTagsPages(input *DescribeTagsInput, fn func(*DescribeTagsOutput, bool) bool) error {
	return c.DescribeTagsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeTagsPagesWithContext same as DescribeTagsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
//
// Deprecated: Use ListTagsForResource.
func (c *EFS) DescribeTagsPagesWithContext(ctx aws.Context, input *DescribeTagsInput, fn func(*DescribeTagsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeTagsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeTagsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeTagsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/ListTagsForResource
func (c *EFS) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-02-01/resource-tags/{ResourceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Elastic File System.
//
// Lists all tags for a top-level EFS resource. You must provide the ID of the
// resource that you want to retrieve the tags for.
//
// This operation requires permissions for the elasticfilesystem:DescribeAccessPoints
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - FileSystemNotFound
//     Returned if the specified FileSystemId value doesn't exist in the requester's
//     Amazon Web Services account.
//
//   - AccessPointNotFound
//     Returned if the specified AccessPointId value doesn't exist in the requester's
//     Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/ListTagsForResource
func (c *EFS) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsForResourcePages iterates over the pages of a ListTagsForResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTagsForResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTagsForResource operation.
//	pageNum := 0
//	err := client.ListTagsForResourcePages(params,
//	    func(page *efs.ListTagsForResourceOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EFS) ListTagsForResourcePages(input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool) error {
	return c.ListTagsForResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsForResourcePagesWithContext same as ListTagsForResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) ListTagsForResourcePagesWithContext(ctx aws.Context, input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsForResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsForResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsForResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opModifyMountTargetSecurityGroups = "ModifyMountTargetSecurityGroups"

// ModifyMountTargetSecurityGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ModifyMountTargetSecurityGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyMountTargetSecurityGroups for more information on using the ModifyMountTargetSecurityGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ModifyMountTargetSecurityGroupsRequest method.
//	req, resp := client.ModifyMountTargetSecurityGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/ModifyMountTargetSecurityGroups
func (c *EFS) ModifyMountTargetSecurityGroupsRequest(input *ModifyMountTargetSecurityGroupsInput) (req *request.Request, output *ModifyMountTargetSecurityGroupsOutput) {
	op := &request.Operation{
		Name:       opModifyMountTargetSecurityGroups,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-02-01/mount-targets/{MountTargetId}/security-groups",
	}

	if input == nil {
		input = &ModifyMountTargetSecurityGroupsInput{}
	}

	output = &ModifyMountTargetSecurityGroupsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyMountTargetSecurityGroups API operation for Amazon Elastic File System.
//
// Modifies the set of security groups in effect for a mount target.
//
// When you create a mount target, Amazon EFS also creates a new network interface.
// For more information, see CreateMountTarget. This operation replaces the
// security groups in effect for the network interface associated with a mount
// target, with the SecurityGroups provided in the request. This operation requires
// that the network interface of the mount target has been created and the lifecycle
// state of the mount target is not deleted.
//
// The operation requires permissions for the following actions:
//
//   - elasticfilesystem:ModifyMountTargetSecurityGroups action on the mount
//     target's file system.
//
//   - ec2:ModifyNetworkInterfaceAttribute action on the mount target's network
//     interface.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation ModifyMountTargetSecurityGroups for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - MountTargetNotFound
//     Returned if there is no mount target with the specified ID found in the caller's
//     Amazon Web Services account.
//
//   - IncorrectMountTargetState
//     Returned if the mount target is not in the correct state for the operation.
//
//   - SecurityGroupLimitExceeded
//     Returned if the size of SecurityGroups specified in the request is greater
//     than five.
//
//   - SecurityGroupNotFound
//     Returned if one of the specified security groups doesn't exist in the subnet's
//     virtual private cloud (VPC).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/ModifyMountTargetSecurityGroups
func (c *EFS) ModifyMountTargetSecurityGroups(input *ModifyMountTargetSecurityGroupsInput) (*ModifyMountTargetSecurityGroupsOutput, error) {
	req, out := c.ModifyMountTargetSecurityGroupsRequest(input)
	return out, req.Send()
}

// ModifyMountTargetSecurityGroupsWithContext is the same as ModifyMountTargetSecurityGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyMountTargetSecurityGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) ModifyMountTargetSecurityGroupsWithContext(ctx aws.Context, input *ModifyMountTargetSecurityGroupsInput, opts ...request.Option) (*ModifyMountTargetSecurityGroupsOutput, error) {
	req, out := c.ModifyMountTargetSecurityGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutAccountPreferences = "PutAccountPreferences"

// PutAccountPreferencesRequest generates a "aws/request.Request" representing the
// client's request for the PutAccountPreferences operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutAccountPreferences for more information on using the PutAccountPreferences
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutAccountPreferencesRequest method.
//	req, resp := client.PutAccountPreferencesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/PutAccountPreferences
func (c *EFS) PutAccountPreferencesRequest(input *PutAccountPreferencesInput) (req *request.Request, output *PutAccountPreferencesOutput) {
	op := &request.Operation{
		Name:       opPutAccountPreferences,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-02-01/account-preferences",
	}

	if input == nil {
		input = &PutAccountPreferencesInput{}
	}

	output = &PutAccountPreferencesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutAccountPreferences API operation for Amazon Elastic File System.
//
// Use this operation to set the account preference in the current Amazon Web
// Services Region to use long 17 character (63 bit) or short 8 character (32
// bit) resource IDs for new EFS file system and mount target resources. All
// existing resource IDs are not affected by any changes you make. You can set
// the ID preference during the opt-in period as EFS transitions to long resource
// IDs. For more information, see Managing Amazon EFS resource IDs (https://docs.aws.amazon.com/efs/latest/ug/manage-efs-resource-ids.html).
//
// Starting in October, 2021, you will receive an error if you try to set the
// account preference to use the short 8 character format resource ID. Contact
// Amazon Web Services support if you receive an error and must use short IDs
// for file system and mount target resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation PutAccountPreferences for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/PutAccountPreferences
func (c *EFS) PutAccountPreferences(input *PutAccountPreferencesInput) (*PutAccountPreferencesOutput, error) {
	req, out := c.PutAccountPreferencesRequest(input)
	return out, req.Send()
}

// PutAccountPreferencesWithContext is the same as PutAccountPreferences with the addition of
// the ability to pass a context and additional request options.
//
// See PutAccountPreferences for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) PutAccountPreferencesWithContext(ctx aws.Context, input *PutAccountPreferencesInput, opts ...request.Option) (*PutAccountPreferencesOutput, error) {
	req, out := c.PutAccountPreferencesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBackupPolicy = "PutBackupPolicy"

// PutBackupPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutBackupPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBackupPolicy for more information on using the PutBackupPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBackupPolicyRequest method.
//	req, resp := client.PutBackupPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/PutBackupPolicy
func (c *EFS) PutBackupPolicyRequest(input *PutBackupPolicyInput) (req *request.Request, output *PutBackupPolicyOutput) {
	op := &request.Operation{
		Name:       opPutBackupPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-02-01/file-systems/{FileSystemId}/backup-policy",
	}

	if input == nil {
		input = &PutBackupPolicyInput{}
	}

	output = &PutBackupPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutBackupPolicy API operation for Amazon Elastic File System.
//
// Updates the file system's backup policy. Use this action to start or stop
// automatic backups of the file system.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation PutBackupPolicy for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - FileSystemNotFound
//     Returned if the specified FileSystemId value doesn't exist in the requester's
//     Amazon Web Services account.
//
//   - IncorrectFileSystemLifeCycleState
//     Returned if the file system's lifecycle state is not "available".
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - ValidationException
//     Returned if the Backup service is not available in the Amazon Web Services
//     Region in which the request was made.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/PutBackupPolicy
func (c *EFS) PutBackupPolicy(input *PutBackupPolicyInput) (*PutBackupPolicyOutput, error) {
	req, out := c.PutBackupPolicyRequest(input)
	return out, req.Send()
}

// PutBackupPolicyWithContext is the same as PutBackupPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutBackupPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) PutBackupPolicyWithContext(ctx aws.Context, input *PutBackupPolicyInput, opts ...request.Option) (*PutBackupPolicyOutput, error) {
	req, out := c.PutBackupPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutFileSystemPolicy = "PutFileSystemPolicy"

// PutFileSystemPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutFileSystemPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutFileSystemPolicy for more information on using the PutFileSystemPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutFileSystemPolicyRequest method.
//	req, resp := client.PutFileSystemPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/PutFileSystemPolicy
func (c *EFS) PutFileSystemPolicyRequest(input *PutFileSystemPolicyInput) (req *request.Request, output *PutFileSystemPolicyOutput) {
	op := &request.Operation{
		Name:       opPutFileSystemPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-02-01/file-systems/{FileSystemId}/policy",
	}

	if input == nil {
		input = &PutFileSystemPolicyInput{}
	}

	output = &PutFileSystemPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutFileSystemPolicy API operation for Amazon Elastic File System.
//
// Applies an Amazon EFS FileSystemPolicy to an Amazon EFS file system. A file
// system policy is an IAM resource-based policy and can contain multiple policy
// statements. A file system always has exactly one file system policy, which
// can be the default policy or an explicit policy set or updated using this
// API operation. EFS file system policies have a 20,000 character limit. When
// an explicit policy is set, it overrides the default policy. For more information
// about the default file system policy, see Default EFS File System Policy
// (https://docs.aws.amazon.com/efs/latest/ug/iam-access-control-nfs-efs.html#default-filesystempolicy).
//
// EFS file system policies have a 20,000 character limit.
//
// This operation requires permissions for the elasticfilesystem:PutFileSystemPolicy
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation PutFileSystemPolicy for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - FileSystemNotFound
//     Returned if the specified FileSystemId value doesn't exist in the requester's
//     Amazon Web Services account.
//
//   - InvalidPolicyException
//     Returned if the FileSystemPolicy is malformed or contains an error such as
//     a parameter value that is not valid or a missing required parameter. Returned
//     in the case of a policy lockout safety check error.
//
//   - IncorrectFileSystemLifeCycleState
//     Returned if the file system's lifecycle state is not "available".
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/PutFileSystemPolicy
func (c *EFS) PutFileSystemPolicy(input *PutFileSystemPolicyInput) (*PutFileSystemPolicyOutput, error) {
	req, out := c.PutFileSystemPolicyRequest(input)
	return out, req.Send()
}

// PutFileSystemPolicyWithContext is the same as PutFileSystemPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutFileSystemPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) PutFileSystemPolicyWithContext(ctx aws.Context, input *PutFileSystemPolicyInput, opts ...request.Option) (*PutFileSystemPolicyOutput, error) {
	req, out := c.PutFileSystemPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutLifecycleConfiguration = "PutLifecycleConfiguration"

// PutLifecycleConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutLifecycleConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutLifecycleConfiguration for more information on using the PutLifecycleConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutLifecycleConfigurationRequest method.
//	req, resp := client.PutLifecycleConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/PutLifecycleConfiguration
func (c *EFS) PutLifecycleConfigurationRequest(input *PutLifecycleConfigurationInput) (req *request.Request, output *PutLifecycleConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutLifecycleConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-02-01/file-systems/{FileSystemId}/lifecycle-configuration",
	}

	if input == nil {
		input = &PutLifecycleConfigurationInput{}
	}

	output = &PutLifecycleConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutLifecycleConfiguration API operation for Amazon Elastic File System.
//
// Use this action to manage EFS lifecycle management and EFS Intelligent-Tiering.
// A LifecycleConfiguration consists of one or more LifecyclePolicy objects
// that define the following:
//
//   - EFS Lifecycle management - When Amazon EFS automatically transitions
//     files in a file system into the lower-cost EFS Infrequent Access (IA)
//     storage class. To enable EFS Lifecycle management, set the value of TransitionToIA
//     to one of the available options.
//
//   - EFS Intelligent-Tiering - When Amazon EFS automatically transitions
//     files from IA back into the file system's primary storage class (EFS Standard
//     or EFS One Zone Standard). To enable EFS Intelligent-Tiering, set the
//     value of TransitionToPrimaryStorageClass to AFTER_1_ACCESS.
//
// For more information, see EFS Lifecycle Management (https://docs.aws.amazon.com/efs/latest/ug/lifecycle-management-efs.html).
//
// Each Amazon EFS file system supports one lifecycle configuration, which applies
// to all files in the file system. If a LifecycleConfiguration object already
// exists for the specified file system, a PutLifecycleConfiguration call modifies
// the existing configuration. A PutLifecycleConfiguration call with an empty
// LifecyclePolicies array in the request body deletes any existing LifecycleConfiguration
// and turns off lifecycle management and EFS Intelligent-Tiering for the file
// system.
//
// In the request, specify the following:
//
//   - The ID for the file system for which you are enabling, disabling, or
//     modifying lifecycle management and EFS Intelligent-Tiering.
//
//   - A LifecyclePolicies array of LifecyclePolicy objects that define when
//     files are moved into IA storage, and when they are moved back to Standard
//     storage. Amazon EFS requires that each LifecyclePolicy object have only
//     have a single transition, so the LifecyclePolicies array needs to be structured
//     with separate LifecyclePolicy objects. See the example requests in the
//     following section for more information.
//
// This operation requires permissions for the elasticfilesystem:PutLifecycleConfiguration
// operation.
//
// To apply a LifecycleConfiguration object to an encrypted file system, you
// need the same Key Management Service permissions as when you created the
// encrypted file system.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation PutLifecycleConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - FileSystemNotFound
//     Returned if the specified FileSystemId value doesn't exist in the requester's
//     Amazon Web Services account.
//
//   - IncorrectFileSystemLifeCycleState
//     Returned if the file system's lifecycle state is not "available".
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/PutLifecycleConfiguration
func (c *EFS) PutLifecycleConfiguration(input *PutLifecycleConfigurationInput) (*PutLifecycleConfigurationOutput, error) {
	req, out := c.PutLifecycleConfigurationRequest(input)
	return out, req.Send()
}

// PutLifecycleConfigurationWithContext is the same as PutLifecycleConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutLifecycleConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) PutLifecycleConfigurationWithContext(ctx aws.Context, input *PutLifecycleConfigurationInput, opts ...request.Option) (*PutLifecycleConfigurationOutput, error) {
	req, out := c.PutLifecycleConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/TagResource
func (c *EFS) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-02-01/resource-tags/{ResourceId}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Elastic File System.
//
// Creates a tag for an EFS resource. You can create tags for EFS file systems
// and access points using this API operation.
//
// This operation requires permissions for the elasticfilesystem:TagResource
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - FileSystemNotFound
//     Returned if the specified FileSystemId value doesn't exist in the requester's
//     Amazon Web Services account.
//
//   - AccessPointNotFound
//     Returned if the specified AccessPointId value doesn't exist in the requester's
//     Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/TagResource
func (c *EFS) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/UntagResource
func (c *EFS) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-02-01/resource-tags/{ResourceId}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Elastic File System.
//
// Removes tags from an EFS resource. You can remove tags from EFS file systems
// and access points using this API operation.
//
// This operation requires permissions for the elasticfilesystem:UntagResource
// action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - FileSystemNotFound
//     Returned if the specified FileSystemId value doesn't exist in the requester's
//     Amazon Web Services account.
//
//   - AccessPointNotFound
//     Returned if the specified AccessPointId value doesn't exist in the requester's
//     Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/UntagResource
func (c *EFS) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFileSystem = "UpdateFileSystem"

// UpdateFileSystemRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFileSystem operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFileSystem for more information on using the UpdateFileSystem
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFileSystemRequest method.
//	req, resp := client.UpdateFileSystemRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/UpdateFileSystem
func (c *EFS) UpdateFileSystemRequest(input *UpdateFileSystemInput) (req *request.Request, output *UpdateFileSystemOutput) {
	op := &request.Operation{
		Name:       opUpdateFileSystem,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-02-01/file-systems/{FileSystemId}",
	}

	if input == nil {
		input = &UpdateFileSystemInput{}
	}

	output = &UpdateFileSystemOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFileSystem API operation for Amazon Elastic File System.
//
// Updates the throughput mode or the amount of provisioned throughput of an
// existing file system.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic File System's
// API operation UpdateFileSystem for usage and error information.
//
// Returned Error Types:
//
//   - BadRequest
//     Returned if the request is malformed or contains an error such as an invalid
//     parameter value or a missing required parameter.
//
//   - FileSystemNotFound
//     Returned if the specified FileSystemId value doesn't exist in the requester's
//     Amazon Web Services account.
//
//   - IncorrectFileSystemLifeCycleState
//     Returned if the file system's lifecycle state is not "available".
//
//   - InsufficientThroughputCapacity
//     Returned if there's not enough capacity to provision additional throughput.
//     This value might be returned when you try to create a file system in provisioned
//     throughput mode, when you attempt to increase the provisioned throughput
//     of an existing file system, or when you attempt to change an existing file
//     system from Bursting Throughput to Provisioned Throughput mode. Try again
//     later.
//
//   - InternalServerError
//     Returned if an error occurred on the server side.
//
//   - ThroughputLimitExceeded
//     Returned if the throughput mode or amount of provisioned throughput can't
//     be changed because the throughput limit of 1024 MiB/s has been reached.
//
//   - TooManyRequests
//     Returned if you don’t wait at least 24 hours before either changing the
//     throughput mode, or decreasing the Provisioned Throughput value.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/UpdateFileSystem
func (c *EFS) UpdateFileSystem(input *UpdateFileSystemInput) (*UpdateFileSystemOutput, error) {
	req, out := c.UpdateFileSystemRequest(input)
	return out, req.Send()
}

// UpdateFileSystemWithContext is the same as UpdateFileSystem with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFileSystem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EFS) UpdateFileSystemWithContext(ctx aws.Context, input *UpdateFileSystemInput, opts ...request.Option) (*UpdateFileSystemOutput, error) {
	req, out := c.UpdateFileSystemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Returned if the access point that you are trying to create already exists,
// with the creation token you provided in the request.
type AccessPointAlreadyExists struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// AccessPointId is a required field
	AccessPointId *string `type:"string" required:"true"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// ErrorCode is a required field
	ErrorCode *string `min:"1" type:"string" required:"true"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPointAlreadyExists) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPointAlreadyExists) GoString() string {
	return s.String()
}

func newErrorAccessPointAlreadyExists(v protocol.ResponseMetadata) error {
	return &AccessPointAlreadyExists{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessPointAlreadyExists) Code() string {
	return "AccessPointAlreadyExists"
}

// Message returns the exception's message.
func (s *AccessPointAlreadyExists) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessPointAlreadyExists) OrigErr() error {
	return nil
}

func (s *AccessPointAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessPointAlreadyExists) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessPointAlreadyExists) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides a description of an EFS file system access point.
type AccessPointDescription struct {
	_ struct{} `type:"structure"`

	// The unique Amazon Resource Name (ARN) associated with the access point.
	AccessPointArn *string `type:"string"`

	// The ID of the access point, assigned by Amazon EFS.
	AccessPointId *string `type:"string"`

	// The opaque string specified in the request to ensure idempotent creation.
	ClientToken *string `min:"1" type:"string"`

	// The ID of the EFS file system that the access point applies to.
	FileSystemId *string `type:"string"`

	// Identifies the lifecycle phase of the access point.
	LifeCycleState *string `type:"string" enum:"LifeCycleState"`

	// The name of the access point. This is the value of the Name tag.
	Name *string `type:"string"`

	// Identifies the Amazon Web Services account that owns the access point resource.
	OwnerId *string `type:"string"`

	// The full POSIX identity, including the user ID, group ID, and secondary group
	// IDs on the access point that is used for all file operations by NFS clients
	// using the access point.
	PosixUser *PosixUser `type:"structure"`

	// The directory on the Amazon EFS file system that the access point exposes
	// as the root directory to NFS clients using the access point.
	RootDirectory *RootDirectory `type:"structure"`

	// The tags associated with the access point, presented as an array of Tag objects.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPointDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPointDescription) GoString() string {
	return s.String()
}

// SetAccessPointArn sets the AccessPointArn field's value.
func (s *AccessPointDescription) SetAccessPointArn(v string) *AccessPointDescription {
	s.AccessPointArn = &v
	return s
}

// SetAccessPointId sets the AccessPointId field's value.
func (s *AccessPointDescription) SetAccessPointId(v string) *AccessPointDescription {
	s.AccessPointId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *AccessPointDescription) SetClientToken(v string) *AccessPointDescription {
	s.ClientToken = &v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *AccessPointDescription) SetFileSystemId(v string) *AccessPointDescription {
	s.FileSystemId = &v
	return s
}

// SetLifeCycleState sets the LifeCycleState field's value.
func (s *AccessPointDescription) SetLifeCycleState(v string) *AccessPointDescription {
	s.LifeCycleState = &v
	return s
}

// SetName sets the Name field's value.
func (s *AccessPointDescription) SetName(v string) *AccessPointDescription {
	s.Name = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *AccessPointDescription) SetOwnerId(v string) *AccessPointDescription {
	s.OwnerId = &v
	return s
}

// SetPosixUser sets the PosixUser field's value.
func (s *AccessPointDescription) SetPosixUser(v *PosixUser) *AccessPointDescription {
	s.PosixUser = v
	return s
}

// SetRootDirectory sets the RootDirectory field's value.
func (s *AccessPointDescription) SetRootDirectory(v *RootDirectory) *AccessPointDescription {
	s.RootDirectory = v
	return s
}

// SetTags sets the Tags field's value.
func (s *AccessPointDescription) SetTags(v []*Tag) *AccessPointDescription {
	s.Tags = v
	return s
}

// Returned if the Amazon Web Services account has already created the maximum
// number of access points allowed per file system. For more informaton, see
// https://docs.aws.amazon.com/efs/latest/ug/limits.html#limits-efs-resources-per-account-per-region
// (https://docs.aws.amazon.com/efs/latest/ug/limits.html#limits-efs-resources-per-account-per-region).
type AccessPointLimitExceeded struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// ErrorCode is a required field
	ErrorCode *string `min:"1" type:"string" required:"true"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPointLimitExceeded) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPointLimitExceeded) GoString() string {
	return s.String()
}

func newErrorAccessPointLimitExceeded(v protocol.ResponseMetadata) error {
	return &AccessPointLimitExceeded{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessPointLimitExceeded) Code() string {
	return "AccessPointLimitExceeded"
}

// Message returns the exception's message.
func (s *AccessPointLimitExceeded) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessPointLimitExceeded) OrigErr() error {
	return nil
}

func (s *AccessPointLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessPointLimitExceeded) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessPointLimitExceeded) RequestID() string {
	return s.RespMetadata.RequestID
}

// Returned if the specified AccessPointId value doesn't exist in the requester's
// Amazon Web Services account.
type AccessPointNotFound struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// ErrorCode is a required field
	ErrorCode *string `min:"1" type:"string" required:"true"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPointNotFound) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPointNotFound) GoString() string {
	return s.String()
}

func newErrorAccessPointNotFound(v protocol.ResponseMetadata) error {
	return &AccessPointNotFound{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessPointNotFound) Code() string {
	return "AccessPointNotFound"
}

// Message returns the exception's message.
func (s *AccessPointNotFound) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessPointNotFound) OrigErr() error {
	return nil
}

func (s *AccessPointNotFound) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessPointNotFound) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessPointNotFound) RequestID() string {
	return s.RespMetadata.RequestID
}

// Returned if the Availability Zone that was specified for a mount target is
// different from the Availability Zone that was specified for One Zone storage.
// For more information, see Regional and One Zone storage redundancy (https://docs.aws.amazon.com/efs/latest/ug/availability-durability.html).
type AvailabilityZonesMismatch struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	ErrorCode *string `min:"1" type:"string"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AvailabilityZonesMismatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AvailabilityZonesMismatch) GoString() string {
	return s.String()
}

func newErrorAvailabilityZonesMismatch(v protocol.ResponseMetadata) error {
	return &AvailabilityZonesMismatch{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AvailabilityZonesMismatch) Code() string {
	return "AvailabilityZonesMismatch"
}

// Message returns the exception's message.
func (s *AvailabilityZonesMismatch) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AvailabilityZonesMismatch) OrigErr() error {
	return nil
}

func (s *AvailabilityZonesMismatch) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AvailabilityZonesMismatch) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AvailabilityZonesMismatch) RequestID() string {
	return s.RespMetadata.RequestID
}

// The backup policy for the file system used to create automatic daily backups.
// If status has a value of ENABLED, the file system is being automatically
// backed up. For more information, see Automatic backups (https://docs.aws.amazon.com/efs/latest/ug/awsbackup.html#automatic-backups).
type BackupPolicy struct {
	_ struct{} `type:"structure"`

	// Describes the status of the file system's backup policy.
	//
	//    * ENABLED - EFS is automatically backing up the file system.
	//
	//    * ENABLING - EFS is turning on automatic backups for the file system.
	//
	//    * DISABLED - Automatic back ups are turned off for the file system.
	//
	//    * DISABLING - EFS is turning off automatic backups for the file system.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"Status"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackupPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackupPolicy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BackupPolicy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BackupPolicy"}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStatus sets the Status field's value.
func (s *BackupPolicy) SetStatus(v string) *BackupPolicy {
	s.Status = &v
	return s
}

// Returned if the request is malformed or contains an error such as an invalid
// parameter value or a missing required parameter.
type BadRequest struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// ErrorCode is a required field
	ErrorCode *string `min:"1" type:"string" required:"true"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequest) GoString() string {
	return s.String()
}

func newErrorBadRequest(v protocol.ResponseMetadata) error {
	return &BadRequest{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequest) Code() string {
	return "BadRequest"
}

// Message returns the exception's message.
func (s *BadRequest) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequest) OrigErr() error {
	return nil
}

func (s *BadRequest) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequest) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequest) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAccessPointInput struct {
	_ struct{} `type:"structure"`

	// A string of up to 64 ASCII characters that Amazon EFS uses to ensure idempotent
	// creation.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The ID of the EFS file system that the access point provides access to.
	//
	// FileSystemId is a required field
	FileSystemId *string `type:"string" required:"true"`

	// The operating system user and group applied to all file system requests made
	// using the access point.
	PosixUser *PosixUser `type:"structure"`

	// Specifies the directory on the Amazon EFS file system that the access point
	// exposes as the root directory of your file system to NFS clients using the
	// access point. The clients using the access point can only access the root
	// directory and below. If the RootDirectory > Path specified does not exist,
	// EFS creates it and applies the CreationInfo settings when a client connects
	// to an access point. When specifying a RootDirectory, you must provide the
	// Path, and the CreationInfo.
	//
	// Amazon EFS creates a root directory only if you have provided the CreationInfo:
	// OwnUid, OwnGID, and permissions for the directory. If you do not provide
	// this information, Amazon EFS does not create the root directory. If the root
	// directory does not exist, attempts to mount using the access point will fail.
	RootDirectory *RootDirectory `type:"structure"`

	// Creates tags associated with the access point. Each tag is a key-value pair,
	// each key must be unique. For more information, see Tagging Amazon Web Services
	// resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// in the Amazon Web Services General Reference Guide.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccessPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccessPointInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}
	if s.PosixUser != nil {
		if err := s.PosixUser.Validate(); err != nil {
			invalidParams.AddNested("PosixUser", err.(request.ErrInvalidParams))
		}
	}
	if s.RootDirectory != nil {
		if err := s.RootDirectory.Validate(); err != nil {
			invalidParams.AddNested("RootDirectory", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAccessPointInput) SetClientToken(v string) *CreateAccessPointInput {
	s.ClientToken = &v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *CreateAccessPointInput) SetFileSystemId(v string) *CreateAccessPointInput {
	s.FileSystemId = &v
	return s
}

// SetPosixUser sets the PosixUser field's value.
func (s *CreateAccessPointInput) SetPosixUser(v *PosixUser) *CreateAccessPointInput {
	s.PosixUser = v
	return s
}

// SetRootDirectory sets the RootDirectory field's value.
func (s *CreateAccessPointInput) SetRootDirectory(v *RootDirectory) *CreateAccessPointInput {
	s.RootDirectory = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAccessPointInput) SetTags(v []*Tag) *CreateAccessPointInput {
	s.Tags = v
	return s
}

// Provides a description of an EFS file system access point.
type CreateAccessPointOutput struct {
	_ struct{} `type:"structure"`

	// The unique Amazon Resource Name (ARN) associated with the access point.
	AccessPointArn *string `type:"string"`

	// The ID of the access point, assigned by Amazon EFS.
	AccessPointId *string `type:"string"`

	// The opaque string specified in the request to ensure idempotent creation.
	ClientToken *string `min:"1" type:"string"`

	// The ID of the EFS file system that the access point applies to.
	FileSystemId *string `type:"string"`

	// Identifies the lifecycle phase of the access point.
	LifeCycleState *string `type:"string" enum:"LifeCycleState"`

	// The name of the access point. This is the value of the Name tag.
	Name *string `type:"string"`

	// Identifies the Amazon Web Services account that owns the access point resource.
	OwnerId *string `type:"string"`

	// The full POSIX identity, including the user ID, group ID, and secondary group
	// IDs on the access point that is used for all file operations by NFS clients
	// using the access point.
	PosixUser *PosixUser `type:"structure"`

	// The directory on the Amazon EFS file system that the access point exposes
	// as the root directory to NFS clients using the access point.
	RootDirectory *RootDirectory `type:"structure"`

	// The tags associated with the access point, presented as an array of Tag objects.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessPointOutput) GoString() string {
	return s.String()
}

// SetAccessPointArn sets the AccessPointArn field's value.
func (s *CreateAccessPointOutput) SetAccessPointArn(v string) *CreateAccessPointOutput {
	s.AccessPointArn = &v
	return s
}

// SetAccessPointId sets the AccessPointId field's value.
func (s *CreateAccessPointOutput) SetAccessPointId(v string) *CreateAccessPointOutput {
	s.AccessPointId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAccessPointOutput) SetClientToken(v string) *CreateAccessPointOutput {
	s.ClientToken = &v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *CreateAccessPointOutput) SetFileSystemId(v string) *CreateAccessPointOutput {
	s.FileSystemId = &v
	return s
}

// SetLifeCycleState sets the LifeCycleState field's value.
func (s *CreateAccessPointOutput) SetLifeCycleState(v string) *CreateAccessPointOutput {
	s.LifeCycleState = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAccessPointOutput) SetName(v string) *CreateAccessPointOutput {
	s.Name = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *CreateAccessPointOutput) SetOwnerId(v string) *CreateAccessPointOutput {
	s.OwnerId = &v
	return s
}

// SetPosixUser sets the PosixUser field's value.
func (s *CreateAccessPointOutput) SetPosixUser(v *PosixUser) *CreateAccessPointOutput {
	s.PosixUser = v
	return s
}

// SetRootDirectory sets the RootDirectory field's value.
func (s *CreateAccessPointOutput) SetRootDirectory(v *RootDirectory) *CreateAccessPointOutput {
	s.RootDirectory = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAccessPointOutput) SetTags(v []*Tag) *CreateAccessPointOutput {
	s.Tags = v
	return s
}

type CreateFileSystemInput struct {
	_ struct{} `type:"structure"`

	// Used to create a file system that uses One Zone storage classes. It specifies
	// the Amazon Web Services Availability Zone in which to create the file system.
	// Use the format us-east-1a to specify the Availability Zone. For more information
	// about One Zone storage classes, see Using EFS storage classes (https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html)
	// in the Amazon EFS User Guide.
	//
	// One Zone storage classes are not available in all Availability Zones in Amazon
	// Web Services Regions where Amazon EFS is available.
	AvailabilityZoneName *string `min:"1" type:"string"`

	// Specifies whether automatic backups are enabled on the file system that you
	// are creating. Set the value to true to enable automatic backups. If you are
	// creating a file system that uses One Zone storage classes, automatic backups
	// are enabled by default. For more information, see Automatic backups (https://docs.aws.amazon.com/efs/latest/ug/awsbackup.html#automatic-backups)
	// in the Amazon EFS User Guide.
	//
	// Default is false. However, if you specify an AvailabilityZoneName, the default
	// is true.
	//
	// Backup is not available in all Amazon Web Services Regions where Amazon EFS
	// is available.
	Backup *bool `type:"boolean"`

	// A string of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent
	// creation.
	CreationToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// A Boolean value that, if true, creates an encrypted file system. When creating
	// an encrypted file system, you have the option of specifying an existing Key
	// Management Service key (KMS key). If you don't specify a KMS key, then the
	// default KMS key for Amazon EFS, /aws/elasticfilesystem, is used to protect
	// the encrypted file system.
	Encrypted *bool `type:"boolean"`

	// The ID of the KMS key that you want to use to protect the encrypted file
	// system. This parameter is required only if you want to use a non-default
	// KMS key. If this parameter is not specified, the default KMS key for Amazon
	// EFS is used. You can specify a KMS key ID using the following formats:
	//
	//    * Key ID - A unique identifier of the key, for example 1234abcd-12ab-34cd-56ef-1234567890ab.
	//
	//    * ARN - An Amazon Resource Name (ARN) for the key, for example arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab.
	//
	//    * Key alias - A previously created display name for a key, for example
	//    alias/projectKey1.
	//
	//    * Key alias ARN - An ARN for a key alias, for example arn:aws:kms:us-west-2:444455556666:alias/projectKey1.
	//
	// If you use KmsKeyId, you must set the CreateFileSystemRequest$Encrypted parameter
	// to true.
	//
	// EFS accepts only symmetric KMS keys. You cannot use asymmetric KMS keys with
	// Amazon EFS file systems.
	KmsKeyId *string `type:"string"`

	// The performance mode of the file system. We recommend generalPurpose performance
	// mode for most file systems. File systems using the maxIO performance mode
	// can scale to higher levels of aggregate throughput and operations per second
	// with a tradeoff of slightly higher latencies for most file operations. The
	// performance mode can't be changed after the file system has been created.
	//
	// The maxIO mode is not supported on file systems using One Zone storage classes.
	//
	// Default is generalPurpose.
	PerformanceMode *string `type:"string" enum:"PerformanceMode"`

	// The throughput, measured in mebibytes per second (MiBps), that you want to
	// provision for a file system that you're creating. Required if ThroughputMode
	// is set to provisioned. Valid values are 1-3414 MiBps, with the upper limit
	// depending on Region. To increase this limit, contact Amazon Web Services
	// Support. For more information, see Amazon EFS quotas that you can increase
	// (https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits) in the
	// Amazon EFS User Guide.
	ProvisionedThroughputInMibps *float64 `min:"1" type:"double"`

	// Use to create one or more tags associated with the file system. Each tag
	// is a user-defined key-value pair. Name your file system on creation by including
	// a "Key":"Name","Value":"{value}" key-value pair. Each key must be unique.
	// For more information, see Tagging Amazon Web Services resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
	// in the Amazon Web Services General Reference Guide.
	Tags []*Tag `type:"list"`

	// Specifies the throughput mode for the file system. The mode can be bursting,
	// provisioned, or elastic. If you set ThroughputMode to provisioned, you must
	// also set a value for ProvisionedThroughputInMibps. After you create the file
	// system, you can decrease your file system's throughput in Provisioned Throughput
	// mode or change between the throughput modes, with certain time restrictions.
	// For more information, see Specifying throughput with provisioned mode (https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput)
	// in the Amazon EFS User Guide.
	//
	// Default is bursting.
	ThroughputMode *string `type:"string" enum:"ThroughputMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFileSystemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFileSystemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFileSystemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFileSystemInput"}
	if s.AvailabilityZoneName != nil && len(*s.AvailabilityZoneName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AvailabilityZoneName", 1))
	}
	if s.CreationToken != nil && len(*s.CreationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CreationToken", 1))
	}
	if s.ProvisionedThroughputInMibps != nil && *s.ProvisionedThroughputInMibps < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ProvisionedThroughputInMibps", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZoneName sets the AvailabilityZoneName field's value.
func (s *CreateFileSystemInput) SetAvailabilityZoneName(v string) *CreateFileSystemInput {
	s.AvailabilityZoneName = &v
	return s
}

// SetBackup sets the Backup field's value.
func (s *CreateFileSystemInput) SetBackup(v bool) *CreateFileSystemInput {
	s.Backup = &v
	return s
}

// SetCreationToken sets the CreationToken field's value.
func (s *CreateFileSystemInput) SetCreationToken(v string) *CreateFileSystemInput {
	s.CreationToken = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *CreateFileSystemInput) SetEncrypted(v bool) *CreateFileSystemInput {
	s.Encrypted = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateFileSystemInput) SetKmsKeyId(v string) *CreateFileSystemInput {
	s.KmsKeyId = &v
	return s
}

// SetPerformanceMode sets the PerformanceMode field's value.
func (s *CreateFileSystemInput) SetPerformanceMode(v string) *CreateFileSystemInput {
	s.PerformanceMode = &v
	return s
}

// SetProvisionedThroughputInMibps sets the ProvisionedThroughputInMibps field's value.
func (s *CreateFileSystemInput) SetProvisionedThroughputInMibps(v float64) *CreateFileSystemInput {
	s.ProvisionedThroughputInMibps = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFileSystemInput) SetTags(v []*Tag) *CreateFileSystemInput {
	s.Tags = v
	return s
}

// SetThroughputMode sets the ThroughputMode field's value.
func (s *CreateFileSystemInput) SetThroughputMode(v string) *CreateFileSystemInput {
	s.ThroughputMode = &v
	return s
}

type CreateMountTargetInput struct {
	_ struct{} `type:"structure"`

	// The ID of the file system for which to create the mount target.
	//
	// FileSystemId is a required field
	FileSystemId *string `type:"string" required:"true"`

	// Valid IPv4 address within the address range of the specified subnet.
	IpAddress *string `min:"7" type:"string"`

	// Up to five VPC security group IDs, of the form sg-xxxxxxxx. These must be
	// for the same VPC as subnet specified.
	SecurityGroups []*string `type:"list"`

	// The ID of the subnet to add the mount target in. For file systems that use
	// One Zone storage classes, use the subnet that is associated with the file
	// system's Availability Zone.
	//
	// SubnetId is a required field
	SubnetId *string `min:"15" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMountTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMountTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMountTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMountTargetInput"}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}
	if s.IpAddress != nil && len(*s.IpAddress) < 7 {
		invalidParams.Add(request.NewErrParamMinLen("IpAddress", 7))
	}
	if s.SubnetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetId"))
	}
	if s.SubnetId != nil && len(*s.SubnetId) < 15 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetId", 15))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *CreateMountTargetInput) SetFileSystemId(v string) *CreateMountTargetInput {
	s.FileSystemId = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *CreateMountTargetInput) SetIpAddress(v string) *CreateMountTargetInput {
	s.IpAddress = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *CreateMountTargetInput) SetSecurityGroups(v []*string) *CreateMountTargetInput {
	s.SecurityGroups = v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *CreateMountTargetInput) SetSubnetId(v string) *CreateMountTargetInput {
	s.SubnetId = &v
	return s
}

type CreateReplicationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// An array of destination configuration objects. Only one destination configuration
	// object is supported.
	//
	// Destinations is a required field
	Destinations []*DestinationToCreate `type:"list" required:"true"`

	// Specifies the Amazon EFS file system that you want to replicate. This file
	// system cannot already be a source or destination file system in another replication
	// configuration.
	//
	// SourceFileSystemId is a required field
	SourceFileSystemId *string `location:"uri" locationName:"SourceFileSystemId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReplicationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReplicationConfigurationInput"}
	if s.Destinations == nil {
		invalidParams.Add(request.NewErrParamRequired("Destinations"))
	}
	if s.SourceFileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceFileSystemId"))
	}
	if s.SourceFileSystemId != nil && len(*s.SourceFileSystemId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceFileSystemId", 1))
	}
	if s.Destinations != nil {
		for i, v := range s.Destinations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Destinations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinations sets the Destinations field's value.
func (s *CreateReplicationConfigurationInput) SetDestinations(v []*DestinationToCreate) *CreateReplicationConfigurationInput {
	s.Destinations = v
	return s
}

// SetSourceFileSystemId sets the SourceFileSystemId field's value.
func (s *CreateReplicationConfigurationInput) SetSourceFileSystemId(v string) *CreateReplicationConfigurationInput {
	s.SourceFileSystemId = &v
	return s
}

// Describes the replication configuration for a specific file system.
type CreateReplicationConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Describes when the replication configuration was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// An array of destination objects. Only one destination object is supported.
	//
	// Destinations is a required field
	Destinations []*Destination `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the original source Amazon EFS file system
	// in the replication configuration.
	//
	// OriginalSourceFileSystemArn is a required field
	OriginalSourceFileSystemArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the current source file system in the replication
	// configuration.
	//
	// SourceFileSystemArn is a required field
	SourceFileSystemArn *string `type:"string" required:"true"`

	// The ID of the source Amazon EFS file system that is being replicated.
	//
	// SourceFileSystemId is a required field
	SourceFileSystemId *string `type:"string" required:"true"`

	// The Amazon Web Services Region in which the source Amazon EFS file system
	// is located.
	//
	// SourceFileSystemRegion is a required field
	SourceFileSystemRegion *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReplicationConfigurationOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateReplicationConfigurationOutput) SetCreationTime(v time.Time) *CreateReplicationConfigurationOutput {
	s.CreationTime = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *CreateReplicationConfigurationOutput) SetDestinations(v []*Destination) *CreateReplicationConfigurationOutput {
	s.Destinations = v
	return s
}

// SetOriginalSourceFileSystemArn sets the OriginalSourceFileSystemArn field's value.
func (s *CreateReplicationConfigurationOutput) SetOriginalSourceFileSystemArn(v string) *CreateReplicationConfigurationOutput {
	s.OriginalSourceFileSystemArn = &v
	return s
}

// SetSourceFileSystemArn sets the SourceFileSystemArn field's value.
func (s *CreateReplicationConfigurationOutput) SetSourceFileSystemArn(v string) *CreateReplicationConfigurationOutput {
	s.SourceFileSystemArn = &v
	return s
}

// SetSourceFileSystemId sets the SourceFileSystemId field's value.
func (s *CreateReplicationConfigurationOutput) SetSourceFileSystemId(v string) *CreateReplicationConfigurationOutput {
	s.SourceFileSystemId = &v
	return s
}

// SetSourceFileSystemRegion sets the SourceFileSystemRegion field's value.
func (s *CreateReplicationConfigurationOutput) SetSourceFileSystemRegion(v string) *CreateReplicationConfigurationOutput {
	s.SourceFileSystemRegion = &v
	return s
}

type CreateTagsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the file system whose tags you want to modify (String). This operation
	// modifies the tags only, not the file system.
	//
	// FileSystemId is a required field
	FileSystemId *string `location:"uri" locationName:"FileSystemId" type:"string" required:"true"`

	// An array of Tag objects to add. Each Tag object is a key-value pair.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTagsInput"}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}
	if s.FileSystemId != nil && len(*s.FileSystemId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileSystemId", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *CreateTagsInput) SetFileSystemId(v string) *CreateTagsInput {
	s.FileSystemId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTagsInput) SetTags(v []*Tag) *CreateTagsInput {
	s.Tags = v
	return s
}

type CreateTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTagsOutput) GoString() string {
	return s.String()
}

// Required if the RootDirectory > Path specified does not exist. Specifies
// the POSIX IDs and permissions to apply to the access point's RootDirectory
// > Path. If the access point root directory does not exist, EFS creates it
// with these settings when a client connects to the access point. When specifying
// CreationInfo, you must include values for all properties.
//
// Amazon EFS creates a root directory only if you have provided the CreationInfo:
// OwnUid, OwnGID, and permissions for the directory. If you do not provide
// this information, Amazon EFS does not create the root directory. If the root
// directory does not exist, attempts to mount using the access point will fail.
//
// If you do not provide CreationInfo and the specified RootDirectory does not
// exist, attempts to mount the file system using the access point will fail.
type CreationInfo struct {
	_ struct{} `type:"structure"`

	// Specifies the POSIX group ID to apply to the RootDirectory. Accepts values
	// from 0 to 2^32 (4294967295).
	//
	// OwnerGid is a required field
	OwnerGid *int64 `type:"long" required:"true"`

	// Specifies the POSIX user ID to apply to the RootDirectory. Accepts values
	// from 0 to 2^32 (4294967295).
	//
	// OwnerUid is a required field
	OwnerUid *int64 `type:"long" required:"true"`

	// Specifies the POSIX permissions to apply to the RootDirectory, in the format
	// of an octal number representing the file's mode bits.
	//
	// Permissions is a required field
	Permissions *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreationInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreationInfo) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreationInfo) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreationInfo"}
	if s.OwnerGid == nil {
		invalidParams.Add(request.NewErrParamRequired("OwnerGid"))
	}
	if s.OwnerUid == nil {
		invalidParams.Add(request.NewErrParamRequired("OwnerUid"))
	}
	if s.Permissions == nil {
		invalidParams.Add(request.NewErrParamRequired("Permissions"))
	}
	if s.Permissions != nil && len(*s.Permissions) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Permissions", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOwnerGid sets the OwnerGid field's value.
func (s *CreationInfo) SetOwnerGid(v int64) *CreationInfo {
	s.OwnerGid = &v
	return s
}

// SetOwnerUid sets the OwnerUid field's value.
func (s *CreationInfo) SetOwnerUid(v int64) *CreationInfo {
	s.OwnerUid = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *CreationInfo) SetPermissions(v string) *CreationInfo {
	s.Permissions = &v
	return s
}

type DeleteAccessPointInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the access point that you want to delete.
	//
	// AccessPointId is a required field
	AccessPointId *string `location:"uri" locationName:"AccessPointId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccessPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccessPointInput"}
	if s.AccessPointId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessPointId"))
	}
	if s.AccessPointId != nil && len(*s.AccessPointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccessPointId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPointId sets the AccessPointId field's value.
func (s *DeleteAccessPointInput) SetAccessPointId(v string) *DeleteAccessPointInput {
	s.AccessPointId = &v
	return s
}

type DeleteAccessPointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessPointOutput) GoString() string {
	return s.String()
}

type DeleteFileSystemInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the file system you want to delete.
	//
	// FileSystemId is a required field
	FileSystemId *string `location:"uri" locationName:"FileSystemId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFileSystemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFileSystemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFileSystemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFileSystemInput"}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}
	if s.FileSystemId != nil && len(*s.FileSystemId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileSystemId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *DeleteFileSystemInput) SetFileSystemId(v string) *DeleteFileSystemInput {
	s.FileSystemId = &v
	return s
}

type DeleteFileSystemOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFileSystemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFileSystemOutput) GoString() string {
	return s.String()
}

type DeleteFileSystemPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Specifies the EFS file system for which to delete the FileSystemPolicy.
	//
	// FileSystemId is a required field
	FileSystemId *string `location:"uri" locationName:"FileSystemId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFileSystemPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFileSystemPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFileSystemPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFileSystemPolicyInput"}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}
	if s.FileSystemId != nil && len(*s.FileSystemId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileSystemId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *DeleteFileSystemPolicyInput) SetFileSystemId(v string) *DeleteFileSystemPolicyInput {
	s.FileSystemId = &v
	return s
}

type DeleteFileSystemPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFileSystemPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFileSystemPolicyOutput) GoString() string {
	return s.String()
}

type DeleteMountTargetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the mount target to delete (String).
	//
	// MountTargetId is a required field
	MountTargetId *string `location:"uri" locationName:"MountTargetId" min:"13" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMountTargetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMountTargetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMountTargetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMountTargetInput"}
	if s.MountTargetId == nil {
		invalidParams.Add(request.NewErrParamRequired("MountTargetId"))
	}
	if s.MountTargetId != nil && len(*s.MountTargetId) < 13 {
		invalidParams.Add(request.NewErrParamMinLen("MountTargetId", 13))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMountTargetId sets the MountTargetId field's value.
func (s *DeleteMountTargetInput) SetMountTargetId(v string) *DeleteMountTargetInput {
	s.MountTargetId = &v
	return s
}

type DeleteMountTargetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMountTargetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMountTargetOutput) GoString() string {
	return s.String()
}

type DeleteReplicationConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the source file system in the replication configuration.
	//
	// SourceFileSystemId is a required field
	SourceFileSystemId *string `location:"uri" locationName:"SourceFileSystemId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReplicationConfigurationInput"}
	if s.SourceFileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceFileSystemId"))
	}
	if s.SourceFileSystemId != nil && len(*s.SourceFileSystemId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceFileSystemId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSourceFileSystemId sets the SourceFileSystemId field's value.
func (s *DeleteReplicationConfigurationInput) SetSourceFileSystemId(v string) *DeleteReplicationConfigurationInput {
	s.SourceFileSystemId = &v
	return s
}

type DeleteReplicationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReplicationConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteTagsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the file system whose tags you want to delete (String).
	//
	// FileSystemId is a required field
	FileSystemId *string `location:"uri" locationName:"FileSystemId" type:"string" required:"true"`

	// A list of tag keys to delete.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTagsInput"}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}
	if s.FileSystemId != nil && len(*s.FileSystemId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileSystemId", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *DeleteTagsInput) SetFileSystemId(v string) *DeleteTagsInput {
	s.FileSystemId = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DeleteTagsInput) SetTagKeys(v []*string) *DeleteTagsInput {
	s.TagKeys = v
	return s
}

type DeleteTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTagsOutput) GoString() string {
	return s.String()
}

// The service timed out trying to fulfill the request, and the client should
// try the call again.
type DependencyTimeout struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// ErrorCode is a required field
	ErrorCode *string `min:"1" type:"string" required:"true"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DependencyTimeout) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DependencyTimeout) GoString() string {
	return s.String()
}

func newErrorDependencyTimeout(v protocol.ResponseMetadata) error {
	return &DependencyTimeout{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DependencyTimeout) Code() string {
	return "DependencyTimeout"
}

// Message returns the exception's message.
func (s *DependencyTimeout) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DependencyTimeout) OrigErr() error {
	return nil
}

func (s *DependencyTimeout) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DependencyTimeout) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DependencyTimeout) RequestID() string {
	return s.RespMetadata.RequestID
}

type DescribeAccessPointsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// (Optional) Specifies an EFS access point to describe in the response; mutually
	// exclusive with FileSystemId.
	AccessPointId *string `location:"querystring" locationName:"AccessPointId" type:"string"`

	// (Optional) If you provide a FileSystemId, EFS returns all access points for
	// that file system; mutually exclusive with AccessPointId.
	FileSystemId *string `location:"querystring" locationName:"FileSystemId" type:"string"`

	// (Optional) When retrieving all access points for a file system, you can optionally
	// specify the MaxItems parameter to limit the number of objects returned in
	// a response. The default value is 100.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// NextToken is present if the response is paginated. You can use NextMarker
	// in the subsequent request to fetch the next page of access point descriptions.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccessPointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccessPointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccessPointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAccessPointsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPointId sets the AccessPointId field's value.
func (s *DescribeAccessPointsInput) SetAccessPointId(v string) *DescribeAccessPointsInput {
	s.AccessPointId = &v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *DescribeAccessPointsInput) SetFileSystemId(v string) *DescribeAccessPointsInput {
	s.FileSystemId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeAccessPointsInput) SetMaxResults(v int64) *DescribeAccessPointsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAccessPointsInput) SetNextToken(v string) *DescribeAccessPointsInput {
	s.NextToken = &v
	return s
}

type DescribeAccessPointsOutput struct {
	_ struct{} `type:"structure"`

	// An array of access point descriptions.
	AccessPoints []*AccessPointDescription `type:"list"`

	// Present if there are more access points than returned in the response. You
	// can use the NextMarker in the subsequent request to fetch the additional
	// descriptions.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccessPointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccessPointsOutput) GoString() string {
	return s.String()
}

// SetAccessPoints sets the AccessPoints field's value.
func (s *DescribeAccessPointsOutput) SetAccessPoints(v []*AccessPointDescription) *DescribeAccessPointsOutput {
	s.AccessPoints = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAccessPointsOutput) SetNextToken(v string) *DescribeAccessPointsOutput {
	s.NextToken = &v
	return s
}

type DescribeAccountPreferencesInput struct {
	_ struct{} `type:"structure"`

	// (Optional) When retrieving account preferences, you can optionally specify
	// the MaxItems parameter to limit the number of objects returned in a response.
	// The default value is 100.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) You can use NextToken in a subsequent request to fetch the next
	// page of Amazon Web Services account preferences if the response payload was
	// paginated.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountPreferencesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountPreferencesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccountPreferencesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAccountPreferencesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeAccountPreferencesInput) SetMaxResults(v int64) *DescribeAccountPreferencesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAccountPreferencesInput) SetNextToken(v string) *DescribeAccountPreferencesInput {
	s.NextToken = &v
	return s
}

type DescribeAccountPreferencesOutput struct {
	_ struct{} `type:"structure"`

	// Present if there are more records than returned in the response. You can
	// use the NextToken in the subsequent request to fetch the additional descriptions.
	NextToken *string `min:"1" type:"string"`

	// Describes the resource ID preference setting for the Amazon Web Services
	// account associated with the user making the request, in the current Amazon
	// Web Services Region.
	ResourceIdPreference *ResourceIdPreference `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountPreferencesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountPreferencesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAccountPreferencesOutput) SetNextToken(v string) *DescribeAccountPreferencesOutput {
	s.NextToken = &v
	return s
}

// SetResourceIdPreference sets the ResourceIdPreference field's value.
func (s *DescribeAccountPreferencesOutput) SetResourceIdPreference(v *ResourceIdPreference) *DescribeAccountPreferencesOutput {
	s.ResourceIdPreference = v
	return s
}

type DescribeBackupPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Specifies which EFS file system to retrieve the BackupPolicy for.
	//
	// FileSystemId is a required field
	FileSystemId *string `location:"uri" locationName:"FileSystemId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBackupPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBackupPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBackupPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBackupPolicyInput"}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}
	if s.FileSystemId != nil && len(*s.FileSystemId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileSystemId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *DescribeBackupPolicyInput) SetFileSystemId(v string) *DescribeBackupPolicyInput {
	s.FileSystemId = &v
	return s
}

type DescribeBackupPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Describes the file system's backup policy, indicating whether automatic backups
	// are turned on or off.
	BackupPolicy *BackupPolicy `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBackupPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBackupPolicyOutput) GoString() string {
	return s.String()
}

// SetBackupPolicy sets the BackupPolicy field's value.
func (s *DescribeBackupPolicyOutput) SetBackupPolicy(v *BackupPolicy) *DescribeBackupPolicyOutput {
	s.BackupPolicy = v
	return s
}

type DescribeFileSystemPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Specifies which EFS file system to retrieve the FileSystemPolicy for.
	//
	// FileSystemId is a required field
	FileSystemId *string `location:"uri" locationName:"FileSystemId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFileSystemPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFileSystemPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFileSystemPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFileSystemPolicyInput"}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}
	if s.FileSystemId != nil && len(*s.FileSystemId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileSystemId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *DescribeFileSystemPolicyInput) SetFileSystemId(v string) *DescribeFileSystemPolicyInput {
	s.FileSystemId = &v
	return s
}

type DescribeFileSystemPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the EFS file system to which the FileSystemPolicy applies.
	FileSystemId *string `type:"string"`

	// The JSON formatted FileSystemPolicy for the EFS file system.
	Policy *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFileSystemPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFileSystemPolicyOutput) GoString() string {
	return s.String()
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *DescribeFileSystemPolicyOutput) SetFileSystemId(v string) *DescribeFileSystemPolicyOutput {
	s.FileSystemId = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *DescribeFileSystemPolicyOutput) SetPolicy(v string) *DescribeFileSystemPolicyOutput {
	s.Policy = &v
	return s
}

type DescribeFileSystemsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// (Optional) Restricts the list to the file system with this creation token
	// (String). You specify a creation token when you create an Amazon EFS file
	// system.
	CreationToken *string `location:"querystring" locationName:"CreationToken" min:"1" type:"string"`

	// (Optional) ID of the file system whose description you want to retrieve (String).
	FileSystemId *string `location:"querystring" locationName:"FileSystemId" type:"string"`

	// (Optional) Opaque pagination token returned from a previous DescribeFileSystems
	// operation (String). If present, specifies to continue the list from where
	// the returning call had left off.
	Marker *string `location:"querystring" locationName:"Marker" min:"1" type:"string"`

	// (Optional) Specifies the maximum number of file systems to return in the
	// response (integer). This number is automatically set to 100. The response
	// is paginated at 100 per page if you have more than 100 file systems.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFileSystemsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFileSystemsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFileSystemsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFileSystemsInput"}
	if s.CreationToken != nil && len(*s.CreationToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CreationToken", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreationToken sets the CreationToken field's value.
func (s *DescribeFileSystemsInput) SetCreationToken(v string) *DescribeFileSystemsInput {
	s.CreationToken = &v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *DescribeFileSystemsInput) SetFileSystemId(v string) *DescribeFileSystemsInput {
	s.FileSystemId = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeFileSystemsInput) SetMarker(v string) *DescribeFileSystemsInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *DescribeFileSystemsInput) SetMaxItems(v int64) *DescribeFileSystemsInput {
	s.MaxItems = &v
	return s
}

type DescribeFileSystemsOutput struct {
	_ struct{} `type:"structure"`

	// An array of file system descriptions.
	FileSystems []*FileSystemDescription `type:"list"`

	// Present if provided by caller in the request (String).
	Marker *string `min:"1" type:"string"`

	// Present if there are more file systems than returned in the response (String).
	// You can use the NextMarker in the subsequent request to fetch the descriptions.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFileSystemsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFileSystemsOutput) GoString() string {
	return s.String()
}

// SetFileSystems sets the FileSystems field's value.
func (s *DescribeFileSystemsOutput) SetFileSystems(v []*FileSystemDescription) *DescribeFileSystemsOutput {
	s.FileSystems = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeFileSystemsOutput) SetMarker(v string) *DescribeFileSystemsOutput {
	s.Marker = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *DescribeFileSystemsOutput) SetNextMarker(v string) *DescribeFileSystemsOutput {
	s.NextMarker = &v
	return s
}

type DescribeLifecycleConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the file system whose LifecycleConfiguration object you want to
	// retrieve (String).
	//
	// FileSystemId is a required field
	FileSystemId *string `location:"uri" locationName:"FileSystemId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLifecycleConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLifecycleConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLifecycleConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLifecycleConfigurationInput"}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}
	if s.FileSystemId != nil && len(*s.FileSystemId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileSystemId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *DescribeLifecycleConfigurationInput) SetFileSystemId(v string) *DescribeLifecycleConfigurationInput {
	s.FileSystemId = &v
	return s
}

type DescribeLifecycleConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// An array of lifecycle management policies. EFS supports a maximum of one
	// policy per file system.
	LifecyclePolicies []*LifecyclePolicy `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLifecycleConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLifecycleConfigurationOutput) GoString() string {
	return s.String()
}

// SetLifecyclePolicies sets the LifecyclePolicies field's value.
func (s *DescribeLifecycleConfigurationOutput) SetLifecyclePolicies(v []*LifecyclePolicy) *DescribeLifecycleConfigurationOutput {
	s.LifecyclePolicies = v
	return s
}

type DescribeMountTargetSecurityGroupsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the mount target whose security groups you want to retrieve.
	//
	// MountTargetId is a required field
	MountTargetId *string `location:"uri" locationName:"MountTargetId" min:"13" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMountTargetSecurityGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMountTargetSecurityGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMountTargetSecurityGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMountTargetSecurityGroupsInput"}
	if s.MountTargetId == nil {
		invalidParams.Add(request.NewErrParamRequired("MountTargetId"))
	}
	if s.MountTargetId != nil && len(*s.MountTargetId) < 13 {
		invalidParams.Add(request.NewErrParamMinLen("MountTargetId", 13))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMountTargetId sets the MountTargetId field's value.
func (s *DescribeMountTargetSecurityGroupsInput) SetMountTargetId(v string) *DescribeMountTargetSecurityGroupsInput {
	s.MountTargetId = &v
	return s
}

type DescribeMountTargetSecurityGroupsOutput struct {
	_ struct{} `type:"structure"`

	// An array of security groups.
	//
	// SecurityGroups is a required field
	SecurityGroups []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMountTargetSecurityGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMountTargetSecurityGroupsOutput) GoString() string {
	return s.String()
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *DescribeMountTargetSecurityGroupsOutput) SetSecurityGroups(v []*string) *DescribeMountTargetSecurityGroupsOutput {
	s.SecurityGroups = v
	return s
}

type DescribeMountTargetsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// (Optional) The ID of the access point whose mount targets that you want to
	// list. It must be included in your request if a FileSystemId or MountTargetId
	// is not included in your request. Accepts either an access point ID or ARN
	// as input.
	AccessPointId *string `location:"querystring" locationName:"AccessPointId" type:"string"`

	// (Optional) ID of the file system whose mount targets you want to list (String).
	// It must be included in your request if an AccessPointId or MountTargetId
	// is not included. Accepts either a file system ID or ARN as input.
	FileSystemId *string `location:"querystring" locationName:"FileSystemId" type:"string"`

	// (Optional) Opaque pagination token returned from a previous DescribeMountTargets
	// operation (String). If present, it specifies to continue the list from where
	// the previous returning call left off.
	Marker *string `location:"querystring" locationName:"Marker" min:"1" type:"string"`

	// (Optional) Maximum number of mount targets to return in the response. Currently,
	// this number is automatically set to 10, and other values are ignored. The
	// response is paginated at 100 per page if you have more than 100 mount targets.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`

	// (Optional) ID of the mount target that you want to have described (String).
	// It must be included in your request if FileSystemId is not included. Accepts
	// either a mount target ID or ARN as input.
	MountTargetId *string `location:"querystring" locationName:"MountTargetId" min:"13" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMountTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMountTargetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMountTargetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeMountTargetsInput"}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}
	if s.MountTargetId != nil && len(*s.MountTargetId) < 13 {
		invalidParams.Add(request.NewErrParamMinLen("MountTargetId", 13))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPointId sets the AccessPointId field's value.
func (s *DescribeMountTargetsInput) SetAccessPointId(v string) *DescribeMountTargetsInput {
	s.AccessPointId = &v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *DescribeMountTargetsInput) SetFileSystemId(v string) *DescribeMountTargetsInput {
	s.FileSystemId = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeMountTargetsInput) SetMarker(v string) *DescribeMountTargetsInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *DescribeMountTargetsInput) SetMaxItems(v int64) *DescribeMountTargetsInput {
	s.MaxItems = &v
	return s
}

// SetMountTargetId sets the MountTargetId field's value.
func (s *DescribeMountTargetsInput) SetMountTargetId(v string) *DescribeMountTargetsInput {
	s.MountTargetId = &v
	return s
}

type DescribeMountTargetsOutput struct {
	_ struct{} `type:"structure"`

	// If the request included the Marker, the response returns that value in this
	// field.
	Marker *string `min:"1" type:"string"`

	// Returns the file system's mount targets as an array of MountTargetDescription
	// objects.
	MountTargets []*MountTargetDescription `type:"list"`

	// If a value is present, there are more mount targets to return. In a subsequent
	// request, you can provide Marker in your request with this value to retrieve
	// the next set of mount targets.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMountTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeMountTargetsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeMountTargetsOutput) SetMarker(v string) *DescribeMountTargetsOutput {
	s.Marker = &v
	return s
}

// SetMountTargets sets the MountTargets field's value.
func (s *DescribeMountTargetsOutput) SetMountTargets(v []*MountTargetDescription) *DescribeMountTargetsOutput {
	s.MountTargets = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *DescribeMountTargetsOutput) SetNextMarker(v string) *DescribeMountTargetsOutput {
	s.NextMarker = &v
	return s
}

type DescribeReplicationConfigurationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// You can retrieve the replication configuration for a specific file system
	// by providing its file system ID.
	FileSystemId *string `location:"querystring" locationName:"FileSystemId" type:"string"`

	// (Optional) To limit the number of objects returned in a response, you can
	// specify the MaxItems parameter. The default value is 100.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// NextToken is present if the response is paginated. You can use NextToken
	// in a subsequent request to fetch the next page of output.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReplicationConfigurationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *DescribeReplicationConfigurationsInput) SetFileSystemId(v string) *DescribeReplicationConfigurationsInput {
	s.FileSystemId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeReplicationConfigurationsInput) SetMaxResults(v int64) *DescribeReplicationConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeReplicationConfigurationsInput) SetNextToken(v string) *DescribeReplicationConfigurationsInput {
	s.NextToken = &v
	return s
}

type DescribeReplicationConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// You can use the NextToken from the previous response in a subsequent request
	// to fetch the additional descriptions.
	NextToken *string `min:"1" type:"string"`

	// The collection of replication configurations that is returned.
	Replications []*ReplicationConfigurationDescription `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReplicationConfigurationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeReplicationConfigurationsOutput) SetNextToken(v string) *DescribeReplicationConfigurationsOutput {
	s.NextToken = &v
	return s
}

// SetReplications sets the Replications field's value.
func (s *DescribeReplicationConfigurationsOutput) SetReplications(v []*ReplicationConfigurationDescription) *DescribeReplicationConfigurationsOutput {
	s.Replications = v
	return s
}

type DescribeTagsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the file system whose tag set you want to retrieve.
	//
	// FileSystemId is a required field
	FileSystemId *string `location:"uri" locationName:"FileSystemId" type:"string" required:"true"`

	// (Optional) An opaque pagination token returned from a previous DescribeTags
	// operation (String). If present, it specifies to continue the list from where
	// the previous call left off.
	Marker *string `location:"querystring" locationName:"Marker" min:"1" type:"string"`

	// (Optional) The maximum number of file system tags to return in the response.
	// Currently, this number is automatically set to 100, and other values are
	// ignored. The response is paginated at 100 per page if you have more than
	// 100 tags.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTagsInput"}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}
	if s.FileSystemId != nil && len(*s.FileSystemId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileSystemId", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *DescribeTagsInput) SetFileSystemId(v string) *DescribeTagsInput {
	s.FileSystemId = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeTagsInput) SetMarker(v string) *DescribeTagsInput {
	s.Marker = &v
	return s
}

// SetMaxItems sets the MaxItems field's value.
func (s *DescribeTagsInput) SetMaxItems(v int64) *DescribeTagsInput {
	s.MaxItems = &v
	return s
}

type DescribeTagsOutput struct {
	_ struct{} `type:"structure"`

	// If the request included a Marker, the response returns that value in this
	// field.
	Marker *string `min:"1" type:"string"`

	// If a value is present, there are more tags to return. In a subsequent request,
	// you can provide the value of NextMarker as the value of the Marker parameter
	// in your next request to retrieve the next set of tags.
	NextMarker *string `min:"1" type:"string"`

	// Returns tags associated with the file system as an array of Tag objects.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTagsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeTagsOutput) SetMarker(v string) *DescribeTagsOutput {
	s.Marker = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *DescribeTagsOutput) SetNextMarker(v string) *DescribeTagsOutput {
	s.NextMarker = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeTagsOutput) SetTags(v []*Tag) *DescribeTagsOutput {
	s.Tags = v
	return s
}

// Describes the destination file system in the replication configuration.
type Destination struct {
	_ struct{} `type:"structure"`

	// The ID of the destination Amazon EFS file system.
	//
	// FileSystemId is a required field
	FileSystemId *string `type:"string" required:"true"`

	// The time when the most recent sync was successfully completed on the destination
	// file system. Any changes to data on the source file system that occurred
	// before this time have been successfully replicated to the destination file
	// system. Any changes that occurred after this time might not be fully replicated.
	LastReplicatedTimestamp *time.Time `type:"timestamp"`

	// The Amazon Web Services Region in which the destination file system is located.
	//
	// Region is a required field
	Region *string `min:"1" type:"string" required:"true"`

	// Describes the status of the destination Amazon EFS file system.
	//
	//    * The Paused state occurs as a result of opting out of the source or destination
	//    Region after the replication configuration was created. To resume replication
	//    for the file system, you need to again opt in to the Amazon Web Services
	//    Region. For more information, see Managing Amazon Web Services Regions
	//    (https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable)
	//    in the Amazon Web Services General Reference Guide.
	//
	//    * The Error state occurs when either the source or the destination file
	//    system (or both) is in a failed state and is unrecoverable. For more information,
	//    see Monitoring replication status (https://docs.aws.amazon.com/efs/latest/ug/awsbackup.html#restoring-backup-efsmonitoring-replication-status.html)
	//    in the Amazon EFS User Guide. You must delete the replication configuration,
	//    and then restore the most recent backup of the failed file system (either
	//    the source or the destination) to a new file system.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"ReplicationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Destination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Destination) GoString() string {
	return s.String()
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *Destination) SetFileSystemId(v string) *Destination {
	s.FileSystemId = &v
	return s
}

// SetLastReplicatedTimestamp sets the LastReplicatedTimestamp field's value.
func (s *Destination) SetLastReplicatedTimestamp(v time.Time) *Destination {
	s.LastReplicatedTimestamp = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Destination) SetRegion(v string) *Destination {
	s.Region = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Destination) SetStatus(v string) *Destination {
	s.Status = &v
	return s
}

// Describes the destination file system to create in the replication configuration.
type DestinationToCreate struct {
	_ struct{} `type:"structure"`

	// To create a file system that uses EFS One Zone storage, specify the name
	// of the Availability Zone in which to create the destination file system.
	AvailabilityZoneName *string `min:"1" type:"string"`

	// Specifies the Key Management Service (KMS) key that you want to use to encrypt
	// the destination file system. If you do not specify a KMS key, Amazon EFS
	// uses your default KMS key for Amazon EFS, /aws/elasticfilesystem. This ID
	// can be in one of the following formats:
	//
	//    * Key ID - The unique identifier of the key, for example 1234abcd-12ab-34cd-56ef-1234567890ab.
	//
	//    * ARN - The Amazon Resource Name (ARN) for the key, for example arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab.
	//
	//    * Key alias - A previously created display name for a key, for example
	//    alias/projectKey1.
	//
	//    * Key alias ARN - The ARN for a key alias, for example arn:aws:kms:us-west-2:444455556666:alias/projectKey1.
	KmsKeyId *string `type:"string"`

	// To create a file system that uses Regional storage, specify the Amazon Web
	// Services Region in which to create the destination file system.
	Region *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationToCreate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationToCreate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DestinationToCreate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DestinationToCreate"}
	if s.AvailabilityZoneName != nil && len(*s.AvailabilityZoneName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AvailabilityZoneName", 1))
	}
	if s.Region != nil && len(*s.Region) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Region", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZoneName sets the AvailabilityZoneName field's value.
func (s *DestinationToCreate) SetAvailabilityZoneName(v string) *DestinationToCreate {
	s.AvailabilityZoneName = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DestinationToCreate) SetKmsKeyId(v string) *DestinationToCreate {
	s.KmsKeyId = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *DestinationToCreate) SetRegion(v string) *DestinationToCreate {
	s.Region = &v
	return s
}

// Returned if the file system you are trying to create already exists, with
// the creation token you provided.
type FileSystemAlreadyExists struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// ErrorCode is a required field
	ErrorCode *string `min:"1" type:"string" required:"true"`

	// FileSystemId is a required field
	FileSystemId *string `type:"string" required:"true"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileSystemAlreadyExists) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileSystemAlreadyExists) GoString() string {
	return s.String()
}

func newErrorFileSystemAlreadyExists(v protocol.ResponseMetadata) error {
	return &FileSystemAlreadyExists{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *FileSystemAlreadyExists) Code() string {
	return "FileSystemAlreadyExists"
}

// Message returns the exception's message.
func (s *FileSystemAlreadyExists) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *FileSystemAlreadyExists) OrigErr() error {
	return nil
}

func (s *FileSystemAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *FileSystemAlreadyExists) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *FileSystemAlreadyExists) RequestID() string {
	return s.RespMetadata.RequestID
}

// A description of the file system.
type FileSystemDescription struct {
	_ struct{} `type:"structure"`

	// The unique and consistent identifier of the Availability Zone in which the
	// file system's One Zone storage classes exist. For example, use1-az1 is an
	// Availability Zone ID for the us-east-1 Amazon Web Services Region, and it
	// has the same location in every Amazon Web Services account.
	AvailabilityZoneId *string `type:"string"`

	// Describes the Amazon Web Services Availability Zone in which the file system
	// is located, and is valid only for file systems using One Zone storage classes.
	// For more information, see Using EFS storage classes (https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html)
	// in the Amazon EFS User Guide.
	AvailabilityZoneName *string `min:"1" type:"string"`

	// The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z).
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The opaque string specified in the request.
	//
	// CreationToken is a required field
	CreationToken *string `min:"1" type:"string" required:"true"`

	// A Boolean value that, if true, indicates that the file system is encrypted.
	Encrypted *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) for the EFS file system, in the format arn:aws:elasticfilesystem:region:account-id:file-system/file-system-id
	// . Example with sample data: arn:aws:elasticfilesystem:us-west-2:1111333322228888:file-system/fs-01234567
	FileSystemArn *string `type:"string"`

	// The ID of the file system, assigned by Amazon EFS.
	//
	// FileSystemId is a required field
	FileSystemId *string `type:"string" required:"true"`

	// The ID of an KMS key used to protect the encrypted file system.
	KmsKeyId *string `type:"string"`

	// The lifecycle phase of the file system.
	//
	// LifeCycleState is a required field
	LifeCycleState *string `type:"string" required:"true" enum:"LifeCycleState"`

	// You can add tags to a file system, including a Name tag. For more information,
	// see CreateFileSystem. If the file system has a Name tag, Amazon EFS returns
	// the value in this field.
	Name *string `type:"string"`

	// The current number of mount targets that the file system has. For more information,
	// see CreateMountTarget.
	//
	// NumberOfMountTargets is a required field
	NumberOfMountTargets *int64 `type:"integer" required:"true"`

	// The Amazon Web Services account that created the file system.
	//
	// OwnerId is a required field
	OwnerId *string `type:"string" required:"true"`

	// The performance mode of the file system.
	//
	// PerformanceMode is a required field
	PerformanceMode *string `type:"string" required:"true" enum:"PerformanceMode"`

	// The amount of provisioned throughput, measured in MiBps, for the file system.
	// Valid for file systems using ThroughputMode set to provisioned.
	ProvisionedThroughputInMibps *float64 `min:"1" type:"double"`

	// The latest known metered size (in bytes) of data stored in the file system,
	// in its Value field, and the time at which that size was determined in its
	// Timestamp field. The Timestamp value is the integer number of seconds since
	// 1970-01-01T00:00:00Z. The SizeInBytes value doesn't represent the size of
	// a consistent snapshot of the file system, but it is eventually consistent
	// when there are no writes to the file system. That is, SizeInBytes represents
	// actual size only if the file system is not modified for a period longer than
	// a couple of hours. Otherwise, the value is not the exact size that the file
	// system was at any point in time.
	//
	// SizeInBytes is a required field
	SizeInBytes *FileSystemSize `type:"structure" required:"true"`

	// The tags associated with the file system, presented as an array of Tag objects.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`

	// Displays the file system's throughput mode. For more information, see Throughput
	// modes (https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes)
	// in the Amazon EFS User Guide.
	ThroughputMode *string `type:"string" enum:"ThroughputMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileSystemDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileSystemDescription) GoString() string {
	return s.String()
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *FileSystemDescription) SetAvailabilityZoneId(v string) *FileSystemDescription {
	s.AvailabilityZoneId = &v
	return s
}

// SetAvailabilityZoneName sets the AvailabilityZoneName field's value.
func (s *FileSystemDescription) SetAvailabilityZoneName(v string) *FileSystemDescription {
	s.AvailabilityZoneName = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *FileSystemDescription) SetCreationTime(v time.Time) *FileSystemDescription {
	s.CreationTime = &v
	return s
}

// SetCreationToken sets the CreationToken field's value.
func (s *FileSystemDescription) SetCreationToken(v string) *FileSystemDescription {
	s.CreationToken = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *FileSystemDescription) SetEncrypted(v bool) *FileSystemDescription {
	s.Encrypted = &v
	return s
}

// SetFileSystemArn sets the FileSystemArn field's value.
func (s *FileSystemDescription) SetFileSystemArn(v string) *FileSystemDescription {
	s.FileSystemArn = &v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *FileSystemDescription) SetFileSystemId(v string) *FileSystemDescription {
	s.FileSystemId = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *FileSystemDescription) SetKmsKeyId(v string) *FileSystemDescription {
	s.KmsKeyId = &v
	return s
}

// SetLifeCycleState sets the LifeCycleState field's value.
func (s *FileSystemDescription) SetLifeCycleState(v string) *FileSystemDescription {
	s.LifeCycleState = &v
	return s
}

// SetName sets the Name field's value.
func (s *FileSystemDescription) SetName(v string) *FileSystemDescription {
	s.Name = &v
	return s
}

// SetNumberOfMountTargets sets the NumberOfMountTargets field's value.
func (s *FileSystemDescription) SetNumberOfMountTargets(v int64) *FileSystemDescription {
	s.NumberOfMountTargets = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *FileSystemDescription) SetOwnerId(v string) *FileSystemDescription {
	s.OwnerId = &v
	return s
}

// SetPerformanceMode sets the PerformanceMode field's value.
func (s *FileSystemDescription) SetPerformanceMode(v string) *FileSystemDescription {
	s.PerformanceMode = &v
	return s
}

// SetProvisionedThroughputInMibps sets the ProvisionedThroughputInMibps field's value.
func (s *FileSystemDescription) SetProvisionedThroughputInMibps(v float64) *FileSystemDescription {
	s.ProvisionedThroughputInMibps = &v
	return s
}

// SetSizeInBytes sets the SizeInBytes field's value.
func (s *FileSystemDescription) SetSizeInBytes(v *FileSystemSize) *FileSystemDescription {
	s.SizeInBytes = v
	return s
}

// SetTags sets the Tags field's value.
func (s *FileSystemDescription) SetTags(v []*Tag) *FileSystemDescription {
	s.Tags = v
	return s
}

// SetThroughputMode sets the ThroughputMode field's value.
func (s *FileSystemDescription) SetThroughputMode(v string) *FileSystemDescription {
	s.ThroughputMode = &v
	return s
}

// Returned if a file system has mount targets.
type FileSystemInUse struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// ErrorCode is a required field
	ErrorCode *string `min:"1" type:"string" required:"true"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileSystemInUse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileSystemInUse) GoString() string {
	return s.String()
}

func newErrorFileSystemInUse(v protocol.ResponseMetadata) error {
	return &FileSystemInUse{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *FileSystemInUse) Code() string {
	return "FileSystemInUse"
}

// Message returns the exception's message.
func (s *FileSystemInUse) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *FileSystemInUse) OrigErr() error {
	return nil
}

func (s *FileSystemInUse) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *FileSystemInUse) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *FileSystemInUse) RequestID() string {
	return s.RespMetadata.RequestID
}

// Returned if the Amazon Web Services account has already created the maximum
// number of file systems allowed per account.
type FileSystemLimitExceeded struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// ErrorCode is a required field
	ErrorCode *string `min:"1" type:"string" required:"true"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileSystemLimitExceeded) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileSystemLimitExceeded) GoString() string {
	return s.String()
}

func newErrorFileSystemLimitExceeded(v protocol.ResponseMetadata) error {
	return &FileSystemLimitExceeded{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *FileSystemLimitExceeded) Code() string {
	return "FileSystemLimitExceeded"
}

// Message returns the exception's message.
func (s *FileSystemLimitExceeded) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *FileSystemLimitExceeded) OrigErr() error {
	return nil
}

func (s *FileSystemLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *FileSystemLimitExceeded) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *FileSystemLimitExceeded) RequestID() string {
	return s.RespMetadata.RequestID
}

// Returned if the specified FileSystemId value doesn't exist in the requester's
// Amazon Web Services account.
type FileSystemNotFound struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// ErrorCode is a required field
	ErrorCode *string `min:"1" type:"string" required:"true"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileSystemNotFound) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileSystemNotFound) GoString() string {
	return s.String()
}

func newErrorFileSystemNotFound(v protocol.ResponseMetadata) error {
	return &FileSystemNotFound{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *FileSystemNotFound) Code() string {
	return "FileSystemNotFound"
}

// Message returns the exception's message.
func (s *FileSystemNotFound) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *FileSystemNotFound) OrigErr() error {
	return nil
}

func (s *FileSystemNotFound) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *FileSystemNotFound) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *FileSystemNotFound) RequestID() string {
	return s.RespMetadata.RequestID
}

// The latest known metered size (in bytes) of data stored in the file system,
// in its Value field, and the time at which that size was determined in its
// Timestamp field. The value doesn't represent the size of a consistent snapshot
// of the file system, but it is eventually consistent when there are no writes
// to the file system. That is, the value represents the actual size only if
// the file system is not modified for a period longer than a couple of hours.
// Otherwise, the value is not necessarily the exact size the file system was
// at any instant in time.
type FileSystemSize struct {
	_ struct{} `type:"structure"`

	// The time at which the size of data, returned in the Value field, was determined.
	// The value is the integer number of seconds since 1970-01-01T00:00:00Z.
	Timestamp *time.Time `type:"timestamp"`

	// The latest known metered size (in bytes) of data stored in the file system.
	//
	// Value is a required field
	Value *int64 `type:"long" required:"true"`

	// The latest known metered size (in bytes) of data stored in the Infrequent
	// Access storage class.
	ValueInIA *int64 `type:"long"`

	// The latest known metered size (in bytes) of data stored in the Standard storage
	// class.
	ValueInStandard *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileSystemSize) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileSystemSize) GoString() string {
	return s.String()
}

// SetTimestamp sets the Timestamp field's value.
func (s *FileSystemSize) SetTimestamp(v time.Time) *FileSystemSize {
	s.Timestamp = &v
	return s
}

// SetValue sets the Value field's value.
func (s *FileSystemSize) SetValue(v int64) *FileSystemSize {
	s.Value = &v
	return s
}

// SetValueInIA sets the ValueInIA field's value.
func (s *FileSystemSize) SetValueInIA(v int64) *FileSystemSize {
	s.ValueInIA = &v
	return s
}

// SetValueInStandard sets the ValueInStandard field's value.
func (s *FileSystemSize) SetValueInStandard(v int64) *FileSystemSize {
	s.ValueInStandard = &v
	return s
}

// Returned if the file system's lifecycle state is not "available".
type IncorrectFileSystemLifeCycleState struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// ErrorCode is a required field
	ErrorCode *string `min:"1" type:"string" required:"true"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncorrectFileSystemLifeCycleState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncorrectFileSystemLifeCycleState) GoString() string {
	return s.String()
}

func newErrorIncorrectFileSystemLifeCycleState(v protocol.ResponseMetadata) error {
	return &IncorrectFileSystemLifeCycleState{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *IncorrectFileSystemLifeCycleState) Code() string {
	return "IncorrectFileSystemLifeCycleState"
}

// Message returns the exception's message.
func (s *IncorrectFileSystemLifeCycleState) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *IncorrectFileSystemLifeCycleState) OrigErr() error {
	return nil
}

func (s *IncorrectFileSystemLifeCycleState) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *IncorrectFileSystemLifeCycleState) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *IncorrectFileSystemLifeCycleState) RequestID() string {
	return s.RespMetadata.RequestID
}

// Returned if the mount target is not in the correct state for the operation.
type IncorrectMountTargetState struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// ErrorCode is a required field
	ErrorCode *string `min:"1" type:"string" required:"true"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncorrectMountTargetState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IncorrectMountTargetState) GoString() string {
	return s.String()
}

func newErrorIncorrectMountTargetState(v protocol.ResponseMetadata) error {
	return &IncorrectMountTargetState{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *IncorrectMountTargetState) Code() string {
	return "IncorrectMountTargetState"
}

// Message returns the exception's message.
func (s *IncorrectMountTargetState) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *IncorrectMountTargetState) OrigErr() error {
	return nil
}

func (s *IncorrectMountTargetState) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *IncorrectMountTargetState) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *IncorrectMountTargetState) RequestID() string {
	return s.RespMetadata.RequestID
}

// Returned if there's not enough capacity to provision additional throughput.
// This value might be returned when you try to create a file system in provisioned
// throughput mode, when you attempt to increase the provisioned throughput
// of an existing file system, or when you attempt to change an existing file
// system from Bursting Throughput to Provisioned Throughput mode. Try again
// later.
type InsufficientThroughputCapacity struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// ErrorCode is a required field
	ErrorCode *string `min:"1" type:"string" required:"true"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsufficientThroughputCapacity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsufficientThroughputCapacity) GoString() string {
	return s.String()
}

func newErrorInsufficientThroughputCapacity(v protocol.ResponseMetadata) error {
	return &InsufficientThroughputCapacity{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InsufficientThroughputCapacity) Code() string {
	return "InsufficientThroughputCapacity"
}

// Message returns the exception's message.
func (s *InsufficientThroughputCapacity) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InsufficientThroughputCapacity) OrigErr() error {
	return nil
}

func (s *InsufficientThroughputCapacity) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InsufficientThroughputCapacity) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InsufficientThroughputCapacity) RequestID() string {
	return s.RespMetadata.RequestID
}

// Returned if an error occurred on the server side.
type InternalServerError struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// ErrorCode is a required field
	ErrorCode *string `min:"1" type:"string" required:"true"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerError) GoString() string {
	return s.String()
}

func newErrorInternalServerError(v protocol.ResponseMetadata) error {
	return &InternalServerError{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerError) Code() string {
	return "InternalServerError"
}

// Message returns the exception's message.
func (s *InternalServerError) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerError) OrigErr() error {
	return nil
}

func (s *InternalServerError) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerError) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerError) RequestID() string {
	return s.RespMetadata.RequestID
}

// Returned if the FileSystemPolicy is malformed or contains an error such as
// a parameter value that is not valid or a missing required parameter. Returned
// in the case of a policy lockout safety check error.
type InvalidPolicyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	ErrorCode *string `min:"1" type:"string"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidPolicyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidPolicyException) GoString() string {
	return s.String()
}

func newErrorInvalidPolicyException(v protocol.ResponseMetadata) error {
	return &InvalidPolicyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidPolicyException) Code() string {
	return "InvalidPolicyException"
}

// Message returns the exception's message.
func (s *InvalidPolicyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidPolicyException) OrigErr() error {
	return nil
}

func (s *InvalidPolicyException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidPolicyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidPolicyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Returned if the request specified an IpAddress that is already in use in
// the subnet.
type IpAddressInUse struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// ErrorCode is a required field
	ErrorCode *string `min:"1" type:"string" required:"true"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpAddressInUse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpAddressInUse) GoString() string {
	return s.String()
}

func newErrorIpAddressInUse(v protocol.ResponseMetadata) error {
	return &IpAddressInUse{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *IpAddressInUse) Code() string {
	return "IpAddressInUse"
}

// Message returns the exception's message.
func (s *IpAddressInUse) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *IpAddressInUse) OrigErr() error {
	return nil
}

func (s *IpAddressInUse) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *IpAddressInUse) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *IpAddressInUse) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a policy used by EFS lifecycle management and EFS Intelligent-Tiering
// that specifies when to transition files into and out of the file system's
// Infrequent Access (IA) storage class. For more information, see EFS Intelligent‐Tiering
// and EFS Lifecycle Management (https://docs.aws.amazon.com/efs/latest/ug/lifecycle-management-efs.html).
//
// When using the put-lifecycle-configuration CLI command or the PutLifecycleConfiguration
// API action, Amazon EFS requires that each LifecyclePolicy object have only
// a single transition. This means that in a request body, LifecyclePolicies
// must be structured as an array of LifecyclePolicy objects, one object for
// each transition, TransitionToIA, TransitionToPrimaryStorageClass. For more
// information, see the request examples in PutLifecycleConfiguration.
type LifecyclePolicy struct {
	_ struct{} `type:"structure"`

	// Describes the period of time that a file is not accessed, after which it
	// transitions to IA storage. Metadata operations such as listing the contents
	// of a directory don't count as file access events.
	TransitionToIA *string `type:"string" enum:"TransitionToIARules"`

	// Describes when to transition a file from IA storage to primary storage. Metadata
	// operations such as listing the contents of a directory don't count as file
	// access events.
	TransitionToPrimaryStorageClass *string `type:"string" enum:"TransitionToPrimaryStorageClassRules"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifecyclePolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LifecyclePolicy) GoString() string {
	return s.String()
}

// SetTransitionToIA sets the TransitionToIA field's value.
func (s *LifecyclePolicy) SetTransitionToIA(v string) *LifecyclePolicy {
	s.TransitionToIA = &v
	return s
}

// SetTransitionToPrimaryStorageClass sets the TransitionToPrimaryStorageClass field's value.
func (s *LifecyclePolicy) SetTransitionToPrimaryStorageClass(v string) *LifecyclePolicy {
	s.TransitionToPrimaryStorageClass = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// (Optional) Specifies the maximum number of tag objects to return in the response.
	// The default value is 100.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// (Optional) You can use NextToken in a subsequent request to fetch the next
	// page of access point descriptions if the response payload was paginated.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`

	// Specifies the EFS resource you want to retrieve tags for. You can retrieve
	// tags for EFS file systems and access points using this API endpoint.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"ResourceId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForResourceInput) SetMaxResults(v int64) *ListTagsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ListTagsForResourceInput) SetResourceId(v string) *ListTagsForResourceInput {
	s.ResourceId = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// NextToken is present if the response payload is paginated. You can use NextToken
	// in a subsequent request to fetch the next page of access point descriptions.
	NextToken *string `min:"1" type:"string"`

	// An array of the tags for the specified EFS resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ModifyMountTargetSecurityGroupsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the mount target whose security groups you want to modify.
	//
	// MountTargetId is a required field
	MountTargetId *string `location:"uri" locationName:"MountTargetId" min:"13" type:"string" required:"true"`

	// An array of up to five VPC security group IDs.
	SecurityGroups []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyMountTargetSecurityGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyMountTargetSecurityGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyMountTargetSecurityGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyMountTargetSecurityGroupsInput"}
	if s.MountTargetId == nil {
		invalidParams.Add(request.NewErrParamRequired("MountTargetId"))
	}
	if s.MountTargetId != nil && len(*s.MountTargetId) < 13 {
		invalidParams.Add(request.NewErrParamMinLen("MountTargetId", 13))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMountTargetId sets the MountTargetId field's value.
func (s *ModifyMountTargetSecurityGroupsInput) SetMountTargetId(v string) *ModifyMountTargetSecurityGroupsInput {
	s.MountTargetId = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *ModifyMountTargetSecurityGroupsInput) SetSecurityGroups(v []*string) *ModifyMountTargetSecurityGroupsInput {
	s.SecurityGroups = v
	return s
}

type ModifyMountTargetSecurityGroupsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyMountTargetSecurityGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyMountTargetSecurityGroupsOutput) GoString() string {
	return s.String()
}

// Returned if the mount target would violate one of the specified restrictions
// based on the file system's existing mount targets.
type MountTargetConflict struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// ErrorCode is a required field
	ErrorCode *string `min:"1" type:"string" required:"true"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MountTargetConflict) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MountTargetConflict) GoString() string {
	return s.String()
}

func newErrorMountTargetConflict(v protocol.ResponseMetadata) error {
	return &MountTargetConflict{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MountTargetConflict) Code() string {
	return "MountTargetConflict"
}

// Message returns the exception's message.
func (s *MountTargetConflict) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MountTargetConflict) OrigErr() error {
	return nil
}

func (s *MountTargetConflict) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MountTargetConflict) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MountTargetConflict) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides a description of a mount target.
type MountTargetDescription struct {
	_ struct{} `type:"structure"`

	// The unique and consistent identifier of the Availability Zone that the mount
	// target resides in. For example, use1-az1 is an AZ ID for the us-east-1 Region
	// and it has the same location in every Amazon Web Services account.
	AvailabilityZoneId *string `type:"string"`

	// The name of the Availability Zone in which the mount target is located. Availability
	// Zones are independently mapped to names for each Amazon Web Services account.
	// For example, the Availability Zone us-east-1a for your Amazon Web Services
	// account might not be the same location as us-east-1a for another Amazon Web
	// Services account.
	AvailabilityZoneName *string `min:"1" type:"string"`

	// The ID of the file system for which the mount target is intended.
	//
	// FileSystemId is a required field
	FileSystemId *string `type:"string" required:"true"`

	// Address at which the file system can be mounted by using the mount target.
	IpAddress *string `min:"7" type:"string"`

	// Lifecycle state of the mount target.
	//
	// LifeCycleState is a required field
	LifeCycleState *string `type:"string" required:"true" enum:"LifeCycleState"`

	// System-assigned mount target ID.
	//
	// MountTargetId is a required field
	MountTargetId *string `min:"13" type:"string" required:"true"`

	// The ID of the network interface that Amazon EFS created when it created the
	// mount target.
	NetworkInterfaceId *string `type:"string"`

	// Amazon Web Services account ID that owns the resource.
	OwnerId *string `type:"string"`

	// The ID of the mount target's subnet.
	//
	// SubnetId is a required field
	SubnetId *string `min:"15" type:"string" required:"true"`

	// The virtual private cloud (VPC) ID that the mount target is configured in.
	VpcId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MountTargetDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MountTargetDescription) GoString() string {
	return s.String()
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *MountTargetDescription) SetAvailabilityZoneId(v string) *MountTargetDescription {
	s.AvailabilityZoneId = &v
	return s
}

// SetAvailabilityZoneName sets the AvailabilityZoneName field's value.
func (s *MountTargetDescription) SetAvailabilityZoneName(v string) *MountTargetDescription {
	s.AvailabilityZoneName = &v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *MountTargetDescription) SetFileSystemId(v string) *MountTargetDescription {
	s.FileSystemId = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *MountTargetDescription) SetIpAddress(v string) *MountTargetDescription {
	s.IpAddress = &v
	return s
}

// SetLifeCycleState sets the LifeCycleState field's value.
func (s *MountTargetDescription) SetLifeCycleState(v string) *MountTargetDescription {
	s.LifeCycleState = &v
	return s
}

// SetMountTargetId sets the MountTargetId field's value.
func (s *MountTargetDescription) SetMountTargetId(v string) *MountTargetDescription {
	s.MountTargetId = &v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *MountTargetDescription) SetNetworkInterfaceId(v string) *MountTargetDescription {
	s.NetworkInterfaceId = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *MountTargetDescription) SetOwnerId(v string) *MountTargetDescription {
	s.OwnerId = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *MountTargetDescription) SetSubnetId(v string) *MountTargetDescription {
	s.SubnetId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *MountTargetDescription) SetVpcId(v string) *MountTargetDescription {
	s.VpcId = &v
	return s
}

// Returned if there is no mount target with the specified ID found in the caller's
// Amazon Web Services account.
type MountTargetNotFound struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// ErrorCode is a required field
	ErrorCode *string `min:"1" type:"string" required:"true"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MountTargetNotFound) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MountTargetNotFound) GoString() string {
	return s.String()
}

func newErrorMountTargetNotFound(v protocol.ResponseMetadata) error {
	return &MountTargetNotFound{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MountTargetNotFound) Code() string {
	return "MountTargetNotFound"
}

// Message returns the exception's message.
func (s *MountTargetNotFound) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MountTargetNotFound) OrigErr() error {
	return nil
}

func (s *MountTargetNotFound) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MountTargetNotFound) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MountTargetNotFound) RequestID() string {
	return s.RespMetadata.RequestID
}

// The calling account has reached the limit for elastic network interfaces
// for the specific Amazon Web Services Region. Either delete some network interfaces
// or request that the account quota be raised. For more information, see Amazon
// VPC Quotas (https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Appendix_Limits.html)
// in the Amazon VPC User Guide (see the Network interfaces per Region entry
// in the Network interfaces table).
type NetworkInterfaceLimitExceeded struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// ErrorCode is a required field
	ErrorCode *string `min:"1" type:"string" required:"true"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkInterfaceLimitExceeded) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkInterfaceLimitExceeded) GoString() string {
	return s.String()
}

func newErrorNetworkInterfaceLimitExceeded(v protocol.ResponseMetadata) error {
	return &NetworkInterfaceLimitExceeded{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NetworkInterfaceLimitExceeded) Code() string {
	return "NetworkInterfaceLimitExceeded"
}

// Message returns the exception's message.
func (s *NetworkInterfaceLimitExceeded) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NetworkInterfaceLimitExceeded) OrigErr() error {
	return nil
}

func (s *NetworkInterfaceLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NetworkInterfaceLimitExceeded) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NetworkInterfaceLimitExceeded) RequestID() string {
	return s.RespMetadata.RequestID
}

// Returned if IpAddress was not specified in the request and there are no free
// IP addresses in the subnet.
type NoFreeAddressesInSubnet struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// ErrorCode is a required field
	ErrorCode *string `min:"1" type:"string" required:"true"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoFreeAddressesInSubnet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NoFreeAddressesInSubnet) GoString() string {
	return s.String()
}

func newErrorNoFreeAddressesInSubnet(v protocol.ResponseMetadata) error {
	return &NoFreeAddressesInSubnet{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NoFreeAddressesInSubnet) Code() string {
	return "NoFreeAddressesInSubnet"
}

// Message returns the exception's message.
func (s *NoFreeAddressesInSubnet) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NoFreeAddressesInSubnet) OrigErr() error {
	return nil
}

func (s *NoFreeAddressesInSubnet) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NoFreeAddressesInSubnet) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NoFreeAddressesInSubnet) RequestID() string {
	return s.RespMetadata.RequestID
}

// Returned if the default file system policy is in effect for the EFS file
// system specified.
type PolicyNotFound struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	ErrorCode *string `min:"1" type:"string"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyNotFound) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PolicyNotFound) GoString() string {
	return s.String()
}

func newErrorPolicyNotFound(v protocol.ResponseMetadata) error {
	return &PolicyNotFound{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *PolicyNotFound) Code() string {
	return "PolicyNotFound"
}

// Message returns the exception's message.
func (s *PolicyNotFound) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *PolicyNotFound) OrigErr() error {
	return nil
}

func (s *PolicyNotFound) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *PolicyNotFound) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *PolicyNotFound) RequestID() string {
	return s.RespMetadata.RequestID
}

// The full POSIX identity, including the user ID, group ID, and any secondary
// group IDs, on the access point that is used for all file system operations
// performed by NFS clients using the access point.
type PosixUser struct {
	_ struct{} `type:"structure"`

	// The POSIX group ID used for all file system operations using this access
	// point.
	//
	// Gid is a required field
	Gid *int64 `type:"long" required:"true"`

	// Secondary POSIX group IDs used for all file system operations using this
	// access point.
	SecondaryGids []*int64 `type:"list"`

	// The POSIX user ID used for all file system operations using this access point.
	//
	// Uid is a required field
	Uid *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PosixUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PosixUser) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PosixUser) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PosixUser"}
	if s.Gid == nil {
		invalidParams.Add(request.NewErrParamRequired("Gid"))
	}
	if s.Uid == nil {
		invalidParams.Add(request.NewErrParamRequired("Uid"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGid sets the Gid field's value.
func (s *PosixUser) SetGid(v int64) *PosixUser {
	s.Gid = &v
	return s
}

// SetSecondaryGids sets the SecondaryGids field's value.
func (s *PosixUser) SetSecondaryGids(v []*int64) *PosixUser {
	s.SecondaryGids = v
	return s
}

// SetUid sets the Uid field's value.
func (s *PosixUser) SetUid(v int64) *PosixUser {
	s.Uid = &v
	return s
}

type PutAccountPreferencesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the EFS resource ID preference to set for the user's Amazon Web
	// Services account, in the current Amazon Web Services Region, either LONG_ID
	// (17 characters), or SHORT_ID (8 characters).
	//
	// Starting in October, 2021, you will receive an error when setting the account
	// preference to SHORT_ID. Contact Amazon Web Services support if you receive
	// an error and must use short IDs for file system and mount target resources.
	//
	// ResourceIdType is a required field
	ResourceIdType *string `type:"string" required:"true" enum:"ResourceIdType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccountPreferencesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccountPreferencesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAccountPreferencesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAccountPreferencesInput"}
	if s.ResourceIdType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIdType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceIdType sets the ResourceIdType field's value.
func (s *PutAccountPreferencesInput) SetResourceIdType(v string) *PutAccountPreferencesInput {
	s.ResourceIdType = &v
	return s
}

type PutAccountPreferencesOutput struct {
	_ struct{} `type:"structure"`

	// Describes the resource type and its ID preference for the user's Amazon Web
	// Services account, in the current Amazon Web Services Region.
	ResourceIdPreference *ResourceIdPreference `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccountPreferencesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutAccountPreferencesOutput) GoString() string {
	return s.String()
}

// SetResourceIdPreference sets the ResourceIdPreference field's value.
func (s *PutAccountPreferencesOutput) SetResourceIdPreference(v *ResourceIdPreference) *PutAccountPreferencesOutput {
	s.ResourceIdPreference = v
	return s
}

type PutBackupPolicyInput struct {
	_ struct{} `type:"structure"`

	// The backup policy included in the PutBackupPolicy request.
	//
	// BackupPolicy is a required field
	BackupPolicy *BackupPolicy `type:"structure" required:"true"`

	// Specifies which EFS file system to update the backup policy for.
	//
	// FileSystemId is a required field
	FileSystemId *string `location:"uri" locationName:"FileSystemId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBackupPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBackupPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBackupPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBackupPolicyInput"}
	if s.BackupPolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupPolicy"))
	}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}
	if s.FileSystemId != nil && len(*s.FileSystemId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileSystemId", 1))
	}
	if s.BackupPolicy != nil {
		if err := s.BackupPolicy.Validate(); err != nil {
			invalidParams.AddNested("BackupPolicy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupPolicy sets the BackupPolicy field's value.
func (s *PutBackupPolicyInput) SetBackupPolicy(v *BackupPolicy) *PutBackupPolicyInput {
	s.BackupPolicy = v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *PutBackupPolicyInput) SetFileSystemId(v string) *PutBackupPolicyInput {
	s.FileSystemId = &v
	return s
}

type PutBackupPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Describes the file system's backup policy, indicating whether automatic backups
	// are turned on or off.
	BackupPolicy *BackupPolicy `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBackupPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBackupPolicyOutput) GoString() string {
	return s.String()
}

// SetBackupPolicy sets the BackupPolicy field's value.
func (s *PutBackupPolicyOutput) SetBackupPolicy(v *BackupPolicy) *PutBackupPolicyOutput {
	s.BackupPolicy = v
	return s
}

type PutFileSystemPolicyInput struct {
	_ struct{} `type:"structure"`

	// (Optional) A boolean that specifies whether or not to bypass the FileSystemPolicy
	// lockout safety check. The lockout safety check determines whether the policy
	// in the request will lock out, or prevent, the IAM principal that is making
	// the request from making future PutFileSystemPolicy requests on this file
	// system. Set BypassPolicyLockoutSafetyCheck to True only when you intend to
	// prevent the IAM principal that is making the request from making subsequent
	// PutFileSystemPolicy requests on this file system. The default value is False.
	BypassPolicyLockoutSafetyCheck *bool `type:"boolean"`

	// The ID of the EFS file system that you want to create or update the FileSystemPolicy
	// for.
	//
	// FileSystemId is a required field
	FileSystemId *string `location:"uri" locationName:"FileSystemId" type:"string" required:"true"`

	// The FileSystemPolicy that you're creating. Accepts a JSON formatted policy
	// definition. EFS file system policies have a 20,000 character limit. To find
	// out more about the elements that make up a file system policy, see EFS Resource-based
	// Policies (https://docs.aws.amazon.com/efs/latest/ug/access-control-overview.html#access-control-manage-access-intro-resource-policies).
	//
	// Policy is a required field
	Policy *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutFileSystemPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutFileSystemPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutFileSystemPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutFileSystemPolicyInput"}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}
	if s.FileSystemId != nil && len(*s.FileSystemId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileSystemId", 1))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBypassPolicyLockoutSafetyCheck sets the BypassPolicyLockoutSafetyCheck field's value.
func (s *PutFileSystemPolicyInput) SetBypassPolicyLockoutSafetyCheck(v bool) *PutFileSystemPolicyInput {
	s.BypassPolicyLockoutSafetyCheck = &v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *PutFileSystemPolicyInput) SetFileSystemId(v string) *PutFileSystemPolicyInput {
	s.FileSystemId = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutFileSystemPolicyInput) SetPolicy(v string) *PutFileSystemPolicyInput {
	s.Policy = &v
	return s
}

type PutFileSystemPolicyOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the EFS file system to which the FileSystemPolicy applies.
	FileSystemId *string `type:"string"`

	// The JSON formatted FileSystemPolicy for the EFS file system.
	Policy *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutFileSystemPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutFileSystemPolicyOutput) GoString() string {
	return s.String()
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *PutFileSystemPolicyOutput) SetFileSystemId(v string) *PutFileSystemPolicyOutput {
	s.FileSystemId = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutFileSystemPolicyOutput) SetPolicy(v string) *PutFileSystemPolicyOutput {
	s.Policy = &v
	return s
}

type PutLifecycleConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the file system for which you are creating the LifecycleConfiguration
	// object (String).
	//
	// FileSystemId is a required field
	FileSystemId *string `location:"uri" locationName:"FileSystemId" type:"string" required:"true"`

	// An array of LifecyclePolicy objects that define the file system's LifecycleConfiguration
	// object. A LifecycleConfiguration object informs EFS lifecycle management
	// and EFS Intelligent-Tiering of the following:
	//
	//    * When to move files in the file system from primary storage to the IA
	//    storage class.
	//
	//    * When to move files that are in IA storage to primary storage.
	//
	// When using the put-lifecycle-configuration CLI command or the PutLifecycleConfiguration
	// API action, Amazon EFS requires that each LifecyclePolicy object have only
	// a single transition. This means that in a request body, LifecyclePolicies
	// must be structured as an array of LifecyclePolicy objects, one object for
	// each transition, TransitionToIA, TransitionToPrimaryStorageClass. See the
	// example requests in the following section for more information.
	//
	// LifecyclePolicies is a required field
	LifecyclePolicies []*LifecyclePolicy `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLifecycleConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLifecycleConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutLifecycleConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutLifecycleConfigurationInput"}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}
	if s.FileSystemId != nil && len(*s.FileSystemId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileSystemId", 1))
	}
	if s.LifecyclePolicies == nil {
		invalidParams.Add(request.NewErrParamRequired("LifecyclePolicies"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *PutLifecycleConfigurationInput) SetFileSystemId(v string) *PutLifecycleConfigurationInput {
	s.FileSystemId = &v
	return s
}

// SetLifecyclePolicies sets the LifecyclePolicies field's value.
func (s *PutLifecycleConfigurationInput) SetLifecyclePolicies(v []*LifecyclePolicy) *PutLifecycleConfigurationInput {
	s.LifecyclePolicies = v
	return s
}

type PutLifecycleConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// An array of lifecycle management policies. EFS supports a maximum of one
	// policy per file system.
	LifecyclePolicies []*LifecyclePolicy `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLifecycleConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutLifecycleConfigurationOutput) GoString() string {
	return s.String()
}

// SetLifecyclePolicies sets the LifecyclePolicies field's value.
func (s *PutLifecycleConfigurationOutput) SetLifecyclePolicies(v []*LifecyclePolicy) *PutLifecycleConfigurationOutput {
	s.LifecyclePolicies = v
	return s
}

// Describes the replication configuration for a specific file system.
type ReplicationConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// Describes when the replication configuration was created.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// An array of destination objects. Only one destination object is supported.
	//
	// Destinations is a required field
	Destinations []*Destination `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the original source Amazon EFS file system
	// in the replication configuration.
	//
	// OriginalSourceFileSystemArn is a required field
	OriginalSourceFileSystemArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the current source file system in the replication
	// configuration.
	//
	// SourceFileSystemArn is a required field
	SourceFileSystemArn *string `type:"string" required:"true"`

	// The ID of the source Amazon EFS file system that is being replicated.
	//
	// SourceFileSystemId is a required field
	SourceFileSystemId *string `type:"string" required:"true"`

	// The Amazon Web Services Region in which the source Amazon EFS file system
	// is located.
	//
	// SourceFileSystemRegion is a required field
	SourceFileSystemRegion *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicationConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicationConfigurationDescription) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *ReplicationConfigurationDescription) SetCreationTime(v time.Time) *ReplicationConfigurationDescription {
	s.CreationTime = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *ReplicationConfigurationDescription) SetDestinations(v []*Destination) *ReplicationConfigurationDescription {
	s.Destinations = v
	return s
}

// SetOriginalSourceFileSystemArn sets the OriginalSourceFileSystemArn field's value.
func (s *ReplicationConfigurationDescription) SetOriginalSourceFileSystemArn(v string) *ReplicationConfigurationDescription {
	s.OriginalSourceFileSystemArn = &v
	return s
}

// SetSourceFileSystemArn sets the SourceFileSystemArn field's value.
func (s *ReplicationConfigurationDescription) SetSourceFileSystemArn(v string) *ReplicationConfigurationDescription {
	s.SourceFileSystemArn = &v
	return s
}

// SetSourceFileSystemId sets the SourceFileSystemId field's value.
func (s *ReplicationConfigurationDescription) SetSourceFileSystemId(v string) *ReplicationConfigurationDescription {
	s.SourceFileSystemId = &v
	return s
}

// SetSourceFileSystemRegion sets the SourceFileSystemRegion field's value.
func (s *ReplicationConfigurationDescription) SetSourceFileSystemRegion(v string) *ReplicationConfigurationDescription {
	s.SourceFileSystemRegion = &v
	return s
}

// Returned if the specified file system does not have a replication configuration.
type ReplicationNotFound struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// ReplicationNotFound
	ErrorCode *string `min:"1" type:"string"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicationNotFound) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReplicationNotFound) GoString() string {
	return s.String()
}

func newErrorReplicationNotFound(v protocol.ResponseMetadata) error {
	return &ReplicationNotFound{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ReplicationNotFound) Code() string {
	return "ReplicationNotFound"
}

// Message returns the exception's message.
func (s *ReplicationNotFound) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ReplicationNotFound) OrigErr() error {
	return nil
}

func (s *ReplicationNotFound) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ReplicationNotFound) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ReplicationNotFound) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes the resource type and its ID preference for the user's Amazon Web
// Services account, in the current Amazon Web Services Region.
type ResourceIdPreference struct {
	_ struct{} `type:"structure"`

	// Identifies the EFS resource ID preference, either LONG_ID (17 characters)
	// or SHORT_ID (8 characters).
	ResourceIdType *string `type:"string" enum:"ResourceIdType"`

	// Identifies the Amazon EFS resources to which the ID preference setting applies,
	// FILE_SYSTEM and MOUNT_TARGET.
	Resources []*string `type:"list" enum:"Resource"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceIdPreference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceIdPreference) GoString() string {
	return s.String()
}

// SetResourceIdType sets the ResourceIdType field's value.
func (s *ResourceIdPreference) SetResourceIdType(v string) *ResourceIdPreference {
	s.ResourceIdType = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *ResourceIdPreference) SetResources(v []*string) *ResourceIdPreference {
	s.Resources = v
	return s
}

// Specifies the directory on the Amazon EFS file system that the access point
// provides access to. The access point exposes the specified file system path
// as the root directory of your file system to applications using the access
// point. NFS clients using the access point can only access data in the access
// point's RootDirectory and it's subdirectories.
type RootDirectory struct {
	_ struct{} `type:"structure"`

	// (Optional) Specifies the POSIX IDs and permissions to apply to the access
	// point's RootDirectory. If the RootDirectory > Path specified does not exist,
	// EFS creates the root directory using the CreationInfo settings when a client
	// connects to an access point. When specifying the CreationInfo, you must provide
	// values for all properties.
	//
	// If you do not provide CreationInfo and the specified RootDirectory > Path
	// does not exist, attempts to mount the file system using the access point
	// will fail.
	CreationInfo *CreationInfo `type:"structure"`

	// Specifies the path on the EFS file system to expose as the root directory
	// to NFS clients using the access point to access the EFS file system. A path
	// can have up to four subdirectories. If the specified path does not exist,
	// you are required to provide the CreationInfo.
	Path *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RootDirectory) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RootDirectory) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RootDirectory) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RootDirectory"}
	if s.Path != nil && len(*s.Path) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Path", 1))
	}
	if s.CreationInfo != nil {
		if err := s.CreationInfo.Validate(); err != nil {
			invalidParams.AddNested("CreationInfo", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreationInfo sets the CreationInfo field's value.
func (s *RootDirectory) SetCreationInfo(v *CreationInfo) *RootDirectory {
	s.CreationInfo = v
	return s
}

// SetPath sets the Path field's value.
func (s *RootDirectory) SetPath(v string) *RootDirectory {
	s.Path = &v
	return s
}

// Returned if the size of SecurityGroups specified in the request is greater
// than five.
type SecurityGroupLimitExceeded struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// ErrorCode is a required field
	ErrorCode *string `min:"1" type:"string" required:"true"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecurityGroupLimitExceeded) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecurityGroupLimitExceeded) GoString() string {
	return s.String()
}

func newErrorSecurityGroupLimitExceeded(v protocol.ResponseMetadata) error {
	return &SecurityGroupLimitExceeded{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SecurityGroupLimitExceeded) Code() string {
	return "SecurityGroupLimitExceeded"
}

// Message returns the exception's message.
func (s *SecurityGroupLimitExceeded) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SecurityGroupLimitExceeded) OrigErr() error {
	return nil
}

func (s *SecurityGroupLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SecurityGroupLimitExceeded) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SecurityGroupLimitExceeded) RequestID() string {
	return s.RespMetadata.RequestID
}

// Returned if one of the specified security groups doesn't exist in the subnet's
// virtual private cloud (VPC).
type SecurityGroupNotFound struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// ErrorCode is a required field
	ErrorCode *string `min:"1" type:"string" required:"true"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecurityGroupNotFound) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SecurityGroupNotFound) GoString() string {
	return s.String()
}

func newErrorSecurityGroupNotFound(v protocol.ResponseMetadata) error {
	return &SecurityGroupNotFound{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SecurityGroupNotFound) Code() string {
	return "SecurityGroupNotFound"
}

// Message returns the exception's message.
func (s *SecurityGroupNotFound) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SecurityGroupNotFound) OrigErr() error {
	return nil
}

func (s *SecurityGroupNotFound) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SecurityGroupNotFound) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SecurityGroupNotFound) RequestID() string {
	return s.RespMetadata.RequestID
}

// Returned if there is no subnet with ID SubnetId provided in the request.
type SubnetNotFound struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// ErrorCode is a required field
	ErrorCode *string `min:"1" type:"string" required:"true"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubnetNotFound) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubnetNotFound) GoString() string {
	return s.String()
}

func newErrorSubnetNotFound(v protocol.ResponseMetadata) error {
	return &SubnetNotFound{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SubnetNotFound) Code() string {
	return "SubnetNotFound"
}

// Message returns the exception's message.
func (s *SubnetNotFound) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SubnetNotFound) OrigErr() error {
	return nil
}

func (s *SubnetNotFound) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SubnetNotFound) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SubnetNotFound) RequestID() string {
	return s.RespMetadata.RequestID
}

// A tag is a key-value pair. Allowed characters are letters, white space, and
// numbers that can be represented in UTF-8, and the following characters:+
// - = . _ : /.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag key (String). The key can't start with aws:.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag key.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ID specifying the EFS resource that you want to create a tag for.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"ResourceId" type:"string" required:"true"`

	// An array of Tag objects to add. Each Tag object is a key-value pair.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *TagResourceInput) SetResourceId(v string) *TagResourceInput {
	s.ResourceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Returned when the CreateAccessPoint API action is called too quickly and
// the number of Access Points on the file system is nearing the limit of 120
// (https://docs.aws.amazon.com/efs/latest/ug/limits.html#limits-efs-resources-per-account-per-region).
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	ErrorCode *string `min:"1" type:"string"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Returned if the throughput mode or amount of provisioned throughput can't
// be changed because the throughput limit of 1024 MiB/s has been reached.
type ThroughputLimitExceeded struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// ErrorCode is a required field
	ErrorCode *string `min:"1" type:"string" required:"true"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThroughputLimitExceeded) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThroughputLimitExceeded) GoString() string {
	return s.String()
}

func newErrorThroughputLimitExceeded(v protocol.ResponseMetadata) error {
	return &ThroughputLimitExceeded{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThroughputLimitExceeded) Code() string {
	return "ThroughputLimitExceeded"
}

// Message returns the exception's message.
func (s *ThroughputLimitExceeded) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThroughputLimitExceeded) OrigErr() error {
	return nil
}

func (s *ThroughputLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThroughputLimitExceeded) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThroughputLimitExceeded) RequestID() string {
	return s.RespMetadata.RequestID
}

// Returned if you don’t wait at least 24 hours before either changing the
// throughput mode, or decreasing the Provisioned Throughput value.
type TooManyRequests struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// ErrorCode is a required field
	ErrorCode *string `min:"1" type:"string" required:"true"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequests) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequests) GoString() string {
	return s.String()
}

func newErrorTooManyRequests(v protocol.ResponseMetadata) error {
	return &TooManyRequests{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequests) Code() string {
	return "TooManyRequests"
}

// Message returns the exception's message.
func (s *TooManyRequests) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequests) OrigErr() error {
	return nil
}

func (s *TooManyRequests) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequests) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequests) RequestID() string {
	return s.RespMetadata.RequestID
}

// Returned if the requested Amazon EFS functionality is not available in the
// specified Availability Zone.
type UnsupportedAvailabilityZone struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// ErrorCode is a required field
	ErrorCode *string `min:"1" type:"string" required:"true"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedAvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedAvailabilityZone) GoString() string {
	return s.String()
}

func newErrorUnsupportedAvailabilityZone(v protocol.ResponseMetadata) error {
	return &UnsupportedAvailabilityZone{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedAvailabilityZone) Code() string {
	return "UnsupportedAvailabilityZone"
}

// Message returns the exception's message.
func (s *UnsupportedAvailabilityZone) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedAvailabilityZone) OrigErr() error {
	return nil
}

func (s *UnsupportedAvailabilityZone) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedAvailabilityZone) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedAvailabilityZone) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Specifies the EFS resource that you want to remove tags from.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"ResourceId" type:"string" required:"true"`

	// The keys of the key-value tag pairs that you want to remove from the specified
	// EFS resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *UntagResourceInput) SetResourceId(v string) *UntagResourceInput {
	s.ResourceId = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateFileSystemInput struct {
	_ struct{} `type:"structure"`

	// The ID of the file system that you want to update.
	//
	// FileSystemId is a required field
	FileSystemId *string `location:"uri" locationName:"FileSystemId" type:"string" required:"true"`

	// (Optional) The throughput, measured in mebibytes per second (MiBps), that
	// you want to provision for a file system that you're creating. Required if
	// ThroughputMode is set to provisioned. Valid values are 1-3414 MiBps, with
	// the upper limit depending on Region. To increase this limit, contact Amazon
	// Web Services Support. For more information, see Amazon EFS quotas that you
	// can increase (https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits)
	// in the Amazon EFS User Guide.
	ProvisionedThroughputInMibps *float64 `min:"1" type:"double"`

	// (Optional) Updates the file system's throughput mode. If you're not updating
	// your throughput mode, you don't need to provide this value in your request.
	// If you are changing the ThroughputMode to provisioned, you must also set
	// a value for ProvisionedThroughputInMibps.
	ThroughputMode *string `type:"string" enum:"ThroughputMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFileSystemInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFileSystemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFileSystemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateFileSystemInput"}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}
	if s.FileSystemId != nil && len(*s.FileSystemId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileSystemId", 1))
	}
	if s.ProvisionedThroughputInMibps != nil && *s.ProvisionedThroughputInMibps < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ProvisionedThroughputInMibps", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *UpdateFileSystemInput) SetFileSystemId(v string) *UpdateFileSystemInput {
	s.FileSystemId = &v
	return s
}

// SetProvisionedThroughputInMibps sets the ProvisionedThroughputInMibps field's value.
func (s *UpdateFileSystemInput) SetProvisionedThroughputInMibps(v float64) *UpdateFileSystemInput {
	s.ProvisionedThroughputInMibps = &v
	return s
}

// SetThroughputMode sets the ThroughputMode field's value.
func (s *UpdateFileSystemInput) SetThroughputMode(v string) *UpdateFileSystemInput {
	s.ThroughputMode = &v
	return s
}

// A description of the file system.
type UpdateFileSystemOutput struct {
	_ struct{} `type:"structure"`

	// The unique and consistent identifier of the Availability Zone in which the
	// file system's One Zone storage classes exist. For example, use1-az1 is an
	// Availability Zone ID for the us-east-1 Amazon Web Services Region, and it
	// has the same location in every Amazon Web Services account.
	AvailabilityZoneId *string `type:"string"`

	// Describes the Amazon Web Services Availability Zone in which the file system
	// is located, and is valid only for file systems using One Zone storage classes.
	// For more information, see Using EFS storage classes (https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html)
	// in the Amazon EFS User Guide.
	AvailabilityZoneName *string `min:"1" type:"string"`

	// The time that the file system was created, in seconds (since 1970-01-01T00:00:00Z).
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The opaque string specified in the request.
	//
	// CreationToken is a required field
	CreationToken *string `min:"1" type:"string" required:"true"`

	// A Boolean value that, if true, indicates that the file system is encrypted.
	Encrypted *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) for the EFS file system, in the format arn:aws:elasticfilesystem:region:account-id:file-system/file-system-id
	// . Example with sample data: arn:aws:elasticfilesystem:us-west-2:1111333322228888:file-system/fs-01234567
	FileSystemArn *string `type:"string"`

	// The ID of the file system, assigned by Amazon EFS.
	//
	// FileSystemId is a required field
	FileSystemId *string `type:"string" required:"true"`

	// The ID of an KMS key used to protect the encrypted file system.
	KmsKeyId *string `type:"string"`

	// The lifecycle phase of the file system.
	//
	// LifeCycleState is a required field
	LifeCycleState *string `type:"string" required:"true" enum:"LifeCycleState"`

	// You can add tags to a file system, including a Name tag. For more information,
	// see CreateFileSystem. If the file system has a Name tag, Amazon EFS returns
	// the value in this field.
	Name *string `type:"string"`

	// The current number of mount targets that the file system has. For more information,
	// see CreateMountTarget.
	//
	// NumberOfMountTargets is a required field
	NumberOfMountTargets *int64 `type:"integer" required:"true"`

	// The Amazon Web Services account that created the file system.
	//
	// OwnerId is a required field
	OwnerId *string `type:"string" required:"true"`

	// The performance mode of the file system.
	//
	// PerformanceMode is a required field
	PerformanceMode *string `type:"string" required:"true" enum:"PerformanceMode"`

	// The amount of provisioned throughput, measured in MiBps, for the file system.
	// Valid for file systems using ThroughputMode set to provisioned.
	ProvisionedThroughputInMibps *float64 `min:"1" type:"double"`

	// The latest known metered size (in bytes) of data stored in the file system,
	// in its Value field, and the time at which that size was determined in its
	// Timestamp field. The Timestamp value is the integer number of seconds since
	// 1970-01-01T00:00:00Z. The SizeInBytes value doesn't represent the size of
	// a consistent snapshot of the file system, but it is eventually consistent
	// when there are no writes to the file system. That is, SizeInBytes represents
	// actual size only if the file system is not modified for a period longer than
	// a couple of hours. Otherwise, the value is not the exact size that the file
	// system was at any point in time.
	//
	// SizeInBytes is a required field
	SizeInBytes *FileSystemSize `type:"structure" required:"true"`

	// The tags associated with the file system, presented as an array of Tag objects.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`

	// Displays the file system's throughput mode. For more information, see Throughput
	// modes (https://docs.aws.amazon.com/efs/latest/ug/performance.html#throughput-modes)
	// in the Amazon EFS User Guide.
	ThroughputMode *string `type:"string" enum:"ThroughputMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFileSystemOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateFileSystemOutput) GoString() string {
	return s.String()
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *UpdateFileSystemOutput) SetAvailabilityZoneId(v string) *UpdateFileSystemOutput {
	s.AvailabilityZoneId = &v
	return s
}

// SetAvailabilityZoneName sets the AvailabilityZoneName field's value.
func (s *UpdateFileSystemOutput) SetAvailabilityZoneName(v string) *UpdateFileSystemOutput {
	s.AvailabilityZoneName = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *UpdateFileSystemOutput) SetCreationTime(v time.Time) *UpdateFileSystemOutput {
	s.CreationTime = &v
	return s
}

// SetCreationToken sets the CreationToken field's value.
func (s *UpdateFileSystemOutput) SetCreationToken(v string) *UpdateFileSystemOutput {
	s.CreationToken = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *UpdateFileSystemOutput) SetEncrypted(v bool) *UpdateFileSystemOutput {
	s.Encrypted = &v
	return s
}

// SetFileSystemArn sets the FileSystemArn field's value.
func (s *UpdateFileSystemOutput) SetFileSystemArn(v string) *UpdateFileSystemOutput {
	s.FileSystemArn = &v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *UpdateFileSystemOutput) SetFileSystemId(v string) *UpdateFileSystemOutput {
	s.FileSystemId = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *UpdateFileSystemOutput) SetKmsKeyId(v string) *UpdateFileSystemOutput {
	s.KmsKeyId = &v
	return s
}

// SetLifeCycleState sets the LifeCycleState field's value.
func (s *UpdateFileSystemOutput) SetLifeCycleState(v string) *UpdateFileSystemOutput {
	s.LifeCycleState = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateFileSystemOutput) SetName(v string) *UpdateFileSystemOutput {
	s.Name = &v
	return s
}

// SetNumberOfMountTargets sets the NumberOfMountTargets field's value.
func (s *UpdateFileSystemOutput) SetNumberOfMountTargets(v int64) *UpdateFileSystemOutput {
	s.NumberOfMountTargets = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *UpdateFileSystemOutput) SetOwnerId(v string) *UpdateFileSystemOutput {
	s.OwnerId = &v
	return s
}

// SetPerformanceMode sets the PerformanceMode field's value.
func (s *UpdateFileSystemOutput) SetPerformanceMode(v string) *UpdateFileSystemOutput {
	s.PerformanceMode = &v
	return s
}

// SetProvisionedThroughputInMibps sets the ProvisionedThroughputInMibps field's value.
func (s *UpdateFileSystemOutput) SetProvisionedThroughputInMibps(v float64) *UpdateFileSystemOutput {
	s.ProvisionedThroughputInMibps = &v
	return s
}

// SetSizeInBytes sets the SizeInBytes field's value.
func (s *UpdateFileSystemOutput) SetSizeInBytes(v *FileSystemSize) *UpdateFileSystemOutput {
	s.SizeInBytes = v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateFileSystemOutput) SetTags(v []*Tag) *UpdateFileSystemOutput {
	s.Tags = v
	return s
}

// SetThroughputMode sets the ThroughputMode field's value.
func (s *UpdateFileSystemOutput) SetThroughputMode(v string) *UpdateFileSystemOutput {
	s.ThroughputMode = &v
	return s
}

// Returned if the Backup service is not available in the Amazon Web Services
// Region in which the request was made.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The error code is a string that uniquely identifies an error condition. It
	// is meant to be read and understood by programs that detect and handle errors
	// by type.
	//
	// ErrorCode is a required field
	ErrorCode *string `min:"1" type:"string" required:"true"`

	// The error message contains a generic description of the error condition in
	// English. It is intended for a human audience. Simple programs display the
	// message directly to the end user if they encounter an error condition they
	// don't know how or don't care to handle. Sophisticated programs with more
	// exhaustive error handling and proper internationalization are more likely
	// to ignore the error message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// LifeCycleStateCreating is a LifeCycleState enum value
	LifeCycleStateCreating = "creating"

	// LifeCycleStateAvailable is a LifeCycleState enum value
	LifeCycleStateAvailable = "available"

	// LifeCycleStateUpdating is a LifeCycleState enum value
	LifeCycleStateUpdating = "updating"

	// LifeCycleStateDeleting is a LifeCycleState enum value
	LifeCycleStateDeleting = "deleting"

	// LifeCycleStateDeleted is a LifeCycleState enum value
	LifeCycleStateDeleted = "deleted"

	// LifeCycleStateError is a LifeCycleState enum value
	LifeCycleStateError = "error"
)

// LifeCycleState_Values returns all elements of the LifeCycleState enum
func LifeCycleState_Values() []string {
	return []string{
		LifeCycleStateCreating,
		LifeCycleStateAvailable,
		LifeCycleStateUpdating,
		LifeCycleStateDeleting,
		LifeCycleStateDeleted,
		LifeCycleStateError,
	}
}

const (
	// PerformanceModeGeneralPurpose is a PerformanceMode enum value
	PerformanceModeGeneralPurpose = "generalPurpose"

	// PerformanceModeMaxIo is a PerformanceMode enum value
	PerformanceModeMaxIo = "maxIO"
)

// PerformanceMode_Values returns all elements of the PerformanceMode enum
func PerformanceMode_Values() []string {
	return []string{
		PerformanceModeGeneralPurpose,
		PerformanceModeMaxIo,
	}
}

const (
	// ReplicationStatusEnabled is a ReplicationStatus enum value
	ReplicationStatusEnabled = "ENABLED"

	// ReplicationStatusEnabling is a ReplicationStatus enum value
	ReplicationStatusEnabling = "ENABLING"

	// ReplicationStatusDeleting is a ReplicationStatus enum value
	ReplicationStatusDeleting = "DELETING"

	// ReplicationStatusError is a ReplicationStatus enum value
	ReplicationStatusError = "ERROR"

	// ReplicationStatusPaused is a ReplicationStatus enum value
	ReplicationStatusPaused = "PAUSED"

	// ReplicationStatusPausing is a ReplicationStatus enum value
	ReplicationStatusPausing = "PAUSING"
)

// ReplicationStatus_Values returns all elements of the ReplicationStatus enum
func ReplicationStatus_Values() []string {
	return []string{
		ReplicationStatusEnabled,
		ReplicationStatusEnabling,
		ReplicationStatusDeleting,
		ReplicationStatusError,
		ReplicationStatusPaused,
		ReplicationStatusPausing,
	}
}

// An EFS resource, for example a file system or a mount target.
const (
	// ResourceFileSystem is a Resource enum value
	ResourceFileSystem = "FILE_SYSTEM"

	// ResourceMountTarget is a Resource enum value
	ResourceMountTarget = "MOUNT_TARGET"
)

// Resource_Values returns all elements of the Resource enum
func Resource_Values() []string {
	return []string{
		ResourceFileSystem,
		ResourceMountTarget,
	}
}

// A preference indicating a choice to use 63bit/32bit IDs for all applicable
// resources.
const (
	// ResourceIdTypeLongId is a ResourceIdType enum value
	ResourceIdTypeLongId = "LONG_ID"

	// ResourceIdTypeShortId is a ResourceIdType enum value
	ResourceIdTypeShortId = "SHORT_ID"
)

// ResourceIdType_Values returns all elements of the ResourceIdType enum
func ResourceIdType_Values() []string {
	return []string{
		ResourceIdTypeLongId,
		ResourceIdTypeShortId,
	}
}

const (
	// StatusEnabled is a Status enum value
	StatusEnabled = "ENABLED"

	// StatusEnabling is a Status enum value
	StatusEnabling = "ENABLING"

	// StatusDisabled is a Status enum value
	StatusDisabled = "DISABLED"

	// StatusDisabling is a Status enum value
	StatusDisabling = "DISABLING"
)

// Status_Values returns all elements of the Status enum
func Status_Values() []string {
	return []string{
		StatusEnabled,
		StatusEnabling,
		StatusDisabled,
		StatusDisabling,
	}
}

const (
	// ThroughputModeBursting is a ThroughputMode enum value
	ThroughputModeBursting = "bursting"

	// ThroughputModeProvisioned is a ThroughputMode enum value
	ThroughputModeProvisioned = "provisioned"

	// ThroughputModeElastic is a ThroughputMode enum value
	ThroughputModeElastic = "elastic"
)

// ThroughputMode_Values returns all elements of the ThroughputMode enum
func ThroughputMode_Values() []string {
	return []string{
		ThroughputModeBursting,
		ThroughputModeProvisioned,
		ThroughputModeElastic,
	}
}

const (
	// TransitionToIARulesAfter7Days is a TransitionToIARules enum value
	TransitionToIARulesAfter7Days = "AFTER_7_DAYS"

	// TransitionToIARulesAfter14Days is a TransitionToIARules enum value
	TransitionToIARulesAfter14Days = "AFTER_14_DAYS"

	// TransitionToIARulesAfter30Days is a TransitionToIARules enum value
	TransitionToIARulesAfter30Days = "AFTER_30_DAYS"

	// TransitionToIARulesAfter60Days is a TransitionToIARules enum value
	TransitionToIARulesAfter60Days = "AFTER_60_DAYS"

	// TransitionToIARulesAfter90Days is a TransitionToIARules enum value
	TransitionToIARulesAfter90Days = "AFTER_90_DAYS"

	// TransitionToIARulesAfter1Day is a TransitionToIARules enum value
	TransitionToIARulesAfter1Day = "AFTER_1_DAY"
)

// TransitionToIARules_Values returns all elements of the TransitionToIARules enum
func TransitionToIARules_Values() []string {
	return []string{
		TransitionToIARulesAfter7Days,
		TransitionToIARulesAfter14Days,
		TransitionToIARulesAfter30Days,
		TransitionToIARulesAfter60Days,
		TransitionToIARulesAfter90Days,
		TransitionToIARulesAfter1Day,
	}
}

const (
	// TransitionToPrimaryStorageClassRulesAfter1Access is a TransitionToPrimaryStorageClassRules enum value
	TransitionToPrimaryStorageClassRulesAfter1Access = "AFTER_1_ACCESS"
)

// TransitionToPrimaryStorageClassRules_Values returns all elements of the TransitionToPrimaryStorageClassRules enum
func TransitionToPrimaryStorageClassRules_Values() []string {
	return []string{
		TransitionToPrimaryStorageClassRulesAfter1Access,
	}
}
