// Copyright 2026 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package merchantapi provides access to the Merchant API.
//
// For product documentation, see: https://developers.google.com/merchant/api
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/merchantapi/reports/v1"
//	...
//	ctx := context.Background()
//	merchantapiService, err := merchantapi.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	merchantapiService, err := merchantapi.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	merchantapiService, err := merchantapi.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package merchantapi // import "google.golang.org/api/merchantapi/reports/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "merchantapi:reports_v1"
const apiName = "merchantapi"
const apiVersion = "reports_v1"
const basePath = "https://merchantapi.googleapis.com/"
const basePathTemplate = "https://merchantapi.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://merchantapi.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// Manage your product listings and accounts for Google Shopping
	ContentScope = "https://www.googleapis.com/auth/content"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/content",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Accounts = NewAccountsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Accounts *AccountsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAccountsService(s *Service) *AccountsService {
	rs := &AccountsService{s: s}
	rs.Reports = NewAccountsReportsService(s)
	return rs
}

type AccountsService struct {
	s *Service

	Reports *AccountsReportsService
}

func NewAccountsReportsService(s *Service) *AccountsReportsService {
	rs := &AccountsReportsService{s: s}
	return rs
}

type AccountsReportsService struct {
	s *Service
}

// BestSellersBrandView: Fields available for query in
// `best_sellers_brand_view` table. Best sellers
// (https://support.google.com/merchants/answer/9488679) report with top
// brands. Values are only set for fields requested explicitly in the request's
// search query.
type BestSellersBrandView struct {
	// Brand: Name of the brand.
	Brand string `json:"brand,omitempty"`
	// PreviousRank: Popularity rank in the previous week or month.
	PreviousRank int64 `json:"previousRank,omitempty,string"`
	// PreviousRelativeDemand: Estimated demand in relation to the brand with the
	// highest popularity rank in the same category and country in the previous
	// week or month.
	//
	// Possible values:
	//   "RELATIVE_DEMAND_ENUM_UNSPECIFIED" - Not specified.
	//   "VERY_LOW" - Demand is 0-5% of the demand of the highest ranked product
	// cluster or brand.
	//   "LOW" - Demand is 6-10% of the demand of the highest ranked product
	// cluster or brand.
	//   "MEDIUM" - Demand is 11-20% of the demand of the highest ranked product
	// cluster or brand.
	//   "HIGH" - Demand is 21-50% of the demand of the highest ranked product
	// cluster or brand.
	//   "VERY_HIGH" - Demand is 51-100% of the demand of the highest ranked
	// product cluster or brand.
	PreviousRelativeDemand string `json:"previousRelativeDemand,omitempty"`
	// Rank: Popularity of the brand on Ads and organic surfaces, in the selected
	// category and country, based on the estimated number of units sold.
	Rank int64 `json:"rank,omitempty,string"`
	// RelativeDemand: Estimated demand in relation to the brand with the highest
	// popularity rank in the same category and country.
	//
	// Possible values:
	//   "RELATIVE_DEMAND_ENUM_UNSPECIFIED" - Not specified.
	//   "VERY_LOW" - Demand is 0-5% of the demand of the highest ranked product
	// cluster or brand.
	//   "LOW" - Demand is 6-10% of the demand of the highest ranked product
	// cluster or brand.
	//   "MEDIUM" - Demand is 11-20% of the demand of the highest ranked product
	// cluster or brand.
	//   "HIGH" - Demand is 21-50% of the demand of the highest ranked product
	// cluster or brand.
	//   "VERY_HIGH" - Demand is 51-100% of the demand of the highest ranked
	// product cluster or brand.
	RelativeDemand string `json:"relativeDemand,omitempty"`
	// RelativeDemandChange: Change in the estimated demand. Whether it rose, sank
	// or remained flat.
	//
	// Possible values:
	//   "RELATIVE_DEMAND_CHANGE_TYPE_ENUM_UNSPECIFIED" - Not specified.
	//   "SINKER" - Relative demand is lower than the previous time period.
	//   "FLAT" - Relative demand is equal to the previous time period.
	//   "RISER" - Relative demand is higher than the previous time period.
	RelativeDemandChange string `json:"relativeDemandChange,omitempty"`
	// ReportCategoryId: Google product category ID to calculate the ranking for,
	// represented in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436). Required in the
	// `SELECT` clause. If a `WHERE` condition on `report_category_id` is not
	// specified in the query, rankings for all top-level categories are returned.
	ReportCategoryId int64 `json:"reportCategoryId,omitempty,string"`
	// ReportCountryCode: Country where the ranking is calculated. Represented in
	// the ISO 3166 format. Required in the `SELECT` clause. Condition on
	// `report_country_code` is required in the `WHERE` clause.
	ReportCountryCode string `json:"reportCountryCode,omitempty"`
	// ReportDate: Report date. The value of this field can only be one of the
	// following: * The first day of the week (Monday) for weekly reports, * The
	// first day of the month for monthly reports. Required in the `SELECT` clause.
	// If a `WHERE` condition on `report_date` is not specified in the query, the
	// latest available weekly or monthly report is returned.
	ReportDate *Date `json:"reportDate,omitempty"`
	// ReportGranularity: Granularity of the report. The ranking can be done over a
	// week or a month timeframe. Required in the `SELECT` clause. Condition on
	// `report_granularity` is required in the `WHERE` clause.
	//
	// Possible values:
	//   "REPORT_GRANULARITY_ENUM_UNSPECIFIED" - Not specified.
	//   "WEEKLY" - Report is computed over a week timeframe.
	//   "MONTHLY" - Report is computed over a month timeframe.
	ReportGranularity string `json:"reportGranularity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Brand") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Brand") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BestSellersBrandView) MarshalJSON() ([]byte, error) {
	type NoMethod BestSellersBrandView
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BestSellersProductClusterView: Fields available for query in
// `best_sellers_product_cluster_view` table. Best sellers
// (https://support.google.com/merchants/answer/9488679) report with top
// product clusters. A product cluster is a grouping for different offers and
// variants that represent the same product, for example, Google Pixel 7.
// Values are only set for fields requested explicitly in the request's search
// query.
type BestSellersProductClusterView struct {
	// Brand: Brand of the product cluster.
	Brand string `json:"brand,omitempty"`
	// BrandInventoryStatus: Whether there is at least one product of the brand
	// currently `IN_STOCK` in your product data source in at least one of the
	// countries, all products are `OUT_OF_STOCK` in your product data source in
	// all countries, or `NOT_IN_INVENTORY`. The field doesn't take the Best
	// sellers report country filter into account.
	//
	// Possible values:
	//   "INVENTORY_STATUS_UNSPECIFIED" - Not specified.
	//   "IN_STOCK" - You have a product for this product cluster or brand in
	// stock.
	//   "OUT_OF_STOCK" - You have a product for this product cluster or brand in
	// inventory but it is currently out of stock.
	//   "NOT_IN_INVENTORY" - You do not have a product for this product cluster or
	// brand in inventory.
	BrandInventoryStatus string `json:"brandInventoryStatus,omitempty"`
	// CategoryL1: Product category (1st level) of the product cluster, represented
	// in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436).
	CategoryL1 string `json:"categoryL1,omitempty"`
	// CategoryL2: Product category (2nd level) of the product cluster, represented
	// in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436).
	CategoryL2 string `json:"categoryL2,omitempty"`
	// CategoryL3: Product category (3rd level) of the product cluster, represented
	// in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436).
	CategoryL3 string `json:"categoryL3,omitempty"`
	// CategoryL4: Product category (4th level) of the product cluster, represented
	// in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436).
	CategoryL4 string `json:"categoryL4,omitempty"`
	// CategoryL5: Product category (5th level) of the product cluster, represented
	// in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436).
	CategoryL5 string `json:"categoryL5,omitempty"`
	// InventoryStatus: Whether the product cluster is `IN_STOCK` in your product
	// data source in at least one of the countries, `OUT_OF_STOCK` in your product
	// data source in all countries, or `NOT_IN_INVENTORY` at all. The field
	// doesn't take the Best sellers report country filter into account.
	//
	// Possible values:
	//   "INVENTORY_STATUS_UNSPECIFIED" - Not specified.
	//   "IN_STOCK" - You have a product for this product cluster or brand in
	// stock.
	//   "OUT_OF_STOCK" - You have a product for this product cluster or brand in
	// inventory but it is currently out of stock.
	//   "NOT_IN_INVENTORY" - You do not have a product for this product cluster or
	// brand in inventory.
	InventoryStatus string `json:"inventoryStatus,omitempty"`
	// PreviousRank: Popularity rank in the previous week or month.
	PreviousRank int64 `json:"previousRank,omitempty,string"`
	// PreviousRelativeDemand: Estimated demand in relation to the product cluster
	// with the highest popularity rank in the same category and country in the
	// previous week or month.
	//
	// Possible values:
	//   "RELATIVE_DEMAND_ENUM_UNSPECIFIED" - Not specified.
	//   "VERY_LOW" - Demand is 0-5% of the demand of the highest ranked product
	// cluster or brand.
	//   "LOW" - Demand is 6-10% of the demand of the highest ranked product
	// cluster or brand.
	//   "MEDIUM" - Demand is 11-20% of the demand of the highest ranked product
	// cluster or brand.
	//   "HIGH" - Demand is 21-50% of the demand of the highest ranked product
	// cluster or brand.
	//   "VERY_HIGH" - Demand is 51-100% of the demand of the highest ranked
	// product cluster or brand.
	PreviousRelativeDemand string `json:"previousRelativeDemand,omitempty"`
	// Rank: Popularity of the product cluster on Ads and organic surfaces, in the
	// selected category and country, based on the estimated number of units sold.
	Rank int64 `json:"rank,omitempty,string"`
	// RelativeDemand: Estimated demand in relation to the product cluster with the
	// highest popularity rank in the same category and country.
	//
	// Possible values:
	//   "RELATIVE_DEMAND_ENUM_UNSPECIFIED" - Not specified.
	//   "VERY_LOW" - Demand is 0-5% of the demand of the highest ranked product
	// cluster or brand.
	//   "LOW" - Demand is 6-10% of the demand of the highest ranked product
	// cluster or brand.
	//   "MEDIUM" - Demand is 11-20% of the demand of the highest ranked product
	// cluster or brand.
	//   "HIGH" - Demand is 21-50% of the demand of the highest ranked product
	// cluster or brand.
	//   "VERY_HIGH" - Demand is 51-100% of the demand of the highest ranked
	// product cluster or brand.
	RelativeDemand string `json:"relativeDemand,omitempty"`
	// RelativeDemandChange: Change in the estimated demand. Whether it rose, sank
	// or remained flat.
	//
	// Possible values:
	//   "RELATIVE_DEMAND_CHANGE_TYPE_ENUM_UNSPECIFIED" - Not specified.
	//   "SINKER" - Relative demand is lower than the previous time period.
	//   "FLAT" - Relative demand is equal to the previous time period.
	//   "RISER" - Relative demand is higher than the previous time period.
	RelativeDemandChange string `json:"relativeDemandChange,omitempty"`
	// ReportCategoryId: Google product category ID to calculate the ranking for,
	// represented in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436). Required in the
	// `SELECT` clause. If a `WHERE` condition on `report_category_id` is not
	// specified in the query, rankings for all top-level categories are returned.
	ReportCategoryId int64 `json:"reportCategoryId,omitempty,string"`
	// ReportCountryCode: Country where the ranking is calculated. Represented in
	// the ISO 3166 format. Required in the `SELECT` clause. Condition on
	// `report_country_code` is required in the `WHERE` clause.
	ReportCountryCode string `json:"reportCountryCode,omitempty"`
	// ReportDate: Report date. The value of this field can only be one of the
	// following: * The first day of the week (Monday) for weekly reports, * The
	// first day of the month for monthly reports. Required in the `SELECT` clause.
	// If a `WHERE` condition on `report_date` is not specified in the query, the
	// latest available weekly or monthly report is returned.
	ReportDate *Date `json:"reportDate,omitempty"`
	// ReportGranularity: Granularity of the report. The ranking can be done over a
	// week or a month timeframe. Required in the `SELECT` clause. Condition on
	// `report_granularity` is required in the `WHERE` clause.
	//
	// Possible values:
	//   "REPORT_GRANULARITY_ENUM_UNSPECIFIED" - Not specified.
	//   "WEEKLY" - Report is computed over a week timeframe.
	//   "MONTHLY" - Report is computed over a month timeframe.
	ReportGranularity string `json:"reportGranularity,omitempty"`
	// Title: Title of the product cluster.
	Title string `json:"title,omitempty"`
	// VariantGtins: GTINs of example variants of the product cluster.
	VariantGtins []string `json:"variantGtins,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Brand") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Brand") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BestSellersProductClusterView) MarshalJSON() ([]byte, error) {
	type NoMethod BestSellersProductClusterView
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CompetitiveVisibilityBenchmarkView: Fields available for query in
// `competitive_visibility_benchmark_view` table. Competitive visibility
// (https://support.google.com/merchants/answer/11366442) report with the
// category benchmark. Values are only set for fields requested explicitly in
// the request's search query.
type CompetitiveVisibilityBenchmarkView struct {
	// CategoryBenchmarkVisibilityTrend: Change in visibility based on impressions
	// with respect to the start of the selected time range (or first day with
	// non-zero impressions) for a combined set of merchants with highest
	// visibility approximating the market. Cannot be filtered on in the 'WHERE'
	// clause.
	CategoryBenchmarkVisibilityTrend float64 `json:"categoryBenchmarkVisibilityTrend,omitempty"`
	// Date: Date of this row. Required in the `SELECT` clause. A condition on
	// `date` is required in the `WHERE` clause.
	Date *Date `json:"date,omitempty"`
	// ReportCategoryId: Google product category ID to calculate the report for,
	// represented in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436). Required in the
	// `SELECT` clause. A condition on `report_category_id` is required in the
	// `WHERE` clause.
	ReportCategoryId int64 `json:"reportCategoryId,omitempty,string"`
	// ReportCountryCode: Country where impressions appeared. Required in the
	// `SELECT` clause. A condition on `report_country_code` is required in the
	// `WHERE` clause.
	ReportCountryCode string `json:"reportCountryCode,omitempty"`
	// TrafficSource: Traffic source of impressions. Required in the `SELECT`
	// clause.
	//
	// Possible values:
	//   "TRAFFIC_SOURCE_ENUM_UNSPECIFIED" - Not specified.
	//   "ORGANIC" - Organic traffic.
	//   "ADS" - Traffic from ads.
	//   "ALL" - Organic and ads traffic.
	TrafficSource string `json:"trafficSource,omitempty"`
	// YourDomainVisibilityTrend: Change in visibility based on impressions for
	// your domain with respect to the start of the selected time range (or first
	// day with non-zero impressions). Cannot be filtered on in the 'WHERE' clause.
	YourDomainVisibilityTrend float64 `json:"yourDomainVisibilityTrend,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "CategoryBenchmarkVisibilityTrend") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "CategoryBenchmarkVisibilityTrend") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s CompetitiveVisibilityBenchmarkView) MarshalJSON() ([]byte, error) {
	type NoMethod CompetitiveVisibilityBenchmarkView
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *CompetitiveVisibilityBenchmarkView) UnmarshalJSON(data []byte) error {
	type NoMethod CompetitiveVisibilityBenchmarkView
	var s1 struct {
		CategoryBenchmarkVisibilityTrend gensupport.JSONFloat64 `json:"categoryBenchmarkVisibilityTrend"`
		YourDomainVisibilityTrend        gensupport.JSONFloat64 `json:"yourDomainVisibilityTrend"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.CategoryBenchmarkVisibilityTrend = float64(s1.CategoryBenchmarkVisibilityTrend)
	s.YourDomainVisibilityTrend = float64(s1.YourDomainVisibilityTrend)
	return nil
}

// CompetitiveVisibilityCompetitorView: Fields available for query in
// `competitive_visibility_competitor_view` table. Competitive visibility
// (https://support.google.com/merchants/answer/11366442) report with
// businesses with similar visibility. Values are only set for fields requested
// explicitly in the request's search query.
type CompetitiveVisibilityCompetitorView struct {
	// AdsOrganicRatio: [Ads / organic ratio]
	// (https://support.google.com/merchants/answer/11366442#zippy=%2Cads-free-ratio)
	// shows how often the domain receives impressions from Shopping ads compared
	// to organic traffic. The number is rounded and bucketed. Cannot be filtered
	// on in the 'WHERE' clause.
	AdsOrganicRatio float64 `json:"adsOrganicRatio,omitempty"`
	// Date: Date of this row. A condition on `date` is required in the `WHERE`
	// clause.
	Date *Date `json:"date,omitempty"`
	// Domain: Domain of your competitor or your domain, if 'is_your_domain' is
	// true. Required in the `SELECT` clause. Cannot be filtered on in the 'WHERE'
	// clause.
	Domain string `json:"domain,omitempty"`
	// HigherPositionRate: [Higher position rate]
	// (https://support.google.com/merchants/answer/11366442#zippy=%2Chigher-position-rate)
	// shows how often a competitor’s offer got placed in a higher position on
	// the page than your offer. Cannot be filtered on in the 'WHERE' clause.
	HigherPositionRate float64 `json:"higherPositionRate,omitempty"`
	// IsYourDomain: True if this row contains data for your domain. Cannot be
	// filtered on in the 'WHERE' clause.
	IsYourDomain bool `json:"isYourDomain,omitempty"`
	// PageOverlapRate: [Page overlap rate]
	// (https://support.google.com/merchants/answer/11366442#zippy=%2Cpage-overlap-rate)
	// shows how frequently competing retailers’ offers are shown together with
	// your offers on the same page. Cannot be filtered on in the 'WHERE' clause.
	PageOverlapRate float64 `json:"pageOverlapRate,omitempty"`
	// Rank: Position of the domain in the similar businesses ranking for the
	// selected keys (`date`, `report_category_id`, `report_country_code`,
	// `traffic_source`) based on impressions. 1 is the highest. Cannot be filtered
	// on in the 'WHERE' clause.
	Rank int64 `json:"rank,omitempty,string"`
	// RelativeVisibility: [Relative visibility]
	// (https://support.google.com/merchants/answer/11366442#zippy=%2Crelative-visibility)
	// shows how often your competitors’ offers are shown compared to your
	// offers. In other words, this is the number of displayed impressions of a
	// competitor retailer divided by the number of your displayed impressions
	// during a selected time range for a selected product category and country.
	// Cannot be filtered on in the 'WHERE' clause.
	RelativeVisibility float64 `json:"relativeVisibility,omitempty"`
	// ReportCategoryId: Google product category ID to calculate the report for,
	// represented in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436). Required in the
	// `SELECT` clause. A condition on `report_category_id` is required in the
	// `WHERE` clause.
	ReportCategoryId int64 `json:"reportCategoryId,omitempty,string"`
	// ReportCountryCode: Country where impressions appeared. Required in the
	// `SELECT` clause. A condition on `report_country_code` is required in the
	// `WHERE` clause.
	ReportCountryCode string `json:"reportCountryCode,omitempty"`
	// TrafficSource: Traffic source of impressions. Required in the `SELECT`
	// clause.
	//
	// Possible values:
	//   "TRAFFIC_SOURCE_ENUM_UNSPECIFIED" - Not specified.
	//   "ORGANIC" - Organic traffic.
	//   "ADS" - Traffic from ads.
	//   "ALL" - Organic and ads traffic.
	TrafficSource string `json:"trafficSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdsOrganicRatio") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdsOrganicRatio") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CompetitiveVisibilityCompetitorView) MarshalJSON() ([]byte, error) {
	type NoMethod CompetitiveVisibilityCompetitorView
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *CompetitiveVisibilityCompetitorView) UnmarshalJSON(data []byte) error {
	type NoMethod CompetitiveVisibilityCompetitorView
	var s1 struct {
		AdsOrganicRatio    gensupport.JSONFloat64 `json:"adsOrganicRatio"`
		HigherPositionRate gensupport.JSONFloat64 `json:"higherPositionRate"`
		PageOverlapRate    gensupport.JSONFloat64 `json:"pageOverlapRate"`
		RelativeVisibility gensupport.JSONFloat64 `json:"relativeVisibility"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AdsOrganicRatio = float64(s1.AdsOrganicRatio)
	s.HigherPositionRate = float64(s1.HigherPositionRate)
	s.PageOverlapRate = float64(s1.PageOverlapRate)
	s.RelativeVisibility = float64(s1.RelativeVisibility)
	return nil
}

// CompetitiveVisibilityTopMerchantView: Fields available for query in
// `competitive_visibility_top_merchant_view` table. Competitive visibility
// (https://support.google.com/merchants/answer/11366442) report with business
// with highest visibility. Values are only set for fields requested explicitly
// in the request's search query.
type CompetitiveVisibilityTopMerchantView struct {
	// AdsOrganicRatio: [Ads / organic ratio]
	// (https://support.google.com/merchants/answer/11366442#zippy=%2Cads-free-ratio)
	// shows how often the domain receives impressions from Shopping ads compared
	// to organic traffic. The number is rounded and bucketed. Cannot be filtered
	// on in the 'WHERE' clause.
	AdsOrganicRatio float64 `json:"adsOrganicRatio,omitempty"`
	// Date: Date of this row. Cannot be selected in the `SELECT` clause. A
	// condition on `date` is required in the `WHERE` clause.
	Date *Date `json:"date,omitempty"`
	// Domain: Domain of your competitor or your domain, if 'is_your_domain' is
	// true. Required in the `SELECT` clause. Cannot be filtered on in the 'WHERE'
	// clause.
	Domain string `json:"domain,omitempty"`
	// HigherPositionRate: [Higher position rate]
	// (https://support.google.com/merchants/answer/11366442#zippy=%2Chigher-position-rate)
	// shows how often a competitor’s offer got placed in a higher position on
	// the page than your offer. Cannot be filtered on in the 'WHERE' clause.
	HigherPositionRate float64 `json:"higherPositionRate,omitempty"`
	// IsYourDomain: True if this row contains data for your domain. Cannot be
	// filtered on in the 'WHERE' clause.
	IsYourDomain bool `json:"isYourDomain,omitempty"`
	// PageOverlapRate: [Page overlap rate]
	// (https://support.google.com/merchants/answer/11366442#zippy=%2Cpage-overlap-rate)
	// shows how frequently competing retailers’ offers are shown together with
	// your offers on the same page. Cannot be filtered on in the 'WHERE' clause.
	PageOverlapRate float64 `json:"pageOverlapRate,omitempty"`
	// Rank: Position of the domain in the top merchants ranking for the selected
	// keys (`date`, `report_category_id`, `report_country_code`, `traffic_source`)
	// based on impressions. 1 is the highest. Cannot be filtered on in the 'WHERE'
	// clause.
	Rank int64 `json:"rank,omitempty,string"`
	// ReportCategoryId: Google product category ID to calculate the report for,
	// represented in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436). Required in the
	// `SELECT` clause. A condition on `report_category_id` is required in the
	// `WHERE` clause.
	ReportCategoryId int64 `json:"reportCategoryId,omitempty,string"`
	// ReportCountryCode: Country where impressions appeared. Required in the
	// `SELECT` clause. A condition on `report_country_code` is required in the
	// `WHERE` clause.
	ReportCountryCode string `json:"reportCountryCode,omitempty"`
	// TrafficSource: Traffic source of impressions. Required in the `SELECT`
	// clause.
	//
	// Possible values:
	//   "TRAFFIC_SOURCE_ENUM_UNSPECIFIED" - Not specified.
	//   "ORGANIC" - Organic traffic.
	//   "ADS" - Traffic from ads.
	//   "ALL" - Organic and ads traffic.
	TrafficSource string `json:"trafficSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdsOrganicRatio") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdsOrganicRatio") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CompetitiveVisibilityTopMerchantView) MarshalJSON() ([]byte, error) {
	type NoMethod CompetitiveVisibilityTopMerchantView
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *CompetitiveVisibilityTopMerchantView) UnmarshalJSON(data []byte) error {
	type NoMethod CompetitiveVisibilityTopMerchantView
	var s1 struct {
		AdsOrganicRatio    gensupport.JSONFloat64 `json:"adsOrganicRatio"`
		HigherPositionRate gensupport.JSONFloat64 `json:"higherPositionRate"`
		PageOverlapRate    gensupport.JSONFloat64 `json:"pageOverlapRate"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AdsOrganicRatio = float64(s1.AdsOrganicRatio)
	s.HigherPositionRate = float64(s1.HigherPositionRate)
	s.PageOverlapRate = float64(s1.PageOverlapRate)
	return nil
}

// Date: Represents a whole or partial calendar date, such as a birthday. The
// time of day and time zone are either specified elsewhere or are
// insignificant. The date is relative to the Gregorian Calendar. This can
// represent one of the following: * A full date, with non-zero year, month,
// and day values. * A month and day, with a zero year (for example, an
// anniversary). * A year on its own, with a zero month and a zero day. * A
// year and month, with a zero day (for example, a credit card expiration
// date). Related types: * google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type Date struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and month,
	// or 0 to specify a year by itself or a year and month where the day isn't
	// significant.
	Day int64 `json:"day,omitempty"`
	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year without
	// a month and day.
	Month int64 `json:"month,omitempty"`
	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
	// without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Date) MarshalJSON() ([]byte, error) {
	type NoMethod Date
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IssueSeverityPerReportingContext: Issue severity per reporting context.
type IssueSeverityPerReportingContext struct {
	// DemotedCountries: List of demoted countries in the reporting context,
	// represented in ISO 3166 format.
	DemotedCountries []string `json:"demotedCountries,omitempty"`
	// DisapprovedCountries: List of disapproved countries in the reporting
	// context, represented in ISO 3166 format.
	DisapprovedCountries []string `json:"disapprovedCountries,omitempty"`
	// ReportingContext: Reporting context the issue applies to.
	//
	// Possible values:
	//   "REPORTING_CONTEXT_ENUM_UNSPECIFIED" - Not specified.
	//   "SHOPPING_ADS" - [Shopping
	// ads](https://support.google.com/merchants/answer/6149970).
	//   "DISCOVERY_ADS" - Deprecated: Use `DEMAND_GEN_ADS` instead. [Discovery and
	// Demand Gen ads](https://support.google.com/merchants/answer/13389785).
	//   "DEMAND_GEN_ADS" - [Demand Gen
	// ads](https://support.google.com/merchants/answer/13389785).
	//   "DEMAND_GEN_ADS_DISCOVER_SURFACE" - [Demand Gen ads on Discover
	// surface](https://support.google.com/merchants/answer/13389785).
	//   "VIDEO_ADS" - [Video
	// ads](https://support.google.com/google-ads/answer/6340491).
	//   "DISPLAY_ADS" - [Display
	// ads](https://support.google.com/merchants/answer/6069387).
	//   "LOCAL_INVENTORY_ADS" - [Local inventory
	// ads](https://support.google.com/merchants/answer/3271956).
	//   "VEHICLE_INVENTORY_ADS" - [Vehicle inventory
	// ads](https://support.google.com/merchants/answer/11544533).
	//   "FREE_LISTINGS" - [Free product
	// listings](https://support.google.com/merchants/answer/9199328).
	//   "FREE_LOCAL_LISTINGS" - [Free local product
	// listings](https://support.google.com/merchants/answer/9825611).
	//   "FREE_LOCAL_VEHICLE_LISTINGS" - [Free local vehicle
	// listings](https://support.google.com/merchants/answer/11544533).
	//   "YOUTUBE_AFFILIATE" - [Youtube
	// Affiliate](https://support.google.com/youtube/answer/13376398).
	//   "YOUTUBE_SHOPPING" - [YouTube
	// Shopping](https://support.google.com/merchants/answer/13478370).
	//   "CLOUD_RETAIL" - [Cloud
	// retail](https://cloud.google.com/solutions/retail).
	//   "LOCAL_CLOUD_RETAIL" - [Local cloud
	// retail](https://cloud.google.com/solutions/retail).
	//   "PRODUCT_REVIEWS" - [Product
	// Reviews](https://support.google.com/merchants/answer/14620732).
	//   "MERCHANT_REVIEWS" - [Merchant
	// Reviews](https://developers.google.com/merchant-review-feeds).
	//   "YOUTUBE_CHECKOUT" - YouTube Checkout .
	ReportingContext string `json:"reportingContext,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DemotedCountries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DemotedCountries") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IssueSeverityPerReportingContext) MarshalJSON() ([]byte, error) {
	type NoMethod IssueSeverityPerReportingContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ItemIssue: Item issue associated with the product.
type ItemIssue struct {
	// Resolution: Item issue resolution.
	//
	// Possible values:
	//   "ITEM_ISSUE_RESOLUTION_UNSPECIFIED" - Not specified.
	//   "MERCHANT_ACTION" - The merchant has to fix the issue.
	//   "PENDING_PROCESSING" - The issue will be resolved automatically (for
	// example, image crawl) or through a Google review. No merchant action is
	// required now. Resolution might lead to another issue (for example, if crawl
	// fails).
	Resolution string `json:"resolution,omitempty"`
	// Severity: Item issue severity.
	Severity *ItemIssueSeverity `json:"severity,omitempty"`
	// Type: Item issue type.
	Type *ItemIssueType `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Resolution") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Resolution") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ItemIssue) MarshalJSON() ([]byte, error) {
	type NoMethod ItemIssue
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ItemIssueSeverity: How the issue affects the serving of the product.
type ItemIssueSeverity struct {
	// AggregatedSeverity: Aggregated severity of the issue for all reporting
	// contexts it affects. **This field can be used for filtering the results.**
	//
	// Possible values:
	//   "AGGREGATED_ISSUE_SEVERITY_UNSPECIFIED" - Not specified.
	//   "DISAPPROVED" - Issue disapproves the product in at least one reporting
	// context.
	//   "DEMOTED" - Issue demotes the product in all reporting contexts it
	// affects.
	//   "PENDING" - Issue resolution is `PENDING_PROCESSING`.
	AggregatedSeverity string `json:"aggregatedSeverity,omitempty"`
	// SeverityPerReportingContext: Issue severity per reporting context.
	SeverityPerReportingContext []*IssueSeverityPerReportingContext `json:"severityPerReportingContext,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AggregatedSeverity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AggregatedSeverity") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ItemIssueSeverity) MarshalJSON() ([]byte, error) {
	type NoMethod ItemIssueSeverity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ItemIssueType: Issue type.
type ItemIssueType struct {
	// CanonicalAttribute: Canonical attribute name for attribute-specific issues.
	CanonicalAttribute string `json:"canonicalAttribute,omitempty"`
	// Code: Error code of the issue, equivalent to the `code` of Product issues
	// (https://developers.google.com/shopping-content/guides/product-issues).
	Code string `json:"code,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CanonicalAttribute") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CanonicalAttribute") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ItemIssueType) MarshalJSON() ([]byte, error) {
	type NoMethod ItemIssueType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NonProductPerformanceView: Fields available for query in
// `non_product_performance_view` table. Performance data on images and online
// store links leading to your non-product pages. This includes performance
// metrics (for example, `clicks`) and dimensions according to which
// performance metrics are segmented (for example, `date`). Segment fields
// cannot be selected in queries without also selecting at least one metric
// field. Values are only set for fields requested explicitly in the request's
// search query.
type NonProductPerformanceView struct {
	// ClickThroughRate: Click-through rate - the number of clicks (`clicks`)
	// divided by the number of impressions (`impressions`) of images and online
	// store links leading to your non-product pages. Metric.
	ClickThroughRate float64 `json:"clickThroughRate,omitempty"`
	// Clicks: Number of clicks on images and online store links leading to your
	// non-product pages. Metric.
	Clicks int64 `json:"clicks,omitempty,string"`
	// Date: Date in the merchant timezone to which metrics apply. Segment.
	// Condition on `date` is required in the `WHERE` clause.
	Date *Date `json:"date,omitempty"`
	// Impressions: Number of times images and online store links leading to your
	// non-product pages were shown. Metric.
	Impressions int64 `json:"impressions,omitempty,string"`
	// Week: First day of the week (Monday) of the metrics date in the merchant
	// timezone. Segment.
	Week *Date `json:"week,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClickThroughRate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClickThroughRate") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NonProductPerformanceView) MarshalJSON() ([]byte, error) {
	type NoMethod NonProductPerformanceView
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *NonProductPerformanceView) UnmarshalJSON(data []byte) error {
	type NoMethod NonProductPerformanceView
	var s1 struct {
		ClickThroughRate gensupport.JSONFloat64 `json:"clickThroughRate"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ClickThroughRate = float64(s1.ClickThroughRate)
	return nil
}

// Price: The price represented as a number and currency.
type Price struct {
	// AmountMicros: The price represented as a number in micros (1 million micros
	// is an equivalent to one's currency standard unit, for example, 1 USD =
	// 1000000 micros).
	AmountMicros int64 `json:"amountMicros,omitempty,string"`
	// CurrencyCode: The currency of the price using three-letter acronyms
	// according to ISO 4217 (http://en.wikipedia.org/wiki/ISO_4217).
	CurrencyCode string `json:"currencyCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AmountMicros") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AmountMicros") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Price) MarshalJSON() ([]byte, error) {
	type NoMethod Price
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PriceCompetitivenessProductView: Fields available for query in
// `price_competitiveness_product_view` table. Price competitiveness
// (https://support.google.com/merchants/answer/9626903) report. Values are
// only set for fields requested explicitly in the request's search query.
type PriceCompetitivenessProductView struct {
	// BenchmarkPrice: Latest available price benchmark for the product's catalog
	// in the benchmark country.
	BenchmarkPrice *Price `json:"benchmarkPrice,omitempty"`
	// Brand: Brand of the product.
	Brand string `json:"brand,omitempty"`
	// CategoryL1: Product category (1st level) in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436).
	CategoryL1 string `json:"categoryL1,omitempty"`
	// CategoryL2: Product category (2nd level) in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436).
	CategoryL2 string `json:"categoryL2,omitempty"`
	// CategoryL3: Product category (3rd level) in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436).
	CategoryL3 string `json:"categoryL3,omitempty"`
	// CategoryL4: Product category (4th level) in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436).
	CategoryL4 string `json:"categoryL4,omitempty"`
	// CategoryL5: Product category (5th level) in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436).
	CategoryL5 string `json:"categoryL5,omitempty"`
	// Id: REST ID of the product, in the form of
	// `channel~languageCode~feedLabel~offerId`. Can be used to join data with the
	// `product_view` table. Required in the `SELECT` clause.
	Id string `json:"id,omitempty"`
	// OfferId: Merchant-provided id of the product.
	OfferId string `json:"offerId,omitempty"`
	// Price: Current price of the product.
	Price *Price `json:"price,omitempty"`
	// ProductTypeL1: Product type (1st level) in merchant's own product taxonomy
	// (https://support.google.com/merchants/answer/6324406).
	ProductTypeL1 string `json:"productTypeL1,omitempty"`
	// ProductTypeL2: Product type (2nd level) in merchant's own product taxonomy
	// (https://support.google.com/merchants/answer/6324406).
	ProductTypeL2 string `json:"productTypeL2,omitempty"`
	// ProductTypeL3: Product type (3rd level) in merchant's own product taxonomy
	// (https://support.google.com/merchants/answer/6324406).
	ProductTypeL3 string `json:"productTypeL3,omitempty"`
	// ProductTypeL4: Product type (4th level) in merchant's own product taxonomy
	// (https://support.google.com/merchants/answer/6324406).
	ProductTypeL4 string `json:"productTypeL4,omitempty"`
	// ProductTypeL5: Product type (5th level) in merchant's own product taxonomy
	// (https://support.google.com/merchants/answer/6324406).
	ProductTypeL5 string `json:"productTypeL5,omitempty"`
	// ReportCountryCode: Country of the price benchmark. Represented in the ISO
	// 3166 format. Required in the `SELECT` clause.
	ReportCountryCode string `json:"reportCountryCode,omitempty"`
	// Title: Title of the product.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BenchmarkPrice") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BenchmarkPrice") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PriceCompetitivenessProductView) MarshalJSON() ([]byte, error) {
	type NoMethod PriceCompetitivenessProductView
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PriceInsightsProductView: Fields available for query in
// `price_insights_product_view` table. Price insights
// (https://support.google.com/merchants/answer/11916926) report. Values are
// only set for fields requested explicitly in the request's search query.
type PriceInsightsProductView struct {
	// Brand: Brand of the product.
	Brand string `json:"brand,omitempty"`
	// CategoryL1: Product category (1st level) in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436).
	CategoryL1 string `json:"categoryL1,omitempty"`
	// CategoryL2: Product category (2nd level) in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436).
	CategoryL2 string `json:"categoryL2,omitempty"`
	// CategoryL3: Product category (3rd level) in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436).
	CategoryL3 string `json:"categoryL3,omitempty"`
	// CategoryL4: Product category (4th level) in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436).
	CategoryL4 string `json:"categoryL4,omitempty"`
	// CategoryL5: Product category (5th level) in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436).
	CategoryL5 string `json:"categoryL5,omitempty"`
	// Effectiveness: The predicted effectiveness of applying the price suggestion,
	// bucketed.
	//
	// Possible values:
	//   "EFFECTIVENESS_UNSPECIFIED" - Effectiveness is unknown.
	//   "LOW" - Effectiveness is low.
	//   "MEDIUM" - Effectiveness is medium.
	//   "HIGH" - Effectiveness is high.
	Effectiveness string `json:"effectiveness,omitempty"`
	// Id: REST ID of the product, in the form of
	// `channel~languageCode~feedLabel~offerId`. Can be used to join data with the
	// `product_view` table. Required in the `SELECT` clause.
	Id string `json:"id,omitempty"`
	// OfferId: Merchant-provided id of the product.
	OfferId string `json:"offerId,omitempty"`
	// PredictedClicksChangeFraction: Predicted change in clicks as a fraction
	// after introducing the suggested price compared to current active price. For
	// example, 0.05 is a 5% predicted increase in clicks.
	PredictedClicksChangeFraction float64 `json:"predictedClicksChangeFraction,omitempty"`
	// PredictedConversionsChangeFraction: Predicted change in conversions as a
	// fraction after introducing the suggested price compared to current active
	// price. For example, 0.05 is a 5% predicted increase in conversions).
	PredictedConversionsChangeFraction float64 `json:"predictedConversionsChangeFraction,omitempty"`
	// PredictedImpressionsChangeFraction: Predicted change in impressions as a
	// fraction after introducing the suggested price compared to current active
	// price. For example, 0.05 is a 5% predicted increase in impressions.
	PredictedImpressionsChangeFraction float64 `json:"predictedImpressionsChangeFraction,omitempty"`
	// Price: Current price of the product.
	Price *Price `json:"price,omitempty"`
	// ProductTypeL1: Product type (1st level) in merchant's own product taxonomy
	// (https://support.google.com/merchants/answer/6324406).
	ProductTypeL1 string `json:"productTypeL1,omitempty"`
	// ProductTypeL2: Product type (2nd level) in merchant's own product taxonomy
	// (https://support.google.com/merchants/answer/6324406).
	ProductTypeL2 string `json:"productTypeL2,omitempty"`
	// ProductTypeL3: Product type (3rd level) in merchant's own product taxonomy
	// (https://support.google.com/merchants/answer/6324406).
	ProductTypeL3 string `json:"productTypeL3,omitempty"`
	// ProductTypeL4: Product type (4th level) in merchant's own product taxonomy
	// (https://support.google.com/merchants/answer/6324406).
	ProductTypeL4 string `json:"productTypeL4,omitempty"`
	// ProductTypeL5: Product type (5th level) in merchant's own product taxonomy
	// (https://support.google.com/merchants/answer/6324406).
	ProductTypeL5 string `json:"productTypeL5,omitempty"`
	// SuggestedPrice: Latest suggested price for the product.
	SuggestedPrice *Price `json:"suggestedPrice,omitempty"`
	// Title: Title of the product.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Brand") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Brand") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PriceInsightsProductView) MarshalJSON() ([]byte, error) {
	type NoMethod PriceInsightsProductView
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *PriceInsightsProductView) UnmarshalJSON(data []byte) error {
	type NoMethod PriceInsightsProductView
	var s1 struct {
		PredictedClicksChangeFraction      gensupport.JSONFloat64 `json:"predictedClicksChangeFraction"`
		PredictedConversionsChangeFraction gensupport.JSONFloat64 `json:"predictedConversionsChangeFraction"`
		PredictedImpressionsChangeFraction gensupport.JSONFloat64 `json:"predictedImpressionsChangeFraction"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.PredictedClicksChangeFraction = float64(s1.PredictedClicksChangeFraction)
	s.PredictedConversionsChangeFraction = float64(s1.PredictedConversionsChangeFraction)
	s.PredictedImpressionsChangeFraction = float64(s1.PredictedImpressionsChangeFraction)
	return nil
}

// ProductChange: The change that happened to the product including old value,
// new value, country code as the region code and reporting context.
type ProductChange struct {
	// NewValue: The new value of the changed resource or attribute. If empty, it
	// means that the product was deleted. Will have one of these values :
	// (`approved`, `pending`, `disapproved`, ``)
	NewValue string `json:"newValue,omitempty"`
	// OldValue: The old value of the changed resource or attribute. If empty, it
	// means that the product was created. Will have one of these values :
	// (`approved`, `pending`, `disapproved`, ``)
	OldValue string `json:"oldValue,omitempty"`
	// RegionCode: Countries that have the change (if applicable). Represented in
	// the ISO 3166 format.
	RegionCode string `json:"regionCode,omitempty"`
	// ReportingContext: Reporting contexts that have the change (if applicable).
	// Currently this field supports only (`SHOPPING_ADS`, `LOCAL_INVENTORY_ADS`,
	// `YOUTUBE_SHOPPING`, `YOUTUBE_CHECKOUT`, `YOUTUBE_AFFILIATE`) from the enum
	// value ReportingContextEnum
	// (/merchant/api/reference/rest/Shared.Types/ReportingContextEnum)
	//
	// Possible values:
	//   "REPORTING_CONTEXT_ENUM_UNSPECIFIED" - Not specified.
	//   "SHOPPING_ADS" - [Shopping
	// ads](https://support.google.com/merchants/answer/6149970).
	//   "DISCOVERY_ADS" - Deprecated: Use `DEMAND_GEN_ADS` instead. [Discovery and
	// Demand Gen ads](https://support.google.com/merchants/answer/13389785).
	//   "DEMAND_GEN_ADS" - [Demand Gen
	// ads](https://support.google.com/merchants/answer/13389785).
	//   "DEMAND_GEN_ADS_DISCOVER_SURFACE" - [Demand Gen ads on Discover
	// surface](https://support.google.com/merchants/answer/13389785).
	//   "VIDEO_ADS" - [Video
	// ads](https://support.google.com/google-ads/answer/6340491).
	//   "DISPLAY_ADS" - [Display
	// ads](https://support.google.com/merchants/answer/6069387).
	//   "LOCAL_INVENTORY_ADS" - [Local inventory
	// ads](https://support.google.com/merchants/answer/3271956).
	//   "VEHICLE_INVENTORY_ADS" - [Vehicle inventory
	// ads](https://support.google.com/merchants/answer/11544533).
	//   "FREE_LISTINGS" - [Free product
	// listings](https://support.google.com/merchants/answer/9199328).
	//   "FREE_LOCAL_LISTINGS" - [Free local product
	// listings](https://support.google.com/merchants/answer/9825611).
	//   "FREE_LOCAL_VEHICLE_LISTINGS" - [Free local vehicle
	// listings](https://support.google.com/merchants/answer/11544533).
	//   "YOUTUBE_AFFILIATE" - [Youtube
	// Affiliate](https://support.google.com/youtube/answer/13376398).
	//   "YOUTUBE_SHOPPING" - [YouTube
	// Shopping](https://support.google.com/merchants/answer/13478370).
	//   "CLOUD_RETAIL" - [Cloud
	// retail](https://cloud.google.com/solutions/retail).
	//   "LOCAL_CLOUD_RETAIL" - [Local cloud
	// retail](https://cloud.google.com/solutions/retail).
	//   "PRODUCT_REVIEWS" - [Product
	// Reviews](https://support.google.com/merchants/answer/14620732).
	//   "MERCHANT_REVIEWS" - [Merchant
	// Reviews](https://developers.google.com/merchant-review-feeds).
	//   "YOUTUBE_CHECKOUT" - YouTube Checkout .
	ReportingContext string `json:"reportingContext,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NewValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NewValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductChange) MarshalJSON() ([]byte, error) {
	type NoMethod ProductChange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductPerformanceView: Fields available for query in
// `product_performance_view` table. Product performance data for your account,
// including performance metrics (for example, `clicks`) and dimensions
// according to which performance metrics are segmented (for example,
// `offer_id`). Values of product dimensions, such as `offer_id`, reflect the
// state of a product at the time of the impression. Segment fields cannot be
// selected in queries without also selecting at least one metric field. Values
// are only set for fields requested explicitly in the request's search query.
type ProductPerformanceView struct {
	// Brand: Brand of the product. Segment.
	Brand string `json:"brand,omitempty"`
	// CategoryL1: Product category (1st level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in Google's product taxonomy. Segment.
	CategoryL1 string `json:"categoryL1,omitempty"`
	// CategoryL2: Product category (2nd level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in Google's product taxonomy. Segment.
	CategoryL2 string `json:"categoryL2,omitempty"`
	// CategoryL3: Product category (3rd level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in Google's product taxonomy. Segment.
	CategoryL3 string `json:"categoryL3,omitempty"`
	// CategoryL4: Product category (4th level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in Google's product taxonomy. Segment.
	CategoryL4 string `json:"categoryL4,omitempty"`
	// CategoryL5: Product category (5th level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in Google's product taxonomy. Segment.
	CategoryL5 string `json:"categoryL5,omitempty"`
	// ClickThroughRate: Click-through rate - the number of clicks merchant's
	// products receive (clicks) divided by the number of times the products are
	// shown (impressions). Metric.
	ClickThroughRate float64 `json:"clickThroughRate,omitempty"`
	// Clicks: Number of clicks. Metric.
	Clicks int64 `json:"clicks,omitempty,string"`
	// ConversionRate: Number of conversions divided by the number of clicks,
	// reported on the impression date. Metric. Available only for the `FREE`
	// traffic source.
	ConversionRate float64 `json:"conversionRate,omitempty"`
	// ConversionValue: Value of conversions attributed to the product, reported on
	// the conversion date. Metric. Available only for the `FREE` traffic source.
	ConversionValue *Price `json:"conversionValue,omitempty"`
	// Conversions: Number of conversions attributed to the product, reported on
	// the conversion date. Depending on the attribution model, a conversion might
	// be distributed across multiple clicks, where each click gets its own credit
	// assigned. This metric is a sum of all such credits. Metric. Available only
	// for the `FREE` traffic source.
	Conversions float64 `json:"conversions,omitempty"`
	// CustomLabel0: Custom label 0 for custom grouping of products. Segment.
	CustomLabel0 string `json:"customLabel0,omitempty"`
	// CustomLabel1: Custom label 1 for custom grouping of products. Segment.
	CustomLabel1 string `json:"customLabel1,omitempty"`
	// CustomLabel2: Custom label 2 for custom grouping of products. Segment.
	CustomLabel2 string `json:"customLabel2,omitempty"`
	// CustomLabel3: Custom label 3 for custom grouping of products. Segment.
	CustomLabel3 string `json:"customLabel3,omitempty"`
	// CustomLabel4: Custom label 4 for custom grouping of products. Segment.
	CustomLabel4 string `json:"customLabel4,omitempty"`
	// CustomerCountryCode: Code of the country where the customer is located at
	// the time of the event. Represented in the ISO 3166 format. Segment. If the
	// customer country cannot be determined, a special 'ZZ' code is returned.
	CustomerCountryCode string `json:"customerCountryCode,omitempty"`
	// Date: Date in the merchant timezone to which metrics apply. Segment.
	// Condition on `date` is required in the `WHERE` clause.
	Date *Date `json:"date,omitempty"`
	// Impressions: Number of times merchant's products are shown. Metric.
	Impressions int64 `json:"impressions,omitempty,string"`
	// MarketingMethod: Marketing method to which metrics apply. Segment.
	//
	// Possible values:
	//   "MARKETING_METHOD_ENUM_UNSPECIFIED" - Not specified.
	//   "ORGANIC" - Organic marketing.
	//   "ADS" - Ads-based marketing.
	MarketingMethod string `json:"marketingMethod,omitempty"`
	// OfferId: Merchant-provided id of the product. Segment.
	OfferId string `json:"offerId,omitempty"`
	// ProductTypeL1: Product type (1st level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in merchant's own product taxonomy. Segment.
	ProductTypeL1 string `json:"productTypeL1,omitempty"`
	// ProductTypeL2: Product type (2nd level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in merchant's own product taxonomy. Segment.
	ProductTypeL2 string `json:"productTypeL2,omitempty"`
	// ProductTypeL3: Product type (3rd level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in merchant's own product taxonomy. Segment.
	ProductTypeL3 string `json:"productTypeL3,omitempty"`
	// ProductTypeL4: Product type (4th level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in merchant's own product taxonomy. Segment.
	ProductTypeL4 string `json:"productTypeL4,omitempty"`
	// ProductTypeL5: Product type (5th level)
	// (https://developers.google.com/shopping-content/guides/reports/segmentation#category_and_product_type)
	// in merchant's own product taxonomy. Segment.
	ProductTypeL5 string `json:"productTypeL5,omitempty"`
	// Title: Title of the product. Segment.
	Title string `json:"title,omitempty"`
	// Week: First day of the week (Monday) of the metrics date in the merchant
	// timezone. Segment.
	Week *Date `json:"week,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Brand") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Brand") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductPerformanceView) MarshalJSON() ([]byte, error) {
	type NoMethod ProductPerformanceView
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *ProductPerformanceView) UnmarshalJSON(data []byte) error {
	type NoMethod ProductPerformanceView
	var s1 struct {
		ClickThroughRate gensupport.JSONFloat64 `json:"clickThroughRate"`
		ConversionRate   gensupport.JSONFloat64 `json:"conversionRate"`
		Conversions      gensupport.JSONFloat64 `json:"conversions"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ClickThroughRate = float64(s1.ClickThroughRate)
	s.ConversionRate = float64(s1.ConversionRate)
	s.Conversions = float64(s1.Conversions)
	return nil
}

// ProductStatusChangeMessage: The message that the merchant will receive to
// notify about product status change event
type ProductStatusChangeMessage struct {
	// Account: The target account that owns the entity that changed. Format :
	// `accounts/{merchant_id}`
	Account string `json:"account,omitempty"`
	// Attribute: The attribute in the resource that changed, in this case it will
	// be always `Status`.
	//
	// Possible values:
	//   "ATTRIBUTE_UNSPECIFIED" - Unspecified attribute
	//   "STATUS" - Status of the changed entity
	Attribute string `json:"attribute,omitempty"`
	// Changes: A message to describe the change that happened to the product
	Changes []*ProductChange `json:"changes,omitempty"`
	// EventTime: The time at which the event was generated. If you want to order
	// the notification messages you receive you should rely on this field not on
	// the order of receiving the notifications.
	EventTime string `json:"eventTime,omitempty"`
	// ExpirationTime: Optional. The product expiration time. This field will not
	// be set if the notification is sent for a product deletion event.
	ExpirationTime string `json:"expirationTime,omitempty"`
	// ManagingAccount: The account that manages the merchant's account. can be the
	// same as merchant id if it is standalone account. Format :
	// `accounts/{service_provider_id}`
	ManagingAccount string `json:"managingAccount,omitempty"`
	// Resource: The product name. Format: `accounts/{account}/products/{product}`
	Resource string `json:"resource,omitempty"`
	// ResourceId: The product id.
	ResourceId string `json:"resourceId,omitempty"`
	// ResourceType: The resource that changed, in this case it will always be
	// `Product`.
	//
	// Possible values:
	//   "RESOURCE_UNSPECIFIED" - Unspecified resource
	//   "PRODUCT" - Resource type : product
	ResourceType string `json:"resourceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Account") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Account") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProductStatusChangeMessage) MarshalJSON() ([]byte, error) {
	type NoMethod ProductStatusChangeMessage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProductView: Fields available for query in `product_view` table. Products in
// the current inventory. Products in this table are the same as in Products
// sub-API but not all product attributes from Products sub-API are available
// for query in this table. In contrast to Products sub-API, this table allows
// to filter the returned list of products by product attributes. To retrieve a
// single product by `id` or list all products, Products sub-API should be
// used. Values are only set for fields requested explicitly in the request's
// search query.
type ProductView struct {
	// AggregatedReportingContextStatus: Aggregated status.
	//
	// Possible values:
	//   "AGGREGATED_REPORTING_CONTEXT_STATUS_UNSPECIFIED" - Not specified.
	//   "NOT_ELIGIBLE_OR_DISAPPROVED" - Product is not eligible or is disapproved
	// for all reporting contexts.
	//   "PENDING" - Product's status is pending in all reporting contexts.
	//   "ELIGIBLE_LIMITED" - Product is eligible for some (but not all) reporting
	// contexts.
	//   "ELIGIBLE" - Product is eligible for all reporting contexts.
	AggregatedReportingContextStatus string `json:"aggregatedReportingContextStatus,omitempty"`
	// Availability: Availability
	// (https://support.google.com/merchants/answer/6324448) of the product.
	Availability string `json:"availability,omitempty"`
	// Brand: Brand of the product.
	Brand string `json:"brand,omitempty"`
	// CategoryL1: Product category (1st level) in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436).
	CategoryL1 string `json:"categoryL1,omitempty"`
	// CategoryL2: Product category (2nd level) in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436).
	CategoryL2 string `json:"categoryL2,omitempty"`
	// CategoryL3: Product category (3rd level) in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436).
	CategoryL3 string `json:"categoryL3,omitempty"`
	// CategoryL4: Product category (4th level) in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436).
	CategoryL4 string `json:"categoryL4,omitempty"`
	// CategoryL5: Product category (5th level) in Google's product taxonomy
	// (https://support.google.com/merchants/answer/6324436).
	CategoryL5 string `json:"categoryL5,omitempty"`
	// Channel: Channel of the product. Can be `ONLINE` or `LOCAL`.
	//
	// Possible values:
	//   "CHANNEL_ENUM_UNSPECIFIED" - Not specified.
	//   "ONLINE" - Online product.
	//   "LOCAL" - Local product.
	Channel string `json:"channel,omitempty"`
	// ClickPotential: Estimated performance potential compared to highest
	// performing products of the merchant.
	//
	// Possible values:
	//   "CLICK_POTENTIAL_UNSPECIFIED" - Unknown predicted clicks impact.
	//   "LOW" - Potential to receive a low number of clicks compared to the
	// highest performing products of the merchant.
	//   "MEDIUM" - Potential to receive a moderate number of clicks compared to
	// the highest performing products of the merchant.
	//   "HIGH" - Potential to receive a similar number of clicks as the highest
	// performing products of the merchant.
	ClickPotential string `json:"clickPotential,omitempty"`
	// ClickPotentialRank: Normalized click potential of the product. Values range
	// from 1 to 1000, where 1 is the highest click potential and 1000 is the
	// theoretical lowest.
	ClickPotentialRank int64 `json:"clickPotentialRank,omitempty,string"`
	// Condition: Condition (https://support.google.com/merchants/answer/6324469)
	// of the product.
	Condition string `json:"condition,omitempty"`
	// CreationTime: The time the merchant created the product in timestamp
	// seconds.
	CreationTime string `json:"creationTime,omitempty"`
	// ExpirationDate: Expiration date for the product, specified on insertion.
	ExpirationDate *Date `json:"expirationDate,omitempty"`
	// FeedLabel: Feed label of the product.
	FeedLabel string `json:"feedLabel,omitempty"`
	// Gtin: List of Global Trade Item Numbers (GTINs) of the product.
	Gtin []string `json:"gtin,omitempty"`
	// Id: REST ID of the product, in the form of
	// `channel~languageCode~feedLabel~offerId`. Merchant API methods that operate
	// on products take this as their `name` parameter. Required in the `SELECT`
	// clause.
	Id string `json:"id,omitempty"`
	// ItemGroupId: Item group id provided by the merchant for grouping variants
	// together.
	ItemGroupId string `json:"itemGroupId,omitempty"`
	// ItemIssues: List of item issues for the product. **This field cannot be used
	// for sorting the results.** **Only selected attributes of this field (for
	// example, `item_issues.severity.aggregated_severity`) can be used for
	// filtering the results.**
	ItemIssues []*ItemIssue `json:"itemIssues,omitempty"`
	// LanguageCode: Language code of the product in BCP 47 format.
	LanguageCode string `json:"languageCode,omitempty"`
	// OfferId: Merchant-provided id of the product.
	OfferId string `json:"offerId,omitempty"`
	// Price: Product price. Absent if the information about the price of the
	// product is not available.
	Price *Price `json:"price,omitempty"`
	// ProductTypeL1: Product type (1st level) in merchant's own product taxonomy
	// (https://support.google.com/merchants/answer/6324406).
	ProductTypeL1 string `json:"productTypeL1,omitempty"`
	// ProductTypeL2: Product type (2nd level) in merchant's own product taxonomy
	// (https://support.google.com/merchants/answer/6324406).
	ProductTypeL2 string `json:"productTypeL2,omitempty"`
	// ProductTypeL3: Product type (3rd level) in merchant's own product taxonomy
	// (https://support.google.com/merchants/answer/6324406).
	ProductTypeL3 string `json:"productTypeL3,omitempty"`
	// ProductTypeL4: Product type (4th level) in merchant's own product taxonomy
	// (https://support.google.com/merchants/answer/6324406).
	ProductTypeL4 string `json:"productTypeL4,omitempty"`
	// ProductTypeL5: Product type (5th level) in merchant's own product taxonomy
	// (https://support.google.com/merchants/answer/6324406).
	ProductTypeL5 string `json:"productTypeL5,omitempty"`
	// ShippingLabel: Normalized shipping label
	// (https://support.google.com/merchants/answer/6324504) specified in the data
	// source.
	ShippingLabel string `json:"shippingLabel,omitempty"`
	// ThumbnailLink: Link to the processed image of the product, hosted on the
	// Google infrastructure.
	ThumbnailLink string `json:"thumbnailLink,omitempty"`
	// Title: Title of the product.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "AggregatedReportingContextStatus") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "AggregatedReportingContextStatus") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s ProductView) MarshalJSON() ([]byte, error) {
	type NoMethod ProductView
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReportRow: Result row returned from the search query. Only the message
// corresponding to the queried table is populated in the response. Within the
// populated message, only the fields requested explicitly in the query are
// populated.
type ReportRow struct {
	// BestSellersBrandView: Fields available for query in
	// `best_sellers_brand_view` table.
	BestSellersBrandView *BestSellersBrandView `json:"bestSellersBrandView,omitempty"`
	// BestSellersProductClusterView: Fields available for query in
	// `best_sellers_product_cluster_view` table.
	BestSellersProductClusterView *BestSellersProductClusterView `json:"bestSellersProductClusterView,omitempty"`
	// CompetitiveVisibilityBenchmarkView: Fields available for query in
	// `competitive_visibility_benchmark_view` table.
	CompetitiveVisibilityBenchmarkView *CompetitiveVisibilityBenchmarkView `json:"competitiveVisibilityBenchmarkView,omitempty"`
	// CompetitiveVisibilityCompetitorView: Fields available for query in
	// `competitive_visibility_competitor_view` table.
	CompetitiveVisibilityCompetitorView *CompetitiveVisibilityCompetitorView `json:"competitiveVisibilityCompetitorView,omitempty"`
	// CompetitiveVisibilityTopMerchantView: Fields available for query in
	// `competitive_visibility_top_merchant_view` table.
	CompetitiveVisibilityTopMerchantView *CompetitiveVisibilityTopMerchantView `json:"competitiveVisibilityTopMerchantView,omitempty"`
	// NonProductPerformanceView: Fields available for query in
	// `non_product_performance_view` table.
	NonProductPerformanceView *NonProductPerformanceView `json:"nonProductPerformanceView,omitempty"`
	// PriceCompetitivenessProductView: Fields available for query in
	// `price_competitiveness_product_view` table.
	PriceCompetitivenessProductView *PriceCompetitivenessProductView `json:"priceCompetitivenessProductView,omitempty"`
	// PriceInsightsProductView: Fields available for query in
	// `price_insights_product_view` table.
	PriceInsightsProductView *PriceInsightsProductView `json:"priceInsightsProductView,omitempty"`
	// ProductPerformanceView: Fields available for query in
	// `product_performance_view` table.
	ProductPerformanceView *ProductPerformanceView `json:"productPerformanceView,omitempty"`
	// ProductView: Fields available for query in `product_view` table.
	ProductView *ProductView `json:"productView,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BestSellersBrandView") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BestSellersBrandView") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReportRow) MarshalJSON() ([]byte, error) {
	type NoMethod ReportRow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchRequest: Request message for the `ReportService.Search` method.
type SearchRequest struct {
	// PageSize: Optional. Number of `ReportRows` to retrieve in a single page.
	// Defaults to 1000. Values above 5000 are coerced to 5000.
	PageSize int64 `json:"pageSize,omitempty"`
	// PageToken: Optional. Token of the page to retrieve. If not specified, the
	// first page of results is returned. In order to request the next page of
	// results, the value obtained from `next_page_token` in the previous response
	// should be used.
	PageToken string `json:"pageToken,omitempty"`
	// Query: Required. Query that defines a report to be retrieved. For details on
	// how to construct your query, see the Query Language guide
	// (/merchant/api/guides/reports/query-language). For the full list of
	// available tables and fields, see the Available fields
	// (/merchant/api/reference/rest/reports_{api_version}/accounts.reports).
	Query string `json:"query,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PageSize") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PageSize") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SearchRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchResponse: Response message for the `ReportService.Search` method.
type SearchResponse struct {
	// NextPageToken: Token which can be sent as `page_token` to retrieve the next
	// page. If omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Results: Rows that matched the search query.
	Results []*ReportRow `json:"results,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccountsReportsSearchCall struct {
	s             *Service
	parent        string
	searchrequest *SearchRequest
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Search: Retrieves a report defined by a search query. The response might
// contain fewer rows than specified by `page_size`. Rely on `next_page_token`
// to determine if there are more rows to be requested.
//
//   - parent: Id of the account making the call. Must be a standalone account or
//     an MCA subaccount. Format: accounts/{account}.
func (r *AccountsReportsService) Search(parent string, searchrequest *SearchRequest) *AccountsReportsSearchCall {
	c := &AccountsReportsSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.searchrequest = searchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *AccountsReportsSearchCall) Fields(s ...googleapi.Field) *AccountsReportsSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *AccountsReportsSearchCall) Context(ctx context.Context) *AccountsReportsSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *AccountsReportsSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AccountsReportsSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.searchrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "reports/v1/{+parent}/reports:search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "merchantapi.accounts.reports.search", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "merchantapi.accounts.reports.search" call.
// Any non-2xx status code is an error. Response headers are in either
// *SearchResponse.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *AccountsReportsSearchCall) Do(opts ...googleapi.CallOption) (*SearchResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SearchResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "merchantapi.accounts.reports.search", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *AccountsReportsSearchCall) Pages(ctx context.Context, f func(*SearchResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.searchrequest.PageToken = pt }(c.searchrequest.PageToken)
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.searchrequest.PageToken = x.NextPageToken
	}
}
