/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.engine;

import io.jenetics.Gene;
import io.jenetics.Genotype;
import io.jenetics.engine.Codec;
import java.util.Objects;
import java.util.function.Function;

public interface Problem<T, G extends Gene<?, G>, C extends Comparable<? super C>> {
    public Function<T, C> fitness();

    public Codec<T, G> codec();

    default public T decode(Genotype<G> genotype) {
        return this.codec().decode(genotype);
    }

    default public C fitness(T arg) {
        return (C)((Comparable)this.fitness().apply(arg));
    }

    default public C fitness(Genotype<G> genotype) {
        return this.fitness(this.codec().decode(genotype));
    }

    public static <T, G extends Gene<?, G>, C extends Comparable<? super C>> Problem<T, G, C> of(final Function<T, C> fitness, final Codec<T, G> codec) {
        Objects.requireNonNull(fitness);
        Objects.requireNonNull(codec);
        return new Problem<T, G, C>(){

            @Override
            public Codec<T, G> codec() {
                return codec;
            }

            @Override
            public Function<T, C> fitness() {
                return fitness;
            }
        };
    }
}

