/*
 * Decompiled with CFR 0.152.
 */
package brut.util;

import brut.util.ExtDataInput;
import com.google.common.io.CountingInputStream;
import java.io.DataInput;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public final class ExtDataInputStream
extends FilterInputStream
implements ExtDataInput {
    public static final Logger LOGGER = Logger.getLogger(ExtDataInputStream.class.getName());
    public final FilterInputStream mDelegate;
    public final CountingInputStream mCountIn;

    public ExtDataInputStream(DataInput dataInput, CountingInputStream countingInputStream) {
        super((InputStream)((Object)dataInput));
        this.mDelegate = (FilterInputStream)((Object)dataInput);
        this.mCountIn = countingInputStream;
    }

    public final void jumpTo(long l) {
        long l2 = ((ExtDataInputStream)((Object)l6)).mCountIn.count;
        if (l2 <= l) {
            long l3;
            if (l2 < l && (l2 = ((InputStream)((Object)l6)).skip(l3 = l - l2)) != l3) {
                Long l4 = l3;
                Long l5 = l2;
                Object[] objectArray = new Object[2];
                Object[] objectArray2 = objectArray;
                objectArray[0] = l4;
                objectArray[1] = l5;
                throw new IOException(String.format("Jump failed: expected %d, got %d", objectArray2));
            }
            return;
        }
        Long l6 = l2;
        Long l7 = l;
        Object[] objectArray = new Object[2];
        Object[] objectArray3 = objectArray;
        objectArray[0] = l6;
        objectArray[1] = l7;
        throw new IOException(String.format("Jumping backwards from %d to %d", objectArray3));
    }

    public final int[] readIntArray(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.mDelegate.readInt();
        }
        return nArray;
    }

    public final String readAscii(int n) {
        char[] cArray = new char[n];
        int n2 = 0;
        while (true) {
            char c;
            int n3 = n;
            n = n3 + -1;
            if (n3 <= 0 || (c = (char)this.mDelegate.readUnsignedByte()) == '\u0000') break;
            int n4 = n2 + 1;
            cArray[n2] = c;
            n2 = n4;
        }
        if (n > 0) {
            this.skipBytes(n);
        }
        return new String(cArray, 0, n2);
    }

    public final String readUtf16(int n) {
        char[] cArray = new char[n];
        int n2 = 0;
        while (true) {
            char c;
            int n3 = n;
            n = n3 + -1;
            if (n3 <= 0 || (c = this.mDelegate.readChar()) == '\u0000') break;
            int n4 = n2 + 1;
            cArray[n2] = c;
            n2 = n4;
        }
        if (n > 0) {
            this.skipBytes(n * 2);
        }
        return new String(cArray, 0, n2);
    }

    @Override
    public final void readFully(byte[] byArray) {
        this.mDelegate.readFully(byArray);
    }

    @Override
    public final void readFully(byte[] byArray, int n, int n2) {
        this.mDelegate.readFully(byArray, n, n2);
    }

    @Override
    public final int skipBytes(int n) {
        int n2;
        int n3;
        for (n2 = 0; n2 < n && (n3 = this.mDelegate.skipBytes(n - n2)) > 0; n2 += n3) {
        }
        return n2;
    }

    @Override
    public final boolean readBoolean() {
        return this.mDelegate.readBoolean();
    }

    @Override
    public final byte readByte() {
        return this.mDelegate.readByte();
    }

    @Override
    public final int readUnsignedByte() {
        return this.mDelegate.readUnsignedByte();
    }

    @Override
    public final short readShort() {
        return this.mDelegate.readShort();
    }

    @Override
    public final int readUnsignedShort() {
        return this.mDelegate.readUnsignedShort();
    }

    @Override
    public final char readChar() {
        return this.mDelegate.readChar();
    }

    @Override
    public final int readInt() {
        return this.mDelegate.readInt();
    }

    @Override
    public final long readLong() {
        return this.mDelegate.readLong();
    }

    @Override
    public final float readFloat() {
        return this.mDelegate.readFloat();
    }

    @Override
    public final double readDouble() {
        return this.mDelegate.readDouble();
    }

    @Override
    public final String readLine() {
        return this.mDelegate.readLine();
    }

    @Override
    public final String readUTF() {
        return this.mDelegate.readUTF();
    }
}

