/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.immutable.instruction;

import com.android.tools.smali.dexlib2.Format;
import com.android.tools.smali.dexlib2.Opcode;
import com.android.tools.smali.dexlib2.iface.instruction.formats.Instruction35mi;
import com.android.tools.smali.dexlib2.immutable.instruction.ImmutableInstruction;
import com.android.tools.smali.dexlib2.util.Preconditions;

public final class ImmutableInstruction35mi
extends ImmutableInstruction
implements Instruction35mi {
    public final int registerCount;
    public final int registerC;
    public final int registerD;
    public final int registerE;
    public final int registerF;
    public final int registerG;
    public final int inlineIndex;

    public ImmutableInstruction35mi(Opcode opcode, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(opcode);
        this.registerCount = Preconditions.check35cAnd45ccRegisterCount(n);
        int n8 = n > 0 ? Preconditions.checkNibbleRegister(n2) : 0;
        this.registerC = n8;
        n8 = n > 1 ? Preconditions.checkNibbleRegister(n3) : 0;
        this.registerD = n8;
        n8 = n > 2 ? Preconditions.checkNibbleRegister(n4) : 0;
        this.registerE = n8;
        n8 = n > 3 ? Preconditions.checkNibbleRegister(n5) : 0;
        this.registerF = n8;
        n8 = n > 4 ? Preconditions.checkNibbleRegister(n6) : 0;
        this.registerG = n8;
        if (n7 >= 0 && n7 <= 65535) {
            this.inlineIndex = n7;
            return;
        }
        Integer n9 = n7;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n9;
        throw new IllegalArgumentException(String.format("Invalid inline index: %d. Must be between 0 and 65535, inclusive", objectArray2));
    }

    @Override
    public final int getRegisterCount() {
        return this.registerCount;
    }

    @Override
    public final int getRegisterC() {
        return this.registerC;
    }

    @Override
    public final int getRegisterD() {
        return this.registerD;
    }

    @Override
    public final int getRegisterE() {
        return this.registerE;
    }

    @Override
    public final int getRegisterF() {
        return this.registerF;
    }

    @Override
    public final int getRegisterG() {
        return this.registerG;
    }

    @Override
    public final int getInlineIndex() {
        return this.inlineIndex;
    }

    @Override
    public final Format getFormat() {
        return Format.Format35mi;
    }
}

