/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.cli.AmbiguousOptionException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLine$Builder;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.commons.cli.Util;

public final class DefaultParser {
    public CommandLine cmd;
    public Options options;
    public int nonOptionAction;
    public String currentToken;
    public Option currentOption;
    public boolean skipParsing;
    public ArrayList expectedOpts;
    public final Consumer deprecatedHandler = CommandLine$Builder.DEPRECATED_HANDLER;

    public final void checkRequiredArgs() {
        Option option = this.currentOption;
        if (option != null && (option.argCount == -2 ? option.values.isEmpty() : option.acceptsArg())) {
            DefaultParser defaultParser = this;
            if (defaultParser.isJavaProperty(defaultParser.currentOption.getKey()) && this.currentOption.values.size() == 1) {
                return;
            }
            throw new MissingArgumentException(this.currentOption);
        }
    }

    public final List getMatchingLongOptions(String string) {
        ArrayList arrayList;
        Iterator iterator = ((DefaultParser)((Object)iterator)).options;
        iterator.getClass();
        string = Util.stripLeadingHyphens(string);
        List<Object> list = arrayList;
        arrayList = new ArrayList();
        if (((Options)((Object)iterator)).longOpts.containsKey(string)) {
            list = Collections.singletonList(string);
        } else {
            for (String string2 : ((Options)((Object)iterator)).longOpts.keySet()) {
                if (!string2.startsWith(string)) continue;
                ((ArrayList)list).add(string2);
            }
        }
        return list;
    }

    public final void handleLongOptionWithEqual(String string) {
        String string2 = string;
        int n = string2.indexOf(61);
        String string3 = string2.substring(n + 1);
        Object object = string2.substring(0, n);
        List list = this.getMatchingLongOptions((String)object);
        if (list.isEmpty()) {
            DefaultParser defaultParser = this;
            defaultParser.handleUnknownToken(defaultParser.currentToken);
        } else {
            if (list.size() > 1 && !this.options.longOpts.containsKey(Util.stripLeadingHyphens((String)object))) {
                throw new AmbiguousOptionException((String)object, list);
            }
            if (!this.options.longOpts.containsKey(Util.stripLeadingHyphens((String)object))) {
                object = (String)list.get(0);
            }
            object = this.options.getOption((String)object);
            if (((Option)object).acceptsArg()) {
                DefaultParser defaultParser = this;
                defaultParser.handleOption((Option)object);
                defaultParser.currentOption.processValue(string3);
                defaultParser.currentOption = null;
            } else {
                DefaultParser defaultParser = this;
                defaultParser.handleUnknownToken(defaultParser.currentToken);
            }
        }
    }

    public final void handleLongOptionWithoutEqual(String string) {
        List list = this.getMatchingLongOptions(string);
        if (list.isEmpty()) {
            DefaultParser defaultParser = this;
            defaultParser.handleUnknownToken(defaultParser.currentToken);
        } else {
            if (list.size() > 1 && !this.options.longOpts.containsKey(Util.stripLeadingHyphens(string))) {
                throw new AmbiguousOptionException(string, list);
            }
            if (!this.options.longOpts.containsKey(Util.stripLeadingHyphens(string))) {
                string = (String)list.get(0);
            }
            DefaultParser defaultParser = this;
            defaultParser.handleOption(defaultParser.options.getOption(string));
        }
    }

    public final void handleOption(Option option) {
        this.checkRequiredArgs();
        option = (Option)option.clone();
        if (this.options.optionGroups.get(option.getKey()) == null) {
            this.cmd.options.add(option);
            if (!option.hasArg()) {
                option = null;
            }
            this.currentOption = option;
            return;
        }
        throw new ClassCastException();
    }

    public final boolean isJavaProperty(String string) {
        int n;
        string = string.isEmpty() ? null : string.substring(0, 1);
        Option option = ((DefaultParser)((Object)option)).options.getOption(string);
        return option != null && ((n = option.argCount) >= 2 || n == -2);
    }

    public final void handleUnknownToken(String string) {
        if (string.startsWith("-") && string.length() > 1 && this.nonOptionAction == 4) {
            throw new UnrecognizedOptionException("Unrecognized option: ".concat(string));
        }
        if (!string.startsWith("-") || string.equals("-") || string.length() > 1 && this.nonOptionAction != 1) {
            this.cmd.args.add(string);
        }
        if (this.nonOptionAction == 3) {
            this.skipParsing = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final CommandLine parse(Options iterator, String[] stringArray) {
        block39: {
            block40: {
                CommandLine commandLine;
                CommandLine$Builder commandLine$Builder;
                ArrayList arrayList;
                this.options = (Options)((Object)Objects.requireNonNull(iterator, "options"));
                this.nonOptionAction = 4;
                this.skipParsing = false;
                this.currentOption = null;
                Object object = arrayList;
                arrayList = new ArrayList(Collections.unmodifiableList(((Options)((Object)iterator)).requiredOpts));
                this.expectedOpts = object;
                iterator = new HashSet(((Options)((Object)iterator)).optionGroups.values()).iterator();
                if (iterator.hasNext()) break block39;
                iterator = commandLine$Builder;
                object = this.deprecatedHandler;
                new CommandLine$Builder().deprecatedHandler = object;
                CommandLine object22 = commandLine;
                Iterator iterator2 = iterator;
                iterator = ((CommandLine$Builder)((Object)iterator2)).args;
                commandLine = new CommandLine((LinkedList)((Object)iterator), ((CommandLine$Builder)((Object)iterator2)).options, (Consumer)object);
                this.cmd = object22;
                if (stringArray == null) break block40;
                for (String string : stringArray) {
                    block38: {
                        Object object2;
                        block37: {
                            void var4_10;
                            int n;
                            block45: {
                                block44: {
                                    Object object3;
                                    block43: {
                                        block42: {
                                            block41: {
                                                if (string == null) continue;
                                                this.currentToken = string;
                                                if (!this.skipParsing) break block41;
                                                this.cmd.args.add(string);
                                                break block38;
                                            }
                                            if (!"--".equals(string)) break block42;
                                            this.skipParsing = true;
                                            break block38;
                                        }
                                        object2 = this.currentOption;
                                        if (object2 == null || !((Option)object2).acceptsArg()) break block37;
                                        if (!string.startsWith("-") || string.length() == 1) break block43;
                                        int n2 = string.indexOf(61);
                                        object2 = n2 == -1 ? string : string.substring(0, n2);
                                        if (!this.getMatchingLongOptions((String)object2).isEmpty()) break block44;
                                        object2 = Util.stripLeadingHyphens(string);
                                        object3 = null;
                                        for (int i = ((String)object2).length() - 2; i > 1; --i) {
                                            String string2 = ((String)object2).substring(0, i);
                                            if (!this.options.longOpts.containsKey(Util.stripLeadingHyphens(string2))) continue;
                                            object3 = string2;
                                            break;
                                        }
                                        if (object3 != null && !string.startsWith("--")) break block44;
                                    }
                                    if (!string.startsWith("-") || string.length() == 1) break block45;
                                    int n3 = string.indexOf(61);
                                    object2 = n3 == -1 ? string.substring(1) : string.substring(1, n3);
                                    object3 = this.options;
                                    object3.getClass();
                                    if (((Options)object3).shortOpts.containsKey(Util.stripLeadingHyphens((String)object2))) break block44;
                                    if (((String)object2).isEmpty()) break block45;
                                    Object object4 = object2;
                                    object2 = this.options;
                                    String string3 = String.valueOf(((String)object4).charAt(0));
                                    object2.getClass();
                                    if (!((Options)object2).shortOpts.containsKey(Util.stripLeadingHyphens(string3))) break block45;
                                }
                                try {
                                    Double.parseDouble(string);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    break block37;
                                }
                            }
                            object2 = this.currentOption;
                            if (!Util.isEmpty(string) && (n = string.length()) > 1 && string.startsWith("\"") && string.endsWith("\"") && string.substring(1, --n).indexOf(34) == -1) {
                                String string4 = string.substring(1, n);
                            }
                            ((Option)object2).processValue((String)var4_10);
                            break block38;
                        }
                        if (string.startsWith("--")) {
                            if (string.indexOf(61) == -1) {
                                this.handleLongOptionWithoutEqual(string);
                            } else {
                                this.handleLongOptionWithEqual(string);
                            }
                        } else if (string.startsWith("-") && !"-".equals(string)) {
                            object2 = Util.stripLeadingHyphens(string);
                            int n = ((String)object2).indexOf(61);
                            if (((String)object2).length() == 1) {
                                Options options = this.options;
                                options.getClass();
                                if (options.shortOpts.containsKey(Util.stripLeadingHyphens((String)object2))) {
                                    this.handleOption(this.options.getOption((String)object2));
                                } else {
                                    this.handleUnknownToken(string);
                                }
                            } else if (n == -1) {
                                Object object5 = this.options;
                                object5.getClass();
                                if (((Options)object5).shortOpts.containsKey(Util.stripLeadingHyphens((String)object2))) {
                                    this.handleOption(this.options.getOption((String)object2));
                                } else if (!this.getMatchingLongOptions((String)object2).isEmpty()) {
                                    this.handleLongOptionWithoutEqual(string);
                                } else {
                                    object5 = Util.stripLeadingHyphens((String)object2);
                                    Object object6 = null;
                                    for (int i = ((String)object5).length() - 2; i > 1; --i) {
                                        String string5 = ((String)object5).substring(0, i);
                                        if (!this.options.longOpts.containsKey(Util.stripLeadingHyphens(string5))) continue;
                                        object6 = string5;
                                        break;
                                    }
                                    if (object6 != null && this.options.getOption((String)object6).acceptsArg()) {
                                        this.handleOption(this.options.getOption((String)object6));
                                        this.currentOption.processValue(((String)object2).substring(((String)object6).length()));
                                        this.currentOption = null;
                                    } else if (this.isJavaProperty((String)object2)) {
                                        this.handleOption(this.options.getOption(((String)object2).substring(0, 1)));
                                        this.currentOption.processValue(((String)object2).substring(1));
                                        this.currentOption = null;
                                    } else {
                                        for (int i = 1; i < string.length(); ++i) {
                                            String string6 = String.valueOf(string.charAt(i));
                                            object6 = this.options;
                                            object6.getClass();
                                            String string7 = Util.stripLeadingHyphens(string6);
                                            if (!((Options)object6).shortOpts.containsKey(string7) && !((Options)object6).longOpts.containsKey(string7)) {
                                                void var4_12;
                                                if (this.nonOptionAction == 3 && i > 1) {
                                                    String string8 = string.substring(i);
                                                }
                                                this.handleUnknownToken((String)var4_12);
                                            } else {
                                                this.handleOption(this.options.getOption(string6));
                                                if (this.currentOption == null) continue;
                                                int n4 = i + 1;
                                                if (string.length() == n4) continue;
                                                this.currentOption.processValue(string.substring(n4));
                                            }
                                            break;
                                        }
                                    }
                                }
                            } else {
                                Object object7 = object2;
                                object2 = ((String)object2).substring(0, n);
                                String string9 = ((String)object7).substring(n + 1);
                                if (((String)object2).length() == 1) {
                                    if ((object2 = this.options.getOption((String)object2)) != null && ((Option)object2).acceptsArg()) {
                                        this.handleOption((Option)object2);
                                        this.currentOption.processValue(string9);
                                        this.currentOption = null;
                                    } else {
                                        this.handleUnknownToken(string);
                                    }
                                } else if (this.isJavaProperty((String)object2)) {
                                    this.handleOption(this.options.getOption(((String)object2).substring(0, 1)));
                                    this.currentOption.processValue(((String)object2).substring(1));
                                    this.currentOption.processValue(string9);
                                    this.currentOption = null;
                                } else {
                                    this.handleLongOptionWithEqual(string);
                                }
                            }
                        } else {
                            this.handleUnknownToken(string);
                        }
                    }
                    Option option = this.currentOption;
                    if (option == null || option.acceptsArg()) continue;
                    this.currentOption = null;
                }
            }
            this.checkRequiredArgs();
            if (this.expectedOpts.isEmpty()) {
                return this.cmd;
            }
            throw new MissingOptionException(this.expectedOpts);
        }
        iterator.next().getClass();
        throw new ClassCastException();
    }
}

