/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import org.traccar.api.BaseResource;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Path(value="events")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class EventResource
extends BaseResource {
    @Path(value="{id}")
    @GET
    public Event get(@PathParam(value="id") long id) throws StorageException {
        Event event = this.storage.getObject(Event.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", id)));
        if (event == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).build());
        }
        this.permissionsService.checkPermission(Device.class, this.getUserId(), event.getDeviceId());
        return event;
    }
}

