/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.broadcast;

import java.util.HashSet;
import java.util.Set;
import org.traccar.broadcast.BroadcastInterface;
import org.traccar.broadcast.BroadcastMessage;
import org.traccar.broadcast.BroadcastService;
import org.traccar.model.BaseModel;
import org.traccar.model.Device;
import org.traccar.model.Event;
import org.traccar.model.ObjectOperation;
import org.traccar.model.Permission;
import org.traccar.model.Position;

public abstract class BaseBroadcastService
implements BroadcastService {
    private final Set<BroadcastInterface> listeners = new HashSet<BroadcastInterface>();

    @Override
    public boolean singleInstance() {
        return true;
    }

    @Override
    public void registerListener(BroadcastInterface listener) {
        this.listeners.add(listener);
    }

    @Override
    public void updateDevice(boolean local, Device device) {
        BroadcastMessage message = new BroadcastMessage();
        message.setDevice(device);
        this.sendMessage(message);
    }

    @Override
    public void updatePosition(boolean local, Position position) {
        BroadcastMessage message = new BroadcastMessage();
        message.setPosition(position);
        this.sendMessage(message);
    }

    @Override
    public void updateEvent(boolean local, long userId, Event event) {
        BroadcastMessage message = new BroadcastMessage();
        message.setUserId(userId);
        message.setEvent(event);
        this.sendMessage(message);
    }

    @Override
    public void updateCommand(boolean local, long deviceId) {
        BroadcastMessage message = new BroadcastMessage();
        message.setCommandDeviceId(deviceId);
        this.sendMessage(message);
    }

    @Override
    public <T extends BaseModel> void invalidateObject(boolean local, Class<T> clazz, long id, ObjectOperation operation) {
        BroadcastMessage message = new BroadcastMessage();
        BroadcastMessage.InvalidateObject invalidateObject = new BroadcastMessage.InvalidateObject();
        invalidateObject.setClazz(Permission.getKey(clazz));
        invalidateObject.setId(id);
        invalidateObject.setOperation(operation);
        message.setInvalidateObject(invalidateObject);
        this.sendMessage(message);
    }

    @Override
    public synchronized <T1 extends BaseModel, T2 extends BaseModel> void invalidatePermission(boolean local, Class<T1> clazz1, long id1, Class<T2> clazz2, long id2, boolean link) {
        BroadcastMessage message = new BroadcastMessage();
        BroadcastMessage.InvalidatePermission invalidatePermission = new BroadcastMessage.InvalidatePermission();
        invalidatePermission.setClazz1(Permission.getKey(clazz1));
        invalidatePermission.setId1(id1);
        invalidatePermission.setClazz2(Permission.getKey(clazz2));
        invalidatePermission.setId2(id2);
        invalidatePermission.setLink(link);
        message.setInvalidatePermission(invalidatePermission);
        this.sendMessage(message);
    }

    protected abstract void sendMessage(BroadcastMessage var1);

    protected void handleMessage(BroadcastMessage message) throws Exception {
        block3: {
            block7: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                if (message.getDevice() == null) break block2;
                                this.listeners.forEach(listener -> listener.updateDevice(false, message.getDevice()));
                                break block3;
                            }
                            if (message.getPosition() == null) break block4;
                            this.listeners.forEach(listener -> listener.updatePosition(false, message.getPosition()));
                            break block3;
                        }
                        if (message.getUserId() == null || message.getEvent() == null) break block5;
                        this.listeners.forEach(listener -> listener.updateEvent(false, message.getUserId(), message.getEvent()));
                        break block3;
                    }
                    if (message.getCommandDeviceId() == null) break block6;
                    this.listeners.forEach(listener -> listener.updateCommand(false, message.getCommandDeviceId()));
                    break block3;
                }
                if (message.getInvalidateObject() == null) break block7;
                BroadcastMessage.InvalidateObject invalidateObject = message.getInvalidateObject();
                for (BroadcastInterface listener2 : this.listeners) {
                    listener2.invalidateObject(false, Permission.getKeyClass(invalidateObject.getClazz()), invalidateObject.getId(), invalidateObject.getOperation());
                }
                break block3;
            }
            if (message.getInvalidatePermission() == null) break block3;
            BroadcastMessage.InvalidatePermission invalidatePermission = message.getInvalidatePermission();
            for (BroadcastInterface listener3 : this.listeners) {
                listener3.invalidatePermission(false, Permission.getKeyClass(invalidatePermission.getClazz1()), invalidatePermission.getId1(), Permission.getKeyClass(invalidatePermission.getClazz2()), invalidatePermission.getId2(), invalidatePermission.getLink());
            }
        }
    }
}

