/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class Pt215ProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_LOGIN = 1;
    public static final int MSG_HEARTBEAT = 8;
    public static final int MSG_GPS_REALTIME = 16;
    public static final int MSG_GPS_OFFLINE = 17;
    public static final int MSG_STATUS = 19;

    public Pt215ProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, int type, ByteBuf content) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeByte(88);
            response.writeByte(88);
            response.writeByte(content != null ? 1 + content.readableBytes() : 1);
            response.writeByte(type);
            if (content != null) {
                response.writeBytes(content);
                content.release();
            }
            response.writeByte(13);
            response.writeByte(10);
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(2);
        buf.readUnsignedByte();
        short type = buf.readUnsignedByte();
        if (type == 1) {
            this.getDeviceSession(channel, remoteAddress, ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)).substring(1));
            this.sendResponse(channel, remoteAddress, type, null);
        } else if (type == 17 || type == 16) {
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
            if (deviceSession == null) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.sendResponse(channel, remoteAddress, type, buf.retainedSlice(buf.readerIndex(), 6));
            DateBuilder dateBuilder = new DateBuilder().setDate(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
            position.setTime(dateBuilder.getDate());
            double latitude = (double)buf.readUnsignedInt() / 60.0 / 30000.0;
            double longitude = (double)buf.readUnsignedInt() / 60.0 / 30000.0;
            int flags = buf.readUnsignedShort();
            position.setCourse(BitUtil.to(flags, 10));
            position.setValid(BitUtil.check(flags, 12));
            if (!BitUtil.check(flags, 10)) {
                latitude = -latitude;
            }
            if (BitUtil.check(flags, 11)) {
                longitude = -longitude;
            }
            position.setLatitude(latitude);
            position.setLongitude(longitude);
            return position;
        }
        return null;
    }
}

