/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.common.base.Supplier;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.auth.AbstractFirebaseAuth;
import com.google.firebase.auth.multitenancy.TenantManager;
import com.google.firebase.internal.FirebaseService;

public final class FirebaseAuth
extends AbstractFirebaseAuth {
    private static final String SERVICE_ID = FirebaseAuth.class.getName();
    private final Supplier<TenantManager> tenantManager;

    private FirebaseAuth(Builder builder) {
        super(builder);
        this.tenantManager = this.threadSafeMemoize(builder.tenantManager);
    }

    public TenantManager getTenantManager() {
        return (TenantManager)this.tenantManager.get();
    }

    public static FirebaseAuth getInstance() {
        return FirebaseAuth.getInstance(FirebaseApp.getInstance());
    }

    public static synchronized FirebaseAuth getInstance(FirebaseApp app) {
        FirebaseAuthService service = ImplFirebaseTrampolines.getService(app, SERVICE_ID, FirebaseAuthService.class);
        if (service == null) {
            service = ImplFirebaseTrampolines.addService(app, new FirebaseAuthService(app));
        }
        return (FirebaseAuth)service.getInstance();
    }

    private static FirebaseAuth fromApp(final FirebaseApp app) {
        return FirebaseAuth.populateBuilderFromApp(FirebaseAuth.builder(), app, null).setTenantManager(new Supplier<TenantManager>(){

            public TenantManager get() {
                return new TenantManager(app);
            }
        }).build();
    }

    static Builder builder() {
        return new Builder();
    }

    static class Builder
    extends AbstractFirebaseAuth.Builder<Builder> {
        private Supplier<TenantManager> tenantManager;

        private Builder() {
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder setTenantManager(Supplier<TenantManager> tenantManager) {
            this.tenantManager = tenantManager;
            return this;
        }

        public FirebaseAuth build() {
            return new FirebaseAuth(this);
        }
    }

    private static class FirebaseAuthService
    extends FirebaseService<FirebaseAuth> {
        FirebaseAuthService(FirebaseApp app) {
            super(SERVICE_ID, FirebaseAuth.fromApp(app));
        }
    }
}

