// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
)

type EntityRefSlice struct {
	orig  *[]*otlpcommon.EntityRef
	state *State
}

func GetOrigEntityRefSlice(ms EntityRefSlice) *[]*otlpcommon.EntityRef {
	return ms.orig
}

func GetEntityRefSliceState(ms EntityRefSlice) *State {
	return ms.state
}

func NewEntityRefSlice(orig *[]*otlpcommon.EntityRef, state *State) EntityRefSlice {
	return EntityRefSlice{orig: orig, state: state}
}

func GenerateTestEntityRefSlice() EntityRefSlice {
	orig := GenerateOrigTestEntityRefSlice()
	return NewEntityRefSlice(&orig, NewState())
}

func CopyOrigEntityRefSlice(dest, src []*otlpcommon.EntityRef) []*otlpcommon.EntityRef {
	var newDest []*otlpcommon.EntityRef
	if cap(dest) < len(src) {
		newDest = make([]*otlpcommon.EntityRef, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigEntityRef()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteOrigEntityRef(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigEntityRef()
		}
	}
	for i := range src {
		CopyOrigEntityRef(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestEntityRefSlice() []*otlpcommon.EntityRef {
	orig := make([]*otlpcommon.EntityRef, 5)
	orig[0] = NewOrigEntityRef()
	orig[1] = GenTestOrigEntityRef()
	orig[2] = NewOrigEntityRef()
	orig[3] = GenTestOrigEntityRef()
	orig[4] = NewOrigEntityRef()
	return orig
}
