// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcollectorlogs "go.opentelemetry.io/proto/slim/otlp/collector/logs/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpcollectorlogs "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/logs/v1"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigExportLogsServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportLogsServiceResponse() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigExportLogsServiceResponse()
				CopyOrigExportLogsServiceResponse(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigExportLogsServiceResponse(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigExportLogsServiceResponseUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigExportLogsServiceResponse()
	UnmarshalJSONOrigExportLogsServiceResponse(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigExportLogsServiceResponse(), dest)
}

func TestMarshalAndUnmarshalJSONOrigExportLogsServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportLogsServiceResponse() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigExportLogsServiceResponse(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigExportLogsServiceResponse()
				UnmarshalJSONOrigExportLogsServiceResponse(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigExportLogsServiceResponse(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigExportLogsServiceResponseFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesExportLogsServiceResponse() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigExportLogsServiceResponse()
			require.Error(t, UnmarshalProtoOrigExportLogsServiceResponse(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigExportLogsServiceResponseUnknown(t *testing.T) {
	dest := NewOrigExportLogsServiceResponse()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigExportLogsServiceResponse(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigExportLogsServiceResponse(), dest)
}

func TestMarshalAndUnmarshalProtoOrigExportLogsServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportLogsServiceResponse() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigExportLogsServiceResponse(src))
				gotSize := MarshalProtoOrigExportLogsServiceResponse(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigExportLogsServiceResponse()
				require.NoError(t, UnmarshalProtoOrigExportLogsServiceResponse(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigExportLogsServiceResponse(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufExportLogsServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportLogsServiceResponse() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigExportLogsServiceResponse(src))
			gotSize := MarshalProtoOrigExportLogsServiceResponse(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcollectorlogs.ExportLogsServiceResponse{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigExportLogsServiceResponse()
			require.NoError(t, UnmarshalProtoOrigExportLogsServiceResponse(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesExportLogsServiceResponse() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                  {0x02},
		"PartialSuccess/wrong_wire_type": {0xc},
		"PartialSuccess/missing_value":   {0xa},
	}
}

func genTestEncodingValuesExportLogsServiceResponse() map[string]*otlpcollectorlogs.ExportLogsServiceResponse {
	return map[string]*otlpcollectorlogs.ExportLogsServiceResponse{
		"empty":               NewOrigExportLogsServiceResponse(),
		"PartialSuccess/test": {PartialSuccess: *GenTestOrigExportLogsPartialSuccess()},
	}
}
