// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
)

func CopyOrigNumberDataPointSlice(dest, src []*otlpmetrics.NumberDataPoint) []*otlpmetrics.NumberDataPoint {
	var newDest []*otlpmetrics.NumberDataPoint
	if cap(dest) < len(src) {
		newDest = make([]*otlpmetrics.NumberDataPoint, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigNumberDataPoint()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteOrigNumberDataPoint(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigNumberDataPoint()
		}
	}
	for i := range src {
		CopyOrigNumberDataPoint(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestNumberDataPointSlice() []*otlpmetrics.NumberDataPoint {
	orig := make([]*otlpmetrics.NumberDataPoint, 5)
	orig[0] = NewOrigNumberDataPoint()
	orig[1] = GenTestOrigNumberDataPoint()
	orig[2] = NewOrigNumberDataPoint()
	orig[3] = GenTestOrigNumberDataPoint()
	orig[4] = NewOrigNumberDataPoint()
	return orig
}
