// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
)

func TestCopyOrigNumberDataPointSlice(t *testing.T) {
	src := []*otlpmetrics.NumberDataPoint{}
	dest := []*otlpmetrics.NumberDataPoint{}
	// Test CopyTo empty
	dest = CopyOrigNumberDataPointSlice(dest, src)
	assert.Equal(t, []*otlpmetrics.NumberDataPoint{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestNumberDataPointSlice()
	dest = CopyOrigNumberDataPointSlice(dest, src)
	assert.Equal(t, GenerateOrigTestNumberDataPointSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigNumberDataPointSlice(dest, src)
	assert.Equal(t, GenerateOrigTestNumberDataPointSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigNumberDataPointSlice(dest, []*otlpmetrics.NumberDataPoint{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigNumberDataPointSlice(dest, src)
	assert.Equal(t, GenerateOrigTestNumberDataPointSlice(), dest)
}
