// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpprofiles "go.opentelemetry.io/proto/slim/otlp/profiles/v1development"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigResourceProfiles(t *testing.T) {
	for name, src := range genTestEncodingValuesResourceProfiles() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigResourceProfiles()
				CopyOrigResourceProfiles(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigResourceProfiles(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigResourceProfilesUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigResourceProfiles()
	UnmarshalJSONOrigResourceProfiles(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigResourceProfiles(), dest)
}

func TestMarshalAndUnmarshalJSONOrigResourceProfiles(t *testing.T) {
	for name, src := range genTestEncodingValuesResourceProfiles() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigResourceProfiles(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigResourceProfiles()
				UnmarshalJSONOrigResourceProfiles(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigResourceProfiles(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigResourceProfilesFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesResourceProfiles() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigResourceProfiles()
			require.Error(t, UnmarshalProtoOrigResourceProfiles(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigResourceProfilesUnknown(t *testing.T) {
	dest := NewOrigResourceProfiles()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigResourceProfiles(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigResourceProfiles(), dest)
}

func TestMarshalAndUnmarshalProtoOrigResourceProfiles(t *testing.T) {
	for name, src := range genTestEncodingValuesResourceProfiles() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigResourceProfiles(src))
				gotSize := MarshalProtoOrigResourceProfiles(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigResourceProfiles()
				require.NoError(t, UnmarshalProtoOrigResourceProfiles(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigResourceProfiles(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufResourceProfiles(t *testing.T) {
	for name, src := range genTestEncodingValuesResourceProfiles() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigResourceProfiles(src))
			gotSize := MarshalProtoOrigResourceProfiles(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpprofiles.ResourceProfiles{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigResourceProfiles()
			require.NoError(t, UnmarshalProtoOrigResourceProfiles(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesResourceProfiles() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                 {0x02},
		"Resource/wrong_wire_type":      {0xc},
		"Resource/missing_value":        {0xa},
		"ScopeProfiles/wrong_wire_type": {0x14},
		"ScopeProfiles/missing_value":   {0x12},
		"SchemaUrl/wrong_wire_type":     {0x1c},
		"SchemaUrl/missing_value":       {0x1a},
	}
}

func genTestEncodingValuesResourceProfiles() map[string]*otlpprofiles.ResourceProfiles {
	return map[string]*otlpprofiles.ResourceProfiles{
		"empty":                          NewOrigResourceProfiles(),
		"Resource/test":                  {Resource: *GenTestOrigResource()},
		"ScopeProfiles/default_and_test": {ScopeProfiles: []*otlpprofiles.ScopeProfiles{{}, GenTestOrigScopeProfiles()}},
		"SchemaUrl/test":                 {SchemaUrl: "test_schemaurl"},
	}
}
