// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/networksecurity/v1/server_tls_policy.proto

package networksecurity

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// ServerTlsPolicy is a resource that specifies how a server should authenticate
// incoming requests. This resource itself does not affect configuration unless
// it is attached to a target https proxy or endpoint config selector resource.
type ServerTlsPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the ServerTlsPolicy resource. It matches the pattern
	// `projects/*/locations/{location}/serverTlsPolicies/{server_tls_policy}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Free-text description of the resource.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The timestamp when the resource was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when the resource was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Set of label tags associated with the resource.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	//
	// Determines if server allows plaintext connections. If set to true, server
	// allows plain text connections. By default, it is set to false. This setting
	// is not exclusive of other encryption modes. For example, if `allow_open`
	// and `mtls_policy` are set, server allows both plain text and mTLS
	// connections. See documentation of other encryption modes to confirm
	// compatibility.
	//
	// Consider using it if you wish to upgrade in place your deployment to TLS
	// while having mixed TLS and non-TLS traffic reaching port :80.
	AllowOpen bool `protobuf:"varint,6,opt,name=allow_open,json=allowOpen,proto3" json:"allow_open,omitempty"`
	//
	// Defines a mechanism to provision server identity (public and private keys).
	// Cannot be combined with `allow_open` as a permissive mode that allows both
	// plain text and TLS is not supported.
	ServerCertificate *CertificateProvider `protobuf:"bytes,7,opt,name=server_certificate,json=serverCertificate,proto3" json:"server_certificate,omitempty"`
	//
	// Defines a mechanism to provision peer validation certificates for peer to
	// peer authentication (Mutual TLS - mTLS). If not specified, client
	// certificate will not be requested. The connection is treated as TLS and not
	// mTLS. If `allow_open` and `mtls_policy` are set, server allows both plain
	// text and mTLS connections.
	MtlsPolicy *ServerTlsPolicy_MTLSPolicy `protobuf:"bytes,8,opt,name=mtls_policy,json=mtlsPolicy,proto3" json:"mtls_policy,omitempty"`
}

func (x *ServerTlsPolicy) Reset() {
	*x = ServerTlsPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networksecurity_v1_server_tls_policy_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServerTlsPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerTlsPolicy) ProtoMessage() {}

func (x *ServerTlsPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networksecurity_v1_server_tls_policy_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerTlsPolicy.ProtoReflect.Descriptor instead.
func (*ServerTlsPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1_server_tls_policy_proto_rawDescGZIP(), []int{0}
}

func (x *ServerTlsPolicy) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ServerTlsPolicy) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ServerTlsPolicy) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ServerTlsPolicy) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ServerTlsPolicy) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ServerTlsPolicy) GetAllowOpen() bool {
	if x != nil {
		return x.AllowOpen
	}
	return false
}

func (x *ServerTlsPolicy) GetServerCertificate() *CertificateProvider {
	if x != nil {
		return x.ServerCertificate
	}
	return nil
}

func (x *ServerTlsPolicy) GetMtlsPolicy() *ServerTlsPolicy_MTLSPolicy {
	if x != nil {
		return x.MtlsPolicy
	}
	return nil
}

// Request used by the ListServerTlsPolicies method.
type ListServerTlsPoliciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location from which the ServerTlsPolicies should
	// be listed, specified in the format `projects/*/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of ServerTlsPolicies to return per call.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListServerTlsPoliciesResponse`
	// Indicates that this is a continuation of a prior
	// `ListServerTlsPolicies` call, and that the system
	// should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListServerTlsPoliciesRequest) Reset() {
	*x = ListServerTlsPoliciesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networksecurity_v1_server_tls_policy_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListServerTlsPoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServerTlsPoliciesRequest) ProtoMessage() {}

func (x *ListServerTlsPoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networksecurity_v1_server_tls_policy_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListServerTlsPoliciesRequest.ProtoReflect.Descriptor instead.
func (*ListServerTlsPoliciesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1_server_tls_policy_proto_rawDescGZIP(), []int{1}
}

func (x *ListServerTlsPoliciesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListServerTlsPoliciesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListServerTlsPoliciesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response returned by the ListServerTlsPolicies method.
type ListServerTlsPoliciesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of ServerTlsPolicy resources.
	ServerTlsPolicies []*ServerTlsPolicy `protobuf:"bytes,1,rep,name=server_tls_policies,json=serverTlsPolicies,proto3" json:"server_tls_policies,omitempty"`
	// If there might be more results than those appearing in this response, then
	// `next_page_token` is included. To get the next set of results, call this
	// method again using the value of `next_page_token` as `page_token`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListServerTlsPoliciesResponse) Reset() {
	*x = ListServerTlsPoliciesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networksecurity_v1_server_tls_policy_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListServerTlsPoliciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListServerTlsPoliciesResponse) ProtoMessage() {}

func (x *ListServerTlsPoliciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networksecurity_v1_server_tls_policy_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListServerTlsPoliciesResponse.ProtoReflect.Descriptor instead.
func (*ListServerTlsPoliciesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1_server_tls_policy_proto_rawDescGZIP(), []int{2}
}

func (x *ListServerTlsPoliciesResponse) GetServerTlsPolicies() []*ServerTlsPolicy {
	if x != nil {
		return x.ServerTlsPolicies
	}
	return nil
}

func (x *ListServerTlsPoliciesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request used by the GetServerTlsPolicy method.
type GetServerTlsPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A name of the ServerTlsPolicy to get. Must be in the format
	// `projects/*/locations/{location}/serverTlsPolicies/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetServerTlsPolicyRequest) Reset() {
	*x = GetServerTlsPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networksecurity_v1_server_tls_policy_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetServerTlsPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetServerTlsPolicyRequest) ProtoMessage() {}

func (x *GetServerTlsPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networksecurity_v1_server_tls_policy_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetServerTlsPolicyRequest.ProtoReflect.Descriptor instead.
func (*GetServerTlsPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1_server_tls_policy_proto_rawDescGZIP(), []int{3}
}

func (x *GetServerTlsPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request used by the CreateServerTlsPolicy method.
type CreateServerTlsPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the ServerTlsPolicy. Must be in
	// the format `projects/*/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Short name of the ServerTlsPolicy resource to be created. This value should
	// be 1-63 characters long, containing only letters, numbers, hyphens, and
	// underscores, and should not start with a number. E.g. "server_mtls_policy".
	ServerTlsPolicyId string `protobuf:"bytes,2,opt,name=server_tls_policy_id,json=serverTlsPolicyId,proto3" json:"server_tls_policy_id,omitempty"`
	// Required. ServerTlsPolicy resource to be created.
	ServerTlsPolicy *ServerTlsPolicy `protobuf:"bytes,3,opt,name=server_tls_policy,json=serverTlsPolicy,proto3" json:"server_tls_policy,omitempty"`
}

func (x *CreateServerTlsPolicyRequest) Reset() {
	*x = CreateServerTlsPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networksecurity_v1_server_tls_policy_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateServerTlsPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateServerTlsPolicyRequest) ProtoMessage() {}

func (x *CreateServerTlsPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networksecurity_v1_server_tls_policy_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateServerTlsPolicyRequest.ProtoReflect.Descriptor instead.
func (*CreateServerTlsPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1_server_tls_policy_proto_rawDescGZIP(), []int{4}
}

func (x *CreateServerTlsPolicyRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateServerTlsPolicyRequest) GetServerTlsPolicyId() string {
	if x != nil {
		return x.ServerTlsPolicyId
	}
	return ""
}

func (x *CreateServerTlsPolicyRequest) GetServerTlsPolicy() *ServerTlsPolicy {
	if x != nil {
		return x.ServerTlsPolicy
	}
	return nil
}

// Request used by UpdateServerTlsPolicy method.
type UpdateServerTlsPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Field mask is used to specify the fields to be overwritten in the
	// ServerTlsPolicy resource by the update.  The fields
	// specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the
	// mask. If the user does not provide a mask then all fields will be
	// overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. Updated ServerTlsPolicy resource.
	ServerTlsPolicy *ServerTlsPolicy `protobuf:"bytes,2,opt,name=server_tls_policy,json=serverTlsPolicy,proto3" json:"server_tls_policy,omitempty"`
}

func (x *UpdateServerTlsPolicyRequest) Reset() {
	*x = UpdateServerTlsPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networksecurity_v1_server_tls_policy_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateServerTlsPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateServerTlsPolicyRequest) ProtoMessage() {}

func (x *UpdateServerTlsPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networksecurity_v1_server_tls_policy_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateServerTlsPolicyRequest.ProtoReflect.Descriptor instead.
func (*UpdateServerTlsPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1_server_tls_policy_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateServerTlsPolicyRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateServerTlsPolicyRequest) GetServerTlsPolicy() *ServerTlsPolicy {
	if x != nil {
		return x.ServerTlsPolicy
	}
	return nil
}

// Request used by the DeleteServerTlsPolicy method.
type DeleteServerTlsPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A name of the ServerTlsPolicy to delete. Must be in
	// the format `projects/*/locations/{location}/serverTlsPolicies/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteServerTlsPolicyRequest) Reset() {
	*x = DeleteServerTlsPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networksecurity_v1_server_tls_policy_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteServerTlsPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteServerTlsPolicyRequest) ProtoMessage() {}

func (x *DeleteServerTlsPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networksecurity_v1_server_tls_policy_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteServerTlsPolicyRequest.ProtoReflect.Descriptor instead.
func (*DeleteServerTlsPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1_server_tls_policy_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteServerTlsPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Specification of the MTLSPolicy.
type ServerTlsPolicy_MTLSPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	//
	// Defines the mechanism to obtain the Certificate Authority certificate to
	// validate the client certificate.
	ClientValidationCa []*ValidationCA `protobuf:"bytes,1,rep,name=client_validation_ca,json=clientValidationCa,proto3" json:"client_validation_ca,omitempty"`
}

func (x *ServerTlsPolicy_MTLSPolicy) Reset() {
	*x = ServerTlsPolicy_MTLSPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networksecurity_v1_server_tls_policy_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServerTlsPolicy_MTLSPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServerTlsPolicy_MTLSPolicy) ProtoMessage() {}

func (x *ServerTlsPolicy_MTLSPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networksecurity_v1_server_tls_policy_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServerTlsPolicy_MTLSPolicy.ProtoReflect.Descriptor instead.
func (*ServerTlsPolicy_MTLSPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_networksecurity_v1_server_tls_policy_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ServerTlsPolicy_MTLSPolicy) GetClientValidationCa() []*ValidationCA {
	if x != nil {
		return x.ClientValidationCa
	}
	return nil
}

var File_google_cloud_networksecurity_v1_server_tls_policy_proto protoreflect.FileDescriptor

var file_google_cloud_networksecurity_v1_server_tls_policy_proto_rawDesc = []byte{
	0x0a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2f, 0x76,
	0x31, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x74, 0x6c, 0x73, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x6c, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb7, 0x06, 0x0a, 0x0f, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x54,
	0x6c, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x54, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x54, 0x6c, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x1d, 0x0a,
	0x0a, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6f, 0x70, 0x65, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x09, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4f, 0x70, 0x65, 0x6e, 0x12, 0x63, 0x0a, 0x12,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x52, 0x11,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x12, 0x5c, 0x0a, 0x0b, 0x6d, 0x74, 0x6c, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63,
	0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x54,
	0x6c, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x4d, 0x54, 0x4c, 0x53, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x0a, 0x6d, 0x74, 0x6c, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x1a,
	0x6d, 0x0a, 0x0a, 0x4d, 0x54, 0x4c, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x5f, 0x0a,
	0x14, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x61, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x41, 0x52, 0x12, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x1a, 0x39,
	0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x82, 0x01, 0xea, 0x41, 0x7f, 0x0a,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x54, 0x6c, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x4d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x54,
	0x6c, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x5f, 0x74, 0x6c, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x7d, 0x22, 0x9d,
	0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x54, 0x6c, 0x73,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa9,
	0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x54, 0x6c, 0x73,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x60, 0x0a, 0x13, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x74, 0x6c, 0x73, 0x5f, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x54, 0x6c, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52,
	0x11, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x54, 0x6c, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x67, 0x0a, 0x19, 0x47, 0x65,
	0x74, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x54, 0x6c, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x54, 0x6c, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x87, 0x02, 0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x54, 0x6c, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x12, 0x2e, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x54, 0x6c, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x34, 0x0a, 0x14, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x74,
	0x6c, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x54,
	0x6c, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x64, 0x12, 0x61, 0x0a, 0x11, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x5f, 0x74, 0x6c, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x54, 0x6c,
	0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x73, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x54, 0x6c, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0xc3, 0x01,
	0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x54, 0x6c,
	0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b,
	0x12, 0x61, 0x0a, 0x11, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x74, 0x6c, 0x73, 0x5f, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x54, 0x6c, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x54, 0x6c, 0x73, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x22, 0x6a, 0x0a, 0x1c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x54, 0x6c, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x54, 0x6c, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x42,
	0xf6, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x2e, 0x76, 0x31, 0x42, 0x14, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x54,
	0x6c, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x4e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f,
	0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2f, 0x76, 0x31, 0x3b,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0xaa,
	0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x56,
	0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79,
	0x5c, 0x56, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_networksecurity_v1_server_tls_policy_proto_rawDescOnce sync.Once
	file_google_cloud_networksecurity_v1_server_tls_policy_proto_rawDescData = file_google_cloud_networksecurity_v1_server_tls_policy_proto_rawDesc
)

func file_google_cloud_networksecurity_v1_server_tls_policy_proto_rawDescGZIP() []byte {
	file_google_cloud_networksecurity_v1_server_tls_policy_proto_rawDescOnce.Do(func() {
		file_google_cloud_networksecurity_v1_server_tls_policy_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_networksecurity_v1_server_tls_policy_proto_rawDescData)
	})
	return file_google_cloud_networksecurity_v1_server_tls_policy_proto_rawDescData
}

var file_google_cloud_networksecurity_v1_server_tls_policy_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_cloud_networksecurity_v1_server_tls_policy_proto_goTypes = []interface{}{
	(*ServerTlsPolicy)(nil),               // 0: google.cloud.networksecurity.v1.ServerTlsPolicy
	(*ListServerTlsPoliciesRequest)(nil),  // 1: google.cloud.networksecurity.v1.ListServerTlsPoliciesRequest
	(*ListServerTlsPoliciesResponse)(nil), // 2: google.cloud.networksecurity.v1.ListServerTlsPoliciesResponse
	(*GetServerTlsPolicyRequest)(nil),     // 3: google.cloud.networksecurity.v1.GetServerTlsPolicyRequest
	(*CreateServerTlsPolicyRequest)(nil),  // 4: google.cloud.networksecurity.v1.CreateServerTlsPolicyRequest
	(*UpdateServerTlsPolicyRequest)(nil),  // 5: google.cloud.networksecurity.v1.UpdateServerTlsPolicyRequest
	(*DeleteServerTlsPolicyRequest)(nil),  // 6: google.cloud.networksecurity.v1.DeleteServerTlsPolicyRequest
	(*ServerTlsPolicy_MTLSPolicy)(nil),    // 7: google.cloud.networksecurity.v1.ServerTlsPolicy.MTLSPolicy
	nil,                                   // 8: google.cloud.networksecurity.v1.ServerTlsPolicy.LabelsEntry
	(*timestamppb.Timestamp)(nil),         // 9: google.protobuf.Timestamp
	(*CertificateProvider)(nil),           // 10: google.cloud.networksecurity.v1.CertificateProvider
	(*fieldmaskpb.FieldMask)(nil),         // 11: google.protobuf.FieldMask
	(*ValidationCA)(nil),                  // 12: google.cloud.networksecurity.v1.ValidationCA
}
var file_google_cloud_networksecurity_v1_server_tls_policy_proto_depIdxs = []int32{
	9,  // 0: google.cloud.networksecurity.v1.ServerTlsPolicy.create_time:type_name -> google.protobuf.Timestamp
	9,  // 1: google.cloud.networksecurity.v1.ServerTlsPolicy.update_time:type_name -> google.protobuf.Timestamp
	8,  // 2: google.cloud.networksecurity.v1.ServerTlsPolicy.labels:type_name -> google.cloud.networksecurity.v1.ServerTlsPolicy.LabelsEntry
	10, // 3: google.cloud.networksecurity.v1.ServerTlsPolicy.server_certificate:type_name -> google.cloud.networksecurity.v1.CertificateProvider
	7,  // 4: google.cloud.networksecurity.v1.ServerTlsPolicy.mtls_policy:type_name -> google.cloud.networksecurity.v1.ServerTlsPolicy.MTLSPolicy
	0,  // 5: google.cloud.networksecurity.v1.ListServerTlsPoliciesResponse.server_tls_policies:type_name -> google.cloud.networksecurity.v1.ServerTlsPolicy
	0,  // 6: google.cloud.networksecurity.v1.CreateServerTlsPolicyRequest.server_tls_policy:type_name -> google.cloud.networksecurity.v1.ServerTlsPolicy
	11, // 7: google.cloud.networksecurity.v1.UpdateServerTlsPolicyRequest.update_mask:type_name -> google.protobuf.FieldMask
	0,  // 8: google.cloud.networksecurity.v1.UpdateServerTlsPolicyRequest.server_tls_policy:type_name -> google.cloud.networksecurity.v1.ServerTlsPolicy
	12, // 9: google.cloud.networksecurity.v1.ServerTlsPolicy.MTLSPolicy.client_validation_ca:type_name -> google.cloud.networksecurity.v1.ValidationCA
	10, // [10:10] is the sub-list for method output_type
	10, // [10:10] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_google_cloud_networksecurity_v1_server_tls_policy_proto_init() }
func file_google_cloud_networksecurity_v1_server_tls_policy_proto_init() {
	if File_google_cloud_networksecurity_v1_server_tls_policy_proto != nil {
		return
	}
	file_google_cloud_networksecurity_v1_tls_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_networksecurity_v1_server_tls_policy_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServerTlsPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networksecurity_v1_server_tls_policy_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListServerTlsPoliciesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networksecurity_v1_server_tls_policy_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListServerTlsPoliciesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networksecurity_v1_server_tls_policy_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetServerTlsPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networksecurity_v1_server_tls_policy_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateServerTlsPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networksecurity_v1_server_tls_policy_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateServerTlsPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networksecurity_v1_server_tls_policy_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteServerTlsPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networksecurity_v1_server_tls_policy_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServerTlsPolicy_MTLSPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_networksecurity_v1_server_tls_policy_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_networksecurity_v1_server_tls_policy_proto_goTypes,
		DependencyIndexes: file_google_cloud_networksecurity_v1_server_tls_policy_proto_depIdxs,
		MessageInfos:      file_google_cloud_networksecurity_v1_server_tls_policy_proto_msgTypes,
	}.Build()
	File_google_cloud_networksecurity_v1_server_tls_policy_proto = out.File
	file_google_cloud_networksecurity_v1_server_tls_policy_proto_rawDesc = nil
	file_google_cloud_networksecurity_v1_server_tls_policy_proto_goTypes = nil
	file_google_cloud_networksecurity_v1_server_tls_policy_proto_depIdxs = nil
}
