package main

import (
	"context"
	"fmt"
	"log"

	"github.com/owenthereal/tmux"
)

func main() {
	ctx := context.Background()

	t, err := tmux.Default()
	if err != nil {
		log.Fatal(err)
	}

	server, err := t.GetServerInformation(ctx)
	if err != nil {
		log.Fatal(err)
	}

	fmt.Println(server.Version)
}
