// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dataplex/v1/catalog.proto

package dataplexpb

import (
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// View for controlling which parts of an entry are to be returned.
type EntryView int32

const (
	// Unspecified EntryView. Defaults to FULL.
	EntryView_ENTRY_VIEW_UNSPECIFIED EntryView = 0
	// Returns entry only, without aspects.
	EntryView_BASIC EntryView = 1
	// Returns all required aspects as well as the keys of all non-required
	// aspects.
	EntryView_FULL EntryView = 2
	// Returns aspects matching custom fields in GetEntryRequest. If the number of
	// aspects exceeds 100, the first 100 will be returned.
	EntryView_CUSTOM EntryView = 3
	EntryView_ALL    EntryView = 4
)

// Enum value maps for EntryView.
var (
	EntryView_name = map[int32]string{
		0: "ENTRY_VIEW_UNSPECIFIED",
		1: "BASIC",
		2: "FULL",
		3: "CUSTOM",
		4: "ALL",
	}
	EntryView_value = map[string]int32{
		"ENTRY_VIEW_UNSPECIFIED": 0,
		"BASIC":                  1,
		"FULL":                   2,
		"CUSTOM":                 3,
		"ALL":                    4,
	}
)

func (x EntryView) Enum() *EntryView {
	p := new(EntryView)
	*p = x
	return p
}

func (x EntryView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EntryView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_catalog_proto_enumTypes[0].Descriptor()
}

func (EntryView) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_catalog_proto_enumTypes[0]
}

func (x EntryView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EntryView.Descriptor instead.
func (EntryView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{0}
}

// Denotes the transfer status of a resource. It is unspecified for resources
// created from Dataplex API.
type TransferStatus int32

const (
	// The default value. It is set for resources that were not subject for
	// migration from Data Catalog service.
	TransferStatus_TRANSFER_STATUS_UNSPECIFIED TransferStatus = 0
	// Indicates that a resource was migrated from Data Catalog service but it
	// hasn't been transferred yet. In particular the resource cannot be updated
	// from Dataplex API.
	TransferStatus_TRANSFER_STATUS_MIGRATED TransferStatus = 1
	// Indicates that a resource was transferred from Data Catalog service. The
	// resource can only be updated from Dataplex API.
	TransferStatus_TRANSFER_STATUS_TRANSFERRED TransferStatus = 2
)

// Enum value maps for TransferStatus.
var (
	TransferStatus_name = map[int32]string{
		0: "TRANSFER_STATUS_UNSPECIFIED",
		1: "TRANSFER_STATUS_MIGRATED",
		2: "TRANSFER_STATUS_TRANSFERRED",
	}
	TransferStatus_value = map[string]int32{
		"TRANSFER_STATUS_UNSPECIFIED": 0,
		"TRANSFER_STATUS_MIGRATED":    1,
		"TRANSFER_STATUS_TRANSFERRED": 2,
	}
)

func (x TransferStatus) Enum() *TransferStatus {
	p := new(TransferStatus)
	*p = x
	return p
}

func (x TransferStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransferStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_catalog_proto_enumTypes[1].Descriptor()
}

func (TransferStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_catalog_proto_enumTypes[1]
}

func (x TransferStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransferStatus.Descriptor instead.
func (TransferStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{1}
}

// Classifies the data stored by the aspect.
type AspectType_DataClassification int32

const (
	// Denotes that the aspect contains only metadata.
	AspectType_DATA_CLASSIFICATION_UNSPECIFIED AspectType_DataClassification = 0
	// Metadata and data classification.
	AspectType_METADATA_AND_DATA AspectType_DataClassification = 1
)

// Enum value maps for AspectType_DataClassification.
var (
	AspectType_DataClassification_name = map[int32]string{
		0: "DATA_CLASSIFICATION_UNSPECIFIED",
		1: "METADATA_AND_DATA",
	}
	AspectType_DataClassification_value = map[string]int32{
		"DATA_CLASSIFICATION_UNSPECIFIED": 0,
		"METADATA_AND_DATA":               1,
	}
)

func (x AspectType_DataClassification) Enum() *AspectType_DataClassification {
	p := new(AspectType_DataClassification)
	*p = x
	return p
}

func (x AspectType_DataClassification) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AspectType_DataClassification) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_catalog_proto_enumTypes[2].Descriptor()
}

func (AspectType_DataClassification) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_catalog_proto_enumTypes[2]
}

func (x AspectType_DataClassification) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AspectType_DataClassification.Descriptor instead.
func (AspectType_DataClassification) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{0, 0}
}

// Metadata job type.
type MetadataJob_Type int32

const (
	// Unspecified.
	MetadataJob_TYPE_UNSPECIFIED MetadataJob_Type = 0
	// Import job.
	MetadataJob_IMPORT MetadataJob_Type = 1
	// Export job.
	MetadataJob_EXPORT MetadataJob_Type = 2
)

// Enum value maps for MetadataJob_Type.
var (
	MetadataJob_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "IMPORT",
		2: "EXPORT",
	}
	MetadataJob_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"IMPORT":           1,
		"EXPORT":           2,
	}
)

func (x MetadataJob_Type) Enum() *MetadataJob_Type {
	p := new(MetadataJob_Type)
	*p = x
	return p
}

func (x MetadataJob_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetadataJob_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_catalog_proto_enumTypes[3].Descriptor()
}

func (MetadataJob_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_catalog_proto_enumTypes[3]
}

func (x MetadataJob_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetadataJob_Type.Descriptor instead.
func (MetadataJob_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{41, 0}
}

// Specifies how the entries and aspects in a metadata import job are
// updated. For more information, see [Sync
// mode](https://cloud.google.com/dataplex/docs/import-metadata#sync-mode).
type MetadataJob_ImportJobSpec_SyncMode int32

const (
	// Sync mode unspecified.
	MetadataJob_ImportJobSpec_SYNC_MODE_UNSPECIFIED MetadataJob_ImportJobSpec_SyncMode = 0
	// All resources in the job's scope are modified. If a resource exists in
	// Dataplex Universal Catalog but isn't included in the metadata import
	// file, the resource is deleted when you run the metadata job. Use this
	// mode to perform a full sync of the set of entries in the job scope.
	//
	// This sync mode is supported for entries.
	MetadataJob_ImportJobSpec_FULL MetadataJob_ImportJobSpec_SyncMode = 1
	// Only the resources that are explicitly included in the
	// metadata import file are modified. Use this mode to modify a subset of
	// resources while leaving unreferenced resources unchanged.
	//
	// This sync mode is supported for aspects.
	MetadataJob_ImportJobSpec_INCREMENTAL MetadataJob_ImportJobSpec_SyncMode = 2
	// If entry sync mode is `NONE`, then aspects are modified according
	// to the aspect sync mode. Other metadata that belongs to entries in the
	// job's scope isn't modified.
	//
	// This sync mode is supported for entries.
	MetadataJob_ImportJobSpec_NONE MetadataJob_ImportJobSpec_SyncMode = 3
)

// Enum value maps for MetadataJob_ImportJobSpec_SyncMode.
var (
	MetadataJob_ImportJobSpec_SyncMode_name = map[int32]string{
		0: "SYNC_MODE_UNSPECIFIED",
		1: "FULL",
		2: "INCREMENTAL",
		3: "NONE",
	}
	MetadataJob_ImportJobSpec_SyncMode_value = map[string]int32{
		"SYNC_MODE_UNSPECIFIED": 0,
		"FULL":                  1,
		"INCREMENTAL":           2,
		"NONE":                  3,
	}
)

func (x MetadataJob_ImportJobSpec_SyncMode) Enum() *MetadataJob_ImportJobSpec_SyncMode {
	p := new(MetadataJob_ImportJobSpec_SyncMode)
	*p = x
	return p
}

func (x MetadataJob_ImportJobSpec_SyncMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetadataJob_ImportJobSpec_SyncMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_catalog_proto_enumTypes[4].Descriptor()
}

func (MetadataJob_ImportJobSpec_SyncMode) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_catalog_proto_enumTypes[4]
}

func (x MetadataJob_ImportJobSpec_SyncMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetadataJob_ImportJobSpec_SyncMode.Descriptor instead.
func (MetadataJob_ImportJobSpec_SyncMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{41, 2, 0}
}

// The level of logs to write to Cloud Logging for this job.
type MetadataJob_ImportJobSpec_LogLevel int32

const (
	// Log level unspecified.
	MetadataJob_ImportJobSpec_LOG_LEVEL_UNSPECIFIED MetadataJob_ImportJobSpec_LogLevel = 0
	// Debug-level logging. Captures detailed logs for each import item. Use
	// debug-level logging to troubleshoot issues with specific import items.
	// For example, use debug-level logging to identify resources that are
	// missing from the job scope, entries or aspects that don't conform to
	// the associated entry type or aspect type, or other misconfigurations
	// with the metadata import file.
	//
	// Depending on the size of your metadata job and the number of logs that
	// are generated, debug-level logging might incur
	// [additional costs](https://cloud.google.com/stackdriver/pricing).
	MetadataJob_ImportJobSpec_DEBUG MetadataJob_ImportJobSpec_LogLevel = 1
	// Info-level logging. Captures logs at the overall job level. Includes
	// aggregate logs about import items, but doesn't specify which import
	// item has an error.
	MetadataJob_ImportJobSpec_INFO MetadataJob_ImportJobSpec_LogLevel = 2
)

// Enum value maps for MetadataJob_ImportJobSpec_LogLevel.
var (
	MetadataJob_ImportJobSpec_LogLevel_name = map[int32]string{
		0: "LOG_LEVEL_UNSPECIFIED",
		1: "DEBUG",
		2: "INFO",
	}
	MetadataJob_ImportJobSpec_LogLevel_value = map[string]int32{
		"LOG_LEVEL_UNSPECIFIED": 0,
		"DEBUG":                 1,
		"INFO":                  2,
	}
)

func (x MetadataJob_ImportJobSpec_LogLevel) Enum() *MetadataJob_ImportJobSpec_LogLevel {
	p := new(MetadataJob_ImportJobSpec_LogLevel)
	*p = x
	return p
}

func (x MetadataJob_ImportJobSpec_LogLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetadataJob_ImportJobSpec_LogLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_catalog_proto_enumTypes[5].Descriptor()
}

func (MetadataJob_ImportJobSpec_LogLevel) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_catalog_proto_enumTypes[5]
}

func (x MetadataJob_ImportJobSpec_LogLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetadataJob_ImportJobSpec_LogLevel.Descriptor instead.
func (MetadataJob_ImportJobSpec_LogLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{41, 2, 1}
}

// State of a metadata job.
type MetadataJob_Status_State int32

const (
	// State unspecified.
	MetadataJob_Status_STATE_UNSPECIFIED MetadataJob_Status_State = 0
	// The job is queued.
	MetadataJob_Status_QUEUED MetadataJob_Status_State = 1
	// The job is running.
	MetadataJob_Status_RUNNING MetadataJob_Status_State = 2
	// The job is being canceled.
	MetadataJob_Status_CANCELING MetadataJob_Status_State = 3
	// The job is canceled.
	MetadataJob_Status_CANCELED MetadataJob_Status_State = 4
	// The job succeeded.
	MetadataJob_Status_SUCCEEDED MetadataJob_Status_State = 5
	// The job failed.
	MetadataJob_Status_FAILED MetadataJob_Status_State = 6
	// The job completed with some errors.
	MetadataJob_Status_SUCCEEDED_WITH_ERRORS MetadataJob_Status_State = 7
)

// Enum value maps for MetadataJob_Status_State.
var (
	MetadataJob_Status_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "QUEUED",
		2: "RUNNING",
		3: "CANCELING",
		4: "CANCELED",
		5: "SUCCEEDED",
		6: "FAILED",
		7: "SUCCEEDED_WITH_ERRORS",
	}
	MetadataJob_Status_State_value = map[string]int32{
		"STATE_UNSPECIFIED":     0,
		"QUEUED":                1,
		"RUNNING":               2,
		"CANCELING":             3,
		"CANCELED":              4,
		"SUCCEEDED":             5,
		"FAILED":                6,
		"SUCCEEDED_WITH_ERRORS": 7,
	}
)

func (x MetadataJob_Status_State) Enum() *MetadataJob_Status_State {
	p := new(MetadataJob_Status_State)
	*p = x
	return p
}

func (x MetadataJob_Status_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetadataJob_Status_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_catalog_proto_enumTypes[6].Descriptor()
}

func (MetadataJob_Status_State) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_catalog_proto_enumTypes[6]
}

func (x MetadataJob_Status_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetadataJob_Status_State.Descriptor instead.
func (MetadataJob_Status_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{41, 4, 0}
}

// Reference type of the Entry.
type EntryLink_EntryReference_Type int32

const (
	// Unspecified reference type. Implies that the Entry is referenced
	// in a non-directional Entry Link.
	EntryLink_EntryReference_UNSPECIFIED EntryLink_EntryReference_Type = 0
	// The Entry is referenced as the source of the directional Entry Link.
	EntryLink_EntryReference_SOURCE EntryLink_EntryReference_Type = 2
	// The Entry is referenced as the target of the directional Entry Link.
	EntryLink_EntryReference_TARGET EntryLink_EntryReference_Type = 3
)

// Enum value maps for EntryLink_EntryReference_Type.
var (
	EntryLink_EntryReference_Type_name = map[int32]string{
		0: "UNSPECIFIED",
		2: "SOURCE",
		3: "TARGET",
	}
	EntryLink_EntryReference_Type_value = map[string]int32{
		"UNSPECIFIED": 0,
		"SOURCE":      2,
		"TARGET":      3,
	}
)

func (x EntryLink_EntryReference_Type) Enum() *EntryLink_EntryReference_Type {
	p := new(EntryLink_EntryReference_Type)
	*p = x
	return p
}

func (x EntryLink_EntryReference_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EntryLink_EntryReference_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataplex_v1_catalog_proto_enumTypes[7].Descriptor()
}

func (EntryLink_EntryReference_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_dataplex_v1_catalog_proto_enumTypes[7]
}

func (x EntryLink_EntryReference_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EntryLink_EntryReference_Type.Descriptor instead.
func (EntryLink_EntryReference_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{42, 0, 0}
}

// AspectType is a template for creating Aspects, and represents the
// JSON-schema for a given Entry, for example, BigQuery Table Schema.
type AspectType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The relative resource name of the AspectType, of the form:
	// projects/{project_number}/locations/{location_id}/aspectTypes/{aspect_type_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. System generated globally unique ID for the AspectType.
	// If you delete and recreate the AspectType with the same name, then this ID
	// will be different.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The time when the AspectType was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the AspectType was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Description of the AspectType.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. User friendly display name.
	DisplayName string `protobuf:"bytes,6,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. User-defined labels for the AspectType.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The service computes this checksum. The client may send it on update and
	// delete requests to ensure it has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,8,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. Immutable. Stores data classification of the aspect.
	DataClassification AspectType_DataClassification `protobuf:"varint,9,opt,name=data_classification,json=dataClassification,proto3,enum=google.cloud.dataplex.v1.AspectType_DataClassification" json:"data_classification,omitempty"`
	// Immutable. Defines the Authorization for this type.
	Authorization *AspectType_Authorization `protobuf:"bytes,52,opt,name=authorization,proto3" json:"authorization,omitempty"`
	// Required. MetadataTemplate of the aspect.
	MetadataTemplate *AspectType_MetadataTemplate `protobuf:"bytes,53,opt,name=metadata_template,json=metadataTemplate,proto3" json:"metadata_template,omitempty"`
	// Output only. Denotes the transfer status of the Aspect Type. It is
	// unspecified for Aspect Types created from Dataplex API.
	TransferStatus TransferStatus `protobuf:"varint,202,opt,name=transfer_status,json=transferStatus,proto3,enum=google.cloud.dataplex.v1.TransferStatus" json:"transfer_status,omitempty"`
}

func (x *AspectType) Reset() {
	*x = AspectType{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AspectType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AspectType) ProtoMessage() {}

func (x *AspectType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AspectType.ProtoReflect.Descriptor instead.
func (*AspectType) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{0}
}

func (x *AspectType) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AspectType) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *AspectType) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AspectType) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *AspectType) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *AspectType) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *AspectType) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *AspectType) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *AspectType) GetDataClassification() AspectType_DataClassification {
	if x != nil {
		return x.DataClassification
	}
	return AspectType_DATA_CLASSIFICATION_UNSPECIFIED
}

func (x *AspectType) GetAuthorization() *AspectType_Authorization {
	if x != nil {
		return x.Authorization
	}
	return nil
}

func (x *AspectType) GetMetadataTemplate() *AspectType_MetadataTemplate {
	if x != nil {
		return x.MetadataTemplate
	}
	return nil
}

func (x *AspectType) GetTransferStatus() TransferStatus {
	if x != nil {
		return x.TransferStatus
	}
	return TransferStatus_TRANSFER_STATUS_UNSPECIFIED
}

// An Entry Group represents a logical grouping of one or more Entries.
type EntryGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The relative resource name of the EntryGroup, in the format
	// projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. System generated globally unique ID for the EntryGroup. If you
	// delete and recreate the EntryGroup with the same name, this ID will be
	// different.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The time when the EntryGroup was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the EntryGroup was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Description of the EntryGroup.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. User friendly display name.
	DisplayName string `protobuf:"bytes,6,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. User-defined labels for the EntryGroup.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// This checksum is computed by the service, and might be sent on update and
	// delete requests to ensure the client has an up-to-date value before
	// proceeding.
	Etag string `protobuf:"bytes,8,opt,name=etag,proto3" json:"etag,omitempty"`
	// Output only. Denotes the transfer status of the Entry Group. It is
	// unspecified for Entry Group created from Dataplex API.
	TransferStatus TransferStatus `protobuf:"varint,202,opt,name=transfer_status,json=transferStatus,proto3,enum=google.cloud.dataplex.v1.TransferStatus" json:"transfer_status,omitempty"`
}

func (x *EntryGroup) Reset() {
	*x = EntryGroup{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EntryGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntryGroup) ProtoMessage() {}

func (x *EntryGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntryGroup.ProtoReflect.Descriptor instead.
func (*EntryGroup) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{1}
}

func (x *EntryGroup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EntryGroup) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *EntryGroup) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *EntryGroup) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *EntryGroup) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *EntryGroup) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *EntryGroup) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *EntryGroup) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *EntryGroup) GetTransferStatus() TransferStatus {
	if x != nil {
		return x.TransferStatus
	}
	return TransferStatus_TRANSFER_STATUS_UNSPECIFIED
}

// Entry Type is a template for creating Entries.
type EntryType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The relative resource name of the EntryType, of the form:
	// projects/{project_number}/locations/{location_id}/entryTypes/{entry_type_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. System generated globally unique ID for the EntryType. This ID
	// will be different if the EntryType is deleted and re-created with the same
	// name.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The time when the EntryType was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the EntryType was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Description of the EntryType.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. User friendly display name.
	DisplayName string `protobuf:"bytes,6,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. User-defined labels for the EntryType.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. This checksum is computed by the service, and might be sent on
	// update and delete requests to ensure the client has an up-to-date value
	// before proceeding.
	Etag string `protobuf:"bytes,8,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. Indicates the classes this Entry Type belongs to, for example,
	// TABLE, DATABASE, MODEL.
	TypeAliases []string `protobuf:"bytes,9,rep,name=type_aliases,json=typeAliases,proto3" json:"type_aliases,omitempty"`
	// Optional. The platform that Entries of this type belongs to.
	Platform string `protobuf:"bytes,10,opt,name=platform,proto3" json:"platform,omitempty"`
	// Optional. The system that Entries of this type belongs to. Examples include
	// CloudSQL, MariaDB etc
	System string `protobuf:"bytes,11,opt,name=system,proto3" json:"system,omitempty"`
	// AspectInfo for the entry type.
	RequiredAspects []*EntryType_AspectInfo `protobuf:"bytes,50,rep,name=required_aspects,json=requiredAspects,proto3" json:"required_aspects,omitempty"`
	// Immutable. Authorization defined for this type.
	Authorization *EntryType_Authorization `protobuf:"bytes,51,opt,name=authorization,proto3" json:"authorization,omitempty"`
}

func (x *EntryType) Reset() {
	*x = EntryType{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EntryType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntryType) ProtoMessage() {}

func (x *EntryType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntryType.ProtoReflect.Descriptor instead.
func (*EntryType) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{2}
}

func (x *EntryType) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EntryType) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *EntryType) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *EntryType) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *EntryType) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *EntryType) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *EntryType) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *EntryType) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *EntryType) GetTypeAliases() []string {
	if x != nil {
		return x.TypeAliases
	}
	return nil
}

func (x *EntryType) GetPlatform() string {
	if x != nil {
		return x.Platform
	}
	return ""
}

func (x *EntryType) GetSystem() string {
	if x != nil {
		return x.System
	}
	return ""
}

func (x *EntryType) GetRequiredAspects() []*EntryType_AspectInfo {
	if x != nil {
		return x.RequiredAspects
	}
	return nil
}

func (x *EntryType) GetAuthorization() *EntryType_Authorization {
	if x != nil {
		return x.Authorization
	}
	return nil
}

// An aspect is a single piece of metadata describing an entry.
type Aspect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the type used to create this Aspect.
	AspectType string `protobuf:"bytes,1,opt,name=aspect_type,json=aspectType,proto3" json:"aspect_type,omitempty"`
	// Output only. The path in the entry under which the aspect is attached.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	// Output only. The time when the Aspect was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the Aspect was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Required. The content of the aspect, according to its aspect type schema.
	// The maximum size of the field is 120KB (encoded as UTF-8).
	Data *structpb.Struct `protobuf:"bytes,8,opt,name=data,proto3" json:"data,omitempty"`
	// Optional. Information related to the source system of the aspect.
	AspectSource *AspectSource `protobuf:"bytes,9,opt,name=aspect_source,json=aspectSource,proto3" json:"aspect_source,omitempty"`
}

func (x *Aspect) Reset() {
	*x = Aspect{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Aspect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Aspect) ProtoMessage() {}

func (x *Aspect) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Aspect.ProtoReflect.Descriptor instead.
func (*Aspect) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{3}
}

func (x *Aspect) GetAspectType() string {
	if x != nil {
		return x.AspectType
	}
	return ""
}

func (x *Aspect) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *Aspect) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Aspect) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Aspect) GetData() *structpb.Struct {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *Aspect) GetAspectSource() *AspectSource {
	if x != nil {
		return x.AspectSource
	}
	return nil
}

// Information related to the source system of the aspect.
type AspectSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time the aspect was created in the source system.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The time the aspect was last updated in the source system.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The version of the data format used to produce this data. This field is
	// used to indicated when the underlying data format changes (e.g., schema
	// modifications, changes to the source URL format definition, etc).
	DataVersion string `protobuf:"bytes,12,opt,name=data_version,json=dataVersion,proto3" json:"data_version,omitempty"`
}

func (x *AspectSource) Reset() {
	*x = AspectSource{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AspectSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AspectSource) ProtoMessage() {}

func (x *AspectSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AspectSource.ProtoReflect.Descriptor instead.
func (*AspectSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{4}
}

func (x *AspectSource) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *AspectSource) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *AspectSource) GetDataVersion() string {
	if x != nil {
		return x.DataVersion
	}
	return ""
}

// An entry is a representation of a data resource that can be described by
// various metadata.
type Entry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The relative resource name of the entry, in the format
	// `projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}/entries/{entry_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. The relative resource name of the entry type that was
	// used to create this entry, in the format
	// `projects/{project_id_or_number}/locations/{location_id}/entryTypes/{entry_type_id}`.
	EntryType string `protobuf:"bytes,4,opt,name=entry_type,json=entryType,proto3" json:"entry_type,omitempty"`
	// Output only. The time when the entry was created in Dataplex Universal
	// Catalog.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the entry was last updated in Dataplex Universal
	// Catalog.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. The aspects that are attached to the entry. Depending on how the
	// aspect is attached to the entry, the format of the aspect key can be one of
	// the following:
	//
	// * If the aspect is attached directly to the entry:
	// `{project_id_or_number}.{location_id}.{aspect_type_id}`
	// * If the aspect is attached to an entry's path:
	// `{project_id_or_number}.{location_id}.{aspect_type_id}@{path}`
	Aspects map[string]*Aspect `protobuf:"bytes,9,rep,name=aspects,proto3" json:"aspects,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Immutable. The resource name of the parent entry, in the format
	// `projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}/entries/{entry_id}`.
	ParentEntry string `protobuf:"bytes,10,opt,name=parent_entry,json=parentEntry,proto3" json:"parent_entry,omitempty"`
	// Optional. A name for the entry that can be referenced by an external
	// system. For more information, see [Fully qualified
	// names](https://cloud.google.com/data-catalog/docs/fully-qualified-names).
	// The maximum size of the field is 4000 characters.
	FullyQualifiedName string `protobuf:"bytes,12,opt,name=fully_qualified_name,json=fullyQualifiedName,proto3" json:"fully_qualified_name,omitempty"`
	// Optional. Information related to the source system of the data resource
	// that is represented by the entry.
	EntrySource *EntrySource `protobuf:"bytes,15,opt,name=entry_source,json=entrySource,proto3" json:"entry_source,omitempty"`
}

func (x *Entry) Reset() {
	*x = Entry{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Entry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Entry) ProtoMessage() {}

func (x *Entry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Entry.ProtoReflect.Descriptor instead.
func (*Entry) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{5}
}

func (x *Entry) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Entry) GetEntryType() string {
	if x != nil {
		return x.EntryType
	}
	return ""
}

func (x *Entry) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Entry) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Entry) GetAspects() map[string]*Aspect {
	if x != nil {
		return x.Aspects
	}
	return nil
}

func (x *Entry) GetParentEntry() string {
	if x != nil {
		return x.ParentEntry
	}
	return ""
}

func (x *Entry) GetFullyQualifiedName() string {
	if x != nil {
		return x.FullyQualifiedName
	}
	return ""
}

func (x *Entry) GetEntrySource() *EntrySource {
	if x != nil {
		return x.EntrySource
	}
	return nil
}

// Information related to the source system of the data resource that is
// represented by the entry.
type EntrySource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the resource in the source system.
	// Maximum length is 4,000 characters.
	Resource string `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	// The name of the source system.
	// Maximum length is 64 characters.
	System string `protobuf:"bytes,2,opt,name=system,proto3" json:"system,omitempty"`
	// The platform containing the source system.
	// Maximum length is 64 characters.
	Platform string `protobuf:"bytes,3,opt,name=platform,proto3" json:"platform,omitempty"`
	// A user-friendly display name.
	// Maximum length is 500 characters.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// A description of the data resource.
	// Maximum length is 2,000 characters.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// User-defined labels.
	// The maximum size of keys and values is 128 characters each.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Immutable. The entries representing the ancestors of the data resource in
	// the source system.
	Ancestors []*EntrySource_Ancestor `protobuf:"bytes,9,rep,name=ancestors,proto3" json:"ancestors,omitempty"`
	// The time when the resource was created in the source system.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The time when the resource was last updated in the source system. If the
	// entry exists in the system and its `EntrySource` has `update_time`
	// populated, further updates to the `EntrySource` of the entry must provide
	// incremental updates to its `update_time`.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Location of the resource in the source system. You can search
	// the entry by this location. By default, this should match the location of
	// the entry group containing this entry. A different value allows capturing
	// the source location for data external to Google Cloud.
	Location string `protobuf:"bytes,12,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *EntrySource) Reset() {
	*x = EntrySource{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EntrySource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntrySource) ProtoMessage() {}

func (x *EntrySource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntrySource.ProtoReflect.Descriptor instead.
func (*EntrySource) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{6}
}

func (x *EntrySource) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

func (x *EntrySource) GetSystem() string {
	if x != nil {
		return x.System
	}
	return ""
}

func (x *EntrySource) GetPlatform() string {
	if x != nil {
		return x.Platform
	}
	return ""
}

func (x *EntrySource) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *EntrySource) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *EntrySource) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *EntrySource) GetAncestors() []*EntrySource_Ancestor {
	if x != nil {
		return x.Ancestors
	}
	return nil
}

func (x *EntrySource) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *EntrySource) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *EntrySource) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

// Create EntryGroup Request.
type CreateEntryGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the entryGroup, of the form:
	// projects/{project_number}/locations/{location_id}
	// where `location_id` refers to a Google Cloud region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. EntryGroup identifier.
	EntryGroupId string `protobuf:"bytes,2,opt,name=entry_group_id,json=entryGroupId,proto3" json:"entry_group_id,omitempty"`
	// Required. EntryGroup Resource.
	EntryGroup *EntryGroup `protobuf:"bytes,3,opt,name=entry_group,json=entryGroup,proto3" json:"entry_group,omitempty"`
	// Optional. The service validates the request without performing any
	// mutations. The default is false.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateEntryGroupRequest) Reset() {
	*x = CreateEntryGroupRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateEntryGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEntryGroupRequest) ProtoMessage() {}

func (x *CreateEntryGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEntryGroupRequest.ProtoReflect.Descriptor instead.
func (*CreateEntryGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{7}
}

func (x *CreateEntryGroupRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateEntryGroupRequest) GetEntryGroupId() string {
	if x != nil {
		return x.EntryGroupId
	}
	return ""
}

func (x *CreateEntryGroupRequest) GetEntryGroup() *EntryGroup {
	if x != nil {
		return x.EntryGroup
	}
	return nil
}

func (x *CreateEntryGroupRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Update EntryGroup Request.
type UpdateEntryGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. EntryGroup Resource.
	EntryGroup *EntryGroup `protobuf:"bytes,1,opt,name=entry_group,json=entryGroup,proto3" json:"entry_group,omitempty"`
	// Required. Mask of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. The service validates the request, without performing any
	// mutations. The default is false.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdateEntryGroupRequest) Reset() {
	*x = UpdateEntryGroupRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateEntryGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEntryGroupRequest) ProtoMessage() {}

func (x *UpdateEntryGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEntryGroupRequest.ProtoReflect.Descriptor instead.
func (*UpdateEntryGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{8}
}

func (x *UpdateEntryGroupRequest) GetEntryGroup() *EntryGroup {
	if x != nil {
		return x.EntryGroup
	}
	return nil
}

func (x *UpdateEntryGroupRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateEntryGroupRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Delete EntryGroup Request.
type DeleteEntryGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the EntryGroup:
	// `projects/{project_number}/locations/{location_id}/entryGroups/{entry_group_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If the client provided etag value does not match the current etag
	// value, the DeleteEntryGroupRequest method returns an ABORTED error
	// response.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteEntryGroupRequest) Reset() {
	*x = DeleteEntryGroupRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteEntryGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteEntryGroupRequest) ProtoMessage() {}

func (x *DeleteEntryGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteEntryGroupRequest.ProtoReflect.Descriptor instead.
func (*DeleteEntryGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{9}
}

func (x *DeleteEntryGroupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteEntryGroupRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// List entryGroups request.
type ListEntryGroupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the entryGroup location, of the form:
	// `projects/{project_number}/locations/{location_id}`
	// where `location_id` refers to a Google Cloud region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of EntryGroups to return. The service may return
	// fewer than this value. If unspecified, the service returns at most 10
	// EntryGroups. The maximum value is 1000; values above 1000 will be coerced
	// to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token received from a previous `ListEntryGroups` call.
	// Provide this to retrieve the subsequent page. When paginating, all other
	// parameters you provide to `ListEntryGroups` must match the call that
	// provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter request.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Order by fields for the result.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListEntryGroupsRequest) Reset() {
	*x = ListEntryGroupsRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListEntryGroupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntryGroupsRequest) ProtoMessage() {}

func (x *ListEntryGroupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntryGroupsRequest.ProtoReflect.Descriptor instead.
func (*ListEntryGroupsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{10}
}

func (x *ListEntryGroupsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEntryGroupsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEntryGroupsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListEntryGroupsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListEntryGroupsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// List entry groups response.
type ListEntryGroupsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Entry groups under the given parent location.
	EntryGroups []*EntryGroup `protobuf:"bytes,1,rep,name=entry_groups,json=entryGroups,proto3" json:"entry_groups,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that the service couldn't reach.
	UnreachableLocations []string `protobuf:"bytes,3,rep,name=unreachable_locations,json=unreachableLocations,proto3" json:"unreachable_locations,omitempty"`
}

func (x *ListEntryGroupsResponse) Reset() {
	*x = ListEntryGroupsResponse{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListEntryGroupsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntryGroupsResponse) ProtoMessage() {}

func (x *ListEntryGroupsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntryGroupsResponse.ProtoReflect.Descriptor instead.
func (*ListEntryGroupsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{11}
}

func (x *ListEntryGroupsResponse) GetEntryGroups() []*EntryGroup {
	if x != nil {
		return x.EntryGroups
	}
	return nil
}

func (x *ListEntryGroupsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListEntryGroupsResponse) GetUnreachableLocations() []string {
	if x != nil {
		return x.UnreachableLocations
	}
	return nil
}

// Get EntryGroup request.
type GetEntryGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the EntryGroup:
	// `projects/{project_number}/locations/{location_id}/entryGroups/{entry_group_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEntryGroupRequest) Reset() {
	*x = GetEntryGroupRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetEntryGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEntryGroupRequest) ProtoMessage() {}

func (x *GetEntryGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEntryGroupRequest.ProtoReflect.Descriptor instead.
func (*GetEntryGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{12}
}

func (x *GetEntryGroupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Create EntryType Request.
type CreateEntryTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the EntryType, of the form:
	// projects/{project_number}/locations/{location_id}
	// where `location_id` refers to a Google Cloud region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. EntryType identifier.
	EntryTypeId string `protobuf:"bytes,2,opt,name=entry_type_id,json=entryTypeId,proto3" json:"entry_type_id,omitempty"`
	// Required. EntryType Resource.
	EntryType *EntryType `protobuf:"bytes,3,opt,name=entry_type,json=entryType,proto3" json:"entry_type,omitempty"`
	// Optional. The service validates the request without performing any
	// mutations. The default is false.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateEntryTypeRequest) Reset() {
	*x = CreateEntryTypeRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateEntryTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEntryTypeRequest) ProtoMessage() {}

func (x *CreateEntryTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEntryTypeRequest.ProtoReflect.Descriptor instead.
func (*CreateEntryTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{13}
}

func (x *CreateEntryTypeRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateEntryTypeRequest) GetEntryTypeId() string {
	if x != nil {
		return x.EntryTypeId
	}
	return ""
}

func (x *CreateEntryTypeRequest) GetEntryType() *EntryType {
	if x != nil {
		return x.EntryType
	}
	return nil
}

func (x *CreateEntryTypeRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Update EntryType Request.
type UpdateEntryTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. EntryType Resource.
	EntryType *EntryType `protobuf:"bytes,1,opt,name=entry_type,json=entryType,proto3" json:"entry_type,omitempty"`
	// Required. Mask of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. The service validates the request without performing any
	// mutations. The default is false.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdateEntryTypeRequest) Reset() {
	*x = UpdateEntryTypeRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateEntryTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEntryTypeRequest) ProtoMessage() {}

func (x *UpdateEntryTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEntryTypeRequest.ProtoReflect.Descriptor instead.
func (*UpdateEntryTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{14}
}

func (x *UpdateEntryTypeRequest) GetEntryType() *EntryType {
	if x != nil {
		return x.EntryType
	}
	return nil
}

func (x *UpdateEntryTypeRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateEntryTypeRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Delete EntryType Request.
type DeleteEntryTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the EntryType:
	// `projects/{project_number}/locations/{location_id}/entryTypes/{entry_type_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If the client provided etag value does not match the current etag
	// value, the DeleteEntryTypeRequest method returns an ABORTED error response.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteEntryTypeRequest) Reset() {
	*x = DeleteEntryTypeRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteEntryTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteEntryTypeRequest) ProtoMessage() {}

func (x *DeleteEntryTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteEntryTypeRequest.ProtoReflect.Descriptor instead.
func (*DeleteEntryTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{15}
}

func (x *DeleteEntryTypeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteEntryTypeRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// List EntryTypes request
type ListEntryTypesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the EntryType location, of the form:
	// `projects/{project_number}/locations/{location_id}`
	// where `location_id` refers to a Google Cloud region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of EntryTypes to return. The service may return
	// fewer than this value. If unspecified, the service returns at most 10
	// EntryTypes. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token received from a previous `ListEntryTypes` call.
	// Provide this to retrieve the subsequent page. When paginating, all other
	// parameters you provided to `ListEntryTypes` must match the call that
	// provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter request. Filters are case-sensitive.
	// The service supports the following formats:
	//
	// * labels.key1 = "value1"
	// * labels:key1
	// * name = "value"
	//
	// These restrictions can be conjoined with AND, OR, and NOT conjunctions.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Orders the result by `name` or `create_time` fields.
	// If not specified, the ordering is undefined.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListEntryTypesRequest) Reset() {
	*x = ListEntryTypesRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListEntryTypesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntryTypesRequest) ProtoMessage() {}

func (x *ListEntryTypesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntryTypesRequest.ProtoReflect.Descriptor instead.
func (*ListEntryTypesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{16}
}

func (x *ListEntryTypesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEntryTypesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEntryTypesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListEntryTypesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListEntryTypesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// List EntryTypes response.
type ListEntryTypesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// EntryTypes under the given parent location.
	EntryTypes []*EntryType `protobuf:"bytes,1,rep,name=entry_types,json=entryTypes,proto3" json:"entry_types,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that the service couldn't reach.
	UnreachableLocations []string `protobuf:"bytes,3,rep,name=unreachable_locations,json=unreachableLocations,proto3" json:"unreachable_locations,omitempty"`
}

func (x *ListEntryTypesResponse) Reset() {
	*x = ListEntryTypesResponse{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListEntryTypesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntryTypesResponse) ProtoMessage() {}

func (x *ListEntryTypesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntryTypesResponse.ProtoReflect.Descriptor instead.
func (*ListEntryTypesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{17}
}

func (x *ListEntryTypesResponse) GetEntryTypes() []*EntryType {
	if x != nil {
		return x.EntryTypes
	}
	return nil
}

func (x *ListEntryTypesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListEntryTypesResponse) GetUnreachableLocations() []string {
	if x != nil {
		return x.UnreachableLocations
	}
	return nil
}

// Get EntryType request.
type GetEntryTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the EntryType:
	// `projects/{project_number}/locations/{location_id}/entryTypes/{entry_type_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEntryTypeRequest) Reset() {
	*x = GetEntryTypeRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetEntryTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEntryTypeRequest) ProtoMessage() {}

func (x *GetEntryTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEntryTypeRequest.ProtoReflect.Descriptor instead.
func (*GetEntryTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{18}
}

func (x *GetEntryTypeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Create AspectType Request.
type CreateAspectTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the AspectType, of the form:
	// projects/{project_number}/locations/{location_id}
	// where `location_id` refers to a Google Cloud region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. AspectType identifier.
	AspectTypeId string `protobuf:"bytes,2,opt,name=aspect_type_id,json=aspectTypeId,proto3" json:"aspect_type_id,omitempty"`
	// Required. AspectType Resource.
	AspectType *AspectType `protobuf:"bytes,3,opt,name=aspect_type,json=aspectType,proto3" json:"aspect_type,omitempty"`
	// Optional. The service validates the request without performing any
	// mutations. The default is false.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateAspectTypeRequest) Reset() {
	*x = CreateAspectTypeRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateAspectTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateAspectTypeRequest) ProtoMessage() {}

func (x *CreateAspectTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateAspectTypeRequest.ProtoReflect.Descriptor instead.
func (*CreateAspectTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{19}
}

func (x *CreateAspectTypeRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateAspectTypeRequest) GetAspectTypeId() string {
	if x != nil {
		return x.AspectTypeId
	}
	return ""
}

func (x *CreateAspectTypeRequest) GetAspectType() *AspectType {
	if x != nil {
		return x.AspectType
	}
	return nil
}

func (x *CreateAspectTypeRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Update AspectType Request
type UpdateAspectTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. AspectType Resource
	AspectType *AspectType `protobuf:"bytes,1,opt,name=aspect_type,json=aspectType,proto3" json:"aspect_type,omitempty"`
	// Required. Mask of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. Only validate the request, but do not perform mutations.
	// The default is false.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdateAspectTypeRequest) Reset() {
	*x = UpdateAspectTypeRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateAspectTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAspectTypeRequest) ProtoMessage() {}

func (x *UpdateAspectTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAspectTypeRequest.ProtoReflect.Descriptor instead.
func (*UpdateAspectTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{20}
}

func (x *UpdateAspectTypeRequest) GetAspectType() *AspectType {
	if x != nil {
		return x.AspectType
	}
	return nil
}

func (x *UpdateAspectTypeRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateAspectTypeRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Delete AspectType Request.
type DeleteAspectTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the AspectType:
	// `projects/{project_number}/locations/{location_id}/aspectTypes/{aspect_type_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If the client provided etag value does not match the current etag
	// value, the DeleteAspectTypeRequest method returns an ABORTED error
	// response.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteAspectTypeRequest) Reset() {
	*x = DeleteAspectTypeRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteAspectTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteAspectTypeRequest) ProtoMessage() {}

func (x *DeleteAspectTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteAspectTypeRequest.ProtoReflect.Descriptor instead.
func (*DeleteAspectTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{21}
}

func (x *DeleteAspectTypeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteAspectTypeRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// List AspectTypes request.
type ListAspectTypesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the AspectType location, of the form:
	// `projects/{project_number}/locations/{location_id}`
	// where `location_id` refers to a Google Cloud region.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of AspectTypes to return. The service may return
	// fewer than this value. If unspecified, the service returns at most 10
	// AspectTypes. The maximum value is 1000; values above 1000 will be coerced
	// to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token received from a previous `ListAspectTypes` call.
	// Provide this to retrieve the subsequent page. When paginating, all other
	// parameters you provide to `ListAspectTypes` must match the call that
	// provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter request. Filters are case-sensitive.
	// The service supports the following formats:
	//
	// * labels.key1 = "value1"
	// * labels:key1
	// * name = "value"
	//
	// These restrictions can be conjoined with AND, OR, and NOT conjunctions.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Orders the result by `name` or `create_time` fields.
	// If not specified, the ordering is undefined.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListAspectTypesRequest) Reset() {
	*x = ListAspectTypesRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAspectTypesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAspectTypesRequest) ProtoMessage() {}

func (x *ListAspectTypesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAspectTypesRequest.ProtoReflect.Descriptor instead.
func (*ListAspectTypesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{22}
}

func (x *ListAspectTypesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAspectTypesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAspectTypesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAspectTypesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListAspectTypesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// List AspectTypes response.
type ListAspectTypesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// AspectTypes under the given parent location.
	AspectTypes []*AspectType `protobuf:"bytes,1,rep,name=aspect_types,json=aspectTypes,proto3" json:"aspect_types,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that the service couldn't reach.
	UnreachableLocations []string `protobuf:"bytes,3,rep,name=unreachable_locations,json=unreachableLocations,proto3" json:"unreachable_locations,omitempty"`
}

func (x *ListAspectTypesResponse) Reset() {
	*x = ListAspectTypesResponse{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAspectTypesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAspectTypesResponse) ProtoMessage() {}

func (x *ListAspectTypesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAspectTypesResponse.ProtoReflect.Descriptor instead.
func (*ListAspectTypesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{23}
}

func (x *ListAspectTypesResponse) GetAspectTypes() []*AspectType {
	if x != nil {
		return x.AspectTypes
	}
	return nil
}

func (x *ListAspectTypesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListAspectTypesResponse) GetUnreachableLocations() []string {
	if x != nil {
		return x.UnreachableLocations
	}
	return nil
}

// Get AspectType request.
type GetAspectTypeRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the AspectType:
	// `projects/{project_number}/locations/{location_id}/aspectTypes/{aspect_type_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAspectTypeRequest) Reset() {
	*x = GetAspectTypeRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetAspectTypeRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAspectTypeRequest) ProtoMessage() {}

func (x *GetAspectTypeRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAspectTypeRequest.ProtoReflect.Descriptor instead.
func (*GetAspectTypeRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{24}
}

func (x *GetAspectTypeRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Create Entry request.
type CreateEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent Entry Group:
	// `projects/{project}/locations/{location}/entryGroups/{entry_group}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Entry identifier. It has to be unique within an Entry Group.
	//
	// Entries corresponding to Google Cloud resources use an Entry ID format
	// based on [full resource
	// names](https://cloud.google.com/apis/design/resource_names#full_resource_name).
	// The format is a full resource name of the resource without the
	// prefix double slashes in the API service name part of the full resource
	// name. This allows retrieval of entries using their associated resource
	// name.
	//
	// For example, if the full resource name of a resource is
	// `//library.googleapis.com/shelves/shelf1/books/book2`,
	// then the suggested entry_id is
	// `library.googleapis.com/shelves/shelf1/books/book2`.
	//
	// It is also suggested to follow the same convention for entries
	// corresponding to resources from providers or systems other than Google
	// Cloud.
	//
	// The maximum size of the field is 4000 characters.
	EntryId string `protobuf:"bytes,2,opt,name=entry_id,json=entryId,proto3" json:"entry_id,omitempty"`
	// Required. Entry resource.
	Entry *Entry `protobuf:"bytes,3,opt,name=entry,proto3" json:"entry,omitempty"`
}

func (x *CreateEntryRequest) Reset() {
	*x = CreateEntryRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEntryRequest) ProtoMessage() {}

func (x *CreateEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEntryRequest.ProtoReflect.Descriptor instead.
func (*CreateEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{25}
}

func (x *CreateEntryRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateEntryRequest) GetEntryId() string {
	if x != nil {
		return x.EntryId
	}
	return ""
}

func (x *CreateEntryRequest) GetEntry() *Entry {
	if x != nil {
		return x.Entry
	}
	return nil
}

// Update Entry request.
type UpdateEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Entry resource.
	Entry *Entry `protobuf:"bytes,1,opt,name=entry,proto3" json:"entry,omitempty"`
	// Optional. Mask of fields to update. To update Aspects, the update_mask must
	// contain the value "aspects".
	//
	// If the update_mask is empty, the service will update all modifiable fields
	// present in the request.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. If set to true and the entry doesn't exist, the service will
	// create it.
	AllowMissing bool `protobuf:"varint,3,opt,name=allow_missing,json=allowMissing,proto3" json:"allow_missing,omitempty"`
	// Optional. If set to true and the aspect_keys specify aspect ranges, the
	// service deletes any existing aspects from that range that weren't provided
	// in the request.
	DeleteMissingAspects bool `protobuf:"varint,4,opt,name=delete_missing_aspects,json=deleteMissingAspects,proto3" json:"delete_missing_aspects,omitempty"`
	// Optional. The map keys of the Aspects which the service should modify. It
	// supports the following syntaxes:
	//
	// * `<aspect_type_reference>` - matches an aspect of the given type and empty
	// path.
	// * `<aspect_type_reference>@path` - matches an aspect of the given type and
	// specified path. For example, to attach an aspect to a field that is
	// specified by the `schema` aspect, the path should have the format
	// `Schema.<field_name>`.
	// * `<aspect_type_reference>@*` - matches aspects of the given type for all
	// paths.
	// * `*@path` - matches aspects of all types on the given path.
	//
	// The service will not remove existing aspects matching the syntax unless
	// `delete_missing_aspects` is set to true.
	//
	// If this field is left empty, the service treats it as specifying
	// exactly those Aspects present in the request.
	AspectKeys []string `protobuf:"bytes,5,rep,name=aspect_keys,json=aspectKeys,proto3" json:"aspect_keys,omitempty"`
}

func (x *UpdateEntryRequest) Reset() {
	*x = UpdateEntryRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEntryRequest) ProtoMessage() {}

func (x *UpdateEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEntryRequest.ProtoReflect.Descriptor instead.
func (*UpdateEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{26}
}

func (x *UpdateEntryRequest) GetEntry() *Entry {
	if x != nil {
		return x.Entry
	}
	return nil
}

func (x *UpdateEntryRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateEntryRequest) GetAllowMissing() bool {
	if x != nil {
		return x.AllowMissing
	}
	return false
}

func (x *UpdateEntryRequest) GetDeleteMissingAspects() bool {
	if x != nil {
		return x.DeleteMissingAspects
	}
	return false
}

func (x *UpdateEntryRequest) GetAspectKeys() []string {
	if x != nil {
		return x.AspectKeys
	}
	return nil
}

// Delete Entry request.
type DeleteEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Entry:
	// `projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteEntryRequest) Reset() {
	*x = DeleteEntryRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteEntryRequest) ProtoMessage() {}

func (x *DeleteEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteEntryRequest.ProtoReflect.Descriptor instead.
func (*DeleteEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{27}
}

func (x *DeleteEntryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// List Entries request.
type ListEntriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent Entry Group:
	// `projects/{project}/locations/{location}/entryGroups/{entry_group}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Number of items to return per page. If there are remaining
	// results, the service returns a next_page_token. If unspecified, the service
	// returns at most 10 Entries. The maximum value is 100; values above 100 will
	// be coerced to 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token received from a previous `ListEntries` call. Provide
	// this to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A filter on the entries to return. Filters are case-sensitive.
	// You can filter the request by the following fields:
	//
	// * entry_type
	// * entry_source.display_name
	// * parent_entry
	//
	// The comparison operators are =, !=, <, >, <=, >=. The service compares
	// strings according to lexical order.
	//
	// You can use the logical operators AND, OR, NOT in the filter.
	//
	// You can use Wildcard "*", but for entry_type and parent_entry you need to
	// provide the full project id or number.
	//
	// You cannot use parent_entry in conjunction with other fields.
	//
	// Example filter expressions:
	//
	// * "entry_source.display_name=AnExampleDisplayName"
	// * "entry_type=projects/example-project/locations/global/entryTypes/example-entry_type"
	// * "entry_type=projects/example-project/locations/us/entryTypes/a* OR
	// entry_type=projects/another-project/locations/*"
	// * "NOT entry_source.display_name=AnotherExampleDisplayName"
	// * "parent_entry=projects/example-project/locations/us/entryGroups/example-entry-group/entries/example-entry"
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListEntriesRequest) Reset() {
	*x = ListEntriesRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListEntriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntriesRequest) ProtoMessage() {}

func (x *ListEntriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntriesRequest.ProtoReflect.Descriptor instead.
func (*ListEntriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{28}
}

func (x *ListEntriesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEntriesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEntriesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListEntriesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// List Entries response.
type ListEntriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of entries under the given parent location.
	Entries []*Entry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListEntriesResponse) Reset() {
	*x = ListEntriesResponse{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListEntriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntriesResponse) ProtoMessage() {}

func (x *ListEntriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntriesResponse.ProtoReflect.Descriptor instead.
func (*ListEntriesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{29}
}

func (x *ListEntriesResponse) GetEntries() []*Entry {
	if x != nil {
		return x.Entries
	}
	return nil
}

func (x *ListEntriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Get Entry request.
type GetEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Entry:
	// `projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. View to control which parts of an entry the service should
	// return.
	View EntryView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.dataplex.v1.EntryView" json:"view,omitempty"`
	// Optional. Limits the aspects returned to the provided aspect types.
	// It only works for CUSTOM view.
	AspectTypes []string `protobuf:"bytes,3,rep,name=aspect_types,json=aspectTypes,proto3" json:"aspect_types,omitempty"`
	// Optional. Limits the aspects returned to those associated with the provided
	// paths within the Entry. It only works for CUSTOM view.
	Paths []string `protobuf:"bytes,4,rep,name=paths,proto3" json:"paths,omitempty"`
}

func (x *GetEntryRequest) Reset() {
	*x = GetEntryRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEntryRequest) ProtoMessage() {}

func (x *GetEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEntryRequest.ProtoReflect.Descriptor instead.
func (*GetEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{30}
}

func (x *GetEntryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetEntryRequest) GetView() EntryView {
	if x != nil {
		return x.View
	}
	return EntryView_ENTRY_VIEW_UNSPECIFIED
}

func (x *GetEntryRequest) GetAspectTypes() []string {
	if x != nil {
		return x.AspectTypes
	}
	return nil
}

func (x *GetEntryRequest) GetPaths() []string {
	if x != nil {
		return x.Paths
	}
	return nil
}

// Lookup Entry request using permissions in the source system.
type LookupEntryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project to which the request should be attributed in the
	// following form: `projects/{project}/locations/{location}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. View to control which parts of an entry the service should
	// return.
	View EntryView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.dataplex.v1.EntryView" json:"view,omitempty"`
	// Optional. Limits the aspects returned to the provided aspect types.
	// It only works for CUSTOM view.
	AspectTypes []string `protobuf:"bytes,3,rep,name=aspect_types,json=aspectTypes,proto3" json:"aspect_types,omitempty"`
	// Optional. Limits the aspects returned to those associated with the provided
	// paths within the Entry. It only works for CUSTOM view.
	Paths []string `protobuf:"bytes,4,rep,name=paths,proto3" json:"paths,omitempty"`
	// Required. The resource name of the Entry:
	// `projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}`.
	Entry string `protobuf:"bytes,5,opt,name=entry,proto3" json:"entry,omitempty"`
}

func (x *LookupEntryRequest) Reset() {
	*x = LookupEntryRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LookupEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LookupEntryRequest) ProtoMessage() {}

func (x *LookupEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LookupEntryRequest.ProtoReflect.Descriptor instead.
func (*LookupEntryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{31}
}

func (x *LookupEntryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LookupEntryRequest) GetView() EntryView {
	if x != nil {
		return x.View
	}
	return EntryView_ENTRY_VIEW_UNSPECIFIED
}

func (x *LookupEntryRequest) GetAspectTypes() []string {
	if x != nil {
		return x.AspectTypes
	}
	return nil
}

func (x *LookupEntryRequest) GetPaths() []string {
	if x != nil {
		return x.Paths
	}
	return nil
}

func (x *LookupEntryRequest) GetEntry() string {
	if x != nil {
		return x.Entry
	}
	return ""
}

type SearchEntriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project to which the request should be attributed in the
	// following form: `projects/{project}/locations/global`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The query against which entries in scope should be matched.
	// The query syntax is defined in [Search syntax for Dataplex Universal
	// Catalog](https://cloud.google.com/dataplex/docs/search-syntax).
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Optional. Number of results in the search page. If <=0, then defaults
	// to 10. Max limit for page_size is 1000. Throws an invalid argument for
	// page_size > 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Page token received from a previous `SearchEntries` call. Provide
	// this to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Specifies the ordering of results.
	// Supported values are:
	//
	// * `relevance`
	// * `last_modified_timestamp`
	// * `last_modified_timestamp asc`
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Optional. The scope under which the search should be operating. It must
	// either be `organizations/<org_id>` or `projects/<project_ref>`. If it is
	// unspecified, it defaults to the organization where the project provided in
	// `name` is located.
	Scope string `protobuf:"bytes,7,opt,name=scope,proto3" json:"scope,omitempty"`
	// Optional. Specifies whether the search should understand the meaning and
	// intent behind the query, rather than just matching keywords.
	SemanticSearch bool `protobuf:"varint,11,opt,name=semantic_search,json=semanticSearch,proto3" json:"semantic_search,omitempty"`
}

func (x *SearchEntriesRequest) Reset() {
	*x = SearchEntriesRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchEntriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchEntriesRequest) ProtoMessage() {}

func (x *SearchEntriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchEntriesRequest.ProtoReflect.Descriptor instead.
func (*SearchEntriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{32}
}

func (x *SearchEntriesRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SearchEntriesRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchEntriesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchEntriesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchEntriesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *SearchEntriesRequest) GetScope() string {
	if x != nil {
		return x.Scope
	}
	return ""
}

func (x *SearchEntriesRequest) GetSemanticSearch() bool {
	if x != nil {
		return x.SemanticSearch
	}
	return false
}

// A single result of a SearchEntries request.
type SearchEntriesResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Linked resource name.
	//
	// Deprecated: Marked as deprecated in google/cloud/dataplex/v1/catalog.proto.
	LinkedResource string `protobuf:"bytes,8,opt,name=linked_resource,json=linkedResource,proto3" json:"linked_resource,omitempty"`
	DataplexEntry  *Entry `protobuf:"bytes,9,opt,name=dataplex_entry,json=dataplexEntry,proto3" json:"dataplex_entry,omitempty"`
	// Snippets.
	//
	// Deprecated: Marked as deprecated in google/cloud/dataplex/v1/catalog.proto.
	Snippets *SearchEntriesResult_Snippets `protobuf:"bytes,12,opt,name=snippets,proto3" json:"snippets,omitempty"`
}

func (x *SearchEntriesResult) Reset() {
	*x = SearchEntriesResult{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchEntriesResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchEntriesResult) ProtoMessage() {}

func (x *SearchEntriesResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchEntriesResult.ProtoReflect.Descriptor instead.
func (*SearchEntriesResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{33}
}

// Deprecated: Marked as deprecated in google/cloud/dataplex/v1/catalog.proto.
func (x *SearchEntriesResult) GetLinkedResource() string {
	if x != nil {
		return x.LinkedResource
	}
	return ""
}

func (x *SearchEntriesResult) GetDataplexEntry() *Entry {
	if x != nil {
		return x.DataplexEntry
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/dataplex/v1/catalog.proto.
func (x *SearchEntriesResult) GetSnippets() *SearchEntriesResult_Snippets {
	if x != nil {
		return x.Snippets
	}
	return nil
}

type SearchEntriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The results matching the search query.
	Results []*SearchEntriesResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// The estimated total number of matching entries. This number isn't
	// guaranteed to be accurate.
	TotalSize int32 `protobuf:"varint,2,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that the service couldn't reach. Search results don't include
	// data from these locations.
	Unreachable []string `protobuf:"bytes,4,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *SearchEntriesResponse) Reset() {
	*x = SearchEntriesResponse{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchEntriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchEntriesResponse) ProtoMessage() {}

func (x *SearchEntriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchEntriesResponse.ProtoReflect.Descriptor instead.
func (*SearchEntriesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{34}
}

func (x *SearchEntriesResponse) GetResults() []*SearchEntriesResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *SearchEntriesResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

func (x *SearchEntriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *SearchEntriesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// An object that describes the values that you want to set for an entry and its
// attached aspects when you import metadata. Used when you run a metadata
// import job. See
// [CreateMetadataJob][google.cloud.dataplex.v1.CatalogService.CreateMetadataJob].
//
// You provide a collection of import items in a metadata import file. For more
// information about how to create a metadata import file, see [Metadata import
// file](https://cloud.google.com/dataplex/docs/import-metadata#metadata-import-file).
type ImportItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Information about an entry and its attached aspects.
	Entry *Entry `protobuf:"bytes,1,opt,name=entry,proto3" json:"entry,omitempty"`
	// Information about the entry link. User should provide either one of the
	// entry or entry_link. While providing entry_link, user should not
	// provide update_mask and aspect_keys.
	EntryLink *EntryLink `protobuf:"bytes,4,opt,name=entry_link,json=entryLink,proto3" json:"entry_link,omitempty"`
	// The fields to update, in paths that are relative to the `Entry` resource.
	// Separate each field with a comma.
	//
	// In `FULL` entry sync mode, Dataplex Universal Catalog includes the paths of
	// all of the fields for an entry that can be modified, including aspects.
	// This means that Dataplex Universal Catalog replaces the existing entry with
	// the entry in the metadata import file. All modifiable fields are updated,
	// regardless of the fields that are listed in the update mask, and regardless
	// of whether a field is present in the `entry` object.
	//
	// The `update_mask` field is ignored when an entry is created or re-created.
	//
	// In an aspect-only metadata job (when entry sync mode is `NONE`), set this
	// value to `aspects`.
	//
	// Dataplex Universal Catalog also determines which entries and aspects to
	// modify by comparing the values and timestamps that you provide in the
	// metadata import file with the values and timestamps that exist in your
	// project. For more information, see [Comparison
	// logic](https://cloud.google.com/dataplex/docs/import-metadata#data-modification-logic).
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The aspects to modify. Supports the following syntaxes:
	//
	// * `{aspect_type_reference}`: matches aspects that belong to the specified
	// aspect type and are attached directly to the entry.
	// * `{aspect_type_reference}@{path}`: matches aspects that belong to the
	// specified aspect type and path.
	// * `{aspect_type_reference}@*` : matches aspects of the given type for all
	// paths.
	// * `*@path` : matches aspects of all types on the given path.
	//
	// Replace `{aspect_type_reference}` with a reference to the aspect type, in
	// the format
	// `{project_id_or_number}.{location_id}.{aspect_type_id}`.
	//
	// In `FULL` entry sync mode, if you leave this field empty, it is treated as
	// specifying exactly those aspects that are present within the specified
	// entry. Dataplex Universal Catalog implicitly adds the keys for all of the
	// required aspects of an entry.
	AspectKeys []string `protobuf:"bytes,3,rep,name=aspect_keys,json=aspectKeys,proto3" json:"aspect_keys,omitempty"`
}

func (x *ImportItem) Reset() {
	*x = ImportItem{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportItem) ProtoMessage() {}

func (x *ImportItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportItem.ProtoReflect.Descriptor instead.
func (*ImportItem) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{35}
}

func (x *ImportItem) GetEntry() *Entry {
	if x != nil {
		return x.Entry
	}
	return nil
}

func (x *ImportItem) GetEntryLink() *EntryLink {
	if x != nil {
		return x.EntryLink
	}
	return nil
}

func (x *ImportItem) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *ImportItem) GetAspectKeys() []string {
	if x != nil {
		return x.AspectKeys
	}
	return nil
}

// Create metadata job request.
type CreateMetadataJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent location, in the format
	// `projects/{project_id_or_number}/locations/{location_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The metadata job resource.
	MetadataJob *MetadataJob `protobuf:"bytes,2,opt,name=metadata_job,json=metadataJob,proto3" json:"metadata_job,omitempty"`
	// Optional. The metadata job ID. If not provided, a unique ID is generated
	// with the prefix `metadata-job-`.
	MetadataJobId string `protobuf:"bytes,3,opt,name=metadata_job_id,json=metadataJobId,proto3" json:"metadata_job_id,omitempty"`
	// Optional. The service validates the request without performing any
	// mutations. The default is false.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateMetadataJobRequest) Reset() {
	*x = CreateMetadataJobRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateMetadataJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMetadataJobRequest) ProtoMessage() {}

func (x *CreateMetadataJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMetadataJobRequest.ProtoReflect.Descriptor instead.
func (*CreateMetadataJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{36}
}

func (x *CreateMetadataJobRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateMetadataJobRequest) GetMetadataJob() *MetadataJob {
	if x != nil {
		return x.MetadataJob
	}
	return nil
}

func (x *CreateMetadataJobRequest) GetMetadataJobId() string {
	if x != nil {
		return x.MetadataJobId
	}
	return ""
}

func (x *CreateMetadataJobRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Get metadata job request.
type GetMetadataJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the metadata job, in the format
	// `projects/{project_id_or_number}/locations/{location_id}/metadataJobs/{metadata_job_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetMetadataJobRequest) Reset() {
	*x = GetMetadataJobRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMetadataJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMetadataJobRequest) ProtoMessage() {}

func (x *GetMetadataJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMetadataJobRequest.ProtoReflect.Descriptor instead.
func (*GetMetadataJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{37}
}

func (x *GetMetadataJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// List metadata jobs request.
type ListMetadataJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent location, in the format
	// `projects/{project_id_or_number}/locations/{location_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of metadata jobs to return. The service might
	// return fewer jobs than this value. If unspecified, at most 10 jobs are
	// returned. The maximum value is 1,000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The page token received from a previous `ListMetadataJobs` call.
	// Provide this token to retrieve the subsequent page of results. When
	// paginating, all other parameters that are provided to the
	// `ListMetadataJobs` request must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter request. Filters are case-sensitive.
	// The service supports the following formats:
	//
	// * `labels.key1 = "value1"`
	// * `labels:key1`
	// * `name = "value"`
	//
	// You can combine filters with `AND`, `OR`, and `NOT` operators.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The field to sort the results by, either `name` or `create_time`.
	// If not specified, the ordering is undefined.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListMetadataJobsRequest) Reset() {
	*x = ListMetadataJobsRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListMetadataJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMetadataJobsRequest) ProtoMessage() {}

func (x *ListMetadataJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMetadataJobsRequest.ProtoReflect.Descriptor instead.
func (*ListMetadataJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{38}
}

func (x *ListMetadataJobsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMetadataJobsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMetadataJobsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListMetadataJobsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListMetadataJobsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// List metadata jobs response.
type ListMetadataJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Metadata jobs under the specified parent location.
	MetadataJobs []*MetadataJob `protobuf:"bytes,1,rep,name=metadata_jobs,json=metadataJobs,proto3" json:"metadata_jobs,omitempty"`
	// A token to retrieve the next page of results. If there are no more results
	// in the list, the value is empty.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that the service couldn't reach.
	UnreachableLocations []string `protobuf:"bytes,3,rep,name=unreachable_locations,json=unreachableLocations,proto3" json:"unreachable_locations,omitempty"`
}

func (x *ListMetadataJobsResponse) Reset() {
	*x = ListMetadataJobsResponse{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListMetadataJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMetadataJobsResponse) ProtoMessage() {}

func (x *ListMetadataJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMetadataJobsResponse.ProtoReflect.Descriptor instead.
func (*ListMetadataJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{39}
}

func (x *ListMetadataJobsResponse) GetMetadataJobs() []*MetadataJob {
	if x != nil {
		return x.MetadataJobs
	}
	return nil
}

func (x *ListMetadataJobsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListMetadataJobsResponse) GetUnreachableLocations() []string {
	if x != nil {
		return x.UnreachableLocations
	}
	return nil
}

// Cancel metadata job request.
type CancelMetadataJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the job, in the format
	// `projects/{project_id_or_number}/locations/{location_id}/metadataJobs/{metadata_job_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CancelMetadataJobRequest) Reset() {
	*x = CancelMetadataJobRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CancelMetadataJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelMetadataJobRequest) ProtoMessage() {}

func (x *CancelMetadataJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelMetadataJobRequest.ProtoReflect.Descriptor instead.
func (*CancelMetadataJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{40}
}

func (x *CancelMetadataJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A metadata job resource.
type MetadataJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. The name of the resource that the configuration is
	// applied to, in the format
	// `projects/{project_number}/locations/{location_id}/metadataJobs/{metadata_job_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. A system-generated, globally unique ID for the metadata job.
	// If the metadata job is deleted and then re-created with the same name, this
	// ID is different.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The time when the metadata job was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the metadata job was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. User-defined labels.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. Metadata job type.
	Type MetadataJob_Type `protobuf:"varint,6,opt,name=type,proto3,enum=google.cloud.dataplex.v1.MetadataJob_Type" json:"type,omitempty"`
	// Types that are assignable to Spec:
	//
	//	*MetadataJob_ImportSpec
	//	*MetadataJob_ExportSpec
	Spec isMetadataJob_Spec `protobuf_oneof:"spec"`
	// Types that are assignable to Result:
	//
	//	*MetadataJob_ImportResult
	//	*MetadataJob_ExportResult
	Result isMetadataJob_Result `protobuf_oneof:"result"`
	// Output only. Metadata job status.
	Status *MetadataJob_Status `protobuf:"bytes,7,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *MetadataJob) Reset() {
	*x = MetadataJob{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetadataJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataJob) ProtoMessage() {}

func (x *MetadataJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataJob.ProtoReflect.Descriptor instead.
func (*MetadataJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{41}
}

func (x *MetadataJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MetadataJob) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *MetadataJob) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *MetadataJob) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *MetadataJob) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *MetadataJob) GetType() MetadataJob_Type {
	if x != nil {
		return x.Type
	}
	return MetadataJob_TYPE_UNSPECIFIED
}

func (m *MetadataJob) GetSpec() isMetadataJob_Spec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (x *MetadataJob) GetImportSpec() *MetadataJob_ImportJobSpec {
	if x, ok := x.GetSpec().(*MetadataJob_ImportSpec); ok {
		return x.ImportSpec
	}
	return nil
}

func (x *MetadataJob) GetExportSpec() *MetadataJob_ExportJobSpec {
	if x, ok := x.GetSpec().(*MetadataJob_ExportSpec); ok {
		return x.ExportSpec
	}
	return nil
}

func (m *MetadataJob) GetResult() isMetadataJob_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *MetadataJob) GetImportResult() *MetadataJob_ImportJobResult {
	if x, ok := x.GetResult().(*MetadataJob_ImportResult); ok {
		return x.ImportResult
	}
	return nil
}

func (x *MetadataJob) GetExportResult() *MetadataJob_ExportJobResult {
	if x, ok := x.GetResult().(*MetadataJob_ExportResult); ok {
		return x.ExportResult
	}
	return nil
}

func (x *MetadataJob) GetStatus() *MetadataJob_Status {
	if x != nil {
		return x.Status
	}
	return nil
}

type isMetadataJob_Spec interface {
	isMetadataJob_Spec()
}

type MetadataJob_ImportSpec struct {
	// Import job specification.
	ImportSpec *MetadataJob_ImportJobSpec `protobuf:"bytes,100,opt,name=import_spec,json=importSpec,proto3,oneof"`
}

type MetadataJob_ExportSpec struct {
	// Export job specification.
	ExportSpec *MetadataJob_ExportJobSpec `protobuf:"bytes,101,opt,name=export_spec,json=exportSpec,proto3,oneof"`
}

func (*MetadataJob_ImportSpec) isMetadataJob_Spec() {}

func (*MetadataJob_ExportSpec) isMetadataJob_Spec() {}

type isMetadataJob_Result interface {
	isMetadataJob_Result()
}

type MetadataJob_ImportResult struct {
	// Output only. Import job result.
	ImportResult *MetadataJob_ImportJobResult `protobuf:"bytes,200,opt,name=import_result,json=importResult,proto3,oneof"`
}

type MetadataJob_ExportResult struct {
	// Output only. Export job result.
	ExportResult *MetadataJob_ExportJobResult `protobuf:"bytes,201,opt,name=export_result,json=exportResult,proto3,oneof"`
}

func (*MetadataJob_ImportResult) isMetadataJob_Result() {}

func (*MetadataJob_ExportResult) isMetadataJob_Result() {}

// EntryLink represents a link between two Entries.
type EntryLink struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Immutable. Identifier. The relative resource name of the Entry
	// Link, of the form:
	// `projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}/entryLinks/{entry_link_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. Relative resource name of the Entry Link Type used to
	// create this Entry Link. For example:
	//
	// - Entry link between synonym terms in a glossary:
	// `projects/dataplex-types/locations/global/entryLinkTypes/synonym`
	// - Entry link between related terms in a glossary:
	// `projects/dataplex-types/locations/global/entryLinkTypes/related`
	// - Entry link between glossary terms and data assets:
	// `projects/dataplex-types/locations/global/entryLinkTypes/definition`
	EntryLinkType string `protobuf:"bytes,2,opt,name=entry_link_type,json=entryLinkType,proto3" json:"entry_link_type,omitempty"`
	// Output only. The time when the Entry Link was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time when the Entry Link was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Required. Specifies the Entries referenced in the Entry Link. There should
	// be exactly two entry references.
	EntryReferences []*EntryLink_EntryReference `protobuf:"bytes,10,rep,name=entry_references,json=entryReferences,proto3" json:"entry_references,omitempty"`
}

func (x *EntryLink) Reset() {
	*x = EntryLink{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EntryLink) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntryLink) ProtoMessage() {}

func (x *EntryLink) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntryLink.ProtoReflect.Descriptor instead.
func (*EntryLink) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{42}
}

func (x *EntryLink) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EntryLink) GetEntryLinkType() string {
	if x != nil {
		return x.EntryLinkType
	}
	return ""
}

func (x *EntryLink) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *EntryLink) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *EntryLink) GetEntryReferences() []*EntryLink_EntryReference {
	if x != nil {
		return x.EntryReferences
	}
	return nil
}

// Request message for CreateEntryLink.
type CreateEntryLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the parent Entry Group:
	// `projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Entry Link identifier
	// * Must contain only lowercase letters, numbers and hyphens.
	// * Must start with a letter.
	// * Must be between 1-63 characters.
	// * Must end with a number or a letter.
	// * Must be unique within the EntryGroup.
	EntryLinkId string `protobuf:"bytes,2,opt,name=entry_link_id,json=entryLinkId,proto3" json:"entry_link_id,omitempty"`
	// Required. Entry Link resource.
	EntryLink *EntryLink `protobuf:"bytes,3,opt,name=entry_link,json=entryLink,proto3" json:"entry_link,omitempty"`
}

func (x *CreateEntryLinkRequest) Reset() {
	*x = CreateEntryLinkRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateEntryLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEntryLinkRequest) ProtoMessage() {}

func (x *CreateEntryLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEntryLinkRequest.ProtoReflect.Descriptor instead.
func (*CreateEntryLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{43}
}

func (x *CreateEntryLinkRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateEntryLinkRequest) GetEntryLinkId() string {
	if x != nil {
		return x.EntryLinkId
	}
	return ""
}

func (x *CreateEntryLinkRequest) GetEntryLink() *EntryLink {
	if x != nil {
		return x.EntryLink
	}
	return nil
}

// Request message for DeleteEntryLink.
type DeleteEntryLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Entry Link:
	// `projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}/entryLinks/{entry_link_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteEntryLinkRequest) Reset() {
	*x = DeleteEntryLinkRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteEntryLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteEntryLinkRequest) ProtoMessage() {}

func (x *DeleteEntryLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteEntryLinkRequest.ProtoReflect.Descriptor instead.
func (*DeleteEntryLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{44}
}

func (x *DeleteEntryLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GetEntryLink.
type GetEntryLinkRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Entry Link:
	// `projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}/entryLinks/{entry_link_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEntryLinkRequest) Reset() {
	*x = GetEntryLinkRequest{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetEntryLinkRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEntryLinkRequest) ProtoMessage() {}

func (x *GetEntryLinkRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEntryLinkRequest.ProtoReflect.Descriptor instead.
func (*GetEntryLinkRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{45}
}

func (x *GetEntryLinkRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Authorization for an AspectType.
type AspectType_Authorization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The IAM permission grantable on the EntryGroup to allow access
	// to instantiate Aspects of Dataplex Universal Catalog owned AspectTypes,
	// only settable for Dataplex Universal Catalog owned Types.
	AlternateUsePermission string `protobuf:"bytes,1,opt,name=alternate_use_permission,json=alternateUsePermission,proto3" json:"alternate_use_permission,omitempty"`
}

func (x *AspectType_Authorization) Reset() {
	*x = AspectType_Authorization{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AspectType_Authorization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AspectType_Authorization) ProtoMessage() {}

func (x *AspectType_Authorization) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AspectType_Authorization.ProtoReflect.Descriptor instead.
func (*AspectType_Authorization) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{0, 0}
}

func (x *AspectType_Authorization) GetAlternateUsePermission() string {
	if x != nil {
		return x.AlternateUsePermission
	}
	return ""
}

// MetadataTemplate definition for an AspectType.
type AspectType_MetadataTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Index is used to encode Template messages. The value of index
	// can range between 1 and 2,147,483,647. Index must be unique within all
	// fields in a Template. (Nested Templates can reuse indexes). Once a
	// Template is defined, the index cannot be changed, because it identifies
	// the field in the actual storage format. Index is a mandatory field, but
	// it is optional for top level fields, and map/array "values" definitions.
	Index int32 `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
	// Required. The name of the field.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The datatype of this field. The following values are supported:
	//
	// Primitive types:
	//
	// * string
	// * int
	// * bool
	// * double
	// * datetime. Must be of the format RFC3339 UTC "Zulu" (Examples:
	// "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z").
	//
	// Complex types:
	//
	// * enum
	// * array
	// * map
	// * record
	Type string `protobuf:"bytes,5,opt,name=type,proto3" json:"type,omitempty"`
	// Optional. Field definition. You must specify it if the type is record. It
	// defines the nested fields.
	RecordFields []*AspectType_MetadataTemplate `protobuf:"bytes,6,rep,name=record_fields,json=recordFields,proto3" json:"record_fields,omitempty"`
	// Optional. The list of values for an enum type. You must define it if the
	// type is enum.
	EnumValues []*AspectType_MetadataTemplate_EnumValue `protobuf:"bytes,8,rep,name=enum_values,json=enumValues,proto3" json:"enum_values,omitempty"`
	// Optional. If the type is map, set map_items. map_items can refer to a
	// primitive field or a complex (record only) field. To specify a primitive
	// field, you only need to set name and type in the nested
	// MetadataTemplate. The recommended value for the name field is item, as
	// this isn't used in the actual payload.
	MapItems *AspectType_MetadataTemplate `protobuf:"bytes,10,opt,name=map_items,json=mapItems,proto3" json:"map_items,omitempty"`
	// Optional. If the type is array, set array_items. array_items can refer
	// to a primitive field or a complex (record only) field. To specify a
	// primitive field, you only need to set name and type in the nested
	// MetadataTemplate. The recommended value for the name field is item, as
	// this isn't used in the actual payload.
	ArrayItems *AspectType_MetadataTemplate `protobuf:"bytes,11,opt,name=array_items,json=arrayItems,proto3" json:"array_items,omitempty"`
	// Optional. You can use type id if this definition of the field needs to be
	// reused later. The type id must be unique across the entire template. You
	// can only specify it if the field type is record.
	TypeId string `protobuf:"bytes,12,opt,name=type_id,json=typeId,proto3" json:"type_id,omitempty"`
	// Optional. A reference to another field definition (not an inline
	// definition). The value must be equal to the value of an id field defined
	// elsewhere in the MetadataTemplate. Only fields with record type can
	// refer to other fields.
	TypeRef string `protobuf:"bytes,13,opt,name=type_ref,json=typeRef,proto3" json:"type_ref,omitempty"`
	// Optional. Specifies the constraints on this field.
	Constraints *AspectType_MetadataTemplate_Constraints `protobuf:"bytes,50,opt,name=constraints,proto3" json:"constraints,omitempty"`
	// Optional. Specifies annotations on this field.
	Annotations *AspectType_MetadataTemplate_Annotations `protobuf:"bytes,51,opt,name=annotations,proto3" json:"annotations,omitempty"`
}

func (x *AspectType_MetadataTemplate) Reset() {
	*x = AspectType_MetadataTemplate{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AspectType_MetadataTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AspectType_MetadataTemplate) ProtoMessage() {}

func (x *AspectType_MetadataTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AspectType_MetadataTemplate.ProtoReflect.Descriptor instead.
func (*AspectType_MetadataTemplate) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{0, 1}
}

func (x *AspectType_MetadataTemplate) GetIndex() int32 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *AspectType_MetadataTemplate) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AspectType_MetadataTemplate) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *AspectType_MetadataTemplate) GetRecordFields() []*AspectType_MetadataTemplate {
	if x != nil {
		return x.RecordFields
	}
	return nil
}

func (x *AspectType_MetadataTemplate) GetEnumValues() []*AspectType_MetadataTemplate_EnumValue {
	if x != nil {
		return x.EnumValues
	}
	return nil
}

func (x *AspectType_MetadataTemplate) GetMapItems() *AspectType_MetadataTemplate {
	if x != nil {
		return x.MapItems
	}
	return nil
}

func (x *AspectType_MetadataTemplate) GetArrayItems() *AspectType_MetadataTemplate {
	if x != nil {
		return x.ArrayItems
	}
	return nil
}

func (x *AspectType_MetadataTemplate) GetTypeId() string {
	if x != nil {
		return x.TypeId
	}
	return ""
}

func (x *AspectType_MetadataTemplate) GetTypeRef() string {
	if x != nil {
		return x.TypeRef
	}
	return ""
}

func (x *AspectType_MetadataTemplate) GetConstraints() *AspectType_MetadataTemplate_Constraints {
	if x != nil {
		return x.Constraints
	}
	return nil
}

func (x *AspectType_MetadataTemplate) GetAnnotations() *AspectType_MetadataTemplate_Annotations {
	if x != nil {
		return x.Annotations
	}
	return nil
}

// Definition of Enumvalue, to be used for enum fields.
type AspectType_MetadataTemplate_EnumValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Index for the enum value. It can't be modified.
	Index int32 `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
	// Required. Name of the enumvalue. This is the actual value that the
	// aspect can contain.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. You can set this message if you need to deprecate an enum
	// value.
	Deprecated string `protobuf:"bytes,3,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
}

func (x *AspectType_MetadataTemplate_EnumValue) Reset() {
	*x = AspectType_MetadataTemplate_EnumValue{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AspectType_MetadataTemplate_EnumValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AspectType_MetadataTemplate_EnumValue) ProtoMessage() {}

func (x *AspectType_MetadataTemplate_EnumValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AspectType_MetadataTemplate_EnumValue.ProtoReflect.Descriptor instead.
func (*AspectType_MetadataTemplate_EnumValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *AspectType_MetadataTemplate_EnumValue) GetIndex() int32 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *AspectType_MetadataTemplate_EnumValue) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AspectType_MetadataTemplate_EnumValue) GetDeprecated() string {
	if x != nil {
		return x.Deprecated
	}
	return ""
}

// Definition of the constraints of a field.
type AspectType_MetadataTemplate_Constraints struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Marks this field as optional or required.
	Required bool `protobuf:"varint,1,opt,name=required,proto3" json:"required,omitempty"`
}

func (x *AspectType_MetadataTemplate_Constraints) Reset() {
	*x = AspectType_MetadataTemplate_Constraints{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AspectType_MetadataTemplate_Constraints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AspectType_MetadataTemplate_Constraints) ProtoMessage() {}

func (x *AspectType_MetadataTemplate_Constraints) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AspectType_MetadataTemplate_Constraints.ProtoReflect.Descriptor instead.
func (*AspectType_MetadataTemplate_Constraints) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{0, 1, 1}
}

func (x *AspectType_MetadataTemplate_Constraints) GetRequired() bool {
	if x != nil {
		return x.Required
	}
	return false
}

// Definition of the annotations of a field.
type AspectType_MetadataTemplate_Annotations struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Marks a field as deprecated. You can include a deprecation
	// message.
	Deprecated string `protobuf:"bytes,1,opt,name=deprecated,proto3" json:"deprecated,omitempty"`
	// Optional. Display name for a field.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Description for a field.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Display order for a field. You can use this to reorder where
	// a field is rendered.
	DisplayOrder int32 `protobuf:"varint,4,opt,name=display_order,json=displayOrder,proto3" json:"display_order,omitempty"`
	// Optional. You can use String Type annotations to specify special
	// meaning to string fields. The following values are supported:
	//
	// * richText: The field must be interpreted as a rich text field.
	// * url: A fully qualified URL link.
	// * resource: A service qualified resource reference.
	StringType string `protobuf:"bytes,6,opt,name=string_type,json=stringType,proto3" json:"string_type,omitempty"`
	// Optional. Suggested hints for string fields. You can use them to
	// suggest values to users through console.
	StringValues []string `protobuf:"bytes,7,rep,name=string_values,json=stringValues,proto3" json:"string_values,omitempty"`
}

func (x *AspectType_MetadataTemplate_Annotations) Reset() {
	*x = AspectType_MetadataTemplate_Annotations{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AspectType_MetadataTemplate_Annotations) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AspectType_MetadataTemplate_Annotations) ProtoMessage() {}

func (x *AspectType_MetadataTemplate_Annotations) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AspectType_MetadataTemplate_Annotations.ProtoReflect.Descriptor instead.
func (*AspectType_MetadataTemplate_Annotations) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{0, 1, 2}
}

func (x *AspectType_MetadataTemplate_Annotations) GetDeprecated() string {
	if x != nil {
		return x.Deprecated
	}
	return ""
}

func (x *AspectType_MetadataTemplate_Annotations) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *AspectType_MetadataTemplate_Annotations) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *AspectType_MetadataTemplate_Annotations) GetDisplayOrder() int32 {
	if x != nil {
		return x.DisplayOrder
	}
	return 0
}

func (x *AspectType_MetadataTemplate_Annotations) GetStringType() string {
	if x != nil {
		return x.StringType
	}
	return ""
}

func (x *AspectType_MetadataTemplate_Annotations) GetStringValues() []string {
	if x != nil {
		return x.StringValues
	}
	return nil
}

type EntryType_AspectInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required aspect type for the entry type.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *EntryType_AspectInfo) Reset() {
	*x = EntryType_AspectInfo{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EntryType_AspectInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntryType_AspectInfo) ProtoMessage() {}

func (x *EntryType_AspectInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntryType_AspectInfo.ProtoReflect.Descriptor instead.
func (*EntryType_AspectInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{2, 0}
}

func (x *EntryType_AspectInfo) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

// Authorization for an Entry Type.
type EntryType_Authorization struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. The IAM permission grantable on the Entry Group to allow
	// access to instantiate Entries of Dataplex Universal Catalog owned Entry
	// Types, only settable for Dataplex Universal Catalog owned Types.
	AlternateUsePermission string `protobuf:"bytes,1,opt,name=alternate_use_permission,json=alternateUsePermission,proto3" json:"alternate_use_permission,omitempty"`
}

func (x *EntryType_Authorization) Reset() {
	*x = EntryType_Authorization{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[54]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EntryType_Authorization) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntryType_Authorization) ProtoMessage() {}

func (x *EntryType_Authorization) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[54]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntryType_Authorization.ProtoReflect.Descriptor instead.
func (*EntryType_Authorization) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{2, 1}
}

func (x *EntryType_Authorization) GetAlternateUsePermission() string {
	if x != nil {
		return x.AlternateUsePermission
	}
	return ""
}

// Information about individual items in the hierarchy that is associated with
// the data resource.
type EntrySource_Ancestor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The name of the ancestor resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The type of the ancestor resource.
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *EntrySource_Ancestor) Reset() {
	*x = EntrySource_Ancestor{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[57]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EntrySource_Ancestor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntrySource_Ancestor) ProtoMessage() {}

func (x *EntrySource_Ancestor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[57]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntrySource_Ancestor.ProtoReflect.Descriptor instead.
func (*EntrySource_Ancestor) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{6, 0}
}

func (x *EntrySource_Ancestor) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EntrySource_Ancestor) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

// Snippets for the entry, contains HTML-style highlighting for
// matched tokens, will be used in UI.
//
// Deprecated: Marked as deprecated in google/cloud/dataplex/v1/catalog.proto.
type SearchEntriesResult_Snippets struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Entry
	//
	// Deprecated: Marked as deprecated in google/cloud/dataplex/v1/catalog.proto.
	DataplexEntry *Entry `protobuf:"bytes,1,opt,name=dataplex_entry,json=dataplexEntry,proto3" json:"dataplex_entry,omitempty"`
}

func (x *SearchEntriesResult_Snippets) Reset() {
	*x = SearchEntriesResult_Snippets{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[59]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchEntriesResult_Snippets) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchEntriesResult_Snippets) ProtoMessage() {}

func (x *SearchEntriesResult_Snippets) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[59]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchEntriesResult_Snippets.ProtoReflect.Descriptor instead.
func (*SearchEntriesResult_Snippets) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{33, 0}
}

// Deprecated: Marked as deprecated in google/cloud/dataplex/v1/catalog.proto.
func (x *SearchEntriesResult_Snippets) GetDataplexEntry() *Entry {
	if x != nil {
		return x.DataplexEntry
	}
	return nil
}

// Results from a metadata import job.
type MetadataJob_ImportJobResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The total number of entries that were deleted.
	DeletedEntries int64 `protobuf:"varint,1,opt,name=deleted_entries,json=deletedEntries,proto3" json:"deleted_entries,omitempty"`
	// Output only. The total number of entries that were updated.
	UpdatedEntries int64 `protobuf:"varint,2,opt,name=updated_entries,json=updatedEntries,proto3" json:"updated_entries,omitempty"`
	// Output only. The total number of entries that were created.
	CreatedEntries int64 `protobuf:"varint,3,opt,name=created_entries,json=createdEntries,proto3" json:"created_entries,omitempty"`
	// Output only. The total number of entries that were unchanged.
	UnchangedEntries int64 `protobuf:"varint,4,opt,name=unchanged_entries,json=unchangedEntries,proto3" json:"unchanged_entries,omitempty"`
	// Output only. The total number of entries that were recreated.
	RecreatedEntries int64 `protobuf:"varint,6,opt,name=recreated_entries,json=recreatedEntries,proto3" json:"recreated_entries,omitempty"`
	// Output only. The time when the status was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The total number of entry links that were successfully
	// deleted.
	DeletedEntryLinks int64 `protobuf:"varint,7,opt,name=deleted_entry_links,json=deletedEntryLinks,proto3" json:"deleted_entry_links,omitempty"`
	// Output only. The total number of entry links that were successfully
	// created.
	CreatedEntryLinks int64 `protobuf:"varint,8,opt,name=created_entry_links,json=createdEntryLinks,proto3" json:"created_entry_links,omitempty"`
	// Output only. The total number of entry links that were left unchanged.
	UnchangedEntryLinks int64 `protobuf:"varint,9,opt,name=unchanged_entry_links,json=unchangedEntryLinks,proto3" json:"unchanged_entry_links,omitempty"`
}

func (x *MetadataJob_ImportJobResult) Reset() {
	*x = MetadataJob_ImportJobResult{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[60]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetadataJob_ImportJobResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataJob_ImportJobResult) ProtoMessage() {}

func (x *MetadataJob_ImportJobResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[60]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataJob_ImportJobResult.ProtoReflect.Descriptor instead.
func (*MetadataJob_ImportJobResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{41, 0}
}

func (x *MetadataJob_ImportJobResult) GetDeletedEntries() int64 {
	if x != nil {
		return x.DeletedEntries
	}
	return 0
}

func (x *MetadataJob_ImportJobResult) GetUpdatedEntries() int64 {
	if x != nil {
		return x.UpdatedEntries
	}
	return 0
}

func (x *MetadataJob_ImportJobResult) GetCreatedEntries() int64 {
	if x != nil {
		return x.CreatedEntries
	}
	return 0
}

func (x *MetadataJob_ImportJobResult) GetUnchangedEntries() int64 {
	if x != nil {
		return x.UnchangedEntries
	}
	return 0
}

func (x *MetadataJob_ImportJobResult) GetRecreatedEntries() int64 {
	if x != nil {
		return x.RecreatedEntries
	}
	return 0
}

func (x *MetadataJob_ImportJobResult) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *MetadataJob_ImportJobResult) GetDeletedEntryLinks() int64 {
	if x != nil {
		return x.DeletedEntryLinks
	}
	return 0
}

func (x *MetadataJob_ImportJobResult) GetCreatedEntryLinks() int64 {
	if x != nil {
		return x.CreatedEntryLinks
	}
	return 0
}

func (x *MetadataJob_ImportJobResult) GetUnchangedEntryLinks() int64 {
	if x != nil {
		return x.UnchangedEntryLinks
	}
	return 0
}

// Summary results from a metadata export job. The results are a snapshot of
// the metadata at the time when the job was created. The exported entries are
// saved to a Cloud Storage bucket.
type MetadataJob_ExportJobResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The number of entries that were exported.
	ExportedEntries int64 `protobuf:"varint,1,opt,name=exported_entries,json=exportedEntries,proto3" json:"exported_entries,omitempty"`
	// Output only. The error message if the metadata export job failed.
	ErrorMessage string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
}

func (x *MetadataJob_ExportJobResult) Reset() {
	*x = MetadataJob_ExportJobResult{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[61]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetadataJob_ExportJobResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataJob_ExportJobResult) ProtoMessage() {}

func (x *MetadataJob_ExportJobResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[61]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataJob_ExportJobResult.ProtoReflect.Descriptor instead.
func (*MetadataJob_ExportJobResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{41, 1}
}

func (x *MetadataJob_ExportJobResult) GetExportedEntries() int64 {
	if x != nil {
		return x.ExportedEntries
	}
	return 0
}

func (x *MetadataJob_ExportJobResult) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

// Job specification for a metadata import job.
//
// You can run the following kinds of metadata import jobs:
//
// * Full sync of entries with incremental import of their aspects.
// Supported for custom entries.
// * Incremental import of aspects only. Supported for aspects that belong
// to custom entries and system entries. For custom entries, you can modify
// both optional aspects and required aspects. For system entries, you can
// modify optional aspects.
type MetadataJob_ImportJobSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The URI of a Cloud Storage bucket or folder (beginning with
	// `gs://` and ending with `/`) that contains the metadata import files for
	// this job.
	//
	// A metadata import file defines the values to set for each of the entries
	// and aspects in a metadata import job. For more information about how to
	// create a metadata import file and the file requirements, see [Metadata
	// import
	// file](https://cloud.google.com/dataplex/docs/import-metadata#metadata-import-file).
	//
	// You can provide multiple metadata import files in the same metadata job.
	// The bucket or folder must contain at least one metadata import file, in
	// JSON Lines format (either `.json` or `.jsonl` file extension).
	//
	// In `FULL` entry sync mode, don't save the metadata import file in a
	// folder named `SOURCE_STORAGE_URI/deletions/`.
	//
	// **Caution**: If the metadata import file contains no data, all entries
	// and aspects that belong to the job's scope are deleted.
	SourceStorageUri string `protobuf:"bytes,1,opt,name=source_storage_uri,json=sourceStorageUri,proto3" json:"source_storage_uri,omitempty"`
	// Optional. The time when the process that created the metadata import
	// files began.
	SourceCreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=source_create_time,json=sourceCreateTime,proto3" json:"source_create_time,omitempty"`
	// Required. A boundary on the scope of impact that the metadata import job
	// can have.
	Scope *MetadataJob_ImportJobSpec_ImportJobScope `protobuf:"bytes,2,opt,name=scope,proto3" json:"scope,omitempty"`
	// Required. The sync mode for entries.
	EntrySyncMode MetadataJob_ImportJobSpec_SyncMode `protobuf:"varint,3,opt,name=entry_sync_mode,json=entrySyncMode,proto3,enum=google.cloud.dataplex.v1.MetadataJob_ImportJobSpec_SyncMode" json:"entry_sync_mode,omitempty"`
	// Required. The sync mode for aspects.
	AspectSyncMode MetadataJob_ImportJobSpec_SyncMode `protobuf:"varint,4,opt,name=aspect_sync_mode,json=aspectSyncMode,proto3,enum=google.cloud.dataplex.v1.MetadataJob_ImportJobSpec_SyncMode" json:"aspect_sync_mode,omitempty"`
	// Optional. The level of logs to write to Cloud Logging for this job.
	//
	// Debug-level logs provide highly-detailed information for
	// troubleshooting, but their increased verbosity could incur [additional
	// costs](https://cloud.google.com/stackdriver/pricing) that might not be
	// merited for all jobs.
	//
	// If unspecified, defaults to `INFO`.
	LogLevel MetadataJob_ImportJobSpec_LogLevel `protobuf:"varint,6,opt,name=log_level,json=logLevel,proto3,enum=google.cloud.dataplex.v1.MetadataJob_ImportJobSpec_LogLevel" json:"log_level,omitempty"`
}

func (x *MetadataJob_ImportJobSpec) Reset() {
	*x = MetadataJob_ImportJobSpec{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[62]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetadataJob_ImportJobSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataJob_ImportJobSpec) ProtoMessage() {}

func (x *MetadataJob_ImportJobSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[62]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataJob_ImportJobSpec.ProtoReflect.Descriptor instead.
func (*MetadataJob_ImportJobSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{41, 2}
}

func (x *MetadataJob_ImportJobSpec) GetSourceStorageUri() string {
	if x != nil {
		return x.SourceStorageUri
	}
	return ""
}

func (x *MetadataJob_ImportJobSpec) GetSourceCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SourceCreateTime
	}
	return nil
}

func (x *MetadataJob_ImportJobSpec) GetScope() *MetadataJob_ImportJobSpec_ImportJobScope {
	if x != nil {
		return x.Scope
	}
	return nil
}

func (x *MetadataJob_ImportJobSpec) GetEntrySyncMode() MetadataJob_ImportJobSpec_SyncMode {
	if x != nil {
		return x.EntrySyncMode
	}
	return MetadataJob_ImportJobSpec_SYNC_MODE_UNSPECIFIED
}

func (x *MetadataJob_ImportJobSpec) GetAspectSyncMode() MetadataJob_ImportJobSpec_SyncMode {
	if x != nil {
		return x.AspectSyncMode
	}
	return MetadataJob_ImportJobSpec_SYNC_MODE_UNSPECIFIED
}

func (x *MetadataJob_ImportJobSpec) GetLogLevel() MetadataJob_ImportJobSpec_LogLevel {
	if x != nil {
		return x.LogLevel
	}
	return MetadataJob_ImportJobSpec_LOG_LEVEL_UNSPECIFIED
}

// Job specification for a metadata export job.
type MetadataJob_ExportJobSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The scope of the export job.
	Scope *MetadataJob_ExportJobSpec_ExportJobScope `protobuf:"bytes,2,opt,name=scope,proto3" json:"scope,omitempty"`
	// Required. The root path of the Cloud Storage bucket to export the
	// metadata to, in the format `gs://{bucket}/`. You can optionally specify a
	// custom prefix after the bucket name, in the format
	// `gs://{bucket}/{prefix}/`. The maximum length of the custom prefix is 128
	// characters. Dataplex Universal Catalog constructs the object path for the
	// exported files by using the bucket name and prefix that you provide,
	// followed by a system-generated path.
	//
	// The bucket must be in the same VPC Service Controls perimeter as the job.
	OutputPath string `protobuf:"bytes,3,opt,name=output_path,json=outputPath,proto3" json:"output_path,omitempty"`
}

func (x *MetadataJob_ExportJobSpec) Reset() {
	*x = MetadataJob_ExportJobSpec{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[63]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetadataJob_ExportJobSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataJob_ExportJobSpec) ProtoMessage() {}

func (x *MetadataJob_ExportJobSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[63]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataJob_ExportJobSpec.ProtoReflect.Descriptor instead.
func (*MetadataJob_ExportJobSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{41, 3}
}

func (x *MetadataJob_ExportJobSpec) GetScope() *MetadataJob_ExportJobSpec_ExportJobScope {
	if x != nil {
		return x.Scope
	}
	return nil
}

func (x *MetadataJob_ExportJobSpec) GetOutputPath() string {
	if x != nil {
		return x.OutputPath
	}
	return ""
}

// Metadata job status.
type MetadataJob_Status struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. State of the metadata job.
	State MetadataJob_Status_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.dataplex.v1.MetadataJob_Status_State" json:"state,omitempty"`
	// Output only. Message relating to the progression of a metadata job.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	// Output only. Progress tracking.
	CompletionPercent int32 `protobuf:"varint,3,opt,name=completion_percent,json=completionPercent,proto3" json:"completion_percent,omitempty"`
	// Output only. The time when the status was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *MetadataJob_Status) Reset() {
	*x = MetadataJob_Status{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[64]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetadataJob_Status) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataJob_Status) ProtoMessage() {}

func (x *MetadataJob_Status) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[64]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataJob_Status.ProtoReflect.Descriptor instead.
func (*MetadataJob_Status) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{41, 4}
}

func (x *MetadataJob_Status) GetState() MetadataJob_Status_State {
	if x != nil {
		return x.State
	}
	return MetadataJob_Status_STATE_UNSPECIFIED
}

func (x *MetadataJob_Status) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

func (x *MetadataJob_Status) GetCompletionPercent() int32 {
	if x != nil {
		return x.CompletionPercent
	}
	return 0
}

func (x *MetadataJob_Status) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// A boundary on the scope of impact that the metadata import job can have.
type MetadataJob_ImportJobSpec_ImportJobScope struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The entry groups that are in scope for the import job,
	// specified as relative resource names in the format
	// `projects/{project_number_or_id}/locations/{location_id}/entryGroups/{entry_group_id}`.
	// Only entries and aspects that belong to the specified entry groups are
	// affected by the job.
	//
	// The entry groups and the job must be in the same location.
	EntryGroups []string `protobuf:"bytes,1,rep,name=entry_groups,json=entryGroups,proto3" json:"entry_groups,omitempty"`
	// Required. The entry types that are in scope for the import job,
	// specified as relative resource names in the format
	// `projects/{project_number_or_id}/locations/{location_id}/entryTypes/{entry_type_id}`.
	// The job modifies only the entries and aspects that belong to these
	// entry types.
	//
	// If the metadata import file attempts to modify an entry whose type
	// isn't included in this list, the import job is halted before modifying
	// any entries or aspects.
	//
	// The location of an entry type must either match the location of the
	// job, or the entry type must be global.
	EntryTypes []string `protobuf:"bytes,2,rep,name=entry_types,json=entryTypes,proto3" json:"entry_types,omitempty"`
	// Optional. The aspect types that are in scope for the import job,
	// specified as relative resource names in the format
	// `projects/{project_number_or_id}/locations/{location_id}/aspectTypes/{aspect_type_id}`.
	// The job modifies only the aspects that belong to these aspect types.
	//
	// This field is required when creating an aspect-only import job.
	//
	// If the metadata import file attempts to modify an aspect whose type
	// isn't included in this list, the import job is halted before modifying
	// any entries or aspects.
	//
	// The location of an aspect type must either match the location of the
	// job, or the aspect type must be global.
	AspectTypes []string `protobuf:"bytes,3,rep,name=aspect_types,json=aspectTypes,proto3" json:"aspect_types,omitempty"`
	// Optional. The glossaries that are in scope for the import job,
	// specified as relative resource names in the format
	// `projects/{project_number_or_id}/locations/{location_id}/glossaries/{glossary_id}`.
	//
	// While importing Business Glossary entries, the user must
	// provide glossaries. While importing entries, the user does not have to
	// provide glossaries. If the metadata import file attempts to modify
	// Business Glossary entries whose glossary isn't included in this list,
	// the import job will skip those entries.
	//
	// The location of a glossary must either match the location of the
	// job, or the glossary must be global.
	Glossaries []string `protobuf:"bytes,4,rep,name=glossaries,proto3" json:"glossaries,omitempty"`
	// Optional. The entry link types that are in scope for the import job,
	// specified as relative resource names in the format
	// `projects/{project_number_or_id}/locations/{location_id}/entryLinkTypes/{entry_link_type_id}`.
	// The job modifies only the entryLinks that belong to these entry link
	// types.
	//
	// If the metadata import file attempts to create or delete an entry link
	// whose entry link type isn't included in this list, the import job will
	// skip those entry links.
	EntryLinkTypes []string `protobuf:"bytes,5,rep,name=entry_link_types,json=entryLinkTypes,proto3" json:"entry_link_types,omitempty"`
	// Optional. Defines the scope of entries that can be referenced in the
	// entry links.
	//
	// Currently, projects are supported as valid scopes.
	// Format: `projects/{project_number_or_id}`
	//
	// If the metadata import file attempts to create an entry link
	// which references an entry that is not in the scope, the import job will
	// skip that entry link.
	ReferencedEntryScopes []string `protobuf:"bytes,6,rep,name=referenced_entry_scopes,json=referencedEntryScopes,proto3" json:"referenced_entry_scopes,omitempty"`
}

func (x *MetadataJob_ImportJobSpec_ImportJobScope) Reset() {
	*x = MetadataJob_ImportJobSpec_ImportJobScope{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[66]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetadataJob_ImportJobSpec_ImportJobScope) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataJob_ImportJobSpec_ImportJobScope) ProtoMessage() {}

func (x *MetadataJob_ImportJobSpec_ImportJobScope) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[66]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataJob_ImportJobSpec_ImportJobScope.ProtoReflect.Descriptor instead.
func (*MetadataJob_ImportJobSpec_ImportJobScope) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{41, 2, 0}
}

func (x *MetadataJob_ImportJobSpec_ImportJobScope) GetEntryGroups() []string {
	if x != nil {
		return x.EntryGroups
	}
	return nil
}

func (x *MetadataJob_ImportJobSpec_ImportJobScope) GetEntryTypes() []string {
	if x != nil {
		return x.EntryTypes
	}
	return nil
}

func (x *MetadataJob_ImportJobSpec_ImportJobScope) GetAspectTypes() []string {
	if x != nil {
		return x.AspectTypes
	}
	return nil
}

func (x *MetadataJob_ImportJobSpec_ImportJobScope) GetGlossaries() []string {
	if x != nil {
		return x.Glossaries
	}
	return nil
}

func (x *MetadataJob_ImportJobSpec_ImportJobScope) GetEntryLinkTypes() []string {
	if x != nil {
		return x.EntryLinkTypes
	}
	return nil
}

func (x *MetadataJob_ImportJobSpec_ImportJobScope) GetReferencedEntryScopes() []string {
	if x != nil {
		return x.ReferencedEntryScopes
	}
	return nil
}

// The scope of the export job.
type MetadataJob_ExportJobSpec_ExportJobScope struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the metadata export job is an organization-level export job.
	//
	// - If `true`, the job exports the entries from the same organization and
	// VPC Service Controls perimeter as the job. The project that the job
	// belongs to determines the VPC Service Controls perimeter. If you set
	// the job scope to be at the organization level, then don't provide a
	// list of projects or entry groups.
	// - If `false`, you must specify a list of projects or a list of entry
	// groups whose entries you want to export.
	//
	// The default is `false`.
	OrganizationLevel bool `protobuf:"varint,1,opt,name=organization_level,json=organizationLevel,proto3" json:"organization_level,omitempty"`
	// The projects whose metadata you want to export, in the format
	// `projects/{project_id_or_number}`. Only the entries from
	// the specified projects are exported.
	//
	// The projects must be in the same organization and VPC Service Controls
	// perimeter as the job.
	//
	// If you set the job scope to be a list of projects, then set the
	// organization-level export flag to false and don't provide a list of
	// entry groups.
	Projects []string `protobuf:"bytes,2,rep,name=projects,proto3" json:"projects,omitempty"`
	// The entry groups whose metadata you want to export, in the format
	// `projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}`.
	// Only the entries in the specified entry groups are exported.
	//
	// The entry groups must be in the same location and the same VPC Service
	// Controls perimeter as the job.
	//
	// If you set the job scope to be a list of entry groups, then set the
	// organization-level export flag to false and don't provide a list of
	// projects.
	EntryGroups []string `protobuf:"bytes,3,rep,name=entry_groups,json=entryGroups,proto3" json:"entry_groups,omitempty"`
	// The entry types that are in scope for the export job, specified as
	// relative resource names in the format
	// `projects/{project_id_or_number}/locations/{location}/entryTypes/{entry_type_id}`.
	// Only entries that belong to the specified entry types are affected by
	// the job.
	EntryTypes []string `protobuf:"bytes,4,rep,name=entry_types,json=entryTypes,proto3" json:"entry_types,omitempty"`
	// The aspect types that are in scope for the export job, specified as
	// relative resource names in the format
	// `projects/{project_id_or_number}/locations/{location}/aspectTypes/{aspect_type_id}`.
	// Only aspects that belong to the specified aspect types are affected by
	// the job.
	AspectTypes []string `protobuf:"bytes,5,rep,name=aspect_types,json=aspectTypes,proto3" json:"aspect_types,omitempty"`
}

func (x *MetadataJob_ExportJobSpec_ExportJobScope) Reset() {
	*x = MetadataJob_ExportJobSpec_ExportJobScope{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[67]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetadataJob_ExportJobSpec_ExportJobScope) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetadataJob_ExportJobSpec_ExportJobScope) ProtoMessage() {}

func (x *MetadataJob_ExportJobSpec_ExportJobScope) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[67]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetadataJob_ExportJobSpec_ExportJobScope.ProtoReflect.Descriptor instead.
func (*MetadataJob_ExportJobSpec_ExportJobScope) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{41, 3, 0}
}

func (x *MetadataJob_ExportJobSpec_ExportJobScope) GetOrganizationLevel() bool {
	if x != nil {
		return x.OrganizationLevel
	}
	return false
}

func (x *MetadataJob_ExportJobSpec_ExportJobScope) GetProjects() []string {
	if x != nil {
		return x.Projects
	}
	return nil
}

func (x *MetadataJob_ExportJobSpec_ExportJobScope) GetEntryGroups() []string {
	if x != nil {
		return x.EntryGroups
	}
	return nil
}

func (x *MetadataJob_ExportJobSpec_ExportJobScope) GetEntryTypes() []string {
	if x != nil {
		return x.EntryTypes
	}
	return nil
}

func (x *MetadataJob_ExportJobSpec_ExportJobScope) GetAspectTypes() []string {
	if x != nil {
		return x.AspectTypes
	}
	return nil
}

// Reference to the Entry that is linked through the Entry Link.
type EntryLink_EntryReference struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Immutable. The relative resource name of the referenced Entry,
	// of the form:
	// `projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}/entries/{entry_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. The path in the Entry that is referenced in the Entry Link.
	// Empty path denotes that the Entry itself is referenced in the Entry
	// Link.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	// Required. Immutable. The reference type of the Entry.
	Type EntryLink_EntryReference_Type `protobuf:"varint,3,opt,name=type,proto3,enum=google.cloud.dataplex.v1.EntryLink_EntryReference_Type" json:"type,omitempty"`
}

func (x *EntryLink_EntryReference) Reset() {
	*x = EntryLink_EntryReference{}
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[68]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EntryLink_EntryReference) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EntryLink_EntryReference) ProtoMessage() {}

func (x *EntryLink_EntryReference) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataplex_v1_catalog_proto_msgTypes[68]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EntryLink_EntryReference.ProtoReflect.Descriptor instead.
func (*EntryLink_EntryReference) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP(), []int{42, 0}
}

func (x *EntryLink_EntryReference) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *EntryLink_EntryReference) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *EntryLink_EntryReference) GetType() EntryLink_EntryReference_Type {
	if x != nil {
		return x.Type
	}
	return EntryLink_EntryReference_UNSPECIFIED
}

var File_google_cloud_dataplex_v1_catalog_proto protoreflect.FileDescriptor

var file_google_cloud_dataplex_v1_catalog_proto_rawDesc = []byte{
	0x0a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x96, 0x12,
	0x0a, 0x0a, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3e, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x03, 0xfa,
	0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03,
	0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03,
	0x75, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26,
	0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x70, 0x0a, 0x13, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x05, 0x52, 0x12, 0x64, 0x61, 0x74, 0x61, 0x43, 0x6c, 0x61,
	0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5d, 0x0a, 0x0d, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x34, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0d, 0x61, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x67, 0x0a, 0x11, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18,
	0x35, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x10, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x12, 0x57, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0xca, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65,
	0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x1a, 0x4e, 0x0a, 0x0d,
	0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a,
	0x18, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x65, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x70,
	0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x05, 0x52, 0x16, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x65, 0x55,
	0x73, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x83, 0x09, 0x0a,
	0x10, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x12, 0x19, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x5f,
	0x0a, 0x0d, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0c, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12,
	0x65, 0x0a, 0x0b, 0x65, 0x6e, 0x75, 0x6d, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x08,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x45, 0x6e, 0x75, 0x6d,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x65, 0x6e, 0x75, 0x6d,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x57, 0x0a, 0x09, 0x6d, 0x61, 0x70, 0x5f, 0x69, 0x74,
	0x65, 0x6d, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x2e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6d, 0x61, 0x70, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x12,
	0x5b, 0x0a, 0x0b, 0x61, 0x72, 0x72, 0x61, 0x79, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x61, 0x72, 0x72, 0x61, 0x79, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x1c, 0x0a, 0x07,
	0x74, 0x79, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x06, 0x74, 0x79, 0x70, 0x65, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x08, 0x74, 0x79,
	0x70, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x07, 0x74, 0x79, 0x70, 0x65, 0x52, 0x65, 0x66, 0x12, 0x68, 0x0a, 0x0b, 0x63, 0x6f,
	0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x18, 0x32, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x74, 0x73, 0x12, 0x68, 0x0a, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x33, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x2e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x64,
	0x0a, 0x09, 0x45, 0x6e, 0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x23, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63,
	0x61, 0x74, 0x65, 0x64, 0x1a, 0x2e, 0x0a, 0x0b, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x74, 0x73, 0x12, 0x1f, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x64, 0x1a, 0xfb, 0x01, 0x0a, 0x0b, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x23, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74,
	0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x64,
	0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x64, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4f, 0x72, 0x64,
	0x65, 0x72, 0x12, 0x24, 0x0a, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x73, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x54, 0x79, 0x70, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x50, 0x0a,
	0x12, 0x44, 0x61, 0x74, 0x61, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x23, 0x0a, 0x1f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x43, 0x4c, 0x41, 0x53,
	0x53, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x4d, 0x45, 0x54, 0x41,
	0x44, 0x41, 0x54, 0x41, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x10, 0x01, 0x3a,
	0x84, 0x01, 0xea, 0x41, 0x80, 0x01, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x41, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f,
	0x7b, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x7d, 0x2a, 0x0b, 0x61,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x32, 0x0a, 0x61, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x22, 0xb4, 0x05, 0x0a, 0x0a, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x4d, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x12,
	0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x12, 0x57, 0x0a, 0x0f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0xca, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x84, 0x01, 0xea, 0x41, 0x80, 0x01, 0x0a, 0x22, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x12, 0x41, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x7d, 0x2a, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x32, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x90, 0x08,
	0x0a, 0x09, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3d, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x03, 0xfa, 0x41,
	0x23, 0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x69,
	0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4c, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x07,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x26, 0x0a, 0x0c, 0x74,
	0x79, 0x70, 0x65, 0x5f, 0x61, 0x6c, 0x69, 0x61, 0x73, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x74, 0x79, 0x70, 0x65, 0x41, 0x6c, 0x69, 0x61,
	0x73, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x12, 0x1b, 0x0a, 0x06, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x73, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x12, 0x59, 0x0a, 0x10, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x5f, 0x61, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x73, 0x18, 0x32, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65,
	0x2e, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0f, 0x72, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x64, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x73, 0x12, 0x5c, 0x0a, 0x0d,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x33, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0d, 0x61, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x49, 0x0a, 0x0a, 0x41, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x3b, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x1a, 0x4e, 0x0a, 0x0d, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x18, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x74, 0x65, 0x5f, 0x75, 0x73, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x16, 0x61,
	0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x65, 0x55, 0x73, 0x65, 0x50, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x3a, 0x7e, 0xea, 0x41, 0x7b, 0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x7d, 0x2a, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x32, 0x09, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65,
	0x22, 0xcf, 0x02, 0x0a, 0x06, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x61,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x30,
	0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x50, 0x0a, 0x0d, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x22, 0xab, 0x01, 0x0a, 0x0c, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x22, 0xb0, 0x05, 0x0a, 0x05, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0, 0x41, 0x05, 0x52,
	0x09, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b,
	0x0a, 0x07, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x2e, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x07, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x73, 0x12, 0x29, 0x0a, 0x0c, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x05, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x35, 0x0a, 0x14, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x5f,
	0x71, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x66, 0x75, 0x6c, 0x6c, 0x79,
	0x51, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4d, 0x0a,
	0x0c, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x0f, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x1a, 0x5c, 0x0a, 0x0c,
	0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x36,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x86, 0x01, 0xea, 0x41, 0x82,
	0x01, 0x0a, 0x1d, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x51, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x7d, 0x2a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x32, 0x05, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x22, 0xd4, 0x04, 0x0a, 0x0b, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x16, 0x0a, 0x06, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x51, 0x0a, 0x09, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x73,
	0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x41, 0x6e,
	0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x09, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x1f, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x1a, 0x3c, 0x0a, 0x08, 0x41, 0x6e, 0x63, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x1a,
	0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xfd, 0x01, 0x0a, 0x17, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x0e, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x49, 0x64, 0x12, 0x4a, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c,
	0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xd1, 0x01, 0x0a, 0x17, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x72,
	0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a,
	0x22, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x22, 0xde, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x42, 0x79, 0x22, 0xbf, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x47, 0x0a, 0x0c, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x0b, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x33, 0x0a, 0x15, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x14, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x56, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xf7, 0x01,
	0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x27, 0x0a, 0x0d, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79,
	0x70, 0x65, 0x49, 0x64, 0x12, 0x47, 0x0a, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x09, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x28, 0x0a,
	0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xcd, 0x01, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x47, 0x0a, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x28, 0x0a,
	0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x70, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0xdd, 0x01, 0x0a, 0x15, 0x4c, 0x69,
	0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xbb, 0x01, 0x0a, 0x16, 0x4c, 0x69,
	0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x33, 0x0a, 0x15, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x14, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x54, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xfd, 0x01,
	0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x0e,
	0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x61, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x49, 0x64, 0x12, 0x4a, 0x0a, 0x0b, 0x61, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xd1, 0x01,
	0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x0b, 0x61, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x61, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c,
	0x79, 0x22, 0x72, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04,
	0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0xde, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f,
	0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xbf, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x47, 0x0a, 0x0c, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b,
	0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x33, 0x0a, 0x15, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x14, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x56, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x41,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xb4, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a,
	0x22, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1e, 0x0a, 0x08, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x49, 0x64, 0x12, 0x3a, 0x0a, 0x05, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x05, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x22, 0x9d, 0x02, 0x0a, 0x12, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a,
	0x0a, 0x05, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x05, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x28, 0x0a, 0x0d,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x4d,
	0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x12, 0x39, 0x0a, 0x16, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x5f, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x73,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x64, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x73, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x22, 0x4f, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbb, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73,
	0x74, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x78, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e,
	0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x39, 0x0a,
	0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xcd, 0x01, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x3c, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x56, 0x69,
	0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x12, 0x26, 0x0a,
	0x0c, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x19, 0x0a, 0x05, 0x70, 0x61, 0x74, 0x68, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x70, 0x61, 0x74, 0x68, 0x73,
	0x22, 0xeb, 0x01, 0x0a, 0x12, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x3c, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x56,
	0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x12, 0x26,
	0x0a, 0x0c, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x19, 0x0a, 0x05, 0x70, 0x61, 0x74, 0x68, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x70, 0x61, 0x74, 0x68,
	0x73, 0x12, 0x3b, 0x0a, 0x05, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x05, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x22, 0x9f,
	0x02, 0x0a, 0x14, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x19, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x73, 0x63, 0x6f,
	0x70, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x6d, 0x61, 0x6e, 0x74, 0x69, 0x63, 0x5f, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0e, 0x73, 0x65, 0x6d, 0x61, 0x6e, 0x74, 0x69, 0x63, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x22, 0xbe, 0x02, 0x0a, 0x13, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74, 0x72, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x2b, 0x0a, 0x0f, 0x6c, 0x69, 0x6e, 0x6b,
	0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0e, 0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x46, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x56, 0x0a,
	0x08, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x53,
	0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x73, 0x42, 0x02, 0x18, 0x01, 0x52, 0x08, 0x73, 0x6e, 0x69,
	0x70, 0x70, 0x65, 0x74, 0x73, 0x1a, 0x5a, 0x0a, 0x08, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74,
	0x73, 0x12, 0x4a, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x5f, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0d,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x3a, 0x02, 0x18,
	0x01, 0x22, 0xc9, 0x01, 0x0a, 0x15, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47, 0x0a, 0x07, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e,
	0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75,
	0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xe5, 0x01,
	0x0a, 0x0a, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x35, 0x0a, 0x05,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x05, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x42, 0x0a, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x6c, 0x69, 0x6e,
	0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x09, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x4d, 0x61, 0x73, 0x6b, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x6b,
	0x65, 0x79, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x4b, 0x65, 0x79, 0x73, 0x22, 0x83, 0x02, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4d, 0x0a, 0x0c, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a,
	0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x4a, 0x6f, 0x62, 0x12, 0x2b, 0x0a, 0x0f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0d, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x49,
	0x64, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e,
	0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x58, 0x0a, 0x15, 0x47,
	0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xdf, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xc3, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x0d, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a,
	0x6f, 0x62, 0x52, 0x0c, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x33, 0x0a, 0x15, 0x75, 0x6e, 0x72, 0x65,
	0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x14, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x61, 0x62, 0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x5b, 0x0a,
	0x18, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a,
	0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a,
	0x23, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd3, 0x1c, 0x0a, 0x0b, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x08,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x03, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01,
	0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4e, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x43, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x2e, 0x54,
	0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x56,
	0x0a, 0x0b, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x64, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x4a, 0x6f, 0x62, 0x53, 0x70, 0x65, 0x63, 0x48, 0x00, 0x52, 0x0a, 0x69, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x56, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a,
	0x6f, 0x62, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x53, 0x70, 0x65, 0x63,
	0x48, 0x00, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x62,
	0x0a, 0x0d, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18,
	0xc8, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x2e, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x01, 0x52, 0x0c, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x62, 0x0a, 0x0d, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x18, 0xc9, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f,
	0x62, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x49, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x1a, 0xe4, 0x03, 0x0a, 0x0f, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x2c, 0x0a, 0x0f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64,
	0x5f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x65,
	0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0e, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x74,
	0x72, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0e, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12,
	0x30, 0x0a, 0x11, 0x75, 0x6e, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x74,
	0x72, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x10, 0x75, 0x6e, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65,
	0x73, 0x12, 0x30, 0x0a, 0x11, 0x72, 0x65, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x65,
	0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x10, 0x72, 0x65, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x33, 0x0a, 0x13, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64,
	0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x33, 0x0a, 0x13, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x6c, 0x69, 0x6e, 0x6b,
	0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12,
	0x37, 0x0a, 0x15, 0x75, 0x6e, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x13, 0x75, 0x6e, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x1a, 0x6b, 0x0a, 0x0f, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x2e, 0x0a, 0x10, 0x65,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x65, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x1a, 0xe3, 0x08, 0x0a, 0x0d, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x4a, 0x6f, 0x62, 0x53, 0x70, 0x65, 0x63, 0x12, 0x31, 0x0a, 0x12, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x55, 0x72, 0x69, 0x12, 0x4d, 0x0a, 0x12, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5d, 0x0a, 0x05, 0x73, 0x63, 0x6f,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x2e,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x69, 0x0a, 0x0f, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a,
	0x6f, 0x62, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x53, 0x79, 0x6e, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x53, 0x79, 0x6e, 0x63, 0x4d,
	0x6f, 0x64, 0x65, 0x12, 0x6b, 0x0a, 0x10, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x73, 0x79,
	0x6e, 0x63, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x4a, 0x6f, 0x62, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x53, 0x70,
	0x65, 0x63, 0x2e, 0x53, 0x79, 0x6e, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0e, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x53, 0x79, 0x6e, 0x63, 0x4d, 0x6f, 0x64, 0x65,
	0x12, 0x5e, 0x0a, 0x09, 0x6c, 0x6f, 0x67, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x4a, 0x6f, 0x62, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c,
	0x1a, 0xb0, 0x03, 0x0a, 0x0e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x53, 0x63,
	0x6f, 0x70, 0x65, 0x12, 0x4d, 0x0a, 0x0c, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x12, 0x4a, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x4d,
	0x0a, 0x0c, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x0b, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x48, 0x0a,
	0x0a, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x28, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x47, 0x6c, 0x6f, 0x73, 0x73, 0x61, 0x72, 0x79, 0x52, 0x0a, 0x67, 0x6c, 0x6f,
	0x73, 0x73, 0x61, 0x72, 0x69, 0x65, 0x73, 0x12, 0x2d, 0x0a, 0x10, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x6e,
	0x6b, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x17, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65,
	0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x53, 0x63, 0x6f,
	0x70, 0x65, 0x73, 0x22, 0x4a, 0x0a, 0x08, 0x53, 0x79, 0x6e, 0x63, 0x4d, 0x6f, 0x64, 0x65, 0x12,
	0x19, 0x0a, 0x15, 0x53, 0x59, 0x4e, 0x43, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x55,
	0x4c, 0x4c, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x43, 0x52, 0x45, 0x4d, 0x45, 0x4e,
	0x54, 0x41, 0x4c, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x03, 0x22,
	0x3a, 0x0a, 0x08, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x19, 0x0a, 0x15, 0x4c,
	0x4f, 0x47, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x45, 0x42, 0x55, 0x47, 0x10,
	0x01, 0x12, 0x08, 0x0a, 0x04, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x02, 0x1a, 0x85, 0x04, 0x0a, 0x0d,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5d, 0x0a,
	0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x4a, 0x6f, 0x62, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x53, 0x70, 0x65,
	0x63, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x53, 0x63, 0x6f, 0x70, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x24, 0x0a, 0x0b,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x50, 0x61,
	0x74, 0x68, 0x1a, 0xee, 0x02, 0x0a, 0x0e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62,
	0x53, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x11, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c,
	0x65, 0x76, 0x65, 0x6c, 0x12, 0x4c, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x30, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x12, 0x4a, 0x0a, 0x0c, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x27, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x52, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x47,
	0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x4a, 0x0a, 0x0c, 0x61, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x42, 0x27, 0xfa,
	0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x1a, 0xf9, 0x02, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x4d,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x4a, 0x6f, 0x62, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x32, 0x0a, 0x12,
	0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65,
	0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x63,
	0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x22, 0x8a, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x51, 0x55, 0x45, 0x55, 0x45, 0x44, 0x10, 0x01, 0x12,
	0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09,
	0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x43,
	0x41, 0x4e, 0x43, 0x45, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43,
	0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c,
	0x45, 0x44, 0x10, 0x06, 0x12, 0x19, 0x0a, 0x15, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45,
	0x44, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x53, 0x10, 0x07, 0x1a,
	0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x34, 0x0a, 0x04, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x49, 0x4d, 0x50, 0x4f,
	0x52, 0x54, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x45, 0x58, 0x50, 0x4f, 0x52, 0x54, 0x10, 0x02,
	0x3a, 0x6c, 0xea, 0x41, 0x69, 0x0a, 0x23, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x12, 0x42, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x73,
	0x2f, 0x7b, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x7d, 0x42, 0x06,
	0x0a, 0x04, 0x73, 0x70, 0x65, 0x63, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x22, 0xd2, 0x05, 0x0a, 0x09, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x43,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41,
	0x03, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x08, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x0f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x6c, 0x69, 0x6e,
	0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41,
	0x02, 0xe0, 0x41, 0x05, 0x52, 0x0d, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x62, 0x0a, 0x10, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x1a, 0xcb, 0x01, 0x0a, 0x0e,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x1a,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41,
	0x02, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x70,
	0x61, 0x74, 0x68, 0x12, 0x53, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x06, 0xe0, 0x41, 0x02, 0xe0,
	0x41, 0x05, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x2f, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x10, 0x02, 0x12, 0x0a, 0x0a,
	0x06, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x10, 0x03, 0x3a, 0x99, 0x01, 0xea, 0x41, 0x95, 0x01,
	0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4c,
	0x69, 0x6e, 0x6b, 0x12, 0x59, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b,
	0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x7d, 0x2a, 0x0a,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x32, 0x09, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0xce, 0x01, 0x0a, 0x16, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x42, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x27, 0x0a, 0x0d, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x49, 0x64, 0x12, 0x47, 0x0a,
	0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0x57, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x54, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x2a, 0x51, 0x0a, 0x09, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x56, 0x69,
	0x65, 0x77, 0x12, 0x1a, 0x0a, 0x16, 0x45, 0x4e, 0x54, 0x52, 0x59, 0x5f, 0x56, 0x49, 0x45, 0x57,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09,
	0x0a, 0x05, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x55, 0x4c,
	0x4c, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x10, 0x03, 0x12,
	0x07, 0x0a, 0x03, 0x41, 0x4c, 0x4c, 0x10, 0x04, 0x2a, 0x70, 0x0a, 0x0e, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1f, 0x0a, 0x1b, 0x54, 0x52,
	0x41, 0x4e, 0x53, 0x46, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x54,
	0x52, 0x41, 0x4e, 0x53, 0x46, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x4d,
	0x49, 0x47, 0x52, 0x41, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x1f, 0x0a, 0x1b, 0x54, 0x52, 0x41,
	0x4e, 0x53, 0x46, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x54, 0x52, 0x41,
	0x4e, 0x53, 0x46, 0x45, 0x52, 0x52, 0x45, 0x44, 0x10, 0x02, 0x32, 0xde, 0x2d, 0x0a, 0x0e, 0x43,
	0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xea, 0x01,
	0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x85, 0x01, 0xca, 0x41, 0x1e, 0x0a, 0x09, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2c, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x3a, 0x0a,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x2e, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x65, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0xec, 0x01, 0x0a, 0x0f, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x87, 0x01, 0xca, 0x41, 0x1e, 0x0a, 0x09, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x16, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x47, 0x3a, 0x0a, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x32, 0x39,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xce, 0x01, 0x0a, 0x0f, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6a,
	0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x2a, 0x2e, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb4, 0x01, 0x0a, 0x0e, 0x4c,
	0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x3f, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x30, 0x12, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x12, 0xa1, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x22, 0x3d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf1, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8a, 0x01, 0xca,
	0x41, 0x1f, 0x0a, 0x0a, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x61, 0x73, 0x70, 0x65, 0x63,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2c, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x3a, 0x0b, 0x61, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x73,
	0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0xf3, 0x01, 0x0a, 0x10, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x8c, 0x01, 0xca, 0x41, 0x1f, 0x0a, 0x0a, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x17, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x3a, 0x0b, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x32, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xd1, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6b, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x31, 0x2a, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xb8, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0xa5,
	0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x41, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x41,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x70, 0x65,
	0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x22, 0x3e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf1, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8a, 0x01,
	0xca, 0x41, 0x1f, 0x0a, 0x0a, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2c, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x3a, 0x0b, 0x65, 0x6e,
	0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0xf3, 0x01, 0x0a, 0x10, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x8c, 0x01, 0xca, 0x41, 0x1f, 0x0a, 0x0a, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x17, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x3a, 0x0b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x32, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xd1, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6b, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x31, 0x2a, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb8, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0xda,
	0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12,
	0xa5, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x3e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xbe, 0x01, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x22, 0x60, 0xda, 0x41, 0x15, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2c, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x69, 0x64,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x3a, 0x05, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x22, 0x39, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0xc1, 0x01, 0x0a, 0x0b, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x22, 0x63, 0xda, 0x41, 0x11, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x49, 0x3a, 0x05, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x32, 0x40, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a,
	0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2a, 0x7d, 0x12, 0xa7, 0x01, 0x0a,
	0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x22, 0x49, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x2a, 0x3a, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74,
	0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x2a, 0x7d, 0x12, 0xb6, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x45,
	0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x4a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12,
	0xa1, 0x01, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x22, 0x49, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x12, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f,
	0x2a, 0x2a, 0x7d, 0x12, 0x93, 0x01, 0x0a, 0x0b, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x22, 0x35, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6c, 0x6f,
	0x6f, 0x6b, 0x75, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0xb6, 0x01, 0x0a, 0x0d, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74,
	0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74,
	0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x44, 0xda, 0x41,
	0x0a, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x31, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74, 0x72, 0x69,
	0x65, 0x73, 0x12, 0xf8, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8f, 0x01, 0xca, 0x41,
	0x20, 0x0a, 0x0b, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x23, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x6a, 0x6f, 0x62, 0x2c, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x3a, 0x0c, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x6a, 0x6f, 0x62, 0x22, 0x30, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0xa9, 0x01,
	0x0a, 0x0e, 0x47, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62,
	0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x22, 0x3f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xbc, 0x01, 0x0a, 0x10, 0x4c, 0x69,
	0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0xaa, 0x01, 0x0a, 0x11, 0x43, 0x61, 0x6e,
	0x63, 0x65, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x12, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x49, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x3a, 0x01, 0x2a, 0x22, 0x37, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63,
	0x61, 0x6e, 0x63, 0x65, 0x6c, 0x12, 0xdc, 0x01, 0x0a, 0x0f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65,
	0x78, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b,
	0x22, 0x72, 0xda, 0x41, 0x1f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x2c, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x6c, 0x69, 0x6e,
	0x6b, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x3a, 0x0a, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x22, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x12, 0xb5, 0x01, 0x0a, 0x0f, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4c,
	0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x22,
	0x4b, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x2a, 0x3c,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x2f, 0x65,
	0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xaf, 0x01, 0x0a,
	0x0c, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x6e,
	0x6b, 0x22, 0x4b, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e,
	0x12, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a,
	0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x4b,
	0xca, 0x41, 0x17, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xbc, 0x01, 0x0a, 0x1c,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x76, 0x31, 0x42, 0x0c, 0x43, 0x61,
	0x74, 0x61, 0x6c, 0x6f, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x6c, 0x65, 0x78, 0x70, 0x62, 0xaa, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x2e, 0x56,
	0x31, 0xca, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x44, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1b, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x61,
	0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_dataplex_v1_catalog_proto_rawDescOnce sync.Once
	file_google_cloud_dataplex_v1_catalog_proto_rawDescData = file_google_cloud_dataplex_v1_catalog_proto_rawDesc
)

func file_google_cloud_dataplex_v1_catalog_proto_rawDescGZIP() []byte {
	file_google_cloud_dataplex_v1_catalog_proto_rawDescOnce.Do(func() {
		file_google_cloud_dataplex_v1_catalog_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dataplex_v1_catalog_proto_rawDescData)
	})
	return file_google_cloud_dataplex_v1_catalog_proto_rawDescData
}

var file_google_cloud_dataplex_v1_catalog_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_google_cloud_dataplex_v1_catalog_proto_msgTypes = make([]protoimpl.MessageInfo, 69)
var file_google_cloud_dataplex_v1_catalog_proto_goTypes = []any{
	(EntryView)(0),                                  // 0: google.cloud.dataplex.v1.EntryView
	(TransferStatus)(0),                             // 1: google.cloud.dataplex.v1.TransferStatus
	(AspectType_DataClassification)(0),              // 2: google.cloud.dataplex.v1.AspectType.DataClassification
	(MetadataJob_Type)(0),                           // 3: google.cloud.dataplex.v1.MetadataJob.Type
	(MetadataJob_ImportJobSpec_SyncMode)(0),         // 4: google.cloud.dataplex.v1.MetadataJob.ImportJobSpec.SyncMode
	(MetadataJob_ImportJobSpec_LogLevel)(0),         // 5: google.cloud.dataplex.v1.MetadataJob.ImportJobSpec.LogLevel
	(MetadataJob_Status_State)(0),                   // 6: google.cloud.dataplex.v1.MetadataJob.Status.State
	(EntryLink_EntryReference_Type)(0),              // 7: google.cloud.dataplex.v1.EntryLink.EntryReference.Type
	(*AspectType)(nil),                              // 8: google.cloud.dataplex.v1.AspectType
	(*EntryGroup)(nil),                              // 9: google.cloud.dataplex.v1.EntryGroup
	(*EntryType)(nil),                               // 10: google.cloud.dataplex.v1.EntryType
	(*Aspect)(nil),                                  // 11: google.cloud.dataplex.v1.Aspect
	(*AspectSource)(nil),                            // 12: google.cloud.dataplex.v1.AspectSource
	(*Entry)(nil),                                   // 13: google.cloud.dataplex.v1.Entry
	(*EntrySource)(nil),                             // 14: google.cloud.dataplex.v1.EntrySource
	(*CreateEntryGroupRequest)(nil),                 // 15: google.cloud.dataplex.v1.CreateEntryGroupRequest
	(*UpdateEntryGroupRequest)(nil),                 // 16: google.cloud.dataplex.v1.UpdateEntryGroupRequest
	(*DeleteEntryGroupRequest)(nil),                 // 17: google.cloud.dataplex.v1.DeleteEntryGroupRequest
	(*ListEntryGroupsRequest)(nil),                  // 18: google.cloud.dataplex.v1.ListEntryGroupsRequest
	(*ListEntryGroupsResponse)(nil),                 // 19: google.cloud.dataplex.v1.ListEntryGroupsResponse
	(*GetEntryGroupRequest)(nil),                    // 20: google.cloud.dataplex.v1.GetEntryGroupRequest
	(*CreateEntryTypeRequest)(nil),                  // 21: google.cloud.dataplex.v1.CreateEntryTypeRequest
	(*UpdateEntryTypeRequest)(nil),                  // 22: google.cloud.dataplex.v1.UpdateEntryTypeRequest
	(*DeleteEntryTypeRequest)(nil),                  // 23: google.cloud.dataplex.v1.DeleteEntryTypeRequest
	(*ListEntryTypesRequest)(nil),                   // 24: google.cloud.dataplex.v1.ListEntryTypesRequest
	(*ListEntryTypesResponse)(nil),                  // 25: google.cloud.dataplex.v1.ListEntryTypesResponse
	(*GetEntryTypeRequest)(nil),                     // 26: google.cloud.dataplex.v1.GetEntryTypeRequest
	(*CreateAspectTypeRequest)(nil),                 // 27: google.cloud.dataplex.v1.CreateAspectTypeRequest
	(*UpdateAspectTypeRequest)(nil),                 // 28: google.cloud.dataplex.v1.UpdateAspectTypeRequest
	(*DeleteAspectTypeRequest)(nil),                 // 29: google.cloud.dataplex.v1.DeleteAspectTypeRequest
	(*ListAspectTypesRequest)(nil),                  // 30: google.cloud.dataplex.v1.ListAspectTypesRequest
	(*ListAspectTypesResponse)(nil),                 // 31: google.cloud.dataplex.v1.ListAspectTypesResponse
	(*GetAspectTypeRequest)(nil),                    // 32: google.cloud.dataplex.v1.GetAspectTypeRequest
	(*CreateEntryRequest)(nil),                      // 33: google.cloud.dataplex.v1.CreateEntryRequest
	(*UpdateEntryRequest)(nil),                      // 34: google.cloud.dataplex.v1.UpdateEntryRequest
	(*DeleteEntryRequest)(nil),                      // 35: google.cloud.dataplex.v1.DeleteEntryRequest
	(*ListEntriesRequest)(nil),                      // 36: google.cloud.dataplex.v1.ListEntriesRequest
	(*ListEntriesResponse)(nil),                     // 37: google.cloud.dataplex.v1.ListEntriesResponse
	(*GetEntryRequest)(nil),                         // 38: google.cloud.dataplex.v1.GetEntryRequest
	(*LookupEntryRequest)(nil),                      // 39: google.cloud.dataplex.v1.LookupEntryRequest
	(*SearchEntriesRequest)(nil),                    // 40: google.cloud.dataplex.v1.SearchEntriesRequest
	(*SearchEntriesResult)(nil),                     // 41: google.cloud.dataplex.v1.SearchEntriesResult
	(*SearchEntriesResponse)(nil),                   // 42: google.cloud.dataplex.v1.SearchEntriesResponse
	(*ImportItem)(nil),                              // 43: google.cloud.dataplex.v1.ImportItem
	(*CreateMetadataJobRequest)(nil),                // 44: google.cloud.dataplex.v1.CreateMetadataJobRequest
	(*GetMetadataJobRequest)(nil),                   // 45: google.cloud.dataplex.v1.GetMetadataJobRequest
	(*ListMetadataJobsRequest)(nil),                 // 46: google.cloud.dataplex.v1.ListMetadataJobsRequest
	(*ListMetadataJobsResponse)(nil),                // 47: google.cloud.dataplex.v1.ListMetadataJobsResponse
	(*CancelMetadataJobRequest)(nil),                // 48: google.cloud.dataplex.v1.CancelMetadataJobRequest
	(*MetadataJob)(nil),                             // 49: google.cloud.dataplex.v1.MetadataJob
	(*EntryLink)(nil),                               // 50: google.cloud.dataplex.v1.EntryLink
	(*CreateEntryLinkRequest)(nil),                  // 51: google.cloud.dataplex.v1.CreateEntryLinkRequest
	(*DeleteEntryLinkRequest)(nil),                  // 52: google.cloud.dataplex.v1.DeleteEntryLinkRequest
	(*GetEntryLinkRequest)(nil),                     // 53: google.cloud.dataplex.v1.GetEntryLinkRequest
	(*AspectType_Authorization)(nil),                // 54: google.cloud.dataplex.v1.AspectType.Authorization
	(*AspectType_MetadataTemplate)(nil),             // 55: google.cloud.dataplex.v1.AspectType.MetadataTemplate
	nil,                                             // 56: google.cloud.dataplex.v1.AspectType.LabelsEntry
	(*AspectType_MetadataTemplate_EnumValue)(nil),   // 57: google.cloud.dataplex.v1.AspectType.MetadataTemplate.EnumValue
	(*AspectType_MetadataTemplate_Constraints)(nil), // 58: google.cloud.dataplex.v1.AspectType.MetadataTemplate.Constraints
	(*AspectType_MetadataTemplate_Annotations)(nil), // 59: google.cloud.dataplex.v1.AspectType.MetadataTemplate.Annotations
	nil,                                  // 60: google.cloud.dataplex.v1.EntryGroup.LabelsEntry
	(*EntryType_AspectInfo)(nil),         // 61: google.cloud.dataplex.v1.EntryType.AspectInfo
	(*EntryType_Authorization)(nil),      // 62: google.cloud.dataplex.v1.EntryType.Authorization
	nil,                                  // 63: google.cloud.dataplex.v1.EntryType.LabelsEntry
	nil,                                  // 64: google.cloud.dataplex.v1.Entry.AspectsEntry
	(*EntrySource_Ancestor)(nil),         // 65: google.cloud.dataplex.v1.EntrySource.Ancestor
	nil,                                  // 66: google.cloud.dataplex.v1.EntrySource.LabelsEntry
	(*SearchEntriesResult_Snippets)(nil), // 67: google.cloud.dataplex.v1.SearchEntriesResult.Snippets
	(*MetadataJob_ImportJobResult)(nil),  // 68: google.cloud.dataplex.v1.MetadataJob.ImportJobResult
	(*MetadataJob_ExportJobResult)(nil),  // 69: google.cloud.dataplex.v1.MetadataJob.ExportJobResult
	(*MetadataJob_ImportJobSpec)(nil),    // 70: google.cloud.dataplex.v1.MetadataJob.ImportJobSpec
	(*MetadataJob_ExportJobSpec)(nil),    // 71: google.cloud.dataplex.v1.MetadataJob.ExportJobSpec
	(*MetadataJob_Status)(nil),           // 72: google.cloud.dataplex.v1.MetadataJob.Status
	nil,                                  // 73: google.cloud.dataplex.v1.MetadataJob.LabelsEntry
	(*MetadataJob_ImportJobSpec_ImportJobScope)(nil), // 74: google.cloud.dataplex.v1.MetadataJob.ImportJobSpec.ImportJobScope
	(*MetadataJob_ExportJobSpec_ExportJobScope)(nil), // 75: google.cloud.dataplex.v1.MetadataJob.ExportJobSpec.ExportJobScope
	(*EntryLink_EntryReference)(nil),                 // 76: google.cloud.dataplex.v1.EntryLink.EntryReference
	(*timestamppb.Timestamp)(nil),                    // 77: google.protobuf.Timestamp
	(*structpb.Struct)(nil),                          // 78: google.protobuf.Struct
	(*fieldmaskpb.FieldMask)(nil),                    // 79: google.protobuf.FieldMask
	(*longrunningpb.Operation)(nil),                  // 80: google.longrunning.Operation
	(*emptypb.Empty)(nil),                            // 81: google.protobuf.Empty
}
var file_google_cloud_dataplex_v1_catalog_proto_depIdxs = []int32{
	77,  // 0: google.cloud.dataplex.v1.AspectType.create_time:type_name -> google.protobuf.Timestamp
	77,  // 1: google.cloud.dataplex.v1.AspectType.update_time:type_name -> google.protobuf.Timestamp
	56,  // 2: google.cloud.dataplex.v1.AspectType.labels:type_name -> google.cloud.dataplex.v1.AspectType.LabelsEntry
	2,   // 3: google.cloud.dataplex.v1.AspectType.data_classification:type_name -> google.cloud.dataplex.v1.AspectType.DataClassification
	54,  // 4: google.cloud.dataplex.v1.AspectType.authorization:type_name -> google.cloud.dataplex.v1.AspectType.Authorization
	55,  // 5: google.cloud.dataplex.v1.AspectType.metadata_template:type_name -> google.cloud.dataplex.v1.AspectType.MetadataTemplate
	1,   // 6: google.cloud.dataplex.v1.AspectType.transfer_status:type_name -> google.cloud.dataplex.v1.TransferStatus
	77,  // 7: google.cloud.dataplex.v1.EntryGroup.create_time:type_name -> google.protobuf.Timestamp
	77,  // 8: google.cloud.dataplex.v1.EntryGroup.update_time:type_name -> google.protobuf.Timestamp
	60,  // 9: google.cloud.dataplex.v1.EntryGroup.labels:type_name -> google.cloud.dataplex.v1.EntryGroup.LabelsEntry
	1,   // 10: google.cloud.dataplex.v1.EntryGroup.transfer_status:type_name -> google.cloud.dataplex.v1.TransferStatus
	77,  // 11: google.cloud.dataplex.v1.EntryType.create_time:type_name -> google.protobuf.Timestamp
	77,  // 12: google.cloud.dataplex.v1.EntryType.update_time:type_name -> google.protobuf.Timestamp
	63,  // 13: google.cloud.dataplex.v1.EntryType.labels:type_name -> google.cloud.dataplex.v1.EntryType.LabelsEntry
	61,  // 14: google.cloud.dataplex.v1.EntryType.required_aspects:type_name -> google.cloud.dataplex.v1.EntryType.AspectInfo
	62,  // 15: google.cloud.dataplex.v1.EntryType.authorization:type_name -> google.cloud.dataplex.v1.EntryType.Authorization
	77,  // 16: google.cloud.dataplex.v1.Aspect.create_time:type_name -> google.protobuf.Timestamp
	77,  // 17: google.cloud.dataplex.v1.Aspect.update_time:type_name -> google.protobuf.Timestamp
	78,  // 18: google.cloud.dataplex.v1.Aspect.data:type_name -> google.protobuf.Struct
	12,  // 19: google.cloud.dataplex.v1.Aspect.aspect_source:type_name -> google.cloud.dataplex.v1.AspectSource
	77,  // 20: google.cloud.dataplex.v1.AspectSource.create_time:type_name -> google.protobuf.Timestamp
	77,  // 21: google.cloud.dataplex.v1.AspectSource.update_time:type_name -> google.protobuf.Timestamp
	77,  // 22: google.cloud.dataplex.v1.Entry.create_time:type_name -> google.protobuf.Timestamp
	77,  // 23: google.cloud.dataplex.v1.Entry.update_time:type_name -> google.protobuf.Timestamp
	64,  // 24: google.cloud.dataplex.v1.Entry.aspects:type_name -> google.cloud.dataplex.v1.Entry.AspectsEntry
	14,  // 25: google.cloud.dataplex.v1.Entry.entry_source:type_name -> google.cloud.dataplex.v1.EntrySource
	66,  // 26: google.cloud.dataplex.v1.EntrySource.labels:type_name -> google.cloud.dataplex.v1.EntrySource.LabelsEntry
	65,  // 27: google.cloud.dataplex.v1.EntrySource.ancestors:type_name -> google.cloud.dataplex.v1.EntrySource.Ancestor
	77,  // 28: google.cloud.dataplex.v1.EntrySource.create_time:type_name -> google.protobuf.Timestamp
	77,  // 29: google.cloud.dataplex.v1.EntrySource.update_time:type_name -> google.protobuf.Timestamp
	9,   // 30: google.cloud.dataplex.v1.CreateEntryGroupRequest.entry_group:type_name -> google.cloud.dataplex.v1.EntryGroup
	9,   // 31: google.cloud.dataplex.v1.UpdateEntryGroupRequest.entry_group:type_name -> google.cloud.dataplex.v1.EntryGroup
	79,  // 32: google.cloud.dataplex.v1.UpdateEntryGroupRequest.update_mask:type_name -> google.protobuf.FieldMask
	9,   // 33: google.cloud.dataplex.v1.ListEntryGroupsResponse.entry_groups:type_name -> google.cloud.dataplex.v1.EntryGroup
	10,  // 34: google.cloud.dataplex.v1.CreateEntryTypeRequest.entry_type:type_name -> google.cloud.dataplex.v1.EntryType
	10,  // 35: google.cloud.dataplex.v1.UpdateEntryTypeRequest.entry_type:type_name -> google.cloud.dataplex.v1.EntryType
	79,  // 36: google.cloud.dataplex.v1.UpdateEntryTypeRequest.update_mask:type_name -> google.protobuf.FieldMask
	10,  // 37: google.cloud.dataplex.v1.ListEntryTypesResponse.entry_types:type_name -> google.cloud.dataplex.v1.EntryType
	8,   // 38: google.cloud.dataplex.v1.CreateAspectTypeRequest.aspect_type:type_name -> google.cloud.dataplex.v1.AspectType
	8,   // 39: google.cloud.dataplex.v1.UpdateAspectTypeRequest.aspect_type:type_name -> google.cloud.dataplex.v1.AspectType
	79,  // 40: google.cloud.dataplex.v1.UpdateAspectTypeRequest.update_mask:type_name -> google.protobuf.FieldMask
	8,   // 41: google.cloud.dataplex.v1.ListAspectTypesResponse.aspect_types:type_name -> google.cloud.dataplex.v1.AspectType
	13,  // 42: google.cloud.dataplex.v1.CreateEntryRequest.entry:type_name -> google.cloud.dataplex.v1.Entry
	13,  // 43: google.cloud.dataplex.v1.UpdateEntryRequest.entry:type_name -> google.cloud.dataplex.v1.Entry
	79,  // 44: google.cloud.dataplex.v1.UpdateEntryRequest.update_mask:type_name -> google.protobuf.FieldMask
	13,  // 45: google.cloud.dataplex.v1.ListEntriesResponse.entries:type_name -> google.cloud.dataplex.v1.Entry
	0,   // 46: google.cloud.dataplex.v1.GetEntryRequest.view:type_name -> google.cloud.dataplex.v1.EntryView
	0,   // 47: google.cloud.dataplex.v1.LookupEntryRequest.view:type_name -> google.cloud.dataplex.v1.EntryView
	13,  // 48: google.cloud.dataplex.v1.SearchEntriesResult.dataplex_entry:type_name -> google.cloud.dataplex.v1.Entry
	67,  // 49: google.cloud.dataplex.v1.SearchEntriesResult.snippets:type_name -> google.cloud.dataplex.v1.SearchEntriesResult.Snippets
	41,  // 50: google.cloud.dataplex.v1.SearchEntriesResponse.results:type_name -> google.cloud.dataplex.v1.SearchEntriesResult
	13,  // 51: google.cloud.dataplex.v1.ImportItem.entry:type_name -> google.cloud.dataplex.v1.Entry
	50,  // 52: google.cloud.dataplex.v1.ImportItem.entry_link:type_name -> google.cloud.dataplex.v1.EntryLink
	79,  // 53: google.cloud.dataplex.v1.ImportItem.update_mask:type_name -> google.protobuf.FieldMask
	49,  // 54: google.cloud.dataplex.v1.CreateMetadataJobRequest.metadata_job:type_name -> google.cloud.dataplex.v1.MetadataJob
	49,  // 55: google.cloud.dataplex.v1.ListMetadataJobsResponse.metadata_jobs:type_name -> google.cloud.dataplex.v1.MetadataJob
	77,  // 56: google.cloud.dataplex.v1.MetadataJob.create_time:type_name -> google.protobuf.Timestamp
	77,  // 57: google.cloud.dataplex.v1.MetadataJob.update_time:type_name -> google.protobuf.Timestamp
	73,  // 58: google.cloud.dataplex.v1.MetadataJob.labels:type_name -> google.cloud.dataplex.v1.MetadataJob.LabelsEntry
	3,   // 59: google.cloud.dataplex.v1.MetadataJob.type:type_name -> google.cloud.dataplex.v1.MetadataJob.Type
	70,  // 60: google.cloud.dataplex.v1.MetadataJob.import_spec:type_name -> google.cloud.dataplex.v1.MetadataJob.ImportJobSpec
	71,  // 61: google.cloud.dataplex.v1.MetadataJob.export_spec:type_name -> google.cloud.dataplex.v1.MetadataJob.ExportJobSpec
	68,  // 62: google.cloud.dataplex.v1.MetadataJob.import_result:type_name -> google.cloud.dataplex.v1.MetadataJob.ImportJobResult
	69,  // 63: google.cloud.dataplex.v1.MetadataJob.export_result:type_name -> google.cloud.dataplex.v1.MetadataJob.ExportJobResult
	72,  // 64: google.cloud.dataplex.v1.MetadataJob.status:type_name -> google.cloud.dataplex.v1.MetadataJob.Status
	77,  // 65: google.cloud.dataplex.v1.EntryLink.create_time:type_name -> google.protobuf.Timestamp
	77,  // 66: google.cloud.dataplex.v1.EntryLink.update_time:type_name -> google.protobuf.Timestamp
	76,  // 67: google.cloud.dataplex.v1.EntryLink.entry_references:type_name -> google.cloud.dataplex.v1.EntryLink.EntryReference
	50,  // 68: google.cloud.dataplex.v1.CreateEntryLinkRequest.entry_link:type_name -> google.cloud.dataplex.v1.EntryLink
	55,  // 69: google.cloud.dataplex.v1.AspectType.MetadataTemplate.record_fields:type_name -> google.cloud.dataplex.v1.AspectType.MetadataTemplate
	57,  // 70: google.cloud.dataplex.v1.AspectType.MetadataTemplate.enum_values:type_name -> google.cloud.dataplex.v1.AspectType.MetadataTemplate.EnumValue
	55,  // 71: google.cloud.dataplex.v1.AspectType.MetadataTemplate.map_items:type_name -> google.cloud.dataplex.v1.AspectType.MetadataTemplate
	55,  // 72: google.cloud.dataplex.v1.AspectType.MetadataTemplate.array_items:type_name -> google.cloud.dataplex.v1.AspectType.MetadataTemplate
	58,  // 73: google.cloud.dataplex.v1.AspectType.MetadataTemplate.constraints:type_name -> google.cloud.dataplex.v1.AspectType.MetadataTemplate.Constraints
	59,  // 74: google.cloud.dataplex.v1.AspectType.MetadataTemplate.annotations:type_name -> google.cloud.dataplex.v1.AspectType.MetadataTemplate.Annotations
	11,  // 75: google.cloud.dataplex.v1.Entry.AspectsEntry.value:type_name -> google.cloud.dataplex.v1.Aspect
	13,  // 76: google.cloud.dataplex.v1.SearchEntriesResult.Snippets.dataplex_entry:type_name -> google.cloud.dataplex.v1.Entry
	77,  // 77: google.cloud.dataplex.v1.MetadataJob.ImportJobResult.update_time:type_name -> google.protobuf.Timestamp
	77,  // 78: google.cloud.dataplex.v1.MetadataJob.ImportJobSpec.source_create_time:type_name -> google.protobuf.Timestamp
	74,  // 79: google.cloud.dataplex.v1.MetadataJob.ImportJobSpec.scope:type_name -> google.cloud.dataplex.v1.MetadataJob.ImportJobSpec.ImportJobScope
	4,   // 80: google.cloud.dataplex.v1.MetadataJob.ImportJobSpec.entry_sync_mode:type_name -> google.cloud.dataplex.v1.MetadataJob.ImportJobSpec.SyncMode
	4,   // 81: google.cloud.dataplex.v1.MetadataJob.ImportJobSpec.aspect_sync_mode:type_name -> google.cloud.dataplex.v1.MetadataJob.ImportJobSpec.SyncMode
	5,   // 82: google.cloud.dataplex.v1.MetadataJob.ImportJobSpec.log_level:type_name -> google.cloud.dataplex.v1.MetadataJob.ImportJobSpec.LogLevel
	75,  // 83: google.cloud.dataplex.v1.MetadataJob.ExportJobSpec.scope:type_name -> google.cloud.dataplex.v1.MetadataJob.ExportJobSpec.ExportJobScope
	6,   // 84: google.cloud.dataplex.v1.MetadataJob.Status.state:type_name -> google.cloud.dataplex.v1.MetadataJob.Status.State
	77,  // 85: google.cloud.dataplex.v1.MetadataJob.Status.update_time:type_name -> google.protobuf.Timestamp
	7,   // 86: google.cloud.dataplex.v1.EntryLink.EntryReference.type:type_name -> google.cloud.dataplex.v1.EntryLink.EntryReference.Type
	21,  // 87: google.cloud.dataplex.v1.CatalogService.CreateEntryType:input_type -> google.cloud.dataplex.v1.CreateEntryTypeRequest
	22,  // 88: google.cloud.dataplex.v1.CatalogService.UpdateEntryType:input_type -> google.cloud.dataplex.v1.UpdateEntryTypeRequest
	23,  // 89: google.cloud.dataplex.v1.CatalogService.DeleteEntryType:input_type -> google.cloud.dataplex.v1.DeleteEntryTypeRequest
	24,  // 90: google.cloud.dataplex.v1.CatalogService.ListEntryTypes:input_type -> google.cloud.dataplex.v1.ListEntryTypesRequest
	26,  // 91: google.cloud.dataplex.v1.CatalogService.GetEntryType:input_type -> google.cloud.dataplex.v1.GetEntryTypeRequest
	27,  // 92: google.cloud.dataplex.v1.CatalogService.CreateAspectType:input_type -> google.cloud.dataplex.v1.CreateAspectTypeRequest
	28,  // 93: google.cloud.dataplex.v1.CatalogService.UpdateAspectType:input_type -> google.cloud.dataplex.v1.UpdateAspectTypeRequest
	29,  // 94: google.cloud.dataplex.v1.CatalogService.DeleteAspectType:input_type -> google.cloud.dataplex.v1.DeleteAspectTypeRequest
	30,  // 95: google.cloud.dataplex.v1.CatalogService.ListAspectTypes:input_type -> google.cloud.dataplex.v1.ListAspectTypesRequest
	32,  // 96: google.cloud.dataplex.v1.CatalogService.GetAspectType:input_type -> google.cloud.dataplex.v1.GetAspectTypeRequest
	15,  // 97: google.cloud.dataplex.v1.CatalogService.CreateEntryGroup:input_type -> google.cloud.dataplex.v1.CreateEntryGroupRequest
	16,  // 98: google.cloud.dataplex.v1.CatalogService.UpdateEntryGroup:input_type -> google.cloud.dataplex.v1.UpdateEntryGroupRequest
	17,  // 99: google.cloud.dataplex.v1.CatalogService.DeleteEntryGroup:input_type -> google.cloud.dataplex.v1.DeleteEntryGroupRequest
	18,  // 100: google.cloud.dataplex.v1.CatalogService.ListEntryGroups:input_type -> google.cloud.dataplex.v1.ListEntryGroupsRequest
	20,  // 101: google.cloud.dataplex.v1.CatalogService.GetEntryGroup:input_type -> google.cloud.dataplex.v1.GetEntryGroupRequest
	33,  // 102: google.cloud.dataplex.v1.CatalogService.CreateEntry:input_type -> google.cloud.dataplex.v1.CreateEntryRequest
	34,  // 103: google.cloud.dataplex.v1.CatalogService.UpdateEntry:input_type -> google.cloud.dataplex.v1.UpdateEntryRequest
	35,  // 104: google.cloud.dataplex.v1.CatalogService.DeleteEntry:input_type -> google.cloud.dataplex.v1.DeleteEntryRequest
	36,  // 105: google.cloud.dataplex.v1.CatalogService.ListEntries:input_type -> google.cloud.dataplex.v1.ListEntriesRequest
	38,  // 106: google.cloud.dataplex.v1.CatalogService.GetEntry:input_type -> google.cloud.dataplex.v1.GetEntryRequest
	39,  // 107: google.cloud.dataplex.v1.CatalogService.LookupEntry:input_type -> google.cloud.dataplex.v1.LookupEntryRequest
	40,  // 108: google.cloud.dataplex.v1.CatalogService.SearchEntries:input_type -> google.cloud.dataplex.v1.SearchEntriesRequest
	44,  // 109: google.cloud.dataplex.v1.CatalogService.CreateMetadataJob:input_type -> google.cloud.dataplex.v1.CreateMetadataJobRequest
	45,  // 110: google.cloud.dataplex.v1.CatalogService.GetMetadataJob:input_type -> google.cloud.dataplex.v1.GetMetadataJobRequest
	46,  // 111: google.cloud.dataplex.v1.CatalogService.ListMetadataJobs:input_type -> google.cloud.dataplex.v1.ListMetadataJobsRequest
	48,  // 112: google.cloud.dataplex.v1.CatalogService.CancelMetadataJob:input_type -> google.cloud.dataplex.v1.CancelMetadataJobRequest
	51,  // 113: google.cloud.dataplex.v1.CatalogService.CreateEntryLink:input_type -> google.cloud.dataplex.v1.CreateEntryLinkRequest
	52,  // 114: google.cloud.dataplex.v1.CatalogService.DeleteEntryLink:input_type -> google.cloud.dataplex.v1.DeleteEntryLinkRequest
	53,  // 115: google.cloud.dataplex.v1.CatalogService.GetEntryLink:input_type -> google.cloud.dataplex.v1.GetEntryLinkRequest
	80,  // 116: google.cloud.dataplex.v1.CatalogService.CreateEntryType:output_type -> google.longrunning.Operation
	80,  // 117: google.cloud.dataplex.v1.CatalogService.UpdateEntryType:output_type -> google.longrunning.Operation
	80,  // 118: google.cloud.dataplex.v1.CatalogService.DeleteEntryType:output_type -> google.longrunning.Operation
	25,  // 119: google.cloud.dataplex.v1.CatalogService.ListEntryTypes:output_type -> google.cloud.dataplex.v1.ListEntryTypesResponse
	10,  // 120: google.cloud.dataplex.v1.CatalogService.GetEntryType:output_type -> google.cloud.dataplex.v1.EntryType
	80,  // 121: google.cloud.dataplex.v1.CatalogService.CreateAspectType:output_type -> google.longrunning.Operation
	80,  // 122: google.cloud.dataplex.v1.CatalogService.UpdateAspectType:output_type -> google.longrunning.Operation
	80,  // 123: google.cloud.dataplex.v1.CatalogService.DeleteAspectType:output_type -> google.longrunning.Operation
	31,  // 124: google.cloud.dataplex.v1.CatalogService.ListAspectTypes:output_type -> google.cloud.dataplex.v1.ListAspectTypesResponse
	8,   // 125: google.cloud.dataplex.v1.CatalogService.GetAspectType:output_type -> google.cloud.dataplex.v1.AspectType
	80,  // 126: google.cloud.dataplex.v1.CatalogService.CreateEntryGroup:output_type -> google.longrunning.Operation
	80,  // 127: google.cloud.dataplex.v1.CatalogService.UpdateEntryGroup:output_type -> google.longrunning.Operation
	80,  // 128: google.cloud.dataplex.v1.CatalogService.DeleteEntryGroup:output_type -> google.longrunning.Operation
	19,  // 129: google.cloud.dataplex.v1.CatalogService.ListEntryGroups:output_type -> google.cloud.dataplex.v1.ListEntryGroupsResponse
	9,   // 130: google.cloud.dataplex.v1.CatalogService.GetEntryGroup:output_type -> google.cloud.dataplex.v1.EntryGroup
	13,  // 131: google.cloud.dataplex.v1.CatalogService.CreateEntry:output_type -> google.cloud.dataplex.v1.Entry
	13,  // 132: google.cloud.dataplex.v1.CatalogService.UpdateEntry:output_type -> google.cloud.dataplex.v1.Entry
	13,  // 133: google.cloud.dataplex.v1.CatalogService.DeleteEntry:output_type -> google.cloud.dataplex.v1.Entry
	37,  // 134: google.cloud.dataplex.v1.CatalogService.ListEntries:output_type -> google.cloud.dataplex.v1.ListEntriesResponse
	13,  // 135: google.cloud.dataplex.v1.CatalogService.GetEntry:output_type -> google.cloud.dataplex.v1.Entry
	13,  // 136: google.cloud.dataplex.v1.CatalogService.LookupEntry:output_type -> google.cloud.dataplex.v1.Entry
	42,  // 137: google.cloud.dataplex.v1.CatalogService.SearchEntries:output_type -> google.cloud.dataplex.v1.SearchEntriesResponse
	80,  // 138: google.cloud.dataplex.v1.CatalogService.CreateMetadataJob:output_type -> google.longrunning.Operation
	49,  // 139: google.cloud.dataplex.v1.CatalogService.GetMetadataJob:output_type -> google.cloud.dataplex.v1.MetadataJob
	47,  // 140: google.cloud.dataplex.v1.CatalogService.ListMetadataJobs:output_type -> google.cloud.dataplex.v1.ListMetadataJobsResponse
	81,  // 141: google.cloud.dataplex.v1.CatalogService.CancelMetadataJob:output_type -> google.protobuf.Empty
	50,  // 142: google.cloud.dataplex.v1.CatalogService.CreateEntryLink:output_type -> google.cloud.dataplex.v1.EntryLink
	50,  // 143: google.cloud.dataplex.v1.CatalogService.DeleteEntryLink:output_type -> google.cloud.dataplex.v1.EntryLink
	50,  // 144: google.cloud.dataplex.v1.CatalogService.GetEntryLink:output_type -> google.cloud.dataplex.v1.EntryLink
	116, // [116:145] is the sub-list for method output_type
	87,  // [87:116] is the sub-list for method input_type
	87,  // [87:87] is the sub-list for extension type_name
	87,  // [87:87] is the sub-list for extension extendee
	0,   // [0:87] is the sub-list for field type_name
}

func init() { file_google_cloud_dataplex_v1_catalog_proto_init() }
func file_google_cloud_dataplex_v1_catalog_proto_init() {
	if File_google_cloud_dataplex_v1_catalog_proto != nil {
		return
	}
	file_google_cloud_dataplex_v1_service_proto_init()
	file_google_cloud_dataplex_v1_catalog_proto_msgTypes[41].OneofWrappers = []any{
		(*MetadataJob_ImportSpec)(nil),
		(*MetadataJob_ExportSpec)(nil),
		(*MetadataJob_ImportResult)(nil),
		(*MetadataJob_ExportResult)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dataplex_v1_catalog_proto_rawDesc,
			NumEnums:      8,
			NumMessages:   69,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dataplex_v1_catalog_proto_goTypes,
		DependencyIndexes: file_google_cloud_dataplex_v1_catalog_proto_depIdxs,
		EnumInfos:         file_google_cloud_dataplex_v1_catalog_proto_enumTypes,
		MessageInfos:      file_google_cloud_dataplex_v1_catalog_proto_msgTypes,
	}.Build()
	File_google_cloud_dataplex_v1_catalog_proto = out.File
	file_google_cloud_dataplex_v1_catalog_proto_rawDesc = nil
	file_google_cloud_dataplex_v1_catalog_proto_goTypes = nil
	file_google_cloud_dataplex_v1_catalog_proto_depIdxs = nil
}
