// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A complex type that contains the type of limit that you specified in the
// request and the current value for that limit.
type AccountLimit struct {

	// The limit that you requested. Valid values include the following:
	//
	//   - MAX_HEALTH_CHECKS_BY_OWNER: The maximum number of health checks that you
	//   can create using the current account.
	//
	//   - MAX_HOSTED_ZONES_BY_OWNER: The maximum number of hosted zones that you can
	//   create using the current account.
	//
	//   - MAX_REUSABLE_DELEGATION_SETS_BY_OWNER: The maximum number of reusable
	//   delegation sets that you can create using the current account.
	//
	//   - MAX_TRAFFIC_POLICIES_BY_OWNER: The maximum number of traffic policies that
	//   you can create using the current account.
	//
	//   - MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER: The maximum number of traffic policy
	//   instances that you can create using the current account. (Traffic policy
	//   instances are referred to as traffic flow policy records in the Amazon Route 53
	//   console.)
	//
	// This member is required.
	Type AccountLimitType

	// The current value for the limit that is specified by [Type].
	//
	// [Type]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_AccountLimit.html#Route53-Type-AccountLimit-Type
	//
	// This member is required.
	Value *int64

	noSmithyDocumentSerde
}

// A complex type that identifies the CloudWatch alarm that you want Amazon Route
// 53 health checkers to use to determine whether the specified health check is
// healthy.
type AlarmIdentifier struct {

	// The name of the CloudWatch alarm that you want Amazon Route 53 health checkers
	// to use to determine whether this health check is healthy.
	//
	// Route 53 supports CloudWatch alarms with the following features:
	//
	//   - Standard-resolution metrics. High-resolution metrics aren't supported. For
	//   more information, see [High-Resolution Metrics]in the Amazon CloudWatch User Guide.
	//
	//   - Statistics: Average, Minimum, Maximum, Sum, and SampleCount. Extended
	//   statistics aren't supported.
	//
	// [High-Resolution Metrics]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/publishingMetrics.html#high-resolution-metrics
	//
	// This member is required.
	Name *string

	// For the CloudWatch alarm that you want Route 53 health checkers to use to
	// determine whether this health check is healthy, the region that the alarm was
	// created in.
	//
	// For the current list of CloudWatch regions, see [Amazon CloudWatch endpoints and quotas] in the Amazon Web Services
	// General Reference.
	//
	// [Amazon CloudWatch endpoints and quotas]: https://docs.aws.amazon.com/general/latest/gr/cw_region.html
	//
	// This member is required.
	Region CloudWatchRegion

	noSmithyDocumentSerde
}

//	Alias resource record sets only: Information about the Amazon Web Services
//
// resource, such as a CloudFront distribution or an Amazon S3 bucket, that you
// want to route traffic to.
//
// When creating resource record sets for a private hosted zone, note the
// following:
//
//   - For information about creating failover resource record sets in a private
//     hosted zone, see [Configuring Failover in a Private Hosted Zone].
//
// [Configuring Failover in a Private Hosted Zone]: https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html
type AliasTarget struct {

	//  Alias resource record sets only: The value that you specify depends on where
	// you want to route queries:
	//
	// Amazon API Gateway custom regional APIs and edge-optimized APIs Specify the
	// applicable domain name for your API. You can get the applicable value using the
	// CLI command [get-domain-names]:
	//
	//   - For regional APIs, specify the value of regionalDomainName .
	//
	//   - For edge-optimized APIs, specify the value of distributionDomainName . This
	//   is the name of the associated CloudFront distribution, such as
	//   da1b2c3d4e5.cloudfront.net .
	//
	// The name of the record that you're creating must match a custom domain name for
	// your API, such as api.example.com .
	//
	// Amazon Virtual Private Cloud interface VPC endpoint Enter the API endpoint for
	// the interface endpoint, such as
	// vpce-123456789abcdef01-example-us-east-1a.elasticloadbalancing.us-east-1.vpce.amazonaws.com
	// . For edge-optimized APIs, this is the domain name for the corresponding
	// CloudFront distribution. You can get the value of DnsName using the CLI command [describe-vpc-endpoints]
	// .
	//
	// CloudFront distribution Specify the domain name that CloudFront assigned when
	// you created your distribution.
	//
	// Your CloudFront distribution must include an alternate domain name that matches
	// the name of the resource record set. For example, if the name of the resource
	// record set is acme.example.com, your CloudFront distribution must include
	// acme.example.com as one of the alternate domain names. For more information, see
	// [Using Alternate Domain Names (CNAMEs)]in the Amazon CloudFront Developer Guide.
	//
	// You can't create a resource record set in a private hosted zone to route
	// traffic to a CloudFront distribution.
	//
	// For failover alias records, you can't specify a CloudFront distribution for
	// both the primary and secondary records. A distribution must include an alternate
	// domain name that matches the name of the record. However, the primary and
	// secondary records have the same name, and you can't include the same alternate
	// domain name in more than one distribution.
	//
	// Elastic Beanstalk environment If the domain name for your Elastic Beanstalk
	// environment includes the region that you deployed the environment in, you can
	// create an alias record that routes traffic to the environment. For example, the
	// domain name my-environment.us-west-2.elasticbeanstalk.com is a regionalized
	// domain name.
	//
	// For environments that were created before early 2016, the domain name doesn't
	// include the region. To route traffic to these environments, you must create a
	// CNAME record instead of an alias record. Note that you can't create a CNAME
	// record for the root domain name. For example, if your domain name is
	// example.com, you can create a record that routes traffic for acme.example.com to
	// your Elastic Beanstalk environment, but you can't create a record that routes
	// traffic for example.com to your Elastic Beanstalk environment.
	//
	// For Elastic Beanstalk environments that have regionalized subdomains, specify
	// the CNAME attribute for the environment. You can use the following methods to
	// get the value of the CNAME attribute:
	//
	//   - Amazon Web Services Management Console: For information about how to get
	//   the value by using the console, see [Using Custom Domains with Elastic Beanstalk]in the Elastic Beanstalk Developer Guide.
	//
	//   - Elastic Beanstalk API: Use the DescribeEnvironments action to get the value
	//   of the CNAME attribute. For more information, see [DescribeEnvironments]in the Elastic Beanstalk
	//   API Reference.
	//
	//   - CLI: Use the describe-environments command to get the value of the CNAME
	//   attribute. For more information, see [describe-environments]in the CLI Command Reference.
	//
	// ELB load balancer Specify the DNS name that is associated with the load
	// balancer. Get the DNS name by using the Amazon Web Services Management Console,
	// the ELB API, or the CLI.
	//
	//   - Amazon Web Services Management Console: Go to the EC2 page, choose Load
	//   Balancers in the navigation pane, choose the load balancer, choose the
	//   Description tab, and get the value of the DNS name field.
	//
	// If you're routing traffic to a Classic Load Balancer, get the value that begins
	//   with dualstack. If you're routing traffic to another type of load balancer, get
	//   the value that applies to the record type, A or AAAA.
	//
	//   - Elastic Load Balancing API: Use DescribeLoadBalancers to get the value of
	//   DNSName . For more information, see the applicable guide:
	//
	//   - Classic Load Balancers: [DescribeLoadBalancers]
	//
	//   - Application and Network Load Balancers: [DescribeLoadBalancers]
	//
	//   - CLI: Use describe-load-balancers to get the value of DNSName . For more
	//   information, see the applicable guide:
	//
	//   - Classic Load Balancers: [describe-load-balancers]
	//
	//   - Application and Network Load Balancers: [describe-load-balancers]
	//
	// Global Accelerator accelerator Specify the DNS name for your accelerator:
	//
	//   - Global Accelerator API: To get the DNS name, use [DescribeAccelerator].
	//
	//   - CLI: To get the DNS name, use [describe-accelerator].
	//
	// Amazon S3 bucket that is configured as a static website Specify the domain name
	// of the Amazon S3 website endpoint that you created the bucket in, for example,
	// s3-website.us-east-2.amazonaws.com . For more information about valid values,
	// see the table [Amazon S3 Website Endpoints]in the Amazon Web Services General Reference. For more
	// information about using S3 buckets for websites, see [Getting Started with Amazon Route 53]in the Amazon Route 53
	// Developer Guide.
	//
	// Another Route 53 resource record set Specify the value of the Name element for
	// a resource record set in the current hosted zone.
	//
	// If you're creating an alias record that has the same name as the hosted zone
	// (known as the zone apex), you can't specify the domain name for a record for
	// which the value of Type is CNAME . This is because the alias record must have
	// the same type as the record that you're routing traffic to, and creating a CNAME
	// record for the zone apex isn't supported even for an alias record.
	//
	// [DescribeEnvironments]: https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeEnvironments.html
	// [describe-environments]: https://docs.aws.amazon.com/cli/latest/reference/elasticbeanstalk/describe-environments.html
	// [Getting Started with Amazon Route 53]: https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/getting-started.html
	// [describe-accelerator]: https://docs.aws.amazon.com/cli/latest/reference/globalaccelerator/describe-accelerator.html
	// [Amazon S3 Website Endpoints]: https://docs.aws.amazon.com/general/latest/gr/s3.html#s3_website_region_endpoints
	// [DescribeAccelerator]: https://docs.aws.amazon.com/global-accelerator/latest/api/API_DescribeAccelerator.html
	// [Using Custom Domains with Elastic Beanstalk]: https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/customdomains.html
	// [describe-load-balancers]: http://docs.aws.amazon.com/cli/latest/reference/elbv2/describe-load-balancers.html
	// [DescribeLoadBalancers]: https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html
	// [get-domain-names]: https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-domain-names.html
	// [Using Alternate Domain Names (CNAMEs)]: https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html
	// [describe-vpc-endpoints]: https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-vpc-endpoints.html
	//
	// This member is required.
	DNSName *string

	//  Applies only to alias, failover alias, geolocation alias, latency alias, and
	// weighted alias resource record sets: When EvaluateTargetHealth is true , an
	// alias resource record set inherits the health of the referenced Amazon Web
	// Services resource, such as an ELB load balancer or another resource record set
	// in the hosted zone.
	//
	// Note the following:
	//
	// CloudFront distributions You can't set EvaluateTargetHealth to true when the
	// alias target is a CloudFront distribution.
	//
	// Elastic Beanstalk environments that have regionalized subdomains If you specify
	// an Elastic Beanstalk environment in DNSName and the environment contains an ELB
	// load balancer, Elastic Load Balancing routes queries only to the healthy Amazon
	// EC2 instances that are registered with the load balancer. (An environment
	// automatically contains an ELB load balancer if it includes more than one Amazon
	// EC2 instance.) If you set EvaluateTargetHealth to true and either no Amazon EC2
	// instances are healthy or the load balancer itself is unhealthy, Route 53 routes
	// queries to other available resources that are healthy, if any.
	//
	// If the environment contains a single Amazon EC2 instance, there are no special
	// requirements.
	//
	// ELB load balancers Health checking behavior depends on the type of load
	// balancer:
	//
	//   - Classic Load Balancers: If you specify an ELB Classic Load Balancer in
	//   DNSName , Elastic Load Balancing routes queries only to the healthy Amazon EC2
	//   instances that are registered with the load balancer. If you set
	//   EvaluateTargetHealth to true and either no EC2 instances are healthy or the
	//   load balancer itself is unhealthy, Route 53 routes queries to other resources.
	//
	//   - Application and Network Load Balancers: If you specify an ELB Application
	//   or Network Load Balancer and you set EvaluateTargetHealth to true , Route 53
	//   routes queries to the load balancer based on the health of the target groups
	//   that are associated with the load balancer:
	//
	//   - For an Application or Network Load Balancer to be considered healthy, every
	//   target group that contains targets must contain at least one healthy target. If
	//   any target group contains only unhealthy targets, the load balancer is
	//   considered unhealthy, and Route 53 routes queries to other resources.
	//
	//   - A target group that has no registered targets is considered unhealthy.
	//
	// When you create a load balancer, you configure settings for Elastic Load
	// Balancing health checks; they're not Route 53 health checks, but they perform a
	// similar function. Do not create Route 53 health checks for the EC2 instances
	// that you register with an ELB load balancer.
	//
	// S3 buckets There are no special requirements for setting EvaluateTargetHealth
	// to true when the alias target is an S3 bucket.
	//
	// Other records in the same hosted zone If the Amazon Web Services resource that
	// you specify in DNSName is a record or a group of records (for example, a group
	// of weighted records) but is not another alias record, we recommend that you
	// associate a health check with all of the records in the alias target. For more
	// information, see [What Happens When You Omit Health Checks?]in the Amazon Route 53 Developer Guide.
	//
	// For more information and examples, see [Amazon Route 53 Health Checks and DNS Failover] in the Amazon Route 53 Developer Guide.
	//
	// [Amazon Route 53 Health Checks and DNS Failover]: https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html
	// [What Happens When You Omit Health Checks?]: https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-complex-configs.html#dns-failover-complex-configs-hc-omitting
	//
	// This member is required.
	EvaluateTargetHealth bool

	//  Alias resource records sets only: The value used depends on where you want to
	// route traffic:
	//
	// Amazon API Gateway custom regional APIs and edge-optimized APIs Specify the
	// hosted zone ID for your API. You can get the applicable value using the CLI
	// command [get-domain-names]:
	//
	//   - For regional APIs, specify the value of regionalHostedZoneId .
	//
	//   - For edge-optimized APIs, specify the value of distributionHostedZoneId .
	//
	// Amazon Virtual Private Cloud interface VPC endpoint Specify the hosted zone ID
	// for your interface endpoint. You can get the value of HostedZoneId using the
	// CLI command [describe-vpc-endpoints].
	//
	// CloudFront distribution Specify Z2FDTNDATAQYW2 .
	//
	// Alias resource record sets for CloudFront can't be created in a private zone.
	//
	// Elastic Beanstalk environment Specify the hosted zone ID for the region that
	// you created the environment in. The environment must have a regionalized
	// subdomain. For a list of regions and the corresponding hosted zone IDs, see [Elastic Beanstalk endpoints and quotas]in
	// the Amazon Web Services General Reference.
	//
	// ELB load balancer Specify the value of the hosted zone ID for the load
	// balancer. Use the following methods to get the hosted zone ID:
	//
	// [Elastic Load Balancing endpoints and quotas]
	//   - topic in the Amazon Web Services General Reference: Use the value that
	//   corresponds with the region that you created your load balancer in. Note that
	//   there are separate columns for Application and Classic Load Balancers and for
	//   Network Load Balancers.
	//
	//   - Amazon Web Services Management Console: Go to the Amazon EC2 page, choose
	//   Load Balancers in the navigation pane, select the load balancer, and get the
	//   value of the Hosted zone field on the Description tab.
	//
	//   - Elastic Load Balancing API: Use DescribeLoadBalancers to get the applicable
	//   value. For more information, see the applicable guide:
	//
	//   - Classic Load Balancers: Use [DescribeLoadBalancers]to get the value of CanonicalHostedZoneNameId .
	//
	//   - Application and Network Load Balancers: Use [DescribeLoadBalancers]to get the value of
	//   CanonicalHostedZoneId .
	//
	//   - CLI: Use describe-load-balancers to get the applicable value. For more
	//   information, see the applicable guide:
	//
	//   - Classic Load Balancers: Use [describe-load-balancers]to get the value of CanonicalHostedZoneNameId .
	//
	//   - Application and Network Load Balancers: Use [describe-load-balancers]to get the value of
	//   CanonicalHostedZoneId .
	//
	// Global Accelerator accelerator Specify Z2BJ6XQ5FK7U4H .
	//
	// An Amazon S3 bucket configured as a static website Specify the hosted zone ID
	// for the region that you created the bucket in. For more information about valid
	// values, see the table [Amazon S3 Website Endpoints]in the Amazon Web Services General Reference.
	//
	// Another Route 53 resource record set in your hosted zone Specify the hosted
	// zone ID of your hosted zone. (An alias resource record set can't reference a
	// resource record set in a different hosted zone.)
	//
	// [Amazon S3 Website Endpoints]: https://docs.aws.amazon.com/general/latest/gr/s3.html#s3_website_region_endpoints
	// [describe-load-balancers]: http://docs.aws.amazon.com/cli/latest/reference/elbv2/describe-load-balancers.html
	// [DescribeLoadBalancers]: https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html
	// [Elastic Beanstalk endpoints and quotas]: https://docs.aws.amazon.com/general/latest/gr/elasticbeanstalk.html
	// [get-domain-names]: https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-domain-names.html
	// [describe-vpc-endpoints]: https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-vpc-endpoints.html
	// [Elastic Load Balancing endpoints and quotas]: https://docs.aws.amazon.com/general/latest/gr/elb.html
	//
	// This member is required.
	HostedZoneId *string

	noSmithyDocumentSerde
}

// The information for each resource record set that you want to change.
type Change struct {

	// The action to perform:
	//
	//   - CREATE : Creates a resource record set that has the specified values.
	//
	//   - DELETE : Deletes a existing resource record set.
	//
	// To delete the resource record set that is associated with a traffic policy
	//   instance, use [DeleteTrafficPolicyInstance]. Amazon Route 53 will delete the resource record set
	//   automatically. If you delete the resource record set by using
	//   ChangeResourceRecordSets , Route 53 doesn't automatically delete the traffic
	//   policy instance, and you'll continue to be charged for it even though it's no
	//   longer in use.
	//
	//   - UPSERT : If a resource record set doesn't already exist, Route 53 creates
	//   it. If a resource record set does exist, Route 53 updates it with the values in
	//   the request.
	//
	// [DeleteTrafficPolicyInstance]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicyInstance.html
	//
	// This member is required.
	Action ChangeAction

	// Information about the resource record set to create, delete, or update.
	//
	// This member is required.
	ResourceRecordSet *ResourceRecordSet

	noSmithyDocumentSerde
}

// The information for a change request.
type ChangeBatch struct {

	// Information about the changes to make to the record sets.
	//
	// This member is required.
	Changes []Change

	//  Optional: Any comments you want to include about a change batch request.
	Comment *string

	noSmithyDocumentSerde
}

// A complex type that describes change information about changes made to your
// hosted zone.
type ChangeInfo struct {

	// This element contains an ID that you use when performing a [GetChange] action to get
	// detailed information about the change.
	//
	// [GetChange]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetChange.html
	//
	// This member is required.
	Id *string

	// The current state of the request. PENDING indicates that this request has not
	// yet been applied to all Amazon Route 53 DNS servers.
	//
	// This member is required.
	Status ChangeStatus

	// The date and time that the change request was submitted in [ISO 8601 format] and Coordinated
	// Universal Time (UTC). For example, the value 2017-03-27T17:48:16.751Z
	// represents March 27, 2017 at 17:48:16.751 UTC.
	//
	// [ISO 8601 format]: https://en.wikipedia.org/wiki/ISO_8601
	//
	// This member is required.
	SubmittedAt *time.Time

	// A comment you can provide.
	Comment *string

	noSmithyDocumentSerde
}

// A complex type that lists the CIDR blocks.
type CidrBlockSummary struct {

	// Value for the CIDR block.
	CidrBlock *string

	// The location name of the CIDR block.
	LocationName *string

	noSmithyDocumentSerde
}

// A complex type that identifies a CIDR collection.
type CidrCollection struct {

	// The ARN of the collection. Can be used to reference the collection in IAM
	// policy or in another Amazon Web Services account.
	Arn *string

	// The unique ID of the CIDR collection.
	Id *string

	// The name of a CIDR collection.
	Name *string

	// A sequential counter that Route 53 sets to 1 when you create a CIDR collection
	// and increments by 1 each time you update settings for the CIDR collection.
	Version *int64

	noSmithyDocumentSerde
}

// A complex type that contains information about the CIDR collection change.
type CidrCollectionChange struct {

	// CIDR collection change action.
	//
	// This member is required.
	Action CidrCollectionChangeAction

	// List of CIDR blocks.
	//
	// This member is required.
	CidrList []string

	// Name of the location that is associated with the CIDR collection.
	//
	// This member is required.
	LocationName *string

	noSmithyDocumentSerde
}

// The object that is specified in resource record set object when you are linking
// a resource record set to a CIDR location.
//
// A LocationName with an asterisk “*” can be used to create a default CIDR
// record. CollectionId is still required for default record.
type CidrRoutingConfig struct {

	// The CIDR collection ID.
	//
	// This member is required.
	CollectionId *string

	// The CIDR collection location name.
	//
	// This member is required.
	LocationName *string

	noSmithyDocumentSerde
}

// A complex type that contains information about the CloudWatch alarm that Amazon
// Route 53 is monitoring for this health check.
type CloudWatchAlarmConfiguration struct {

	// For the metric that the CloudWatch alarm is associated with, the arithmetic
	// operation that is used for the comparison.
	//
	// This member is required.
	ComparisonOperator ComparisonOperator

	// For the metric that the CloudWatch alarm is associated with, the number of
	// periods that the metric is compared to the threshold.
	//
	// This member is required.
	EvaluationPeriods *int32

	// The name of the CloudWatch metric that the alarm is associated with.
	//
	// This member is required.
	MetricName *string

	// The namespace of the metric that the alarm is associated with. For more
	// information, see [Amazon CloudWatch Namespaces, Dimensions, and Metrics Reference]in the Amazon CloudWatch User Guide.
	//
	// [Amazon CloudWatch Namespaces, Dimensions, and Metrics Reference]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html
	//
	// This member is required.
	Namespace *string

	// For the metric that the CloudWatch alarm is associated with, the duration of
	// one evaluation period in seconds.
	//
	// This member is required.
	Period *int32

	// For the metric that the CloudWatch alarm is associated with, the statistic that
	// is applied to the metric.
	//
	// This member is required.
	Statistic Statistic

	// For the metric that the CloudWatch alarm is associated with, the value the
	// metric is compared with.
	//
	// This member is required.
	Threshold *float64

	// For the metric that the CloudWatch alarm is associated with, a complex type
	// that contains information about the dimensions for the metric. For information,
	// see [Amazon CloudWatch Namespaces, Dimensions, and Metrics Reference]in the Amazon CloudWatch User Guide.
	//
	// [Amazon CloudWatch Namespaces, Dimensions, and Metrics Reference]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html
	Dimensions []Dimension

	noSmithyDocumentSerde
}

// A complex type that is an entry in an [CidrCollection] array.
//
// [CidrCollection]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_CidrCollection.html
type CollectionSummary struct {

	// The ARN of the collection summary. Can be used to reference the collection in
	// IAM policy or cross-account.
	Arn *string

	// Unique ID for the CIDR collection.
	Id *string

	// The name of a CIDR collection.
	Name *string

	// A sequential counter that Route 53 sets to 1 when you create a CIDR collection
	// and increments by 1 each time you update settings for the CIDR collection.
	Version *int64

	noSmithyDocumentSerde
}

// A complex type that lists the coordinates for a geoproximity resource record.
type Coordinates struct {

	//  Specifies a coordinate of the north–south position of a geographic point on
	// the surface of the Earth (-90 - 90).
	//
	// This member is required.
	Latitude *string

	//  Specifies a coordinate of the east–west position of a geographic point on the
	// surface of the Earth (-180 - 180).
	//
	// This member is required.
	Longitude *string

	noSmithyDocumentSerde
}

// A complex type that lists the name servers in a delegation set, as well as the
// CallerReference and the ID for the delegation set.
type DelegationSet struct {

	// A complex type that contains a list of the authoritative name servers for a
	// hosted zone or for a reusable delegation set.
	//
	// This member is required.
	NameServers []string

	// The value that you specified for CallerReference when you created the reusable
	// delegation set.
	CallerReference *string

	// The ID that Amazon Route 53 assigns to a reusable delegation set.
	Id *string

	noSmithyDocumentSerde
}

// For the metric that the CloudWatch alarm is associated with, a complex type
// that contains information about one dimension.
type Dimension struct {

	// For the metric that the CloudWatch alarm is associated with, the name of one
	// dimension.
	//
	// This member is required.
	Name *string

	// For the metric that the CloudWatch alarm is associated with, the value of one
	// dimension.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// A string representing the status of DNSSEC signing.
type DNSSECStatus struct {

	// A string that represents the current hosted zone signing status.
	//
	// Status can have one of the following values:
	//
	// SIGNING DNSSEC signing is enabled for the hosted zone.
	//
	// NOT_SIGNING DNSSEC signing is not enabled for the hosted zone.
	//
	// DELETING DNSSEC signing is in the process of being removed for the hosted zone.
	//
	// ACTION_NEEDED There is a problem with signing in the hosted zone that requires
	// you to take action to resolve. For example, the customer managed key might have
	// been deleted, or the permissions for the customer managed key might have been
	// changed.
	//
	// INTERNAL_FAILURE There was an error during a request. Before you can continue
	// to work with DNSSEC signing, including with key-signing keys (KSKs), you must
	// correct the problem by enabling or disabling DNSSEC signing for the hosted zone.
	ServeSignature *string

	// The status message provided for the following DNSSEC signing status:
	// INTERNAL_FAILURE . The status message includes information about what the
	// problem might be and steps that you can take to correct the issue.
	StatusMessage *string

	noSmithyDocumentSerde
}

// A complex type that contains information about a geographic location.
type GeoLocation struct {

	// The two-letter code for the continent.
	//
	// Amazon Route 53 supports the following continent codes:
	//
	//   - AF: Africa
	//
	//   - AN: Antarctica
	//
	//   - AS: Asia
	//
	//   - EU: Europe
	//
	//   - OC: Oceania
	//
	//   - NA: North America
	//
	//   - SA: South America
	//
	// Constraint: Specifying ContinentCode with either CountryCode or SubdivisionCode
	// returns an InvalidInput error.
	ContinentCode *string

	// For geolocation resource record sets, the two-letter code for a country.
	//
	// Amazon Route 53 uses the two-letter country codes that are specified in [ISO standard 3166-1 alpha-2].
	//
	// Route 53 also supports the country code UA for Ukraine.
	//
	// [ISO standard 3166-1 alpha-2]: https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2
	CountryCode *string

	// For geolocation resource record sets, the two-letter code for a state of the
	// United States. Route 53 doesn't support any other values for SubdivisionCode .
	// For a list of state abbreviations, see [Appendix B: Two–Letter State and Possession Abbreviations]on the United States Postal Service
	// website.
	//
	// If you specify subdivisioncode , you must also specify US for CountryCode .
	//
	// [Appendix B: Two–Letter State and Possession Abbreviations]: https://pe.usps.com/text/pub28/28apb.htm
	SubdivisionCode *string

	noSmithyDocumentSerde
}

// A complex type that contains the codes and full continent, country, and
// subdivision names for the specified geolocation code.
type GeoLocationDetails struct {

	// The two-letter code for the continent.
	ContinentCode *string

	// The full name of the continent.
	ContinentName *string

	// The two-letter code for the country.
	CountryCode *string

	// The name of the country.
	CountryName *string

	// The code for the subdivision, such as a particular state within the United
	// States. For a list of US state abbreviations, see [Appendix B: Two–Letter State and Possession Abbreviations]on the United States Postal
	// Service website. For a list of all supported subdivision codes, use the [ListGeoLocations]API.
	//
	// [ListGeoLocations]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListGeoLocations.html
	// [Appendix B: Two–Letter State and Possession Abbreviations]: https://pe.usps.com/text/pub28/28apb.htm
	SubdivisionCode *string

	// The full name of the subdivision. Route 53 currently supports only states in
	// the United States.
	SubdivisionName *string

	noSmithyDocumentSerde
}

//	(Resource record sets only): A complex type that lets you specify where your
//
// resources are located. Only one of LocalZoneGroup , Coordinates , or Amazon Web
// ServicesRegion is allowed per request at a time.
//
// For more information about geoproximity routing, see [Geoproximity routing] in the Amazon Route 53
// Developer Guide.
//
// [Geoproximity routing]: https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy-geoproximity.html
type GeoProximityLocation struct {

	//  The Amazon Web Services Region the resource you are directing DNS traffic to,
	// is in.
	AWSRegion *string

	//  The bias increases or decreases the size of the geographic region from which
	// Route 53 routes traffic to a resource.
	//
	// To use Bias to change the size of the geographic region, specify the applicable
	// value for the bias:
	//
	//   - To expand the size of the geographic region from which Route 53 routes
	//   traffic to a resource, specify a positive integer from 1 to 99 for the bias.
	//   Route 53 shrinks the size of adjacent regions.
	//
	//   - To shrink the size of the geographic region from which Route 53 routes
	//   traffic to a resource, specify a negative bias of -1 to -99. Route 53 expands
	//   the size of adjacent regions.
	Bias *int32

	//  Contains the longitude and latitude for a geographic region.
	Coordinates *Coordinates

	//  Specifies an Amazon Web Services Local Zone Group.
	//
	// A local Zone Group is usually the Local Zone code without the ending character.
	// For example, if the Local Zone is us-east-1-bue-1a the Local Zone Group is
	// us-east-1-bue-1 .
	//
	// You can identify the Local Zones Group for a specific Local Zone by using the [describe-availability-zones]
	// CLI command:
	//
	// This command returns: "GroupName": "us-west-2-den-1" , specifying that the Local
	// Zone us-west-2-den-1a belongs to the Local Zone Group us-west-2-den-1 .
	//
	// [describe-availability-zones]: https://docs.aws.amazon.com/cli/latest/reference/ec2/describe-availability-zones.html
	LocalZoneGroup *string

	noSmithyDocumentSerde
}

// A complex type that contains information about one health check that is
// associated with the current Amazon Web Services account.
type HealthCheck struct {

	// A unique string that you specified when you created the health check.
	//
	// This member is required.
	CallerReference *string

	// A complex type that contains detailed information about one health check.
	//
	// This member is required.
	HealthCheckConfig *HealthCheckConfig

	// The version of the health check. You can optionally pass this value in a call
	// to UpdateHealthCheck to prevent overwriting another change to the health check.
	//
	// This member is required.
	HealthCheckVersion *int64

	// The identifier that Amazon Route 53 assigned to the health check when you
	// created it. When you add or update a resource record set, you use this value to
	// specify which health check to use. The value can be up to 64 characters long.
	//
	// This member is required.
	Id *string

	// A complex type that contains information about the CloudWatch alarm that Amazon
	// Route 53 is monitoring for this health check.
	CloudWatchAlarmConfiguration *CloudWatchAlarmConfiguration

	// If the health check was created by another service, the service that created
	// the health check. When a health check is created by another service, you can't
	// edit or delete it using Amazon Route 53.
	LinkedService *LinkedService

	noSmithyDocumentSerde
}

// A complex type that contains information about the health check.
type HealthCheckConfig struct {

	// The type of health check that you want to create, which indicates how Amazon
	// Route 53 determines whether an endpoint is healthy.
	//
	// You can't change the value of Type after you create a health check.
	//
	// You can create the following types of health checks:
	//
	//   - HTTP: Route 53 tries to establish a TCP connection. If successful, Route 53
	//   submits an HTTP request and waits for an HTTP status code of 200 or greater and
	//   less than 400.
	//
	//   - HTTPS: Route 53 tries to establish a TCP connection. If successful, Route
	//   53 submits an HTTPS request and waits for an HTTP status code of 200 or greater
	//   and less than 400.
	//
	// If you specify HTTPS for the value of Type , the endpoint must support TLS v1.0,
	//   v1.1, or v1.2.
	//
	//   - HTTP_STR_MATCH: Route 53 tries to establish a TCP connection. If
	//   successful, Route 53 submits an HTTP request and searches the first 5,120 bytes
	//   of the response body for the string that you specify in SearchString .
	//
	//   - HTTPS_STR_MATCH: Route 53 tries to establish a TCP connection. If
	//   successful, Route 53 submits an HTTPS request and searches the first 5,120
	//   bytes of the response body for the string that you specify in SearchString .
	//
	//   - TCP: Route 53 tries to establish a TCP connection.
	//
	//   - CLOUDWATCH_METRIC: The health check is associated with a CloudWatch alarm.
	//   If the state of the alarm is OK , the health check is considered healthy. If
	//   the state is ALARM , the health check is considered unhealthy. If CloudWatch
	//   doesn't have sufficient data to determine whether the state is OK or ALARM ,
	//   the health check status depends on the setting for
	//   InsufficientDataHealthStatus : Healthy , Unhealthy , or LastKnownStatus .
	//
	//   - CALCULATED: For health checks that monitor the status of other health
	//   checks, Route 53 adds up the number of health checks that Route 53 health
	//   checkers consider to be healthy and compares that number with the value of
	//   HealthThreshold .
	//
	//   - RECOVERY_CONTROL: The health check is associated with a Route53 Application
	//   Recovery Controller routing control. If the routing control state is ON , the
	//   health check is considered healthy. If the state is OFF , the health check is
	//   considered unhealthy.
	//
	// For more information, see [How Route 53 Determines Whether an Endpoint Is Healthy] in the Amazon Route 53 Developer Guide.
	//
	// [How Route 53 Determines Whether an Endpoint Is Healthy]: https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html
	//
	// This member is required.
	Type HealthCheckType

	// A complex type that identifies the CloudWatch alarm that you want Amazon Route
	// 53 health checkers to use to determine whether the specified health check is
	// healthy.
	AlarmIdentifier *AlarmIdentifier

	// (CALCULATED Health Checks Only) A complex type that contains one
	// ChildHealthCheck element for each health check that you want to associate with a
	// CALCULATED health check.
	ChildHealthChecks []string

	// Stops Route 53 from performing health checks. When you disable a health check,
	// here's what happens:
	//
	//   - Health checks that check the health of endpoints: Route 53 stops submitting
	//   requests to your application, server, or other resource.
	//
	//   - Calculated health checks: Route 53 stops aggregating the status of the
	//   referenced health checks.
	//
	//   - Health checks that monitor CloudWatch alarms: Route 53 stops monitoring the
	//   corresponding CloudWatch metrics.
	//
	// After you disable a health check, Route 53 considers the status of the health
	// check to always be healthy. If you configured DNS failover, Route 53 continues
	// to route traffic to the corresponding resources. If you want to stop routing
	// traffic to a resource, change the value of [Inverted].
	//
	// Charges for a health check still apply when the health check is disabled. For
	// more information, see [Amazon Route 53 Pricing].
	//
	// [Inverted]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-Inverted
	// [Amazon Route 53 Pricing]: http://aws.amazon.com/route53/pricing/
	Disabled *bool

	// Specify whether you want Amazon Route 53 to send the value of
	// FullyQualifiedDomainName to the endpoint in the client_hello message during TLS
	// negotiation. This allows the endpoint to respond to HTTPS health check requests
	// with the applicable SSL/TLS certificate.
	//
	// Some endpoints require that HTTPS requests include the host name in the
	// client_hello message. If you don't enable SNI, the status of the health check
	// will be SSL alert handshake_failure . A health check can also have that status
	// for other reasons. If SNI is enabled and you're still getting the error, check
	// the SSL/TLS configuration on your endpoint and confirm that your certificate is
	// valid.
	//
	// The SSL/TLS certificate on your endpoint includes a domain name in the Common
	// Name field and possibly several more in the Subject Alternative Names field.
	// One of the domain names in the certificate should match the value that you
	// specify for FullyQualifiedDomainName . If the endpoint responds to the
	// client_hello message with a certificate that does not include the domain name
	// that you specified in FullyQualifiedDomainName , a health checker will retry the
	// handshake. In the second attempt, the health checker will omit
	// FullyQualifiedDomainName from the client_hello message.
	EnableSNI *bool

	// The number of consecutive health checks that an endpoint must pass or fail for
	// Amazon Route 53 to change the current status of the endpoint from unhealthy to
	// healthy or vice versa. For more information, see [How Amazon Route 53 Determines Whether an Endpoint Is Healthy]in the Amazon Route 53
	// Developer Guide.
	//
	// If you don't specify a value for FailureThreshold , the default value is three
	// health checks.
	//
	// [How Amazon Route 53 Determines Whether an Endpoint Is Healthy]: https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html
	FailureThreshold *int32

	// Amazon Route 53 behavior depends on whether you specify a value for IPAddress .
	//
	// If you specify a value for IPAddress :
	//
	// Amazon Route 53 sends health check requests to the specified IPv4 or IPv6
	// address and passes the value of FullyQualifiedDomainName in the Host header for
	// all health checks except TCP health checks. This is typically the fully
	// qualified DNS name of the endpoint on which you want Route 53 to perform health
	// checks.
	//
	// When Route 53 checks the health of an endpoint, here is how it constructs the
	// Host header:
	//
	//   - If you specify a value of 80 for Port and HTTP or HTTP_STR_MATCH for Type ,
	//   Route 53 passes the value of FullyQualifiedDomainName to the endpoint in the
	//   Host header.
	//
	//   - If you specify a value of 443 for Port and HTTPS or HTTPS_STR_MATCH for Type
	//   , Route 53 passes the value of FullyQualifiedDomainName to the endpoint in the
	//   Host header.
	//
	//   - If you specify another value for Port and any value except TCP for Type ,
	//   Route 53 passes FullyQualifiedDomainName:Port to the endpoint in the Host
	//   header.
	//
	// If you don't specify a value for FullyQualifiedDomainName , Route 53 substitutes
	// the value of IPAddress in the Host header in each of the preceding cases.
	//
	// If you don't specify a value for IPAddress :
	//
	// Route 53 sends a DNS request to the domain that you specify for
	// FullyQualifiedDomainName at the interval that you specify for RequestInterval .
	// Using an IPv4 address that DNS returns, Route 53 then checks the health of the
	// endpoint.
	//
	// If you don't specify a value for IPAddress , Route 53 uses only IPv4 to send
	// health checks to the endpoint. If there's no resource record set with a type of
	// A for the name that you specify for FullyQualifiedDomainName , the health check
	// fails with a "DNS resolution failed" error.
	//
	// If you want to check the health of weighted, latency, or failover resource
	// record sets and you choose to specify the endpoint only by
	// FullyQualifiedDomainName , we recommend that you create a separate health check
	// for each endpoint. For example, create a health check for each HTTP server that
	// is serving content for www.example.com. For the value of
	// FullyQualifiedDomainName , specify the domain name of the server (such as
	// us-east-2-www.example.com), not the name of the resource record sets
	// (www.example.com).
	//
	// In this configuration, if you create a health check for which the value of
	// FullyQualifiedDomainName matches the name of the resource record sets and you
	// then associate the health check with those resource record sets, health check
	// results will be unpredictable.
	//
	// In addition, if the value that you specify for Type is HTTP , HTTPS ,
	// HTTP_STR_MATCH , or HTTPS_STR_MATCH , Route 53 passes the value of
	// FullyQualifiedDomainName in the Host header, as it does when you specify a
	// value for IPAddress . If the value of Type is TCP , Route 53 doesn't pass a Host
	// header.
	FullyQualifiedDomainName *string

	// The number of child health checks that are associated with a CALCULATED health
	// check that Amazon Route 53 must consider healthy for the CALCULATED health
	// check to be considered healthy. To specify the child health checks that you want
	// to associate with a CALCULATED health check, use the [ChildHealthChecks] element.
	//
	// Note the following:
	//
	//   - If you specify a number greater than the number of child health checks,
	//   Route 53 always considers this health check to be unhealthy.
	//
	//   - If you specify 0 , Route 53 always considers this health check to be healthy.
	//
	// [ChildHealthChecks]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-ChildHealthChecks
	HealthThreshold *int32

	// The IPv4 or IPv6 IP address of the endpoint that you want Amazon Route 53 to
	// perform health checks on. If you don't specify a value for IPAddress , Route 53
	// sends a DNS request to resolve the domain name that you specify in
	// FullyQualifiedDomainName at the interval that you specify in RequestInterval .
	// Using an IP address returned by DNS, Route 53 then checks the health of the
	// endpoint.
	//
	// Use one of the following formats for the value of IPAddress :
	//
	//   - IPv4 address: four values between 0 and 255, separated by periods (.), for
	//   example, 192.0.2.44 .
	//
	//   - IPv6 address: eight groups of four hexadecimal values, separated by colons
	//   (:), for example, 2001:0db8:85a3:0000:0000:abcd:0001:2345 . You can also
	//   shorten IPv6 addresses as described in RFC 5952, for example,
	//   2001:db8:85a3::abcd:1:2345 .
	//
	// If the endpoint is an EC2 instance, we recommend that you create an Elastic IP
	// address, associate it with your EC2 instance, and specify the Elastic IP address
	// for IPAddress . This ensures that the IP address of your instance will never
	// change.
	//
	// For more information, see [FullyQualifiedDomainName].
	//
	// Constraints: Route 53 can't check the health of endpoints for which the IP
	// address is in local, private, non-routable, or multicast ranges. For more
	// information about IP addresses for which you can't create health checks, see the
	// following documents:
	//
	// [RFC 5735, Special Use IPv4 Addresses]
	//
	// [RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address Space]
	//
	// [RFC 5156, Special-Use IPv6 Addresses]
	//
	// When the value of Type is CALCULATED or CLOUDWATCH_METRIC , omit IPAddress .
	//
	// [RFC 5735, Special Use IPv4 Addresses]: https://tools.ietf.org/html/rfc5735
	// [FullyQualifiedDomainName]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName
	// [RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address Space]: https://tools.ietf.org/html/rfc6598
	// [RFC 5156, Special-Use IPv6 Addresses]: https://tools.ietf.org/html/rfc5156
	IPAddress *string

	// When CloudWatch has insufficient data about the metric to determine the alarm
	// state, the status that you want Amazon Route 53 to assign to the health check:
	//
	//   - Healthy : Route 53 considers the health check to be healthy.
	//
	//   - Unhealthy : Route 53 considers the health check to be unhealthy.
	//
	//   - LastKnownStatus : Route 53 uses the status of the health check from the last
	//   time that CloudWatch had sufficient data to determine the alarm state. For new
	//   health checks that have no last known status, the default status for the health
	//   check is healthy.
	InsufficientDataHealthStatus InsufficientDataHealthStatus

	// Specify whether you want Amazon Route 53 to invert the status of a health
	// check, for example, to consider a health check unhealthy when it otherwise would
	// be considered healthy.
	Inverted *bool

	// Specify whether you want Amazon Route 53 to measure the latency between health
	// checkers in multiple Amazon Web Services regions and your endpoint, and to
	// display CloudWatch latency graphs on the Health Checks page in the Route 53
	// console.
	//
	// You can't change the value of MeasureLatency after you create a health check.
	MeasureLatency *bool

	// The port on the endpoint that you want Amazon Route 53 to perform health checks
	// on.
	//
	// Don't specify a value for Port when you specify a value for Type of
	// CLOUDWATCH_METRIC or CALCULATED .
	Port *int32

	// A complex type that contains one Region element for each region from which you
	// want Amazon Route 53 health checkers to check the specified endpoint.
	//
	// If you don't specify any regions, Route 53 health checkers automatically
	// performs checks from all of the regions that are listed under Valid Values.
	//
	// If you update a health check to remove a region that has been performing health
	// checks, Route 53 will briefly continue to perform checks from that region to
	// ensure that some health checkers are always checking the endpoint (for example,
	// if you replace three regions with four different regions).
	Regions []HealthCheckRegion

	// The number of seconds between the time that Amazon Route 53 gets a response
	// from your endpoint and the time that it sends the next health check request.
	// Each Route 53 health checker makes requests at this interval.
	//
	// You can't change the value of RequestInterval after you create a health check.
	//
	// If you don't specify a value for RequestInterval , the default value is 30
	// seconds.
	RequestInterval *int32

	// The path, if any, that you want Amazon Route 53 to request when performing
	// health checks. The path can be any value for which your endpoint will return an
	// HTTP status code of 2xx or 3xx when the endpoint is healthy, for example, the
	// file /docs/route53-health-check.html. You can also include query string
	// parameters, for example, /welcome.html?language=jp&login=y .
	ResourcePath *string

	// The Amazon Resource Name (ARN) for the Route 53 Application Recovery Controller
	// routing control.
	//
	// For more information about Route 53 Application Recovery Controller, see [Route 53 Application Recovery Controller Developer Guide.].
	//
	// [Route 53 Application Recovery Controller Developer Guide.]: https://docs.aws.amazon.com/r53recovery/latest/dg/what-is-route-53-recovery.html
	RoutingControlArn *string

	// If the value of Type is HTTP_STR_MATCH or HTTPS_STR_MATCH , the string that you
	// want Amazon Route 53 to search for in the response body from the specified
	// resource. If the string appears in the response body, Route 53 considers the
	// resource healthy.
	//
	// Route 53 considers case when searching for SearchString in the response body.
	SearchString *string

	noSmithyDocumentSerde
}

// A complex type that contains the last failure reason as reported by one Amazon
// Route 53 health checker.
type HealthCheckObservation struct {

	// The IP address of the Amazon Route 53 health checker that provided the failure
	// reason in StatusReport .
	IPAddress *string

	// The region of the Amazon Route 53 health checker that provided the status in
	// StatusReport .
	Region HealthCheckRegion

	// A complex type that contains the last failure reason as reported by one Amazon
	// Route 53 health checker and the time of the failed health check.
	StatusReport *StatusReport

	noSmithyDocumentSerde
}

// A complex type that contains general information about the hosted zone.
type HostedZone struct {

	// The value that you specified for CallerReference when you created the hosted
	// zone.
	//
	// This member is required.
	CallerReference *string

	// The ID that Amazon Route 53 assigned to the hosted zone when you created it.
	//
	// This member is required.
	Id *string

	// The name of the domain. For public hosted zones, this is the name that you have
	// registered with your DNS registrar.
	//
	// For information about how to specify characters other than a-z , 0-9 , and -
	// (hyphen) and how to specify internationalized domain names, see [CreateHostedZone].
	//
	// [CreateHostedZone]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateHostedZone.html
	//
	// This member is required.
	Name *string

	// A complex type that includes the Comment and PrivateZone elements. If you
	// omitted the HostedZoneConfig and Comment elements from the request, the Config
	// and Comment elements don't appear in the response.
	Config *HostedZoneConfig

	// If the hosted zone was created by another service, the service that created the
	// hosted zone. When a hosted zone is created by another service, you can't edit or
	// delete it using Route 53.
	LinkedService *LinkedService

	// The number of resource record sets in the hosted zone.
	ResourceRecordSetCount *int64

	noSmithyDocumentSerde
}

// A complex type that contains an optional comment about your hosted zone. If you
// don't want to specify a comment, omit both the HostedZoneConfig and Comment
// elements.
type HostedZoneConfig struct {

	// Any comments that you want to include about the hosted zone.
	Comment *string

	// A value that indicates whether this is a private hosted zone.
	PrivateZone bool

	noSmithyDocumentSerde
}

// A complex type that contains the type of limit that you specified in the
// request and the current value for that limit.
type HostedZoneLimit struct {

	// The limit that you requested. Valid values include the following:
	//
	//   - MAX_RRSETS_BY_ZONE: The maximum number of records that you can create in
	//   the specified hosted zone.
	//
	//   - MAX_VPCS_ASSOCIATED_BY_ZONE: The maximum number of Amazon VPCs that you can
	//   associate with the specified private hosted zone.
	//
	// This member is required.
	Type HostedZoneLimitType

	// The current value for the limit that is specified by Type .
	//
	// This member is required.
	Value *int64

	noSmithyDocumentSerde
}

// A complex type that identifies a hosted zone that a specified Amazon VPC is
// associated with and the owner of the hosted zone. If there is a value for
// OwningAccount , there is no value for OwningService , and vice versa.
type HostedZoneOwner struct {

	// If the hosted zone was created by an Amazon Web Services account, or was
	// created by an Amazon Web Services service that creates hosted zones using the
	// current account, OwningAccount contains the account ID of that account. For
	// example, when you use Cloud Map to create a hosted zone, Cloud Map creates the
	// hosted zone using the current Amazon Web Services account.
	OwningAccount *string

	// If an Amazon Web Services service uses its own account to create a hosted zone
	// and associate the specified VPC with that hosted zone, OwningService contains
	// an abbreviation that identifies the service. For example, if Amazon Elastic File
	// System (Amazon EFS) created a hosted zone and associated a VPC with the hosted
	// zone, the value of OwningService is efs.amazonaws.com .
	OwningService *string

	noSmithyDocumentSerde
}

// In the response to a ListHostedZonesByVPC request, the HostedZoneSummaries
// element contains one HostedZoneSummary element for each hosted zone that the
// specified Amazon VPC is associated with. Each HostedZoneSummary element
// contains the hosted zone name and ID, and information about who owns the hosted
// zone.
type HostedZoneSummary struct {

	// The Route 53 hosted zone ID of a private hosted zone that the specified VPC is
	// associated with.
	//
	// This member is required.
	HostedZoneId *string

	// The name of the private hosted zone, such as example.com .
	//
	// This member is required.
	Name *string

	// The owner of a private hosted zone that the specified VPC is associated with.
	// The owner can be either an Amazon Web Services account or an Amazon Web Services
	// service.
	//
	// This member is required.
	Owner *HostedZoneOwner

	noSmithyDocumentSerde
}

// A key-signing key (KSK) is a complex type that represents a public/private key
// pair. The private key is used to generate a digital signature for the zone
// signing key (ZSK). The public key is stored in the DNS and is used to
// authenticate the ZSK. A KSK is always associated with a hosted zone; it cannot
// exist by itself.
type KeySigningKey struct {

	// The date when the key-signing key (KSK) was created.
	CreatedDate *time.Time

	// A string that represents a DNSKEY record.
	DNSKEYRecord *string

	// A string that represents a delegation signer (DS) record.
	DSRecord *string

	// A string used to represent the delegation signer digest algorithm. This value
	// must follow the guidelines provided by [RFC-8624 Section 3.3].
	//
	// [RFC-8624 Section 3.3]: https://tools.ietf.org/html/rfc8624#section-3.3
	DigestAlgorithmMnemonic *string

	// An integer used to represent the delegation signer digest algorithm. This value
	// must follow the guidelines provided by [RFC-8624 Section 3.3].
	//
	// [RFC-8624 Section 3.3]: https://tools.ietf.org/html/rfc8624#section-3.3
	DigestAlgorithmType int32

	// A cryptographic digest of a DNSKEY resource record (RR). DNSKEY records are
	// used to publish the public key that resolvers can use to verify DNSSEC
	// signatures that are used to secure certain kinds of information provided by the
	// DNS system.
	DigestValue *string

	// An integer that specifies how the key is used. For key-signing key (KSK), this
	// value is always 257.
	Flag int32

	// An integer used to identify the DNSSEC record for the domain name. The process
	// used to calculate the value is described in [RFC-4034 Appendix B].
	//
	// [RFC-4034 Appendix B]: https://tools.ietf.org/rfc/rfc4034.txt
	KeyTag int32

	// The Amazon resource name (ARN) used to identify the customer managed key in Key
	// Management Service (KMS). The KmsArn must be unique for each key-signing key
	// (KSK) in a single hosted zone.
	//
	// You must configure the customer managed key as follows:
	//
	// Status Enabled
	//
	// Key spec ECC_NIST_P256
	//
	// Key usage Sign and verify
	//
	// Key policy The key policy must give permission for the following actions:
	//
	//   - DescribeKey
	//
	//   - GetPublicKey
	//
	//   - Sign
	//
	// The key policy must also include the Amazon Route 53 service in the principal
	// for your account. Specify the following:
	//
	//   - "Service": "dnssec-route53.amazonaws.com"
	//
	// For more information about working with the customer managed key in KMS, see [Key Management Service concepts].
	//
	// [Key Management Service concepts]: https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html
	KmsArn *string

	// The last time that the key-signing key (KSK) was changed.
	LastModifiedDate *time.Time

	// A string used to identify a key-signing key (KSK). Name can include numbers,
	// letters, and underscores (_). Name must be unique for each key-signing key in
	// the same hosted zone.
	Name *string

	// The public key, represented as a Base64 encoding, as required by [RFC-4034 Page 5].
	//
	// [RFC-4034 Page 5]: https://tools.ietf.org/rfc/rfc4034.txt
	PublicKey *string

	// A string used to represent the signing algorithm. This value must follow the
	// guidelines provided by [RFC-8624 Section 3.1].
	//
	// [RFC-8624 Section 3.1]: https://tools.ietf.org/html/rfc8624#section-3.1
	SigningAlgorithmMnemonic *string

	// An integer used to represent the signing algorithm. This value must follow the
	// guidelines provided by [RFC-8624 Section 3.1].
	//
	// [RFC-8624 Section 3.1]: https://tools.ietf.org/html/rfc8624#section-3.1
	SigningAlgorithmType int32

	// A string that represents the current key-signing key (KSK) status.
	//
	// Status can have one of the following values:
	//
	// ACTIVE The KSK is being used for signing.
	//
	// INACTIVE The KSK is not being used for signing.
	//
	// DELETING The KSK is in the process of being deleted.
	//
	// ACTION_NEEDED There is a problem with the KSK that requires you to take action
	// to resolve. For example, the customer managed key might have been deleted, or
	// the permissions for the customer managed key might have been changed.
	//
	// INTERNAL_FAILURE There was an error during a request. Before you can continue
	// to work with DNSSEC signing, including actions that involve this KSK, you must
	// correct the problem. For example, you may need to activate or deactivate the
	// KSK.
	Status *string

	// The status message provided for the following key-signing key (KSK) statuses:
	// ACTION_NEEDED or INTERNAL_FAILURE . The status message includes information
	// about what the problem might be and steps that you can take to correct the
	// issue.
	StatusMessage *string

	noSmithyDocumentSerde
}

// If a health check or hosted zone was created by another service, LinkedService
// is a complex type that describes the service that created the resource. When a
// resource is created by another service, you can't edit or delete it using Amazon
// Route 53.
type LinkedService struct {

	// If the health check or hosted zone was created by another service, an optional
	// description that can be provided by the other service. When a resource is
	// created by another service, you can't edit or delete it using Amazon Route 53.
	Description *string

	// If the health check or hosted zone was created by another service, the service
	// that created the resource. When a resource is created by another service, you
	// can't edit or delete it using Amazon Route 53.
	ServicePrincipal *string

	noSmithyDocumentSerde
}

// A complex type that contains information about the CIDR location.
type LocationSummary struct {

	// A string that specifies a location name.
	LocationName *string

	noSmithyDocumentSerde
}

// A complex type that contains information about a configuration for DNS query
// logging.
type QueryLoggingConfig struct {

	// The Amazon Resource Name (ARN) of the CloudWatch Logs log group that Amazon
	// Route 53 is publishing logs to.
	//
	// This member is required.
	CloudWatchLogsLogGroupArn *string

	// The ID of the hosted zone that CloudWatch Logs is logging queries for.
	//
	// This member is required.
	HostedZoneId *string

	// The ID for a configuration for DNS query logging.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

// Information specific to the resource record.
//
// If you're creating an alias resource record set, omit ResourceRecord .
type ResourceRecord struct {

	// The current or new DNS record value, not to exceed 4,000 characters. In the
	// case of a DELETE action, if the current value does not match the actual value,
	// an error is returned. For descriptions about how to format Value for different
	// record types, see [Supported DNS Resource Record Types]in the Amazon Route 53 Developer Guide.
	//
	// You can specify more than one value for all record types except CNAME and SOA .
	//
	// If you're creating an alias resource record set, omit Value .
	//
	// [Supported DNS Resource Record Types]: https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Information about the resource record set to create or delete.
type ResourceRecordSet struct {

	// For ChangeResourceRecordSets requests, the name of the record that you want to
	// create, update, or delete. For ListResourceRecordSets responses, the name of a
	// record in the specified hosted zone.
	//
	// ChangeResourceRecordSets Only
	//
	// Enter a fully qualified domain name, for example, www.example.com . You can
	// optionally include a trailing dot. If you omit the trailing dot, Amazon Route 53
	// assumes that the domain name that you specify is fully qualified. This means
	// that Route 53 treats www.example.com (without a trailing dot) and
	// www.example.com. (with a trailing dot) as identical.
	//
	// For information about how to specify characters other than a-z , 0-9 , and -
	// (hyphen) and how to specify internationalized domain names, see [DNS Domain Name Format]in the Amazon
	// Route 53 Developer Guide.
	//
	// You can use the asterisk (*) wildcard to replace the leftmost label in a domain
	// name, for example, *.example.com . Note the following:
	//
	//   - The * must replace the entire label. For example, you can't specify
	//   *prod.example.com or prod*.example.com .
	//
	//   - The * can't replace any of the middle labels, for example,
	//   marketing.*.example.com.
	//
	//   - If you include * in any position other than the leftmost label in a domain
	//   name, DNS treats it as an * character (ASCII 42), not as a wildcard.
	//
	// You can't use the * wildcard for resource records sets that have a type of NS.
	//
	// [DNS Domain Name Format]: https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html
	//
	// This member is required.
	Name *string

	// The DNS record type. For information about different record types and how data
	// is encoded for them, see [Supported DNS Resource Record Types]in the Amazon Route 53 Developer Guide.
	//
	// Valid values for basic resource record sets: A | AAAA | CAA | CNAME | DS | MX |
	// NAPTR | NS | PTR | SOA | SPF | SRV | TXT | TLSA | SSHFP | SVCB | HTTPS
	//
	// Values for weighted, latency, geolocation, and failover resource record sets: A
	// | AAAA | CAA | CNAME | MX | NAPTR | PTR | SPF | SRV | TXT | TLSA | SSHFP | SVCB
	// | HTTPS . When creating a group of weighted, latency, geolocation, or failover
	// resource record sets, specify the same value for all of the resource record sets
	// in the group.
	//
	// Valid values for multivalue answer resource record sets: A | AAAA | MX | NAPTR
	// | PTR | SPF | SRV | TXT | CAA | TLSA | SSHFP | SVCB | HTTPS
	//
	// SPF records were formerly used to verify the identity of the sender of email
	// messages. However, we no longer recommend that you create resource record sets
	// for which the value of Type is SPF . RFC 7208, Sender Policy Framework (SPF) for
	// Authorizing Use of Domains in Email, Version 1, has been updated to say,
	// "...[I]ts existence and mechanism defined in [RFC4408] have led to some
	// interoperability issues. Accordingly, its use is no longer appropriate for SPF
	// version 1; implementations are not to use it." In RFC 7208, see section 14.1, [The SPF DNS Record Type].
	//
	// Values for alias resource record sets:
	//
	//   - Amazon API Gateway custom regional APIs and edge-optimized APIs: A
	//
	//   - CloudFront distributions: A
	//
	// If IPv6 is enabled for the distribution, create two resource record sets to
	//   route traffic to your distribution, one with a value of A and one with a value
	//   of AAAA .
	//
	//   - Amazon API Gateway environment that has a regionalized subdomain: A
	//
	//   - ELB load balancers: A | AAAA
	//
	//   - Amazon S3 buckets: A
	//
	//   - Amazon Virtual Private Cloud interface VPC endpoints A
	//
	//   - Another resource record set in this hosted zone: Specify the type of the
	//   resource record set that you're creating the alias for. All values are supported
	//   except NS and SOA .
	//
	// If you're creating an alias record that has the same name as the hosted zone
	//   (known as the zone apex), you can't route traffic to a record for which the
	//   value of Type is CNAME . This is because the alias record must have the same
	//   type as the record you're routing traffic to, and creating a CNAME record for
	//   the zone apex isn't supported even for an alias record.
	//
	// [Supported DNS Resource Record Types]: https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/ResourceRecordTypes.html
	// [The SPF DNS Record Type]: http://tools.ietf.org/html/rfc7208#section-14.1
	//
	// This member is required.
	Type RRType

	//  Alias resource record sets only: Information about the Amazon Web Services
	// resource, such as a CloudFront distribution or an Amazon S3 bucket, that you
	// want to route traffic to.
	//
	// If you're creating resource records sets for a private hosted zone, note the
	// following:
	//
	//   - You can't create an alias resource record set in a private hosted zone to
	//   route traffic to a CloudFront distribution.
	//
	//   - For information about creating failover resource record sets in a private
	//   hosted zone, see [Configuring Failover in a Private Hosted Zone]in the Amazon Route 53 Developer Guide.
	//
	// [Configuring Failover in a Private Hosted Zone]: https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html
	AliasTarget *AliasTarget

	// The object that is specified in resource record set object when you are linking
	// a resource record set to a CIDR location.
	//
	// A LocationName with an asterisk “*” can be used to create a default CIDR
	// record. CollectionId is still required for default record.
	CidrRoutingConfig *CidrRoutingConfig

	//  Failover resource record sets only: To configure failover, you add the Failover
	// element to two resource record sets. For one resource record set, you specify
	// PRIMARY as the value for Failover ; for the other resource record set, you
	// specify SECONDARY . In addition, you include the HealthCheckId element and
	// specify the health check that you want Amazon Route 53 to perform for each
	// resource record set.
	//
	// Except where noted, the following failover behaviors assume that you have
	// included the HealthCheckId element in both resource record sets:
	//
	//   - When the primary resource record set is healthy, Route 53 responds to DNS
	//   queries with the applicable value from the primary resource record set
	//   regardless of the health of the secondary resource record set.
	//
	//   - When the primary resource record set is unhealthy and the secondary
	//   resource record set is healthy, Route 53 responds to DNS queries with the
	//   applicable value from the secondary resource record set.
	//
	//   - When the secondary resource record set is unhealthy, Route 53 responds to
	//   DNS queries with the applicable value from the primary resource record set
	//   regardless of the health of the primary resource record set.
	//
	//   - If you omit the HealthCheckId element for the secondary resource record set,
	//   and if the primary resource record set is unhealthy, Route 53 always responds to
	//   DNS queries with the applicable value from the secondary resource record set.
	//   This is true regardless of the health of the associated endpoint.
	//
	// You can't create non-failover resource record sets that have the same values
	// for the Name and Type elements as failover resource record sets.
	//
	// For failover alias resource record sets, you must also include the
	// EvaluateTargetHealth element and set the value to true.
	//
	// For more information about configuring failover for Route 53, see the following
	// topics in the Amazon Route 53 Developer Guide:
	//
	// [Route 53 Health Checks and DNS Failover]
	//
	// [Configuring Failover in a Private Hosted Zone]
	//
	// [Configuring Failover in a Private Hosted Zone]: https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html
	// [Route 53 Health Checks and DNS Failover]: https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html
	Failover ResourceRecordSetFailover

	//  Geolocation resource record sets only: A complex type that lets you control
	// how Amazon Route 53 responds to DNS queries based on the geographic origin of
	// the query. For example, if you want all queries from Africa to be routed to a
	// web server with an IP address of 192.0.2.111 , create a resource record set with
	// a Type of A and a ContinentCode of AF .
	//
	// If you create separate resource record sets for overlapping geographic regions
	// (for example, one resource record set for a continent and one for a country on
	// the same continent), priority goes to the smallest geographic region. This
	// allows you to route most queries for a continent to one resource and to route
	// queries for a country on that continent to a different resource.
	//
	// You can't create two geolocation resource record sets that specify the same
	// geographic location.
	//
	// The value * in the CountryCode element matches all geographic locations that
	// aren't specified in other geolocation resource record sets that have the same
	// values for the Name and Type elements.
	//
	// Geolocation works by mapping IP addresses to locations. However, some IP
	// addresses aren't mapped to geographic locations, so even if you create
	// geolocation resource record sets that cover all seven continents, Route 53 will
	// receive some DNS queries from locations that it can't identify. We recommend
	// that you create a resource record set for which the value of CountryCode is * .
	// Two groups of queries are routed to the resource that you specify in this
	// record: queries that come from locations for which you haven't created
	// geolocation resource record sets and queries from IP addresses that aren't
	// mapped to a location. If you don't create a * resource record set, Route 53
	// returns a "no answer" response for queries from those locations.
	//
	// You can't create non-geolocation resource record sets that have the same values
	// for the Name and Type elements as geolocation resource record sets.
	GeoLocation *GeoLocation

	//  GeoproximityLocation resource record sets only: A complex type that lets you
	// control how Route 53 responds to DNS queries based on the geographic origin of
	// the query and your resources.
	GeoProximityLocation *GeoProximityLocation

	// If you want Amazon Route 53 to return this resource record set in response to a
	// DNS query only when the status of a health check is healthy, include the
	// HealthCheckId element and specify the ID of the applicable health check.
	//
	// Route 53 determines whether a resource record set is healthy based on one of
	// the following:
	//
	//   - By periodically sending a request to the endpoint that is specified in the
	//   health check
	//
	//   - By aggregating the status of a specified group of health checks (calculated
	//   health checks)
	//
	//   - By determining the current state of a CloudWatch alarm (CloudWatch metric
	//   health checks)
	//
	// Route 53 doesn't check the health of the endpoint that is specified in the
	// resource record set, for example, the endpoint specified by the IP address in
	// the Value element. When you add a HealthCheckId element to a resource record
	// set, Route 53 checks the health of the endpoint that you specified in the health
	// check.
	//
	// For more information, see the following topics in the Amazon Route 53 Developer
	// Guide:
	//
	// [How Amazon Route 53 Determines Whether an Endpoint Is Healthy]
	//
	// [Route 53 Health Checks and DNS Failover]
	//
	// [Configuring Failover in a Private Hosted Zone]
	//
	// When to Specify HealthCheckId
	//
	// Specifying a value for HealthCheckId is useful only when Route 53 is choosing
	// between two or more resource record sets to respond to a DNS query, and you want
	// Route 53 to base the choice in part on the status of a health check. Configuring
	// health checks makes sense only in the following configurations:
	//
	//   - Non-alias resource record sets: You're checking the health of a group of
	//   non-alias resource record sets that have the same routing policy, name, and type
	//   (such as multiple weighted records named www.example.com with a type of A) and
	//   you specify health check IDs for all the resource record sets.
	//
	// If the health check status for a resource record set is healthy, Route 53
	//   includes the record among the records that it responds to DNS queries with.
	//
	// If the health check status for a resource record set is unhealthy, Route 53
	//   stops responding to DNS queries using the value for that resource record set.
	//
	// If the health check status for all resource record sets in the group is
	//   unhealthy, Route 53 considers all resource record sets in the group healthy and
	//   responds to DNS queries accordingly.
	//
	//   - Alias resource record sets: You specify the following settings:
	//
	//   - You set EvaluateTargetHealth to true for an alias resource record set in a
	//   group of resource record sets that have the same routing policy, name, and type
	//   (such as multiple weighted records named www.example.com with a type of A).
	//
	//   - You configure the alias resource record set to route traffic to a non-alias
	//   resource record set in the same hosted zone.
	//
	//   - You specify a health check ID for the non-alias resource record set.
	//
	// If the health check status is healthy, Route 53 considers the alias resource
	//   record set to be healthy and includes the alias record among the records that it
	//   responds to DNS queries with.
	//
	// If the health check status is unhealthy, Route 53 stops responding to DNS
	//   queries using the alias resource record set.
	//
	// The alias resource record set can also route traffic to a group of non-alias
	//   resource record sets that have the same routing policy, name, and type. In that
	//   configuration, associate health checks with all of the resource record sets in
	//   the group of non-alias resource record sets.
	//
	// Geolocation Routing
	//
	// For geolocation resource record sets, if an endpoint is unhealthy, Route 53
	// looks for a resource record set for the larger, associated geographic region.
	// For example, suppose you have resource record sets for a state in the United
	// States, for the entire United States, for North America, and a resource record
	// set that has * for CountryCode is * , which applies to all locations. If the
	// endpoint for the state resource record set is unhealthy, Route 53 checks for
	// healthy resource record sets in the following order until it finds a resource
	// record set for which the endpoint is healthy:
	//
	//   - The United States
	//
	//   - North America
	//
	//   - The default resource record set
	//
	// Specifying the Health Check Endpoint by Domain Name
	//
	// If your health checks specify the endpoint only by domain name, we recommend
	// that you create a separate health check for each endpoint. For example, create a
	// health check for each HTTP server that is serving content for www.example.com .
	// For the value of FullyQualifiedDomainName , specify the domain name of the
	// server (such as us-east-2-www.example.com ), not the name of the resource record
	// sets ( www.example.com ).
	//
	// Health check results will be unpredictable if you do the following:
	//
	//   - Create a health check that has the same value for FullyQualifiedDomainName
	//   as the name of a resource record set.
	//
	//   - Associate that health check with the resource record set.
	//
	// [Configuring Failover in a Private Hosted Zone]: https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-private-hosted-zones.html
	// [Route 53 Health Checks and DNS Failover]: https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover.html
	// [How Amazon Route 53 Determines Whether an Endpoint Is Healthy]: https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html
	HealthCheckId *string

	//  Multivalue answer resource record sets only: To route traffic approximately
	// randomly to multiple resources, such as web servers, create one multivalue
	// answer record for each resource and specify true for MultiValueAnswer . Note the
	// following:
	//
	//   - If you associate a health check with a multivalue answer resource record
	//   set, Amazon Route 53 responds to DNS queries with the corresponding IP address
	//   only when the health check is healthy.
	//
	//   - If you don't associate a health check with a multivalue answer record,
	//   Route 53 always considers the record to be healthy.
	//
	//   - Route 53 responds to DNS queries with up to eight healthy records; if you
	//   have eight or fewer healthy records, Route 53 responds to all DNS queries with
	//   all the healthy records.
	//
	//   - If you have more than eight healthy records, Route 53 responds to different
	//   DNS resolvers with different combinations of healthy records.
	//
	//   - When all records are unhealthy, Route 53 responds to DNS queries with up to
	//   eight unhealthy records.
	//
	//   - If a resource becomes unavailable after a resolver caches a response,
	//   client software typically tries another of the IP addresses in the response.
	//
	// You can't create multivalue answer alias records.
	MultiValueAnswer *bool

	//  Latency-based resource record sets only: The Amazon EC2 Region where you
	// created the resource that this resource record set refers to. The resource
	// typically is an Amazon Web Services resource, such as an EC2 instance or an ELB
	// load balancer, and is referred to by an IP address or a DNS domain name,
	// depending on the record type.
	//
	// When Amazon Route 53 receives a DNS query for a domain name and type for which
	// you have created latency resource record sets, Route 53 selects the latency
	// resource record set that has the lowest latency between the end user and the
	// associated Amazon EC2 Region. Route 53 then returns the value that is associated
	// with the selected resource record set.
	//
	// Note the following:
	//
	//   - You can only specify one ResourceRecord per latency resource record set.
	//
	//   - You can only create one latency resource record set for each Amazon EC2
	//   Region.
	//
	//   - You aren't required to create latency resource record sets for all Amazon
	//   EC2 Regions. Route 53 will choose the region with the best latency from among
	//   the regions that you create latency resource record sets for.
	//
	//   - You can't create non-latency resource record sets that have the same values
	//   for the Name and Type elements as latency resource record sets.
	Region ResourceRecordSetRegion

	// Information about the resource records to act upon.
	//
	// If you're creating an alias resource record set, omit ResourceRecords .
	ResourceRecords []ResourceRecord

	//  Resource record sets that have a routing policy other than simple: An
	// identifier that differentiates among multiple resource record sets that have the
	// same combination of name and type, such as multiple weighted resource record
	// sets named acme.example.com that have a type of A. In a group of resource record
	// sets that have the same name and type, the value of SetIdentifier must be
	// unique for each resource record set.
	//
	// For information about routing policies, see [Choosing a Routing Policy] in the Amazon Route 53 Developer
	// Guide.
	//
	// [Choosing a Routing Policy]: https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html
	SetIdentifier *string

	// The resource record cache time to live (TTL), in seconds. Note the following:
	//
	//   - If you're creating or updating an alias resource record set, omit TTL .
	//   Amazon Route 53 uses the value of TTL for the alias target.
	//
	//   - If you're associating this resource record set with a health check (if
	//   you're adding a HealthCheckId element), we recommend that you specify a TTL of
	//   60 seconds or less so clients respond quickly to changes in health status.
	//
	//   - All of the resource record sets in a group of weighted resource record sets
	//   must have the same value for TTL .
	//
	//   - If a group of weighted resource record sets includes one or more weighted
	//   alias resource record sets for which the alias target is an ELB load balancer,
	//   we recommend that you specify a TTL of 60 seconds for all of the non-alias
	//   weighted resource record sets that have the same name and type. Values other
	//   than 60 seconds (the TTL for load balancers) will change the effect of the
	//   values that you specify for Weight .
	TTL *int64

	// When you create a traffic policy instance, Amazon Route 53 automatically
	// creates a resource record set. TrafficPolicyInstanceId is the ID of the traffic
	// policy instance that Route 53 created this resource record set for.
	//
	// To delete the resource record set that is associated with a traffic policy
	// instance, use DeleteTrafficPolicyInstance . Route 53 will delete the resource
	// record set automatically. If you delete the resource record set by using
	// ChangeResourceRecordSets , Route 53 doesn't automatically delete the traffic
	// policy instance, and you'll continue to be charged for it even though it's no
	// longer in use.
	TrafficPolicyInstanceId *string

	//  Weighted resource record sets only: Among resource record sets that have the
	// same combination of DNS name and type, a value that determines the proportion of
	// DNS queries that Amazon Route 53 responds to using the current resource record
	// set. Route 53 calculates the sum of the weights for the resource record sets
	// that have the same combination of DNS name and type. Route 53 then responds to
	// queries based on the ratio of a resource's weight to the total. Note the
	// following:
	//
	//   - You must specify a value for the Weight element for every weighted resource
	//   record set.
	//
	//   - You can only specify one ResourceRecord per weighted resource record set.
	//
	//   - You can't create latency, failover, or geolocation resource record sets
	//   that have the same values for the Name and Type elements as weighted resource
	//   record sets.
	//
	//   - You can create a maximum of 100 weighted resource record sets that have the
	//   same values for the Name and Type elements.
	//
	//   - For weighted (but not weighted alias) resource record sets, if you set
	//   Weight to 0 for a resource record set, Route 53 never responds to queries with
	//   the applicable value for that resource record set. However, if you set Weight
	//   to 0 for all resource record sets that have the same combination of DNS name
	//   and type, traffic is routed to all resources with equal probability.
	//
	// The effect of setting Weight to 0 is different when you associate health checks
	//   with weighted resource record sets. For more information, see [Options for Configuring Route 53 Active-Active and Active-Passive Failover]in the Amazon
	//   Route 53 Developer Guide.
	//
	// [Options for Configuring Route 53 Active-Active and Active-Passive Failover]: https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-configuring-options.html
	Weight *int64

	noSmithyDocumentSerde
}

// A complex type containing a resource and its associated tags.
type ResourceTagSet struct {

	// The ID for the specified resource.
	ResourceId *string

	// The type of the resource.
	//
	//   - The resource type for health checks is healthcheck .
	//
	//   - The resource type for hosted zones is hostedzone .
	ResourceType TagResourceType

	// The tags associated with the specified resource.
	Tags []Tag

	noSmithyDocumentSerde
}

// A complex type that contains the type of limit that you specified in the
// request and the current value for that limit.
type ReusableDelegationSetLimit struct {

	// The limit that you requested: MAX_ZONES_BY_REUSABLE_DELEGATION_SET , the maximum
	// number of hosted zones that you can associate with the specified reusable
	// delegation set.
	//
	// This member is required.
	Type ReusableDelegationSetLimitType

	// The current value for the MAX_ZONES_BY_REUSABLE_DELEGATION_SET limit.
	//
	// This member is required.
	Value *int64

	noSmithyDocumentSerde
}

// A complex type that contains the status that one Amazon Route 53 health checker
// reports and the time of the health check.
type StatusReport struct {

	// The date and time that the health checker performed the health check in [ISO 8601 format] and
	// Coordinated Universal Time (UTC). For example, the value
	// 2017-03-27T17:48:16.751Z represents March 27, 2017 at 17:48:16.751 UTC.
	//
	// [ISO 8601 format]: https://en.wikipedia.org/wiki/ISO_8601
	CheckedTime *time.Time

	// A description of the status of the health check endpoint as reported by one of
	// the Amazon Route 53 health checkers.
	Status *string

	noSmithyDocumentSerde
}

// A complex type that contains information about a tag that you want to add or
// edit for the specified health check or hosted zone.
type Tag struct {

	// The value of Key depends on the operation that you want to perform:
	//
	//   - Add a tag to a health check or hosted zone: Key is the name that you want to
	//   give the new tag.
	//
	//   - Edit a tag: Key is the name of the tag that you want to change the Value for.
	//
	//   - Delete a key: Key is the name of the tag you want to remove.
	//
	//   - Give a name to a health check: Edit the default Name tag. In the Amazon
	//   Route 53 console, the list of your health checks includes a Name column that
	//   lets you see the name that you've given to each health check.
	Key *string

	// The value of Value depends on the operation that you want to perform:
	//
	//   - Add a tag to a health check or hosted zone: Value is the value that you want
	//   to give the new tag.
	//
	//   - Edit a tag: Value is the new value that you want to assign the tag.
	Value *string

	noSmithyDocumentSerde
}

// A complex type that contains settings for a traffic policy.
type TrafficPolicy struct {

	// The definition of a traffic policy in JSON format. You specify the JSON
	// document to use for a new traffic policy in the CreateTrafficPolicy request.
	// For more information about the JSON format, see [Traffic Policy Document Format].
	//
	// [Traffic Policy Document Format]: https://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html
	//
	// This member is required.
	Document *string

	// The ID that Amazon Route 53 assigned to a traffic policy when you created it.
	//
	// This member is required.
	Id *string

	// The name that you specified when you created the traffic policy.
	//
	// This member is required.
	Name *string

	// The DNS type of the resource record sets that Amazon Route 53 creates when you
	// use a traffic policy to create a traffic policy instance.
	//
	// This member is required.
	Type RRType

	// The version number that Amazon Route 53 assigns to a traffic policy. For a new
	// traffic policy, the value of Version is always 1.
	//
	// This member is required.
	Version *int32

	// The comment that you specify in the CreateTrafficPolicy request, if any.
	Comment *string

	noSmithyDocumentSerde
}

// A complex type that contains settings for the new traffic policy instance.
type TrafficPolicyInstance struct {

	// The ID of the hosted zone that Amazon Route 53 created resource record sets in.
	//
	// This member is required.
	HostedZoneId *string

	// The ID that Amazon Route 53 assigned to the new traffic policy instance.
	//
	// This member is required.
	Id *string

	// If State is Failed , an explanation of the reason for the failure. If State is
	// another value, Message is empty.
	//
	// This member is required.
	Message *string

	// The DNS name, such as www.example.com, for which Amazon Route 53 responds to
	// queries by using the resource record sets that are associated with this traffic
	// policy instance.
	//
	// This member is required.
	Name *string

	// The value of State is one of the following values:
	//
	// Applied Amazon Route 53 has finished creating resource record sets, and changes
	// have propagated to all Route 53 edge locations.
	//
	// Creating Route 53 is creating the resource record sets. Use
	// GetTrafficPolicyInstance to confirm that the CreateTrafficPolicyInstance
	// request completed successfully.
	//
	// Failed Route 53 wasn't able to create or update the resource record sets. When
	// the value of State is Failed , see Message for an explanation of what caused
	// the request to fail.
	//
	// This member is required.
	State *string

	// The TTL that Amazon Route 53 assigned to all of the resource record sets that
	// it created in the specified hosted zone.
	//
	// This member is required.
	TTL *int64

	// The ID of the traffic policy that Amazon Route 53 used to create resource
	// record sets in the specified hosted zone.
	//
	// This member is required.
	TrafficPolicyId *string

	// The DNS type that Amazon Route 53 assigned to all of the resource record sets
	// that it created for this traffic policy instance.
	//
	// This member is required.
	TrafficPolicyType RRType

	// The version of the traffic policy that Amazon Route 53 used to create resource
	// record sets in the specified hosted zone.
	//
	// This member is required.
	TrafficPolicyVersion *int32

	noSmithyDocumentSerde
}

// A complex type that contains information about the latest version of one
// traffic policy that is associated with the current Amazon Web Services account.
type TrafficPolicySummary struct {

	// The ID that Amazon Route 53 assigned to the traffic policy when you created it.
	//
	// This member is required.
	Id *string

	// The version number of the latest version of the traffic policy.
	//
	// This member is required.
	LatestVersion *int32

	// The name that you specified for the traffic policy when you created it.
	//
	// This member is required.
	Name *string

	// The number of traffic policies that are associated with the current Amazon Web
	// Services account.
	//
	// This member is required.
	TrafficPolicyCount *int32

	// The DNS type of the resource record sets that Amazon Route 53 creates when you
	// use a traffic policy to create a traffic policy instance.
	//
	// This member is required.
	Type RRType

	noSmithyDocumentSerde
}

// (Private hosted zones only) A complex type that contains information about an
// Amazon VPC.
//
// If you associate a private hosted zone with an Amazon VPC when you make a [CreateHostedZone]
// request, the following parameters are also required.
//
// [CreateHostedZone]: https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateHostedZone.html
type VPC struct {

	// (Private hosted zones only) The ID of an Amazon VPC.
	VPCId *string

	// (Private hosted zones only) The region that an Amazon VPC was created in.
	VPCRegion VPCRegion

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
