// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1/data_foundry_service.proto

package aiplatformpb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	DataFoundryService_GenerateSyntheticData_FullMethodName = "/google.cloud.aiplatform.v1.DataFoundryService/GenerateSyntheticData"
)

// DataFoundryServiceClient is the client API for DataFoundryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DataFoundryServiceClient interface {
	// Generates synthetic data based on the provided configuration.
	GenerateSyntheticData(ctx context.Context, in *GenerateSyntheticDataRequest, opts ...grpc.CallOption) (*GenerateSyntheticDataResponse, error)
}

type dataFoundryServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDataFoundryServiceClient(cc grpc.ClientConnInterface) DataFoundryServiceClient {
	return &dataFoundryServiceClient{cc}
}

func (c *dataFoundryServiceClient) GenerateSyntheticData(ctx context.Context, in *GenerateSyntheticDataRequest, opts ...grpc.CallOption) (*GenerateSyntheticDataResponse, error) {
	out := new(GenerateSyntheticDataResponse)
	err := c.cc.Invoke(ctx, DataFoundryService_GenerateSyntheticData_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataFoundryServiceServer is the server API for DataFoundryService service.
// All implementations should embed UnimplementedDataFoundryServiceServer
// for forward compatibility
type DataFoundryServiceServer interface {
	// Generates synthetic data based on the provided configuration.
	GenerateSyntheticData(context.Context, *GenerateSyntheticDataRequest) (*GenerateSyntheticDataResponse, error)
}

// UnimplementedDataFoundryServiceServer should be embedded to have forward compatible implementations.
type UnimplementedDataFoundryServiceServer struct {
}

func (UnimplementedDataFoundryServiceServer) GenerateSyntheticData(context.Context, *GenerateSyntheticDataRequest) (*GenerateSyntheticDataResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateSyntheticData not implemented")
}

// UnsafeDataFoundryServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DataFoundryServiceServer will
// result in compilation errors.
type UnsafeDataFoundryServiceServer interface {
	mustEmbedUnimplementedDataFoundryServiceServer()
}

func RegisterDataFoundryServiceServer(s grpc.ServiceRegistrar, srv DataFoundryServiceServer) {
	s.RegisterService(&DataFoundryService_ServiceDesc, srv)
}

func _DataFoundryService_GenerateSyntheticData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateSyntheticDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataFoundryServiceServer).GenerateSyntheticData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DataFoundryService_GenerateSyntheticData_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataFoundryServiceServer).GenerateSyntheticData(ctx, req.(*GenerateSyntheticDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DataFoundryService_ServiceDesc is the grpc.ServiceDesc for DataFoundryService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DataFoundryService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1.DataFoundryService",
	HandlerType: (*DataFoundryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GenerateSyntheticData",
			Handler:    _DataFoundryService_GenerateSyntheticData_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1/data_foundry_service.proto",
}
