// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/aiplatform/v1beta1/vertex_rag_data.proto

package aiplatformpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// RagFile state.
type FileStatus_State int32

const (
	// RagFile state is unspecified.
	FileStatus_STATE_UNSPECIFIED FileStatus_State = 0
	// RagFile resource has been created and indexed successfully.
	FileStatus_ACTIVE FileStatus_State = 1
	// RagFile resource is in a problematic state.
	// See `error_message` field for details.
	FileStatus_ERROR FileStatus_State = 2
)

// Enum value maps for FileStatus_State.
var (
	FileStatus_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "ERROR",
	}
	FileStatus_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"ERROR":             2,
	}
)

func (x FileStatus_State) Enum() *FileStatus_State {
	p := new(FileStatus_State)
	*p = x
	return p
}

func (x FileStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FileStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_enumTypes[0].Descriptor()
}

func (FileStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_enumTypes[0]
}

func (x FileStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FileStatus_State.Descriptor instead.
func (FileStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{2, 0}
}

// RagCorpus life state.
type CorpusStatus_State int32

const (
	// This state is not supposed to happen.
	CorpusStatus_UNKNOWN CorpusStatus_State = 0
	// RagCorpus resource entry is initialized, but hasn't done validation.
	CorpusStatus_INITIALIZED CorpusStatus_State = 1
	// RagCorpus is provisioned successfully and is ready to serve.
	CorpusStatus_ACTIVE CorpusStatus_State = 2
	// RagCorpus is in a problematic situation.
	// See `error_message` field for details.
	CorpusStatus_ERROR CorpusStatus_State = 3
)

// Enum value maps for CorpusStatus_State.
var (
	CorpusStatus_State_name = map[int32]string{
		0: "UNKNOWN",
		1: "INITIALIZED",
		2: "ACTIVE",
		3: "ERROR",
	}
	CorpusStatus_State_value = map[string]int32{
		"UNKNOWN":     0,
		"INITIALIZED": 1,
		"ACTIVE":      2,
		"ERROR":       3,
	}
)

func (x CorpusStatus_State) Enum() *CorpusStatus_State {
	p := new(CorpusStatus_State)
	*p = x
	return p
}

func (x CorpusStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CorpusStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_enumTypes[1].Descriptor()
}

func (CorpusStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_enumTypes[1]
}

func (x CorpusStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CorpusStatus_State.Descriptor instead.
func (CorpusStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{4, 0}
}

// The type of the RagFile.
type RagFile_RagFileType int32

const (
	// RagFile type is unspecified.
	RagFile_RAG_FILE_TYPE_UNSPECIFIED RagFile_RagFileType = 0
	// RagFile type is TXT.
	RagFile_RAG_FILE_TYPE_TXT RagFile_RagFileType = 1
	// RagFile type is PDF.
	RagFile_RAG_FILE_TYPE_PDF RagFile_RagFileType = 2
)

// Enum value maps for RagFile_RagFileType.
var (
	RagFile_RagFileType_name = map[int32]string{
		0: "RAG_FILE_TYPE_UNSPECIFIED",
		1: "RAG_FILE_TYPE_TXT",
		2: "RAG_FILE_TYPE_PDF",
	}
	RagFile_RagFileType_value = map[string]int32{
		"RAG_FILE_TYPE_UNSPECIFIED": 0,
		"RAG_FILE_TYPE_TXT":         1,
		"RAG_FILE_TYPE_PDF":         2,
	}
)

func (x RagFile_RagFileType) Enum() *RagFile_RagFileType {
	p := new(RagFile_RagFileType)
	*p = x
	return p
}

func (x RagFile_RagFileType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RagFile_RagFileType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_enumTypes[2].Descriptor()
}

func (RagFile_RagFileType) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_enumTypes[2]
}

func (x RagFile_RagFileType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RagFile_RagFileType.Descriptor instead.
func (RagFile_RagFileType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{6, 0}
}

// Config for the embedding model to use for RAG.
type RagEmbeddingModelConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The model config to use.
	//
	// Types that are assignable to ModelConfig:
	//
	//	*RagEmbeddingModelConfig_VertexPredictionEndpoint_
	//	*RagEmbeddingModelConfig_HybridSearchConfig_
	ModelConfig isRagEmbeddingModelConfig_ModelConfig `protobuf_oneof:"model_config"`
}

func (x *RagEmbeddingModelConfig) Reset() {
	*x = RagEmbeddingModelConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagEmbeddingModelConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagEmbeddingModelConfig) ProtoMessage() {}

func (x *RagEmbeddingModelConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagEmbeddingModelConfig.ProtoReflect.Descriptor instead.
func (*RagEmbeddingModelConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{0}
}

func (m *RagEmbeddingModelConfig) GetModelConfig() isRagEmbeddingModelConfig_ModelConfig {
	if m != nil {
		return m.ModelConfig
	}
	return nil
}

func (x *RagEmbeddingModelConfig) GetVertexPredictionEndpoint() *RagEmbeddingModelConfig_VertexPredictionEndpoint {
	if x, ok := x.GetModelConfig().(*RagEmbeddingModelConfig_VertexPredictionEndpoint_); ok {
		return x.VertexPredictionEndpoint
	}
	return nil
}

func (x *RagEmbeddingModelConfig) GetHybridSearchConfig() *RagEmbeddingModelConfig_HybridSearchConfig {
	if x, ok := x.GetModelConfig().(*RagEmbeddingModelConfig_HybridSearchConfig_); ok {
		return x.HybridSearchConfig
	}
	return nil
}

type isRagEmbeddingModelConfig_ModelConfig interface {
	isRagEmbeddingModelConfig_ModelConfig()
}

type RagEmbeddingModelConfig_VertexPredictionEndpoint_ struct {
	// The Vertex AI Prediction Endpoint that either refers to a publisher model
	// or an endpoint that is hosting a 1P fine-tuned text embedding model.
	// Endpoints hosting non-1P fine-tuned text embedding models are
	// currently not supported.
	// This is used for dense vector search.
	VertexPredictionEndpoint *RagEmbeddingModelConfig_VertexPredictionEndpoint `protobuf:"bytes,1,opt,name=vertex_prediction_endpoint,json=vertexPredictionEndpoint,proto3,oneof"`
}

type RagEmbeddingModelConfig_HybridSearchConfig_ struct {
	// Configuration for hybrid search.
	HybridSearchConfig *RagEmbeddingModelConfig_HybridSearchConfig `protobuf:"bytes,2,opt,name=hybrid_search_config,json=hybridSearchConfig,proto3,oneof"`
}

func (*RagEmbeddingModelConfig_VertexPredictionEndpoint_) isRagEmbeddingModelConfig_ModelConfig() {}

func (*RagEmbeddingModelConfig_HybridSearchConfig_) isRagEmbeddingModelConfig_ModelConfig() {}

// Config for the Vector DB to use for RAG.
type RagVectorDbConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The config for the Vector DB.
	//
	// Types that are assignable to VectorDb:
	//
	//	*RagVectorDbConfig_RagManagedDb_
	//	*RagVectorDbConfig_Weaviate_
	//	*RagVectorDbConfig_Pinecone_
	//	*RagVectorDbConfig_VertexFeatureStore_
	//	*RagVectorDbConfig_VertexVectorSearch_
	VectorDb isRagVectorDbConfig_VectorDb `protobuf_oneof:"vector_db"`
	// Authentication config for the chosen Vector DB.
	ApiAuth *ApiAuth `protobuf:"bytes,5,opt,name=api_auth,json=apiAuth,proto3" json:"api_auth,omitempty"`
	// Optional. Immutable. The embedding model config of the Vector DB.
	RagEmbeddingModelConfig *RagEmbeddingModelConfig `protobuf:"bytes,7,opt,name=rag_embedding_model_config,json=ragEmbeddingModelConfig,proto3" json:"rag_embedding_model_config,omitempty"`
}

func (x *RagVectorDbConfig) Reset() {
	*x = RagVectorDbConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagVectorDbConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagVectorDbConfig) ProtoMessage() {}

func (x *RagVectorDbConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagVectorDbConfig.ProtoReflect.Descriptor instead.
func (*RagVectorDbConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{1}
}

func (m *RagVectorDbConfig) GetVectorDb() isRagVectorDbConfig_VectorDb {
	if m != nil {
		return m.VectorDb
	}
	return nil
}

func (x *RagVectorDbConfig) GetRagManagedDb() *RagVectorDbConfig_RagManagedDb {
	if x, ok := x.GetVectorDb().(*RagVectorDbConfig_RagManagedDb_); ok {
		return x.RagManagedDb
	}
	return nil
}

func (x *RagVectorDbConfig) GetWeaviate() *RagVectorDbConfig_Weaviate {
	if x, ok := x.GetVectorDb().(*RagVectorDbConfig_Weaviate_); ok {
		return x.Weaviate
	}
	return nil
}

func (x *RagVectorDbConfig) GetPinecone() *RagVectorDbConfig_Pinecone {
	if x, ok := x.GetVectorDb().(*RagVectorDbConfig_Pinecone_); ok {
		return x.Pinecone
	}
	return nil
}

func (x *RagVectorDbConfig) GetVertexFeatureStore() *RagVectorDbConfig_VertexFeatureStore {
	if x, ok := x.GetVectorDb().(*RagVectorDbConfig_VertexFeatureStore_); ok {
		return x.VertexFeatureStore
	}
	return nil
}

func (x *RagVectorDbConfig) GetVertexVectorSearch() *RagVectorDbConfig_VertexVectorSearch {
	if x, ok := x.GetVectorDb().(*RagVectorDbConfig_VertexVectorSearch_); ok {
		return x.VertexVectorSearch
	}
	return nil
}

func (x *RagVectorDbConfig) GetApiAuth() *ApiAuth {
	if x != nil {
		return x.ApiAuth
	}
	return nil
}

func (x *RagVectorDbConfig) GetRagEmbeddingModelConfig() *RagEmbeddingModelConfig {
	if x != nil {
		return x.RagEmbeddingModelConfig
	}
	return nil
}

type isRagVectorDbConfig_VectorDb interface {
	isRagVectorDbConfig_VectorDb()
}

type RagVectorDbConfig_RagManagedDb_ struct {
	// The config for the RAG-managed Vector DB.
	RagManagedDb *RagVectorDbConfig_RagManagedDb `protobuf:"bytes,1,opt,name=rag_managed_db,json=ragManagedDb,proto3,oneof"`
}

type RagVectorDbConfig_Weaviate_ struct {
	// The config for the Weaviate.
	Weaviate *RagVectorDbConfig_Weaviate `protobuf:"bytes,2,opt,name=weaviate,proto3,oneof"`
}

type RagVectorDbConfig_Pinecone_ struct {
	// The config for the Pinecone.
	Pinecone *RagVectorDbConfig_Pinecone `protobuf:"bytes,3,opt,name=pinecone,proto3,oneof"`
}

type RagVectorDbConfig_VertexFeatureStore_ struct {
	// The config for the Vertex Feature Store.
	VertexFeatureStore *RagVectorDbConfig_VertexFeatureStore `protobuf:"bytes,4,opt,name=vertex_feature_store,json=vertexFeatureStore,proto3,oneof"`
}

type RagVectorDbConfig_VertexVectorSearch_ struct {
	// The config for the Vertex Vector Search.
	VertexVectorSearch *RagVectorDbConfig_VertexVectorSearch `protobuf:"bytes,6,opt,name=vertex_vector_search,json=vertexVectorSearch,proto3,oneof"`
}

func (*RagVectorDbConfig_RagManagedDb_) isRagVectorDbConfig_VectorDb() {}

func (*RagVectorDbConfig_Weaviate_) isRagVectorDbConfig_VectorDb() {}

func (*RagVectorDbConfig_Pinecone_) isRagVectorDbConfig_VectorDb() {}

func (*RagVectorDbConfig_VertexFeatureStore_) isRagVectorDbConfig_VectorDb() {}

func (*RagVectorDbConfig_VertexVectorSearch_) isRagVectorDbConfig_VectorDb() {}

// RagFile status.
type FileStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. RagFile state.
	State FileStatus_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.aiplatform.v1beta1.FileStatus_State" json:"state,omitempty"`
	// Output only. Only when the `state` field is ERROR.
	ErrorStatus string `protobuf:"bytes,2,opt,name=error_status,json=errorStatus,proto3" json:"error_status,omitempty"`
}

func (x *FileStatus) Reset() {
	*x = FileStatus{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FileStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileStatus) ProtoMessage() {}

func (x *FileStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileStatus.ProtoReflect.Descriptor instead.
func (*FileStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{2}
}

func (x *FileStatus) GetState() FileStatus_State {
	if x != nil {
		return x.State
	}
	return FileStatus_STATE_UNSPECIFIED
}

func (x *FileStatus) GetErrorStatus() string {
	if x != nil {
		return x.ErrorStatus
	}
	return ""
}

// Config for the Vertex AI Search.
type VertexAiSearchConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Vertex AI Search Serving Config resource full name. For example,
	// `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}/servingConfigs/{serving_config}`
	// or
	// `projects/{project}/locations/{location}/collections/{collection}/dataStores/{data_store}/servingConfigs/{serving_config}`.
	ServingConfig string `protobuf:"bytes,1,opt,name=serving_config,json=servingConfig,proto3" json:"serving_config,omitempty"`
}

func (x *VertexAiSearchConfig) Reset() {
	*x = VertexAiSearchConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VertexAiSearchConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VertexAiSearchConfig) ProtoMessage() {}

func (x *VertexAiSearchConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VertexAiSearchConfig.ProtoReflect.Descriptor instead.
func (*VertexAiSearchConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{3}
}

func (x *VertexAiSearchConfig) GetServingConfig() string {
	if x != nil {
		return x.ServingConfig
	}
	return ""
}

// RagCorpus status.
type CorpusStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. RagCorpus life state.
	State CorpusStatus_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.aiplatform.v1beta1.CorpusStatus_State" json:"state,omitempty"`
	// Output only. Only when the `state` field is ERROR.
	ErrorStatus string `protobuf:"bytes,2,opt,name=error_status,json=errorStatus,proto3" json:"error_status,omitempty"`
}

func (x *CorpusStatus) Reset() {
	*x = CorpusStatus{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CorpusStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CorpusStatus) ProtoMessage() {}

func (x *CorpusStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CorpusStatus.ProtoReflect.Descriptor instead.
func (*CorpusStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{4}
}

func (x *CorpusStatus) GetState() CorpusStatus_State {
	if x != nil {
		return x.State
	}
	return CorpusStatus_UNKNOWN
}

func (x *CorpusStatus) GetErrorStatus() string {
	if x != nil {
		return x.ErrorStatus
	}
	return ""
}

// A RagCorpus is a RagFile container and a project can have multiple
// RagCorpora.
type RagCorpus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The backend config of the RagCorpus.
	// It can be data store and/or retrieval engine.
	//
	// Types that are assignable to BackendConfig:
	//
	//	*RagCorpus_VectorDbConfig
	//	*RagCorpus_VertexAiSearchConfig
	BackendConfig isRagCorpus_BackendConfig `protobuf_oneof:"backend_config"`
	// Output only. The resource name of the RagCorpus.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the RagCorpus.
	// The name can be up to 128 characters long and can consist of any UTF-8
	// characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The description of the RagCorpus.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Immutable. The embedding model config of the RagCorpus.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/vertex_rag_data.proto.
	RagEmbeddingModelConfig *RagEmbeddingModelConfig `protobuf:"bytes,6,opt,name=rag_embedding_model_config,json=ragEmbeddingModelConfig,proto3" json:"rag_embedding_model_config,omitempty"`
	// Optional. Immutable. The Vector DB config of the RagCorpus.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/vertex_rag_data.proto.
	RagVectorDbConfig *RagVectorDbConfig `protobuf:"bytes,7,opt,name=rag_vector_db_config,json=ragVectorDbConfig,proto3" json:"rag_vector_db_config,omitempty"`
	// Output only. Timestamp when this RagCorpus was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when this RagCorpus was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. RagCorpus state.
	CorpusStatus *CorpusStatus `protobuf:"bytes,8,opt,name=corpus_status,json=corpusStatus,proto3" json:"corpus_status,omitempty"`
	// Output only. Number of RagFiles in the RagCorpus.
	RagFilesCount int32 `protobuf:"varint,11,opt,name=rag_files_count,json=ragFilesCount,proto3" json:"rag_files_count,omitempty"`
	// Optional. Immutable. The CMEK key name used to encrypt at-rest data related
	// to this Corpus. Only applicable to RagManagedDb option for Vector DB. This
	// field can only be set at corpus creation time, and cannot be updated or
	// deleted.
	EncryptionSpec *EncryptionSpec `protobuf:"bytes,12,opt,name=encryption_spec,json=encryptionSpec,proto3" json:"encryption_spec,omitempty"`
	// Optional. The corpus type config of the RagCorpus.
	CorpusTypeConfig *RagCorpus_CorpusTypeConfig `protobuf:"bytes,13,opt,name=corpus_type_config,json=corpusTypeConfig,proto3" json:"corpus_type_config,omitempty"`
}

func (x *RagCorpus) Reset() {
	*x = RagCorpus{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagCorpus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagCorpus) ProtoMessage() {}

func (x *RagCorpus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagCorpus.ProtoReflect.Descriptor instead.
func (*RagCorpus) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{5}
}

func (m *RagCorpus) GetBackendConfig() isRagCorpus_BackendConfig {
	if m != nil {
		return m.BackendConfig
	}
	return nil
}

func (x *RagCorpus) GetVectorDbConfig() *RagVectorDbConfig {
	if x, ok := x.GetBackendConfig().(*RagCorpus_VectorDbConfig); ok {
		return x.VectorDbConfig
	}
	return nil
}

func (x *RagCorpus) GetVertexAiSearchConfig() *VertexAiSearchConfig {
	if x, ok := x.GetBackendConfig().(*RagCorpus_VertexAiSearchConfig); ok {
		return x.VertexAiSearchConfig
	}
	return nil
}

func (x *RagCorpus) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RagCorpus) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *RagCorpus) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/vertex_rag_data.proto.
func (x *RagCorpus) GetRagEmbeddingModelConfig() *RagEmbeddingModelConfig {
	if x != nil {
		return x.RagEmbeddingModelConfig
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/vertex_rag_data.proto.
func (x *RagCorpus) GetRagVectorDbConfig() *RagVectorDbConfig {
	if x != nil {
		return x.RagVectorDbConfig
	}
	return nil
}

func (x *RagCorpus) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *RagCorpus) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *RagCorpus) GetCorpusStatus() *CorpusStatus {
	if x != nil {
		return x.CorpusStatus
	}
	return nil
}

func (x *RagCorpus) GetRagFilesCount() int32 {
	if x != nil {
		return x.RagFilesCount
	}
	return 0
}

func (x *RagCorpus) GetEncryptionSpec() *EncryptionSpec {
	if x != nil {
		return x.EncryptionSpec
	}
	return nil
}

func (x *RagCorpus) GetCorpusTypeConfig() *RagCorpus_CorpusTypeConfig {
	if x != nil {
		return x.CorpusTypeConfig
	}
	return nil
}

type isRagCorpus_BackendConfig interface {
	isRagCorpus_BackendConfig()
}

type RagCorpus_VectorDbConfig struct {
	// Optional. Immutable. The config for the Vector DBs.
	VectorDbConfig *RagVectorDbConfig `protobuf:"bytes,9,opt,name=vector_db_config,json=vectorDbConfig,proto3,oneof"`
}

type RagCorpus_VertexAiSearchConfig struct {
	// Optional. Immutable. The config for the Vertex AI Search.
	VertexAiSearchConfig *VertexAiSearchConfig `protobuf:"bytes,10,opt,name=vertex_ai_search_config,json=vertexAiSearchConfig,proto3,oneof"`
}

func (*RagCorpus_VectorDbConfig) isRagCorpus_BackendConfig() {}

func (*RagCorpus_VertexAiSearchConfig) isRagCorpus_BackendConfig() {}

// A RagFile contains user data for chunking, embedding and indexing.
type RagFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The origin location of the RagFile if it is imported from Google Cloud
	// Storage or Google Drive.
	//
	// Types that are assignable to RagFileSource:
	//
	//	*RagFile_GcsSource
	//	*RagFile_GoogleDriveSource
	//	*RagFile_DirectUploadSource
	//	*RagFile_SlackSource
	//	*RagFile_JiraSource
	//	*RagFile_SharePointSources
	RagFileSource isRagFile_RagFileSource `protobuf_oneof:"rag_file_source"`
	// Output only. The resource name of the RagFile.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the RagFile.
	// The name can be up to 128 characters long and can consist of any UTF-8
	// characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The description of the RagFile.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The size of the RagFile in bytes.
	SizeBytes int64 `protobuf:"varint,4,opt,name=size_bytes,json=sizeBytes,proto3" json:"size_bytes,omitempty"`
	// Output only. The type of the RagFile.
	RagFileType RagFile_RagFileType `protobuf:"varint,5,opt,name=rag_file_type,json=ragFileType,proto3,enum=google.cloud.aiplatform.v1beta1.RagFile_RagFileType" json:"rag_file_type,omitempty"`
	// Output only. Timestamp when this RagFile was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when this RagFile was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. State of the RagFile.
	FileStatus *FileStatus `protobuf:"bytes,13,opt,name=file_status,json=fileStatus,proto3" json:"file_status,omitempty"`
	// Output only. The metadata for metadata search. The contents will be
	// be in JSON format.
	UserMetadata string `protobuf:"bytes,15,opt,name=user_metadata,json=userMetadata,proto3" json:"user_metadata,omitempty"`
}

func (x *RagFile) Reset() {
	*x = RagFile{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagFile) ProtoMessage() {}

func (x *RagFile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagFile.ProtoReflect.Descriptor instead.
func (*RagFile) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{6}
}

func (m *RagFile) GetRagFileSource() isRagFile_RagFileSource {
	if m != nil {
		return m.RagFileSource
	}
	return nil
}

func (x *RagFile) GetGcsSource() *GcsSource {
	if x, ok := x.GetRagFileSource().(*RagFile_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (x *RagFile) GetGoogleDriveSource() *GoogleDriveSource {
	if x, ok := x.GetRagFileSource().(*RagFile_GoogleDriveSource); ok {
		return x.GoogleDriveSource
	}
	return nil
}

func (x *RagFile) GetDirectUploadSource() *DirectUploadSource {
	if x, ok := x.GetRagFileSource().(*RagFile_DirectUploadSource); ok {
		return x.DirectUploadSource
	}
	return nil
}

func (x *RagFile) GetSlackSource() *SlackSource {
	if x, ok := x.GetRagFileSource().(*RagFile_SlackSource); ok {
		return x.SlackSource
	}
	return nil
}

func (x *RagFile) GetJiraSource() *JiraSource {
	if x, ok := x.GetRagFileSource().(*RagFile_JiraSource); ok {
		return x.JiraSource
	}
	return nil
}

func (x *RagFile) GetSharePointSources() *SharePointSources {
	if x, ok := x.GetRagFileSource().(*RagFile_SharePointSources); ok {
		return x.SharePointSources
	}
	return nil
}

func (x *RagFile) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RagFile) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *RagFile) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *RagFile) GetSizeBytes() int64 {
	if x != nil {
		return x.SizeBytes
	}
	return 0
}

func (x *RagFile) GetRagFileType() RagFile_RagFileType {
	if x != nil {
		return x.RagFileType
	}
	return RagFile_RAG_FILE_TYPE_UNSPECIFIED
}

func (x *RagFile) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *RagFile) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *RagFile) GetFileStatus() *FileStatus {
	if x != nil {
		return x.FileStatus
	}
	return nil
}

func (x *RagFile) GetUserMetadata() string {
	if x != nil {
		return x.UserMetadata
	}
	return ""
}

type isRagFile_RagFileSource interface {
	isRagFile_RagFileSource()
}

type RagFile_GcsSource struct {
	// Output only. Google Cloud Storage location of the RagFile.
	// It does not support wildcards in the Cloud Storage uri for now.
	GcsSource *GcsSource `protobuf:"bytes,8,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

type RagFile_GoogleDriveSource struct {
	// Output only. Google Drive location. Supports importing individual files
	// as well as Google Drive folders.
	GoogleDriveSource *GoogleDriveSource `protobuf:"bytes,9,opt,name=google_drive_source,json=googleDriveSource,proto3,oneof"`
}

type RagFile_DirectUploadSource struct {
	// Output only. The RagFile is encapsulated and uploaded in the
	// UploadRagFile request.
	DirectUploadSource *DirectUploadSource `protobuf:"bytes,10,opt,name=direct_upload_source,json=directUploadSource,proto3,oneof"`
}

type RagFile_SlackSource struct {
	// The RagFile is imported from a Slack channel.
	SlackSource *SlackSource `protobuf:"bytes,11,opt,name=slack_source,json=slackSource,proto3,oneof"`
}

type RagFile_JiraSource struct {
	// The RagFile is imported from a Jira query.
	JiraSource *JiraSource `protobuf:"bytes,12,opt,name=jira_source,json=jiraSource,proto3,oneof"`
}

type RagFile_SharePointSources struct {
	// The RagFile is imported from a SharePoint source.
	SharePointSources *SharePointSources `protobuf:"bytes,14,opt,name=share_point_sources,json=sharePointSources,proto3,oneof"`
}

func (*RagFile_GcsSource) isRagFile_RagFileSource() {}

func (*RagFile_GoogleDriveSource) isRagFile_RagFileSource() {}

func (*RagFile_DirectUploadSource) isRagFile_RagFileSource() {}

func (*RagFile_SlackSource) isRagFile_RagFileSource() {}

func (*RagFile_JiraSource) isRagFile_RagFileSource() {}

func (*RagFile_SharePointSources) isRagFile_RagFileSource() {}

// A RagChunk includes the content of a chunk of a RagFile, and associated
// metadata.
type RagChunk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The content of the chunk.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// If populated, represents where the chunk starts and ends in the document.
	PageSpan *RagChunk_PageSpan `protobuf:"bytes,2,opt,name=page_span,json=pageSpan,proto3,oneof" json:"page_span,omitempty"`
}

func (x *RagChunk) Reset() {
	*x = RagChunk{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagChunk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagChunk) ProtoMessage() {}

func (x *RagChunk) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagChunk.ProtoReflect.Descriptor instead.
func (*RagChunk) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{7}
}

func (x *RagChunk) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *RagChunk) GetPageSpan() *RagChunk_PageSpan {
	if x != nil {
		return x.PageSpan
	}
	return nil
}

// Specifies the size and overlap of chunks for RagFiles.
type RagFileChunkingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the chunking config for RagFiles.
	//
	// Types that are assignable to ChunkingConfig:
	//
	//	*RagFileChunkingConfig_FixedLengthChunking_
	ChunkingConfig isRagFileChunkingConfig_ChunkingConfig `protobuf_oneof:"chunking_config"`
	// The size of the chunks.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/vertex_rag_data.proto.
	ChunkSize int32 `protobuf:"varint,1,opt,name=chunk_size,json=chunkSize,proto3" json:"chunk_size,omitempty"`
	// The overlap between chunks.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/vertex_rag_data.proto.
	ChunkOverlap int32 `protobuf:"varint,2,opt,name=chunk_overlap,json=chunkOverlap,proto3" json:"chunk_overlap,omitempty"`
}

func (x *RagFileChunkingConfig) Reset() {
	*x = RagFileChunkingConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagFileChunkingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagFileChunkingConfig) ProtoMessage() {}

func (x *RagFileChunkingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagFileChunkingConfig.ProtoReflect.Descriptor instead.
func (*RagFileChunkingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{8}
}

func (m *RagFileChunkingConfig) GetChunkingConfig() isRagFileChunkingConfig_ChunkingConfig {
	if m != nil {
		return m.ChunkingConfig
	}
	return nil
}

func (x *RagFileChunkingConfig) GetFixedLengthChunking() *RagFileChunkingConfig_FixedLengthChunking {
	if x, ok := x.GetChunkingConfig().(*RagFileChunkingConfig_FixedLengthChunking_); ok {
		return x.FixedLengthChunking
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/vertex_rag_data.proto.
func (x *RagFileChunkingConfig) GetChunkSize() int32 {
	if x != nil {
		return x.ChunkSize
	}
	return 0
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/vertex_rag_data.proto.
func (x *RagFileChunkingConfig) GetChunkOverlap() int32 {
	if x != nil {
		return x.ChunkOverlap
	}
	return 0
}

type isRagFileChunkingConfig_ChunkingConfig interface {
	isRagFileChunkingConfig_ChunkingConfig()
}

type RagFileChunkingConfig_FixedLengthChunking_ struct {
	// Specifies the fixed length chunking config.
	FixedLengthChunking *RagFileChunkingConfig_FixedLengthChunking `protobuf:"bytes,3,opt,name=fixed_length_chunking,json=fixedLengthChunking,proto3,oneof"`
}

func (*RagFileChunkingConfig_FixedLengthChunking_) isRagFileChunkingConfig_ChunkingConfig() {}

// Specifies the transformation config for RagFiles.
type RagFileTransformationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the chunking config for RagFiles.
	RagFileChunkingConfig *RagFileChunkingConfig `protobuf:"bytes,1,opt,name=rag_file_chunking_config,json=ragFileChunkingConfig,proto3" json:"rag_file_chunking_config,omitempty"`
}

func (x *RagFileTransformationConfig) Reset() {
	*x = RagFileTransformationConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagFileTransformationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagFileTransformationConfig) ProtoMessage() {}

func (x *RagFileTransformationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagFileTransformationConfig.ProtoReflect.Descriptor instead.
func (*RagFileTransformationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{9}
}

func (x *RagFileTransformationConfig) GetRagFileChunkingConfig() *RagFileChunkingConfig {
	if x != nil {
		return x.RagFileChunkingConfig
	}
	return nil
}

// Specifies the parsing config for RagFiles.
type RagFileParsingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The parser to use for RagFiles.
	//
	// Types that are assignable to Parser:
	//
	//	*RagFileParsingConfig_AdvancedParser_
	//	*RagFileParsingConfig_LayoutParser_
	//	*RagFileParsingConfig_LlmParser_
	Parser isRagFileParsingConfig_Parser `protobuf_oneof:"parser"`
	// Whether to use advanced PDF parsing.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/vertex_rag_data.proto.
	UseAdvancedPdfParsing bool `protobuf:"varint,2,opt,name=use_advanced_pdf_parsing,json=useAdvancedPdfParsing,proto3" json:"use_advanced_pdf_parsing,omitempty"`
}

func (x *RagFileParsingConfig) Reset() {
	*x = RagFileParsingConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagFileParsingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagFileParsingConfig) ProtoMessage() {}

func (x *RagFileParsingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagFileParsingConfig.ProtoReflect.Descriptor instead.
func (*RagFileParsingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{10}
}

func (m *RagFileParsingConfig) GetParser() isRagFileParsingConfig_Parser {
	if m != nil {
		return m.Parser
	}
	return nil
}

func (x *RagFileParsingConfig) GetAdvancedParser() *RagFileParsingConfig_AdvancedParser {
	if x, ok := x.GetParser().(*RagFileParsingConfig_AdvancedParser_); ok {
		return x.AdvancedParser
	}
	return nil
}

func (x *RagFileParsingConfig) GetLayoutParser() *RagFileParsingConfig_LayoutParser {
	if x, ok := x.GetParser().(*RagFileParsingConfig_LayoutParser_); ok {
		return x.LayoutParser
	}
	return nil
}

func (x *RagFileParsingConfig) GetLlmParser() *RagFileParsingConfig_LlmParser {
	if x, ok := x.GetParser().(*RagFileParsingConfig_LlmParser_); ok {
		return x.LlmParser
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/vertex_rag_data.proto.
func (x *RagFileParsingConfig) GetUseAdvancedPdfParsing() bool {
	if x != nil {
		return x.UseAdvancedPdfParsing
	}
	return false
}

type isRagFileParsingConfig_Parser interface {
	isRagFileParsingConfig_Parser()
}

type RagFileParsingConfig_AdvancedParser_ struct {
	// The Advanced Parser to use for RagFiles.
	AdvancedParser *RagFileParsingConfig_AdvancedParser `protobuf:"bytes,3,opt,name=advanced_parser,json=advancedParser,proto3,oneof"`
}

type RagFileParsingConfig_LayoutParser_ struct {
	// The Layout Parser to use for RagFiles.
	LayoutParser *RagFileParsingConfig_LayoutParser `protobuf:"bytes,4,opt,name=layout_parser,json=layoutParser,proto3,oneof"`
}

type RagFileParsingConfig_LlmParser_ struct {
	// The LLM Parser to use for RagFiles.
	LlmParser *RagFileParsingConfig_LlmParser `protobuf:"bytes,5,opt,name=llm_parser,json=llmParser,proto3,oneof"`
}

func (*RagFileParsingConfig_AdvancedParser_) isRagFileParsingConfig_Parser() {}

func (*RagFileParsingConfig_LayoutParser_) isRagFileParsingConfig_Parser() {}

func (*RagFileParsingConfig_LlmParser_) isRagFileParsingConfig_Parser() {}

// Metadata config for RagFile.
type RagFileMetadataConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the metadata schema source.
	//
	// Types that are assignable to MetadataSchemaSource:
	//
	//	*RagFileMetadataConfig_GcsMetadataSchemaSource
	//	*RagFileMetadataConfig_GoogleDriveMetadataSchemaSource
	//	*RagFileMetadataConfig_InlineMetadataSchemaSource
	MetadataSchemaSource isRagFileMetadataConfig_MetadataSchemaSource `protobuf_oneof:"metadata_schema_source"`
	// Specifies the metadata source.
	//
	// Types that are assignable to MetadataSource:
	//
	//	*RagFileMetadataConfig_GcsMetadataSource
	//	*RagFileMetadataConfig_GoogleDriveMetadataSource
	//	*RagFileMetadataConfig_InlineMetadataSource
	MetadataSource isRagFileMetadataConfig_MetadataSource `protobuf_oneof:"metadata_source"`
}

func (x *RagFileMetadataConfig) Reset() {
	*x = RagFileMetadataConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagFileMetadataConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagFileMetadataConfig) ProtoMessage() {}

func (x *RagFileMetadataConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagFileMetadataConfig.ProtoReflect.Descriptor instead.
func (*RagFileMetadataConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{11}
}

func (m *RagFileMetadataConfig) GetMetadataSchemaSource() isRagFileMetadataConfig_MetadataSchemaSource {
	if m != nil {
		return m.MetadataSchemaSource
	}
	return nil
}

func (x *RagFileMetadataConfig) GetGcsMetadataSchemaSource() *GcsSource {
	if x, ok := x.GetMetadataSchemaSource().(*RagFileMetadataConfig_GcsMetadataSchemaSource); ok {
		return x.GcsMetadataSchemaSource
	}
	return nil
}

func (x *RagFileMetadataConfig) GetGoogleDriveMetadataSchemaSource() *GoogleDriveSource {
	if x, ok := x.GetMetadataSchemaSource().(*RagFileMetadataConfig_GoogleDriveMetadataSchemaSource); ok {
		return x.GoogleDriveMetadataSchemaSource
	}
	return nil
}

func (x *RagFileMetadataConfig) GetInlineMetadataSchemaSource() string {
	if x, ok := x.GetMetadataSchemaSource().(*RagFileMetadataConfig_InlineMetadataSchemaSource); ok {
		return x.InlineMetadataSchemaSource
	}
	return ""
}

func (m *RagFileMetadataConfig) GetMetadataSource() isRagFileMetadataConfig_MetadataSource {
	if m != nil {
		return m.MetadataSource
	}
	return nil
}

func (x *RagFileMetadataConfig) GetGcsMetadataSource() *GcsSource {
	if x, ok := x.GetMetadataSource().(*RagFileMetadataConfig_GcsMetadataSource); ok {
		return x.GcsMetadataSource
	}
	return nil
}

func (x *RagFileMetadataConfig) GetGoogleDriveMetadataSource() *GoogleDriveSource {
	if x, ok := x.GetMetadataSource().(*RagFileMetadataConfig_GoogleDriveMetadataSource); ok {
		return x.GoogleDriveMetadataSource
	}
	return nil
}

func (x *RagFileMetadataConfig) GetInlineMetadataSource() string {
	if x, ok := x.GetMetadataSource().(*RagFileMetadataConfig_InlineMetadataSource); ok {
		return x.InlineMetadataSource
	}
	return ""
}

type isRagFileMetadataConfig_MetadataSchemaSource interface {
	isRagFileMetadataConfig_MetadataSchemaSource()
}

type RagFileMetadataConfig_GcsMetadataSchemaSource struct {
	// Google Cloud Storage location. Supports importing individual files as
	// well as entire Google Cloud Storage directories. Sample formats:
	// - `gs://bucket_name/my_directory/object_name/metadata_schema.json`
	// - `gs://bucket_name/my_directory`
	// If providing a directory, the metadata schema will be read from
	// the files that ends with "metadata_schema.json" in the directory.
	GcsMetadataSchemaSource *GcsSource `protobuf:"bytes,1,opt,name=gcs_metadata_schema_source,json=gcsMetadataSchemaSource,proto3,oneof"`
}

type RagFileMetadataConfig_GoogleDriveMetadataSchemaSource struct {
	// Google Drive location. Supports importing individual files as
	// well as Google Drive folders.
	// If providing a folder, the metadata schema will be read from
	// the files that ends with "metadata_schema.json" in the directory.
	GoogleDriveMetadataSchemaSource *GoogleDriveSource `protobuf:"bytes,2,opt,name=google_drive_metadata_schema_source,json=googleDriveMetadataSchemaSource,proto3,oneof"`
}

type RagFileMetadataConfig_InlineMetadataSchemaSource struct {
	// Inline metadata schema source. Must be a JSON string.
	InlineMetadataSchemaSource string `protobuf:"bytes,3,opt,name=inline_metadata_schema_source,json=inlineMetadataSchemaSource,proto3,oneof"`
}

func (*RagFileMetadataConfig_GcsMetadataSchemaSource) isRagFileMetadataConfig_MetadataSchemaSource() {
}

func (*RagFileMetadataConfig_GoogleDriveMetadataSchemaSource) isRagFileMetadataConfig_MetadataSchemaSource() {
}

func (*RagFileMetadataConfig_InlineMetadataSchemaSource) isRagFileMetadataConfig_MetadataSchemaSource() {
}

type isRagFileMetadataConfig_MetadataSource interface {
	isRagFileMetadataConfig_MetadataSource()
}

type RagFileMetadataConfig_GcsMetadataSource struct {
	// Google Cloud Storage location. Supports importing individual files as
	// well as entire Google Cloud Storage directories. Sample formats:
	// - `gs://bucket_name/my_directory/object_name/metadata.json`
	// - `gs://bucket_name/my_directory`
	// If providing a directory, the metadata will be read from
	// the files that ends with "metadata.json" in the directory.
	GcsMetadataSource *GcsSource `protobuf:"bytes,4,opt,name=gcs_metadata_source,json=gcsMetadataSource,proto3,oneof"`
}

type RagFileMetadataConfig_GoogleDriveMetadataSource struct {
	// Google Drive location. Supports importing individual files as
	// well as Google Drive folders.
	// If providing a directory, the metadata will be read from
	// the files that ends with "metadata.json" in the directory.
	GoogleDriveMetadataSource *GoogleDriveSource `protobuf:"bytes,5,opt,name=google_drive_metadata_source,json=googleDriveMetadataSource,proto3,oneof"`
}

type RagFileMetadataConfig_InlineMetadataSource struct {
	// Inline metadata source. Must be a JSON string.
	InlineMetadataSource string `protobuf:"bytes,6,opt,name=inline_metadata_source,json=inlineMetadataSource,proto3,oneof"`
}

func (*RagFileMetadataConfig_GcsMetadataSource) isRagFileMetadataConfig_MetadataSource() {}

func (*RagFileMetadataConfig_GoogleDriveMetadataSource) isRagFileMetadataConfig_MetadataSource() {}

func (*RagFileMetadataConfig_InlineMetadataSource) isRagFileMetadataConfig_MetadataSource() {}

// Config for uploading RagFile.
type UploadRagFileConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the size and overlap of chunks after uploading RagFile.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/vertex_rag_data.proto.
	RagFileChunkingConfig *RagFileChunkingConfig `protobuf:"bytes,1,opt,name=rag_file_chunking_config,json=ragFileChunkingConfig,proto3" json:"rag_file_chunking_config,omitempty"`
	// Specifies the transformation config for RagFiles.
	RagFileTransformationConfig *RagFileTransformationConfig `protobuf:"bytes,3,opt,name=rag_file_transformation_config,json=ragFileTransformationConfig,proto3" json:"rag_file_transformation_config,omitempty"`
	// Specifies the metadata config for RagFiles.
	// Including paths for metadata schema and metadata.
	// Alteratively, inline metadata schema and metadata can be provided.
	RagFileMetadataConfig *RagFileMetadataConfig `protobuf:"bytes,4,opt,name=rag_file_metadata_config,json=ragFileMetadataConfig,proto3" json:"rag_file_metadata_config,omitempty"`
	// Optional. Specifies the parsing config for RagFiles.
	// RAG will use the default parser if this field is not set.
	RagFileParsingConfig *RagFileParsingConfig `protobuf:"bytes,5,opt,name=rag_file_parsing_config,json=ragFileParsingConfig,proto3" json:"rag_file_parsing_config,omitempty"`
}

func (x *UploadRagFileConfig) Reset() {
	*x = UploadRagFileConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UploadRagFileConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UploadRagFileConfig) ProtoMessage() {}

func (x *UploadRagFileConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UploadRagFileConfig.ProtoReflect.Descriptor instead.
func (*UploadRagFileConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{12}
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/vertex_rag_data.proto.
func (x *UploadRagFileConfig) GetRagFileChunkingConfig() *RagFileChunkingConfig {
	if x != nil {
		return x.RagFileChunkingConfig
	}
	return nil
}

func (x *UploadRagFileConfig) GetRagFileTransformationConfig() *RagFileTransformationConfig {
	if x != nil {
		return x.RagFileTransformationConfig
	}
	return nil
}

func (x *UploadRagFileConfig) GetRagFileMetadataConfig() *RagFileMetadataConfig {
	if x != nil {
		return x.RagFileMetadataConfig
	}
	return nil
}

func (x *UploadRagFileConfig) GetRagFileParsingConfig() *RagFileParsingConfig {
	if x != nil {
		return x.RagFileParsingConfig
	}
	return nil
}

// Config for importing RagFiles.
type ImportRagFilesConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source of the import.
	//
	// Types that are assignable to ImportSource:
	//
	//	*ImportRagFilesConfig_GcsSource
	//	*ImportRagFilesConfig_GoogleDriveSource
	//	*ImportRagFilesConfig_SlackSource
	//	*ImportRagFilesConfig_JiraSource
	//	*ImportRagFilesConfig_SharePointSources
	ImportSource isImportRagFilesConfig_ImportSource `protobuf_oneof:"import_source"`
	// Optional. If provided, all partial failures are written to the sink.
	// Deprecated. Prefer to use the `import_result_sink`.
	//
	// Types that are assignable to PartialFailureSink:
	//
	//	*ImportRagFilesConfig_PartialFailureGcsSink
	//	*ImportRagFilesConfig_PartialFailureBigquerySink
	PartialFailureSink isImportRagFilesConfig_PartialFailureSink `protobuf_oneof:"partial_failure_sink"`
	// Optional. If provided, all successfully imported files and all partial
	// failures are written to the sink.
	//
	// Types that are assignable to ImportResultSink:
	//
	//	*ImportRagFilesConfig_ImportResultGcsSink
	//	*ImportRagFilesConfig_ImportResultBigquerySink
	ImportResultSink isImportRagFilesConfig_ImportResultSink `protobuf_oneof:"import_result_sink"`
	// Specifies the size and overlap of chunks after importing RagFiles.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/vertex_rag_data.proto.
	RagFileChunkingConfig *RagFileChunkingConfig `protobuf:"bytes,4,opt,name=rag_file_chunking_config,json=ragFileChunkingConfig,proto3" json:"rag_file_chunking_config,omitempty"`
	// Specifies the transformation config for RagFiles.
	RagFileTransformationConfig *RagFileTransformationConfig `protobuf:"bytes,16,opt,name=rag_file_transformation_config,json=ragFileTransformationConfig,proto3" json:"rag_file_transformation_config,omitempty"`
	// Optional. Specifies the parsing config for RagFiles.
	// RAG will use the default parser if this field is not set.
	RagFileParsingConfig *RagFileParsingConfig `protobuf:"bytes,8,opt,name=rag_file_parsing_config,json=ragFileParsingConfig,proto3" json:"rag_file_parsing_config,omitempty"`
	// Specifies the metadata config for RagFiles.
	// Including paths for metadata schema and metadata.
	RagFileMetadataConfig *RagFileMetadataConfig `protobuf:"bytes,17,opt,name=rag_file_metadata_config,json=ragFileMetadataConfig,proto3" json:"rag_file_metadata_config,omitempty"`
	// Optional. The max number of queries per minute that this job is allowed to
	// make to the embedding model specified on the corpus. This value is specific
	// to this job and not shared across other import jobs. Consult the Quotas
	// page on the project to set an appropriate value here.
	// If unspecified, a default value of 1,000 QPM would be used.
	MaxEmbeddingRequestsPerMin int32 `protobuf:"varint,5,opt,name=max_embedding_requests_per_min,json=maxEmbeddingRequestsPerMin,proto3" json:"max_embedding_requests_per_min,omitempty"`
	// Optional. The max number of queries per minute that the indexing pipeline
	// job is allowed to make to the embedding model specified in the project.
	// Please follow the quota usage guideline of the embedding model you use to
	// set the value properly.If this value is not specified,
	// max_embedding_requests_per_min will be used by indexing pipeline job as the
	// global limit.
	GlobalMaxEmbeddingRequestsPerMin int32 `protobuf:"varint,18,opt,name=global_max_embedding_requests_per_min,json=globalMaxEmbeddingRequestsPerMin,proto3" json:"global_max_embedding_requests_per_min,omitempty"`
	// Rebuilds the ANN index to optimize for recall on the imported data.
	// Only applicable for RagCorpora running on RagManagedDb with
	// `retrieval_strategy` set to `ANN`. The rebuild will be performed using the
	// existing ANN config set on the RagCorpus. To change the ANN config, please
	// use the UpdateRagCorpus API.
	//
	// Default is false, i.e., index is not rebuilt.
	RebuildAnnIndex bool `protobuf:"varint,19,opt,name=rebuild_ann_index,json=rebuildAnnIndex,proto3" json:"rebuild_ann_index,omitempty"`
}

func (x *ImportRagFilesConfig) Reset() {
	*x = ImportRagFilesConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImportRagFilesConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportRagFilesConfig) ProtoMessage() {}

func (x *ImportRagFilesConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportRagFilesConfig.ProtoReflect.Descriptor instead.
func (*ImportRagFilesConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{13}
}

func (m *ImportRagFilesConfig) GetImportSource() isImportRagFilesConfig_ImportSource {
	if m != nil {
		return m.ImportSource
	}
	return nil
}

func (x *ImportRagFilesConfig) GetGcsSource() *GcsSource {
	if x, ok := x.GetImportSource().(*ImportRagFilesConfig_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (x *ImportRagFilesConfig) GetGoogleDriveSource() *GoogleDriveSource {
	if x, ok := x.GetImportSource().(*ImportRagFilesConfig_GoogleDriveSource); ok {
		return x.GoogleDriveSource
	}
	return nil
}

func (x *ImportRagFilesConfig) GetSlackSource() *SlackSource {
	if x, ok := x.GetImportSource().(*ImportRagFilesConfig_SlackSource); ok {
		return x.SlackSource
	}
	return nil
}

func (x *ImportRagFilesConfig) GetJiraSource() *JiraSource {
	if x, ok := x.GetImportSource().(*ImportRagFilesConfig_JiraSource); ok {
		return x.JiraSource
	}
	return nil
}

func (x *ImportRagFilesConfig) GetSharePointSources() *SharePointSources {
	if x, ok := x.GetImportSource().(*ImportRagFilesConfig_SharePointSources); ok {
		return x.SharePointSources
	}
	return nil
}

func (m *ImportRagFilesConfig) GetPartialFailureSink() isImportRagFilesConfig_PartialFailureSink {
	if m != nil {
		return m.PartialFailureSink
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/vertex_rag_data.proto.
func (x *ImportRagFilesConfig) GetPartialFailureGcsSink() *GcsDestination {
	if x, ok := x.GetPartialFailureSink().(*ImportRagFilesConfig_PartialFailureGcsSink); ok {
		return x.PartialFailureGcsSink
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/vertex_rag_data.proto.
func (x *ImportRagFilesConfig) GetPartialFailureBigquerySink() *BigQueryDestination {
	if x, ok := x.GetPartialFailureSink().(*ImportRagFilesConfig_PartialFailureBigquerySink); ok {
		return x.PartialFailureBigquerySink
	}
	return nil
}

func (m *ImportRagFilesConfig) GetImportResultSink() isImportRagFilesConfig_ImportResultSink {
	if m != nil {
		return m.ImportResultSink
	}
	return nil
}

func (x *ImportRagFilesConfig) GetImportResultGcsSink() *GcsDestination {
	if x, ok := x.GetImportResultSink().(*ImportRagFilesConfig_ImportResultGcsSink); ok {
		return x.ImportResultGcsSink
	}
	return nil
}

func (x *ImportRagFilesConfig) GetImportResultBigquerySink() *BigQueryDestination {
	if x, ok := x.GetImportResultSink().(*ImportRagFilesConfig_ImportResultBigquerySink); ok {
		return x.ImportResultBigquerySink
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/vertex_rag_data.proto.
func (x *ImportRagFilesConfig) GetRagFileChunkingConfig() *RagFileChunkingConfig {
	if x != nil {
		return x.RagFileChunkingConfig
	}
	return nil
}

func (x *ImportRagFilesConfig) GetRagFileTransformationConfig() *RagFileTransformationConfig {
	if x != nil {
		return x.RagFileTransformationConfig
	}
	return nil
}

func (x *ImportRagFilesConfig) GetRagFileParsingConfig() *RagFileParsingConfig {
	if x != nil {
		return x.RagFileParsingConfig
	}
	return nil
}

func (x *ImportRagFilesConfig) GetRagFileMetadataConfig() *RagFileMetadataConfig {
	if x != nil {
		return x.RagFileMetadataConfig
	}
	return nil
}

func (x *ImportRagFilesConfig) GetMaxEmbeddingRequestsPerMin() int32 {
	if x != nil {
		return x.MaxEmbeddingRequestsPerMin
	}
	return 0
}

func (x *ImportRagFilesConfig) GetGlobalMaxEmbeddingRequestsPerMin() int32 {
	if x != nil {
		return x.GlobalMaxEmbeddingRequestsPerMin
	}
	return 0
}

func (x *ImportRagFilesConfig) GetRebuildAnnIndex() bool {
	if x != nil {
		return x.RebuildAnnIndex
	}
	return false
}

type isImportRagFilesConfig_ImportSource interface {
	isImportRagFilesConfig_ImportSource()
}

type ImportRagFilesConfig_GcsSource struct {
	// Google Cloud Storage location. Supports importing individual files as
	// well as entire Google Cloud Storage directories. Sample formats:
	// - `gs://bucket_name/my_directory/object_name/my_file.txt`
	// - `gs://bucket_name/my_directory`
	GcsSource *GcsSource `protobuf:"bytes,2,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

type ImportRagFilesConfig_GoogleDriveSource struct {
	// Google Drive location. Supports importing individual files as
	// well as Google Drive folders.
	GoogleDriveSource *GoogleDriveSource `protobuf:"bytes,3,opt,name=google_drive_source,json=googleDriveSource,proto3,oneof"`
}

type ImportRagFilesConfig_SlackSource struct {
	// Slack channels with their corresponding access tokens.
	SlackSource *SlackSource `protobuf:"bytes,6,opt,name=slack_source,json=slackSource,proto3,oneof"`
}

type ImportRagFilesConfig_JiraSource struct {
	// Jira queries with their corresponding authentication.
	JiraSource *JiraSource `protobuf:"bytes,7,opt,name=jira_source,json=jiraSource,proto3,oneof"`
}

type ImportRagFilesConfig_SharePointSources struct {
	// SharePoint sources.
	SharePointSources *SharePointSources `protobuf:"bytes,13,opt,name=share_point_sources,json=sharePointSources,proto3,oneof"`
}

func (*ImportRagFilesConfig_GcsSource) isImportRagFilesConfig_ImportSource() {}

func (*ImportRagFilesConfig_GoogleDriveSource) isImportRagFilesConfig_ImportSource() {}

func (*ImportRagFilesConfig_SlackSource) isImportRagFilesConfig_ImportSource() {}

func (*ImportRagFilesConfig_JiraSource) isImportRagFilesConfig_ImportSource() {}

func (*ImportRagFilesConfig_SharePointSources) isImportRagFilesConfig_ImportSource() {}

type isImportRagFilesConfig_PartialFailureSink interface {
	isImportRagFilesConfig_PartialFailureSink()
}

type ImportRagFilesConfig_PartialFailureGcsSink struct {
	// The Cloud Storage path to write partial failures to.
	// Deprecated. Prefer to use `import_result_gcs_sink`.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/vertex_rag_data.proto.
	PartialFailureGcsSink *GcsDestination `protobuf:"bytes,11,opt,name=partial_failure_gcs_sink,json=partialFailureGcsSink,proto3,oneof"`
}

type ImportRagFilesConfig_PartialFailureBigquerySink struct {
	// The BigQuery destination to write partial failures to. It should be a
	// bigquery table resource name (e.g.
	// "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
	// table does not exist, it will be created with the expected schema. If the
	// table exists, the schema will be validated and data will be added to this
	// existing table.
	// Deprecated. Prefer to use `import_result_bq_sink`.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/vertex_rag_data.proto.
	PartialFailureBigquerySink *BigQueryDestination `protobuf:"bytes,12,opt,name=partial_failure_bigquery_sink,json=partialFailureBigquerySink,proto3,oneof"`
}

func (*ImportRagFilesConfig_PartialFailureGcsSink) isImportRagFilesConfig_PartialFailureSink() {}

func (*ImportRagFilesConfig_PartialFailureBigquerySink) isImportRagFilesConfig_PartialFailureSink() {}

type isImportRagFilesConfig_ImportResultSink interface {
	isImportRagFilesConfig_ImportResultSink()
}

type ImportRagFilesConfig_ImportResultGcsSink struct {
	// The Cloud Storage path to write import result to.
	ImportResultGcsSink *GcsDestination `protobuf:"bytes,14,opt,name=import_result_gcs_sink,json=importResultGcsSink,proto3,oneof"`
}

type ImportRagFilesConfig_ImportResultBigquerySink struct {
	// The BigQuery destination to write import result to. It should be a
	// bigquery table resource name (e.g.
	// "bq://projectId.bqDatasetId.bqTableId"). The dataset must exist. If the
	// table does not exist, it will be created with the expected schema. If the
	// table exists, the schema will be validated and data will be added to this
	// existing table.
	ImportResultBigquerySink *BigQueryDestination `protobuf:"bytes,15,opt,name=import_result_bigquery_sink,json=importResultBigquerySink,proto3,oneof"`
}

func (*ImportRagFilesConfig_ImportResultGcsSink) isImportRagFilesConfig_ImportResultSink() {}

func (*ImportRagFilesConfig_ImportResultBigquerySink) isImportRagFilesConfig_ImportResultSink() {}

// Configuration message for RagManagedDb used by RagEngine.
type RagManagedDbConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The tier of the RagManagedDb.
	//
	// Types that are assignable to Tier:
	//
	//	*RagManagedDbConfig_Enterprise_
	//	*RagManagedDbConfig_Scaled_
	//	*RagManagedDbConfig_Basic_
	//	*RagManagedDbConfig_Unprovisioned_
	Tier isRagManagedDbConfig_Tier `protobuf_oneof:"tier"`
}

func (x *RagManagedDbConfig) Reset() {
	*x = RagManagedDbConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagManagedDbConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagManagedDbConfig) ProtoMessage() {}

func (x *RagManagedDbConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagManagedDbConfig.ProtoReflect.Descriptor instead.
func (*RagManagedDbConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{14}
}

func (m *RagManagedDbConfig) GetTier() isRagManagedDbConfig_Tier {
	if m != nil {
		return m.Tier
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/vertex_rag_data.proto.
func (x *RagManagedDbConfig) GetEnterprise() *RagManagedDbConfig_Enterprise {
	if x, ok := x.GetTier().(*RagManagedDbConfig_Enterprise_); ok {
		return x.Enterprise
	}
	return nil
}

func (x *RagManagedDbConfig) GetScaled() *RagManagedDbConfig_Scaled {
	if x, ok := x.GetTier().(*RagManagedDbConfig_Scaled_); ok {
		return x.Scaled
	}
	return nil
}

func (x *RagManagedDbConfig) GetBasic() *RagManagedDbConfig_Basic {
	if x, ok := x.GetTier().(*RagManagedDbConfig_Basic_); ok {
		return x.Basic
	}
	return nil
}

func (x *RagManagedDbConfig) GetUnprovisioned() *RagManagedDbConfig_Unprovisioned {
	if x, ok := x.GetTier().(*RagManagedDbConfig_Unprovisioned_); ok {
		return x.Unprovisioned
	}
	return nil
}

type isRagManagedDbConfig_Tier interface {
	isRagManagedDbConfig_Tier()
}

type RagManagedDbConfig_Enterprise_ struct {
	// Deprecated: Please use `Scaled` tier instead.
	// Sets the RagManagedDb to the Enterprise tier. This is the default tier
	// if not explicitly chosen.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/vertex_rag_data.proto.
	Enterprise *RagManagedDbConfig_Enterprise `protobuf:"bytes,1,opt,name=enterprise,proto3,oneof"`
}

type RagManagedDbConfig_Scaled_ struct {
	// Sets the RagManagedDb to the Scaled tier.
	Scaled *RagManagedDbConfig_Scaled `protobuf:"bytes,4,opt,name=scaled,proto3,oneof"`
}

type RagManagedDbConfig_Basic_ struct {
	// Sets the RagManagedDb to the Basic tier.
	Basic *RagManagedDbConfig_Basic `protobuf:"bytes,2,opt,name=basic,proto3,oneof"`
}

type RagManagedDbConfig_Unprovisioned_ struct {
	// Sets the RagManagedDb to the Unprovisioned tier.
	Unprovisioned *RagManagedDbConfig_Unprovisioned `protobuf:"bytes,3,opt,name=unprovisioned,proto3,oneof"`
}

func (*RagManagedDbConfig_Enterprise_) isRagManagedDbConfig_Tier() {}

func (*RagManagedDbConfig_Scaled_) isRagManagedDbConfig_Tier() {}

func (*RagManagedDbConfig_Basic_) isRagManagedDbConfig_Tier() {}

func (*RagManagedDbConfig_Unprovisioned_) isRagManagedDbConfig_Tier() {}

// Config for RagEngine.
type RagEngineConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of the RagEngineConfig.
	// Format:
	// `projects/{project}/locations/{location}/ragEngineConfig`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The config of the RagManagedDb used by RagEngine.
	RagManagedDbConfig *RagManagedDbConfig `protobuf:"bytes,2,opt,name=rag_managed_db_config,json=ragManagedDbConfig,proto3" json:"rag_managed_db_config,omitempty"`
}

func (x *RagEngineConfig) Reset() {
	*x = RagEngineConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagEngineConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagEngineConfig) ProtoMessage() {}

func (x *RagEngineConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagEngineConfig.ProtoReflect.Descriptor instead.
func (*RagEngineConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{15}
}

func (x *RagEngineConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RagEngineConfig) GetRagManagedDbConfig() *RagManagedDbConfig {
	if x != nil {
		return x.RagManagedDbConfig
	}
	return nil
}

// Config representing a model hosted on Vertex Prediction Endpoint.
type RagEmbeddingModelConfig_VertexPredictionEndpoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The endpoint resource name.
	// Format:
	// `projects/{project}/locations/{location}/publishers/{publisher}/models/{model}`
	// or
	// `projects/{project}/locations/{location}/endpoints/{endpoint}`
	Endpoint string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Output only. The resource name of the model that is deployed on the
	// endpoint. Present only when the endpoint is not a publisher model.
	// Pattern:
	// `projects/{project}/locations/{location}/models/{model}`
	Model string `protobuf:"bytes,2,opt,name=model,proto3" json:"model,omitempty"`
	// Output only. Version ID of the model that is deployed on the endpoint.
	// Present only when the endpoint is not a publisher model.
	ModelVersionId string `protobuf:"bytes,3,opt,name=model_version_id,json=modelVersionId,proto3" json:"model_version_id,omitempty"`
}

func (x *RagEmbeddingModelConfig_VertexPredictionEndpoint) Reset() {
	*x = RagEmbeddingModelConfig_VertexPredictionEndpoint{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagEmbeddingModelConfig_VertexPredictionEndpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagEmbeddingModelConfig_VertexPredictionEndpoint) ProtoMessage() {}

func (x *RagEmbeddingModelConfig_VertexPredictionEndpoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagEmbeddingModelConfig_VertexPredictionEndpoint.ProtoReflect.Descriptor instead.
func (*RagEmbeddingModelConfig_VertexPredictionEndpoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{0, 0}
}

func (x *RagEmbeddingModelConfig_VertexPredictionEndpoint) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *RagEmbeddingModelConfig_VertexPredictionEndpoint) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *RagEmbeddingModelConfig_VertexPredictionEndpoint) GetModelVersionId() string {
	if x != nil {
		return x.ModelVersionId
	}
	return ""
}

// Configuration for sparse emebdding generation.
type RagEmbeddingModelConfig_SparseEmbeddingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The model to use for sparse embedding generation.
	//
	// Types that are assignable to Model:
	//
	//	*RagEmbeddingModelConfig_SparseEmbeddingConfig_Bm25_
	Model isRagEmbeddingModelConfig_SparseEmbeddingConfig_Model `protobuf_oneof:"model"`
}

func (x *RagEmbeddingModelConfig_SparseEmbeddingConfig) Reset() {
	*x = RagEmbeddingModelConfig_SparseEmbeddingConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagEmbeddingModelConfig_SparseEmbeddingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagEmbeddingModelConfig_SparseEmbeddingConfig) ProtoMessage() {}

func (x *RagEmbeddingModelConfig_SparseEmbeddingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagEmbeddingModelConfig_SparseEmbeddingConfig.ProtoReflect.Descriptor instead.
func (*RagEmbeddingModelConfig_SparseEmbeddingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{0, 1}
}

func (m *RagEmbeddingModelConfig_SparseEmbeddingConfig) GetModel() isRagEmbeddingModelConfig_SparseEmbeddingConfig_Model {
	if m != nil {
		return m.Model
	}
	return nil
}

func (x *RagEmbeddingModelConfig_SparseEmbeddingConfig) GetBm25() *RagEmbeddingModelConfig_SparseEmbeddingConfig_Bm25 {
	if x, ok := x.GetModel().(*RagEmbeddingModelConfig_SparseEmbeddingConfig_Bm25_); ok {
		return x.Bm25
	}
	return nil
}

type isRagEmbeddingModelConfig_SparseEmbeddingConfig_Model interface {
	isRagEmbeddingModelConfig_SparseEmbeddingConfig_Model()
}

type RagEmbeddingModelConfig_SparseEmbeddingConfig_Bm25_ struct {
	// Use BM25 scoring algorithm.
	Bm25 *RagEmbeddingModelConfig_SparseEmbeddingConfig_Bm25 `protobuf:"bytes,1,opt,name=bm25,proto3,oneof"`
}

func (*RagEmbeddingModelConfig_SparseEmbeddingConfig_Bm25_) isRagEmbeddingModelConfig_SparseEmbeddingConfig_Model() {
}

// Config for hybrid search.
type RagEmbeddingModelConfig_HybridSearchConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The configuration for sparse embedding generation. This field
	// is optional the default behavior depends on the vector database choice on
	// the RagCorpus.
	SparseEmbeddingConfig *RagEmbeddingModelConfig_SparseEmbeddingConfig `protobuf:"bytes,1,opt,name=sparse_embedding_config,json=sparseEmbeddingConfig,proto3" json:"sparse_embedding_config,omitempty"`
	// Required. The Vertex AI Prediction Endpoint that hosts the embedding
	// model for dense embedding generations.
	DenseEmbeddingModelPredictionEndpoint *RagEmbeddingModelConfig_VertexPredictionEndpoint `protobuf:"bytes,2,opt,name=dense_embedding_model_prediction_endpoint,json=denseEmbeddingModelPredictionEndpoint,proto3" json:"dense_embedding_model_prediction_endpoint,omitempty"`
}

func (x *RagEmbeddingModelConfig_HybridSearchConfig) Reset() {
	*x = RagEmbeddingModelConfig_HybridSearchConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagEmbeddingModelConfig_HybridSearchConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagEmbeddingModelConfig_HybridSearchConfig) ProtoMessage() {}

func (x *RagEmbeddingModelConfig_HybridSearchConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagEmbeddingModelConfig_HybridSearchConfig.ProtoReflect.Descriptor instead.
func (*RagEmbeddingModelConfig_HybridSearchConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{0, 2}
}

func (x *RagEmbeddingModelConfig_HybridSearchConfig) GetSparseEmbeddingConfig() *RagEmbeddingModelConfig_SparseEmbeddingConfig {
	if x != nil {
		return x.SparseEmbeddingConfig
	}
	return nil
}

func (x *RagEmbeddingModelConfig_HybridSearchConfig) GetDenseEmbeddingModelPredictionEndpoint() *RagEmbeddingModelConfig_VertexPredictionEndpoint {
	if x != nil {
		return x.DenseEmbeddingModelPredictionEndpoint
	}
	return nil
}

// Message for BM25 parameters.
type RagEmbeddingModelConfig_SparseEmbeddingConfig_Bm25 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Use multilingual tokenizer if set to true.
	Multilingual bool `protobuf:"varint,1,opt,name=multilingual,proto3" json:"multilingual,omitempty"`
	// Optional. The parameter to control term frequency saturation. It
	// determines the scaling between the matching term frequency and final
	// score. k1 is in the range of [1.2, 3]. The default value is 1.2.
	K1 *float32 `protobuf:"fixed32,2,opt,name=k1,proto3,oneof" json:"k1,omitempty"`
	// Optional. The parameter to control document length normalization. It
	// determines how much the document length affects the final score. b is
	// in the range of [0, 1]. The default value is 0.75.
	B *float32 `protobuf:"fixed32,3,opt,name=b,proto3,oneof" json:"b,omitempty"`
}

func (x *RagEmbeddingModelConfig_SparseEmbeddingConfig_Bm25) Reset() {
	*x = RagEmbeddingModelConfig_SparseEmbeddingConfig_Bm25{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagEmbeddingModelConfig_SparseEmbeddingConfig_Bm25) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagEmbeddingModelConfig_SparseEmbeddingConfig_Bm25) ProtoMessage() {}

func (x *RagEmbeddingModelConfig_SparseEmbeddingConfig_Bm25) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagEmbeddingModelConfig_SparseEmbeddingConfig_Bm25.ProtoReflect.Descriptor instead.
func (*RagEmbeddingModelConfig_SparseEmbeddingConfig_Bm25) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *RagEmbeddingModelConfig_SparseEmbeddingConfig_Bm25) GetMultilingual() bool {
	if x != nil {
		return x.Multilingual
	}
	return false
}

func (x *RagEmbeddingModelConfig_SparseEmbeddingConfig_Bm25) GetK1() float32 {
	if x != nil && x.K1 != nil {
		return *x.K1
	}
	return 0
}

func (x *RagEmbeddingModelConfig_SparseEmbeddingConfig_Bm25) GetB() float32 {
	if x != nil && x.B != nil {
		return *x.B
	}
	return 0
}

// The config for the default RAG-managed Vector DB.
type RagVectorDbConfig_RagManagedDb struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Choice of retrieval strategy.
	//
	// Types that are assignable to RetrievalStrategy:
	//
	//	*RagVectorDbConfig_RagManagedDb_Knn
	//	*RagVectorDbConfig_RagManagedDb_Ann
	RetrievalStrategy isRagVectorDbConfig_RagManagedDb_RetrievalStrategy `protobuf_oneof:"retrieval_strategy"`
}

func (x *RagVectorDbConfig_RagManagedDb) Reset() {
	*x = RagVectorDbConfig_RagManagedDb{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagVectorDbConfig_RagManagedDb) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagVectorDbConfig_RagManagedDb) ProtoMessage() {}

func (x *RagVectorDbConfig_RagManagedDb) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagVectorDbConfig_RagManagedDb.ProtoReflect.Descriptor instead.
func (*RagVectorDbConfig_RagManagedDb) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{1, 0}
}

func (m *RagVectorDbConfig_RagManagedDb) GetRetrievalStrategy() isRagVectorDbConfig_RagManagedDb_RetrievalStrategy {
	if m != nil {
		return m.RetrievalStrategy
	}
	return nil
}

func (x *RagVectorDbConfig_RagManagedDb) GetKnn() *RagVectorDbConfig_RagManagedDb_KNN {
	if x, ok := x.GetRetrievalStrategy().(*RagVectorDbConfig_RagManagedDb_Knn); ok {
		return x.Knn
	}
	return nil
}

func (x *RagVectorDbConfig_RagManagedDb) GetAnn() *RagVectorDbConfig_RagManagedDb_ANN {
	if x, ok := x.GetRetrievalStrategy().(*RagVectorDbConfig_RagManagedDb_Ann); ok {
		return x.Ann
	}
	return nil
}

type isRagVectorDbConfig_RagManagedDb_RetrievalStrategy interface {
	isRagVectorDbConfig_RagManagedDb_RetrievalStrategy()
}

type RagVectorDbConfig_RagManagedDb_Knn struct {
	// Performs a KNN search on RagCorpus.
	// Default choice if not specified.
	Knn *RagVectorDbConfig_RagManagedDb_KNN `protobuf:"bytes,1,opt,name=knn,proto3,oneof"`
}

type RagVectorDbConfig_RagManagedDb_Ann struct {
	// Performs an ANN search on RagCorpus. Use this if you have a lot of
	// files (> 10K) in your RagCorpus and want to reduce the search latency.
	Ann *RagVectorDbConfig_RagManagedDb_ANN `protobuf:"bytes,2,opt,name=ann,proto3,oneof"`
}

func (*RagVectorDbConfig_RagManagedDb_Knn) isRagVectorDbConfig_RagManagedDb_RetrievalStrategy() {}

func (*RagVectorDbConfig_RagManagedDb_Ann) isRagVectorDbConfig_RagManagedDb_RetrievalStrategy() {}

// The config for the Weaviate.
type RagVectorDbConfig_Weaviate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Weaviate DB instance HTTP endpoint. e.g. 34.56.78.90:8080
	// Vertex RAG only supports HTTP connection to Weaviate.
	// This value cannot be changed after it's set.
	HttpEndpoint string `protobuf:"bytes,1,opt,name=http_endpoint,json=httpEndpoint,proto3" json:"http_endpoint,omitempty"`
	// The corresponding collection this corpus maps to.
	// This value cannot be changed after it's set.
	CollectionName string `protobuf:"bytes,2,opt,name=collection_name,json=collectionName,proto3" json:"collection_name,omitempty"`
}

func (x *RagVectorDbConfig_Weaviate) Reset() {
	*x = RagVectorDbConfig_Weaviate{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagVectorDbConfig_Weaviate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagVectorDbConfig_Weaviate) ProtoMessage() {}

func (x *RagVectorDbConfig_Weaviate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagVectorDbConfig_Weaviate.ProtoReflect.Descriptor instead.
func (*RagVectorDbConfig_Weaviate) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{1, 1}
}

func (x *RagVectorDbConfig_Weaviate) GetHttpEndpoint() string {
	if x != nil {
		return x.HttpEndpoint
	}
	return ""
}

func (x *RagVectorDbConfig_Weaviate) GetCollectionName() string {
	if x != nil {
		return x.CollectionName
	}
	return ""
}

// The config for the Pinecone.
type RagVectorDbConfig_Pinecone struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Pinecone index name.
	// This value cannot be changed after it's set.
	IndexName string `protobuf:"bytes,1,opt,name=index_name,json=indexName,proto3" json:"index_name,omitempty"`
}

func (x *RagVectorDbConfig_Pinecone) Reset() {
	*x = RagVectorDbConfig_Pinecone{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagVectorDbConfig_Pinecone) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagVectorDbConfig_Pinecone) ProtoMessage() {}

func (x *RagVectorDbConfig_Pinecone) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagVectorDbConfig_Pinecone.ProtoReflect.Descriptor instead.
func (*RagVectorDbConfig_Pinecone) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{1, 2}
}

func (x *RagVectorDbConfig_Pinecone) GetIndexName() string {
	if x != nil {
		return x.IndexName
	}
	return ""
}

// The config for the Vertex Feature Store.
type RagVectorDbConfig_VertexFeatureStore struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the FeatureView.
	// Format:
	// `projects/{project}/locations/{location}/featureOnlineStores/{feature_online_store}/featureViews/{feature_view}`
	FeatureViewResourceName string `protobuf:"bytes,1,opt,name=feature_view_resource_name,json=featureViewResourceName,proto3" json:"feature_view_resource_name,omitempty"`
}

func (x *RagVectorDbConfig_VertexFeatureStore) Reset() {
	*x = RagVectorDbConfig_VertexFeatureStore{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagVectorDbConfig_VertexFeatureStore) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagVectorDbConfig_VertexFeatureStore) ProtoMessage() {}

func (x *RagVectorDbConfig_VertexFeatureStore) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagVectorDbConfig_VertexFeatureStore.ProtoReflect.Descriptor instead.
func (*RagVectorDbConfig_VertexFeatureStore) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{1, 3}
}

func (x *RagVectorDbConfig_VertexFeatureStore) GetFeatureViewResourceName() string {
	if x != nil {
		return x.FeatureViewResourceName
	}
	return ""
}

// The config for the Vertex Vector Search.
type RagVectorDbConfig_VertexVectorSearch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the Index Endpoint.
	// Format:
	// `projects/{project}/locations/{location}/indexEndpoints/{index_endpoint}`
	IndexEndpoint string `protobuf:"bytes,1,opt,name=index_endpoint,json=indexEndpoint,proto3" json:"index_endpoint,omitempty"`
	// The resource name of the Index.
	// Format:
	// `projects/{project}/locations/{location}/indexes/{index}`
	Index string `protobuf:"bytes,2,opt,name=index,proto3" json:"index,omitempty"`
}

func (x *RagVectorDbConfig_VertexVectorSearch) Reset() {
	*x = RagVectorDbConfig_VertexVectorSearch{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagVectorDbConfig_VertexVectorSearch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagVectorDbConfig_VertexVectorSearch) ProtoMessage() {}

func (x *RagVectorDbConfig_VertexVectorSearch) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagVectorDbConfig_VertexVectorSearch.ProtoReflect.Descriptor instead.
func (*RagVectorDbConfig_VertexVectorSearch) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{1, 4}
}

func (x *RagVectorDbConfig_VertexVectorSearch) GetIndexEndpoint() string {
	if x != nil {
		return x.IndexEndpoint
	}
	return ""
}

func (x *RagVectorDbConfig_VertexVectorSearch) GetIndex() string {
	if x != nil {
		return x.Index
	}
	return ""
}

// Config for KNN search.
type RagVectorDbConfig_RagManagedDb_KNN struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RagVectorDbConfig_RagManagedDb_KNN) Reset() {
	*x = RagVectorDbConfig_RagManagedDb_KNN{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagVectorDbConfig_RagManagedDb_KNN) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagVectorDbConfig_RagManagedDb_KNN) ProtoMessage() {}

func (x *RagVectorDbConfig_RagManagedDb_KNN) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagVectorDbConfig_RagManagedDb_KNN.ProtoReflect.Descriptor instead.
func (*RagVectorDbConfig_RagManagedDb_KNN) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{1, 0, 0}
}

// Config for ANN search.
//
// RagManagedDb uses a tree-based structure to partition data and
// facilitate faster searches. As a tradeoff, it requires longer indexing
// time and manual triggering of index rebuild via the ImportRagFiles and
// UpdateRagCorpus API.
type RagVectorDbConfig_RagManagedDb_ANN struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The depth of the tree-based structure. Only depth values of 2 and 3 are
	// supported.
	//
	// Recommended value is 2 if you have if you have O(10K) files in the
	// RagCorpus and set this to 3 if more than that.
	//
	// Default value is 2.
	TreeDepth int32 `protobuf:"varint,1,opt,name=tree_depth,json=treeDepth,proto3" json:"tree_depth,omitempty"`
	// Number of leaf nodes in the tree-based structure. Each leaf node
	// contains groups of closely related vectors along with their
	// corresponding centroid.
	//
	// Recommended value is 10 * sqrt(num of RagFiles in your RagCorpus).
	//
	// Default value is 500.
	LeafCount int32 `protobuf:"varint,2,opt,name=leaf_count,json=leafCount,proto3" json:"leaf_count,omitempty"`
}

func (x *RagVectorDbConfig_RagManagedDb_ANN) Reset() {
	*x = RagVectorDbConfig_RagManagedDb_ANN{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagVectorDbConfig_RagManagedDb_ANN) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagVectorDbConfig_RagManagedDb_ANN) ProtoMessage() {}

func (x *RagVectorDbConfig_RagManagedDb_ANN) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagVectorDbConfig_RagManagedDb_ANN.ProtoReflect.Descriptor instead.
func (*RagVectorDbConfig_RagManagedDb_ANN) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{1, 0, 1}
}

func (x *RagVectorDbConfig_RagManagedDb_ANN) GetTreeDepth() int32 {
	if x != nil {
		return x.TreeDepth
	}
	return 0
}

func (x *RagVectorDbConfig_RagManagedDb_ANN) GetLeafCount() int32 {
	if x != nil {
		return x.LeafCount
	}
	return 0
}

// The config for the corpus type of the RagCorpus.
type RagCorpus_CorpusTypeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional.
	// Whether the RagCorpus is used as document store or memory store.
	//
	// Types that are assignable to CorpusTypeConfig:
	//
	//	*RagCorpus_CorpusTypeConfig_DocumentCorpus_
	//	*RagCorpus_CorpusTypeConfig_MemoryCorpus_
	CorpusTypeConfig isRagCorpus_CorpusTypeConfig_CorpusTypeConfig `protobuf_oneof:"corpus_type_config"`
}

func (x *RagCorpus_CorpusTypeConfig) Reset() {
	*x = RagCorpus_CorpusTypeConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagCorpus_CorpusTypeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagCorpus_CorpusTypeConfig) ProtoMessage() {}

func (x *RagCorpus_CorpusTypeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagCorpus_CorpusTypeConfig.ProtoReflect.Descriptor instead.
func (*RagCorpus_CorpusTypeConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{5, 0}
}

func (m *RagCorpus_CorpusTypeConfig) GetCorpusTypeConfig() isRagCorpus_CorpusTypeConfig_CorpusTypeConfig {
	if m != nil {
		return m.CorpusTypeConfig
	}
	return nil
}

func (x *RagCorpus_CorpusTypeConfig) GetDocumentCorpus() *RagCorpus_CorpusTypeConfig_DocumentCorpus {
	if x, ok := x.GetCorpusTypeConfig().(*RagCorpus_CorpusTypeConfig_DocumentCorpus_); ok {
		return x.DocumentCorpus
	}
	return nil
}

func (x *RagCorpus_CorpusTypeConfig) GetMemoryCorpus() *RagCorpus_CorpusTypeConfig_MemoryCorpus {
	if x, ok := x.GetCorpusTypeConfig().(*RagCorpus_CorpusTypeConfig_MemoryCorpus_); ok {
		return x.MemoryCorpus
	}
	return nil
}

type isRagCorpus_CorpusTypeConfig_CorpusTypeConfig interface {
	isRagCorpus_CorpusTypeConfig_CorpusTypeConfig()
}

type RagCorpus_CorpusTypeConfig_DocumentCorpus_ struct {
	// Optional. Config for the document corpus.
	DocumentCorpus *RagCorpus_CorpusTypeConfig_DocumentCorpus `protobuf:"bytes,1,opt,name=document_corpus,json=documentCorpus,proto3,oneof"`
}

type RagCorpus_CorpusTypeConfig_MemoryCorpus_ struct {
	// Optional. Config for the memory corpus.
	MemoryCorpus *RagCorpus_CorpusTypeConfig_MemoryCorpus `protobuf:"bytes,2,opt,name=memory_corpus,json=memoryCorpus,proto3,oneof"`
}

func (*RagCorpus_CorpusTypeConfig_DocumentCorpus_) isRagCorpus_CorpusTypeConfig_CorpusTypeConfig() {}

func (*RagCorpus_CorpusTypeConfig_MemoryCorpus_) isRagCorpus_CorpusTypeConfig_CorpusTypeConfig() {}

// Config for the document corpus.
type RagCorpus_CorpusTypeConfig_DocumentCorpus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RagCorpus_CorpusTypeConfig_DocumentCorpus) Reset() {
	*x = RagCorpus_CorpusTypeConfig_DocumentCorpus{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagCorpus_CorpusTypeConfig_DocumentCorpus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagCorpus_CorpusTypeConfig_DocumentCorpus) ProtoMessage() {}

func (x *RagCorpus_CorpusTypeConfig_DocumentCorpus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagCorpus_CorpusTypeConfig_DocumentCorpus.ProtoReflect.Descriptor instead.
func (*RagCorpus_CorpusTypeConfig_DocumentCorpus) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{5, 0, 0}
}

// Config for the memory corpus.
type RagCorpus_CorpusTypeConfig_MemoryCorpus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The LLM parser to use for the memory corpus.
	LlmParser *RagFileParsingConfig_LlmParser `protobuf:"bytes,1,opt,name=llm_parser,json=llmParser,proto3" json:"llm_parser,omitempty"`
}

func (x *RagCorpus_CorpusTypeConfig_MemoryCorpus) Reset() {
	*x = RagCorpus_CorpusTypeConfig_MemoryCorpus{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagCorpus_CorpusTypeConfig_MemoryCorpus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagCorpus_CorpusTypeConfig_MemoryCorpus) ProtoMessage() {}

func (x *RagCorpus_CorpusTypeConfig_MemoryCorpus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagCorpus_CorpusTypeConfig_MemoryCorpus.ProtoReflect.Descriptor instead.
func (*RagCorpus_CorpusTypeConfig_MemoryCorpus) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{5, 0, 1}
}

func (x *RagCorpus_CorpusTypeConfig_MemoryCorpus) GetLlmParser() *RagFileParsingConfig_LlmParser {
	if x != nil {
		return x.LlmParser
	}
	return nil
}

// Represents where the chunk starts and ends in the document.
type RagChunk_PageSpan struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Page where chunk starts in the document. Inclusive. 1-indexed.
	FirstPage int32 `protobuf:"varint,1,opt,name=first_page,json=firstPage,proto3" json:"first_page,omitempty"`
	// Page where chunk ends in the document. Inclusive. 1-indexed.
	LastPage int32 `protobuf:"varint,2,opt,name=last_page,json=lastPage,proto3" json:"last_page,omitempty"`
}

func (x *RagChunk_PageSpan) Reset() {
	*x = RagChunk_PageSpan{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagChunk_PageSpan) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagChunk_PageSpan) ProtoMessage() {}

func (x *RagChunk_PageSpan) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagChunk_PageSpan.ProtoReflect.Descriptor instead.
func (*RagChunk_PageSpan) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{7, 0}
}

func (x *RagChunk_PageSpan) GetFirstPage() int32 {
	if x != nil {
		return x.FirstPage
	}
	return 0
}

func (x *RagChunk_PageSpan) GetLastPage() int32 {
	if x != nil {
		return x.LastPage
	}
	return 0
}

// Specifies the fixed length chunking config.
type RagFileChunkingConfig_FixedLengthChunking struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The size of the chunks.
	ChunkSize int32 `protobuf:"varint,1,opt,name=chunk_size,json=chunkSize,proto3" json:"chunk_size,omitempty"`
	// The overlap between chunks.
	ChunkOverlap int32 `protobuf:"varint,2,opt,name=chunk_overlap,json=chunkOverlap,proto3" json:"chunk_overlap,omitempty"`
}

func (x *RagFileChunkingConfig_FixedLengthChunking) Reset() {
	*x = RagFileChunkingConfig_FixedLengthChunking{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagFileChunkingConfig_FixedLengthChunking) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagFileChunkingConfig_FixedLengthChunking) ProtoMessage() {}

func (x *RagFileChunkingConfig_FixedLengthChunking) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagFileChunkingConfig_FixedLengthChunking.ProtoReflect.Descriptor instead.
func (*RagFileChunkingConfig_FixedLengthChunking) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{8, 0}
}

func (x *RagFileChunkingConfig_FixedLengthChunking) GetChunkSize() int32 {
	if x != nil {
		return x.ChunkSize
	}
	return 0
}

func (x *RagFileChunkingConfig_FixedLengthChunking) GetChunkOverlap() int32 {
	if x != nil {
		return x.ChunkOverlap
	}
	return 0
}

// Specifies the advanced parsing for RagFiles.
type RagFileParsingConfig_AdvancedParser struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether to use advanced PDF parsing.
	UseAdvancedPdfParsing bool `protobuf:"varint,1,opt,name=use_advanced_pdf_parsing,json=useAdvancedPdfParsing,proto3" json:"use_advanced_pdf_parsing,omitempty"`
}

func (x *RagFileParsingConfig_AdvancedParser) Reset() {
	*x = RagFileParsingConfig_AdvancedParser{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagFileParsingConfig_AdvancedParser) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagFileParsingConfig_AdvancedParser) ProtoMessage() {}

func (x *RagFileParsingConfig_AdvancedParser) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagFileParsingConfig_AdvancedParser.ProtoReflect.Descriptor instead.
func (*RagFileParsingConfig_AdvancedParser) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{10, 0}
}

func (x *RagFileParsingConfig_AdvancedParser) GetUseAdvancedPdfParsing() bool {
	if x != nil {
		return x.UseAdvancedPdfParsing
	}
	return false
}

// Document AI Layout Parser config.
type RagFileParsingConfig_LayoutParser struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full resource name of a Document AI processor or processor version.
	// The processor must have type `LAYOUT_PARSER_PROCESSOR`. If specified, the
	// `additional_config.parse_as_scanned_pdf` field must be false.
	// Format:
	// * `projects/{project_id}/locations/{location}/processors/{processor_id}`
	// * `projects/{project_id}/locations/{location}/processors/{processor_id}/processorVersions/{processor_version_id}`
	ProcessorName string `protobuf:"bytes,1,opt,name=processor_name,json=processorName,proto3" json:"processor_name,omitempty"`
	// The maximum number of requests the job is allowed to make to the Document
	// AI processor per minute. Consult
	// https://cloud.google.com/document-ai/quotas and the Quota page for your
	// project to set an appropriate value here. If unspecified, a default value
	// of 120 QPM would be used.
	MaxParsingRequestsPerMin int32 `protobuf:"varint,2,opt,name=max_parsing_requests_per_min,json=maxParsingRequestsPerMin,proto3" json:"max_parsing_requests_per_min,omitempty"`
	// The maximum number of requests the job is allowed to make to the Document
	// AI processor per minute in this project. Consult
	// https://cloud.google.com/document-ai/quotas and the Quota page for your
	// project to set an appropriate value here.
	// If this value is not specified,
	// max_parsing_requests_per_min will be used by indexing
	// pipeline as the global limit.
	GlobalMaxParsingRequestsPerMin int32 `protobuf:"varint,3,opt,name=global_max_parsing_requests_per_min,json=globalMaxParsingRequestsPerMin,proto3" json:"global_max_parsing_requests_per_min,omitempty"`
}

func (x *RagFileParsingConfig_LayoutParser) Reset() {
	*x = RagFileParsingConfig_LayoutParser{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagFileParsingConfig_LayoutParser) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagFileParsingConfig_LayoutParser) ProtoMessage() {}

func (x *RagFileParsingConfig_LayoutParser) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagFileParsingConfig_LayoutParser.ProtoReflect.Descriptor instead.
func (*RagFileParsingConfig_LayoutParser) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{10, 1}
}

func (x *RagFileParsingConfig_LayoutParser) GetProcessorName() string {
	if x != nil {
		return x.ProcessorName
	}
	return ""
}

func (x *RagFileParsingConfig_LayoutParser) GetMaxParsingRequestsPerMin() int32 {
	if x != nil {
		return x.MaxParsingRequestsPerMin
	}
	return 0
}

func (x *RagFileParsingConfig_LayoutParser) GetGlobalMaxParsingRequestsPerMin() int32 {
	if x != nil {
		return x.GlobalMaxParsingRequestsPerMin
	}
	return 0
}

// Specifies the LLM parsing for RagFiles.
type RagFileParsingConfig_LlmParser struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of a LLM model used for parsing.
	// Format:
	// * `projects/{project_id}/locations/{location}/publishers/{publisher}/models/{model}`
	ModelName string `protobuf:"bytes,1,opt,name=model_name,json=modelName,proto3" json:"model_name,omitempty"`
	// The maximum number of requests the job is allowed to make to the
	// LLM model per minute. Consult
	// https://cloud.google.com/vertex-ai/generative-ai/docs/quotas
	// and your document size to set an appropriate value here. If unspecified,
	// a default value of 5000 QPM would be used.
	MaxParsingRequestsPerMin int32 `protobuf:"varint,2,opt,name=max_parsing_requests_per_min,json=maxParsingRequestsPerMin,proto3" json:"max_parsing_requests_per_min,omitempty"`
	// The maximum number of requests the job is allowed to make to the
	// LLM model per minute in this project. Consult
	// https://cloud.google.com/vertex-ai/generative-ai/docs/quotas
	// and your document size to set an appropriate value here.
	// If this value is not specified,
	// max_parsing_requests_per_min will be used by indexing pipeline job as the
	// global limit.
	GlobalMaxParsingRequestsPerMin int32 `protobuf:"varint,4,opt,name=global_max_parsing_requests_per_min,json=globalMaxParsingRequestsPerMin,proto3" json:"global_max_parsing_requests_per_min,omitempty"`
	// The prompt to use for parsing. If not specified, a default prompt will
	// be used.
	CustomParsingPrompt string `protobuf:"bytes,3,opt,name=custom_parsing_prompt,json=customParsingPrompt,proto3" json:"custom_parsing_prompt,omitempty"`
}

func (x *RagFileParsingConfig_LlmParser) Reset() {
	*x = RagFileParsingConfig_LlmParser{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagFileParsingConfig_LlmParser) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagFileParsingConfig_LlmParser) ProtoMessage() {}

func (x *RagFileParsingConfig_LlmParser) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagFileParsingConfig_LlmParser.ProtoReflect.Descriptor instead.
func (*RagFileParsingConfig_LlmParser) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{10, 2}
}

func (x *RagFileParsingConfig_LlmParser) GetModelName() string {
	if x != nil {
		return x.ModelName
	}
	return ""
}

func (x *RagFileParsingConfig_LlmParser) GetMaxParsingRequestsPerMin() int32 {
	if x != nil {
		return x.MaxParsingRequestsPerMin
	}
	return 0
}

func (x *RagFileParsingConfig_LlmParser) GetGlobalMaxParsingRequestsPerMin() int32 {
	if x != nil {
		return x.GlobalMaxParsingRequestsPerMin
	}
	return 0
}

func (x *RagFileParsingConfig_LlmParser) GetCustomParsingPrompt() string {
	if x != nil {
		return x.CustomParsingPrompt
	}
	return ""
}

// Deprecated: Please use `Scaled` tier instead.
// Enterprise tier offers production grade performance along with
// autoscaling functionality. It is suitable for customers with large
// amounts of data or performance sensitive workloads.
//
// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/vertex_rag_data.proto.
type RagManagedDbConfig_Enterprise struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RagManagedDbConfig_Enterprise) Reset() {
	*x = RagManagedDbConfig_Enterprise{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagManagedDbConfig_Enterprise) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagManagedDbConfig_Enterprise) ProtoMessage() {}

func (x *RagManagedDbConfig_Enterprise) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagManagedDbConfig_Enterprise.ProtoReflect.Descriptor instead.
func (*RagManagedDbConfig_Enterprise) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{14, 0}
}

// Scaled tier offers production grade performance along with
// autoscaling functionality. It is suitable for customers with large
// amounts of data or performance sensitive workloads.
type RagManagedDbConfig_Scaled struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RagManagedDbConfig_Scaled) Reset() {
	*x = RagManagedDbConfig_Scaled{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagManagedDbConfig_Scaled) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagManagedDbConfig_Scaled) ProtoMessage() {}

func (x *RagManagedDbConfig_Scaled) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagManagedDbConfig_Scaled.ProtoReflect.Descriptor instead.
func (*RagManagedDbConfig_Scaled) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{14, 1}
}

// Basic tier is a cost-effective and low compute tier suitable for
// the following cases:
// * Experimenting with RagManagedDb.
// * Small data size.
// * Latency insensitive workload.
// * Only using RAG Engine with external vector DBs.
//
// NOTE: This is the default tier if not explicitly chosen.
type RagManagedDbConfig_Basic struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RagManagedDbConfig_Basic) Reset() {
	*x = RagManagedDbConfig_Basic{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagManagedDbConfig_Basic) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagManagedDbConfig_Basic) ProtoMessage() {}

func (x *RagManagedDbConfig_Basic) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagManagedDbConfig_Basic.ProtoReflect.Descriptor instead.
func (*RagManagedDbConfig_Basic) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{14, 2}
}

// Disables the RAG Engine service and deletes all your data held
// within this service. This will halt the billing of the service.
//
// NOTE: Once deleted the data cannot be recovered. To start using
// RAG Engine again, you will need to update the tier by calling the
// UpdateRagEngineConfig API.
type RagManagedDbConfig_Unprovisioned struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RagManagedDbConfig_Unprovisioned) Reset() {
	*x = RagManagedDbConfig_Unprovisioned{}
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RagManagedDbConfig_Unprovisioned) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RagManagedDbConfig_Unprovisioned) ProtoMessage() {}

func (x *RagManagedDbConfig_Unprovisioned) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RagManagedDbConfig_Unprovisioned.ProtoReflect.Descriptor instead.
func (*RagManagedDbConfig_Unprovisioned) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP(), []int{14, 3}
}

var File_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x5f, 0x72, 0x61, 0x67, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x70, 0x69, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x69, 0x6f, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe7, 0x08, 0x0a, 0x17, 0x52, 0x61, 0x67, 0x45, 0x6d,
	0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x91, 0x01, 0x0a, 0x1a, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x5f, 0x70, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x45, 0x6d, 0x62,
	0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x18, 0x76, 0x65,
	0x72, 0x74, 0x65, 0x78, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x7f, 0x0a, 0x14, 0x68, 0x79, 0x62, 0x72, 0x69, 0x64,
	0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64,
	0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x48,
	0x79, 0x62, 0x72, 0x69, 0x64, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x48, 0x00, 0x52, 0x12, 0x68, 0x79, 0x62, 0x72, 0x69, 0x64, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0xd0, 0x01, 0x0a, 0x18, 0x56, 0x65, 0x72, 0x74,
	0x65, 0x78, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x12, 0x46, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x3d, 0x0a, 0x05,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x03,
	0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x2d, 0x0a, 0x10, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x1a, 0xfb, 0x01, 0x0a, 0x15, 0x53,
	0x70, 0x61, 0x72, 0x73, 0x65, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x69, 0x0a, 0x04, 0x62, 0x6d, 0x32, 0x35, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e,
	0x67, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x70, 0x61,
	0x72, 0x73, 0x65, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x42, 0x6d, 0x32, 0x35, 0x48, 0x00, 0x52, 0x04, 0x62, 0x6d, 0x32, 0x35, 0x1a,
	0x6e, 0x0a, 0x04, 0x42, 0x6d, 0x32, 0x35, 0x12, 0x27, 0x0a, 0x0c, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x6c, 0x69, 0x6e, 0x67, 0x75, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x75, 0x61, 0x6c,
	0x12, 0x18, 0x0a, 0x02, 0x6b, 0x31, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x00, 0x52, 0x02, 0x6b, 0x31, 0x88, 0x01, 0x01, 0x12, 0x16, 0x0a, 0x01, 0x62, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x01, 0x62, 0x88,
	0x01, 0x01, 0x42, 0x05, 0x0a, 0x03, 0x5f, 0x6b, 0x31, 0x42, 0x04, 0x0a, 0x02, 0x5f, 0x62, 0x42,
	0x07, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x1a, 0xd5, 0x02, 0x0a, 0x12, 0x48, 0x79, 0x62,
	0x72, 0x69, 0x64, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x8b, 0x01, 0x0a, 0x17, 0x73, 0x70, 0x61, 0x72, 0x73, 0x65, 0x5f, 0x65, 0x6d, 0x62, 0x65, 0x64,
	0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x70, 0x61, 0x72,
	0x73, 0x65, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x73, 0x70, 0x61, 0x72, 0x73, 0x65, 0x45, 0x6d,
	0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0xb0, 0x01,
	0x0a, 0x29, 0x64, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e,
	0x67, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x56, 0x65, 0x72, 0x74,
	0x65, 0x78, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x25, 0x64, 0x65, 0x6e, 0x73, 0x65,
	0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x50, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x42, 0x0e, 0x0a, 0x0c, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0xc9, 0x0a, 0x0a, 0x11, 0x52, 0x61, 0x67, 0x56, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x44, 0x62,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x67, 0x0a, 0x0e, 0x72, 0x61, 0x67, 0x5f, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x64, 0x62, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x52, 0x61, 0x67, 0x56, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x44, 0x62, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x52, 0x61, 0x67, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x44, 0x62, 0x48,
	0x00, 0x52, 0x0c, 0x72, 0x61, 0x67, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x44, 0x62, 0x12,
	0x59, 0x0a, 0x08, 0x77, 0x65, 0x61, 0x76, 0x69, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x56, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x44, 0x62, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x57, 0x65, 0x61, 0x76, 0x69, 0x61, 0x74, 0x65, 0x48, 0x00,
	0x52, 0x08, 0x77, 0x65, 0x61, 0x76, 0x69, 0x61, 0x74, 0x65, 0x12, 0x59, 0x0a, 0x08, 0x70, 0x69,
	0x6e, 0x65, 0x63, 0x6f, 0x6e, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52,
	0x61, 0x67, 0x56, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x44, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x50, 0x69, 0x6e, 0x65, 0x63, 0x6f, 0x6e, 0x65, 0x48, 0x00, 0x52, 0x08, 0x70, 0x69, 0x6e,
	0x65, 0x63, 0x6f, 0x6e, 0x65, 0x12, 0x79, 0x0a, 0x14, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x5f,
	0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x56, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x44,
	0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x48, 0x00, 0x52, 0x12, 0x76, 0x65,
	0x72, 0x74, 0x65, 0x78, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x12, 0x79, 0x0a, 0x14, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x5f, 0x76, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x52, 0x61, 0x67, 0x56, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x44, 0x62, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x56, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x48, 0x00, 0x52, 0x12, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x56,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x43, 0x0a, 0x08, 0x61,
	0x70, 0x69, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x41, 0x70, 0x69, 0x41, 0x75, 0x74, 0x68, 0x52, 0x07, 0x61, 0x70, 0x69, 0x41, 0x75, 0x74, 0x68,
	0x12, 0x7d, 0x0a, 0x1a, 0x72, 0x61, 0x67, 0x5f, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e,
	0x67, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64,
	0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x06,
	0xe0, 0x41, 0x01, 0xe0, 0x41, 0x05, 0x52, 0x17, 0x72, 0x61, 0x67, 0x45, 0x6d, 0x62, 0x65, 0x64,
	0x64, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a,
	0xa2, 0x02, 0x0a, 0x0c, 0x52, 0x61, 0x67, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x44, 0x62,
	0x12, 0x57, 0x0a, 0x03, 0x6b, 0x6e, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x52, 0x61, 0x67, 0x56, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x44, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x52, 0x61, 0x67, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x44, 0x62, 0x2e, 0x4b,
	0x4e, 0x4e, 0x48, 0x00, 0x52, 0x03, 0x6b, 0x6e, 0x6e, 0x12, 0x57, 0x0a, 0x03, 0x61, 0x6e, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x56, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x44, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x61, 0x67, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x64, 0x44, 0x62, 0x2e, 0x41, 0x4e, 0x4e, 0x48, 0x00, 0x52, 0x03, 0x61,
	0x6e, 0x6e, 0x1a, 0x05, 0x0a, 0x03, 0x4b, 0x4e, 0x4e, 0x1a, 0x43, 0x0a, 0x03, 0x41, 0x4e, 0x4e,
	0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x72, 0x65, 0x65, 0x5f, 0x64, 0x65, 0x70, 0x74, 0x68, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x74, 0x72, 0x65, 0x65, 0x44, 0x65, 0x70, 0x74, 0x68, 0x12,
	0x1d, 0x0a, 0x0a, 0x6c, 0x65, 0x61, 0x66, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x09, 0x6c, 0x65, 0x61, 0x66, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x14,
	0x0a, 0x12, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x65, 0x67, 0x79, 0x1a, 0x58, 0x0a, 0x08, 0x57, 0x65, 0x61, 0x76, 0x69, 0x61, 0x74, 0x65,
	0x12, 0x23, 0x0a, 0x0d, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x68, 0x74, 0x74, 0x70, 0x45, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x27, 0x0a, 0x0f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e,
	0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x29,
	0x0a, 0x08, 0x50, 0x69, 0x6e, 0x65, 0x63, 0x6f, 0x6e, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x51, 0x0a, 0x12, 0x56, 0x65, 0x72,
	0x74, 0x65, 0x78, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12,
	0x3b, 0x0a, 0x1a, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x17, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x69, 0x65, 0x77,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x51, 0x0a, 0x12,
	0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x56, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x12, 0x25, 0x0a, 0x0e, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x5f, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e, 0x64,
	0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x42,
	0x0b, 0x0a, 0x09, 0x76, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x64, 0x62, 0x22, 0xb9, 0x01, 0x0a,
	0x0a, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x4c, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x6c,
	0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x22, 0x35, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x09, 0x0a,
	0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x02, 0x22, 0x3d, 0x0a, 0x14, 0x56, 0x65, 0x72, 0x74,
	0x65, 0x78, 0x41, 0x69, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x25, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xc4, 0x01, 0x0a, 0x0c, 0x43, 0x6f, 0x72, 0x70,
	0x75, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x4e, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x22, 0x3c, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b,
	0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41,
	0x4c, 0x49, 0x5a, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56,
	0x45, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x03, 0x22, 0xd3,
	0x0c, 0x0a, 0x09, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x12, 0x66, 0x0a, 0x10,
	0x76, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x64, 0x62, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x56, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x44, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0,
	0x41, 0x05, 0x48, 0x00, 0x52, 0x0e, 0x76, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x44, 0x62, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x76, 0x0a, 0x17, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x5f, 0x61,
	0x69, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x41, 0x69,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x06, 0xe0, 0x41,
	0x01, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x14, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x41, 0x69,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7f, 0x0a, 0x1a, 0x72, 0x61, 0x67, 0x5f, 0x65, 0x6d, 0x62, 0x65,
	0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x45, 0x6d,
	0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x08, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x05, 0x18, 0x01, 0x52, 0x17, 0x72, 0x61,
	0x67, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6d, 0x0a, 0x14, 0x72, 0x61, 0x67, 0x5f, 0x76, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x5f, 0x64, 0x62, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x56, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x44,
	0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x08, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x05, 0x18,
	0x01, 0x52, 0x11, 0x72, 0x61, 0x67, 0x56, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x44, 0x62, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x0d, 0x63, 0x6f, 0x72, 0x70,
	0x75, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0c, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x72, 0x61, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0d, 0x72, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x60,
	0x0a, 0x0f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x01,
	0x52, 0x0e, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x6e, 0x0a, 0x12, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52,
	0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x2e, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x54,
	0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10,
	0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x1a, 0x9c, 0x03, 0x0a, 0x10, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x54, 0x79, 0x70, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7a, 0x0a, 0x0f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x2e, 0x43, 0x6f, 0x72, 0x70, 0x75,
	0x73, 0x54, 0x79, 0x70, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x00, 0x52, 0x0e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f, 0x72, 0x70, 0x75,
	0x73, 0x12, 0x74, 0x0a, 0x0d, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x72, 0x70,
	0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x43, 0x6f,
	0x72, 0x70, 0x75, 0x73, 0x2e, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x54, 0x79, 0x70, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x72, 0x70,
	0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0c, 0x6d, 0x65, 0x6d, 0x6f, 0x72,
	0x79, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x1a, 0x10, 0x0a, 0x0e, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x1a, 0x6e, 0x0a, 0x0c, 0x4d, 0x65, 0x6d,
	0x6f, 0x72, 0x79, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x12, 0x5e, 0x0a, 0x0a, 0x6c, 0x6c, 0x6d,
	0x5f, 0x70, 0x61, 0x72, 0x73, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x50, 0x61, 0x72, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x6c, 0x6d, 0x50, 0x61, 0x72, 0x73, 0x65, 0x72, 0x52, 0x09,
	0x6c, 0x6c, 0x6d, 0x50, 0x61, 0x72, 0x73, 0x65, 0x72, 0x42, 0x14, 0x0a, 0x12, 0x63, 0x6f, 0x72,
	0x70, 0x75, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3a,
	0x80, 0x01, 0xea, 0x41, 0x7d, 0x0a, 0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x52, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x12, 0x3f, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x7b,
	0x72, 0x61, 0x67, 0x5f, 0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x7d, 0x2a, 0x0a, 0x72, 0x61, 0x67,
	0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x32, 0x09, 0x72, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70,
	0x75, 0x73, 0x42, 0x10, 0x0a, 0x0e, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0xaa, 0x0a, 0x0a, 0x07, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65,
	0x12, 0x50, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x69, 0x0a, 0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x64, 0x72, 0x69,
	0x76, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x44, 0x72, 0x69, 0x76, 0x65, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x11, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x44, 0x72, 0x69, 0x76, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x6c, 0x0a,
	0x14, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x5f, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x12, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x55,
	0x70, 0x6c, 0x6f, 0x61, 0x64, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x51, 0x0a, 0x0c, 0x73,
	0x6c, 0x61, 0x63, 0x6b, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x53, 0x6c, 0x61, 0x63, 0x6b, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48,
	0x00, 0x52, 0x0b, 0x73, 0x6c, 0x61, 0x63, 0x6b, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4e,
	0x0a, 0x0b, 0x6a, 0x69, 0x72, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a, 0x69, 0x72, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x48, 0x00, 0x52, 0x0a, 0x6a, 0x69, 0x72, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x64,
	0x0a, 0x13, 0x73, 0x68, 0x61, 0x72, 0x65, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x68,
	0x61, 0x72, 0x65, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x48,
	0x00, 0x52, 0x11, 0x73, 0x68, 0x61, 0x72, 0x65, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a,
	0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0a,
	0x73, 0x69, 0x7a, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x69, 0x7a, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x12, 0x5d, 0x0a, 0x0d, 0x72, 0x61, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c,
	0x65, 0x2e, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0b, 0x72, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x51, 0x0a, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x66, 0x69, 0x6c, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0c, 0x75, 0x73, 0x65, 0x72, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x22, 0x5a, 0x0a, 0x0b, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1d, 0x0a, 0x19, 0x52, 0x41, 0x47, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15,
	0x0a, 0x11, 0x52, 0x41, 0x47, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x54, 0x58, 0x54, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x52, 0x41, 0x47, 0x5f, 0x46, 0x49, 0x4c,
	0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x50, 0x44, 0x46, 0x10, 0x02, 0x3a, 0x8f, 0x01, 0xea,
	0x41, 0x8b, 0x01, 0x0a, 0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52,
	0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x53, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x72, 0x61, 0x67, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x2f, 0x7b, 0x72, 0x61, 0x67, 0x5f,
	0x63, 0x6f, 0x72, 0x70, 0x75, 0x73, 0x7d, 0x2f, 0x72, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x73,
	0x2f, 0x7b, 0x72, 0x61, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x7d, 0x2a, 0x08, 0x72, 0x61, 0x67,
	0x46, 0x69, 0x6c, 0x65, 0x73, 0x32, 0x07, 0x72, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x42, 0x11,
	0x0a, 0x0f, 0x72, 0x61, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x22, 0xca, 0x01, 0x0a, 0x08, 0x52, 0x61, 0x67, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x12, 0x12,
	0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x65,
	0x78, 0x74, 0x12, 0x54, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x70, 0x61, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x43, 0x68, 0x75, 0x6e, 0x6b,
	0x2e, 0x50, 0x61, 0x67, 0x65, 0x53, 0x70, 0x61, 0x6e, 0x48, 0x00, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x70, 0x61, 0x6e, 0x88, 0x01, 0x01, 0x1a, 0x46, 0x0a, 0x08, 0x50, 0x61, 0x67, 0x65,
	0x53, 0x70, 0x61, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x69, 0x72, 0x73, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x66, 0x69, 0x72, 0x73, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x6c, 0x61, 0x73, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x70, 0x61, 0x6e, 0x22, 0xd4,
	0x02, 0x0a, 0x15, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x80, 0x01, 0x0a, 0x15, 0x66, 0x69, 0x78,
	0x65, 0x64, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x5f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x69,
	0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x46, 0x69,
	0x6c, 0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x46, 0x69, 0x78, 0x65, 0x64, 0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x43, 0x68, 0x75, 0x6e,
	0x6b, 0x69, 0x6e, 0x67, 0x48, 0x00, 0x52, 0x13, 0x66, 0x69, 0x78, 0x65, 0x64, 0x4c, 0x65, 0x6e,
	0x67, 0x74, 0x68, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x12, 0x21, 0x0a, 0x0a, 0x63,
	0x68, 0x75, 0x6e, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x09, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x27,
	0x0a, 0x0d, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x70, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0c, 0x63, 0x68, 0x75, 0x6e, 0x6b,
	0x4f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x70, 0x1a, 0x59, 0x0a, 0x13, 0x46, 0x69, 0x78, 0x65, 0x64,
	0x4c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x12, 0x1d,
	0x0a, 0x0a, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x09, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x23, 0x0a,
	0x0d, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x70, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0c, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x4f, 0x76, 0x65, 0x72, 0x6c,
	0x61, 0x70, 0x42, 0x11, 0x0a, 0x0f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x8e, 0x01, 0x0a, 0x1b, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c,
	0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6f, 0x0a, 0x18, 0x72, 0x61, 0x67, 0x5f, 0x66, 0x69, 0x6c,
	0x65, 0x5f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c,
	0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x15, 0x72, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x99, 0x07, 0x0a, 0x14, 0x52, 0x61, 0x67, 0x46, 0x69,
	0x6c, 0x65, 0x50, 0x61, 0x72, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x6f, 0x0a, 0x0f, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x73,
	0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x46, 0x69,
	0x6c, 0x65, 0x50, 0x61, 0x72, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x50, 0x61, 0x72, 0x73, 0x65, 0x72, 0x48, 0x00,
	0x52, 0x0e, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x50, 0x61, 0x72, 0x73, 0x65, 0x72,
	0x12, 0x69, 0x0a, 0x0d, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x73, 0x65,
	0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c,
	0x65, 0x50, 0x61, 0x72, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c,
	0x61, 0x79, 0x6f, 0x75, 0x74, 0x50, 0x61, 0x72, 0x73, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0c, 0x6c,
	0x61, 0x79, 0x6f, 0x75, 0x74, 0x50, 0x61, 0x72, 0x73, 0x65, 0x72, 0x12, 0x60, 0x0a, 0x0a, 0x6c,
	0x6c, 0x6d, 0x5f, 0x70, 0x61, 0x72, 0x73, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x50, 0x61, 0x72, 0x73, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x6c, 0x6d, 0x50, 0x61, 0x72, 0x73, 0x65, 0x72,
	0x48, 0x00, 0x52, 0x09, 0x6c, 0x6c, 0x6d, 0x50, 0x61, 0x72, 0x73, 0x65, 0x72, 0x12, 0x3b, 0x0a,
	0x18, 0x75, 0x73, 0x65, 0x5f, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x70, 0x64,
	0x66, 0x5f, 0x70, 0x61, 0x72, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x15, 0x75, 0x73, 0x65, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64,
	0x50, 0x64, 0x66, 0x50, 0x61, 0x72, 0x73, 0x69, 0x6e, 0x67, 0x1a, 0x49, 0x0a, 0x0e, 0x41, 0x64,
	0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x50, 0x61, 0x72, 0x73, 0x65, 0x72, 0x12, 0x37, 0x0a, 0x18,
	0x75, 0x73, 0x65, 0x5f, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x5f, 0x70, 0x64, 0x66,
	0x5f, 0x70, 0x61, 0x72, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15,
	0x75, 0x73, 0x65, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x50, 0x64, 0x66, 0x50, 0x61,
	0x72, 0x73, 0x69, 0x6e, 0x67, 0x1a, 0xc2, 0x01, 0x0a, 0x0c, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74,
	0x50, 0x61, 0x72, 0x73, 0x65, 0x72, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x6f, 0x72, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3e, 0x0a,
	0x1c, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x61, 0x72, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6d, 0x69, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x18, 0x6d, 0x61, 0x78, 0x50, 0x61, 0x72, 0x73, 0x69, 0x6e, 0x67, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x50, 0x65, 0x72, 0x4d, 0x69, 0x6e, 0x12, 0x4b, 0x0a,
	0x23, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x61, 0x72, 0x73,
	0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x5f, 0x70, 0x65, 0x72,
	0x5f, 0x6d, 0x69, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x1e, 0x67, 0x6c, 0x6f, 0x62,
	0x61, 0x6c, 0x4d, 0x61, 0x78, 0x50, 0x61, 0x72, 0x73, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x73, 0x50, 0x65, 0x72, 0x4d, 0x69, 0x6e, 0x1a, 0xeb, 0x01, 0x0a, 0x09, 0x4c,
	0x6c, 0x6d, 0x50, 0x61, 0x72, 0x73, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x1c, 0x6d, 0x61, 0x78, 0x5f, 0x70,
	0x61, 0x72, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x5f,
	0x70, 0x65, 0x72, 0x5f, 0x6d, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x18, 0x6d,
	0x61, 0x78, 0x50, 0x61, 0x72, 0x73, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x73, 0x50, 0x65, 0x72, 0x4d, 0x69, 0x6e, 0x12, 0x4b, 0x0a, 0x23, 0x67, 0x6c, 0x6f, 0x62, 0x61,
	0x6c, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x61, 0x72, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6d, 0x69, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x1e, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x4d, 0x61, 0x78, 0x50,
	0x61, 0x72, 0x73, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x50, 0x65,
	0x72, 0x4d, 0x69, 0x6e, 0x12, 0x32, 0x0a, 0x15, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x70,
	0x61, 0x72, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x13, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x61, 0x72, 0x73, 0x69,
	0x6e, 0x67, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x42, 0x08, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x73,
	0x65, 0x72, 0x22, 0x86, 0x05, 0x0a, 0x15, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x69, 0x0a, 0x1a,
	0x67, 0x63, 0x73, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x17,
	0x67, 0x63, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x82, 0x01, 0x0a, 0x23, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x44, 0x72,
	0x69, 0x76, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x44, 0x72, 0x69, 0x76, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x43, 0x0a, 0x1d,
	0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x1a, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x5c, 0x0a, 0x13, 0x67, 0x63, 0x73, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x01, 0x52, 0x11, 0x67, 0x63,
	0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x75, 0x0a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x5f,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x44, 0x72,
	0x69, 0x76, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x01, 0x52, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x44, 0x72, 0x69, 0x76, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x36, 0x0a, 0x16, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x14, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x18,
	0x0a, 0x16, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x11, 0x0a, 0x0f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xf2, 0x03, 0x0a, 0x13,
	0x55, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x73, 0x0a, 0x18, 0x72, 0x61, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x63, 0x68, 0x75, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x43,
	0x68, 0x75, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x15, 0x72, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x81, 0x01, 0x0a, 0x1e, 0x72, 0x61, 0x67,
	0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x1b, 0x72, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6f, 0x0a, 0x18,
	0x72, 0x61, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x15, 0x72, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x71, 0x0a,
	0x17, 0x72, 0x61, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x73, 0x69, 0x6e,
	0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x50, 0x61, 0x72, 0x73, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x72, 0x61, 0x67, 0x46,
	0x69, 0x6c, 0x65, 0x50, 0x61, 0x72, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0x87, 0x0d, 0x0a, 0x14, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x61, 0x67, 0x46, 0x69,
	0x6c, 0x65, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4b, 0x0a, 0x0a, 0x67, 0x63, 0x73,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x64, 0x0a, 0x13, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5f, 0x64, 0x72, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x44, 0x72, 0x69, 0x76,
	0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x11, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x44, 0x72, 0x69, 0x76, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x51, 0x0a, 0x0c,
	0x73, 0x6c, 0x61, 0x63, 0x6b, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x6c, 0x61, 0x63, 0x6b, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x48, 0x00, 0x52, 0x0b, 0x73, 0x6c, 0x61, 0x63, 0x6b, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x4e, 0x0a, 0x0b, 0x6a, 0x69, 0x72, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a, 0x69, 0x72, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x48, 0x00, 0x52, 0x0a, 0x6a, 0x69, 0x72, 0x61, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x64, 0x0a, 0x13, 0x73, 0x68, 0x61, 0x72, 0x65, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53,
	0x68, 0x61, 0x72, 0x65, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x48, 0x00, 0x52, 0x11, 0x73, 0x68, 0x61, 0x72, 0x65, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x6e, 0x0a, 0x18, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c,
	0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x69, 0x6e,
	0x6b, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x02, 0x18, 0x01, 0x48, 0x01, 0x52, 0x15,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x47, 0x63,
	0x73, 0x53, 0x69, 0x6e, 0x6b, 0x12, 0x7d, 0x0a, 0x1d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c,
	0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42,
	0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x02, 0x18, 0x01, 0x48, 0x01, 0x52, 0x1a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61,
	0x6c, 0x46, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x42, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x53, 0x69, 0x6e, 0x6b, 0x12, 0x66, 0x0a, 0x16, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x02, 0x52, 0x13, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x47, 0x63, 0x73, 0x53, 0x69, 0x6e, 0x6b, 0x12, 0x75, 0x0a, 0x1b,
	0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x62, 0x69,
	0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x18, 0x0f, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x02, 0x52, 0x18, 0x69, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x53,
	0x69, 0x6e, 0x6b, 0x12, 0x73, 0x0a, 0x18, 0x72, 0x61, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x63, 0x68, 0x75, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x43,
	0x68, 0x75, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x15, 0x72, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x81, 0x01, 0x0a, 0x1e, 0x72, 0x61, 0x67,
	0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x10, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x1b, 0x72, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x71, 0x0a, 0x17,
	0x72, 0x61, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x73, 0x69, 0x6e, 0x67,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x50, 0x61, 0x72, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x72, 0x61, 0x67, 0x46, 0x69,
	0x6c, 0x65, 0x50, 0x61, 0x72, 0x73, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x6f, 0x0a, 0x18, 0x72, 0x61, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x11, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x46, 0x69, 0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x15, 0x72, 0x61, 0x67, 0x46, 0x69,
	0x6c, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x47, 0x0a, 0x1e, 0x6d, 0x61, 0x78, 0x5f, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e,
	0x67, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6d,
	0x69, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1a, 0x6d,
	0x61, 0x78, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x73, 0x50, 0x65, 0x72, 0x4d, 0x69, 0x6e, 0x12, 0x54, 0x0a, 0x25, 0x67, 0x6c, 0x6f,
	0x62, 0x61, 0x6c, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e,
	0x67, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6d,
	0x69, 0x6e, 0x18, 0x12, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x20, 0x67,
	0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x4d, 0x61, 0x78, 0x45, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e,
	0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x50, 0x65, 0x72, 0x4d, 0x69, 0x6e, 0x12,
	0x2a, 0x0a, 0x11, 0x72, 0x65, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x61, 0x6e, 0x6e, 0x5f, 0x69,
	0x6e, 0x64, 0x65, 0x78, 0x18, 0x13, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x72, 0x65, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x41, 0x6e, 0x6e, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x42, 0x0f, 0x0a, 0x0d, 0x69,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x16, 0x0a, 0x14,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x5f,
	0x73, 0x69, 0x6e, 0x6b, 0x42, 0x14, 0x0a, 0x12, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x5f, 0x73, 0x69, 0x6e, 0x6b, 0x22, 0xcc, 0x03, 0x0a, 0x12, 0x52,
	0x61, 0x67, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x44, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x64, 0x0a, 0x0a, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x64, 0x44, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x45, 0x6e, 0x74, 0x65, 0x72,
	0x70, 0x72, 0x69, 0x73, 0x65, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x0a, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x12, 0x54, 0x0a, 0x06, 0x73, 0x63, 0x61, 0x6c, 0x65,
	0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x64, 0x44, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x63, 0x61,
	0x6c, 0x65, 0x64, 0x48, 0x00, 0x52, 0x06, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x64, 0x12, 0x51, 0x0a,
	0x05, 0x62, 0x61, 0x73, 0x69, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52,
	0x61, 0x67, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x44, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x42, 0x61, 0x73, 0x69, 0x63, 0x48, 0x00, 0x52, 0x05, 0x62, 0x61, 0x73, 0x69, 0x63,
	0x12, 0x69, 0x0a, 0x0d, 0x75, 0x6e, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x65,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x64, 0x44, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x55, 0x6e, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x48, 0x00, 0x52, 0x0d, 0x75, 0x6e,
	0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x1a, 0x10, 0x0a, 0x0a, 0x45,
	0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x3a, 0x02, 0x18, 0x01, 0x1a, 0x08, 0x0a,
	0x06, 0x53, 0x63, 0x61, 0x6c, 0x65, 0x64, 0x1a, 0x07, 0x0a, 0x05, 0x42, 0x61, 0x73, 0x69, 0x63,
	0x1a, 0x0f, 0x0a, 0x0d, 0x55, 0x6e, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x65,
	0x64, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x69, 0x65, 0x72, 0x22, 0xa0, 0x02, 0x0a, 0x0f, 0x52, 0x61,
	0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x66, 0x0a, 0x15, 0x72, 0x61, 0x67, 0x5f, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x64, 0x62, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x4d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x64, 0x44, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x12, 0x72, 0x61, 0x67, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x44, 0x62, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3a, 0x8b,
	0x01, 0xea, 0x41, 0x87, 0x01, 0x0a, 0x29, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x52, 0x61, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x37, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x61, 0x67, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2a, 0x10, 0x72, 0x61, 0x67, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x32, 0x0f, 0x72, 0x61, 0x67,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0xe9, 0x01, 0x0a,
	0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x42, 0x12, 0x56, 0x65, 0x72, 0x74, 0x65, 0x78, 0x52, 0x61, 0x67, 0x44,
	0x61, 0x74, 0x61, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa,
	0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41,
	0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61,
	0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a,
	0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes = make([]protoimpl.MessageInfo, 39)
var file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_goTypes = []any{
	(FileStatus_State)(0),                                      // 0: google.cloud.aiplatform.v1beta1.FileStatus.State
	(CorpusStatus_State)(0),                                    // 1: google.cloud.aiplatform.v1beta1.CorpusStatus.State
	(RagFile_RagFileType)(0),                                   // 2: google.cloud.aiplatform.v1beta1.RagFile.RagFileType
	(*RagEmbeddingModelConfig)(nil),                            // 3: google.cloud.aiplatform.v1beta1.RagEmbeddingModelConfig
	(*RagVectorDbConfig)(nil),                                  // 4: google.cloud.aiplatform.v1beta1.RagVectorDbConfig
	(*FileStatus)(nil),                                         // 5: google.cloud.aiplatform.v1beta1.FileStatus
	(*VertexAiSearchConfig)(nil),                               // 6: google.cloud.aiplatform.v1beta1.VertexAiSearchConfig
	(*CorpusStatus)(nil),                                       // 7: google.cloud.aiplatform.v1beta1.CorpusStatus
	(*RagCorpus)(nil),                                          // 8: google.cloud.aiplatform.v1beta1.RagCorpus
	(*RagFile)(nil),                                            // 9: google.cloud.aiplatform.v1beta1.RagFile
	(*RagChunk)(nil),                                           // 10: google.cloud.aiplatform.v1beta1.RagChunk
	(*RagFileChunkingConfig)(nil),                              // 11: google.cloud.aiplatform.v1beta1.RagFileChunkingConfig
	(*RagFileTransformationConfig)(nil),                        // 12: google.cloud.aiplatform.v1beta1.RagFileTransformationConfig
	(*RagFileParsingConfig)(nil),                               // 13: google.cloud.aiplatform.v1beta1.RagFileParsingConfig
	(*RagFileMetadataConfig)(nil),                              // 14: google.cloud.aiplatform.v1beta1.RagFileMetadataConfig
	(*UploadRagFileConfig)(nil),                                // 15: google.cloud.aiplatform.v1beta1.UploadRagFileConfig
	(*ImportRagFilesConfig)(nil),                               // 16: google.cloud.aiplatform.v1beta1.ImportRagFilesConfig
	(*RagManagedDbConfig)(nil),                                 // 17: google.cloud.aiplatform.v1beta1.RagManagedDbConfig
	(*RagEngineConfig)(nil),                                    // 18: google.cloud.aiplatform.v1beta1.RagEngineConfig
	(*RagEmbeddingModelConfig_VertexPredictionEndpoint)(nil),   // 19: google.cloud.aiplatform.v1beta1.RagEmbeddingModelConfig.VertexPredictionEndpoint
	(*RagEmbeddingModelConfig_SparseEmbeddingConfig)(nil),      // 20: google.cloud.aiplatform.v1beta1.RagEmbeddingModelConfig.SparseEmbeddingConfig
	(*RagEmbeddingModelConfig_HybridSearchConfig)(nil),         // 21: google.cloud.aiplatform.v1beta1.RagEmbeddingModelConfig.HybridSearchConfig
	(*RagEmbeddingModelConfig_SparseEmbeddingConfig_Bm25)(nil), // 22: google.cloud.aiplatform.v1beta1.RagEmbeddingModelConfig.SparseEmbeddingConfig.Bm25
	(*RagVectorDbConfig_RagManagedDb)(nil),                     // 23: google.cloud.aiplatform.v1beta1.RagVectorDbConfig.RagManagedDb
	(*RagVectorDbConfig_Weaviate)(nil),                         // 24: google.cloud.aiplatform.v1beta1.RagVectorDbConfig.Weaviate
	(*RagVectorDbConfig_Pinecone)(nil),                         // 25: google.cloud.aiplatform.v1beta1.RagVectorDbConfig.Pinecone
	(*RagVectorDbConfig_VertexFeatureStore)(nil),               // 26: google.cloud.aiplatform.v1beta1.RagVectorDbConfig.VertexFeatureStore
	(*RagVectorDbConfig_VertexVectorSearch)(nil),               // 27: google.cloud.aiplatform.v1beta1.RagVectorDbConfig.VertexVectorSearch
	(*RagVectorDbConfig_RagManagedDb_KNN)(nil),                 // 28: google.cloud.aiplatform.v1beta1.RagVectorDbConfig.RagManagedDb.KNN
	(*RagVectorDbConfig_RagManagedDb_ANN)(nil),                 // 29: google.cloud.aiplatform.v1beta1.RagVectorDbConfig.RagManagedDb.ANN
	(*RagCorpus_CorpusTypeConfig)(nil),                         // 30: google.cloud.aiplatform.v1beta1.RagCorpus.CorpusTypeConfig
	(*RagCorpus_CorpusTypeConfig_DocumentCorpus)(nil),          // 31: google.cloud.aiplatform.v1beta1.RagCorpus.CorpusTypeConfig.DocumentCorpus
	(*RagCorpus_CorpusTypeConfig_MemoryCorpus)(nil),            // 32: google.cloud.aiplatform.v1beta1.RagCorpus.CorpusTypeConfig.MemoryCorpus
	(*RagChunk_PageSpan)(nil),                                  // 33: google.cloud.aiplatform.v1beta1.RagChunk.PageSpan
	(*RagFileChunkingConfig_FixedLengthChunking)(nil),          // 34: google.cloud.aiplatform.v1beta1.RagFileChunkingConfig.FixedLengthChunking
	(*RagFileParsingConfig_AdvancedParser)(nil),                // 35: google.cloud.aiplatform.v1beta1.RagFileParsingConfig.AdvancedParser
	(*RagFileParsingConfig_LayoutParser)(nil),                  // 36: google.cloud.aiplatform.v1beta1.RagFileParsingConfig.LayoutParser
	(*RagFileParsingConfig_LlmParser)(nil),                     // 37: google.cloud.aiplatform.v1beta1.RagFileParsingConfig.LlmParser
	(*RagManagedDbConfig_Enterprise)(nil),                      // 38: google.cloud.aiplatform.v1beta1.RagManagedDbConfig.Enterprise
	(*RagManagedDbConfig_Scaled)(nil),                          // 39: google.cloud.aiplatform.v1beta1.RagManagedDbConfig.Scaled
	(*RagManagedDbConfig_Basic)(nil),                           // 40: google.cloud.aiplatform.v1beta1.RagManagedDbConfig.Basic
	(*RagManagedDbConfig_Unprovisioned)(nil),                   // 41: google.cloud.aiplatform.v1beta1.RagManagedDbConfig.Unprovisioned
	(*ApiAuth)(nil),                                            // 42: google.cloud.aiplatform.v1beta1.ApiAuth
	(*timestamppb.Timestamp)(nil),                              // 43: google.protobuf.Timestamp
	(*EncryptionSpec)(nil),                                     // 44: google.cloud.aiplatform.v1beta1.EncryptionSpec
	(*GcsSource)(nil),                                          // 45: google.cloud.aiplatform.v1beta1.GcsSource
	(*GoogleDriveSource)(nil),                                  // 46: google.cloud.aiplatform.v1beta1.GoogleDriveSource
	(*DirectUploadSource)(nil),                                 // 47: google.cloud.aiplatform.v1beta1.DirectUploadSource
	(*SlackSource)(nil),                                        // 48: google.cloud.aiplatform.v1beta1.SlackSource
	(*JiraSource)(nil),                                         // 49: google.cloud.aiplatform.v1beta1.JiraSource
	(*SharePointSources)(nil),                                  // 50: google.cloud.aiplatform.v1beta1.SharePointSources
	(*GcsDestination)(nil),                                     // 51: google.cloud.aiplatform.v1beta1.GcsDestination
	(*BigQueryDestination)(nil),                                // 52: google.cloud.aiplatform.v1beta1.BigQueryDestination
}
var file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_depIdxs = []int32{
	19, // 0: google.cloud.aiplatform.v1beta1.RagEmbeddingModelConfig.vertex_prediction_endpoint:type_name -> google.cloud.aiplatform.v1beta1.RagEmbeddingModelConfig.VertexPredictionEndpoint
	21, // 1: google.cloud.aiplatform.v1beta1.RagEmbeddingModelConfig.hybrid_search_config:type_name -> google.cloud.aiplatform.v1beta1.RagEmbeddingModelConfig.HybridSearchConfig
	23, // 2: google.cloud.aiplatform.v1beta1.RagVectorDbConfig.rag_managed_db:type_name -> google.cloud.aiplatform.v1beta1.RagVectorDbConfig.RagManagedDb
	24, // 3: google.cloud.aiplatform.v1beta1.RagVectorDbConfig.weaviate:type_name -> google.cloud.aiplatform.v1beta1.RagVectorDbConfig.Weaviate
	25, // 4: google.cloud.aiplatform.v1beta1.RagVectorDbConfig.pinecone:type_name -> google.cloud.aiplatform.v1beta1.RagVectorDbConfig.Pinecone
	26, // 5: google.cloud.aiplatform.v1beta1.RagVectorDbConfig.vertex_feature_store:type_name -> google.cloud.aiplatform.v1beta1.RagVectorDbConfig.VertexFeatureStore
	27, // 6: google.cloud.aiplatform.v1beta1.RagVectorDbConfig.vertex_vector_search:type_name -> google.cloud.aiplatform.v1beta1.RagVectorDbConfig.VertexVectorSearch
	42, // 7: google.cloud.aiplatform.v1beta1.RagVectorDbConfig.api_auth:type_name -> google.cloud.aiplatform.v1beta1.ApiAuth
	3,  // 8: google.cloud.aiplatform.v1beta1.RagVectorDbConfig.rag_embedding_model_config:type_name -> google.cloud.aiplatform.v1beta1.RagEmbeddingModelConfig
	0,  // 9: google.cloud.aiplatform.v1beta1.FileStatus.state:type_name -> google.cloud.aiplatform.v1beta1.FileStatus.State
	1,  // 10: google.cloud.aiplatform.v1beta1.CorpusStatus.state:type_name -> google.cloud.aiplatform.v1beta1.CorpusStatus.State
	4,  // 11: google.cloud.aiplatform.v1beta1.RagCorpus.vector_db_config:type_name -> google.cloud.aiplatform.v1beta1.RagVectorDbConfig
	6,  // 12: google.cloud.aiplatform.v1beta1.RagCorpus.vertex_ai_search_config:type_name -> google.cloud.aiplatform.v1beta1.VertexAiSearchConfig
	3,  // 13: google.cloud.aiplatform.v1beta1.RagCorpus.rag_embedding_model_config:type_name -> google.cloud.aiplatform.v1beta1.RagEmbeddingModelConfig
	4,  // 14: google.cloud.aiplatform.v1beta1.RagCorpus.rag_vector_db_config:type_name -> google.cloud.aiplatform.v1beta1.RagVectorDbConfig
	43, // 15: google.cloud.aiplatform.v1beta1.RagCorpus.create_time:type_name -> google.protobuf.Timestamp
	43, // 16: google.cloud.aiplatform.v1beta1.RagCorpus.update_time:type_name -> google.protobuf.Timestamp
	7,  // 17: google.cloud.aiplatform.v1beta1.RagCorpus.corpus_status:type_name -> google.cloud.aiplatform.v1beta1.CorpusStatus
	44, // 18: google.cloud.aiplatform.v1beta1.RagCorpus.encryption_spec:type_name -> google.cloud.aiplatform.v1beta1.EncryptionSpec
	30, // 19: google.cloud.aiplatform.v1beta1.RagCorpus.corpus_type_config:type_name -> google.cloud.aiplatform.v1beta1.RagCorpus.CorpusTypeConfig
	45, // 20: google.cloud.aiplatform.v1beta1.RagFile.gcs_source:type_name -> google.cloud.aiplatform.v1beta1.GcsSource
	46, // 21: google.cloud.aiplatform.v1beta1.RagFile.google_drive_source:type_name -> google.cloud.aiplatform.v1beta1.GoogleDriveSource
	47, // 22: google.cloud.aiplatform.v1beta1.RagFile.direct_upload_source:type_name -> google.cloud.aiplatform.v1beta1.DirectUploadSource
	48, // 23: google.cloud.aiplatform.v1beta1.RagFile.slack_source:type_name -> google.cloud.aiplatform.v1beta1.SlackSource
	49, // 24: google.cloud.aiplatform.v1beta1.RagFile.jira_source:type_name -> google.cloud.aiplatform.v1beta1.JiraSource
	50, // 25: google.cloud.aiplatform.v1beta1.RagFile.share_point_sources:type_name -> google.cloud.aiplatform.v1beta1.SharePointSources
	2,  // 26: google.cloud.aiplatform.v1beta1.RagFile.rag_file_type:type_name -> google.cloud.aiplatform.v1beta1.RagFile.RagFileType
	43, // 27: google.cloud.aiplatform.v1beta1.RagFile.create_time:type_name -> google.protobuf.Timestamp
	43, // 28: google.cloud.aiplatform.v1beta1.RagFile.update_time:type_name -> google.protobuf.Timestamp
	5,  // 29: google.cloud.aiplatform.v1beta1.RagFile.file_status:type_name -> google.cloud.aiplatform.v1beta1.FileStatus
	33, // 30: google.cloud.aiplatform.v1beta1.RagChunk.page_span:type_name -> google.cloud.aiplatform.v1beta1.RagChunk.PageSpan
	34, // 31: google.cloud.aiplatform.v1beta1.RagFileChunkingConfig.fixed_length_chunking:type_name -> google.cloud.aiplatform.v1beta1.RagFileChunkingConfig.FixedLengthChunking
	11, // 32: google.cloud.aiplatform.v1beta1.RagFileTransformationConfig.rag_file_chunking_config:type_name -> google.cloud.aiplatform.v1beta1.RagFileChunkingConfig
	35, // 33: google.cloud.aiplatform.v1beta1.RagFileParsingConfig.advanced_parser:type_name -> google.cloud.aiplatform.v1beta1.RagFileParsingConfig.AdvancedParser
	36, // 34: google.cloud.aiplatform.v1beta1.RagFileParsingConfig.layout_parser:type_name -> google.cloud.aiplatform.v1beta1.RagFileParsingConfig.LayoutParser
	37, // 35: google.cloud.aiplatform.v1beta1.RagFileParsingConfig.llm_parser:type_name -> google.cloud.aiplatform.v1beta1.RagFileParsingConfig.LlmParser
	45, // 36: google.cloud.aiplatform.v1beta1.RagFileMetadataConfig.gcs_metadata_schema_source:type_name -> google.cloud.aiplatform.v1beta1.GcsSource
	46, // 37: google.cloud.aiplatform.v1beta1.RagFileMetadataConfig.google_drive_metadata_schema_source:type_name -> google.cloud.aiplatform.v1beta1.GoogleDriveSource
	45, // 38: google.cloud.aiplatform.v1beta1.RagFileMetadataConfig.gcs_metadata_source:type_name -> google.cloud.aiplatform.v1beta1.GcsSource
	46, // 39: google.cloud.aiplatform.v1beta1.RagFileMetadataConfig.google_drive_metadata_source:type_name -> google.cloud.aiplatform.v1beta1.GoogleDriveSource
	11, // 40: google.cloud.aiplatform.v1beta1.UploadRagFileConfig.rag_file_chunking_config:type_name -> google.cloud.aiplatform.v1beta1.RagFileChunkingConfig
	12, // 41: google.cloud.aiplatform.v1beta1.UploadRagFileConfig.rag_file_transformation_config:type_name -> google.cloud.aiplatform.v1beta1.RagFileTransformationConfig
	14, // 42: google.cloud.aiplatform.v1beta1.UploadRagFileConfig.rag_file_metadata_config:type_name -> google.cloud.aiplatform.v1beta1.RagFileMetadataConfig
	13, // 43: google.cloud.aiplatform.v1beta1.UploadRagFileConfig.rag_file_parsing_config:type_name -> google.cloud.aiplatform.v1beta1.RagFileParsingConfig
	45, // 44: google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.gcs_source:type_name -> google.cloud.aiplatform.v1beta1.GcsSource
	46, // 45: google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.google_drive_source:type_name -> google.cloud.aiplatform.v1beta1.GoogleDriveSource
	48, // 46: google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.slack_source:type_name -> google.cloud.aiplatform.v1beta1.SlackSource
	49, // 47: google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.jira_source:type_name -> google.cloud.aiplatform.v1beta1.JiraSource
	50, // 48: google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.share_point_sources:type_name -> google.cloud.aiplatform.v1beta1.SharePointSources
	51, // 49: google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.partial_failure_gcs_sink:type_name -> google.cloud.aiplatform.v1beta1.GcsDestination
	52, // 50: google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.partial_failure_bigquery_sink:type_name -> google.cloud.aiplatform.v1beta1.BigQueryDestination
	51, // 51: google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.import_result_gcs_sink:type_name -> google.cloud.aiplatform.v1beta1.GcsDestination
	52, // 52: google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.import_result_bigquery_sink:type_name -> google.cloud.aiplatform.v1beta1.BigQueryDestination
	11, // 53: google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.rag_file_chunking_config:type_name -> google.cloud.aiplatform.v1beta1.RagFileChunkingConfig
	12, // 54: google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.rag_file_transformation_config:type_name -> google.cloud.aiplatform.v1beta1.RagFileTransformationConfig
	13, // 55: google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.rag_file_parsing_config:type_name -> google.cloud.aiplatform.v1beta1.RagFileParsingConfig
	14, // 56: google.cloud.aiplatform.v1beta1.ImportRagFilesConfig.rag_file_metadata_config:type_name -> google.cloud.aiplatform.v1beta1.RagFileMetadataConfig
	38, // 57: google.cloud.aiplatform.v1beta1.RagManagedDbConfig.enterprise:type_name -> google.cloud.aiplatform.v1beta1.RagManagedDbConfig.Enterprise
	39, // 58: google.cloud.aiplatform.v1beta1.RagManagedDbConfig.scaled:type_name -> google.cloud.aiplatform.v1beta1.RagManagedDbConfig.Scaled
	40, // 59: google.cloud.aiplatform.v1beta1.RagManagedDbConfig.basic:type_name -> google.cloud.aiplatform.v1beta1.RagManagedDbConfig.Basic
	41, // 60: google.cloud.aiplatform.v1beta1.RagManagedDbConfig.unprovisioned:type_name -> google.cloud.aiplatform.v1beta1.RagManagedDbConfig.Unprovisioned
	17, // 61: google.cloud.aiplatform.v1beta1.RagEngineConfig.rag_managed_db_config:type_name -> google.cloud.aiplatform.v1beta1.RagManagedDbConfig
	22, // 62: google.cloud.aiplatform.v1beta1.RagEmbeddingModelConfig.SparseEmbeddingConfig.bm25:type_name -> google.cloud.aiplatform.v1beta1.RagEmbeddingModelConfig.SparseEmbeddingConfig.Bm25
	20, // 63: google.cloud.aiplatform.v1beta1.RagEmbeddingModelConfig.HybridSearchConfig.sparse_embedding_config:type_name -> google.cloud.aiplatform.v1beta1.RagEmbeddingModelConfig.SparseEmbeddingConfig
	19, // 64: google.cloud.aiplatform.v1beta1.RagEmbeddingModelConfig.HybridSearchConfig.dense_embedding_model_prediction_endpoint:type_name -> google.cloud.aiplatform.v1beta1.RagEmbeddingModelConfig.VertexPredictionEndpoint
	28, // 65: google.cloud.aiplatform.v1beta1.RagVectorDbConfig.RagManagedDb.knn:type_name -> google.cloud.aiplatform.v1beta1.RagVectorDbConfig.RagManagedDb.KNN
	29, // 66: google.cloud.aiplatform.v1beta1.RagVectorDbConfig.RagManagedDb.ann:type_name -> google.cloud.aiplatform.v1beta1.RagVectorDbConfig.RagManagedDb.ANN
	31, // 67: google.cloud.aiplatform.v1beta1.RagCorpus.CorpusTypeConfig.document_corpus:type_name -> google.cloud.aiplatform.v1beta1.RagCorpus.CorpusTypeConfig.DocumentCorpus
	32, // 68: google.cloud.aiplatform.v1beta1.RagCorpus.CorpusTypeConfig.memory_corpus:type_name -> google.cloud.aiplatform.v1beta1.RagCorpus.CorpusTypeConfig.MemoryCorpus
	37, // 69: google.cloud.aiplatform.v1beta1.RagCorpus.CorpusTypeConfig.MemoryCorpus.llm_parser:type_name -> google.cloud.aiplatform.v1beta1.RagFileParsingConfig.LlmParser
	70, // [70:70] is the sub-list for method output_type
	70, // [70:70] is the sub-list for method input_type
	70, // [70:70] is the sub-list for extension type_name
	70, // [70:70] is the sub-list for extension extendee
	0,  // [0:70] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_init() }
func file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_api_auth_proto_init()
	file_google_cloud_aiplatform_v1beta1_encryption_spec_proto_init()
	file_google_cloud_aiplatform_v1beta1_io_proto_init()
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[0].OneofWrappers = []any{
		(*RagEmbeddingModelConfig_VertexPredictionEndpoint_)(nil),
		(*RagEmbeddingModelConfig_HybridSearchConfig_)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[1].OneofWrappers = []any{
		(*RagVectorDbConfig_RagManagedDb_)(nil),
		(*RagVectorDbConfig_Weaviate_)(nil),
		(*RagVectorDbConfig_Pinecone_)(nil),
		(*RagVectorDbConfig_VertexFeatureStore_)(nil),
		(*RagVectorDbConfig_VertexVectorSearch_)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[5].OneofWrappers = []any{
		(*RagCorpus_VectorDbConfig)(nil),
		(*RagCorpus_VertexAiSearchConfig)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[6].OneofWrappers = []any{
		(*RagFile_GcsSource)(nil),
		(*RagFile_GoogleDriveSource)(nil),
		(*RagFile_DirectUploadSource)(nil),
		(*RagFile_SlackSource)(nil),
		(*RagFile_JiraSource)(nil),
		(*RagFile_SharePointSources)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[7].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[8].OneofWrappers = []any{
		(*RagFileChunkingConfig_FixedLengthChunking_)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[10].OneofWrappers = []any{
		(*RagFileParsingConfig_AdvancedParser_)(nil),
		(*RagFileParsingConfig_LayoutParser_)(nil),
		(*RagFileParsingConfig_LlmParser_)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[11].OneofWrappers = []any{
		(*RagFileMetadataConfig_GcsMetadataSchemaSource)(nil),
		(*RagFileMetadataConfig_GoogleDriveMetadataSchemaSource)(nil),
		(*RagFileMetadataConfig_InlineMetadataSchemaSource)(nil),
		(*RagFileMetadataConfig_GcsMetadataSource)(nil),
		(*RagFileMetadataConfig_GoogleDriveMetadataSource)(nil),
		(*RagFileMetadataConfig_InlineMetadataSource)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[13].OneofWrappers = []any{
		(*ImportRagFilesConfig_GcsSource)(nil),
		(*ImportRagFilesConfig_GoogleDriveSource)(nil),
		(*ImportRagFilesConfig_SlackSource)(nil),
		(*ImportRagFilesConfig_JiraSource)(nil),
		(*ImportRagFilesConfig_SharePointSources)(nil),
		(*ImportRagFilesConfig_PartialFailureGcsSink)(nil),
		(*ImportRagFilesConfig_PartialFailureBigquerySink)(nil),
		(*ImportRagFilesConfig_ImportResultGcsSink)(nil),
		(*ImportRagFilesConfig_ImportResultBigquerySink)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[14].OneofWrappers = []any{
		(*RagManagedDbConfig_Enterprise_)(nil),
		(*RagManagedDbConfig_Scaled_)(nil),
		(*RagManagedDbConfig_Basic_)(nil),
		(*RagManagedDbConfig_Unprovisioned_)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[17].OneofWrappers = []any{
		(*RagEmbeddingModelConfig_SparseEmbeddingConfig_Bm25_)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[19].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[20].OneofWrappers = []any{
		(*RagVectorDbConfig_RagManagedDb_Knn)(nil),
		(*RagVectorDbConfig_RagManagedDb_Ann)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes[27].OneofWrappers = []any{
		(*RagCorpus_CorpusTypeConfig_DocumentCorpus_)(nil),
		(*RagCorpus_CorpusTypeConfig_MemoryCorpus_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   39,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto = out.File
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_depIdxs = nil
}
