// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// SetGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Also passes any
// provided key-value pairs. Intended for use by Google-written clients.
//
// Internal use only.

package aiplatform

func (c *DatasetClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *DeploymentResourcePoolClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *EndpointClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *EvaluationClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *ExtensionExecutionClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *ExtensionRegistryClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *FeatureOnlineStoreAdminClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *FeatureOnlineStoreClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *FeatureRegistryClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *FeaturestoreClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *FeaturestoreOnlineServingClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *GenAiCacheClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *GenAiTuningClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *IndexClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *IndexEndpointClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *JobClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *LlmUtilityClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *MatchClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *MetadataClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *MigrationClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *ModelClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *ModelGardenClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *ModelMonitoringClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *NotebookClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *PersistentResourceClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *PipelineClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *PredictionClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *ReasoningEngineClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *ReasoningEngineExecutionClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *ScheduleClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *SpecialistPoolClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *TensorboardClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *VertexRagClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *VertexRagDataClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}

func (c *VizierClient) SetGoogleClientInfo(keyval ...string) {
	c.setGoogleClientInfo(keyval...)
}
