// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Describes the historical SQL Server High Availability states for Amazon EC2
// instances that are enabled for Amazon EC2 High Availability for SQL Server
// monitoring.
func (c *Client) DescribeInstanceSqlHaHistoryStates(ctx context.Context, params *DescribeInstanceSqlHaHistoryStatesInput, optFns ...func(*Options)) (*DescribeInstanceSqlHaHistoryStatesOutput, error) {
	if params == nil {
		params = &DescribeInstanceSqlHaHistoryStatesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeInstanceSqlHaHistoryStates", params, optFns, c.addOperationDescribeInstanceSqlHaHistoryStatesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeInstanceSqlHaHistoryStatesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeInstanceSqlHaHistoryStatesInput struct {

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// The end data and time of the period for which to get historical SQL Server High
	// Availability states. If omitted, the API returns historical states up to the
	// current date and time.
	//
	// Timezone: UTC
	//
	// Format: YYYY-MM-DDThh:mm:ss.sssZ
	EndTime *time.Time

	// One or more filters to apply to the results. Supported filters include:
	//
	//   - tag: - The tag key and value pair assigned to the instance. For example, to
	//   find all instances tagged with Owner:TeamA , specify tag:Owner for the filter
	//   name and TeamA for the filter value.
	//
	//   - tag-key - The tag key assigned to the instance.
	//
	//   - haStatus - The SQL Server High Availability status of the SQL Server High
	//   Availability instance ( processing | active | standby | invalid ).
	//
	//   - sqlServerLicenseUsage - The license type for the SQL Server license ( full |
	//   waived ).
	Filters []types.Filter

	// The IDs of the SQL Server High Availability instances to describe. If omitted,
	// the API returns historical states for all SQL Server High Availability
	// instances.
	InstanceIds []string

	// The maximum number of results to return for the request in a single page. The
	// remaining results can be seen by sending another request with the returned
	// nextToken value.
	MaxResults *int32

	// The token to use to retrieve the next page of results.
	NextToken *string

	// The start data and time of the period for which to get the historical SQL
	// Server High Availability states. If omitted, the API returns all available
	// historical states.
	//
	// Timezone: UTC
	//
	// Format: YYYY-MM-DDThh:mm:ss.sssZ
	StartTime *time.Time

	noSmithyDocumentSerde
}

type DescribeInstanceSqlHaHistoryStatesOutput struct {

	// Information about the historical SQL Server High Availability states of the SQL
	// Server High Availability instances.
	Instances []types.RegisteredInstance

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeInstanceSqlHaHistoryStatesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeInstanceSqlHaHistoryStates{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeInstanceSqlHaHistoryStates{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeInstanceSqlHaHistoryStates"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeInstanceSqlHaHistoryStates(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeInstanceSqlHaHistoryStates(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeInstanceSqlHaHistoryStates",
	}
}
