/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.military;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.server.ai.AIColony;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.EuropeanAIPlayer;
import net.sf.freecol.server.ai.military.DefensiveMap;
import net.sf.freecol.server.ai.military.DefensiveZone;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.EscortUnitMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;
import net.sf.freecol.server.ai.mission.UnitWanderHostileMission;

public final class MilitaryCoordinator {
    private final EuropeanAIPlayer player;
    private final Set<AIUnit> unusedUnits;
    private final List<AIColony> ourColonies;
    private final Map<AIColony, List<AIUnit>> defenders;
    private final DefensiveMap defensiveMap;
    private final Set<Unit> targetedEnemies = Collections.newSetFromMap(new IdentityHashMap());
    private final Map<Settlement, List<AIUnit>> targetedEnemySettlements = new HashMap<Settlement, List<AIUnit>>();
    private final Map<String, Integer> turnsToReachCache = new HashMap<String, Integer>();

    public MilitaryCoordinator(EuropeanAIPlayer player, Set<AIUnit> militaryUnits) {
        assert (player != null);
        assert (militaryUnits.stream().noneMatch(au -> au.getOwner() != player.getPlayer()));
        this.player = player;
        this.unusedUnits = MilitaryCoordinator.identitySet(militaryUnits.stream().filter(u -> !u.getUnit().isInEurope() || !u.hasMission()).collect(Collectors.toList()));
        this.ourColonies = this.getOurColoniesSortedByValue();
        this.defenders = new HashMap<AIColony, List<AIUnit>>();
        for (AIColony colony : this.ourColonies) {
            this.defenders.put(colony, new ArrayList());
        }
        this.defensiveMap = DefensiveMap.createDefensiveMap(player);
    }

    public void determineMissions() {
        Set<AIUnit> artilleryUnits = MilitaryCoordinator.identitySet(MilitaryCoordinator.onlyArtillery(this.unusedUnits));
        Set<AIUnit> dragoonUnits = MilitaryCoordinator.identitySet(MilitaryCoordinator.onlyDragoons(this.unusedUnits));
        Set<AIUnit> otherMilitaryUnits = MilitaryCoordinator.identitySet(MilitaryCoordinator.neitherArtilleryNorDragoons(this.unusedUnits));
        this.keepUnitsInColonies(this.defensiveMap.getAttackedColonies(), artilleryUnits, MilitaryCoordinator.always());
        this.keepUnitsInColonies(this.defensiveMap.getAttackedColonies(), dragoonUnits, MilitaryCoordinator.maxDefenders(1));
        if (this.player.isAggressive()) {
            List<AIColony> importantWaterColonies = this.defensiveMap.getColoniesExposedWater().stream().filter(ac -> ac.getColony().getUnitCount() > 3).collect(Collectors.toList());
            this.keepUnitsInColonies(importantWaterColonies, artilleryUnits, MilitaryCoordinator.maxArtilleries(1));
            this.placeUnitsInColonies(importantWaterColonies, artilleryUnits, MilitaryCoordinator.maxArtilleries(1));
            this.placeUnitsInColonies(this.defensiveMap.getAttackedColonies(), dragoonUnits, MilitaryCoordinator.maxDefenders(1));
            this.placeUnitsInColonies(this.defensiveMap.getAttackedColonies(), dragoonUnits, MilitaryCoordinator.maxDefenders(1));
            this.keepUnitsInColonies(this.defensiveMap.getThreatenedColonies(), dragoonUnits, MilitaryCoordinator.maxDefenders(1));
            this.placeUnitsInColonies(this.defensiveMap.getThreatenedColonies(), dragoonUnits, MilitaryCoordinator.maxDefenders(1));
            this.keepUnitsInColonies(this.defensiveMap.getColoniesExposedWater(), dragoonUnits, MilitaryCoordinator.maxDefenders(1));
            this.placeUnitsInColonies(this.defensiveMap.getColoniesExposedWater(), dragoonUnits, MilitaryCoordinator.maxDefenders(1));
            this.keepUnitsInColonies(this.defensiveMap.getColoniesExposedLand(), dragoonUnits, MilitaryCoordinator.maxDefenders(1));
            this.placeUnitsInColonies(this.defensiveMap.getColoniesExposedLand(), dragoonUnits, MilitaryCoordinator.maxDefenders(1));
            this.keepUnitsInColonies(this.ourColonies, otherMilitaryUnits, MilitaryCoordinator.always());
        } else {
            this.keepUnitsInColonies(this.ourColonies, artilleryUnits, MilitaryCoordinator.maxDefenders(1));
            this.placeUnitsInColonies(this.ourColonies, artilleryUnits, MilitaryCoordinator.maxDefenders(1));
            this.keepUnitsInColonies(this.ourColonies, dragoonUnits, MilitaryCoordinator.maxDefenders(1));
            this.placeUnitsInColonies(this.ourColonies, dragoonUnits, MilitaryCoordinator.maxDefenders(1));
            this.keepUnitsInColonies(this.ourColonies, otherMilitaryUnits, MilitaryCoordinator.always());
            this.keepUnitsInColonies(this.defensiveMap.getThreatenedColonies(), artilleryUnits, MilitaryCoordinator.maxArtilleries(3));
            this.keepUnitsInColonies(this.defensiveMap.getColoniesExposedWater(), artilleryUnits, MilitaryCoordinator.maxArtilleries(2));
            this.placeUnitsInColonies(this.defensiveMap.getThreatenedColonies(), artilleryUnits, MilitaryCoordinator.maxArtilleries(2));
        }
        this.counterattackEnemyValuableUnitsReachableInTurns(dragoonUnits, 0);
        this.counterattackEnemyValuableUnitsReachableInTurns(dragoonUnits, 1);
        this.counterattackAllEnemyUnitsReachableInTurns(dragoonUnits, 1);
        this.counterattackAllEnemyUnitsReachableInTurns(dragoonUnits, 2);
        this.attackEnemySettlements(artilleryUnits, dragoonUnits);
        this.keepUnitsInColonies(this.defensiveMap.getAttackedColonies(), dragoonUnits, MilitaryCoordinator.always());
        this.keepUnitsInColonies(this.defensiveMap.getThreatenedColonies(), artilleryUnits, MilitaryCoordinator.always());
        if (this.player.isAggressive()) {
            this.placeUnitsInColonies(this.defensiveMap.getColoniesExposedWater(), artilleryUnits, MilitaryCoordinator.maxArtilleries(1));
        }
        this.placeUnitsInColonies(this.defensiveMap.getColoniesExposedWater(), artilleryUnits, MilitaryCoordinator.maxArtilleries(2));
        this.keepUnitsInColonies(this.defensiveMap.getThreatenedColonies(), dragoonUnits, MilitaryCoordinator.always());
        this.keepUnitsInColonies(this.defensiveMap.getColoniesExposedLand(), artilleryUnits, MilitaryCoordinator.maxArtilleries(2));
        this.placeUnitsInColonies(this.defensiveMap.getColoniesExposedLand(), dragoonUnits, MilitaryCoordinator.maxDragoons(2));
        this.assignDefendClosestColony(this.unusedUnits);
        if (!this.ourColonies.isEmpty()) {
            this.transportMilitaryUnitsFromEurope(this.ourColonies.get(0), this.unusedUnits);
        }
        this.assignWanderHostile();
    }

    private void attackEnemySettlements(Set<AIUnit> artilleryUnits, Set<AIUnit> dragoonUnits) {
        for (AIUnit artillery : new HashSet<AIUnit>(artilleryUnits)) {
            Settlement possibleTarget;
            if (dragoonUnits.isEmpty() || artillery.getUnit().getTile() == null || (possibleTarget = (Settlement)UnitSeekAndDestroyMission.findMissionTarget(artillery, 10, true, !this.player.isLikesAttackingNatives())) == null) continue;
            List<AIUnit> settlementAttackers = this.targetedEnemySettlements.get(possibleTarget);
            if (settlementAttackers == null) {
                settlementAttackers = new ArrayList<AIUnit>();
                this.targetedEnemySettlements.put(possibleTarget, settlementAttackers);
            }
            if (settlementAttackers.size() > possibleTarget.getUnitCount()) continue;
            Tile escortTargetTile = artillery.getUnit().getTile();
            AIUnit escort = dragoonUnits.stream().sorted((a, b) -> Integer.compare(this.getTurnsToReach(a.getUnit(), escortTargetTile), this.getTurnsToReach(b.getUnit(), escortTargetTile))).findFirst().orElse(null);
            if (escort == null || this.getTurnsToReach(escort.getUnit(), escortTargetTile) > 8) continue;
            artillery.changeMission(new UnitSeekAndDestroyMission(artillery.getAIMain(), artillery, possibleTarget));
            artilleryUnits.remove(artillery);
            this.unusedUnits.remove(artillery);
            escort.changeMission(new EscortUnitMission(escort.getAIMain(), escort, artillery.getUnit()));
            dragoonUnits.remove(escort);
            this.unusedUnits.remove(escort);
            settlementAttackers.add(artillery);
        }
    }

    private int getTurnsToReach(Unit unit, Location location) {
        String key = unit.getId() + "," + location.getId();
        Integer cachedResult = this.turnsToReachCache.get(key);
        if (cachedResult != null) {
            return cachedResult;
        }
        int result = unit.getTurnsToReach(location);
        this.turnsToReachCache.put(key, result);
        return result;
    }

    private void counterattackEnemyValuableUnitsReachableInTurns(Set<AIUnit> dragoonUnits, int turns) {
        for (DefensiveZone defensiveZone : this.defensiveMap.getDefensiveZones()) {
            Set<Unit> unprotectedUnarmedSoldiers = MilitaryCoordinator.identitySet(MilitaryCoordinator.onlyUnprotectedUnarmedSoldierUnits(defensiveZone.getEnemies()));
            Set<Unit> enemyArtillery = MilitaryCoordinator.identitySet(MilitaryCoordinator.onlyArtilleryUnits(defensiveZone.getEnemies()));
            block1: for (Unit enemy : unprotectedUnarmedSoldiers) {
                for (AIUnit dragoon : new HashSet<AIUnit>(dragoonUnits)) {
                    PathNode path;
                    if (dragoon.getUnit().getTile() == null || dragoon.getUnit().getTile().getContiguity() != enemy.getTile().getContiguity() || (path = dragoon.getUnit().findPath(enemy.getTile())) == null || path.getTurns() > turns) continue;
                    dragoon.changeMission(new UnitSeekAndDestroyMission(dragoon.getAIMain(), dragoon, enemy));
                    this.unusedUnits.remove(dragoon);
                    dragoonUnits.remove(dragoon);
                    this.targetedEnemies.add(enemy);
                    continue block1;
                }
            }
            for (int i = 0; i < 2; ++i) {
                block4: for (Unit enemy : enemyArtillery) {
                    for (AIUnit dragoon : new HashSet<AIUnit>(dragoonUnits)) {
                        PathNode path;
                        if (dragoon.getUnit().getTile() == null || dragoon.getUnit().getTile().getContiguity() != enemy.getTile().getContiguity() || (path = dragoon.getUnit().findPath(enemy.getTile())) == null || path.getTurns() > turns) continue;
                        dragoon.changeMission(new UnitSeekAndDestroyMission(dragoon.getAIMain(), dragoon, enemy));
                        this.unusedUnits.remove(dragoon);
                        dragoonUnits.remove(dragoon);
                        this.targetedEnemies.add(enemy);
                        continue block4;
                    }
                }
            }
        }
    }

    private void counterattackAllEnemyUnitsReachableInTurns(Set<AIUnit> dragoonUnits, int turns) {
        for (DefensiveZone defensiveZone : this.defensiveMap.getDefensiveZones()) {
            block1: for (Unit enemy : defensiveZone.getEnemies()) {
                if (this.targetedEnemies.contains(enemy)) continue;
                for (AIUnit dragoon : new HashSet<AIUnit>(dragoonUnits)) {
                    PathNode path;
                    if (dragoon.getUnit().getTile() == null || dragoon.getUnit().getTile().getContiguity() != enemy.getTile().getContiguity() || (path = dragoon.getUnit().findPath(enemy.getTile())) == null || path.getTurns() > turns) continue;
                    dragoon.changeMission(new UnitSeekAndDestroyMission(dragoon.getAIMain(), dragoon, enemy));
                    this.unusedUnits.remove(dragoon);
                    dragoonUnits.remove(dragoon);
                    this.targetedEnemies.add(enemy);
                    continue block1;
                }
            }
        }
    }

    private void assignDefendClosestColony(Set<AIUnit> militaryUnits) {
        for (AIUnit unit : new HashSet<AIUnit>(this.unusedUnits)) {
            Mission mission = this.player.getDefendSettlementMission(unit, true, true);
            if (mission == null) continue;
            unit.changeMission(mission);
            this.unusedUnits.remove(unit);
        }
    }

    private void transportMilitaryUnitsFromEurope(AIColony destination, Set<AIUnit> militaryUnits) {
        for (AIUnit unit : new HashSet<AIUnit>(this.unusedUnits)) {
            if (unit.getUnit().getTile() != null) continue;
            unit.changeMission(new DefendSettlementMission(unit.getAIMain(), unit, destination.getColony()));
            this.unusedUnits.remove(unit);
        }
    }

    private void placeUnit(List<AIColony> aiColonies, Set<AIUnit> units, Function<List<AIUnit>, Boolean> checkIfDefenderShouldBeAdded, boolean onlySameTile) {
        for (AIColony colony : aiColonies) {
            if (!checkIfDefenderShouldBeAdded.apply(this.defenders.get(colony)).booleanValue()) continue;
            AIUnit unit = onlySameTile ? MilitaryCoordinator.findUnitInColony(colony, units) : this.findUnitClosestToColony(colony, units);
            if (unit == null) break;
            this.placeDefender(unit, colony);
            units.remove(unit);
        }
    }

    private void keepUnitsInColonies(List<AIColony> aiColonies, Set<AIUnit> units, Function<List<AIUnit>, Boolean> checkIfDefenderShouldBeAdded) {
        this.placeUnit(aiColonies, units, checkIfDefenderShouldBeAdded, true);
    }

    private void placeUnitsInColonies(List<AIColony> aiColonies, Set<AIUnit> units, Function<List<AIUnit>, Boolean> checkIfDefenderShouldBeAdded) {
        this.placeUnit(aiColonies, units, checkIfDefenderShouldBeAdded, false);
    }

    private void assignWanderHostile() {
        for (AIUnit unit : new HashSet<AIUnit>(this.unusedUnits)) {
            unit.changeMission(new UnitWanderHostileMission(unit.getAIMain(), unit));
            this.unusedUnits.remove(unit);
        }
        assert (this.unusedUnits.isEmpty());
    }

    private void placeDefender(AIUnit unit, AIColony colony) {
        unit.changeMission(new DefendSettlementMission(unit.getAIMain(), unit, colony.getColony()));
        List<AIUnit> units = this.defenders.get(colony);
        units.add(unit);
        this.unusedUnits.remove(unit);
    }

    private AIUnit findUnitClosestToColony(AIColony colony, Set<AIUnit> units) {
        for (AIUnit au : units) {
            if (!(au.getMission() instanceof DefendSettlementMission) || au.getMission().getTarget() != colony.getColony()) continue;
            return au;
        }
        return units.stream().sorted((a, b) -> Integer.compare(this.getTurnsToReach(a.getUnit(), colony.getColony().getTile()), this.getTurnsToReach(b.getUnit(), colony.getColony().getTile()))).findFirst().orElse(null);
    }

    private static AIUnit findUnitInColony(AIColony ac, Set<AIUnit> units) {
        return units.stream().filter(au -> au.getUnit().getTile() != null && au.getUnit().getTile().equals(ac.getColony().getTile())).findAny().orElse(null);
    }

    private static Set<AIUnit> onlyArtillery(Set<AIUnit> militaryUnits) {
        return militaryUnits.stream().filter(au -> MilitaryCoordinator.isArtillery(au.getUnit())).collect(Collectors.toSet());
    }

    private static Set<Unit> onlyArtilleryUnits(Set<Unit> militaryUnits) {
        return militaryUnits.stream().filter(u -> MilitaryCoordinator.isArtillery(u)).collect(Collectors.toSet());
    }

    private static boolean isArtillery(Unit unit) {
        return unit.hasAbility("model.ability.bombard");
    }

    private static Set<Unit> onlyUnprotectedUnarmedSoldierUnits(Set<Unit> militaryUnits) {
        return militaryUnits.stream().filter(u -> !u.isArmed() && u.getSortedMilitaryRoles().stream().anyMatch(r -> r.getExpertUnit() == u.getType())).filter(u -> militaryUnits.stream().noneMatch(guard -> guard.getTile() == u.getTile() && guard.isOffensiveUnit())).collect(Collectors.toSet());
    }

    private static Set<AIUnit> onlyDragoons(Set<AIUnit> militaryUnits) {
        return militaryUnits.stream().filter(au -> MilitaryCoordinator.isDragoon(au.getUnit())).collect(Collectors.toSet());
    }

    private static boolean isDragoon(Unit unit) {
        return unit.isMounted();
    }

    private static Set<AIUnit> neitherArtilleryNorDragoons(Set<AIUnit> militaryUnits) {
        return militaryUnits.stream().filter(au -> !au.getUnit().hasAbility("model.ability.bombard") && !au.getUnit().isMounted()).collect(Collectors.toSet());
    }

    private List<AIColony> getOurColoniesSortedByValue() {
        List<AIColony> ourColonies = this.player.getAIColonies();
        Collections.sort(ourColonies, (a, b) -> Integer.compare(b.getColony().getUnitCount(), a.getColony().getUnitCount()));
        return ourColonies;
    }

    private static <T> Set<T> identitySet(Collection<T> collection) {
        Set result = Collections.newSetFromMap(new IdentityHashMap());
        result.addAll(collection);
        return result;
    }

    private static Function<List<AIUnit>, Boolean> maxDefenders(int count) {
        return units -> units.size() < count;
    }

    private static Function<List<AIUnit>, Boolean> maxArtilleries(int count) {
        return units -> units.stream().filter(au -> MilitaryCoordinator.isArtillery(au.getUnit())).count() < (long)count;
    }

    private static Function<List<AIUnit>, Boolean> maxDragoons(int count) {
        return units -> units.stream().filter(au -> MilitaryCoordinator.isDragoon(au.getUnit())).count() < (long)count;
    }

    private static Function<List<AIUnit>, Boolean> always() {
        return units -> true;
    }

    public static Predicate<? super AIUnit> isUnitHandledByMilitaryCoordinator() {
        return u -> !u.getUnit().isNaval() && u.getUnit().isOffensiveUnit() && !u.getUnit().hasAbility("model.ability.speakWithChief");
    }
}

