## 0.35.0 (15 October 2024)

NOTES:

This release adds support for Terraform Stack and Deployment files. This provides intelligent completion for Terraform Stacks blocks and attributes in Stack and Deployment files, including suggesting only valid completions for variables in component and deployment blocks. Hover documentation for all Stack and Deploy blocks, with helpful type and usage information. Early Validation has been extended to produce diagnostics along with syntax validation for Stack and Deployment files. Reference support allows code navigation in and between Stack and Deploy files. This also provides formatting support for both Stack and Deploy files.

This release also adds support for Terraform Test and Mock files. This provides completion for blocks and attributes, hover documentation and formatting support.

ENHANCEMENTS:

* Add initial support for Terraform Stacks files and Deployment files. This provides block and attribute completion, hover, and diagnostics along with syntax validation for Terraform Stacks and Deployment files ([#1745](https://github.com/hashicorp/terraform-ls/issues/1745))
* Parse and load Stack and Deploy metadata ([#1761](https://github.com/hashicorp/terraform-ls/issues/1761))
* Load Stack component sources from metadata ([#1768](https://github.com/hashicorp/terraform-ls/issues/1768))
* Enable early validation for Terraform Stack files ([#1776](https://github.com/hashicorp/terraform-ls/issues/1776))
* Merge stack configuration schema with dynamic schema based on used components source and providers ([#1770](https://github.com/hashicorp/terraform-ls/issues/1770))
* Merge deployment configuration schema with dynamic schema based on available variables ([#1780](https://github.com/hashicorp/terraform-ls/issues/1780))
* Support Terraform functions in stack files ([#1781](https://github.com/hashicorp/terraform-ls/issues/1781))
* Add DecodeReferenceOrigins and DecodeReferenceTargets jobs ([#1786](https://github.com/hashicorp/terraform-ls/issues/1786))
* Enable component references ([terraform-schema#386](https://github.com/hashicorp/terraform-schema/issues/386))
* Support references for identity tokens and their attributes ([terraform-schema#388](https://github.com/hashicorp/terraform-schema/issues/388))
* Enable references for variables in deployment inputs (Deploy) ([terraform-schema#389](https://github.com/hashicorp/terraform-schema/issues/389))
* Enable component references ([terraform-schema#386](https://github.com/hashicorp/terraform-schema/issues/386))
* Enable ephemeral values for variable ([terraform-schema#387](https://github.com/hashicorp/terraform-schema/issues/387))
* Enable output references ([terraform-schema#384](https://github.com/hashicorp/terraform-schema/issues/384))
* Enable provider references ([terraform-schema#385](https://github.com/hashicorp/terraform-schema/issues/385))
* Add Address to variable block schema for stacks to enable references ([terraform-schema#383](https://github.com/hashicorp/terraform-schema/issues/383))
* Add deployments store block schema ([terraform-schema#382](https://github.com/hashicorp/terraform-schema/issues/382))
* Add input block schema and deprecate variable block ([terraform-schema#381](https://github.com/hashicorp/terraform-schema/issues/381))
* Validate Stack and Deployment files for unreferenced origins ([#1797](https://github.com/hashicorp/terraform-ls/issues/1797))
* Early decode deployment config to support references to store blocks ([terraform-schema#390](https://github.com/hashicorp/terraform-schema/issues/390))
* Support a subset of functions in deployment configurations ([#1799](https://github.com/hashicorp/terraform-ls/issues/1799))
* Support description attribute for orchestration rule block ([terraform-schema#393](https://github.com/hashicorp/terraform-schema/issues/393))
* Support locals in stack and deploy configs ([terraform-schema#395](https://github.com/hashicorp/terraform-schema/issues/395))
* Support depends_on attribute in component blocks ([terraform-schema#392](https://github.com/hashicorp/terraform-schema/issues/392))
* Support provider defined functions in stacks configuration ([#1804](https://github.com/hashicorp/terraform-ls/issues/1804))
* Support description attribute for orchestration rule block ([terraform-schema#393](https://github.com/hashicorp/terraform-schema/issues/393))
* Support locals in stack and deploy configs ([terraform-schema#395](https://github.com/hashicorp/terraform-schema/issues/395))
* Support depends_on attribute in component blocks ([terraform-schema#392](https://github.com/hashicorp/terraform-schema/issues/392))
* Document Terraform Stacks support ([#1802](https://github.com/hashicorp/terraform-ls/issues/1802))
* Support context references within orchestrate blocks in deployment configuration ([#1813](https://github.com/hashicorp/terraform-ls/issues/1813))
* Static schema support for Terraform Test and Mock files ([#1782](https://github.com/hashicorp/terraform-ls/issues/1782))

BUG FIXES:

* Fix typo in USAGE.md ([#1835](https://github.com/hashicorp/terraform-ls/issues/1835))
* Fix panic on blocks with no labels during validation of label name ([#1791](https://github.com/hashicorp/terraform-ls/issues/1791))
* Fix type for provider references in component blocks ([terraform-schema#391](https://github.com/hashicorp/terraform-schema/issues/391))
* Fix type for provider references in component blocks ([terraform-schema#391](https://github.com/hashicorp/terraform-schema/issues/391))
* Support sensitive attribute for stacks variables ([terraform-schema#401](https://github.com/hashicorp/terraform-schema/issues/401))
* Allow any type as inputs to components per default ([terraform-schema#400](https://github.com/hashicorp/terraform-schema/issues/400))

INTERNAL:

* Load embedded provider schemas for providers found in stacks files into state ([#1763](https://github.com/hashicorp/terraform-ls/issues/1763))
* Add artifacts manifest ([#1784](https://github.com/hashicorp/terraform-ls/issues/1784))
* Add Stacks Terraform version to telemetry ([#1828](https://github.com/hashicorp/terraform-ls/issues/1828))
