/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage.multipartupload.model;

import com.google.api.core.BetaApi;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

@BetaApi
public final class UploadPartRequest {
    private final String bucket;
    private final String key;
    private final int partNumber;
    private final String uploadId;
    private final @Nullable String crc32c;
    private final String userProject;

    private UploadPartRequest(Builder builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.partNumber = builder.partNumber;
        this.uploadId = builder.uploadId;
        this.crc32c = builder.crc32c;
        this.userProject = builder.userProject;
    }

    @BetaApi
    public String bucket() {
        return this.bucket;
    }

    @BetaApi
    public String key() {
        return this.key;
    }

    @BetaApi
    public int partNumber() {
        return this.partNumber;
    }

    @BetaApi
    public String uploadId() {
        return this.uploadId;
    }

    @BetaApi
    public @Nullable String crc32c() {
        return this.crc32c;
    }

    @BetaApi
    public String userProject() {
        return this.userProject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UploadPartRequest)) {
            return false;
        }
        UploadPartRequest that = (UploadPartRequest)o;
        return this.partNumber == that.partNumber && Objects.equals(this.bucket, that.bucket) && Objects.equals(this.key, that.key) && Objects.equals(this.uploadId, that.uploadId) && Objects.equals(this.crc32c, that.crc32c) && Objects.equals(this.userProject, that.userProject);
    }

    public int hashCode() {
        return Objects.hash(this.bucket, this.key, this.partNumber, this.uploadId, this.crc32c, this.userProject);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bucket", (Object)this.bucket).add("key", (Object)this.key).add("partNumber", this.partNumber).add("uploadId", (Object)this.uploadId).add("crc32c", (Object)this.crc32c).add("userProject", (Object)this.userProject).toString();
    }

    @BetaApi
    public static Builder builder() {
        return new Builder();
    }

    @BetaApi
    public static class Builder {
        private String bucket;
        private String key;
        private int partNumber;
        private String uploadId;
        private @Nullable String crc32c;
        private String userProject;

        private Builder() {
        }

        @BetaApi
        public Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @BetaApi
        public Builder key(String key) {
            this.key = key;
            return this;
        }

        @BetaApi
        public Builder partNumber(int partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        @BetaApi
        public Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        @BetaApi
        public Builder crc32c(@Nullable String crc32c) {
            this.crc32c = crc32c;
            return this;
        }

        @BetaApi
        public Builder userProject(String userProject) {
            this.userProject = userProject;
            return this;
        }

        @BetaApi
        public UploadPartRequest build() {
            return new UploadPartRequest(this);
        }
    }
}

