/*
 * Decompiled with CFR 0.152.
 */
package liquibase.analytics;

import java.io.File;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import liquibase.Scope;
import liquibase.analytics.AnalyticsTrackEvent;
import liquibase.analytics.configuration.AnalyticsArgs;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemProperties;
import org.apache.commons.lang3.SystemUtils;

public class AnonymousSeed {
    private String username = SystemProperties.getUserName();
    private String macAddresses;
    private String machineId;

    public AnonymousSeed() {
        try {
            if (SystemUtils.IS_OS_LINUX) {
                this.machineId = FileUtils.readFileToString((File)new File("/etc/machine-id"));
            }
        }
        catch (Exception e) {
            Scope.getCurrentScope().getLog(AnalyticsTrackEvent.class).log(AnalyticsArgs.LOG_LEVEL.getCurrentValue(), "Failed to determine /etc/machine-id when calculating user ID", e);
        }
        try {
            if (StringUtils.isEmpty((CharSequence)this.machineId)) {
                this.macAddresses = AnonymousSeed.getMacAddresses();
            }
        }
        catch (Exception e) {
            Scope.getCurrentScope().getLog(AnalyticsTrackEvent.class).log(AnalyticsArgs.LOG_LEVEL.getCurrentValue(), "Failed to determine mac addresses when calculating user ID", e);
        }
    }

    private static String getMacAddresses() throws SocketException {
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        ArrayList<String> macAddresses = new ArrayList<String>();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface network = networkInterfaces.nextElement();
            byte[] macArray = network.getHardwareAddress();
            if (!ArrayUtils.isNotEmpty((byte[])macArray)) continue;
            macAddresses.add(StringUtils.toEncodedString((byte[])macArray, (Charset)StandardCharsets.UTF_8));
        }
        Collections.sort(macAddresses);
        return StringUtils.join((Object[])new List[]{macAddresses});
    }

    public String generateId() {
        if (StringUtils.isEmpty((CharSequence)this.machineId) && StringUtils.isEmpty((CharSequence)this.macAddresses)) {
            return "random-" + String.valueOf(UUID.randomUUID());
        }
        return String.valueOf(UUID.nameUUIDFromBytes(StringUtils.join((Object[])new String[]{this.username, this.macAddresses, this.machineId}).getBytes()));
    }
}

