/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.pipeline.stages;

import com.google.cloud.firestore.PipelineUtils;
import com.google.cloud.firestore.pipeline.expressions.Expression;
import com.google.cloud.firestore.pipeline.expressions.Field;
import com.google.cloud.firestore.pipeline.expressions.FunctionUtils;
import com.google.cloud.firestore.pipeline.stages.InternalOptions;
import com.google.cloud.firestore.pipeline.stages.RawOptions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.firestore.v1.Value;
import java.util.Arrays;
import java.util.List;

abstract class AbstractOptions<T> {
    protected final InternalOptions options;

    AbstractOptions(InternalOptions options) {
        this.options = options;
    }

    abstract T self(InternalOptions var1);

    public final T with(String key, String value) {
        return this.with(key, PipelineUtils.encodeValue(value));
    }

    public final T with(String key, boolean value) {
        return this.with(key, PipelineUtils.encodeValue(value));
    }

    public final T with(String key, long value) {
        return this.with(key, PipelineUtils.encodeValue(value));
    }

    public final T with(String key, double value) {
        return this.with(key, PipelineUtils.encodeValue(value));
    }

    public final T with(String key, Field value) {
        return this.with(key, value.toProto());
    }

    protected final T with(String key, Value value) {
        return this.self(this.options.with(key, value));
    }

    protected final T with(String key, String[] values) {
        return this.self(this.options.with(key, Arrays.stream(values).map(PipelineUtils::encodeValue)::iterator));
    }

    protected final T with(String key, List<? extends Expression> expressions) {
        return this.self(this.options.with(key, Lists.transform(expressions, FunctionUtils::exprToValue)));
    }

    protected final T with(String key, AbstractOptions<?> subSection) {
        return this.self(this.options.with(key, subSection.options));
    }

    protected final T adding(AbstractOptions<?> subSection) {
        return this.self(this.options.adding(subSection));
    }

    public final T withSection(String key, RawOptions subSection) {
        return this.with(key, subSection);
    }

    final ImmutableMap<String, Value> toMap() {
        return this.options.options;
    }
}

