/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.forward;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringSerializer;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.forward.PositionData;
import org.traccar.forward.PositionForwarder;
import org.traccar.forward.ResultHandler;

public class PositionForwarderKafka
implements PositionForwarder {
    private final Producer<String, String> producer;
    private final ObjectMapper objectMapper;
    private final String topic;

    public PositionForwarderKafka(Config config, ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        Properties properties = new Properties();
        properties.put("bootstrap.servers", config.getString(Keys.FORWARD_URL));
        properties.put("acks", "all");
        properties.put("key.serializer", StringSerializer.class.getName());
        properties.put("value.serializer", StringSerializer.class.getName());
        this.producer = new KafkaProducer(properties);
        this.topic = config.getString(Keys.FORWARD_TOPIC);
    }

    @Override
    public void forward(PositionData positionData, ResultHandler resultHandler) {
        try {
            String key = Long.toString(positionData.getDevice().getId());
            String value = this.objectMapper.writeValueAsString((Object)positionData);
            this.producer.send(new ProducerRecord(this.topic, (Object)key, (Object)value));
            resultHandler.onResult(true, null);
        }
        catch (JsonProcessingException e) {
            resultHandler.onResult(false, e);
        }
    }
}

