/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import jakarta.inject.Inject;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.NetworkMessage;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.helper.BufferUtil;
import org.traccar.helper.NetworkUtil;
import org.traccar.model.LogRecord;
import org.traccar.session.ConnectionManager;

public class StandardLoggingHandler
extends ChannelDuplexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardLoggingHandler.class);
    private final String protocol;
    private ConnectionManager connectionManager;
    private boolean decodeTextData;

    public StandardLoggingHandler(String protocol) {
        this.protocol = protocol;
    }

    @Inject
    public void setConfig(Config config) {
        this.decodeTextData = config.getBoolean(Keys.LOGGER_TEXT_PROTOCOL);
    }

    @Inject
    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        LogRecord record = this.createLogRecord(ctx, msg);
        this.log(ctx, false, record);
        super.channelRead(ctx, msg);
        if (record != null) {
            this.connectionManager.updateLog(record);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        this.log(ctx, true, this.createLogRecord(ctx, msg));
        super.write(ctx, msg, promise);
    }

    private LogRecord createLogRecord(ChannelHandlerContext ctx, Object msg) {
        NetworkMessage networkMessage;
        Object object;
        if (msg instanceof NetworkMessage && (object = (networkMessage = (NetworkMessage)msg).getMessage()) instanceof ByteBuf) {
            ByteBuf data = (ByteBuf)object;
            LogRecord record = new LogRecord(ctx.channel().localAddress(), networkMessage.getRemoteAddress());
            record.setProtocol(this.protocol);
            if (this.decodeTextData && BufferUtil.isPrintable(data, data.readableBytes())) {
                record.setData(data.getCharSequence(data.readerIndex(), data.readableBytes(), StandardCharsets.US_ASCII).toString().replace("\r", "\\r").replace("\n", "\\n"));
            } else {
                record.setData(ByteBufUtil.hexDump((ByteBuf)data));
            }
            return record;
        }
        return null;
    }

    private void log(ChannelHandlerContext ctx, boolean downstream, LogRecord record) {
        if (record != null) {
            StringBuilder message = new StringBuilder();
            message.append("[").append(NetworkUtil.session(ctx.channel())).append(": ");
            message.append(this.protocol);
            message.append(downstream ? " > " : " < ");
            message.append(record.getAddress().getHostString());
            message.append("] ");
            message.append(record.getData());
            LOGGER.info(message.toString());
        }
    }
}

