/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.helper;

import io.netty.handler.codec.http.HttpHeaderNames;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Date;
import org.traccar.helper.LogAction;
import org.traccar.model.User;

public final class SessionHelper {
    public static final String USER_ID_KEY = "userId";
    public static final String EXPIRATION_KEY = "expiration";
    public static final String ORIGIN_KEY = "origin";

    private SessionHelper() {
    }

    public static void userLogin(LogAction actionLogger, HttpServletRequest request, User user, Date expiration) {
        String origin;
        request.getSession().invalidate();
        request.getSession().setAttribute(USER_ID_KEY, (Object)user.getId());
        if (expiration != null) {
            request.getSession().setAttribute(EXPIRATION_KEY, (Object)expiration);
        }
        if ((origin = request.getHeader(HttpHeaderNames.ORIGIN.toString())) != null) {
            request.getSession().setAttribute(ORIGIN_KEY, (Object)origin);
        }
        actionLogger.login(request, user.getId());
    }

    public static boolean isSessionOriginValid(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return false;
        }
        String sessionOrigin = (String)session.getAttribute(ORIGIN_KEY);
        if (sessionOrigin == null) {
            return true;
        }
        String requestOrigin = request.getHeader(HttpHeaderNames.ORIGIN.toString());
        return requestOrigin == null || sessionOrigin.equals(requestOrigin);
    }
}

