/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.json.Json;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseHttpProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.DateUtil;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class TtnHttpProtocolDecoder
extends BaseHttpProtocolDecoder {
    public TtnHttpProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        String contentType = request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        if (contentType == null || !contentType.startsWith(HttpHeaderValues.APPLICATION_JSON.toString())) {
            this.sendResponse(channel, HttpResponseStatus.BAD_REQUEST);
            return null;
        }
        String content = request.content().toString(StandardCharsets.UTF_8);
        JsonObject root = Json.createReader((Reader)new StringReader(content)).readObject();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, root.getJsonObject("end_device_ids").getString("device_id"));
        if (deviceSession == null) {
            this.sendResponse(channel, HttpResponseStatus.NOT_FOUND);
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        JsonObject message = root.getJsonObject("uplink_message");
        if (message == null) {
            this.sendResponse(channel, HttpResponseStatus.BAD_REQUEST);
            return null;
        }
        JsonObject payload = message.getJsonObject("decoded_payload");
        if (payload == null) {
            this.sendResponse(channel, HttpResponseStatus.OK);
            return null;
        }
        if (message.getJsonArray("rx_metadata").getJsonObject(0).containsKey((Object)"time")) {
            position.setTime(DateUtil.parseDate(message.getJsonArray("rx_metadata").getJsonObject(0).getString("time")));
        } else {
            position.setTime(DateUtil.parseDate(message.getString("received_at")));
        }
        boolean hasLocation = false;
        block18: for (String key : payload.keySet()) {
            if (key.startsWith("gps_")) {
                JsonObject location = payload.getJsonObject(key);
                if (location.getValueType() != JsonValue.ValueType.OBJECT) continue;
                position.setLatitude(location.getJsonNumber("latitude").doubleValue());
                position.setLongitude(location.getJsonNumber("longitude").doubleValue());
                position.setAltitude(location.getJsonNumber("altitude").doubleValue());
                hasLocation = true;
                continue;
            }
            switch (key) {
                case "latitude": {
                    position.setLatitude(payload.getJsonNumber(key).doubleValue());
                    hasLocation = true;
                    continue block18;
                }
                case "longitude": {
                    position.setLongitude(payload.getJsonNumber(key).doubleValue());
                    hasLocation = true;
                    continue block18;
                }
                case "altitude": {
                    position.setAltitude(payload.getJsonNumber(key).doubleValue());
                    continue block18;
                }
                case "accuracy": {
                    position.setAccuracy(payload.getJsonNumber(key).doubleValue());
                    continue block18;
                }
                case "sats": {
                    position.set("sat", payload.getJsonNumber(key).intValue());
                    continue block18;
                }
                case "speed": {
                    position.setSpeed(this.convertSpeed(payload.getJsonNumber(key).doubleValue(), "kn"));
                    continue block18;
                }
                case "heading": {
                    position.setCourse(payload.getJsonNumber(key).doubleValue());
                    continue block18;
                }
            }
            this.decodeJsonValue(position, key, (JsonValue)payload.get((Object)key));
        }
        if (hasLocation) {
            position.setValid(true);
        } else {
            this.getLastLocation(position, null);
        }
        this.sendResponse(channel, HttpResponseStatus.OK);
        return position;
    }

    private void decodeJsonValue(Position position, String key, JsonValue value) {
        switch (value.getValueType()) {
            case STRING: {
                position.set(key, ((JsonString)value).getString());
                break;
            }
            case NUMBER: {
                position.set(key, ((JsonNumber)value).doubleValue());
                break;
            }
            case TRUE: {
                position.set(key, true);
                break;
            }
            case FALSE: {
                position.set(key, false);
                break;
            }
        }
    }
}

