/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoException;
import com.mongodb.internal.async.AsyncBatchCursor;
import com.mongodb.internal.async.SingleResultCallback;
import java.util.Collections;
import java.util.List;

class AsyncSingleBatchCursor<T>
implements AsyncBatchCursor<T> {
    private final List<T> batch;
    private final int batchSize;
    private volatile boolean hasNext = true;
    private volatile boolean closed = false;

    static <R> AsyncSingleBatchCursor<R> createEmptyAsyncSingleBatchCursor(int batchSize) {
        return new AsyncSingleBatchCursor(Collections.emptyList(), batchSize);
    }

    AsyncSingleBatchCursor(List<T> batch, int batchSize) {
        this.batch = batch;
        this.batchSize = batchSize;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void next(SingleResultCallback<List<T>> callback) {
        if (this.closed) {
            callback.onResult(null, new MongoException("next() called after the cursor was closed."));
        } else if (this.hasNext && !this.batch.isEmpty()) {
            this.hasNext = false;
            callback.onResult(this.batch, null);
        } else {
            this.closed = true;
            callback.onResult(Collections.emptyList(), null);
        }
    }

    @Override
    public void setBatchSize(int batchSize) {
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

