/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.jgrapht.Graph;
import org.jgrapht.WeightedGraph;
import org.jgrapht.ext.EdgeProvider;
import org.jgrapht.ext.GmlBaseListener;
import org.jgrapht.ext.GmlLexer;
import org.jgrapht.ext.GmlParser;
import org.jgrapht.ext.GraphImporter;
import org.jgrapht.ext.ImportException;
import org.jgrapht.ext.VertexProvider;

public class GmlImporter<V, E>
implements GraphImporter<V, E> {
    private VertexProvider<V> vertexProvider;
    private EdgeProvider<V, E> edgeProvider;

    public GmlImporter(VertexProvider<V> vertexProvider, EdgeProvider<V, E> edgeProvider) {
        if (vertexProvider == null) {
            throw new IllegalArgumentException("Vertex provider cannot be null");
        }
        this.vertexProvider = vertexProvider;
        if (edgeProvider == null) {
            throw new IllegalArgumentException("Edge provider cannot be null");
        }
        this.edgeProvider = edgeProvider;
    }

    public VertexProvider<V> getVertexProvider() {
        return this.vertexProvider;
    }

    public void setVertexProvider(VertexProvider<V> vertexProvider) {
        if (vertexProvider == null) {
            throw new IllegalArgumentException("Vertex provider cannot be null");
        }
        this.vertexProvider = vertexProvider;
    }

    public EdgeProvider<V, E> getEdgeProvider() {
        return this.edgeProvider;
    }

    public void setEdgeProvider(EdgeProvider<V, E> edgeProvider) {
        if (edgeProvider == null) {
            throw new IllegalArgumentException("Edge provider cannot be null");
        }
        this.edgeProvider = edgeProvider;
    }

    @Override
    public void importGraph(Graph<V, E> graph, Reader input) throws ImportException {
        try {
            ThrowingErrorListener errorListener = new ThrowingErrorListener();
            GmlLexer lexer = new GmlLexer((CharStream)new ANTLRInputStream(input));
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)errorListener);
            GmlParser parser = new GmlParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)errorListener);
            GmlParser.GmlContext graphContext = parser.gml();
            ParseTreeWalker walker = new ParseTreeWalker();
            CreateGraphGmlListener listener = new CreateGraphGmlListener();
            walker.walk((ParseTreeListener)listener, (ParseTree)graphContext);
            listener.updateGraph(graph);
        }
        catch (IOException e) {
            throw new ImportException("Failed to import gml graph: " + e.getMessage(), e);
        }
        catch (ParseCancellationException pe) {
            throw new ImportException("Failed to import gml graph: " + pe.getMessage(), pe);
        }
        catch (IllegalArgumentException iae) {
            throw new ImportException("Failed to import gml graph: " + iae.getMessage(), iae);
        }
    }

    private class PartialEdge {
        Integer source;
        Integer target;
        Double weight;

        public PartialEdge(Integer source, Integer target, Double weight) {
            this.source = source;
            this.target = target;
            this.weight = weight;
        }
    }

    private class CreateGraphGmlListener
    extends GmlBaseListener {
        private static final String NODE = "node";
        private static final String EDGE = "edge";
        private static final String GRAPH = "graph";
        private static final String WEIGHT = "weight";
        private static final String ID = "id";
        private static final String SOURCE = "source";
        private static final String TARGET = "target";
        private boolean foundGraph;
        private boolean insideGraph;
        private boolean insideNode;
        private boolean insideEdge;
        private int level;
        private Integer nodeId;
        private Integer sourceId;
        private Integer targetId;
        private Double weight;
        private Set<Integer> nodes;
        private int singletons;
        private List<PartialEdge> edges;

        private CreateGraphGmlListener() {
        }

        public void updateGraph(Graph<V, E> graph) throws ImportException {
            if (this.foundGraph) {
                int maxV = 1;
                HashMap map = new HashMap();
                for (Integer id : this.nodes) {
                    maxV = Math.max(maxV, id);
                    Object vertex = GmlImporter.this.vertexProvider.buildVertex(id.toString(), new HashMap<String, String>());
                    map.put(id, vertex);
                    graph.addVertex(vertex);
                }
                for (int i = 0; i < this.singletons; ++i) {
                    String label = String.valueOf(maxV + 1 + i);
                    graph.addVertex(GmlImporter.this.vertexProvider.buildVertex(label, new HashMap<String, String>()));
                }
                for (PartialEdge pe : this.edges) {
                    String label = "e_" + pe.source + "_" + pe.target;
                    Object from = map.get(pe.source);
                    if (from == null) {
                        throw new ImportException("Node " + pe.source + " does not exist");
                    }
                    Object to = map.get(pe.target);
                    if (to == null) {
                        throw new ImportException("Node " + pe.target + " does not exist");
                    }
                    Object e = GmlImporter.this.edgeProvider.buildEdge(from, to, label, new HashMap<String, String>());
                    graph.addEdge(from, to, e);
                    if (pe.weight == null || !(graph instanceof WeightedGraph)) continue;
                    ((WeightedGraph)graph).setEdgeWeight(e, pe.weight);
                }
            }
        }

        @Override
        public void enterGml(GmlParser.GmlContext ctx) {
            this.foundGraph = false;
            this.insideGraph = false;
            this.insideNode = false;
            this.insideEdge = false;
            this.nodes = new HashSet<Integer>();
            this.singletons = 0;
            this.edges = new ArrayList<PartialEdge>();
            this.level = 0;
        }

        @Override
        public void enterNumberKeyValue(GmlParser.NumberKeyValueContext ctx) {
            String key = ctx.ID().getText();
            if (this.insideNode && this.level == 2 && key.equals(ID)) {
                try {
                    this.nodeId = Integer.parseInt(ctx.NUMBER().getText());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (this.insideEdge && this.level == 2 && key.equals(SOURCE)) {
                try {
                    this.sourceId = Integer.parseInt(ctx.NUMBER().getText());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (this.insideEdge && this.level == 2 && key.equals(TARGET)) {
                try {
                    this.targetId = Integer.parseInt(ctx.NUMBER().getText());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (this.insideEdge && this.level == 2 && key.equals(WEIGHT)) {
                try {
                    this.weight = Double.parseDouble(ctx.NUMBER().getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void enterListKeyValue(GmlParser.ListKeyValueContext ctx) {
            String key = ctx.ID().getText();
            if (this.level == 0 && key.equals(GRAPH)) {
                this.foundGraph = true;
                this.insideGraph = true;
            } else if (this.level == 1 && this.insideGraph && key.equals(NODE)) {
                this.insideNode = true;
                this.nodeId = null;
            } else if (this.level == 1 && this.insideGraph && key.equals(EDGE)) {
                this.insideEdge = true;
                this.sourceId = null;
                this.targetId = null;
                this.weight = null;
            }
            ++this.level;
        }

        @Override
        public void exitListKeyValue(GmlParser.ListKeyValueContext ctx) {
            String key = ctx.ID().getText();
            --this.level;
            if (this.level == 0 && key.equals(GRAPH)) {
                this.insideGraph = false;
            } else if (this.level == 1 && this.insideGraph && key.equals(NODE)) {
                if (this.nodeId == null) {
                    ++this.singletons;
                } else {
                    this.nodes.add(this.nodeId);
                }
                this.insideNode = false;
            } else if (this.level == 1 && this.insideGraph && key.equals(EDGE)) {
                if (this.sourceId != null && this.targetId != null) {
                    this.edges.add(new PartialEdge(this.sourceId, this.targetId, this.weight));
                }
                this.insideEdge = false;
            }
        }
    }

    private class ThrowingErrorListener
    extends BaseErrorListener {
        private ThrowingErrorListener() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) throws ParseCancellationException {
            throw new ParseCancellationException("line " + line + ":" + charPositionInLine + " " + msg);
        }
    }
}

