/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer.impl.export;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import org.graalvm.visualvm.lib.profiler.snaptracer.TracerProgressObject;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.TracerSupportImpl;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.export.CSVExporter;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.export.ExportBatch;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.export.HTMLExporter;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.export.XMLExporter;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.swing.VerticalLayout;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.windows.WindowManager;

public final class DataExport {
    private static final Logger LOGGER = Logger.getLogger(DataExport.class.getName());
    private static final int INDETERMINATE_PROGRESS_THRESHOLD = Integer.getInteger("visualvm.tracer.indeterminateProgressThreshold", 2500);
    private static final Filter CSV_FILTER = Filter.create("CSV Files", ".csv");
    private static final Filter HTML_FILTER = Filter.create("HTML Files", ".html");
    private static final Filter XML_FILTER = Filter.create("XML Files", ".xml");
    private static JFileChooser fileChooser;
    private static File lastDirectory;
    private static Filter lastFilter;

    public static void exportData(final TableModel model, final String title) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFileChooser chooser = DataExport.getFileChooser();
                if (chooser.showSaveDialog((Component)WindowManager.getDefault().getRegistry().getActivated()) == 0) {
                    File file = chooser.getSelectedFile();
                    Filter filter = (Filter)chooser.getFileFilter();
                    DataExport.doExportData(model, title, file, filter);
                }
                lastDirectory = chooser.getCurrentDirectory();
                lastFilter = (Filter)chooser.getFileFilter();
            }
        });
    }

    private static void doExportData(final TableModel model, final String title, final File file, final Filter filter) {
        TracerSupportImpl.getInstance().perform(new Runnable(){

            @Override
            public void run() {
                TracerProgressObject progress = null;
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                    ExportBatch batch = null;
                    if (filter == XML_FILTER) {
                        batch = new XMLExporter().createBatch(model, title, writer);
                    } else if (filter == HTML_FILTER) {
                        batch = new HTMLExporter().createBatch(model, title, writer);
                    } else if (filter == CSV_FILTER) {
                        batch = new CSVExporter().createBatch(model, title, writer);
                    }
                    if (batch != null) {
                        final TracerProgressObject progressF = progress = batch.getProgress();
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                DataExport.showProgressDialog(progressF);
                            }
                        });
                        batch.getWorker().run();
                    }
                }
                catch (Throwable t) {
                    if (progress != null) {
                        progress.setText("Exporting data failed");
                        progress.finish();
                    }
                    LOGGER.log(Level.INFO, "Exporting data failed", t);
                }
            }
        });
    }

    private static void showProgressDialog(final TracerProgressObject progress) {
        final JLabel l = new JLabel();
        l.setBorder(BorderFactory.createEmptyBorder(0, 0, 7, 0));
        final JProgressBar p = new JProgressBar(0, progress.getSteps()){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = 300;
                d.height += 2;
                return d;
            }
        };
        p.setBorder(BorderFactory.createEmptyBorder());
        final Timer t = new Timer(INDETERMINATE_PROGRESS_THRESHOLD, null);
        t.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                p.setIndeterminate(true);
                t.stop();
            }
        });
        final JButton b = new JButton(){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                SwingUtilities.getWindowAncestor(this).setVisible(false);
            }
        };
        progress.addListener(new TracerProgressObject.Listener(){

            @Override
            public void progressChanged(int addedSteps, int currentStep, String text) {
                t.stop();
                p.setIndeterminate(false);
                p.setValue(currentStep);
                l.setText(text == null ? "" : text);
                if (!progress.isFinished()) {
                    t.start();
                } else {
                    b.setText("Close");
                }
            }
        });
        l.setText(progress.getText());
        p.setValue(progress.getCurrentStep());
        b.setText(progress.isFinished() ? "Close" : "Cancel");
        JPanel c = new JPanel(new VerticalLayout(false));
        c.setBorder(BorderFactory.createEmptyBorder(20, 10, 15, 10));
        c.add(l);
        c.add(p);
        final DialogDescriptor dd = new DialogDescriptor((Object)c, "Export Tracer Data", true, new Object[]{b}, (Object)b, 0, null, null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Dialog d = DialogDisplayer.getDefault().createDialog(dd);
                DataExport.openDialog(d);
                progress.finish();
            }
        });
    }

    private static JFileChooser getFileChooser() {
        if (fileChooser == null) {
            fileChooser = DataExport.createFileChooser();
        }
        if (lastDirectory != null) {
            fileChooser.setCurrentDirectory(lastDirectory);
        }
        if (lastFilter != null) {
            fileChooser.setFileFilter(lastFilter);
        }
        return fileChooser;
    }

    private static JFileChooser createFileChooser() {
        JFileChooser chooser = new JFileChooser(){

            @Override
            public void approveSelection() {
                File file = this.getSelectedFile();
                Filter filter = (Filter)this.getFileFilter();
                if (!file.getName().endsWith(filter.getExt())) {
                    file = new File(file.getPath() + filter.getExt());
                    this.setSelectedFile(file);
                }
                if (!file.isFile()) {
                    super.approveSelection();
                    return;
                }
                final boolean[] ret = new boolean[1];
                JButton yesB = new JButton("Yes"){

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        ret[0] = true;
                        super.fireActionPerformed(e);
                    }
                };
                DialogDescriptor desc = new DialogDescriptor((Object)("File \"" + file.getName() + "\" already exists.\nDo you want to replace it?"), "Replace Existing File", true, new Object[]{yesB, new JButton("No")}, (Object)yesB, 0, null, null);
                desc.setMessageType(3);
                Dialog d = DialogDisplayer.getDefault().createDialog(desc);
                DataExport.openDialog(d);
                if (ret[0]) {
                    super.approveSelection();
                }
            }
        };
        chooser.setDialogTitle("Export Tracer Data");
        chooser.setDialogType(1);
        chooser.setFileSelectionMode(0);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter(CSV_FILTER);
        chooser.addChoosableFileFilter(HTML_FILTER);
        chooser.addChoosableFileFilter(XML_FILTER);
        return chooser;
    }

    private static void openDialog(Dialog d) {
        if (d instanceof JDialog) {
            d.setLocationRelativeTo((Component)WindowManager.getDefault().getRegistry().getActivated());
        }
        d.setVisible(true);
    }

    private DataExport() {
    }

    static {
        lastFilter = CSV_FILTER;
    }

    private static abstract class Filter
    extends FileFilter {
        abstract String getExt();

        static Filter create(final String descr, final String ext) {
            return new Filter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || Filter.getFileExt(f.getName()).equals(ext);
                }

                @Override
                public String getExt() {
                    return ext;
                }

                @Override
                public String getDescription() {
                    return descr + " (*" + ext + ")";
                }
            };
        }

        private static String getFileExt(String fileName) {
            int extIndex = fileName.lastIndexOf(46);
            if (extIndex == -1) {
                return "";
            }
            return fileName.substring(extIndex);
        }

        private Filter() {
        }
    }
}

