//autogenerated:yes
//nolint:revive,misspell,govet,lll
package ardupilotmega

// Configure an OSD parameter slot.
type MessageOsdParamConfig struct {
	// System ID.
	TargetSystem uint8
	// Component ID.
	TargetComponent uint8
	// Request ID - copied to reply.
	RequestId uint32
	// OSD parameter screen index.
	OsdScreen uint8
	// OSD parameter display index.
	OsdIndex uint8
	// Onboard parameter id, terminated by NULL if the length is less than 16 human-readable chars and WITHOUT null termination (NULL) byte if the length is exactly 16 chars - applications have to provide 16+1 bytes storage if the ID is stored as string
	ParamId string `mavlen:"16"`
	// Config type.
	ConfigType OSD_PARAM_CONFIG_TYPE `mavenum:"uint8"`
	// OSD parameter minimum value.
	MinValue float32
	// OSD parameter maximum value.
	MaxValue float32
	// OSD parameter increment.
	Increment float32
}

// GetID implements the message.Message interface.
func (*MessageOsdParamConfig) GetID() uint32 {
	return 11033
}
