//autogenerated:yes
//nolint:revive,misspell,govet,lll
package development

// The location of a target measured by MAV's onboard sensors.
type MessageTargetRelative struct {
	// Timestamp (UNIX epoch time)
	Timestamp uint64
	// The ID of the target if multiple targets are present
	Id uint8
	// Coordinate frame used for following fields.
	Frame TARGET_OBS_FRAME `mavenum:"uint8"`
	// X Position of the target in TARGET_OBS_FRAME
	X float32
	// Y Position of the target in TARGET_OBS_FRAME
	Y float32
	// Z Position of the target in TARGET_OBS_FRAME
	Z float32
	// Standard deviation of the target's position in TARGET_OBS_FRAME
	PosStd [3]float32
	// Standard deviation of the target's orientation in TARGET_OBS_FRAME
	YawStd float32
	// Quaternion of the target's orientation from the target's frame to the TARGET_OBS_FRAME (w, x, y, z order, zero-rotation is 1, 0, 0, 0)
	QTarget [4]float32
	// Quaternion of the sensor's orientation from TARGET_OBS_FRAME to vehicle-carried NED. (Ignored if set to (0,0,0,0)) (w, x, y, z order, zero-rotation is 1, 0, 0, 0)
	QSensor [4]float32
	// Type of target
	Type LANDING_TARGET_TYPE `mavenum:"uint8"`
}

// GetID implements the message.Message interface.
func (*MessageTargetRelative) GetID() uint32 {
	return 511
}
