// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/ids/v1/ids.proto

package idspb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	IDS_ListEndpoints_FullMethodName  = "/google.cloud.ids.v1.IDS/ListEndpoints"
	IDS_GetEndpoint_FullMethodName    = "/google.cloud.ids.v1.IDS/GetEndpoint"
	IDS_CreateEndpoint_FullMethodName = "/google.cloud.ids.v1.IDS/CreateEndpoint"
	IDS_DeleteEndpoint_FullMethodName = "/google.cloud.ids.v1.IDS/DeleteEndpoint"
)

// IDSClient is the client API for IDS service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type IDSClient interface {
	// Lists Endpoints in a given project and location.
	ListEndpoints(ctx context.Context, in *ListEndpointsRequest, opts ...grpc.CallOption) (*ListEndpointsResponse, error)
	// Gets details of a single Endpoint.
	GetEndpoint(ctx context.Context, in *GetEndpointRequest, opts ...grpc.CallOption) (*Endpoint, error)
	// Creates a new Endpoint in a given project and location.
	CreateEndpoint(ctx context.Context, in *CreateEndpointRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Endpoint.
	DeleteEndpoint(ctx context.Context, in *DeleteEndpointRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type iDSClient struct {
	cc grpc.ClientConnInterface
}

func NewIDSClient(cc grpc.ClientConnInterface) IDSClient {
	return &iDSClient{cc}
}

func (c *iDSClient) ListEndpoints(ctx context.Context, in *ListEndpointsRequest, opts ...grpc.CallOption) (*ListEndpointsResponse, error) {
	out := new(ListEndpointsResponse)
	err := c.cc.Invoke(ctx, IDS_ListEndpoints_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iDSClient) GetEndpoint(ctx context.Context, in *GetEndpointRequest, opts ...grpc.CallOption) (*Endpoint, error) {
	out := new(Endpoint)
	err := c.cc.Invoke(ctx, IDS_GetEndpoint_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iDSClient) CreateEndpoint(ctx context.Context, in *CreateEndpointRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, IDS_CreateEndpoint_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iDSClient) DeleteEndpoint(ctx context.Context, in *DeleteEndpointRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, IDS_DeleteEndpoint_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IDSServer is the server API for IDS service.
// All implementations should embed UnimplementedIDSServer
// for forward compatibility
type IDSServer interface {
	// Lists Endpoints in a given project and location.
	ListEndpoints(context.Context, *ListEndpointsRequest) (*ListEndpointsResponse, error)
	// Gets details of a single Endpoint.
	GetEndpoint(context.Context, *GetEndpointRequest) (*Endpoint, error)
	// Creates a new Endpoint in a given project and location.
	CreateEndpoint(context.Context, *CreateEndpointRequest) (*longrunningpb.Operation, error)
	// Deletes a single Endpoint.
	DeleteEndpoint(context.Context, *DeleteEndpointRequest) (*longrunningpb.Operation, error)
}

// UnimplementedIDSServer should be embedded to have forward compatible implementations.
type UnimplementedIDSServer struct {
}

func (UnimplementedIDSServer) ListEndpoints(context.Context, *ListEndpointsRequest) (*ListEndpointsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEndpoints not implemented")
}
func (UnimplementedIDSServer) GetEndpoint(context.Context, *GetEndpointRequest) (*Endpoint, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEndpoint not implemented")
}
func (UnimplementedIDSServer) CreateEndpoint(context.Context, *CreateEndpointRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEndpoint not implemented")
}
func (UnimplementedIDSServer) DeleteEndpoint(context.Context, *DeleteEndpointRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEndpoint not implemented")
}

// UnsafeIDSServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to IDSServer will
// result in compilation errors.
type UnsafeIDSServer interface {
	mustEmbedUnimplementedIDSServer()
}

func RegisterIDSServer(s grpc.ServiceRegistrar, srv IDSServer) {
	s.RegisterService(&IDS_ServiceDesc, srv)
}

func _IDS_ListEndpoints_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEndpointsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IDSServer).ListEndpoints(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IDS_ListEndpoints_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IDSServer).ListEndpoints(ctx, req.(*ListEndpointsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IDS_GetEndpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEndpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IDSServer).GetEndpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IDS_GetEndpoint_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IDSServer).GetEndpoint(ctx, req.(*GetEndpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IDS_CreateEndpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEndpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IDSServer).CreateEndpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IDS_CreateEndpoint_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IDSServer).CreateEndpoint(ctx, req.(*CreateEndpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IDS_DeleteEndpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEndpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IDSServer).DeleteEndpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IDS_DeleteEndpoint_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IDSServer).DeleteEndpoint(ctx, req.(*DeleteEndpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// IDS_ServiceDesc is the grpc.ServiceDesc for IDS service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var IDS_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.ids.v1.IDS",
	HandlerType: (*IDSServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListEndpoints",
			Handler:    _IDS_ListEndpoints_Handler,
		},
		{
			MethodName: "GetEndpoint",
			Handler:    _IDS_GetEndpoint_Handler,
		},
		{
			MethodName: "CreateEndpoint",
			Handler:    _IDS_CreateEndpoint_Handler,
		},
		{
			MethodName: "DeleteEndpoint",
			Handler:    _IDS_DeleteEndpoint_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/ids/v1/ids.proto",
}
