// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/iam/credentials/v1/iamcredentials.proto

package credentialspb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	IAMCredentials_GenerateAccessToken_FullMethodName = "/google.iam.credentials.v1.IAMCredentials/GenerateAccessToken"
	IAMCredentials_GenerateIdToken_FullMethodName     = "/google.iam.credentials.v1.IAMCredentials/GenerateIdToken"
	IAMCredentials_SignBlob_FullMethodName            = "/google.iam.credentials.v1.IAMCredentials/SignBlob"
	IAMCredentials_SignJwt_FullMethodName             = "/google.iam.credentials.v1.IAMCredentials/SignJwt"
)

// IAMCredentialsClient is the client API for IAMCredentials service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type IAMCredentialsClient interface {
	// Generates an OAuth 2.0 access token for a service account.
	GenerateAccessToken(ctx context.Context, in *GenerateAccessTokenRequest, opts ...grpc.CallOption) (*GenerateAccessTokenResponse, error)
	// Generates an OpenID Connect ID token for a service account.
	GenerateIdToken(ctx context.Context, in *GenerateIdTokenRequest, opts ...grpc.CallOption) (*GenerateIdTokenResponse, error)
	// Signs a blob using a service account's system-managed private key.
	SignBlob(ctx context.Context, in *SignBlobRequest, opts ...grpc.CallOption) (*SignBlobResponse, error)
	// Signs a JWT using a service account's system-managed private key.
	SignJwt(ctx context.Context, in *SignJwtRequest, opts ...grpc.CallOption) (*SignJwtResponse, error)
}

type iAMCredentialsClient struct {
	cc grpc.ClientConnInterface
}

func NewIAMCredentialsClient(cc grpc.ClientConnInterface) IAMCredentialsClient {
	return &iAMCredentialsClient{cc}
}

func (c *iAMCredentialsClient) GenerateAccessToken(ctx context.Context, in *GenerateAccessTokenRequest, opts ...grpc.CallOption) (*GenerateAccessTokenResponse, error) {
	out := new(GenerateAccessTokenResponse)
	err := c.cc.Invoke(ctx, IAMCredentials_GenerateAccessToken_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMCredentialsClient) GenerateIdToken(ctx context.Context, in *GenerateIdTokenRequest, opts ...grpc.CallOption) (*GenerateIdTokenResponse, error) {
	out := new(GenerateIdTokenResponse)
	err := c.cc.Invoke(ctx, IAMCredentials_GenerateIdToken_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMCredentialsClient) SignBlob(ctx context.Context, in *SignBlobRequest, opts ...grpc.CallOption) (*SignBlobResponse, error) {
	out := new(SignBlobResponse)
	err := c.cc.Invoke(ctx, IAMCredentials_SignBlob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMCredentialsClient) SignJwt(ctx context.Context, in *SignJwtRequest, opts ...grpc.CallOption) (*SignJwtResponse, error) {
	out := new(SignJwtResponse)
	err := c.cc.Invoke(ctx, IAMCredentials_SignJwt_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IAMCredentialsServer is the server API for IAMCredentials service.
// All implementations should embed UnimplementedIAMCredentialsServer
// for forward compatibility
type IAMCredentialsServer interface {
	// Generates an OAuth 2.0 access token for a service account.
	GenerateAccessToken(context.Context, *GenerateAccessTokenRequest) (*GenerateAccessTokenResponse, error)
	// Generates an OpenID Connect ID token for a service account.
	GenerateIdToken(context.Context, *GenerateIdTokenRequest) (*GenerateIdTokenResponse, error)
	// Signs a blob using a service account's system-managed private key.
	SignBlob(context.Context, *SignBlobRequest) (*SignBlobResponse, error)
	// Signs a JWT using a service account's system-managed private key.
	SignJwt(context.Context, *SignJwtRequest) (*SignJwtResponse, error)
}

// UnimplementedIAMCredentialsServer should be embedded to have forward compatible implementations.
type UnimplementedIAMCredentialsServer struct {
}

func (UnimplementedIAMCredentialsServer) GenerateAccessToken(context.Context, *GenerateAccessTokenRequest) (*GenerateAccessTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateAccessToken not implemented")
}
func (UnimplementedIAMCredentialsServer) GenerateIdToken(context.Context, *GenerateIdTokenRequest) (*GenerateIdTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateIdToken not implemented")
}
func (UnimplementedIAMCredentialsServer) SignBlob(context.Context, *SignBlobRequest) (*SignBlobResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SignBlob not implemented")
}
func (UnimplementedIAMCredentialsServer) SignJwt(context.Context, *SignJwtRequest) (*SignJwtResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SignJwt not implemented")
}

// UnsafeIAMCredentialsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to IAMCredentialsServer will
// result in compilation errors.
type UnsafeIAMCredentialsServer interface {
	mustEmbedUnimplementedIAMCredentialsServer()
}

func RegisterIAMCredentialsServer(s grpc.ServiceRegistrar, srv IAMCredentialsServer) {
	s.RegisterService(&IAMCredentials_ServiceDesc, srv)
}

func _IAMCredentials_GenerateAccessToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateAccessTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMCredentialsServer).GenerateAccessToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IAMCredentials_GenerateAccessToken_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMCredentialsServer).GenerateAccessToken(ctx, req.(*GenerateAccessTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMCredentials_GenerateIdToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateIdTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMCredentialsServer).GenerateIdToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IAMCredentials_GenerateIdToken_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMCredentialsServer).GenerateIdToken(ctx, req.(*GenerateIdTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMCredentials_SignBlob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SignBlobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMCredentialsServer).SignBlob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IAMCredentials_SignBlob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMCredentialsServer).SignBlob(ctx, req.(*SignBlobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMCredentials_SignJwt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SignJwtRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMCredentialsServer).SignJwt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IAMCredentials_SignJwt_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMCredentialsServer).SignJwt(ctx, req.(*SignJwtRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// IAMCredentials_ServiceDesc is the grpc.ServiceDesc for IAMCredentials service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var IAMCredentials_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.iam.credentials.v1.IAMCredentials",
	HandlerType: (*IAMCredentialsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GenerateAccessToken",
			Handler:    _IAMCredentials_GenerateAccessToken_Handler,
		},
		{
			MethodName: "GenerateIdToken",
			Handler:    _IAMCredentials_GenerateIdToken_Handler,
		},
		{
			MethodName: "SignBlob",
			Handler:    _IAMCredentials_SignBlob_Handler,
		},
		{
			MethodName: "SignJwt",
			Handler:    _IAMCredentials_SignJwt_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/iam/credentials/v1/iamcredentials.proto",
}
